"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _selectors = require("../../../../utils/selectors");

var _selectors2 = require("../../../../k8s/selectors");

var _utils = require("../../../../utils");

var _models = require("../../../../models");

var _constants = require("../../../../constants");

var _Form = require("../../../Form");

var _strings = require("../strings");

var _constants2 = require("../constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const getVCenterInstanceSecrets = vCenterSecrets => {
  vCenterSecrets = vCenterSecrets || [];
  return [_strings.CONNECT_TO_NEW_INSTANCE, ...vCenterSecrets.map(_selectors.getName)];
};

const areResourcesLoaded = resources => !!resources;

const VCenterInstances = ({
  onChange,
  id,
  value,
  extraProps
}) => {
  const WithResources = extraProps.WithResources,
        basicSettings = extraProps.basicSettings;
  const resourceMap = {
    vCenterSecrets: {
      resource: (0, _utils.getResource)(_models.SecretModel, {
        namespace: (0, _selectors2.settingsValue)(basicSettings, _constants2.NAMESPACE_KEY),
        matchExpressions: [{
          key: _constants.VCENTER_TYPE_LABEL,
          operator: 'Exists'
        }, {
          key: _constants.VCENTER_TEMPORARY_LABEL,
          operator: 'DoesNotExist'
        }]
      })
    }
  };

  const resourceToProps = ({
    vCenterSecrets
  }) => ({
    choices: getVCenterInstanceSecrets(vCenterSecrets),
    disabled: !areResourcesLoaded(vCenterSecrets)
  });

  return _react.default.createElement(WithResources, {
    resourceMap: resourceMap,
    resourceToProps: resourceToProps
  }, _react.default.createElement(_Form.Dropdown, {
    id: id,
    value: value,
    onChange: onChange
  }));
};

VCenterInstances.defaultProps = {
  id: undefined,
  value: undefined
};
VCenterInstances.propTypes = {
  onChange: _propTypes.default.func.isRequired,
  extraProps: _propTypes.default.object.isRequired,
  id: _propTypes.default.string,
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object])
};
var _default = VCenterInstances;
exports.default = _default;