"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultTabRow = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const ResultTabRow = ({
  title,
  content,
  expanded
}) => {
  const resolvedContent = typeof content === 'object' ? JSON.stringify(content, null, 1) : content;
  return _react.default.createElement(_patternflyReact.ExpandCollapse, {
    textExpanded: title,
    textCollapsed: title,
    expanded: expanded
  }, _react.default.createElement("pre", {
    className: "blank-slate-pf-secondary-action kubevirt-create-vm-wizard__result-tab-row"
  }, resolvedContent));
};

exports.ResultTabRow = ResultTabRow;
ResultTabRow.defaultProps = {
  expanded: false
};
ResultTabRow.propTypes = {
  title: _propTypes.default.string.isRequired,
  content: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]).isRequired,
  expanded: _propTypes.default.bool
};