"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultTab = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Loading = require("../../Loading");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const getCreationText = (state, createTemplate) => `Creation of VM ${createTemplate ? 'Template ' : ''}${state}`;

const ResultTab = ({
  isSuccessful,
  isCreateTemplate,
  children
}) => {
  if (isSuccessful == null) {
    return _react.default.createElement(_Loading.Loading, {
      key: "progress",
      text: getCreationText('in progress', isCreateTemplate)
    });
  }

  const state = isSuccessful ? 'was successful' : 'failed';
  const icon = isSuccessful ? 'pficon-ok' : 'pficon-error-circle-o';
  return _react.default.createElement("div", {
    className: "wizard-pf-complete blank-slate-pf",
    key: "success"
  }, _react.default.createElement("div", {
    className: "wizard-pf-success-icon"
  }, _react.default.createElement("span", {
    className: `pficon ${icon}`
  })), _react.default.createElement("h3", {
    className: "blank-slate-pf-main-action"
  }, getCreationText(state, isCreateTemplate)), children);
};

exports.ResultTab = ResultTab;
ResultTab.defaultProps = {
  children: null,
  isSuccessful: null,
  isCreateTemplate: false
};
ResultTab.propTypes = {
  children: _propTypes.default.node,
  isSuccessful: _propTypes.default.bool,
  isCreateTemplate: _propTypes.default.bool
};