"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableFactory = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

var _EditableDraggableTable = _interopRequireDefault(require("./EditableDraggableTable"));

var _constants = require("./constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const onChange = (rows, {
  editing,
  type,
  id
}, onRowUpdate, onRowDeleteOrMove, onRowActivate) => {
  switch (type) {
    case _constants.ON_ACTIVATE:
      onRowActivate(rows);
      break;

    case _constants.ON_CONFIRM:
    case _constants.ON_CANCEL:
    case _constants.ON_CHANGE:
      onRowUpdate(rows, id, editing);
      break;

    case _constants.ON_DELETE:
    case _constants.ON_MOVE:
      onRowDeleteOrMove(rows);
      break;

    default:
      // eslint-disable-next-line
      console.warn(`Unknown type ${type}`);
      break;
  }
};

const TableFactory = props => {
  const actionButtons = props.actionButtons.map(({
    id,
    className,
    onClick,
    disabled,
    text
  }) => _react.default.createElement(_patternflyReact.Button, {
    key: id,
    className: className,
    onClick: onClick,
    id: id,
    disabled: disabled
  }, text));

  const onTableChange = (rows, data) => onChange(rows, data, props.onRowUpdate, props.onRowDeleteOrMove, props.onRowActivate);

  const error = props.error && _react.default.createElement(_patternflyReact.Alert, null, props.error);

  return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_patternflyReact.ButtonGroup, {
    className: "pull-right kubevirt-editable-table-actions"
  }, actionButtons), _react.default.createElement(_EditableDraggableTable.default, {
    columns: props.columns,
    rows: props.rows,
    onChange: onTableChange
  }), error);
};

exports.TableFactory = TableFactory;
TableFactory.defaultProps = {
  error: undefined,
  actionButtons: []
};
TableFactory.propTypes = {
  actionButtons: _propTypes.default.array,
  onRowUpdate: _propTypes.default.func.isRequired,
  onRowDeleteOrMove: _propTypes.default.func.isRequired,
  onRowActivate: _propTypes.default.func.isRequired,
  error: _propTypes.default.string,
  columns: _propTypes.default.array.isRequired,
  rows: _propTypes.default.array.isRequired
};