"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Loading = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const Loading = ({
  text,
  id
}) => _react.default.createElement("div", {
  id: id,
  className: "wizard-pf-process blank-slate-pf",
  key: (0, _utils.prefixedId)(id, 'progress') || 'progress'
}, _react.default.createElement("div", {
  className: "spinner spinner-lg blank-slate-pf-icon"
}), _react.default.createElement("h3", {
  className: "blank-slate-pf-main-action"
}, text));

exports.Loading = Loading;
Loading.propTypes = {
  text: _propTypes.default.string,
  id: _propTypes.default.string
};
Loading.defaultProps = {
  text: 'Loading',
  id: undefined
};