"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextArea = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const TextArea = ({
  id,
  value,
  disabled,
  className,
  defaultValue,
  onChange,
  onBlur
}) => _react.default.createElement(_patternflyReact.FormControl, {
  id: id,
  componentClass: "textarea",
  value: value,
  defaultValue: defaultValue,
  onBlur: (0, _utils.eventValueHandler)(onBlur),
  onChange: (0, _utils.eventValueHandler)(onChange),
  className: className,
  disabled: disabled
});

exports.TextArea = TextArea;
TextArea.defaultProps = {
  value: undefined,
  defaultValue: undefined,
  onChange: _patternflyReact.noop,
  onBlur: _patternflyReact.noop,
  disabled: false,
  className: undefined
};
TextArea.propTypes = {
  id: _propTypes.default.string.isRequired,
  value: _propTypes.default.string,
  defaultValue: _propTypes.default.string,
  onChange: _propTypes.default.func,
  onBlur: _propTypes.default.func,
  disabled: _propTypes.default.bool,
  className: _propTypes.default.string
};