"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloneDialog = void 0;

var _react = _interopRequireDefault(require("react"));

var _lodash = require("lodash");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _patternflyReact = require("patternfly-react");

var _ConfigurationSummary = require("../../ConfigurationSummary");

var _Form = require("../../Form");

var _constants = require("../../Wizard/CreateVmWizard/constants");

var _selectors = require("../../../utils/selectors");

var _validations = require("../../../utils/validations");

var _selectors2 = require("../../../k8s/selectors");

var _clone = require("../../../k8s/clone");

var _Loading = require("../../Loading");

var _constants2 = require("../../../constants");

var _strings = require("../../../utils/strings");

var _getVmStatus = require("../../VmStatus/getVmStatus");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const vmAlreadyExists = (name, namespace, vms) => {
  const exists = vms.some(vm => (0, _selectors.getName)(vm) === name && (0, _selectors.getNamespace)(vm) === namespace);
  return exists ? (0, _validations.getValidationObject)(_strings.VIRTUAL_MACHINE_EXISTS) : null;
};

const getFormFields = (namespaces, vm, persistentVolumeClaims, dataVolumes, virtualMachines) => ({
  [_constants.NAME_KEY]: {
    id: 'vm-name',
    title: 'Name',
    required: true,
    validate: settings => {
      const name = (0, _selectors2.settingsValue)(settings, _constants.NAME_KEY);
      const dnsValidation = (0, _validations.validateDNS1123SubdomainValue)(name);
      return dnsValidation && dnsValidation.type === _constants2.VALIDATION_ERROR_TYPE ? dnsValidation : vmAlreadyExists(name, (0, _selectors2.settingsValue)(settings, _constants.NAMESPACE_KEY), virtualMachines);
    }
  },
  [_constants.DESCRIPTION_KEY]: {
    id: 'vm-description',
    title: 'Description',
    type: _Form.TEXT_AREA
  },
  [_constants.NAMESPACE_KEY]: {
    id: 'namespace-dropdown',
    title: 'Namespace',
    type: _Form.DROPDOWN,
    defaultValue: '--- Select Namespace ---',
    choices: namespaces.map(_selectors.getName),
    required: true
  },
  [_constants.START_VM_KEY]: {
    id: 'start-vm',
    title: 'Start virtual machine on clone',
    type: _Form.CHECKBOX,
    noBottom: true
  },
  configuration: {
    id: 'vm-configuration',
    title: 'Configuration',
    type: _Form.CUSTOM,
    CustomComponent: () => _react.default.createElement(_ConfigurationSummary.ConfigurationSummary, {
      vm: vm,
      persistentVolumeClaims: persistentVolumeClaims,
      dataVolumes: dataVolumes
    })
  }
});

const vmIsRunning = vm => (0, _lodash.get)((0, _getVmStatus.isRunning)(vm), 'status') !== _constants2.VM_STATUS_OFF;

class CloneDialog extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "onFormChange", (formFields, newValue, key, valid) => {
      const newSettings = _objectSpread({}, this.state, {
        [key]: newValue,
        valid
      });

      if (key === _constants.NAMESPACE_KEY) {
        const validation = formFields[_constants.NAME_KEY].validate(newSettings);

        if (validation && validation.message) {
          validation.message = `Name ${validation.message}`;
        }

        newSettings[_constants.NAME_KEY] = _objectSpread({}, newSettings[_constants.NAME_KEY] || {}, {
          validation
        });
      }

      this.setState(newSettings);
    });

    _defineProperty(this, "cloneVm", () => {
      this.setState({
        cloning: true
      });
      (0, _clone.clone)(this.props.k8sCreate, this.props.k8sPatch, this.props.vm, (0, _selectors2.settingsValue)(this.state, _constants.NAME_KEY), (0, _selectors2.settingsValue)(this.state, _constants.NAMESPACE_KEY), (0, _selectors2.settingsValue)(this.state, _constants.DESCRIPTION_KEY), (0, _selectors2.settingsValue)(this.state, _constants.START_VM_KEY), this.props.persistentVolumeClaims, this.props.dataVolumes).then(() => this.props.onClose()).catch(error => this.setState({
        cloning: false,
        error: error.message || 'Error occured, please try again later.'
      }));
    });

    _defineProperty(this, "onErrorDismissed", () => this.setState({
      error: null
    }));

    const initVmName = `${(0, _selectors.getName)(props.vm)}-clone`;
    const initVmNameValidation = vmAlreadyExists(initVmName, (0, _selectors.getNamespace)(props.vm), props.virtualMachines);

    if (initVmNameValidation && initVmNameValidation.message) {
      initVmNameValidation.message = `Name ${initVmNameValidation.message}`;
    }

    this.state = {
      [_constants.NAME_KEY]: {
        value: initVmName,
        validation: initVmNameValidation
      },
      [_constants.DESCRIPTION_KEY]: {
        value: (0, _selectors.getDescription)(props.vm)
      },
      [_constants.NAMESPACE_KEY]: {
        value: (0, _selectors.getNamespace)(props.vm)
      },
      [_constants.START_VM_KEY]: {
        value: false
      },
      valid: !initVmNameValidation,
      cloning: false
    };
  }

  render() {
    const formFields = getFormFields(this.props.namespaces, this.props.vm, this.props.persistentVolumeClaims, this.props.dataVolumes, this.props.virtualMachines);
    const LoadingComponent = this.props.LoadingComponent;
    const footer = this.state.cloning ? _react.default.createElement(LoadingComponent, null) : _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_patternflyReact.Button, {
      bsStyle: "default",
      className: "btn-cancel",
      onClick: this.props.onClose
    }, "Cancel"), _react.default.createElement(_patternflyReact.Button, {
      bsStyle: "primary",
      onClick: this.cloneVm,
      disabled: !this.state.valid
    }, "Clone Virtual Machine"));
    return _react.default.createElement(_patternflyReact.Modal, {
      show: true,
      dialogClassName: "kubevirt-clone-dialog"
    }, _react.default.createElement(_patternflyReact.Modal.Header, null, _react.default.createElement(_patternflyReact.Button, {
      className: "close",
      onClick: this.props.onClose
    }, _react.default.createElement(_patternflyReact.Icon, {
      type: "pf",
      name: "close"
    })), _react.default.createElement(_patternflyReact.Modal.Title, null, "Clone Virtual Machine")), _react.default.createElement(_patternflyReact.Modal.Body, null, _react.default.createElement("div", {
      className: "kubevirt-clone-dialog__content"
    }, vmIsRunning(this.props.vm) && _react.default.createElement(_patternflyReact.Alert, {
      type: "warning"
    }, "The VM ", (0, _selectors.getName)(this.props.vm), " is still running. It will be powered off while cloning."), this.state.error && _react.default.createElement(_patternflyReact.Alert, {
      onDismiss: this.onErrorDismissed
    }, this.state.error), _react.default.createElement(_Form.FormFactory, {
      fields: formFields,
      fieldsValues: this.state,
      onFormChange: (newValue, key, valid) => this.onFormChange(formFields, newValue, key, valid),
      labelSize: 2,
      controlSize: 10
    }))), _react.default.createElement(_patternflyReact.Modal.Footer, null, footer));
  }

}

exports.CloneDialog = CloneDialog;
CloneDialog.propTypes = {
  vm: _propTypes.default.object.isRequired,
  namespaces: _propTypes.default.array.isRequired,
  persistentVolumeClaims: _propTypes.default.array.isRequired,
  LoadingComponent: _propTypes.default.func,
  virtualMachines: _propTypes.default.array.isRequired,
  k8sCreate: _propTypes.default.func.isRequired,
  k8sPatch: _propTypes.default.func.isRequired,
  dataVolumes: _propTypes.default.array.isRequired,
  onClose: _propTypes.default.func.isRequired
};
CloneDialog.defaultProps = {
  LoadingComponent: _Loading.Loading
};