"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VmTemplateDetails = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = require("lodash");

var _patternflyReact = require("patternfly-react");

var _utils = require("../../../utils");

var _models = require("../../../models");

var _constants = require("../../../constants");

var _selectors = require("../../../k8s/selectors");

var _Flavor = require("../Flavor");

var _Description = require("../Description");

var _Loading = require("../../Loading");

var _TemplateSource = require("../../TemplateSource");

var _constants2 = require("../common/constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class VmTemplateDetails extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "setEditing", editing => this.setState({
      editing
    }));

    _defineProperty(this, "onFormChange", (formKey, newValue, key, valid) => this.setState(state => ({
      form: _objectSpread({}, state.form, {
        [formKey]: {
          value: _objectSpread({}, (0, _lodash.get)(state.form[formKey], 'value') || {}, {
            [key]: newValue
          }),
          valid
        }
      })
    })));

    _defineProperty(this, "onLoadError", error => this.setState({
      k8sError: error
    }));

    _defineProperty(this, "updateVmDetails", () => {
      const vmTemplate = this.props.vmTemplate;
      const vm = (0, _selectors.selectVm)(vmTemplate.objects);
      const vmIndex = vmTemplate.objects.indexOf(vm);
      this.setEditing(false);
      const vmTemplatePatch = [];
      const descriptionForm = (0, _selectors.settingsValue)(this.state.form, _constants2.DESCRIPTION_KEY);
      const flavorForm = (0, _selectors.settingsValue)(this.state.form, _constants2.FLAVOR_KEY);
      const descriptionPatch = (0, _utils.getUpdateDescriptionPatch)(vmTemplate, (0, _selectors.settingsValue)(descriptionForm, 'description'));
      vmTemplatePatch.push(...descriptionPatch);
      const flavor = (0, _selectors.settingsValue)(flavorForm, 'flavor');
      let cpu;
      let memory;

      if (flavor !== _constants.CUSTOM_FLAVOR && flavorForm.template) {
        const templateVm = (0, _selectors.selectVm)(flavorForm.template.objects);
        cpu = (0, _utils.getCpu)(templateVm);
        memory = (0, _utils.getMemory)(templateVm);
      } else {
        cpu = (0, _selectors.settingsValue)(flavorForm, 'cpu');
        memory = `${(0, _selectors.settingsValue)(flavorForm, 'memory')}G`;
      }

      if (flavor && cpu && memory) {
        const flavorPatch = (0, _utils.getUpdateFlavorPatch)(vmTemplate, flavor);
        const cpuMemPatch = (0, _utils.getUpdateCpuMemoryPatch)(vm, cpu, memory).map(patch => (0, _utils.addPrefixToPatch)(`/objects/${vmIndex}`, patch));
        vmTemplatePatch.push(...flavorPatch);
        vmTemplatePatch.push(...cpuMemPatch);
      }

      if (vmTemplatePatch.length > 0) {
        this.setState({
          updating: true,
          k8sError: null
        });
        const updatePromise = this.props.k8sPatch(_models.TemplateModel, vmTemplate, vmTemplatePatch);
        updatePromise.then(() => this.setState({
          updating: false
        })).catch(error => this.setState({
          updating: false,
          k8sError: error.message || 'An error occurred. Please try again.'
        }));
      }
    });

    _defineProperty(this, "onErrorDismiss", () => this.setState({
      k8sError: null
    }));

    _defineProperty(this, "isFormValid", () => Object.keys(this.state.form).every(key => this.state.form[key].valid));

    this.state = {
      editing: false,
      updating: false,
      k8sError: null,
      form: {}
    };
  }

  render() {
    const _this$props = this.props,
          vmTemplate = _this$props.vmTemplate,
          dataVolumes = _this$props.dataVolumes,
          NamespaceResourceLink = _this$props.NamespaceResourceLink,
          LoadingComponent = _this$props.LoadingComponent,
          k8sGet = _this$props.k8sGet;
    const id = (0, _utils.getId)(vmTemplate);
    const vm = (0, _selectors.selectVm)(vmTemplate.objects);
    const baseTemplate = (0, _utils.getVmTemplate)(vmTemplate);

    const editButton = _react.default.createElement(_patternflyReact.Button, {
      disabled: this.state.updating,
      onClick: () => this.setEditing(true)
    }, "Edit");

    const cancelSaveButton = _react.default.createElement(_react.Fragment, null, _react.default.createElement(_patternflyReact.Button, {
      onClick: () => this.setEditing(false)
    }, "Cancel"), _react.default.createElement(_patternflyReact.Button, {
      bsStyle: "primary",
      disabled: !this.isFormValid(),
      onClick: this.updateVmDetails
    }, "Save"));

    return _react.default.createElement("div", {
      className: "co-m-pane__body"
    }, _react.default.createElement("h1", {
      className: "co-m-pane__heading"
    }, "Virtual Machine Template Overview", _react.default.createElement("div", null, this.state.editing ? cancelSaveButton : editButton)), this.state.k8sError && _react.default.createElement(_patternflyReact.Alert, {
      onDismiss: this.onErrorDismiss
    }, this.state.k8sError), _react.default.createElement(_patternflyReact.Row, null, _react.default.createElement(_patternflyReact.Col, {
      lg: 4,
      md: 4,
      sm: 4,
      xs: 4,
      id: "name-description-column"
    }, _react.default.createElement("dl", null, _react.default.createElement("dt", null, "Name"), _react.default.createElement("dd", {
      id: (0, _utils.prefixedId)(id, 'name')
    }, vmTemplate.metadata.name), _react.default.createElement("dt", null, "Description"), _react.default.createElement("dd", null, _react.default.createElement("div", {
      className: "kubevirt-vm-template-details__description"
    }, _react.default.createElement(_Description.Description, {
      editing: this.state.editing,
      updating: this.state.updating,
      LoadingComponent: LoadingComponent,
      formValues: (0, _selectors.settingsValue)(this.state.form, _constants2.DESCRIPTION_KEY),
      onFormChange: (newValue, key, valid) => this.onFormChange('description', newValue, key, valid),
      obj: vmTemplate,
      id: (0, _utils.prefixedId)(id, 'description')
    }))))), _react.default.createElement(_patternflyReact.Col, {
      lg: 8,
      md: 8,
      sm: 8,
      xs: 8,
      id: "details-column"
    }, _react.default.createElement(_patternflyReact.Row, null, _react.default.createElement(_patternflyReact.Col, {
      lg: 4,
      md: 4,
      sm: 4,
      xs: 4,
      id: "details-column-1"
    }, _react.default.createElement("dl", null, _react.default.createElement("dt", null, "Operating System"), _react.default.createElement("dd", {
      id: (0, _utils.prefixedId)(id, 'os')
    }, (0, _utils.getOperatingSystemName)(vmTemplate) || (0, _utils.getOperatingSystem)(vmTemplate) || _constants.DASHES), _react.default.createElement("dt", null, "Workload Profile"), _react.default.createElement("dd", {
      id: (0, _utils.prefixedId)(id, 'workload-profile')
    }, (0, _utils.getWorkloadProfile)(vmTemplate) || _constants.DASHES), _react.default.createElement("dt", null, "Base Template"), _react.default.createElement("dd", {
      id: (0, _utils.prefixedId)(id, 'base-template')
    }, baseTemplate ? `${baseTemplate.namespace}/${baseTemplate.name}` : _constants.DASHES))), _react.default.createElement(_patternflyReact.Col, {
      lg: 4,
      md: 4,
      sm: 4,
      xs: 4,
      id: "details-column-2"
    }, _react.default.createElement("dl", null, _react.default.createElement("dt", null, "Source"), _react.default.createElement("dd", null, _react.default.createElement(_TemplateSource.TemplateSource, {
      template: vmTemplate,
      dataVolumes: dataVolumes,
      detailed: true
    })), _react.default.createElement("dt", null, "Namespace"), _react.default.createElement("dd", {
      id: (0, _utils.prefixedId)(id, 'namespace')
    }, NamespaceResourceLink ? _react.default.createElement(NamespaceResourceLink, null) : _constants.DASHES))), _react.default.createElement(_patternflyReact.Col, {
      lg: 4,
      md: 4,
      sm: 4,
      xs: 4,
      id: "details-column-3"
    }, _react.default.createElement("dl", null, _react.default.createElement("dt", null, "Flavor"), _react.default.createElement("dd", null, _react.default.createElement(_Flavor.Flavor, {
      flavor: (0, _utils.getFlavor)(vmTemplate) || _constants.CUSTOM_FLAVOR,
      vm: vm,
      id: id,
      editing: this.state.editing,
      updating: this.state.updating,
      LoadingComponent: LoadingComponent,
      onFormChange: (newValue, key, valid) => this.onFormChange('flavor', newValue, key, valid),
      retrieveVmTemplate: () => (0, _utils.retrieveVmTemplate)(k8sGet, vmTemplate),
      formValues: (0, _selectors.settingsValue)(this.state.form, _constants2.FLAVOR_KEY),
      onLoadError: this.onLoadError
    }))))))));
  }

}

exports.VmTemplateDetails = VmTemplateDetails;
VmTemplateDetails.propTypes = {
  vmTemplate: _propTypes.default.object.isRequired,
  dataVolumes: _propTypes.default.array,
  NamespaceResourceLink: _propTypes.default.func,
  k8sGet: _propTypes.default.func.isRequired,
  k8sPatch: _propTypes.default.func.isRequired,
  LoadingComponent: _propTypes.default.func
};
VmTemplateDetails.defaultProps = {
  dataVolumes: [],
  NamespaceResourceLink: undefined,
  LoadingComponent: _Loading.Loading
};