"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationSummary = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("../../utils");

var _constants = require("../../constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const getNicsDescription = vm => {
  const interfaces = (0, _utils.getInterfaces)(vm);
  return interfaces.map(intface => [intface.name, intface.model, intface.macAddress].filter(i => !!i)).map(intface => _react.default.createElement("div", {
    key: intface[0]
  }, intface.join(' - ')));
};

const getDisksDescription = (vm, pvcs, dataVolumes) => {
  const disks = (0, _utils.getDisks)(vm);
  const volumes = (0, _utils.getVolumes)(vm);
  const dataVolumeTemplates = (0, _utils.getDataVolumeTemplates)(vm);
  return disks.map(disk => {
    const description = [];
    description.push(disk.name);
    const volume = volumes.find(v => v.name === disk.name);
    let size;
    let storageClass;
    let other;

    if (volume.dataVolume) {
      let dataVolume = dataVolumeTemplates.find(dv => (0, _utils.getName)(dv) === volume.dataVolume.name);

      if (!dataVolume) {
        dataVolume = dataVolumes.find(dv => (0, _utils.getName)(dv) === volume.dataVolume.name && (0, _utils.getNamespace)(dv) === (0, _utils.getNamespace)(vm));
      }

      size = (0, _utils.getStorageSize)((0, _utils.getDataVolumeResources)(dataVolume));
      storageClass = (0, _utils.getDataVolumeStorageClassName)(dataVolume);
    } else if (volume.persistentVolumeClaim) {
      const pvc = pvcs.find(p => (0, _utils.getName)(p) === volume.persistentVolumeClaim.claimName);
      size = (0, _utils.getStorageSize)((0, _utils.getPvcResources)(pvc));
      storageClass = (0, _utils.getPvcStorageClassName)(pvc);
    } else if (volume.containerDisk) {
      other = 'container disk';
    } else if (volume.cloudInitNoCloud) {
      other = 'cloud-init disk';
    }

    if (size) {
      description.push(size);
    }

    if (storageClass) {
      description.push(storageClass);
    }

    if (other) {
      description.push(other);
    }

    return _react.default.createElement("div", {
      key: disk.name
    }, description.join(' - '));
  });
};

const getFullFlavorDescription = vm => {
  const flavorDesc = (0, _utils.getFlavorDescription)(vm);

  const flavor = (0, _utils.getFlavor)(vm) || _constants.CUSTOM_FLAVOR;

  if (!flavorDesc) {
    return flavor;
  }

  return `${flavor} - ${flavorDesc}`;
};

const ConfigurationSummary = ({
  vm,
  persistentVolumeClaims,
  dataVolumes
}) => {
  const disks = getDisksDescription(vm, persistentVolumeClaims, dataVolumes);
  const nics = getNicsDescription(vm);
  return _react.default.createElement("dl", {
    className: "kubevirt-configuration-summary"
  }, _react.default.createElement("dt", null, "Operating System"), _react.default.createElement("dd", null, (0, _utils.getOperatingSystemName)(vm) || _constants.DASHES), _react.default.createElement("dt", null, "Flavor"), _react.default.createElement("dd", null, getFullFlavorDescription(vm)), _react.default.createElement("dt", null, "Workload Profile"), _react.default.createElement("dd", null, (0, _utils.getWorkloadProfile)(vm) || _constants.DASHES), _react.default.createElement("dt", null, "NICs"), _react.default.createElement("dd", null, nics.length > 0 ? nics : _constants.DASHES), _react.default.createElement("dt", null, "Disks"), _react.default.createElement("dd", null, disks.length > 0 ? disks : _constants.DASHES));
};

exports.ConfigurationSummary = ConfigurationSummary;
ConfigurationSummary.propTypes = {
  vm: _propTypes.default.object.isRequired,
  persistentVolumeClaims: _propTypes.default.array.isRequired,
  dataVolumes: _propTypes.default.array.isRequired
};