"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CancelAcceptButtons = void 0;

var _react = _interopRequireDefault(require("react"));

var _patternflyReact = require("patternfly-react");

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const CancelAcceptButtons = ({
  onCancel,
  onAccept,
  disabled
}) => _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_patternflyReact.Button, {
  onClick: onCancel,
  className: "kubevirt-cancel-accept-buttons"
}, _react.default.createElement(_patternflyReact.Icon, {
  type: "pf",
  name: "close"
})), _react.default.createElement(_patternflyReact.Button, {
  onClick: onAccept,
  disabled: disabled,
  bsStyle: "primary",
  className: "kubevirt-cancel-accept-buttons"
}, _react.default.createElement(_patternflyReact.Icon, {
  type: "fa",
  name: "check"
})));

exports.CancelAcceptButtons = CancelAcceptButtons;
CancelAcceptButtons.propTypes = {
  onCancel: _propTypes.default.func.isRequired,
  onAccept: _propTypes.default.func.isRequired,
  disabled: _propTypes.default.bool
};
CancelAcceptButtons.defaultProps = {
  disabled: false
};