var slerp = require('./slerp')

module.exports = sqlerp

var temp1 = [0, 0, 0, 1]
var temp2 = [0, 0, 0, 1]

/**
 * Performs a spherical linear interpolation with two control points
 *
 * @param {quat} out the receiving quaternion
 * @param {quat} a the first operand
 * @param {quat} b the second operand
 * @param {quat} c the third operand
 * @param {quat} d the fourth operand
 * @param {Number} t interpolation amount
 * @returns {quat} out
 */
function sqlerp (out, a, b, c, d, t) {
  slerp(temp1, a, d, t)
  slerp(temp2, b, c, t)
  slerp(out, temp1, temp2, 2 * t * (1 - t))

  return out
}
