'use strict'

module.exports = alphaComplex

var delaunay = require('delaunay-triangulate')
var circumradius = require('circumradius')

function alphaComplex(alpha, points) {
  return delaunay(points).filter(function(cell) {
    var simplex = new Array(cell.length)
    for(var i=0; i<cell.length; ++i) {
      simplex[i] = points[cell[i]]
    }
    return circumradius(simplex) * alpha < 1
  })
}