import { getSelectors, getStyles } from './cssUtils';
import { getNodes } from './reactUtils';
import { getInsertedStyles } from '../../../utils';
import { addOverrides } from './cssPropertyOverrides';

export function createSerializer() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$globalCSS = _ref.globalCSS,
      globalCSS = _ref$globalCSS === undefined ? '' : _ref$globalCSS;

  addOverrides();
  function test(val) {
    return val && !val.withStyles && val.$$typeof === Symbol.for('react.test.json');
  }

  function print(val, printer) {
    var nodes = getNodes(val);
    nodes.forEach(function (node) {
      node.withStyles = true;
    });

    var selectors = getSelectors(nodes);
    var styles = getStyles(selectors, getInsertedStyles().join(''), globalCSS);
    var code = printer(val);
    if (styles) {
      return styles + '\n\n' + code;
    }
    return code;
  }

  return {
    test: test,
    print: print
  };
}

export default createSerializer();