var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

/* eslint-disable no-case-declarations */
import { declare } from '@babel/helper-plugin-utils';
import { dirname, extname, resolve } from 'path';
import resolveFrom from 'resolve-from';
import { cssToJS, getCSS, styleSheetToken, packageName, writeCSSJSFile, getRelativeImportPath, getCSSOutputPath } from '../util';
import { StyleSheet } from '../../StyleSheet';

var defaultOptions = {
  extensions: ['.css'],
  srcDir: './src',
  useModules: false
};

export default declare(function (_ref) {
  var t = _ref.types;

  var outputFiles = new Set();

  function getVariableName(path) {
    if (path.node.specifiers && path.node.specifiers[0] && path.node.specifiers[0].local) {
      return path.node.specifiers[0].local.name;
    }
    return null;
  }

  function getLastImportIndex(path) {
    var lastImportIndex = 0;
    path.container.forEach(function (p, i) {
      if (t.isImportDeclaration(p)) {
        lastImportIndex = i;
      }
    });
    return lastImportIndex;
  }

  function getPackageImportIndex(path) {
    return path.container.findIndex(function (p) {
      return t.isImportDeclaration(p) && p.source.value === packageName;
    });
  }

  function createStyleSheetImport(path) {
    return t.importDeclaration([t.importSpecifier(t.identifier('__PF__' + styleSheetToken), t.identifier(styleSheetToken))], t.stringLiteral(packageName));
  }

  function validateReferences(referencePaths, styleObject) {
    var nestedProperties = {
      modifier: 'modifiers'
    };
    referencePaths.forEach(function (rp) {
      if (!t.isMemberExpression(rp.parentPath.node)) {
        return;
      }
      var propName = rp.parentPath.node.property.name;
      if (Object.values(nestedProperties).includes(propName)) {
        var nestedNode = rp.parentPath.parentPath.node;
        if (!t.isMemberExpression(nestedNode)) {
          return;
        }
        var nestedPropertyName = nestedNode.property.name;
        if (!styleObject[propName][nestedPropertyName]) {
          throw rp.buildCodeFrameError(nestedPropertyName + ' is not a valid ' + (propName === nestedProperties.modifier ? 'modifier' : 'property'));
        }
      } else if (!styleObject[propName]) {
        throw rp.buildCodeFrameError(propName + ' does not exist');
      }
    });
  }

  return {
    visitor: {
      ImportDeclaration: function ImportDeclaration(path, _ref2) {
        var file = _ref2.file,
            _ref2$opts = _ref2.opts,
            opts = _ref2$opts === undefined ? {} : _ref2$opts;

        var options = _extends({}, defaultOptions, opts);
        var value = path.node.source.value;

        var ext = extname(value);
        if (options.extensions.includes(ext) && getVariableName(path)) {
          var rootPath = file.opts.sourceRoot || process.cwd();
          var scriptDirectory = dirname(resolve(file.opts.filename));
          var cssfilePath = resolveFrom(scriptDirectory, value);
          var cssString = getCSS(cssfilePath);
          var varName = getVariableName(path);
          var bindings = path.scope.bindings;

          var styleObject = StyleSheet.parse(cssString);

          validateReferences(bindings[varName].referencePaths, styleObject);

          if (!options.outDir) {
            var lastImportIndex = getLastImportIndex(path);
            var pfStylesImportIndex = getPackageImportIndex(path);

            if (pfStylesImportIndex === -1) {
              path.getSibling(lastImportIndex).insertAfter(createStyleSheetImport());
              lastImportIndex++;
              pfStylesImportIndex = lastImportIndex;
            }

            var pfStylesImportPath = path.getSibling(pfStylesImportIndex);
            var styleSheetSpecifier = pfStylesImportPath.node.specifiers.find(function (s) {
              return t.isImportSpecifier(s) && s.imported.name === styleSheetToken;
            });
            if (!styleSheetSpecifier) {
              styleSheetSpecifier = t.importSpecifier(t.identifier('__PF__' + styleSheetToken), t.identifier(styleSheetToken));
              pfStylesImportPath.node.specifiers.push(styleSheetSpecifier);
            }
            var varDeclaration = t.variableDeclaration('const', [t.variableDeclarator(t.identifier(varName), t.callExpression(t.memberExpression(t.identifier(styleSheetSpecifier.local.name), t.identifier('parse')), [t.stringLiteral(cssString)]))]);
            path.getSibling(lastImportIndex).insertAfter(varDeclaration);
            path.remove();
          } else {
            var srcDir = options.srcDir,
                outDir = options.outDir;

            var cssOutputPath = getCSSOutputPath(outDir, rootPath, cssfilePath);

            var scriptOutputPath = resolve(file.opts.filename).replace(resolve(srcDir), outDir);

            if (!outputFiles.has(cssOutputPath)) {
              writeCSSJSFile(rootPath, cssfilePath, cssOutputPath, cssToJS(cssString, options.useModules));
              outputFiles.add(cssOutputPath);
            }

            path.node.source.value = getRelativeImportPath(scriptOutputPath, cssOutputPath);
          }
        }
      }
    }
  };
});