'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _common = require('./common');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var currentId = 0;

var createIcon = function createIcon(iconDefinition) {
  var viewBox = [iconDefinition.xOffset || 0, iconDefinition.yOffset || 0, iconDefinition.width, iconDefinition.height].join(' ');
  var transform = iconDefinition.transform;

  var Icon = function (_React$Component) {
    _inherits(Icon, _React$Component);

    function Icon() {
      var _ref;

      var _temp, _this, _ret;

      _classCallCheck(this, Icon);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Icon.__proto__ || Object.getPrototypeOf(Icon)).call.apply(_ref, [this].concat(args))), _this), _this.id = 'icon-title-' + currentId++, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _createClass(Icon, [{
      key: 'render',
      value: function render() {
        var _props = this.props,
            size = _props.size,
            color = _props.color,
            title = _props.title,
            props = _objectWithoutProperties(_props, ['size', 'color', 'title']);

        var hasTitle = Boolean(title);
        var heightWidth = (0, _common.getSize)(size);
        var baseAlign = -.125 * Number.parseFloat(heightWidth);

        return _react2.default.createElement(
          'svg',
          _extends({
            style: { verticalAlign: baseAlign + 'em' },
            fill: color,
            height: heightWidth,
            width: heightWidth,
            viewBox: viewBox,
            'aria-labelledby': hasTitle ? this.id : null,
            'aria-hidden': hasTitle ? null : true,
            role: 'img'
          }, props),
          hasTitle && _react2.default.createElement(
            'title',
            { id: this.id },
            title
          ),
          _react2.default.createElement('path', { d: iconDefinition.svgPath, transform: transform })
        );
      }
    }]);

    return Icon;
  }(_react2.default.Component);

  Icon.displayName = iconDefinition.name;
  Icon.propTypes = _common.propTypes;
  Icon.defaultProps = _common.defaultProps;


  return Icon;
};

exports.default = createIcon;