'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSize = exports.defaultProps = exports.propTypes = exports.IconSize = undefined;

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var IconSize = exports.IconSize = {
  sm: 'sm',
  md: 'md',
  lg: 'lg',
  xl: 'xl'
};

var propTypes = exports.propTypes = {
  color: _propTypes2.default.string,
  size: _propTypes2.default.oneOf(Object.keys(IconSize)),
  title: _propTypes2.default.string
};

var defaultProps = exports.defaultProps = {
  color: 'currentColor',
  size: IconSize.sm,
  title: null
};

var getSize = exports.getSize = function getSize(size) {
  switch (size) {
    case IconSize.sm:
      return '1em';
    case IconSize.md:
      return '1.5em';
    case IconSize.lg:
      return '2em';
    case IconSize.xl:
      return '3em';
    default:
      return '1em';
  }
};