function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import React from 'react';
import { css } from '@patternfly/react-styles';
import PropTypes from 'prop-types';
import styles from "../../@patternfly/patternfly-next/components/AboutModalBox/about-modal-box.css.js";
import titleStyles from "../../@patternfly/patternfly-next/components/Title/title.css.js";
import Title from '../Title/Title';
var propTypes = {
  /** additional classes added to the button */
  className: PropTypes.string,

  /** Name of the Product */
  productName: PropTypes.string.isRequired,

  /** The Trademark info for the product */
  trademark: PropTypes.string.isRequired,

  /** id to used for Modal Box header */
  id: PropTypes.string.isRequired
};
var defaultProps = {
  className: ''
};

var AboutModalBoxHeader = function AboutModalBoxHeader(_ref) {
  var className = _ref.className,
      productName = _ref.productName,
      trademark = _ref.trademark,
      id = _ref.id,
      props = _objectWithoutProperties(_ref, ["className", "productName", "trademark", "id"]);

  return React.createElement("div", _extends({}, props, {
    className: css(styles.aboutModalBoxHeader, className)
  }), React.createElement("div", {
    className: css(styles.aboutModalBoxHeaderStrapline)
  }, React.createElement("h2", {
    className: css(titleStyles.title)
  }, trademark)), React.createElement(Title, {
    size: "4xl",
    id: id
  }, productName));
};

AboutModalBoxHeader.propTypes = propTypes;
AboutModalBoxHeader.defaultProps = defaultProps;
export default AboutModalBoxHeader;