# Sample Metrics

To understand what metrics are collected by the Telemeter service, we can replicate the request that the Telemeter client makes against a running OpenShift cluster's Prometheus service.
The Telemeter client makes an HTTP GET request to Prometheus' `/federate` endpoint with the [metrics match rules](https://github.com/openshift/telemeter/blob/master/jsonnet/telemeter/metrics.jsonnet) URL encoded as query parameters.

To start, find the URL for the Prometheus service running in the OpenShift cluster:
```shell
$ oc get route prometheus-k8s -n openshift-monitoring -o jsonpath="{.spec.host}"
```

Next, navigate to this URL and run the following query, which will
return the full set of metrics that the Telemeter client captures:

[embedmd]:# (telemeter_query txt)
```txt
{__name__="up"} or {__name__="cluster_version"} or {__name__="cluster_version_available_updates"} or {__name__="cluster_operator_up"} or {__name__="cluster_operator_conditions"} or {__name__="cluster_version_payload"} or {__name__="cluster_version_payload_errors"} or {__name__="instance:etcd_object_counts:sum"} or {__name__="ALERTS",alertstate="firing"} or {__name__="code:apiserver_request_count:rate:sum"} or {__name__="kube_pod_status_ready:etcd:sum"} or {__name__="kube_pod_status_ready:image_registry:sum"} or {__name__="cluster:capacity_cpu_cores:sum"} or {__name__="cluster:capacity_memory_bytes:sum"} or {__name__="cluster:cpu_usage_cores:sum"} or {__name__="cluster:memory_usage_bytes:sum"} or {__name__="openshift:cpu_usage_cores:sum"} or {__name__="openshift:memory_usage_bytes:sum"} or {__name__="cluster:node_instance_type_count:sum"}
```

For reference, here is an example response produced by a running OpenShift cluster:

[embedmd]:# (../test/timeseries.txt)
```txt
# This file was generated using `make test/timeseries.txt`.
# TYPE ALERTS untyped
ALERTS{alertname="Watchdog",alertstate="firing",severity="none",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117550163
ALERTS{alertname="etcdHighNumberOfFailedGRPCRequests",alertstate="firing",grpc_method="Watch",grpc_service="etcdserverpb.Watch",instance="10.0.129.163:9979",job="etcd",severity="critical",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117565353
# TYPE cluster:capacity_cpu_cores:sum untyped
cluster:capacity_cpu_cores:sum{label_beta_kubernetes_io_instance_type="m4.large",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 6 1556117556662
cluster:capacity_cpu_cores:sum{label_beta_kubernetes_io_instance_type="m4.xlarge",label_node_role_kubernetes_io="master",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 12 1556117556662
# TYPE cluster:capacity_memory_bytes:sum untyped
cluster:capacity_memory_bytes:sum{label_beta_kubernetes_io_instance_type="m4.large",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 2.5076420608e+10 1556117556662
cluster:capacity_memory_bytes:sum{label_beta_kubernetes_io_instance_type="m4.xlarge",label_node_role_kubernetes_io="master",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 5.0443563008e+10 1556117556662
# TYPE cluster:cpu_usage_cores:sum untyped
cluster:cpu_usage_cores:sum{instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.9542703756791817 1556117556662
# TYPE cluster:memory_usage_bytes:sum untyped
cluster:memory_usage_bytes:sum{instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.1183669248e+10 1556117556662
# TYPE cluster:node_instance_type_count:sum untyped
cluster:node_instance_type_count:sum{label_beta_kubernetes_io_instance_type="m4.large",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 3 1556117556662
cluster:node_instance_type_count:sum{label_beta_kubernetes_io_instance_type="m4.xlarge",label_node_role_kubernetes_io="master",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 3 1556117556662
# TYPE cluster_operator_conditions untyped
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-samples",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="cloud-credential",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="cluster-autoscaler",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="dns",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="image-registry",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="ingress",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="machine-api",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="machine-config",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="marketplace",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="monitoring",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="network",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="node-tuning",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="authentication",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="operator-lifecycle-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="operator-lifecycle-manager-catalog",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-ca",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-catalog-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-catalog-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Available",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="storage",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="dns",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="machine-config",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="network",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Degraded",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-samples",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="authentication",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="cloud-credential",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="cluster-autoscaler",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="image-registry",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="ingress",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="machine-api",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="marketplace",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="monitoring",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="node-tuning",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="operator-lifecycle-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="operator-lifecycle-manager-catalog",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-ca",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-catalog-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="storage",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="authentication",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="cloud-credential",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="cluster-autoscaler",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="dns",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="image-registry",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="ingress",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="machine-api",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="machine-config",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="marketplace",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="monitoring",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="network",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="node-tuning",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-samples",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="operator-lifecycle-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="operator-lifecycle-manager-catalog",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-ca",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-catalog-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-catalog-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Progressing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="storage",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_conditions{condition="Failing",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-catalog-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
cluster_operator_conditions{condition="Upgradeable",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
# TYPE cluster_operator_up untyped
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="authentication",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="cloud-credential",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="cluster-autoscaler",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="console",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="dns",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="image-registry",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="ingress",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-catalog-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="machine-api",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="machine-config",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="marketplace",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="monitoring",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="network",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="storage",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-controller-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="openshift-samples",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="operator-lifecycle-manager",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="operator-lifecycle-manager-catalog",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-ca",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="service-catalog-apiserver",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="kube-scheduler",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
cluster_operator_up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",name="node-tuning",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
# TYPE cluster_version untyped
cluster_version{endpoint="metrics",image="registry.svc.ci.openshift.org/ocp/release@sha256:358e2f627299d0147f5e940de989af71113e96cc6f9e49aed90c27d6ac5b4645",instance="10.0.150.65:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",type="cluster",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.556116444e+09 1556117576197
cluster_version{endpoint="metrics",image="registry.svc.ci.openshift.org/ocp/release@sha256:358e2f627299d0147f5e940de989af71113e96cc6f9e49aed90c27d6ac5b4645",instance="10.0.150.65:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",type="completed",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.55611734e+09 1556117576197
cluster_version{endpoint="metrics",image="registry.svc.ci.openshift.org/ocp/release@sha256:358e2f627299d0147f5e940de989af71113e96cc6f9e49aed90c27d6ac5b4645",instance="10.0.150.65:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",type="current",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.556055326e+09 1556117576197
# TYPE cluster_version_available_updates untyped
cluster_version_available_updates{channel="stable-4.0",endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",upstream="https://api.openshift.com/api/upgrades_info/v1/graph",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
# TYPE cluster_version_payload untyped
cluster_version_payload{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",type="applied",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 338 1556117576197
cluster_version_payload{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",type="pending",version="4.0.0-0.ci-2019-04-23-215541",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117576197
# TYPE code:apiserver_request_count:rate:sum untyped
code:apiserver_request_count:rate:sum{code="200",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 16.467011166025575 1556117563634
code:apiserver_request_count:rate:sum{code="201",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 5.742843423382546 1556117563634
code:apiserver_request_count:rate:sum{code="403",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117563634
code:apiserver_request_count:rate:sum{code="404",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0.5809820833333333 1556117563634
code:apiserver_request_count:rate:sum{code="409",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0.11688881481481482 1556117563634
code:apiserver_request_count:rate:sum{code="500",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117563634
code:apiserver_request_count:rate:sum{code="503",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 0 1556117563634
# TYPE instance:etcd_object_counts:sum untyped
instance:etcd_object_counts:sum{instance="10.0.129.163:6443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 4704 1556117556662
instance:etcd_object_counts:sum{instance="10.0.150.65:6443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 4895 1556117556662
instance:etcd_object_counts:sum{instance="10.0.162.223:6443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 4871 1556117556662
instance:etcd_object_counts:sum{instance="10.128.0.34:8443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 502 1556117556662
instance:etcd_object_counts:sum{instance="10.129.0.27:8443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 502 1556117556662
instance:etcd_object_counts:sum{instance="10.130.0.41:8443",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 502 1556117556662
# TYPE kube_pod_status_ready:etcd:sum untyped
kube_pod_status_ready:etcd:sum{condition="true",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 3 1556117563634
# TYPE kube_pod_status_ready:image_registry:sum untyped
kube_pod_status_ready:image_registry:sum{condition="true",instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117563634
# TYPE openshift:cpu_usage_cores:sum untyped
openshift:cpu_usage_cores:sum{instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 2.188062852712885 1556117556662
# TYPE openshift:memory_usage_bytes:sum untyped
openshift:memory_usage_bytes:sum{instance="",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1.4340767744e+10 1556117556662
# TYPE up untyped
up{endpoint="https",instance="10.0.162.223:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-7rx66",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117562418
up{endpoint="crio",instance="10.0.129.163:9537",job="crio",namespace="kube-system",node="ip-10-0-129-163.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117553503
up{endpoint="crio",instance="10.0.141.142:9537",job="crio",namespace="kube-system",node="ip-10-0-141-142.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117552917
up{endpoint="crio",instance="10.0.145.119:9537",job="crio",namespace="kube-system",node="ip-10-0-145-119.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117562521
up{endpoint="crio",instance="10.0.150.65:9537",job="crio",namespace="kube-system",node="ip-10-0-150-65.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117558467
up{endpoint="crio",instance="10.0.162.223:9537",job="crio",namespace="kube-system",node="ip-10-0-162-223.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117574535
up{endpoint="crio",instance="10.0.172.71:9537",job="crio",namespace="kube-system",node="ip-10-0-172-71.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117558742
up{endpoint="etcd-metrics",instance="10.0.129.163:9979",job="etcd",namespace="kube-system",pod="etcd-member-ip-10-0-129-163.ec2.internal",service="etcd",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117554232
up{endpoint="etcd-metrics",instance="10.0.150.65:9979",job="etcd",namespace="kube-system",pod="etcd-member-ip-10-0-150-65.ec2.internal",service="etcd",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117573369
up{endpoint="etcd-metrics",instance="10.0.162.223:9979",job="etcd",namespace="kube-system",pod="etcd-member-ip-10-0-162-223.ec2.internal",service="etcd",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117577911
up{endpoint="http",instance="10.129.0.21:8080",job="cluster-monitoring-operator",namespace="openshift-monitoring",pod="cluster-monitoring-operator-868797c988-4h2kt",service="cluster-monitoring-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117567256
up{endpoint="http",instance="10.129.2.9:8080",job="prometheus-operator",namespace="openshift-monitoring",pod="prometheus-operator-6c6ff98cfb-5rsww",service="prometheus-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117574842
up{endpoint="https",instance="10.0.129.163:10257",job="kube-controller-manager",namespace="openshift-kube-controller-manager",pod="kube-controller-manager-ip-10-0-129-163.ec2.internal",service="kube-controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117563518
up{endpoint="https",instance="10.0.129.163:10259",job="scheduler",namespace="openshift-kube-scheduler",pod="openshift-kube-scheduler-ip-10-0-129-163.ec2.internal",service="scheduler",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117565289
up{endpoint="https",instance="10.0.129.163:6443",job="apiserver",namespace="default",service="kubernetes",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576186
up{endpoint="https",instance="10.0.129.163:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-jljzq",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117559239
up{endpoint="https",instance="10.0.141.142:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-wf7sk",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117563368
up{endpoint="https",instance="10.0.145.119:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-mw6gh",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117571243
up{endpoint="https",instance="10.0.150.65:10257",job="kube-controller-manager",namespace="openshift-kube-controller-manager",pod="kube-controller-manager-ip-10-0-150-65.ec2.internal",service="kube-controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117563665
up{endpoint="https",instance="10.0.150.65:10259",job="scheduler",namespace="openshift-kube-scheduler",pod="openshift-kube-scheduler-ip-10-0-150-65.ec2.internal",service="scheduler",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117555756
up{endpoint="https",instance="10.0.150.65:6443",job="apiserver",namespace="default",service="kubernetes",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117578704
up{endpoint="https",instance="10.0.150.65:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-8bz9l",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117551236
up{endpoint="https",instance="10.0.162.223:10257",job="kube-controller-manager",namespace="openshift-kube-controller-manager",pod="kube-controller-manager-ip-10-0-162-223.ec2.internal",service="kube-controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117566113
up{endpoint="https",instance="10.0.162.223:10259",job="scheduler",namespace="openshift-kube-scheduler",pod="openshift-kube-scheduler-ip-10-0-162-223.ec2.internal",service="scheduler",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117557201
up{endpoint="https",instance="10.0.162.223:6443",job="apiserver",namespace="default",service="kubernetes",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117571988
up{endpoint="5000-tcp",instance="10.128.2.6:5000",job="image-registry",namespace="openshift-image-registry",pod="image-registry-9c9cc6d74-85xqn",service="image-registry",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117564395
up{endpoint="https",instance="10.0.172.71:9100",job="node-exporter",namespace="openshift-monitoring",pod="node-exporter-dppg8",service="node-exporter",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117572120
up{endpoint="https",instance="10.128.0.12:8443",job="metrics",namespace="openshift-service-catalog-controller-manager-operator",pod="openshift-service-catalog-controller-manager-operator-7449v7dls",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117564116
up{endpoint="https",instance="10.128.0.25:6443",job="integrated-oauth-server",namespace="openshift-authentication",pod="integrated-oauth-server-6c7f759865-9x62j",service="integrated-oauth-server",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117550701
up{endpoint="https",instance="10.128.0.27:8443",job="controller-manager",namespace="openshift-controller-manager",pod="controller-manager-98vv2",service="controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117553534
up{endpoint="https",instance="10.128.0.34:8443",job="api",namespace="openshift-apiserver",pod="apiserver-7q96q",service="api",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117563446
up{endpoint="https",instance="10.129.0.18:8443",job="metrics",namespace="openshift-authentication-operator",pod="authentication-operator-7c65c69768-8qh5n",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117561655
up{endpoint="https",instance="10.129.0.27:8443",job="api",namespace="openshift-apiserver",pod="apiserver-5sxmv",service="api",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117561303
up{endpoint="https",instance="10.129.0.28:6443",job="integrated-oauth-server",namespace="openshift-authentication",pod="integrated-oauth-server-6c7f759865-htr7c",service="integrated-oauth-server",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117572403
up{endpoint="https",instance="10.129.0.32:8443",job="controller-manager",namespace="openshift-controller-manager",pod="controller-manager-2trb6",service="controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117562378
up{endpoint="https",instance="10.129.2.5:8443",job="telemeter-client",namespace="openshift-monitoring",pod="telemeter-client-6847984c5b-8dtqt",service="telemeter-client",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117574528
up{endpoint="https",instance="10.130.0.2:8443",job="metrics",namespace="openshift-controller-manager-operator",pod="openshift-controller-manager-operator-fcb4fd55c-949jb",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117574028
up{endpoint="https",instance="10.130.0.39:8443",job="controller-manager",namespace="openshift-controller-manager",pod="controller-manager-ztm7z",service="controller-manager",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117561340
up{endpoint="https",instance="10.130.0.3:8443",job="metrics",namespace="openshift-kube-apiserver-operator",pod="kube-apiserver-operator-6cb6b7dc48-jqp8g",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117560705
up{endpoint="https",instance="10.130.0.41:8443",job="api",namespace="openshift-apiserver",pod="apiserver-mbb2l",service="api",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117551364
up{endpoint="https",instance="10.130.0.4:8443",job="metrics",namespace="openshift-kube-controller-manager-operator",pod="kube-controller-manager-operator-76c467956-pgs6r",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117563307
up{endpoint="https",instance="10.130.0.6:8443",job="metrics",namespace="openshift-apiserver-operator",pod="openshift-apiserver-operator-7b9859b7cd-ltqlw",service="metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117551642
up{endpoint="https",instance="10.131.0.9:3000",job="grafana",namespace="openshift-monitoring",pod="grafana-69dfd75f-rpd2c",service="grafana",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117553880
up{endpoint="https-main",instance="10.129.2.4:8443",job="kube-state-metrics",namespace="openshift-monitoring",pod="kube-state-metrics-86c7cf9c79-snqd7",service="kube-state-metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117490048
up{endpoint="https-metrics",instance="10.0.129.163:10250",job="kubelet",namespace="kube-system",node="ip-10-0-129-163.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117575333
up{endpoint="https-metrics",instance="10.0.141.142:10250",job="kubelet",namespace="kube-system",node="ip-10-0-141-142.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117574383
up{endpoint="https-metrics",instance="10.0.145.119:10250",job="kubelet",namespace="kube-system",node="ip-10-0-145-119.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117568476
up{endpoint="https-metrics",instance="10.0.150.65:10250",job="kubelet",namespace="kube-system",node="ip-10-0-150-65.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117573874
up{endpoint="https-metrics",instance="10.0.162.223:10250",job="kubelet",namespace="kube-system",node="ip-10-0-162-223.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117552271
up{endpoint="https-metrics",instance="10.0.172.71:10250",job="kubelet",namespace="kube-system",node="ip-10-0-172-71.ec2.internal",service="kubelet",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117568065
up{endpoint="https-metrics",instance="10.130.0.23:8081",job="catalog-operator-metrics",namespace="openshift-operator-lifecycle-manager",pod="catalog-operator-688768d648-phfsm",service="catalog-operator-metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117553702
up{endpoint="https-metrics",instance="10.130.0.24:8081",job="olm-operator-metrics",namespace="openshift-operator-lifecycle-manager",pod="olm-operator-6f5f9688f5-5564g",service="olm-operator-metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117551429
up{endpoint="https-self",instance="10.129.2.4:9443",job="kube-state-metrics",namespace="openshift-monitoring",pod="kube-state-metrics-86c7cf9c79-snqd7",service="kube-state-metrics",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117503078
up{endpoint="metrics",instance="10.0.129.163:9101",job="sdn",namespace="openshift-sdn",pod="sdn-m2t7d",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117575700
up{endpoint="metrics",instance="10.0.141.142:9101",job="sdn",namespace="openshift-sdn",pod="sdn-j6gzl",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117567707
up{endpoint="metrics",instance="10.0.145.119:9101",job="sdn",namespace="openshift-sdn",pod="sdn-nstds",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117554607
up{endpoint="metrics",instance="10.0.150.65:9099",job="cluster-version-operator",namespace="openshift-cluster-version",pod="cluster-version-operator-9c7cf48d5-x28gm",service="cluster-version-operator",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117576197
up{endpoint="metrics",instance="10.0.150.65:9101",job="sdn",namespace="openshift-sdn",pod="sdn-hggrx",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117573368
up{endpoint="metrics",instance="10.0.162.223:9101",job="sdn",namespace="openshift-sdn",pod="sdn-jttz7",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117571924
up{endpoint="metrics",instance="10.0.172.71:9101",job="sdn",namespace="openshift-sdn",pod="sdn-m4m7v",service="sdn",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117561166
up{endpoint="metrics",instance="10.128.0.2:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-bdwfk",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117570550
up{endpoint="metrics",instance="10.128.2.2:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-5s9hp",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117553099
up{endpoint="metrics",instance="10.129.0.5:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-bgg4l",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117568278
up{endpoint="metrics",instance="10.129.2.2:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-ttr4q",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117554075
up{endpoint="metrics",instance="10.129.2.7:1936",job="router-internal-default",namespace="openshift-ingress",pod="router-default-5cdcb6b849-vddvc",service="router-internal-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117578232
up{endpoint="metrics",instance="10.130.0.11:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-fffwj",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117572679
up{endpoint="metrics",instance="10.131.0.2:9153",job="dns-default",namespace="openshift-dns",pod="dns-default-xgrzc",service="dns-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117572610
up{endpoint="metrics",instance="10.131.0.6:1936",job="router-internal-default",namespace="openshift-ingress",pod="router-default-5cdcb6b849-x5mjh",service="router-internal-default",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117567425
up{endpoint="web",instance="10.128.2.10:9091",job="prometheus-k8s",namespace="openshift-monitoring",pod="prometheus-k8s-0",service="prometheus-k8s",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117566467
up{endpoint="web",instance="10.128.2.9:9094",job="alertmanager-main",namespace="openshift-monitoring",pod="alertmanager-main-0",service="alertmanager-main",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117549520
up{endpoint="web",instance="10.129.2.10:9091",job="prometheus-k8s",namespace="openshift-monitoring",pod="prometheus-k8s-1",service="prometheus-k8s",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117572727
up{endpoint="web",instance="10.129.2.8:9094",job="alertmanager-main",namespace="openshift-monitoring",pod="alertmanager-main-2",service="alertmanager-main",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117550260
up{endpoint="web",instance="10.131.0.10:9094",job="alertmanager-main",namespace="openshift-monitoring",pod="alertmanager-main-1",service="alertmanager-main",prometheus="openshift-monitoring/k8s",prometheus_replica="prometheus-k8s-0"} 1 1556117549055
```
