# Questions and answers

The goal of this file is to have a place to easily commit answers to questions
in a way that's easily searchable, and can make its way into official
documentation later.

## Q: When I customize the Ignition generated by the installer, how does the MCO handle that?

This is a supported operation.  Today, the MCO does not have good support for "per node"
configuration, and configuring things like static IP addresses and partition layouts
by customizing the Ignition makes sense.

However, it's important to understand that these custom changes are "invisible" to the
MCO today - they won't show up in `oc get machineconfig`.  And hence it's not
as straightforward to make any "day 2" changes to them.

In the future, it's likely the MCO will gain better support for per-node configuration
as well as tools to more easily manipulate Ignition, so there is less need to edit the
Ignition JSON directly.

## Q: Why are my workers showing older versions of RHCOS?

Today, the MCO only blocks on upgrades of control plane nodes.  `oc get clusterversion` effectively reports the version of the control plane. 

To watch rollout of worker nodes, you should look at `oc describe machineconfigpool/worker` (as well as other custom pools, if any).
