// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	configv1 "github.com/openshift/api/config/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeSchedulers implements SchedulerInterface
type FakeSchedulers struct {
	Fake *FakeConfigV1
}

var schedulersResource = schema.GroupVersionResource{Group: "config.openshift.io", Version: "v1", Resource: "schedulers"}

var schedulersKind = schema.GroupVersionKind{Group: "config.openshift.io", Version: "v1", Kind: "Scheduler"}

// Get takes name of the scheduler, and returns the corresponding scheduler object, and an error if there is any.
func (c *FakeSchedulers) Get(name string, options v1.GetOptions) (result *configv1.Scheduler, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(schedulersResource, name), &configv1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.Scheduler), err
}

// List takes label and field selectors, and returns the list of Schedulers that match those selectors.
func (c *FakeSchedulers) List(opts v1.ListOptions) (result *configv1.SchedulerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(schedulersResource, schedulersKind, opts), &configv1.SchedulerList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &configv1.SchedulerList{ListMeta: obj.(*configv1.SchedulerList).ListMeta}
	for _, item := range obj.(*configv1.SchedulerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested schedulers.
func (c *FakeSchedulers) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(schedulersResource, opts))
}

// Create takes the representation of a scheduler and creates it.  Returns the server's representation of the scheduler, and an error, if there is any.
func (c *FakeSchedulers) Create(scheduler *configv1.Scheduler) (result *configv1.Scheduler, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(schedulersResource, scheduler), &configv1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.Scheduler), err
}

// Update takes the representation of a scheduler and updates it. Returns the server's representation of the scheduler, and an error, if there is any.
func (c *FakeSchedulers) Update(scheduler *configv1.Scheduler) (result *configv1.Scheduler, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(schedulersResource, scheduler), &configv1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.Scheduler), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSchedulers) UpdateStatus(scheduler *configv1.Scheduler) (*configv1.Scheduler, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(schedulersResource, "status", scheduler), &configv1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.Scheduler), err
}

// Delete takes name of the scheduler and deletes it. Returns an error if one occurs.
func (c *FakeSchedulers) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(schedulersResource, name), &configv1.Scheduler{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSchedulers) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(schedulersResource, listOptions)

	_, err := c.Fake.Invokes(action, &configv1.SchedulerList{})
	return err
}

// Patch applies the patch and returns the patched scheduler.
func (c *FakeSchedulers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *configv1.Scheduler, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(schedulersResource, name, pt, data, subresources...), &configv1.Scheduler{})
	if obj == nil {
		return nil, err
	}
	return obj.(*configv1.Scheduler), err
}
