#!/usr/bin/env bash

#  Copyright 2018 The Kubernetes Authors.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

set -e

# Enable tracing in this script off by setting the TRACE variable in your
# environment to any value:
#
# $ TRACE=1 test.sh
TRACE=${TRACE:-""}
if [ -n "$TRACE" ]; then
  set -x
fi

# check if modules are enabled
(go mod edit -json &>/dev/null)
MODULES_ENABLED=$?

MOD_OPT=""
MODULES_OPT=${MODULES_OPT:-""}
if [[ -n "${MODULES_OPT}" && $MODULES_ENABLED ]]; then
    MOD_OPT="-mod=${MODULES_OPT}"
fi

# Turn colors in this script off by setting the NO_COLOR variable in your
# environment to any value:
#
# $ NO_COLOR=1 test.sh
NO_COLOR=${NO_COLOR:-""}
if [ -z "$NO_COLOR" ]; then
  header=$'\e[1;33m'
  reset=$'\e[0m'
else
  header=''
  reset=''
fi

function header_text {
  echo "$header$*$reset"
}

function setup_envs {
  header_text "setting up env vars"

  # Setup env vars
  if [[ -z "${KUBEBUILDER_ASSETS}" ]]; then
      export KUBEBUILDER_ASSETS=$kb_root_dir/bin
  fi
}
