/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/ptp-operator/pkg/apis/ptp/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// NodePtpDeviceLister helps list NodePtpDevices.
type NodePtpDeviceLister interface {
	// List lists all NodePtpDevices in the indexer.
	List(selector labels.Selector) (ret []*v1.NodePtpDevice, err error)
	// NodePtpDevices returns an object that can list and get NodePtpDevices.
	NodePtpDevices(namespace string) NodePtpDeviceNamespaceLister
	NodePtpDeviceListerExpansion
}

// nodePtpDeviceLister implements the NodePtpDeviceLister interface.
type nodePtpDeviceLister struct {
	indexer cache.Indexer
}

// NewNodePtpDeviceLister returns a new NodePtpDeviceLister.
func NewNodePtpDeviceLister(indexer cache.Indexer) NodePtpDeviceLister {
	return &nodePtpDeviceLister{indexer: indexer}
}

// List lists all NodePtpDevices in the indexer.
func (s *nodePtpDeviceLister) List(selector labels.Selector) (ret []*v1.NodePtpDevice, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.NodePtpDevice))
	})
	return ret, err
}

// NodePtpDevices returns an object that can list and get NodePtpDevices.
func (s *nodePtpDeviceLister) NodePtpDevices(namespace string) NodePtpDeviceNamespaceLister {
	return nodePtpDeviceNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// NodePtpDeviceNamespaceLister helps list and get NodePtpDevices.
type NodePtpDeviceNamespaceLister interface {
	// List lists all NodePtpDevices in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.NodePtpDevice, err error)
	// Get retrieves the NodePtpDevice from the indexer for a given namespace and name.
	Get(name string) (*v1.NodePtpDevice, error)
	NodePtpDeviceNamespaceListerExpansion
}

// nodePtpDeviceNamespaceLister implements the NodePtpDeviceNamespaceLister
// interface.
type nodePtpDeviceNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all NodePtpDevices in the indexer for a given namespace.
func (s nodePtpDeviceNamespaceLister) List(selector labels.Selector) (ret []*v1.NodePtpDevice, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.NodePtpDevice))
	})
	return ret, err
}

// Get retrieves the NodePtpDevice from the indexer for a given namespace and name.
func (s nodePtpDeviceNamespaceLister) Get(name string) (*v1.NodePtpDevice, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("nodeptpdevice"), name)
	}
	return obj.(*v1.NodePtpDevice), nil
}
