/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1

import (
	time "time"

	ptpv1 "github.com/openshift/ptp-operator/pkg/apis/ptp/v1"
	versioned "github.com/openshift/ptp-operator/pkg/client/clientset/versioned"
	internalinterfaces "github.com/openshift/ptp-operator/pkg/client/informers/externalversions/internalinterfaces"
	v1 "github.com/openshift/ptp-operator/pkg/client/listers/ptp/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// NodePtpDeviceInformer provides access to a shared informer and lister for
// NodePtpDevices.
type NodePtpDeviceInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1.NodePtpDeviceLister
}

type nodePtpDeviceInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewNodePtpDeviceInformer constructs a new informer for NodePtpDevice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewNodePtpDeviceInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredNodePtpDeviceInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredNodePtpDeviceInformer constructs a new informer for NodePtpDevice type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredNodePtpDeviceInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options metav1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.PtpV1().NodePtpDevices(namespace).List(options)
			},
			WatchFunc: func(options metav1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.PtpV1().NodePtpDevices(namespace).Watch(options)
			},
		},
		&ptpv1.NodePtpDevice{},
		resyncPeriod,
		indexers,
	)
}

func (f *nodePtpDeviceInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredNodePtpDeviceInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *nodePtpDeviceInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&ptpv1.NodePtpDevice{}, f.defaultInformer)
}

func (f *nodePtpDeviceInformer) Lister() v1.NodePtpDeviceLister {
	return v1.NewNodePtpDeviceLister(f.Informer().GetIndexer())
}
