// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/samples/v1"
	"github.com/openshift/cluster-samples-operator/pkg/generated/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type SamplesV1Interface interface {
	RESTClient() rest.Interface
	ConfigsGetter
}

// SamplesV1Client is used to interact with features provided by the samples.operator.openshift.io group.
type SamplesV1Client struct {
	restClient rest.Interface
}

func (c *SamplesV1Client) Configs() ConfigInterface {
	return newConfigs(c)
}

// NewForConfig creates a new SamplesV1Client for the given config.
func NewForConfig(c *rest.Config) (*SamplesV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &SamplesV1Client{client}, nil
}

// NewForConfigOrDie creates a new SamplesV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *SamplesV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new SamplesV1Client for the given RESTClient.
func New(c rest.Interface) *SamplesV1Client {
	return &SamplesV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *SamplesV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
