// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

/*
Package instance is a generated protocol buffer package.

It is generated from these files:
	google/spanner/admin/instance/v1/spanner_instance_admin.proto

It has these top-level messages:
	InstanceConfig
	Instance
	ListInstanceConfigsRequest
	ListInstanceConfigsResponse
	GetInstanceConfigRequest
	GetInstanceRequest
	CreateInstanceRequest
	ListInstancesRequest
	ListInstancesResponse
	UpdateInstanceRequest
	DeleteInstanceRequest
	CreateInstanceMetadata
	UpdateInstanceMetadata
*/
package instance

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_iam_v11 "google.golang.org/genproto/googleapis/iam/v1"
import google_iam_v1 "google.golang.org/genproto/googleapis/iam/v1"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Indicates the current state of the instance.
type Instance_State int32

const (
	// Not specified.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// The instance is still being created. Resources may not be
	// available yet, and operations such as database creation may not
	// work.
	Instance_CREATING Instance_State = 1
	// The instance is fully created and ready to do work such as
	// creating databases.
	Instance_READY Instance_State = 2
)

var Instance_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
}
var Instance_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}
func (Instance_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 0} }

// A possible configuration for a Cloud Spanner instance. Configurations
// define the geographic placement of nodes and their replication.
type InstanceConfig struct {
	// A unique identifier for the instance configuration.  Values
	// are of the form
	// `projects/<project>/instanceConfigs/[a-z][-a-z0-9]*`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of this instance configuration as it appears in UIs.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (m *InstanceConfig) Reset()                    { *m = InstanceConfig{} }
func (m *InstanceConfig) String() string            { return proto.CompactTextString(m) }
func (*InstanceConfig) ProtoMessage()               {}
func (*InstanceConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *InstanceConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstanceConfig) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// An isolated set of Cloud Spanner resources on which databases can be hosted.
type Instance struct {
	// Required. A unique identifier for the instance, which cannot be changed
	// after the instance is created. Values are of the form
	// `projects/<project>/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
	// segment of the name must be between 6 and 30 characters in length.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. The name of the instance's configuration. Values are of the form
	// `projects/<project>/instanceConfigs/<configuration>`. See
	// also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
	Config string `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
	// Required. The descriptive name for this instance as it appears in UIs.
	// Must be unique per project and between 4 and 30 characters in length.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Required. The number of nodes allocated to this instance.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount" json:"node_count,omitempty"`
	// Output only. The current instance state. For
	// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance], the state must be
	// either omitted or set to `CREATING`. For
	// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance], the state must be
	// either omitted or set to `READY`.
	State Instance_State `protobuf:"varint,6,opt,name=state,enum=google.spanner.admin.instance.v1.Instance_State" json:"state,omitempty"`
	// Cloud Labels are a flexible and lightweight mechanism for organizing cloud
	// resources into groups that reflect a customer's organizational needs and
	// deployment strategies. Cloud Labels can be used to filter collections of
	// resources. They can be used to control how resource metrics are aggregated.
	// And they can be used as arguments to policy management rules (e.g. route,
	// firewall, load balancing, etc.).
	//
	//  * Label keys must be between 1 and 63 characters long and must conform to
	//    the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//  * Label values must be between 0 and 63 characters long and must conform
	//    to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//  * No more than 64 labels can be associated with a given resource.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	//
	// If you plan to use labels in your own code, please note that additional
	// characters may be allowed in the future. And so you are advised to use an
	// internal label representation, such as JSON, which doesn't rely upon
	// specific characters being disallowed.  For example, representing labels
	// as the string:  name + "_" + value  would prove problematic if we were to
	// allow "_" in a future release.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Instance) Reset()                    { *m = Instance{} }
func (m *Instance) String() string            { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()               {}
func (*Instance) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetConfig() string {
	if m != nil {
		return m.Config
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// The request for [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
type ListInstanceConfigsRequest struct {
	// Required. The name of the project for which a list of supported instance
	// configurations is requested. Values are of the form
	// `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Number of instance configurations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstanceConfigsResponse.next_page_token]
	// from a previous [ListInstanceConfigsResponse][google.spanner.admin.instance.v1.ListInstanceConfigsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListInstanceConfigsRequest) Reset()                    { *m = ListInstanceConfigsRequest{} }
func (m *ListInstanceConfigsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListInstanceConfigsRequest) ProtoMessage()               {}
func (*ListInstanceConfigsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ListInstanceConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstanceConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstanceConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
type ListInstanceConfigsResponse struct {
	// The list of requested instance configurations.
	InstanceConfigs []*InstanceConfig `protobuf:"bytes,1,rep,name=instance_configs,json=instanceConfigs" json:"instance_configs,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs] call to
	// fetch more of the matching instance configurations.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListInstanceConfigsResponse) Reset()                    { *m = ListInstanceConfigsResponse{} }
func (m *ListInstanceConfigsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListInstanceConfigsResponse) ProtoMessage()               {}
func (*ListInstanceConfigsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListInstanceConfigsResponse) GetInstanceConfigs() []*InstanceConfig {
	if m != nil {
		return m.InstanceConfigs
	}
	return nil
}

func (m *ListInstanceConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for
// [GetInstanceConfigRequest][google.spanner.admin.instance.v1.InstanceAdmin.GetInstanceConfig].
type GetInstanceConfigRequest struct {
	// Required. The name of the requested instance configuration. Values are of
	// the form `projects/<project>/instanceConfigs/<config>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetInstanceConfigRequest) Reset()                    { *m = GetInstanceConfigRequest{} }
func (m *GetInstanceConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetInstanceConfigRequest) ProtoMessage()               {}
func (*GetInstanceConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *GetInstanceConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [GetInstance][google.spanner.admin.instance.v1.InstanceAdmin.GetInstance].
type GetInstanceRequest struct {
	// Required. The name of the requested instance. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetInstanceRequest) Reset()                    { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()               {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance].
type CreateInstanceRequest struct {
	// Required. The name of the project in which to create the instance. Values
	// are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The ID of the instance to create.  Valid identifiers are of the
	// form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 6 and 30 characters in
	// length.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId" json:"instance_id,omitempty"`
	// Required. The instance to create.  The name may be omitted, but if
	// specified must be `<parent>/instances/<instance_id>`.
	Instance *Instance `protobuf:"bytes,3,opt,name=instance" json:"instance,omitempty"`
}

func (m *CreateInstanceRequest) Reset()                    { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()               {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// The request for [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances].
type ListInstancesRequest struct {
	// Required. The name of the project for which a list of instances is
	// requested. Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Number of instances to be returned in the response. If 0 or less, defaults
	// to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstancesResponse.next_page_token] from a
	// previous [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// An expression for filtering the results of the request. Filter rules are
	// case insensitive. The fields eligible for filtering are:
	//
	//   * name
	//   * display_name
	//   * labels.key where key is the name of a label
	//
	// Some examples of using filters are:
	//
	//   * name:* --> The instance has a name.
	//   * name:Howl --> The instance's name contains the string "howl".
	//   * name:HOWL --> Equivalent to above.
	//   * NAME:howl --> Equivalent to above.
	//   * labels.env:* --> The instance has the label "env".
	//   * labels.env:dev --> The instance has the label "env" and the value of
	//                        the label contains the string "dev".
	//   * name:howl labels.env:dev --> The instance's name contains "howl" and
	//                                  it has the label "env" with its value
	//                                  containing "dev".
	Filter string `protobuf:"bytes,4,opt,name=filter" json:"filter,omitempty"`
}

func (m *ListInstancesRequest) Reset()                    { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()               {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInstancesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// The response for [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances].
type ListInstancesResponse struct {
	// The list of requested instances.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances] call to fetch more
	// of the matching instances.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListInstancesResponse) Reset()                    { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()               {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance].
type UpdateInstanceRequest struct {
	// Required. The instance to update, which must always include the instance
	// name.  Otherwise, only fields mentioned in [][google.spanner.admin.instance.v1.UpdateInstanceRequest.field_mask] need be included.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance" json:"instance,omitempty"`
	// Required. A mask specifying which fields in [][google.spanner.admin.instance.v1.UpdateInstanceRequest.instance] should be updated.
	// The field mask must always be specified; this prevents any future fields in
	// [][google.spanner.admin.instance.v1.Instance] from being erased accidentally by clients that do not know
	// about them.
	FieldMask *google_protobuf3.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask" json:"field_mask,omitempty"`
}

func (m *UpdateInstanceRequest) Reset()                    { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()               {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *UpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *UpdateInstanceRequest) GetFieldMask() *google_protobuf3.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

// The request for [DeleteInstance][google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstance].
type DeleteInstanceRequest struct {
	// Required. The name of the instance to be deleted. Values are of the form
	// `projects/<project>/instances/<instance>`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteInstanceRequest) Reset()                    { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()               {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Metadata type for the operation returned by
// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance].
type CreateInstanceMetadata struct {
	// The instance being created.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance" json:"instance,omitempty"`
	// The time at which the
	// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance] request was
	// received.
	StartTime *google_protobuf4.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *google_protobuf4.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *google_protobuf4.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
}

func (m *CreateInstanceMetadata) Reset()                    { *m = CreateInstanceMetadata{} }
func (m *CreateInstanceMetadata) String() string            { return proto.CompactTextString(m) }
func (*CreateInstanceMetadata) ProtoMessage()               {}
func (*CreateInstanceMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *CreateInstanceMetadata) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *CreateInstanceMetadata) GetStartTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *CreateInstanceMetadata) GetCancelTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.CancelTime
	}
	return nil
}

func (m *CreateInstanceMetadata) GetEndTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Metadata type for the operation returned by
// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance].
type UpdateInstanceMetadata struct {
	// The desired end state of the update.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance" json:"instance,omitempty"`
	// The time at which [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance]
	// request was received.
	StartTime *google_protobuf4.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *google_protobuf4.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *google_protobuf4.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
}

func (m *UpdateInstanceMetadata) Reset()                    { *m = UpdateInstanceMetadata{} }
func (m *UpdateInstanceMetadata) String() string            { return proto.CompactTextString(m) }
func (*UpdateInstanceMetadata) ProtoMessage()               {}
func (*UpdateInstanceMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *UpdateInstanceMetadata) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetStartTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetCancelTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.CancelTime
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetEndTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func init() {
	proto.RegisterType((*InstanceConfig)(nil), "google.spanner.admin.instance.v1.InstanceConfig")
	proto.RegisterType((*Instance)(nil), "google.spanner.admin.instance.v1.Instance")
	proto.RegisterType((*ListInstanceConfigsRequest)(nil), "google.spanner.admin.instance.v1.ListInstanceConfigsRequest")
	proto.RegisterType((*ListInstanceConfigsResponse)(nil), "google.spanner.admin.instance.v1.ListInstanceConfigsResponse")
	proto.RegisterType((*GetInstanceConfigRequest)(nil), "google.spanner.admin.instance.v1.GetInstanceConfigRequest")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.spanner.admin.instance.v1.GetInstanceRequest")
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.spanner.admin.instance.v1.CreateInstanceRequest")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.spanner.admin.instance.v1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.spanner.admin.instance.v1.ListInstancesResponse")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "google.spanner.admin.instance.v1.UpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.spanner.admin.instance.v1.DeleteInstanceRequest")
	proto.RegisterType((*CreateInstanceMetadata)(nil), "google.spanner.admin.instance.v1.CreateInstanceMetadata")
	proto.RegisterType((*UpdateInstanceMetadata)(nil), "google.spanner.admin.instance.v1.UpdateInstanceMetadata")
	proto.RegisterEnum("google.spanner.admin.instance.v1.Instance_State", Instance_State_name, Instance_State_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for InstanceAdmin service

type InstanceAdminClient interface {
	// Lists the supported instance configurations for a given project.
	ListInstanceConfigs(ctx context.Context, in *ListInstanceConfigsRequest, opts ...grpc.CallOption) (*ListInstanceConfigsResponse, error)
	// Gets information about a particular instance configuration.
	GetInstanceConfig(ctx context.Context, in *GetInstanceConfigRequest, opts ...grpc.CallOption) (*InstanceConfig, error)
	// Lists all instances in the given project.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets information about a particular instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates an instance and begins preparing it to begin serving. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new
	// instance. The instance name is assigned by the caller. If the
	// named instance already exists, `CreateInstance` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   * The instance is readable via the API, with all requested attributes
	//     but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   * Cancelling the operation renders the instance immediately unreadable
	//     via the API.
	//   * The instance can be deleted.
	//   * All other attempts to modify the instance are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   * Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   * Databases can be created in the instance.
	//   * The instance's allocated resource levels are readable via the API.
	//   * The instance's state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track creation of the instance.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstanceMetadata][google.spanner.admin.instance.v1.CreateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Updates an instance, and begins allocating or releasing resources
	// as requested. The returned [long-running
	// operation][google.longrunning.Operation] can be used to track the
	// progress of updating the instance. If the named instance does not
	// exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   * For resource types for which a decrease in the instance's allocation
	//     has been requested, billing is based on the newly-requested level.
	//
	// Until completion of the returned operation:
	//
	//   * Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time], and begins
	//     restoring resources to their pre-request values. The operation
	//     is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   * All other attempts to modify the instance are rejected.
	//   * Reading the instance via the API continues to give the pre-request
	//     resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   * Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   * All newly-reserved resources are available for serving the instance's
	//     tables.
	//   * The instance's new resource levels are readable via the API.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track the instance modification.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstanceMetadata][google.spanner.admin.instance.v1.UpdateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	//
	// Authorization requires `spanner.instances.update` permission on
	// resource [name][google.spanner.admin.instance.v1.Instance.name].
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes an instance.
	//
	// Immediately upon completion of the request:
	//
	//   * Billing ceases for all of the instance's reserved resources.
	//
	// Soon afterward:
	//
	//   * The instance and *all of its databases* immediately and
	//     irrevocably disappear from the API. All data in the databases
	//     is permanently deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.instances.setIamPolicy` on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	//
	// Authorization requires `spanner.instances.getIamPolicy` on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner instance resource will
	// result in a NOT_FOUND error if the user has `spanner.instances.list`
	// permission on the containing Google Cloud Project. Otherwise returns an
	// empty set of permissions.
	TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error)
}

type instanceAdminClient struct {
	cc *grpc.ClientConn
}

func NewInstanceAdminClient(cc *grpc.ClientConn) InstanceAdminClient {
	return &instanceAdminClient{cc}
}

func (c *instanceAdminClient) ListInstanceConfigs(ctx context.Context, in *ListInstanceConfigsRequest, opts ...grpc.CallOption) (*ListInstanceConfigsResponse, error) {
	out := new(ListInstanceConfigsResponse)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstanceConfig(ctx context.Context, in *GetInstanceConfigRequest, opts ...grpc.CallOption) (*InstanceConfig, error) {
	out := new(InstanceConfig)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstanceConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstances", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/SetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error) {
	out := new(google_iam_v11.TestIamPermissionsResponse)
	err := grpc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/TestIamPermissions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for InstanceAdmin service

type InstanceAdminServer interface {
	// Lists the supported instance configurations for a given project.
	ListInstanceConfigs(context.Context, *ListInstanceConfigsRequest) (*ListInstanceConfigsResponse, error)
	// Gets information about a particular instance configuration.
	GetInstanceConfig(context.Context, *GetInstanceConfigRequest) (*InstanceConfig, error)
	// Lists all instances in the given project.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets information about a particular instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates an instance and begins preparing it to begin serving. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new
	// instance. The instance name is assigned by the caller. If the
	// named instance already exists, `CreateInstance` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   * The instance is readable via the API, with all requested attributes
	//     but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   * Cancelling the operation renders the instance immediately unreadable
	//     via the API.
	//   * The instance can be deleted.
	//   * All other attempts to modify the instance are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   * Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   * Databases can be created in the instance.
	//   * The instance's allocated resource levels are readable via the API.
	//   * The instance's state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track creation of the instance.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstanceMetadata][google.spanner.admin.instance.v1.CreateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	CreateInstance(context.Context, *CreateInstanceRequest) (*google_longrunning.Operation, error)
	// Updates an instance, and begins allocating or releasing resources
	// as requested. The returned [long-running
	// operation][google.longrunning.Operation] can be used to track the
	// progress of updating the instance. If the named instance does not
	// exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   * For resource types for which a decrease in the instance's allocation
	//     has been requested, billing is based on the newly-requested level.
	//
	// Until completion of the returned operation:
	//
	//   * Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time], and begins
	//     restoring resources to their pre-request values. The operation
	//     is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   * All other attempts to modify the instance are rejected.
	//   * Reading the instance via the API continues to give the pre-request
	//     resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   * Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   * All newly-reserved resources are available for serving the instance's
	//     tables.
	//   * The instance's new resource levels are readable via the API.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track the instance modification.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstanceMetadata][google.spanner.admin.instance.v1.UpdateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	//
	// Authorization requires `spanner.instances.update` permission on
	// resource [name][google.spanner.admin.instance.v1.Instance.name].
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*google_longrunning.Operation, error)
	// Deletes an instance.
	//
	// Immediately upon completion of the request:
	//
	//   * Billing ceases for all of the instance's reserved resources.
	//
	// Soon afterward:
	//
	//   * The instance and *all of its databases* immediately and
	//     irrevocably disappear from the API. All data in the databases
	//     is permanently deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*google_protobuf2.Empty, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.instances.setIamPolicy` on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(context.Context, *google_iam_v11.SetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	//
	// Authorization requires `spanner.instances.getIamPolicy` on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(context.Context, *google_iam_v11.GetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner instance resource will
	// result in a NOT_FOUND error if the user has `spanner.instances.list`
	// permission on the containing Google Cloud Project. Otherwise returns an
	// empty set of permissions.
	TestIamPermissions(context.Context, *google_iam_v11.TestIamPermissionsRequest) (*google_iam_v11.TestIamPermissionsResponse, error)
}

func RegisterInstanceAdminServer(s *grpc.Server, srv InstanceAdminServer) {
	s.RegisterService(&_InstanceAdmin_serviceDesc, srv)
}

func _InstanceAdmin_ListInstanceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstanceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstanceConfigs(ctx, req.(*ListInstanceConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstanceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstanceConfig(ctx, req.(*GetInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).SetIamPolicy(ctx, req.(*google_iam_v11.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetIamPolicy(ctx, req.(*google_iam_v11.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).TestIamPermissions(ctx, req.(*google_iam_v11.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _InstanceAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.admin.instance.v1.InstanceAdmin",
	HandlerType: (*InstanceAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstanceConfigs",
			Handler:    _InstanceAdmin_ListInstanceConfigs_Handler,
		},
		{
			MethodName: "GetInstanceConfig",
			Handler:    _InstanceAdmin_GetInstanceConfig_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _InstanceAdmin_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _InstanceAdmin_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _InstanceAdmin_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _InstanceAdmin_UpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _InstanceAdmin_DeleteInstance_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _InstanceAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _InstanceAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InstanceAdmin_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/spanner/admin/instance/v1/spanner_instance_admin.proto",
}

func init() {
	proto.RegisterFile("google/spanner/admin/instance/v1/spanner_instance_admin.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1198 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x57, 0xcf, 0x8f, 0xdb, 0xc4,
	0x17, 0xff, 0xce, 0x6e, 0xb3, 0xdd, 0xbc, 0x6c, 0xb7, 0xdb, 0xf9, 0x36, 0x55, 0x48, 0x29, 0x4d,
	0x5d, 0x54, 0xd2, 0x80, 0x6c, 0x1a, 0xe8, 0xaf, 0x2d, 0x7b, 0xd8, 0xa6, 0xd9, 0x34, 0x52, 0xbb,
	0xac, 0x9c, 0x14, 0x09, 0x38, 0x44, 0xd3, 0x64, 0x36, 0x98, 0xb5, 0xc7, 0xc6, 0x33, 0xa9, 0xd8,
	0xa2, 0x5e, 0x2a, 0x0e, 0x20, 0x21, 0x71, 0x40, 0x42, 0xa8, 0x17, 0x24, 0x8e, 0x20, 0x71, 0xe0,
	0xc0, 0x3f, 0xc0, 0x9f, 0xc0, 0xbf, 0x80, 0xf8, 0x3b, 0xd0, 0x8c, 0x3d, 0x69, 0xec, 0x24, 0x9b,
	0xa4, 0xa2, 0x27, 0x6e, 0x9e, 0xf7, 0xf3, 0xe3, 0xcf, 0x7b, 0x7e, 0xcf, 0x03, 0x5b, 0x7d, 0xdf,
	0xef, 0xbb, 0xd4, 0xe2, 0x01, 0x61, 0x8c, 0x86, 0x16, 0xe9, 0x79, 0x0e, 0xb3, 0x1c, 0xc6, 0x05,
	0x61, 0x5d, 0x6a, 0x3d, 0xba, 0xa2, 0x35, 0x1d, 0x2d, 0xeb, 0x28, 0x13, 0x33, 0x08, 0x7d, 0xe1,
	0xe3, 0x52, 0xe4, 0x6e, 0xc6, 0x46, 0x66, 0xa4, 0xd3, 0xa6, 0xe6, 0xa3, 0x2b, 0xc5, 0x57, 0xe3,
	0x04, 0x24, 0x70, 0x2c, 0xc2, 0x98, 0x2f, 0x88, 0x70, 0x7c, 0xc6, 0x23, 0xff, 0x62, 0x7e, 0x54,
	0x3b, 0x10, 0x9f, 0xc4, 0xe2, 0xd7, 0x62, 0xb1, 0x43, 0x3c, 0x09, 0xc1, 0x21, 0x5e, 0x27, 0xf0,
	0x5d, 0xa7, 0x7b, 0x18, 0xeb, 0x8b, 0x49, 0x7d, 0x42, 0x77, 0x31, 0xd6, 0xb9, 0x3e, 0xeb, 0x87,
	0x03, 0xc6, 0x1c, 0xd6, 0xb7, 0xfc, 0x80, 0x86, 0x89, 0xbc, 0x67, 0x63, 0x23, 0x75, 0x7a, 0x38,
	0xd8, 0xb7, 0xa8, 0x17, 0x08, 0x1d, 0xa1, 0x94, 0x56, 0xee, 0x3b, 0xd4, 0xed, 0x75, 0x3c, 0xc2,
	0x0f, 0x62, 0x8b, 0xf3, 0x69, 0x0b, 0xe1, 0x78, 0x94, 0x0b, 0xe2, 0x05, 0x91, 0x81, 0xd1, 0x80,
	0xf5, 0x66, 0x4c, 0x42, 0xcd, 0x67, 0xfb, 0x4e, 0x1f, 0x63, 0x38, 0xc6, 0x88, 0x47, 0x0b, 0xa8,
	0x84, 0xca, 0x59, 0x5b, 0x3d, 0xe3, 0x0b, 0xb0, 0xd6, 0x73, 0x78, 0xe0, 0x92, 0xc3, 0x8e, 0xd2,
	0x2d, 0x29, 0x5d, 0x2e, 0x96, 0xed, 0x12, 0x8f, 0x1a, 0x5f, 0x2e, 0xc3, 0xaa, 0x8e, 0x34, 0x31,
	0xc6, 0x19, 0x58, 0xe9, 0xaa, 0x0c, 0xb1, 0x77, 0x7c, 0x1a, 0x8b, 0xbd, 0x3c, 0x16, 0x1b, 0x9f,
	0x03, 0x60, 0x7e, 0x8f, 0x76, 0xba, 0xfe, 0x80, 0x89, 0x42, 0xa6, 0x84, 0xca, 0x19, 0x3b, 0x2b,
	0x25, 0x35, 0x29, 0xc0, 0x3b, 0x90, 0xe1, 0x82, 0x08, 0x5a, 0x58, 0x29, 0xa1, 0xf2, 0x7a, 0xf5,
	0x6d, 0x73, 0x56, 0xad, 0x4d, 0x0d, 0xd4, 0x6c, 0x49, 0x3f, 0x3b, 0x72, 0xc7, 0xbb, 0xb0, 0xe2,
	0x92, 0x87, 0xd4, 0xe5, 0x85, 0xe3, 0xa5, 0xe5, 0x72, 0xae, 0x7a, 0x6d, 0x81, 0x40, 0xf7, 0x94,
	0x63, 0x9d, 0x89, 0xf0, 0xd0, 0x8e, 0xa3, 0x14, 0x6f, 0x42, 0x6e, 0x44, 0x8c, 0x37, 0x60, 0xf9,
	0x80, 0x1e, 0xc6, 0x9c, 0xc8, 0x47, 0x7c, 0x1a, 0x32, 0x8f, 0x88, 0x3b, 0xd0, 0x7c, 0x46, 0x87,
	0xcd, 0xa5, 0x1b, 0xc8, 0xb8, 0x0e, 0x19, 0x05, 0x0d, 0xe7, 0xe1, 0x54, 0xab, 0xbd, 0xdd, 0xae,
	0x77, 0x1e, 0xec, 0xb6, 0xf6, 0xea, 0xb5, 0xe6, 0x4e, 0xb3, 0x7e, 0x67, 0xe3, 0x7f, 0x78, 0x0d,
	0x56, 0x6b, 0x76, 0x7d, 0xbb, 0xdd, 0xdc, 0x6d, 0x6c, 0x20, 0x9c, 0x85, 0x8c, 0x5d, 0xdf, 0xbe,
	0xf3, 0xe1, 0xc6, 0x92, 0x11, 0x40, 0xf1, 0x9e, 0xc3, 0x45, 0xb2, 0xa6, 0xdc, 0xa6, 0x9f, 0x0d,
	0x28, 0x17, 0xb2, 0x06, 0x01, 0x09, 0x29, 0x13, 0x31, 0x8a, 0xf8, 0x84, 0xcf, 0x42, 0x36, 0x20,
	0x7d, 0xda, 0xe1, 0xce, 0xe3, 0x08, 0x4c, 0xc6, 0x5e, 0x95, 0x82, 0x96, 0xf3, 0x58, 0xb1, 0xaf,
	0x94, 0xc2, 0x3f, 0xa0, 0x2c, 0x2e, 0x8f, 0x32, 0x6f, 0x4b, 0x81, 0xf1, 0x13, 0x82, 0xb3, 0x13,
	0x53, 0xf2, 0xc0, 0x67, 0x9c, 0xe2, 0x8f, 0x61, 0x63, 0xf8, 0x45, 0x46, 0x25, 0xe7, 0x05, 0xa4,
	0xf8, 0x5d, 0xa0, 0x50, 0x51, 0x50, 0xfb, 0xa4, 0x93, 0x4c, 0x82, 0x2f, 0xc1, 0x49, 0x46, 0x3f,
	0x17, 0x9d, 0x11, 0x80, 0x11, 0x97, 0x27, 0xa4, 0x78, 0x6f, 0x08, 0xd2, 0x84, 0x42, 0x83, 0xa6,
	0x20, 0x6a, 0x52, 0x26, 0x34, 0xab, 0x51, 0x06, 0x3c, 0x62, 0x7f, 0x94, 0xe5, 0x0f, 0x08, 0xf2,
	0xb5, 0x90, 0x12, 0x41, 0xd3, 0xd6, 0xd3, 0xc8, 0x3e, 0x0f, 0xb9, 0x21, 0x21, 0x4e, 0x2f, 0xc6,
	0x0b, 0x5a, 0xd4, 0xec, 0xe1, 0x1d, 0x58, 0xd5, 0x27, 0x45, 0x77, 0xae, 0x5a, 0x99, 0x9f, 0x29,
	0x7b, 0xe8, 0x6b, 0x3c, 0x45, 0x70, 0x7a, 0xb4, 0x32, 0x2f, 0xb3, 0x0d, 0x64, 0xcc, 0x7d, 0xc7,
	0x15, 0x34, 0x2c, 0x1c, 0x8b, 0x62, 0x46, 0x27, 0xe3, 0x6b, 0x04, 0xf9, 0x14, 0x88, 0xb8, 0x31,
	0xee, 0x42, 0x56, 0x43, 0xd5, 0x1d, 0xb1, 0xc8, 0x7b, 0x3e, 0x77, 0x9e, 0xbb, 0x0b, 0x9e, 0x21,
	0xc8, 0x3f, 0x08, 0x7a, 0x13, 0x6a, 0x35, 0x4a, 0x39, 0x7a, 0x71, 0xca, 0xf1, 0x4d, 0x80, 0xe7,
	0x33, 0x58, 0x81, 0xc8, 0x55, 0x8b, 0x3a, 0x92, 0x1e, 0xc2, 0xe6, 0x8e, 0x34, 0xb9, 0x4f, 0xf8,
	0x81, 0x9d, 0xdd, 0xd7, 0x8f, 0xc6, 0x9b, 0x90, 0xbf, 0x43, 0x5d, 0x3a, 0x8e, 0x6d, 0x52, 0xd7,
	0x7d, 0xbb, 0x04, 0x67, 0x92, 0x5d, 0x77, 0x9f, 0x0a, 0xd2, 0x23, 0x82, 0xfc, 0x9b, 0xaf, 0xc2,
	0x05, 0x09, 0x45, 0x47, 0xae, 0x8c, 0xa9, 0xaf, 0xd2, 0xd6, 0xfb, 0xc4, 0xce, 0x2a, 0x6b, 0x79,
	0xc6, 0xb7, 0x20, 0xd7, 0x95, 0x31, 0xdc, 0xc8, 0x77, 0x79, 0xa6, 0x2f, 0x44, 0xe6, 0xca, 0xf9,
	0x2a, 0xac, 0x52, 0xd6, 0x8b, 0x3c, 0x8f, 0xcd, 0xf4, 0x3c, 0x4e, 0x59, 0x4f, 0x9e, 0x14, 0x23,
	0xc9, 0xda, 0xfe, 0xc7, 0x19, 0xa9, 0xfe, 0xbd, 0x06, 0x27, 0xf4, 0x5b, 0x6c, 0xcb, 0xf7, 0xc3,
	0x7f, 0x20, 0xf8, 0xff, 0x84, 0x51, 0x8d, 0xdf, 0x9b, 0x4d, 0xc7, 0xf4, 0xa5, 0x52, 0xdc, 0x7a,
	0x41, 0xef, 0x68, 0x0c, 0x18, 0xd6, 0xd3, 0x3f, 0xff, 0xfa, 0x6e, 0xe9, 0x32, 0x7e, 0x43, 0xfe,
	0x20, 0x7d, 0x11, 0x4d, 0xa2, 0xad, 0x20, 0xf4, 0x3f, 0xa5, 0x5d, 0xc1, 0xad, 0xca, 0x13, 0x2b,
	0x3d, 0xf3, 0x7f, 0x43, 0x70, 0x6a, 0x6c, 0x98, 0xe3, 0xcd, 0xd9, 0x28, 0xa6, 0x6d, 0x80, 0xe2,
	0xc2, 0x8b, 0x28, 0x05, 0x5a, 0x7e, 0x92, 0x23, 0x90, 0xd3, 0x88, 0xad, 0xca, 0x13, 0xfc, 0x0b,
	0x82, 0x13, 0x89, 0x31, 0x88, 0xaf, 0x2d, 0x46, 0xdb, 0x90, 0xee, 0xeb, 0x0b, 0xfb, 0xc5, 0x44,
	0x5f, 0x56, 0x98, 0x2f, 0xe2, 0x0b, 0xb3, 0x88, 0xe6, 0xf8, 0x19, 0x82, 0xdc, 0x08, 0x5b, 0xf8,
	0xdd, 0x85, 0xc8, 0xd5, 0x48, 0x17, 0xf8, 0xca, 0x52, 0xe0, 0xa6, 0x11, 0xaa, 0xa8, 0xfc, 0x1e,
	0xc1, 0x7a, 0x72, 0xf6, 0xe1, 0x39, 0x38, 0x99, 0xb8, 0xa3, 0x8b, 0xe7, 0xb4, 0xe3, 0xc8, 0x4f,
	0xb8, 0xf9, 0xbe, 0xfe, 0x09, 0x37, 0xde, 0x52, 0xa8, 0x2e, 0x19, 0xb3, 0x29, 0xdb, 0x44, 0x15,
	0xfc, 0x23, 0x82, 0xf5, 0xe4, 0x08, 0x9a, 0x07, 0xd8, 0xc4, 0x85, 0x34, 0x0b, 0xd8, 0x55, 0x05,
	0xcc, 0xaa, 0x56, 0x14, 0xb0, 0x61, 0xb8, 0xa3, 0x78, 0x93, 0x08, 0xbf, 0x41, 0xb0, 0x9e, 0x5c,
	0x32, 0xf3, 0x20, 0x9c, 0xb8, 0x96, 0x8a, 0x67, 0xc6, 0x66, 0x50, 0x5d, 0x5e, 0x4d, 0x74, 0x25,
	0x2b, 0x73, 0x54, 0xf2, 0x2b, 0x04, 0x6b, 0x2d, 0x2a, 0x9a, 0xc4, 0xdb, 0x53, 0x17, 0x23, 0x6c,
	0xe8, 0x98, 0x0e, 0xf1, 0x64, 0xe6, 0x51, 0xa5, 0xce, 0x9b, 0x4f, 0xd9, 0x44, 0x5a, 0x63, 0x4b,
	0xa5, 0xbd, 0x6e, 0x54, 0x55, 0xda, 0x90, 0x72, 0x7f, 0x10, 0x76, 0xa7, 0x93, 0xc1, 0x47, 0x22,
	0x4b, 0x66, 0x24, 0x94, 0xc6, 0x51, 0x50, 0x1a, 0x2f, 0x0d, 0x4a, 0x3f, 0x05, 0xe5, 0x57, 0x04,
	0xb8, 0x4d, 0xb9, 0x12, 0xd2, 0xd0, 0x73, 0x38, 0x97, 0xf7, 0x41, 0x5c, 0x4e, 0x25, 0x1b, 0x37,
	0xd1, 0xb0, 0x2e, 0xcf, 0x61, 0x19, 0xcf, 0x84, 0x9a, 0x82, 0xba, 0x65, 0xdc, 0x98, 0x0f, 0xaa,
	0x18, 0x8b, 0xb4, 0x89, 0x2a, 0xb7, 0x7f, 0x47, 0xf0, 0x7a, 0xd7, 0xf7, 0x66, 0x36, 0xd2, 0xed,
	0x57, 0x5a, 0x91, 0x2a, 0xb1, 0x95, 0xf6, 0x64, 0xfb, 0xec, 0xa1, 0x8f, 0xee, 0xc6, 0xee, 0x7d,
	0xdf, 0x25, 0xac, 0x6f, 0xfa, 0x61, 0xdf, 0xea, 0x53, 0xa6, 0x9a, 0xcb, 0x8a, 0x54, 0x24, 0x70,
	0xf8, 0xf4, 0xfb, 0xff, 0x2d, 0xfd, 0xfc, 0xf3, 0xd2, 0xa5, 0x46, 0x14, 0xaa, 0xe6, 0xfa, 0x83,
	0x9e, 0x19, 0x27, 0x35, 0x55, 0xb6, 0xe7, 0x37, 0xb6, 0x0f, 0xae, 0x3c, 0x5c, 0x51, 0xd1, 0xdf,
	0xf9, 0x27, 0x00, 0x00, 0xff, 0xff, 0xbf, 0x53, 0x3b, 0xf8, 0x5c, 0x10, 0x00, 0x00,
}
