// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/vision/v1/image_annotator.proto

package vision

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"
import google_type "google.golang.org/genproto/googleapis/type/color"
import google_type1 "google.golang.org/genproto/googleapis/type/latlng"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A bucketized representation of likelihood, which is intended to give clients
// highly stable results across model upgrades.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// It is very unlikely that the image belongs to the specified vertical.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// It is unlikely that the image belongs to the specified vertical.
	Likelihood_UNLIKELY Likelihood = 2
	// It is possible that the image belongs to the specified vertical.
	Likelihood_POSSIBLE Likelihood = 3
	// It is likely that the image belongs to the specified vertical.
	Likelihood_LIKELY Likelihood = 4
	// It is very likely that the image belongs to the specified vertical.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "UNKNOWN",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"UNKNOWN":       0,
	"VERY_UNLIKELY": 1,
	"UNLIKELY":      2,
	"POSSIBLE":      3,
	"LIKELY":        4,
	"VERY_LIKELY":   5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// Type of image feature.
type Feature_Type int32

const (
	// Unspecified feature type.
	Feature_TYPE_UNSPECIFIED Feature_Type = 0
	// Run face detection.
	Feature_FACE_DETECTION Feature_Type = 1
	// Run landmark detection.
	Feature_LANDMARK_DETECTION Feature_Type = 2
	// Run logo detection.
	Feature_LOGO_DETECTION Feature_Type = 3
	// Run label detection.
	Feature_LABEL_DETECTION Feature_Type = 4
	// Run OCR.
	Feature_TEXT_DETECTION Feature_Type = 5
	// Run dense text document OCR. Takes precedence when both
	// DOCUMENT_TEXT_DETECTION and TEXT_DETECTION are present.
	Feature_DOCUMENT_TEXT_DETECTION Feature_Type = 11
	// Run computer vision models to compute image safe-search properties.
	Feature_SAFE_SEARCH_DETECTION Feature_Type = 6
	// Compute a set of image properties, such as the image's dominant colors.
	Feature_IMAGE_PROPERTIES Feature_Type = 7
	// Run crop hints.
	Feature_CROP_HINTS Feature_Type = 9
	// Run web detection.
	Feature_WEB_DETECTION Feature_Type = 10
)

var Feature_Type_name = map[int32]string{
	0:  "TYPE_UNSPECIFIED",
	1:  "FACE_DETECTION",
	2:  "LANDMARK_DETECTION",
	3:  "LOGO_DETECTION",
	4:  "LABEL_DETECTION",
	5:  "TEXT_DETECTION",
	11: "DOCUMENT_TEXT_DETECTION",
	6:  "SAFE_SEARCH_DETECTION",
	7:  "IMAGE_PROPERTIES",
	9:  "CROP_HINTS",
	10: "WEB_DETECTION",
}
var Feature_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":        0,
	"FACE_DETECTION":          1,
	"LANDMARK_DETECTION":      2,
	"LOGO_DETECTION":          3,
	"LABEL_DETECTION":         4,
	"TEXT_DETECTION":          5,
	"DOCUMENT_TEXT_DETECTION": 11,
	"SAFE_SEARCH_DETECTION":   6,
	"IMAGE_PROPERTIES":        7,
	"CROP_HINTS":              9,
	"WEB_DETECTION":           10,
}

func (x Feature_Type) String() string {
	return proto.EnumName(Feature_Type_name, int32(x))
}
func (Feature_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0, 0} }

// Face landmark (feature) type.
// Left and right are defined from the vantage of the viewer of the image
// without considering mirror projections typical of photos. So, `LEFT_EYE`,
// typically, is the person's right eye.
type FaceAnnotation_Landmark_Type int32

const (
	// Unknown face landmark detected. Should not be filled.
	FaceAnnotation_Landmark_UNKNOWN_LANDMARK FaceAnnotation_Landmark_Type = 0
	// Left eye.
	FaceAnnotation_Landmark_LEFT_EYE FaceAnnotation_Landmark_Type = 1
	// Right eye.
	FaceAnnotation_Landmark_RIGHT_EYE FaceAnnotation_Landmark_Type = 2
	// Left of left eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 3
	// Right of left eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 4
	// Left of right eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 5
	// Right of right eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 6
	// Midpoint between eyes.
	FaceAnnotation_Landmark_MIDPOINT_BETWEEN_EYES FaceAnnotation_Landmark_Type = 7
	// Nose tip.
	FaceAnnotation_Landmark_NOSE_TIP FaceAnnotation_Landmark_Type = 8
	// Upper lip.
	FaceAnnotation_Landmark_UPPER_LIP FaceAnnotation_Landmark_Type = 9
	// Lower lip.
	FaceAnnotation_Landmark_LOWER_LIP FaceAnnotation_Landmark_Type = 10
	// Mouth left.
	FaceAnnotation_Landmark_MOUTH_LEFT FaceAnnotation_Landmark_Type = 11
	// Mouth right.
	FaceAnnotation_Landmark_MOUTH_RIGHT FaceAnnotation_Landmark_Type = 12
	// Mouth center.
	FaceAnnotation_Landmark_MOUTH_CENTER FaceAnnotation_Landmark_Type = 13
	// Nose, bottom right.
	FaceAnnotation_Landmark_NOSE_BOTTOM_RIGHT FaceAnnotation_Landmark_Type = 14
	// Nose, bottom left.
	FaceAnnotation_Landmark_NOSE_BOTTOM_LEFT FaceAnnotation_Landmark_Type = 15
	// Nose, bottom center.
	FaceAnnotation_Landmark_NOSE_BOTTOM_CENTER FaceAnnotation_Landmark_Type = 16
	// Left eye, top boundary.
	FaceAnnotation_Landmark_LEFT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 17
	// Left eye, right corner.
	FaceAnnotation_Landmark_LEFT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 18
	// Left eye, bottom boundary.
	FaceAnnotation_Landmark_LEFT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 19
	// Left eye, left corner.
	FaceAnnotation_Landmark_LEFT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 20
	// Right eye, top boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 21
	// Right eye, right corner.
	FaceAnnotation_Landmark_RIGHT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 22
	// Right eye, bottom boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 23
	// Right eye, left corner.
	FaceAnnotation_Landmark_RIGHT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 24
	// Left eyebrow, upper midpoint.
	FaceAnnotation_Landmark_LEFT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 25
	// Right eyebrow, upper midpoint.
	FaceAnnotation_Landmark_RIGHT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 26
	// Left ear tragion.
	FaceAnnotation_Landmark_LEFT_EAR_TRAGION FaceAnnotation_Landmark_Type = 27
	// Right ear tragion.
	FaceAnnotation_Landmark_RIGHT_EAR_TRAGION FaceAnnotation_Landmark_Type = 28
	// Left eye pupil.
	FaceAnnotation_Landmark_LEFT_EYE_PUPIL FaceAnnotation_Landmark_Type = 29
	// Right eye pupil.
	FaceAnnotation_Landmark_RIGHT_EYE_PUPIL FaceAnnotation_Landmark_Type = 30
	// Forehead glabella.
	FaceAnnotation_Landmark_FOREHEAD_GLABELLA FaceAnnotation_Landmark_Type = 31
	// Chin gnathion.
	FaceAnnotation_Landmark_CHIN_GNATHION FaceAnnotation_Landmark_Type = 32
	// Chin left gonion.
	FaceAnnotation_Landmark_CHIN_LEFT_GONION FaceAnnotation_Landmark_Type = 33
	// Chin right gonion.
	FaceAnnotation_Landmark_CHIN_RIGHT_GONION FaceAnnotation_Landmark_Type = 34
)

var FaceAnnotation_Landmark_Type_name = map[int32]string{
	0:  "UNKNOWN_LANDMARK",
	1:  "LEFT_EYE",
	2:  "RIGHT_EYE",
	3:  "LEFT_OF_LEFT_EYEBROW",
	4:  "RIGHT_OF_LEFT_EYEBROW",
	5:  "LEFT_OF_RIGHT_EYEBROW",
	6:  "RIGHT_OF_RIGHT_EYEBROW",
	7:  "MIDPOINT_BETWEEN_EYES",
	8:  "NOSE_TIP",
	9:  "UPPER_LIP",
	10: "LOWER_LIP",
	11: "MOUTH_LEFT",
	12: "MOUTH_RIGHT",
	13: "MOUTH_CENTER",
	14: "NOSE_BOTTOM_RIGHT",
	15: "NOSE_BOTTOM_LEFT",
	16: "NOSE_BOTTOM_CENTER",
	17: "LEFT_EYE_TOP_BOUNDARY",
	18: "LEFT_EYE_RIGHT_CORNER",
	19: "LEFT_EYE_BOTTOM_BOUNDARY",
	20: "LEFT_EYE_LEFT_CORNER",
	21: "RIGHT_EYE_TOP_BOUNDARY",
	22: "RIGHT_EYE_RIGHT_CORNER",
	23: "RIGHT_EYE_BOTTOM_BOUNDARY",
	24: "RIGHT_EYE_LEFT_CORNER",
	25: "LEFT_EYEBROW_UPPER_MIDPOINT",
	26: "RIGHT_EYEBROW_UPPER_MIDPOINT",
	27: "LEFT_EAR_TRAGION",
	28: "RIGHT_EAR_TRAGION",
	29: "LEFT_EYE_PUPIL",
	30: "RIGHT_EYE_PUPIL",
	31: "FOREHEAD_GLABELLA",
	32: "CHIN_GNATHION",
	33: "CHIN_LEFT_GONION",
	34: "CHIN_RIGHT_GONION",
}
var FaceAnnotation_Landmark_Type_value = map[string]int32{
	"UNKNOWN_LANDMARK":             0,
	"LEFT_EYE":                     1,
	"RIGHT_EYE":                    2,
	"LEFT_OF_LEFT_EYEBROW":         3,
	"RIGHT_OF_LEFT_EYEBROW":        4,
	"LEFT_OF_RIGHT_EYEBROW":        5,
	"RIGHT_OF_RIGHT_EYEBROW":       6,
	"MIDPOINT_BETWEEN_EYES":        7,
	"NOSE_TIP":                     8,
	"UPPER_LIP":                    9,
	"LOWER_LIP":                    10,
	"MOUTH_LEFT":                   11,
	"MOUTH_RIGHT":                  12,
	"MOUTH_CENTER":                 13,
	"NOSE_BOTTOM_RIGHT":            14,
	"NOSE_BOTTOM_LEFT":             15,
	"NOSE_BOTTOM_CENTER":           16,
	"LEFT_EYE_TOP_BOUNDARY":        17,
	"LEFT_EYE_RIGHT_CORNER":        18,
	"LEFT_EYE_BOTTOM_BOUNDARY":     19,
	"LEFT_EYE_LEFT_CORNER":         20,
	"RIGHT_EYE_TOP_BOUNDARY":       21,
	"RIGHT_EYE_RIGHT_CORNER":       22,
	"RIGHT_EYE_BOTTOM_BOUNDARY":    23,
	"RIGHT_EYE_LEFT_CORNER":        24,
	"LEFT_EYEBROW_UPPER_MIDPOINT":  25,
	"RIGHT_EYEBROW_UPPER_MIDPOINT": 26,
	"LEFT_EAR_TRAGION":             27,
	"RIGHT_EAR_TRAGION":            28,
	"LEFT_EYE_PUPIL":               29,
	"RIGHT_EYE_PUPIL":              30,
	"FOREHEAD_GLABELLA":            31,
	"CHIN_GNATHION":                32,
	"CHIN_LEFT_GONION":             33,
	"CHIN_RIGHT_GONION":            34,
}

func (x FaceAnnotation_Landmark_Type) String() string {
	return proto.EnumName(FaceAnnotation_Landmark_Type_name, int32(x))
}
func (FaceAnnotation_Landmark_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{3, 0, 0}
}

// Users describe the type of Google Cloud Vision API tasks to perform over
// images by using *Feature*s. Each Feature indicates a type of image
// detection task to perform. Features encode the Cloud Vision API
// vertical to operate on and the number of top-scoring results to return.
type Feature struct {
	// The feature type.
	Type Feature_Type `protobuf:"varint,1,opt,name=type,enum=google.cloud.vision.v1.Feature_Type" json:"type,omitempty"`
	// Maximum number of results of this type.
	MaxResults int32 `protobuf:"varint,2,opt,name=max_results,json=maxResults" json:"max_results,omitempty"`
}

func (m *Feature) Reset()                    { *m = Feature{} }
func (m *Feature) String() string            { return proto.CompactTextString(m) }
func (*Feature) ProtoMessage()               {}
func (*Feature) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *Feature) GetType() Feature_Type {
	if m != nil {
		return m.Type
	}
	return Feature_TYPE_UNSPECIFIED
}

func (m *Feature) GetMaxResults() int32 {
	if m != nil {
		return m.MaxResults
	}
	return 0
}

// External image source (Google Cloud Storage image location).
type ImageSource struct {
	// NOTE: For new code `image_uri` below is preferred.
	// Google Cloud Storage image URI, which must be in the following form:
	// `gs://bucket_name/object_name` (for details, see
	// [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris)).
	// NOTE: Cloud Storage object versioning is not supported.
	GcsImageUri string `protobuf:"bytes,1,opt,name=gcs_image_uri,json=gcsImageUri" json:"gcs_image_uri,omitempty"`
	// Image URI which supports:
	// 1) Google Cloud Storage image URI, which must be in the following form:
	// `gs://bucket_name/object_name` (for details, see
	// [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris)).
	// NOTE: Cloud Storage object versioning is not supported.
	// 2) Publicly accessible image HTTP/HTTPS URL.
	// This is preferred over the legacy `gcs_image_uri` above. When both
	// `gcs_image_uri` and `image_uri` are specified, `image_uri` takes
	// precedence.
	ImageUri string `protobuf:"bytes,2,opt,name=image_uri,json=imageUri" json:"image_uri,omitempty"`
}

func (m *ImageSource) Reset()                    { *m = ImageSource{} }
func (m *ImageSource) String() string            { return proto.CompactTextString(m) }
func (*ImageSource) ProtoMessage()               {}
func (*ImageSource) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *ImageSource) GetGcsImageUri() string {
	if m != nil {
		return m.GcsImageUri
	}
	return ""
}

func (m *ImageSource) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

// Client image to perform Google Cloud Vision API tasks over.
type Image struct {
	// Image content, represented as a stream of bytes.
	// Note: as with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Google Cloud Storage image location. If both `content` and `source`
	// are provided for an image, `content` takes precedence and is
	// used to perform the image annotation request.
	Source *ImageSource `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (m *Image) String() string            { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *Image) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Image) GetSource() *ImageSource {
	if m != nil {
		return m.Source
	}
	return nil
}

// A face annotation object contains the results of face detection.
type FaceAnnotation struct {
	// The bounding polygon around the face. The coordinates of the bounding box
	// are in the original image's scale, as returned in `ImageParams`.
	// The bounding box is computed to "frame" the face in accordance with human
	// expectations. It is based on the landmarker results.
	// Note that one or more x and/or y coordinates may not be generated in the
	// `BoundingPoly` (the polygon will be unbounded) if only a partial face
	// appears in the image to be annotated.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly" json:"bounding_poly,omitempty"`
	// The `fd_bounding_poly` bounding polygon is tighter than the
	// `boundingPoly`, and encloses only the skin part of the face. Typically, it
	// is used to eliminate the face from any image analysis that detects the
	// "amount of skin" visible in an image. It is not based on the
	// landmarker results, only on the initial face detection, hence
	// the <code>fd</code> (face detection) prefix.
	FdBoundingPoly *BoundingPoly `protobuf:"bytes,2,opt,name=fd_bounding_poly,json=fdBoundingPoly" json:"fd_bounding_poly,omitempty"`
	// Detected face landmarks.
	Landmarks []*FaceAnnotation_Landmark `protobuf:"bytes,3,rep,name=landmarks" json:"landmarks,omitempty"`
	// Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
	// of the face relative to the image vertical about the axis perpendicular to
	// the face. Range [-180,180].
	RollAngle float32 `protobuf:"fixed32,4,opt,name=roll_angle,json=rollAngle" json:"roll_angle,omitempty"`
	// Yaw angle, which indicates the leftward/rightward angle that the face is
	// pointing relative to the vertical plane perpendicular to the image. Range
	// [-180,180].
	PanAngle float32 `protobuf:"fixed32,5,opt,name=pan_angle,json=panAngle" json:"pan_angle,omitempty"`
	// Pitch angle, which indicates the upwards/downwards angle that the face is
	// pointing relative to the image's horizontal plane. Range [-180,180].
	TiltAngle float32 `protobuf:"fixed32,6,opt,name=tilt_angle,json=tiltAngle" json:"tilt_angle,omitempty"`
	// Detection confidence. Range [0, 1].
	DetectionConfidence float32 `protobuf:"fixed32,7,opt,name=detection_confidence,json=detectionConfidence" json:"detection_confidence,omitempty"`
	// Face landmarking confidence. Range [0, 1].
	LandmarkingConfidence float32 `protobuf:"fixed32,8,opt,name=landmarking_confidence,json=landmarkingConfidence" json:"landmarking_confidence,omitempty"`
	// Joy likelihood.
	JoyLikelihood Likelihood `protobuf:"varint,9,opt,name=joy_likelihood,json=joyLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"joy_likelihood,omitempty"`
	// Sorrow likelihood.
	SorrowLikelihood Likelihood `protobuf:"varint,10,opt,name=sorrow_likelihood,json=sorrowLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"sorrow_likelihood,omitempty"`
	// Anger likelihood.
	AngerLikelihood Likelihood `protobuf:"varint,11,opt,name=anger_likelihood,json=angerLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"anger_likelihood,omitempty"`
	// Surprise likelihood.
	SurpriseLikelihood Likelihood `protobuf:"varint,12,opt,name=surprise_likelihood,json=surpriseLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"surprise_likelihood,omitempty"`
	// Under-exposed likelihood.
	UnderExposedLikelihood Likelihood `protobuf:"varint,13,opt,name=under_exposed_likelihood,json=underExposedLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"under_exposed_likelihood,omitempty"`
	// Blurred likelihood.
	BlurredLikelihood Likelihood `protobuf:"varint,14,opt,name=blurred_likelihood,json=blurredLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"blurred_likelihood,omitempty"`
	// Headwear likelihood.
	HeadwearLikelihood Likelihood `protobuf:"varint,15,opt,name=headwear_likelihood,json=headwearLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"headwear_likelihood,omitempty"`
}

func (m *FaceAnnotation) Reset()                    { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string            { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()               {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *FaceAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetFdBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.FdBoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetLandmarks() []*FaceAnnotation_Landmark {
	if m != nil {
		return m.Landmarks
	}
	return nil
}

func (m *FaceAnnotation) GetRollAngle() float32 {
	if m != nil {
		return m.RollAngle
	}
	return 0
}

func (m *FaceAnnotation) GetPanAngle() float32 {
	if m != nil {
		return m.PanAngle
	}
	return 0
}

func (m *FaceAnnotation) GetTiltAngle() float32 {
	if m != nil {
		return m.TiltAngle
	}
	return 0
}

func (m *FaceAnnotation) GetDetectionConfidence() float32 {
	if m != nil {
		return m.DetectionConfidence
	}
	return 0
}

func (m *FaceAnnotation) GetLandmarkingConfidence() float32 {
	if m != nil {
		return m.LandmarkingConfidence
	}
	return 0
}

func (m *FaceAnnotation) GetJoyLikelihood() Likelihood {
	if m != nil {
		return m.JoyLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetSorrowLikelihood() Likelihood {
	if m != nil {
		return m.SorrowLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetAngerLikelihood() Likelihood {
	if m != nil {
		return m.AngerLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetSurpriseLikelihood() Likelihood {
	if m != nil {
		return m.SurpriseLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetUnderExposedLikelihood() Likelihood {
	if m != nil {
		return m.UnderExposedLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetBlurredLikelihood() Likelihood {
	if m != nil {
		return m.BlurredLikelihood
	}
	return Likelihood_UNKNOWN
}

func (m *FaceAnnotation) GetHeadwearLikelihood() Likelihood {
	if m != nil {
		return m.HeadwearLikelihood
	}
	return Likelihood_UNKNOWN
}

// A face-specific landmark (for example, a face feature).
// Landmark positions may fall outside the bounds of the image
// if the face is near one or more edges of the image.
// Therefore it is NOT guaranteed that `0 <= x < width` or
// `0 <= y < height`.
type FaceAnnotation_Landmark struct {
	// Face landmark type.
	Type FaceAnnotation_Landmark_Type `protobuf:"varint,3,opt,name=type,enum=google.cloud.vision.v1.FaceAnnotation_Landmark_Type" json:"type,omitempty"`
	// Face landmark position.
	Position *Position `protobuf:"bytes,4,opt,name=position" json:"position,omitempty"`
}

func (m *FaceAnnotation_Landmark) Reset()                    { *m = FaceAnnotation_Landmark{} }
func (m *FaceAnnotation_Landmark) String() string            { return proto.CompactTextString(m) }
func (*FaceAnnotation_Landmark) ProtoMessage()               {}
func (*FaceAnnotation_Landmark) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3, 0} }

func (m *FaceAnnotation_Landmark) GetType() FaceAnnotation_Landmark_Type {
	if m != nil {
		return m.Type
	}
	return FaceAnnotation_Landmark_UNKNOWN_LANDMARK
}

func (m *FaceAnnotation_Landmark) GetPosition() *Position {
	if m != nil {
		return m.Position
	}
	return nil
}

// Detected entity location information.
type LocationInfo struct {
	// lat/long location coordinates.
	LatLng *google_type1.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng" json:"lat_lng,omitempty"`
}

func (m *LocationInfo) Reset()                    { *m = LocationInfo{} }
func (m *LocationInfo) String() string            { return proto.CompactTextString(m) }
func (*LocationInfo) ProtoMessage()               {}
func (*LocationInfo) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *LocationInfo) GetLatLng() *google_type1.LatLng {
	if m != nil {
		return m.LatLng
	}
	return nil
}

// A `Property` consists of a user-supplied name/value pair.
type Property struct {
	// Name of the property.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Value of the property.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Property) Reset()                    { *m = Property{} }
func (m *Property) String() string            { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()               {}
func (*Property) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *Property) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Property) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Set of detected entity features.
type EntityAnnotation struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search API](https://developers.google.com/knowledge-graph/).
	Mid string `protobuf:"bytes,1,opt,name=mid" json:"mid,omitempty"`
	// The language code for the locale in which the entity textual
	// `description` is expressed.
	Locale string `protobuf:"bytes,2,opt,name=locale" json:"locale,omitempty"`
	// Entity textual description, expressed in its `locale` language.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Overall score of the result. Range [0, 1].
	Score float32 `protobuf:"fixed32,4,opt,name=score" json:"score,omitempty"`
	// The accuracy of the entity detection in an image.
	// For example, for an image in which the "Eiffel Tower" entity is detected,
	// this field represents the confidence that there is a tower in the query
	// image. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence" json:"confidence,omitempty"`
	// The relevancy of the ICA (Image Content Annotation) label to the
	// image. For example, the relevancy of "tower" is likely higher to an image
	// containing the detected "Eiffel Tower" than to an image containing a
	// detected distant towering building, even though the confidence that
	// there is a tower in each image may be the same. Range [0, 1].
	Topicality float32 `protobuf:"fixed32,6,opt,name=topicality" json:"topicality,omitempty"`
	// Image region to which this entity belongs. Currently not produced
	// for `LABEL_DETECTION` features. For `TEXT_DETECTION` (OCR), `boundingPoly`s
	// are produced for the entire text detected in an image region, followed by
	// `boundingPoly`s for each word within the detected text.
	BoundingPoly *BoundingPoly `protobuf:"bytes,7,opt,name=bounding_poly,json=boundingPoly" json:"bounding_poly,omitempty"`
	// The location information for the detected entity. Multiple
	// `LocationInfo` elements can be present because one location may
	// indicate the location of the scene in the image, and another location
	// may indicate the location of the place where the image was taken.
	// Location information is usually present for landmarks.
	Locations []*LocationInfo `protobuf:"bytes,8,rep,name=locations" json:"locations,omitempty"`
	// Some entities may have optional user-supplied `Property` (name/value)
	// fields, such a score or string that qualifies the entity.
	Properties []*Property `protobuf:"bytes,9,rep,name=properties" json:"properties,omitempty"`
}

func (m *EntityAnnotation) Reset()                    { *m = EntityAnnotation{} }
func (m *EntityAnnotation) String() string            { return proto.CompactTextString(m) }
func (*EntityAnnotation) ProtoMessage()               {}
func (*EntityAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *EntityAnnotation) GetMid() string {
	if m != nil {
		return m.Mid
	}
	return ""
}

func (m *EntityAnnotation) GetLocale() string {
	if m != nil {
		return m.Locale
	}
	return ""
}

func (m *EntityAnnotation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EntityAnnotation) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *EntityAnnotation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *EntityAnnotation) GetTopicality() float32 {
	if m != nil {
		return m.Topicality
	}
	return 0
}

func (m *EntityAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *EntityAnnotation) GetLocations() []*LocationInfo {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *EntityAnnotation) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Set of features pertaining to the image, computed by computer vision
// methods over safe-search verticals (for example, adult, spoof, medical,
// violence).
type SafeSearchAnnotation struct {
	// Represents the adult content likelihood for the image.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,enum=google.cloud.vision.v1.Likelihood" json:"adult,omitempty"`
	// Spoof likelihood. The likelihood that an modification
	// was made to the image's canonical version to make it appear
	// funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,enum=google.cloud.vision.v1.Likelihood" json:"spoof,omitempty"`
	// Likelihood that this is a medical image.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,enum=google.cloud.vision.v1.Likelihood" json:"medical,omitempty"`
	// Violence likelihood.
	Violence Likelihood `protobuf:"varint,4,opt,name=violence,enum=google.cloud.vision.v1.Likelihood" json:"violence,omitempty"`
}

func (m *SafeSearchAnnotation) Reset()                    { *m = SafeSearchAnnotation{} }
func (m *SafeSearchAnnotation) String() string            { return proto.CompactTextString(m) }
func (*SafeSearchAnnotation) ProtoMessage()               {}
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *SafeSearchAnnotation) GetAdult() Likelihood {
	if m != nil {
		return m.Adult
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetSpoof() Likelihood {
	if m != nil {
		return m.Spoof
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetMedical() Likelihood {
	if m != nil {
		return m.Medical
	}
	return Likelihood_UNKNOWN
}

func (m *SafeSearchAnnotation) GetViolence() Likelihood {
	if m != nil {
		return m.Violence
	}
	return Likelihood_UNKNOWN
}

// Rectangle determined by min and max `LatLng` pairs.
type LatLongRect struct {
	// Min lat/long pair.
	MinLatLng *google_type1.LatLng `protobuf:"bytes,1,opt,name=min_lat_lng,json=minLatLng" json:"min_lat_lng,omitempty"`
	// Max lat/long pair.
	MaxLatLng *google_type1.LatLng `protobuf:"bytes,2,opt,name=max_lat_lng,json=maxLatLng" json:"max_lat_lng,omitempty"`
}

func (m *LatLongRect) Reset()                    { *m = LatLongRect{} }
func (m *LatLongRect) String() string            { return proto.CompactTextString(m) }
func (*LatLongRect) ProtoMessage()               {}
func (*LatLongRect) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *LatLongRect) GetMinLatLng() *google_type1.LatLng {
	if m != nil {
		return m.MinLatLng
	}
	return nil
}

func (m *LatLongRect) GetMaxLatLng() *google_type1.LatLng {
	if m != nil {
		return m.MaxLatLng
	}
	return nil
}

// Color information consists of RGB channels, score, and the fraction of
// the image that the color occupies in the image.
type ColorInfo struct {
	// RGB components of the color.
	Color *google_type.Color `protobuf:"bytes,1,opt,name=color" json:"color,omitempty"`
	// Image-specific score for this color. Value in range [0, 1].
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
	// The fraction of pixels the color occupies in the image.
	// Value in range [0, 1].
	PixelFraction float32 `protobuf:"fixed32,3,opt,name=pixel_fraction,json=pixelFraction" json:"pixel_fraction,omitempty"`
}

func (m *ColorInfo) Reset()                    { *m = ColorInfo{} }
func (m *ColorInfo) String() string            { return proto.CompactTextString(m) }
func (*ColorInfo) ProtoMessage()               {}
func (*ColorInfo) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *ColorInfo) GetColor() *google_type.Color {
	if m != nil {
		return m.Color
	}
	return nil
}

func (m *ColorInfo) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *ColorInfo) GetPixelFraction() float32 {
	if m != nil {
		return m.PixelFraction
	}
	return 0
}

// Set of dominant colors and their corresponding scores.
type DominantColorsAnnotation struct {
	// RGB color values with their score and pixel fraction.
	Colors []*ColorInfo `protobuf:"bytes,1,rep,name=colors" json:"colors,omitempty"`
}

func (m *DominantColorsAnnotation) Reset()                    { *m = DominantColorsAnnotation{} }
func (m *DominantColorsAnnotation) String() string            { return proto.CompactTextString(m) }
func (*DominantColorsAnnotation) ProtoMessage()               {}
func (*DominantColorsAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *DominantColorsAnnotation) GetColors() []*ColorInfo {
	if m != nil {
		return m.Colors
	}
	return nil
}

// Stores image properties, such as dominant colors.
type ImageProperties struct {
	// If present, dominant colors completed successfully.
	DominantColors *DominantColorsAnnotation `protobuf:"bytes,1,opt,name=dominant_colors,json=dominantColors" json:"dominant_colors,omitempty"`
}

func (m *ImageProperties) Reset()                    { *m = ImageProperties{} }
func (m *ImageProperties) String() string            { return proto.CompactTextString(m) }
func (*ImageProperties) ProtoMessage()               {}
func (*ImageProperties) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *ImageProperties) GetDominantColors() *DominantColorsAnnotation {
	if m != nil {
		return m.DominantColors
	}
	return nil
}

// Single crop hint that is used to generate a new crop when serving an image.
type CropHint struct {
	// The bounding polygon for the crop region. The coordinates of the bounding
	// box are in the original image's scale, as returned in `ImageParams`.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly" json:"bounding_poly,omitempty"`
	// Confidence of this being a salient region.  Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
	// Fraction of importance of this salient region with respect to the original
	// image.
	ImportanceFraction float32 `protobuf:"fixed32,3,opt,name=importance_fraction,json=importanceFraction" json:"importance_fraction,omitempty"`
}

func (m *CropHint) Reset()                    { *m = CropHint{} }
func (m *CropHint) String() string            { return proto.CompactTextString(m) }
func (*CropHint) ProtoMessage()               {}
func (*CropHint) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *CropHint) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *CropHint) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *CropHint) GetImportanceFraction() float32 {
	if m != nil {
		return m.ImportanceFraction
	}
	return 0
}

// Set of crop hints that are used to generate new crops when serving images.
type CropHintsAnnotation struct {
	CropHints []*CropHint `protobuf:"bytes,1,rep,name=crop_hints,json=cropHints" json:"crop_hints,omitempty"`
}

func (m *CropHintsAnnotation) Reset()                    { *m = CropHintsAnnotation{} }
func (m *CropHintsAnnotation) String() string            { return proto.CompactTextString(m) }
func (*CropHintsAnnotation) ProtoMessage()               {}
func (*CropHintsAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *CropHintsAnnotation) GetCropHints() []*CropHint {
	if m != nil {
		return m.CropHints
	}
	return nil
}

// Parameters for crop hints annotation request.
type CropHintsParams struct {
	// Aspect ratios in floats, representing the ratio of the width to the height
	// of the image. For example, if the desired aspect ratio is 4/3, the
	// corresponding float value should be 1.33333.  If not specified, the
	// best possible crop is returned. The number of provided aspect ratios is
	// limited to a maximum of 16; any aspect ratios provided after the 16th are
	// ignored.
	AspectRatios []float32 `protobuf:"fixed32,1,rep,packed,name=aspect_ratios,json=aspectRatios" json:"aspect_ratios,omitempty"`
}

func (m *CropHintsParams) Reset()                    { *m = CropHintsParams{} }
func (m *CropHintsParams) String() string            { return proto.CompactTextString(m) }
func (*CropHintsParams) ProtoMessage()               {}
func (*CropHintsParams) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *CropHintsParams) GetAspectRatios() []float32 {
	if m != nil {
		return m.AspectRatios
	}
	return nil
}

// Image context and/or feature-specific parameters.
type ImageContext struct {
	// lat/long rectangle that specifies the location of the image.
	LatLongRect *LatLongRect `protobuf:"bytes,1,opt,name=lat_long_rect,json=latLongRect" json:"lat_long_rect,omitempty"`
	// List of languages to use for TEXT_DETECTION. In most cases, an empty value
	// yields the best results since it enables automatic language detection. For
	// languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Text detection returns an
	// error if one or more of the specified languages is not one of the
	// [supported languages](/vision/docs/languages).
	LanguageHints []string `protobuf:"bytes,2,rep,name=language_hints,json=languageHints" json:"language_hints,omitempty"`
	// Parameters for crop hints annotation request.
	CropHintsParams *CropHintsParams `protobuf:"bytes,4,opt,name=crop_hints_params,json=cropHintsParams" json:"crop_hints_params,omitempty"`
}

func (m *ImageContext) Reset()                    { *m = ImageContext{} }
func (m *ImageContext) String() string            { return proto.CompactTextString(m) }
func (*ImageContext) ProtoMessage()               {}
func (*ImageContext) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *ImageContext) GetLatLongRect() *LatLongRect {
	if m != nil {
		return m.LatLongRect
	}
	return nil
}

func (m *ImageContext) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

func (m *ImageContext) GetCropHintsParams() *CropHintsParams {
	if m != nil {
		return m.CropHintsParams
	}
	return nil
}

// Request for performing Google Cloud Vision API tasks over a user-provided
// image, with user-requested features.
type AnnotateImageRequest struct {
	// The image to be processed.
	Image *Image `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	// Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features" json:"features,omitempty"`
	// Additional context that may accompany the image.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext" json:"image_context,omitempty"`
}

func (m *AnnotateImageRequest) Reset()                    { *m = AnnotateImageRequest{} }
func (m *AnnotateImageRequest) String() string            { return proto.CompactTextString(m) }
func (*AnnotateImageRequest) ProtoMessage()               {}
func (*AnnotateImageRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *AnnotateImageRequest) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *AnnotateImageRequest) GetFeatures() []*Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateImageRequest) GetImageContext() *ImageContext {
	if m != nil {
		return m.ImageContext
	}
	return nil
}

// Response to an image annotation request.
type AnnotateImageResponse struct {
	// If present, face detection has completed successfully.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,1,rep,name=face_annotations,json=faceAnnotations" json:"face_annotations,omitempty"`
	// If present, landmark detection has completed successfully.
	LandmarkAnnotations []*EntityAnnotation `protobuf:"bytes,2,rep,name=landmark_annotations,json=landmarkAnnotations" json:"landmark_annotations,omitempty"`
	// If present, logo detection has completed successfully.
	LogoAnnotations []*EntityAnnotation `protobuf:"bytes,3,rep,name=logo_annotations,json=logoAnnotations" json:"logo_annotations,omitempty"`
	// If present, label detection has completed successfully.
	LabelAnnotations []*EntityAnnotation `protobuf:"bytes,4,rep,name=label_annotations,json=labelAnnotations" json:"label_annotations,omitempty"`
	// If present, text (OCR) detection or document (OCR) text detection has
	// completed successfully.
	TextAnnotations []*EntityAnnotation `protobuf:"bytes,5,rep,name=text_annotations,json=textAnnotations" json:"text_annotations,omitempty"`
	// If present, text (OCR) detection or document (OCR) text detection has
	// completed successfully.
	// This annotation provides the structural hierarchy for the OCR detected
	// text.
	FullTextAnnotation *TextAnnotation `protobuf:"bytes,12,opt,name=full_text_annotation,json=fullTextAnnotation" json:"full_text_annotation,omitempty"`
	// If present, safe-search annotation has completed successfully.
	SafeSearchAnnotation *SafeSearchAnnotation `protobuf:"bytes,6,opt,name=safe_search_annotation,json=safeSearchAnnotation" json:"safe_search_annotation,omitempty"`
	// If present, image properties were extracted successfully.
	ImagePropertiesAnnotation *ImageProperties `protobuf:"bytes,8,opt,name=image_properties_annotation,json=imagePropertiesAnnotation" json:"image_properties_annotation,omitempty"`
	// If present, crop hints have completed successfully.
	CropHintsAnnotation *CropHintsAnnotation `protobuf:"bytes,11,opt,name=crop_hints_annotation,json=cropHintsAnnotation" json:"crop_hints_annotation,omitempty"`
	// If present, web detection has completed successfully.
	WebDetection *WebDetection `protobuf:"bytes,13,opt,name=web_detection,json=webDetection" json:"web_detection,omitempty"`
	// If set, represents the error message for the operation.
	// Note that filled-in image annotations are guaranteed to be
	// correct, even when `error` is set.
	Error *google_rpc.Status `protobuf:"bytes,9,opt,name=error" json:"error,omitempty"`
}

func (m *AnnotateImageResponse) Reset()                    { *m = AnnotateImageResponse{} }
func (m *AnnotateImageResponse) String() string            { return proto.CompactTextString(m) }
func (*AnnotateImageResponse) ProtoMessage()               {}
func (*AnnotateImageResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func (m *AnnotateImageResponse) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLandmarkAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LandmarkAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLogoAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LogoAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLabelAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetTextAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetFullTextAnnotation() *TextAnnotation {
	if m != nil {
		return m.FullTextAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetSafeSearchAnnotation() *SafeSearchAnnotation {
	if m != nil {
		return m.SafeSearchAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetImagePropertiesAnnotation() *ImageProperties {
	if m != nil {
		return m.ImagePropertiesAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetCropHintsAnnotation() *CropHintsAnnotation {
	if m != nil {
		return m.CropHintsAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetWebDetection() *WebDetection {
	if m != nil {
		return m.WebDetection
	}
	return nil
}

func (m *AnnotateImageResponse) GetError() *google_rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Multiple image annotation requests are batched into a single service call.
type BatchAnnotateImagesRequest struct {
	// Individual image annotation requests for this batch.
	Requests []*AnnotateImageRequest `protobuf:"bytes,1,rep,name=requests" json:"requests,omitempty"`
}

func (m *BatchAnnotateImagesRequest) Reset()                    { *m = BatchAnnotateImagesRequest{} }
func (m *BatchAnnotateImagesRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesRequest) ProtoMessage()               {}
func (*BatchAnnotateImagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{18} }

func (m *BatchAnnotateImagesRequest) GetRequests() []*AnnotateImageRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Response to a batch image annotation request.
type BatchAnnotateImagesResponse struct {
	// Individual responses to image annotation requests within the batch.
	Responses []*AnnotateImageResponse `protobuf:"bytes,1,rep,name=responses" json:"responses,omitempty"`
}

func (m *BatchAnnotateImagesResponse) Reset()                    { *m = BatchAnnotateImagesResponse{} }
func (m *BatchAnnotateImagesResponse) String() string            { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesResponse) ProtoMessage()               {}
func (*BatchAnnotateImagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{19} }

func (m *BatchAnnotateImagesResponse) GetResponses() []*AnnotateImageResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

func init() {
	proto.RegisterType((*Feature)(nil), "google.cloud.vision.v1.Feature")
	proto.RegisterType((*ImageSource)(nil), "google.cloud.vision.v1.ImageSource")
	proto.RegisterType((*Image)(nil), "google.cloud.vision.v1.Image")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.vision.v1.FaceAnnotation")
	proto.RegisterType((*FaceAnnotation_Landmark)(nil), "google.cloud.vision.v1.FaceAnnotation.Landmark")
	proto.RegisterType((*LocationInfo)(nil), "google.cloud.vision.v1.LocationInfo")
	proto.RegisterType((*Property)(nil), "google.cloud.vision.v1.Property")
	proto.RegisterType((*EntityAnnotation)(nil), "google.cloud.vision.v1.EntityAnnotation")
	proto.RegisterType((*SafeSearchAnnotation)(nil), "google.cloud.vision.v1.SafeSearchAnnotation")
	proto.RegisterType((*LatLongRect)(nil), "google.cloud.vision.v1.LatLongRect")
	proto.RegisterType((*ColorInfo)(nil), "google.cloud.vision.v1.ColorInfo")
	proto.RegisterType((*DominantColorsAnnotation)(nil), "google.cloud.vision.v1.DominantColorsAnnotation")
	proto.RegisterType((*ImageProperties)(nil), "google.cloud.vision.v1.ImageProperties")
	proto.RegisterType((*CropHint)(nil), "google.cloud.vision.v1.CropHint")
	proto.RegisterType((*CropHintsAnnotation)(nil), "google.cloud.vision.v1.CropHintsAnnotation")
	proto.RegisterType((*CropHintsParams)(nil), "google.cloud.vision.v1.CropHintsParams")
	proto.RegisterType((*ImageContext)(nil), "google.cloud.vision.v1.ImageContext")
	proto.RegisterType((*AnnotateImageRequest)(nil), "google.cloud.vision.v1.AnnotateImageRequest")
	proto.RegisterType((*AnnotateImageResponse)(nil), "google.cloud.vision.v1.AnnotateImageResponse")
	proto.RegisterType((*BatchAnnotateImagesRequest)(nil), "google.cloud.vision.v1.BatchAnnotateImagesRequest")
	proto.RegisterType((*BatchAnnotateImagesResponse)(nil), "google.cloud.vision.v1.BatchAnnotateImagesResponse")
	proto.RegisterEnum("google.cloud.vision.v1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.cloud.vision.v1.Feature_Type", Feature_Type_name, Feature_Type_value)
	proto.RegisterEnum("google.cloud.vision.v1.FaceAnnotation_Landmark_Type", FaceAnnotation_Landmark_Type_name, FaceAnnotation_Landmark_Type_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ImageAnnotator service

type ImageAnnotatorClient interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error)
}

type imageAnnotatorClient struct {
	cc *grpc.ClientConn
}

func NewImageAnnotatorClient(cc *grpc.ClientConn) ImageAnnotatorClient {
	return &imageAnnotatorClient{cc}
}

func (c *imageAnnotatorClient) BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error) {
	out := new(BatchAnnotateImagesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateImages", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ImageAnnotator service

type ImageAnnotatorServer interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error)
}

func RegisterImageAnnotatorServer(s *grpc.Server, srv ImageAnnotatorServer) {
	s.RegisterService(&_ImageAnnotator_serviceDesc, srv)
}

func _ImageAnnotator_BatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, req.(*BatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageAnnotator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1.ImageAnnotator",
	HandlerType: (*ImageAnnotatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchAnnotateImages",
			Handler:    _ImageAnnotator_BatchAnnotateImages_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1/image_annotator.proto",
}

func init() { proto.RegisterFile("google/cloud/vision/v1/image_annotator.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 2281 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x59, 0x4b, 0x73, 0x23, 0x49,
	0xf1, 0x5f, 0xc9, 0x2f, 0x29, 0xf5, 0x6a, 0x97, 0x1f, 0xa3, 0xb1, 0xe7, 0xe1, 0xed, 0xfd, 0xcf,
	0x1f, 0xc7, 0x30, 0xd8, 0x8c, 0x67, 0x21, 0x96, 0x9d, 0x09, 0x40, 0x92, 0xdb, 0xb6, 0x62, 0x64,
	0x49, 0x5b, 0x92, 0xd7, 0x6b, 0x20, 0xe8, 0x68, 0xb7, 0x4a, 0x9a, 0x9e, 0x6d, 0x75, 0x35, 0xdd,
	0xad, 0x19, 0xfb, 0x4a, 0x04, 0x11, 0xdc, 0xb9, 0x73, 0xe4, 0x4e, 0x04, 0x5f, 0x81, 0x03, 0x47,
	0x62, 0xcf, 0xdc, 0xf8, 0x0c, 0x04, 0x47, 0xa2, 0x1e, 0xdd, 0x2a, 0x69, 0x2c, 0x8f, 0x4c, 0x70,
	0x52, 0x57, 0x66, 0xfe, 0x7e, 0x59, 0x95, 0x55, 0x59, 0x59, 0x55, 0x82, 0x67, 0x03, 0x4a, 0x07,
	0x2e, 0xd9, 0xb7, 0x5d, 0x3a, 0xea, 0xed, 0xbf, 0x73, 0x42, 0x87, 0x7a, 0xfb, 0xef, 0x9e, 0xef,
	0x3b, 0x43, 0x6b, 0x40, 0x4c, 0xcb, 0xf3, 0x68, 0x64, 0x45, 0x34, 0xd8, 0xf3, 0x03, 0x1a, 0x51,
	0xb4, 0x29, 0xac, 0xf7, 0xb8, 0xf5, 0x9e, 0xb0, 0xde, 0x7b, 0xf7, 0x7c, 0xeb, 0x81, 0x64, 0xb1,
	0x7c, 0x67, 0x5f, 0x62, 0x1c, 0xea, 0x85, 0x02, 0xb5, 0xf5, 0x64, 0x86, 0x8f, 0x01, 0xa1, 0x43,
	0x12, 0x05, 0xd7, 0xd2, 0x6c, 0x56, 0x57, 0x22, 0x72, 0x15, 0x99, 0x63, 0x56, 0x69, 0xfd, 0x74,
	0x86, 0xf5, 0x7b, 0x72, 0x69, 0xf6, 0x48, 0x44, 0x6c, 0xc5, 0xf6, 0x9e, 0xb4, 0x0d, 0x7c, 0x7b,
	0x3f, 0x8c, 0xac, 0x68, 0x14, 0x4e, 0x29, 0xa2, 0x6b, 0x9f, 0xec, 0xdb, 0xd4, 0x8d, 0x07, 0xba,
	0x55, 0x56, 0x15, 0xae, 0x15, 0xb9, 0xde, 0x40, 0x68, 0xf4, 0x7f, 0xa4, 0x61, 0xe5, 0x88, 0x58,
	0xd1, 0x28, 0x20, 0xe8, 0x0b, 0x58, 0x64, 0x06, 0xe5, 0xd4, 0x4e, 0x6a, 0xb7, 0x78, 0xf0, 0x7f,
	0x7b, 0x37, 0x47, 0x67, 0x4f, 0x9a, 0xef, 0x75, 0xaf, 0x7d, 0x82, 0x39, 0x02, 0x3d, 0x86, 0xdc,
	0xd0, 0xba, 0x32, 0x03, 0x12, 0x8e, 0xdc, 0x28, 0x2c, 0xa7, 0x77, 0x52, 0xbb, 0x4b, 0x18, 0x86,
	0xd6, 0x15, 0x16, 0x12, 0xfd, 0x5f, 0x29, 0x58, 0x64, 0xf6, 0x68, 0x1d, 0xb4, 0xee, 0x45, 0xdb,
	0x30, 0xcf, 0x9a, 0x9d, 0xb6, 0x51, 0xab, 0x1f, 0xd5, 0x8d, 0x43, 0xed, 0x13, 0x84, 0xa0, 0x78,
	0x54, 0xa9, 0x19, 0xe6, 0xa1, 0xd1, 0x35, 0x6a, 0xdd, 0x7a, 0xab, 0xa9, 0xa5, 0xd0, 0x26, 0xa0,
	0x46, 0xa5, 0x79, 0x78, 0x5a, 0xc1, 0xaf, 0x15, 0x79, 0x9a, 0xd9, 0x36, 0x5a, 0xc7, 0x2d, 0x45,
	0xb6, 0x80, 0xd6, 0xa0, 0xd4, 0xa8, 0x54, 0x8d, 0x86, 0x22, 0x5c, 0x64, 0x86, 0x5d, 0xe3, 0x9b,
	0xae, 0x22, 0x5b, 0x42, 0xdb, 0x70, 0xef, 0xb0, 0x55, 0x3b, 0x3b, 0x35, 0x9a, 0x5d, 0x73, 0x4a,
	0x99, 0x43, 0xf7, 0x61, 0xa3, 0x53, 0x39, 0x32, 0xcc, 0x8e, 0x51, 0xc1, 0xb5, 0x13, 0x45, 0xb5,
	0xcc, 0xba, 0x5d, 0x3f, 0xad, 0x1c, 0x1b, 0x66, 0x1b, 0xb7, 0xda, 0x06, 0xee, 0xd6, 0x8d, 0x8e,
	0xb6, 0x82, 0x8a, 0x00, 0x35, 0xdc, 0x6a, 0x9b, 0x27, 0xf5, 0x66, 0xb7, 0xa3, 0x65, 0xd1, 0x2a,
	0x14, 0xce, 0x8d, 0xaa, 0x02, 0x04, 0xbd, 0x09, 0xb9, 0x3a, 0x5b, 0x7b, 0x1d, 0x3a, 0x0a, 0x6c,
	0x82, 0x74, 0x28, 0x0c, 0xec, 0xd0, 0x14, 0xcb, 0x71, 0x14, 0x38, 0x3c, 0xd6, 0x59, 0x9c, 0x1b,
	0xd8, 0x21, 0x37, 0x3b, 0x0b, 0x1c, 0xb4, 0x0d, 0xd9, 0xb1, 0x3e, 0xcd, 0xf5, 0x19, 0x47, 0x2a,
	0xf5, 0x5f, 0xc3, 0x12, 0x37, 0x44, 0x65, 0x58, 0xb1, 0xa9, 0x17, 0x11, 0x2f, 0xe2, 0x1c, 0x79,
	0x1c, 0x37, 0xd1, 0x4b, 0x58, 0x0e, 0xb9, 0x37, 0x0e, 0xce, 0x1d, 0x7c, 0x36, 0x6b, 0x22, 0x95,
	0x8e, 0x61, 0x09, 0xd1, 0xff, 0x5e, 0x82, 0xe2, 0x91, 0x65, 0x93, 0x4a, 0xb2, 0x40, 0x51, 0x1d,
	0x0a, 0x97, 0x74, 0xe4, 0xf5, 0x1c, 0x6f, 0x60, 0xfa, 0xd4, 0xbd, 0xe6, 0xfe, 0x72, 0xb3, 0xd7,
	0x47, 0x55, 0x1a, 0xb7, 0xa9, 0x7b, 0x8d, 0xf3, 0x97, 0x4a, 0x0b, 0x35, 0x41, 0xeb, 0xf7, 0xcc,
	0x49, 0xb6, 0xf4, 0x1d, 0xd8, 0x8a, 0xfd, 0x9e, 0xda, 0x46, 0xa7, 0x90, 0x75, 0x2d, 0xaf, 0x37,
	0xb4, 0x82, 0x6f, 0xc3, 0xf2, 0xc2, 0xce, 0xc2, 0x6e, 0xee, 0x60, 0x7f, 0xe6, 0xb2, 0x9d, 0x18,
	0xd5, 0x5e, 0x43, 0xe2, 0xf0, 0x98, 0x01, 0x3d, 0x04, 0x08, 0xa8, 0xeb, 0x9a, 0x96, 0x37, 0x70,
	0x49, 0x79, 0x71, 0x27, 0xb5, 0x9b, 0xc6, 0x59, 0x26, 0xa9, 0x30, 0x01, 0x9b, 0x18, 0xdf, 0xf2,
	0xa4, 0x76, 0x89, 0x6b, 0x33, 0xbe, 0xe5, 0x09, 0xe5, 0x43, 0x80, 0xc8, 0x71, 0x23, 0xa9, 0x5d,
	0x16, 0x58, 0x26, 0x11, 0xea, 0xe7, 0xb0, 0x9e, 0xa4, 0xb1, 0x69, 0x53, 0xaf, 0xef, 0xf4, 0x88,
	0x67, 0x93, 0xf2, 0x0a, 0x37, 0x5c, 0x4b, 0x74, 0xb5, 0x44, 0x85, 0x7e, 0x04, 0x9b, 0x71, 0xd7,
	0x58, 0xb0, 0x14, 0x50, 0x86, 0x83, 0x36, 0x14, 0xad, 0x02, 0xab, 0x43, 0xf1, 0x2d, 0xbd, 0x36,
	0x5d, 0xe7, 0x5b, 0xe2, 0x3a, 0x6f, 0x28, 0xed, 0x95, 0xb3, 0x3c, 0x9f, 0xf5, 0x59, 0x81, 0x69,
	0x24, 0x96, 0xb8, 0xf0, 0x96, 0x5e, 0x8f, 0x9b, 0xa8, 0x05, 0xab, 0x21, 0x0d, 0x02, 0xfa, 0x5e,
	0x65, 0x83, 0xb9, 0xd9, 0x34, 0x01, 0x56, 0x08, 0x4f, 0x41, 0xb3, 0xbc, 0x01, 0x09, 0x54, 0xbe,
	0xdc, 0xdc, 0x7c, 0x25, 0x8e, 0x55, 0xe8, 0x3a, 0xb0, 0x16, 0x8e, 0x02, 0x3f, 0x70, 0x42, 0xa2,
	0x32, 0xe6, 0xe7, 0x66, 0x44, 0x31, 0x5c, 0x21, 0xfd, 0x15, 0x94, 0x47, 0x5e, 0x8f, 0x04, 0x26,
	0xb9, 0xf2, 0x69, 0x48, 0x7a, 0x2a, 0x73, 0x61, 0x6e, 0xe6, 0x4d, 0xce, 0x61, 0x08, 0x0a, 0x85,
	0xfd, 0x2b, 0x40, 0x97, 0xee, 0x28, 0x08, 0x26, 0x79, 0x8b, 0x73, 0xf3, 0xae, 0x4a, 0xf4, 0x64,
	0x14, 0xde, 0x10, 0xab, 0xf7, 0x9e, 0x58, 0x13, 0x71, 0x2d, 0xcd, 0x1f, 0x85, 0x18, 0x3e, 0x96,
	0x6d, 0xfd, 0x6d, 0x05, 0x32, 0x71, 0x8a, 0xa0, 0x13, 0x59, 0x18, 0x16, 0x38, 0xe5, 0xe7, 0x77,
	0xcc, 0x30, 0xb5, 0x50, 0xbc, 0x82, 0x8c, 0x4f, 0x43, 0x87, 0xe9, 0x79, 0x7e, 0xe5, 0x0e, 0x76,
	0x66, 0xb1, 0xb5, 0xa5, 0x1d, 0x4e, 0x10, 0xfa, 0x5f, 0x96, 0xc7, 0x55, 0xe4, 0xac, 0xf9, 0xba,
	0xd9, 0x3a, 0x6f, 0x9a, 0x71, 0x8d, 0xd0, 0x3e, 0x41, 0x79, 0xc8, 0x34, 0x8c, 0xa3, 0xae, 0x69,
	0x5c, 0x18, 0x5a, 0x0a, 0x15, 0x20, 0x8b, 0xeb, 0xc7, 0x27, 0xa2, 0x99, 0x46, 0x65, 0x58, 0xe7,
	0xca, 0xd6, 0x91, 0x19, 0x1b, 0x55, 0x71, 0xeb, 0x5c, 0x5b, 0x60, 0xdb, 0xbe, 0x30, 0x9c, 0x56,
	0x2d, 0x32, 0x55, 0x0c, 0x4a, 0xb8, 0xb8, 0x6a, 0x09, 0x6d, 0xc1, 0x66, 0x82, 0x9a, 0xd4, 0x2d,
	0x33, 0xd8, 0x69, 0xfd, 0xb0, 0xdd, 0xaa, 0x37, 0xbb, 0x66, 0xd5, 0xe8, 0x9e, 0x1b, 0x46, 0x93,
	0x69, 0x59, 0xc9, 0xc8, 0x43, 0xa6, 0xd9, 0xea, 0x18, 0x66, 0xb7, 0xde, 0xd6, 0x32, 0xac, 0x8f,
	0x67, 0xed, 0xb6, 0x81, 0xcd, 0x46, 0xbd, 0xad, 0x65, 0x59, 0xb3, 0xd1, 0x3a, 0x97, 0x4d, 0x60,
	0xe5, 0xe5, 0xb4, 0x75, 0xd6, 0x3d, 0xe1, 0xbd, 0xd2, 0x72, 0xa8, 0x04, 0x39, 0xd1, 0xe6, 0xfe,
	0xb4, 0x3c, 0xd2, 0x20, 0x2f, 0x04, 0x35, 0xa3, 0xd9, 0x35, 0xb0, 0x56, 0x40, 0x1b, 0xb0, 0xca,
	0xe9, 0xab, 0xad, 0x6e, 0xb7, 0x75, 0x2a, 0x0d, 0x8b, 0x2c, 0x5e, 0xaa, 0x98, 0xf3, 0x95, 0x58,
	0x85, 0x55, 0xa5, 0x92, 0x44, 0x4b, 0x46, 0x6d, 0x5c, 0x18, 0x66, 0xb7, 0xd5, 0x36, 0xab, 0xad,
	0xb3, 0xe6, 0x61, 0x05, 0x5f, 0x68, 0xab, 0x13, 0x2a, 0x31, 0xea, 0x5a, 0x0b, 0x37, 0x0d, 0xac,
	0x21, 0xf4, 0x00, 0xca, 0x89, 0x4a, 0x32, 0x26, 0xc0, 0xb5, 0x24, 0xfc, 0x4c, 0xcb, 0x3f, 0x24,
	0x6e, 0x7d, 0x1c, 0xc8, 0x0f, 0xdc, 0x6d, 0x4c, 0xea, 0x26, 0xfc, 0x6d, 0xa2, 0x87, 0x70, 0x7f,
	0xac, 0x9b, 0x76, 0x78, 0x6f, 0x3c, 0xab, 0xd3, 0x1e, 0xcb, 0xe8, 0x31, 0x6c, 0xab, 0xf3, 0x6c,
	0x8a, 0x29, 0x88, 0x67, 0x4c, 0xbb, 0x8f, 0x76, 0xe0, 0xc1, 0xc4, 0x94, 0x4e, 0x5b, 0x6c, 0xb1,
	0x80, 0x0a, 0x8a, 0x0a, 0x36, 0xbb, 0xb8, 0x72, 0xcc, 0x8a, 0xfd, 0x36, 0x8b, 0xbe, 0xc4, 0x29,
	0xe2, 0x07, 0xfc, 0xc4, 0x12, 0x8f, 0xbd, 0x7d, 0xd6, 0xae, 0x37, 0xb4, 0x87, 0xec, 0xc4, 0x32,
	0xee, 0x9e, 0x10, 0x3e, 0x62, 0xf8, 0xa3, 0x16, 0x36, 0x4e, 0x8c, 0xca, 0xa1, 0x79, 0xcc, 0x0f,
	0x34, 0x8d, 0x8a, 0xf6, 0x98, 0x1d, 0x2b, 0x6a, 0x27, 0xf5, 0xa6, 0x79, 0xdc, 0xac, 0x74, 0x4f,
	0x18, 0xe5, 0x0e, 0xf3, 0xcf, 0x45, 0x9c, 0xf7, 0xb8, 0xd5, 0x64, 0xd2, 0x4f, 0x19, 0x9e, 0x4b,
	0x05, 0xb3, 0x14, 0xeb, 0xfa, 0x2b, 0xc8, 0x37, 0xa8, 0xcd, 0x93, 0xb2, 0xee, 0xf5, 0x29, 0x7a,
	0x06, 0x2b, 0xae, 0x15, 0x99, 0xae, 0x37, 0x90, 0xa5, 0x7c, 0x2d, 0xce, 0x41, 0x96, 0xa3, 0x7b,
	0x0d, 0x2b, 0x6a, 0x78, 0x03, 0xbc, 0xec, 0xf2, 0x5f, 0xfd, 0x73, 0xc8, 0xb4, 0x03, 0xea, 0x93,
	0x20, 0xba, 0x46, 0x08, 0x16, 0x3d, 0x6b, 0x48, 0xe4, 0xa9, 0x85, 0x7f, 0xa3, 0x75, 0x58, 0x7a,
	0x67, 0xb9, 0x23, 0x22, 0x8f, 0x2a, 0xa2, 0xa1, 0xff, 0x6e, 0x01, 0x34, 0xc3, 0x8b, 0x9c, 0xe8,
	0x5a, 0x39, 0x49, 0x68, 0xb0, 0x30, 0x74, 0x7a, 0x12, 0xcd, 0x3e, 0xd1, 0x26, 0x2c, 0xbb, 0xd4,
	0xb6, 0xdc, 0x18, 0x2d, 0x5b, 0x68, 0x07, 0x72, 0x3d, 0x12, 0xda, 0x81, 0xe3, 0xf3, 0xad, 0x62,
	0x41, 0x9c, 0x92, 0x14, 0x11, 0x73, 0x1b, 0xda, 0x34, 0x88, 0xcb, 0xb4, 0x68, 0xa0, 0x47, 0x00,
	0x4a, 0x9d, 0x14, 0x35, 0x5a, 0x91, 0x30, 0x7d, 0x44, 0x7d, 0xc7, 0xb6, 0x5c, 0x27, 0xba, 0x96,
	0x55, 0x5a, 0x91, 0x7c, 0x78, 0xd6, 0x59, 0xf9, 0xaf, 0xcf, 0x3a, 0x55, 0xc8, 0xba, 0x32, 0xea,
	0x61, 0x39, 0xc3, 0xcf, 0x26, 0x33, 0x69, 0xd4, 0xe9, 0xc1, 0x63, 0x18, 0xfa, 0x39, 0x80, 0x2f,
	0x62, 0xef, 0x90, 0xb0, 0x9c, 0xe5, 0x24, 0xb3, 0x37, 0x4c, 0x39, 0x4b, 0x58, 0xc1, 0xe8, 0xbf,
	0x4f, 0xc3, 0x7a, 0xc7, 0xea, 0x93, 0x0e, 0xb1, 0x02, 0xfb, 0x8d, 0x32, 0x17, 0x5f, 0xc0, 0x92,
	0xd5, 0x1b, 0xb9, 0x91, 0x3c, 0xed, 0xcf, 0x53, 0x27, 0x04, 0x80, 0x21, 0x43, 0x9f, 0xd2, 0x3e,
	0x9f, 0xb2, 0x39, 0x91, 0x1c, 0x80, 0x5e, 0xc1, 0xca, 0x90, 0xf4, 0x58, 0xac, 0x65, 0x29, 0x99,
	0x07, 0x1b, 0x43, 0xd0, 0x4f, 0x21, 0xf3, 0xce, 0xa1, 0x2e, 0x9f, 0xd9, 0xc5, 0xb9, 0xe1, 0x09,
	0x46, 0x7f, 0x0f, 0x39, 0xb6, 0xb4, 0xa9, 0x37, 0xc0, 0xc4, 0x8e, 0xd0, 0x0b, 0xc8, 0x0d, 0x1d,
	0xcf, 0x9c, 0x23, 0x13, 0xb2, 0x43, 0xc7, 0x13, 0x9f, 0x1c, 0x64, 0x5d, 0x25, 0xa0, 0xf4, 0x6d,
	0x20, 0xeb, 0x4a, 0x7c, 0xea, 0x01, 0x64, 0x6b, 0xec, 0x32, 0xc6, 0x93, 0x6f, 0x17, 0x96, 0xf8,
	0xcd, 0x4c, 0x3a, 0x44, 0x13, 0x58, 0x6e, 0x86, 0x85, 0xc1, 0x78, 0x85, 0xa7, 0xd5, 0x15, 0xfe,
	0x04, 0x8a, 0xbe, 0x73, 0x45, 0x5c, 0xb3, 0x1f, 0x58, 0x76, 0x92, 0x1c, 0x69, 0x5c, 0xe0, 0xd2,
	0x23, 0x29, 0xd4, 0xcf, 0xa0, 0x7c, 0x48, 0x87, 0x8e, 0x67, 0x79, 0x11, 0x27, 0x0d, 0x95, 0xa9,
	0xff, 0x09, 0x2c, 0x73, 0x0f, 0x61, 0x39, 0xc5, 0x57, 0xd4, 0xa7, 0xb3, 0xc2, 0x98, 0xf4, 0x1a,
	0x4b, 0x80, 0xee, 0x42, 0x89, 0xdf, 0x1a, 0xda, 0xc9, 0x0a, 0x43, 0x17, 0x50, 0xea, 0x49, 0x4f,
	0x66, 0x42, 0xcb, 0x86, 0xf6, 0xc3, 0x59, 0xb4, 0xb3, 0x3a, 0x86, 0x8b, 0xbd, 0x09, 0x8d, 0xfe,
	0xa7, 0x14, 0x64, 0x6a, 0x01, 0xf5, 0x4f, 0x1c, 0x2f, 0xfa, 0x5f, 0x5e, 0x43, 0x26, 0x77, 0x89,
	0xf4, 0x07, 0xbb, 0xc4, 0x3e, 0xac, 0x39, 0x43, 0x9f, 0x06, 0x91, 0xe5, 0xd9, 0x64, 0x3a, 0xd0,
	0x68, 0xac, 0x4a, 0xa2, 0xfd, 0x35, 0xac, 0xc5, 0xfd, 0x54, 0x03, 0xfd, 0x33, 0x00, 0x3b, 0xa0,
	0xbe, 0xf9, 0x86, 0xc9, 0x65, 0xb0, 0x67, 0xa6, 0x6f, 0x4c, 0x80, 0xb3, 0x76, 0x4c, 0xa5, 0xff,
	0x18, 0x4a, 0x09, 0x6f, 0xdb, 0x0a, 0xac, 0x61, 0x88, 0x3e, 0x83, 0x82, 0x15, 0xfa, 0xc4, 0x8e,
	0xcc, 0x80, 0x39, 0x11, 0xb4, 0x69, 0x9c, 0x17, 0x42, 0xcc, 0x65, 0xfa, 0x77, 0x29, 0xc8, 0xf3,
	0x79, 0xaa, 0xb1, 0x3b, 0xe1, 0x55, 0x84, 0x8e, 0xa1, 0xc0, 0xd7, 0x2c, 0xf5, 0x06, 0x66, 0x40,
	0xec, 0x48, 0x06, 0x6f, 0xe6, 0xd5, 0x50, 0x49, 0x14, 0x9c, 0x73, 0x95, 0xac, 0x79, 0x02, 0x45,
	0xd7, 0xf2, 0x06, 0x23, 0x76, 0x3f, 0x15, 0xc3, 0x4a, 0xef, 0x2c, 0xec, 0x66, 0x71, 0x21, 0x96,
	0xf2, 0xbe, 0xa2, 0x0e, 0xac, 0x8e, 0x47, 0x6e, 0xfa, 0xbc, 0xeb, 0xf2, 0xc0, 0xf7, 0xbd, 0x8f,
	0x05, 0x40, 0x8e, 0x14, 0x97, 0xec, 0x49, 0x01, 0x1b, 0xd5, 0xba, 0x8c, 0x2e, 0xe1, 0xa3, 0xc3,
	0xe4, 0x37, 0x23, 0x12, 0xb2, 0x54, 0x5e, 0xe2, 0x17, 0x64, 0x39, 0xaa, 0x87, 0xb7, 0x5e, 0x78,
	0xb1, 0xb0, 0x45, 0x2f, 0x21, 0xd3, 0x17, 0x2f, 0x19, 0x62, 0x0c, 0xb9, 0x83, 0xc7, 0x1f, 0x79,
	0xf1, 0xc0, 0x09, 0x80, 0x2d, 0x46, 0x71, 0x47, 0xb7, 0x45, 0x80, 0xf9, 0xda, 0xb8, 0x65, 0x31,
	0xaa, 0x93, 0x81, 0xf3, 0x8e, 0xd2, 0xd2, 0xff, 0xba, 0x02, 0x1b, 0x53, 0xa3, 0x0a, 0x7d, 0xea,
	0x85, 0x04, 0x7d, 0x05, 0x5a, 0xdf, 0xb2, 0x89, 0xf2, 0x58, 0x14, 0x2f, 0xa2, 0xff, 0x9f, 0xef,
	0x08, 0x8e, 0x4b, 0xfd, 0x89, 0x76, 0x88, 0x7e, 0x09, 0xeb, 0xf1, 0xad, 0x71, 0x82, 0x56, 0x04,
	0x60, 0x77, 0x16, 0xed, 0x74, 0x25, 0xc7, 0x6b, 0x31, 0x8b, 0x4a, 0xde, 0x01, 0xcd, 0xa5, 0x03,
	0x3a, 0x41, 0xbc, 0x70, 0x47, 0xe2, 0x12, 0x63, 0x50, 0x49, 0xcf, 0x60, 0xd5, 0xb5, 0x2e, 0x89,
	0x3b, 0xc1, 0xba, 0x78, 0x47, 0x56, 0x8d, 0x53, 0x4c, 0xf5, 0x75, 0xea, 0x21, 0x2e, 0x2c, 0x2f,
	0xdd, 0xb5, 0xaf, 0x8c, 0x41, 0x25, 0xfd, 0x06, 0xd6, 0xfb, 0x23, 0xd7, 0x35, 0xa7, 0x98, 0xf9,
	0x85, 0xf4, 0x96, 0x49, 0xeb, 0x4e, 0xd0, 0x60, 0xc4, 0x38, 0x26, 0x65, 0xe8, 0x12, 0x36, 0x43,
	0xab, 0x4f, 0xcc, 0x90, 0x97, 0x71, 0x95, 0x7b, 0x99, 0x73, 0x3f, 0x9b, 0xc5, 0x7d, 0x53, 0xed,
	0xc7, 0xeb, 0xe1, 0x4d, 0x27, 0x82, 0x01, 0x6c, 0x8b, 0x35, 0x3d, 0x3e, 0x3e, 0xa8, 0x8e, 0x32,
	0xb7, 0x67, 0xef, 0x54, 0x59, 0xc0, 0xf7, 0x9d, 0x49, 0x81, 0xe2, 0xc8, 0x84, 0x0d, 0x65, 0x73,
	0x50, 0x5c, 0xe4, 0xb8, 0x8b, 0xef, 0x7f, 0x74, 0x83, 0x50, 0x17, 0xa2, 0x7d, 0xc3, 0xbe, 0x5b,
	0x87, 0xc2, 0xc4, 0xbb, 0x29, 0xbf, 0xb7, 0xdf, 0x92, 0x9d, 0xe7, 0xe4, 0xf2, 0x30, 0xb6, 0xc5,
	0xf9, 0xf7, 0x4a, 0x8b, 0x95, 0x6b, 0x12, 0x04, 0x34, 0xe0, 0x8f, 0x28, 0x4a, 0xb9, 0x0e, 0x7c,
	0x7b, 0xaf, 0xc3, 0xdf, 0x5e, 0xb1, 0x30, 0xd0, 0xfb, 0xb0, 0x55, 0xb5, 0xa2, 0x24, 0xa2, 0x22,
	0x97, 0xc3, 0x78, 0x8b, 0x3a, 0x81, 0x4c, 0x20, 0x3e, 0xe3, 0x1c, 0x9e, 0x39, 0x65, 0x37, 0x6d,
	0x71, 0x38, 0x41, 0xeb, 0x6f, 0x61, 0xfb, 0x46, 0x3f, 0x72, 0xd3, 0x78, 0x0d, 0xd9, 0x40, 0x7e,
	0xc7, 0x9e, 0x7e, 0x30, 0xa7, 0x27, 0x81, 0xc2, 0x63, 0xfc, 0x53, 0x02, 0xa0, 0x3c, 0x34, 0xe4,
	0x60, 0x45, 0xde, 0xba, 0xb5, 0x4f, 0xd8, 0xa5, 0xe4, 0x6b, 0x03, 0x5f, 0x98, 0x67, 0xcd, 0x46,
	0xfd, 0xb5, 0xd1, 0xb8, 0xd0, 0x52, 0xec, 0x6e, 0x9b, 0xb4, 0xd2, 0xac, 0xd5, 0x6e, 0x75, 0x3a,
	0xf5, 0x6a, 0xc3, 0xd0, 0x16, 0x10, 0xc0, 0xb2, 0xd4, 0x2c, 0xb2, 0x7b, 0x2c, 0x87, 0x4a, 0xc1,
	0xd2, 0xc1, 0x9f, 0x53, 0x50, 0xe4, 0x7d, 0xa8, 0xc4, 0x0f, 0xf4, 0xe8, 0x8f, 0x29, 0x58, 0xbb,
	0x61, 0x98, 0xe8, 0x60, 0x66, 0xb9, 0x9f, 0x19, 0xfb, 0xad, 0x17, 0x77, 0xc2, 0x88, 0xb1, 0xeb,
	0x8f, 0x7e, 0xfb, 0xdd, 0x3f, 0xff, 0x90, 0x2e, 0xeb, 0x6b, 0xc9, 0xdf, 0x07, 0xe1, 0x97, 0x72,
	0xa9, 0x92, 0x2f, 0x53, 0x4f, 0xab, 0x11, 0x6c, 0xd9, 0x74, 0x38, 0x83, 0xb9, 0xba, 0x36, 0x39,
	0x9c, 0x76, 0x40, 0x23, 0xda, 0x4e, 0xfd, 0xe2, 0x95, 0x34, 0x1f, 0x50, 0x56, 0x2e, 0xf7, 0x68,
	0x30, 0xd8, 0x1f, 0x10, 0x8f, 0xbf, 0xc4, 0xef, 0x0b, 0x95, 0xe5, 0x3b, 0xe1, 0xf4, 0x9f, 0x00,
	0x2f, 0xc5, 0xd7, 0xbf, 0x53, 0xa9, 0xcb, 0x65, 0x6e, 0xfb, 0xe2, 0x3f, 0x01, 0x00, 0x00, 0xff,
	0xff, 0xe5, 0x59, 0xbe, 0xb0, 0xe8, 0x18, 0x00, 0x00,
}
