// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/remoteexecution/v1test/remote_execution.proto

/*
Package remoteexecution is a generated protocol buffer package.

It is generated from these files:
	google/devtools/remoteexecution/v1test/remote_execution.proto

It has these top-level messages:
	Action
	Command
	Platform
	Directory
	FileNode
	DirectoryNode
	Digest
	ActionResult
	OutputFile
	OutputDirectory
	ExecuteRequest
	ExecuteResponse
	ExecuteOperationMetadata
	GetActionResultRequest
	UpdateActionResultRequest
	FindMissingBlobsRequest
	FindMissingBlobsResponse
	UpdateBlobRequest
	BatchUpdateBlobsRequest
	BatchUpdateBlobsResponse
	GetTreeRequest
	GetTreeResponse
*/
package remoteexecution

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The current stage of execution.
type ExecuteOperationMetadata_Stage int32

const (
	ExecuteOperationMetadata_UNKNOWN ExecuteOperationMetadata_Stage = 0
	// Checking the result against the cache.
	ExecuteOperationMetadata_CACHE_CHECK ExecuteOperationMetadata_Stage = 1
	// Currently idle, awaiting a free machine to execute.
	ExecuteOperationMetadata_QUEUED ExecuteOperationMetadata_Stage = 2
	// Currently being executed by a worker.
	ExecuteOperationMetadata_EXECUTING ExecuteOperationMetadata_Stage = 3
	// Finished execution.
	ExecuteOperationMetadata_COMPLETED ExecuteOperationMetadata_Stage = 4
)

var ExecuteOperationMetadata_Stage_name = map[int32]string{
	0: "UNKNOWN",
	1: "CACHE_CHECK",
	2: "QUEUED",
	3: "EXECUTING",
	4: "COMPLETED",
}
var ExecuteOperationMetadata_Stage_value = map[string]int32{
	"UNKNOWN":     0,
	"CACHE_CHECK": 1,
	"QUEUED":      2,
	"EXECUTING":   3,
	"COMPLETED":   4,
}

func (x ExecuteOperationMetadata_Stage) String() string {
	return proto.EnumName(ExecuteOperationMetadata_Stage_name, int32(x))
}
func (ExecuteOperationMetadata_Stage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{12, 0}
}

// An `Action` captures all the information about an execution which is required
// to reproduce it.
//
// `Action`s are the core component of the [Execution] service. A single
// `Action` represents a repeatable action that can be performed by the
// execution service. `Action`s can be succinctly identified by the digest of
// their wire format encoding and, once an `Action` has been executed, will be
// cached in the action cache. Future requests can then use the cached result
// rather than needing to run afresh.
//
// When a server completes execution of an [Action][google.devtools.remoteexecution.v1test.Action],
// it MAY choose to cache the [result][google.devtools.remoteexecution.v1test.ActionResult]
// in the [ActionCache][google.devtools.remoteexecution.v1test.ActionCache]
// unless `do_not_cache` is `true`. Clients SHOULD expect the server to do so.
// By default, future calls to [Execute][] the same `Action` will also serve
// their results from the cache. Clients must take care to understand the
// caching behaviour. Ideally, all `Action`s will be reproducible so that
// serving a result from cache is always desirable and correct.
type Action struct {
	// The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
	// to run, which MUST be present in the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	CommandDigest *Digest `protobuf:"bytes,1,opt,name=command_digest,json=commandDigest" json:"command_digest,omitempty"`
	// The digest of the root [Directory][google.devtools.remoteexecution.v1test.Directory]
	// for the input files. The files in the directory tree are available in the
	// correct location on the build machine before the command is executed. The
	// root directory, as well as every subdirectory and content blob referred to,
	// MUST be in the [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	InputRootDigest *Digest `protobuf:"bytes,2,opt,name=input_root_digest,json=inputRootDigest" json:"input_root_digest,omitempty"`
	// A list of the output files that the client expects to retrieve from the
	// action. Only the listed files, as well as directories listed in
	// `output_directories`, will be returned to the client as output.
	// Other files that may be created during command execution are discarded.
	//
	// The paths are specified using forward slashes (`/`) as path separators,
	// even if the execution platform natively uses a different separator. The
	// path MUST NOT include a trailing slash.
	//
	// In order to ensure consistent hashing of the same Action, the output paths
	// MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
	// bytes).
	OutputFiles []string `protobuf:"bytes,3,rep,name=output_files,json=outputFiles" json:"output_files,omitempty"`
	// A list of the output directories that the client expects to retrieve from
	// the action. Only the contents of the indicated directories (recursively
	// including the contents of their subdirectories) will be
	// returned, as well as files listed in `output_files`. Other files that may
	// be created during command execution are discarded.
	//
	// The paths are specified using forward slashes (`/`) as path separators,
	// even if the execution platform natively uses a different separator. The
	// path MUST NOT include a trailing slash, unless the path is `"/"` (which,
	// although not recommended, can be used to capture the entire working
	// directory tree, including inputs).
	//
	// In order to ensure consistent hashing of the same Action, the output paths
	// MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
	// bytes).
	OutputDirectories []string `protobuf:"bytes,4,rep,name=output_directories,json=outputDirectories" json:"output_directories,omitempty"`
	// The platform requirements for the execution environment. The server MAY
	// choose to execute the action on any worker satisfying the requirements, so
	// the client SHOULD ensure that running the action on any such worker will
	// have the same result.
	Platform *Platform `protobuf:"bytes,5,opt,name=platform" json:"platform,omitempty"`
	// A timeout after which the execution should be killed. If the timeout is
	// absent, then the client is specifying that the execution should continue
	// as long as the server will let it. The server SHOULD impose a timeout if
	// the client does not specify one, however, if the client does specify a
	// timeout that is longer than the server's maximum timeout, the server MUST
	// reject the request.
	//
	// The timeout is a part of the
	// [Action][google.devtools.remoteexecution.v1test.Action] message, and
	// therefore two `Actions` with different timeouts are different, even if they
	// are otherwise identical. This is because, if they were not, running an
	// `Action` with a lower timeout than is required might result in a cache hit
	// from an execution run with a longer timeout, hiding the fact that the
	// timeout is too short. By encoding it directly in the `Action`, a lower
	// timeout will result in a cache miss and the execution timeout will fail
	// immediately, rather than whenever the cache entry gets evicted.
	Timeout *google_protobuf3.Duration `protobuf:"bytes,6,opt,name=timeout" json:"timeout,omitempty"`
	// If true, then the `Action`'s result cannot be cached.
	DoNotCache bool `protobuf:"varint,7,opt,name=do_not_cache,json=doNotCache" json:"do_not_cache,omitempty"`
}

func (m *Action) Reset()                    { *m = Action{} }
func (m *Action) String() string            { return proto.CompactTextString(m) }
func (*Action) ProtoMessage()               {}
func (*Action) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Action) GetCommandDigest() *Digest {
	if m != nil {
		return m.CommandDigest
	}
	return nil
}

func (m *Action) GetInputRootDigest() *Digest {
	if m != nil {
		return m.InputRootDigest
	}
	return nil
}

func (m *Action) GetOutputFiles() []string {
	if m != nil {
		return m.OutputFiles
	}
	return nil
}

func (m *Action) GetOutputDirectories() []string {
	if m != nil {
		return m.OutputDirectories
	}
	return nil
}

func (m *Action) GetPlatform() *Platform {
	if m != nil {
		return m.Platform
	}
	return nil
}

func (m *Action) GetTimeout() *google_protobuf3.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *Action) GetDoNotCache() bool {
	if m != nil {
		return m.DoNotCache
	}
	return false
}

// A `Command` is the actual command executed by a worker running an
// [Action][google.devtools.remoteexecution.v1test.Action].
//
// Except as otherwise required, the environment (such as which system
// libraries or binaries are available, and what filesystems are mounted where)
// is defined by and specific to the implementation of the remote execution API.
type Command struct {
	// The arguments to the command. The first argument must be the path to the
	// executable, which must be either a relative path, in which case it is
	// evaluated with respect to the input root, or an absolute path. The `PATH`
	// environment variable, or similar functionality on other systems, is not
	// used to determine which executable to run.
	//
	// The working directory will always be the input root.
	Arguments []string `protobuf:"bytes,1,rep,name=arguments" json:"arguments,omitempty"`
	// The environment variables to set when running the program. The worker may
	// provide its own default environment variables; these defaults can be
	// overridden using this field. Additional variables can also be specified.
	//
	// In order to ensure that equivalent `Command`s always hash to the same
	// value, the environment variables MUST be lexicographically sorted by name.
	// Sorting of strings is done by code point, equivalently, by the UTF-8 bytes.
	EnvironmentVariables []*Command_EnvironmentVariable `protobuf:"bytes,2,rep,name=environment_variables,json=environmentVariables" json:"environment_variables,omitempty"`
}

func (m *Command) Reset()                    { *m = Command{} }
func (m *Command) String() string            { return proto.CompactTextString(m) }
func (*Command) ProtoMessage()               {}
func (*Command) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Command) GetArguments() []string {
	if m != nil {
		return m.Arguments
	}
	return nil
}

func (m *Command) GetEnvironmentVariables() []*Command_EnvironmentVariable {
	if m != nil {
		return m.EnvironmentVariables
	}
	return nil
}

// An `EnvironmentVariable` is one variable to set in the running program's
// environment.
type Command_EnvironmentVariable struct {
	// The variable name.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The variable value.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Command_EnvironmentVariable) Reset()                    { *m = Command_EnvironmentVariable{} }
func (m *Command_EnvironmentVariable) String() string            { return proto.CompactTextString(m) }
func (*Command_EnvironmentVariable) ProtoMessage()               {}
func (*Command_EnvironmentVariable) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 0} }

func (m *Command_EnvironmentVariable) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Command_EnvironmentVariable) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A `Platform` is a set of requirements, such as hardware, operation system, or
// compiler toolchain, for an
// [Action][google.devtools.remoteexecution.v1test.Action]'s execution
// environment. A `Platform` is represented as a series of key-value pairs
// representing the properties that are required of the platform.
//
// This message is currently being redeveloped since it is an overly simplistic
// model of platforms.
type Platform struct {
	// The properties that make up this platform. In order to ensure that
	// equivalent `Platform`s always hash to the same value, the properties MUST
	// be lexicographically sorted by name, and then by value. Sorting of strings
	// is done by code point, equivalently, by the UTF-8 bytes.
	Properties []*Platform_Property `protobuf:"bytes,1,rep,name=properties" json:"properties,omitempty"`
}

func (m *Platform) Reset()                    { *m = Platform{} }
func (m *Platform) String() string            { return proto.CompactTextString(m) }
func (*Platform) ProtoMessage()               {}
func (*Platform) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Platform) GetProperties() []*Platform_Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// A single property for the environment. The server is responsible for
// specifying the property `name`s that it accepts. If an unknown `name` is
// provided in the requirements for an
// [Action][google.devtools.remoteexecution.v1test.Action], the server SHOULD
// reject the execution request. If permitted by the server, the same `name`
// may occur multiple times.
//
// The server is also responsible for specifying the interpretation of
// property `value`s. For instance, a property describing how much RAM must be
// available may be interpreted as allowing a worker with 16GB to fulfill a
// request for 8GB, while a property describing the OS environment on which
// the action must be performed may require an exact match with the worker's
// OS.
//
// The server MAY use the `value` of one or more properties to determine how
// it sets up the execution environment, such as by making specific system
// files available to the worker.
type Platform_Property struct {
	// The property name.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The property value.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Platform_Property) Reset()                    { *m = Platform_Property{} }
func (m *Platform_Property) String() string            { return proto.CompactTextString(m) }
func (*Platform_Property) ProtoMessage()               {}
func (*Platform_Property) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

func (m *Platform_Property) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Platform_Property) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A `Directory` represents a directory node in a file tree, containing zero or
// more children [FileNodes][google.devtools.remoteexecution.v1test.FileNode] and
// [DirectoryNodes][google.devtools.remoteexecution.v1test.DirectoryNode].
// Each `Node` contains its name in the directory, the digest of its content
// (either a file blob or a `Directory` proto), as well as possibly some
// metadata about the file or directory.
//
// In order to ensure that two equivalent directory trees hash to the same
// value, the following restrictions MUST be obeyed when constructing a
// a `Directory`:
//   - Every child in the directory must have a path of exactly one segment.
//     Multiple levels of directory hierarchy may not be collapsed.
//   - Each child in the directory must have a unique path segment (file name).
//   - The files and directories in the directory must each be sorted in
//     lexicographical order by path. The path strings must be sorted by code
//     point, equivalently, by UTF-8 bytes.
//
// A `Directory` that obeys the restrictions is said to be in canonical form.
//
// As an example, the following could be used for a file named `bar` and a
// directory named `foo` with an executable file named `baz` (hashes shortened
// for readability):
//
// ```json
// // (Directory proto)
// {
//   files: [
//     {
//       name: "bar",
//       digest: {
//         hash: "4a73bc9d03...",
//         size: 65534
//       }
//     }
//   ],
//   directories: [
//     {
//       name: "foo",
//       digest: {
//         hash: "4cf2eda940...",
//         size: 43
//       }
//     }
//   ]
// }
//
// // (Directory proto with hash "4cf2eda940..." and size 43)
// {
//   files: [
//     {
//       name: "baz",
//       digest: {
//         hash: "b2c941073e...",
//         size: 1294,
//       },
//       is_executable: true
//     }
//   ]
// }
// ```
type Directory struct {
	// The files in the directory.
	Files []*FileNode `protobuf:"bytes,1,rep,name=files" json:"files,omitempty"`
	// The subdirectories in the directory.
	Directories []*DirectoryNode `protobuf:"bytes,2,rep,name=directories" json:"directories,omitempty"`
}

func (m *Directory) Reset()                    { *m = Directory{} }
func (m *Directory) String() string            { return proto.CompactTextString(m) }
func (*Directory) ProtoMessage()               {}
func (*Directory) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Directory) GetFiles() []*FileNode {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *Directory) GetDirectories() []*DirectoryNode {
	if m != nil {
		return m.Directories
	}
	return nil
}

// A `FileNode` represents a single file and associated metadata.
type FileNode struct {
	// The name of the file.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The digest of the file's content.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest" json:"digest,omitempty"`
	// True if file is executable, false otherwise.
	IsExecutable bool `protobuf:"varint,4,opt,name=is_executable,json=isExecutable" json:"is_executable,omitempty"`
}

func (m *FileNode) Reset()                    { *m = FileNode{} }
func (m *FileNode) String() string            { return proto.CompactTextString(m) }
func (*FileNode) ProtoMessage()               {}
func (*FileNode) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *FileNode) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FileNode) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

func (m *FileNode) GetIsExecutable() bool {
	if m != nil {
		return m.IsExecutable
	}
	return false
}

// A `DirectoryNode` represents a child of a
// [Directory][google.devtools.remoteexecution.v1test.Directory] which is itself
// a `Directory` and its associated metadata.
type DirectoryNode struct {
	// The name of the directory.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The digest of the [Directory][google.devtools.remoteexecution.v1test.Directory]
	// object represented. See [Digest][google.devtools.remoteexecution.v1test.Digest]
	// for information about how to take the digest of a proto message.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest" json:"digest,omitempty"`
}

func (m *DirectoryNode) Reset()                    { *m = DirectoryNode{} }
func (m *DirectoryNode) String() string            { return proto.CompactTextString(m) }
func (*DirectoryNode) ProtoMessage()               {}
func (*DirectoryNode) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *DirectoryNode) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DirectoryNode) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

// A content digest. A digest for a given blob consists of the size of the blob
// and its hash. The hash algorithm to use is defined by the server, but servers
// SHOULD use SHA-256.
//
// The size is considered to be an integral part of the digest and cannot be
// separated. That is, even if the `hash` field is correctly specified but
// `size_bytes` is not, the server MUST reject the request.
//
// The reason for including the size in the digest is as follows: in a great
// many cases, the server needs to know the size of the blob it is about to work
// with prior to starting an operation with it, such as flattening Merkle tree
// structures or streaming it to a worker. Technically, the server could
// implement a separate metadata store, but this results in a significantly more
// complicated implementation as opposed to having the client specify the size
// up-front (or storing the size along with the digest in every message where
// digests are embedded). This does mean that the API leaks some implementation
// details of (what we consider to be) a reasonable server implementation, but
// we consider this to be a worthwhile tradeoff.
//
// When a `Digest` is used to refer to a proto message, it always refers to the
// message in binary encoded form. To ensure consistent hashing, clients and
// servers MUST ensure that they serialize messages according to the following
// rules, even if there are alternate valid encodings for the same message.
// - Fields are serialized in tag order.
// - There are no unknown fields.
// - There are no duplicate fields.
// - Fields are serialized according to the default semantics for their type.
//
// Most protocol buffer implementations will always follow these rules when
// serializing, but care should be taken to avoid shortcuts. For instance,
// concatenating two messages to merge them may produce duplicate fields.
type Digest struct {
	// The hash. In the case of SHA-256, it will always be a lowercase hex string
	// exactly 64 characters long.
	Hash string `protobuf:"bytes,1,opt,name=hash" json:"hash,omitempty"`
	// The size of the blob, in bytes.
	SizeBytes int64 `protobuf:"varint,2,opt,name=size_bytes,json=sizeBytes" json:"size_bytes,omitempty"`
}

func (m *Digest) Reset()                    { *m = Digest{} }
func (m *Digest) String() string            { return proto.CompactTextString(m) }
func (*Digest) ProtoMessage()               {}
func (*Digest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Digest) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *Digest) GetSizeBytes() int64 {
	if m != nil {
		return m.SizeBytes
	}
	return 0
}

// An ActionResult represents the result of an
// [Action][google.devtools.remoteexecution.v1test.Action] being run.
type ActionResult struct {
	// The output files of the action. For each output file requested, if the
	// corresponding file existed after the action completed, a single entry will
	// be present in the output list.
	//
	// If the action does not produce the requested output, or produces a
	// directory where a regular file is expected or vice versa, then that output
	// will be omitted from the list. The server is free to arrange the output
	// list as desired; clients MUST NOT assume that the output list is sorted.
	OutputFiles []*OutputFile `protobuf:"bytes,2,rep,name=output_files,json=outputFiles" json:"output_files,omitempty"`
	// The output directories of the action. For each output directory requested,
	// if the corresponding directory existed after the action completed, a single
	// entry will be present in the output list. The client can retrieve the full
	// [Directory][google.devtools.remoteexecution.v1test.Directory] structure
	// using [ContentAddressableStorage.GetTree][google.devtools.remoteexecution.v1test.ContentAddressableStorage.GetTree].
	//
	// If the action does not produce the requested output, or produces a
	// directory where a regular file is expected or vice versa, then that output
	// will be omitted from the list. The server is free to arrange the output
	// list as desired; clients MUST NOT assume that the output list is sorted.
	OutputDirectories []*OutputDirectory `protobuf:"bytes,3,rep,name=output_directories,json=outputDirectories" json:"output_directories,omitempty"`
	// The exit code of the command.
	ExitCode int32 `protobuf:"varint,4,opt,name=exit_code,json=exitCode" json:"exit_code,omitempty"`
	// The standard output buffer of the action. The server will determine, based
	// on the size of the buffer, whether to return it in raw form or to return
	// a digest in `stdout_digest` that points to the buffer. If neither is set,
	// then the buffer is empty. The client SHOULD NOT assume it will get one of
	// the raw buffer or a digest on any given request and should be prepared to
	// handle either.
	StdoutRaw []byte `protobuf:"bytes,5,opt,name=stdout_raw,json=stdoutRaw,proto3" json:"stdout_raw,omitempty"`
	// The digest for a blob containing the standard output of the action, which
	// can be retrieved from the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	// See `stdout_raw` for when this will be set.
	StdoutDigest *Digest `protobuf:"bytes,6,opt,name=stdout_digest,json=stdoutDigest" json:"stdout_digest,omitempty"`
	// The standard error buffer of the action. The server will determine, based
	// on the size of the buffer, whether to return it in raw form or to return
	// a digest in `stderr_digest` that points to the buffer. If neither is set,
	// then the buffer is empty. The client SHOULD NOT assume it will get one of
	// the raw buffer or a digest on any given request and should be prepared to
	// handle either.
	StderrRaw []byte `protobuf:"bytes,7,opt,name=stderr_raw,json=stderrRaw,proto3" json:"stderr_raw,omitempty"`
	// The digest for a blob containing the standard error of the action, which
	// can be retrieved from the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	// See `stderr_raw` for when this will be set.
	StderrDigest *Digest `protobuf:"bytes,8,opt,name=stderr_digest,json=stderrDigest" json:"stderr_digest,omitempty"`
}

func (m *ActionResult) Reset()                    { *m = ActionResult{} }
func (m *ActionResult) String() string            { return proto.CompactTextString(m) }
func (*ActionResult) ProtoMessage()               {}
func (*ActionResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ActionResult) GetOutputFiles() []*OutputFile {
	if m != nil {
		return m.OutputFiles
	}
	return nil
}

func (m *ActionResult) GetOutputDirectories() []*OutputDirectory {
	if m != nil {
		return m.OutputDirectories
	}
	return nil
}

func (m *ActionResult) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func (m *ActionResult) GetStdoutRaw() []byte {
	if m != nil {
		return m.StdoutRaw
	}
	return nil
}

func (m *ActionResult) GetStdoutDigest() *Digest {
	if m != nil {
		return m.StdoutDigest
	}
	return nil
}

func (m *ActionResult) GetStderrRaw() []byte {
	if m != nil {
		return m.StderrRaw
	}
	return nil
}

func (m *ActionResult) GetStderrDigest() *Digest {
	if m != nil {
		return m.StderrDigest
	}
	return nil
}

// An `OutputFile` is similar to a
// [FileNode][google.devtools.remoteexecution.v1test.FileNode], but it is
// tailored for output as part of an `ActionResult`. It allows a full file path
// rather than only a name, and allows the server to include content inline.
//
// `OutputFile` is binary-compatible with `FileNode`.
type OutputFile struct {
	// The full path of the file relative to the input root, including the
	// filename. The path separator is a forward slash `/`.
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// The digest of the file's content.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest" json:"digest,omitempty"`
	// The raw content of the file.
	//
	// This field may be used by the server to provide the content of a file
	// inline in an [ActionResult][google.devtools.remoteexecution.v1test.ActionResult]
	// and avoid requiring that the client make a separate call to
	// [ContentAddressableStorage.GetBlob] to retrieve it.
	//
	// The client SHOULD NOT assume that it will get raw content with any request,
	// and always be prepared to retrieve it via `digest`.
	Content []byte `protobuf:"bytes,3,opt,name=content,proto3" json:"content,omitempty"`
	// True if file is executable, false otherwise.
	IsExecutable bool `protobuf:"varint,4,opt,name=is_executable,json=isExecutable" json:"is_executable,omitempty"`
}

func (m *OutputFile) Reset()                    { *m = OutputFile{} }
func (m *OutputFile) String() string            { return proto.CompactTextString(m) }
func (*OutputFile) ProtoMessage()               {}
func (*OutputFile) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *OutputFile) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *OutputFile) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

func (m *OutputFile) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *OutputFile) GetIsExecutable() bool {
	if m != nil {
		return m.IsExecutable
	}
	return false
}

// An `OutputDirectory` is similar to a
// [DirectoryNode][google.devtools.remoteexecution.v1test.DirectoryNode],
// but it is tailored for output as part of an `ActionResult`. It allows a full
// file path rather than only a name. It contains the digest of a
// [Directory][google.devtools.remoteexecution.v1test.Directory] which will meet
// all the usual requirements for a `Directory`.
//
// `OutputDirectory` is binary-compatible with `DirectoryNode`.
type OutputDirectory struct {
	// The full path of the directory relative to the input root, including the
	// filename. The path separator is a forward slash `/`.
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// The digest of the [Directory][google.devtools.remoteexecution.v1test.Directory]
	// proto describing the directory's contents.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest" json:"digest,omitempty"`
}

func (m *OutputDirectory) Reset()                    { *m = OutputDirectory{} }
func (m *OutputDirectory) String() string            { return proto.CompactTextString(m) }
func (*OutputDirectory) ProtoMessage()               {}
func (*OutputDirectory) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *OutputDirectory) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *OutputDirectory) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

// A request message for
// [Execution.Execute][google.devtools.remoteexecution.v1test.Execution.Execute].
type ExecuteRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName" json:"instance_name,omitempty"`
	// The action to be performed.
	Action *Action `protobuf:"bytes,2,opt,name=action" json:"action,omitempty"`
	// If true, the action will be executed anew even if its result was already
	// present in the cache. If false, the result may be served from the
	// [ActionCache][google.devtools.remoteexecution.v1test.ActionCache].
	SkipCacheLookup bool `protobuf:"varint,3,opt,name=skip_cache_lookup,json=skipCacheLookup" json:"skip_cache_lookup,omitempty"`
	// The total count of input files, not counting directories. This must be
	// provided so that the server can do resource allocation and, on servers with
	// quotas, quota checking. It is also used as a safety check: servers MUST
	// return an error if the total number of input files described in the
	// `action` is different.
	TotalInputFileCount int32 `protobuf:"varint,4,opt,name=total_input_file_count,json=totalInputFileCount" json:"total_input_file_count,omitempty"`
	// The total size of input file content, provided as a hint and check. This
	// must be provided so that the server can do resource allocation and, on
	// servers with quotas, quota checking. It is also used as a safety check:
	// servers MUST return an error if the total size of input files described in
	// the `action` is different.
	TotalInputFileBytes int64 `protobuf:"varint,5,opt,name=total_input_file_bytes,json=totalInputFileBytes" json:"total_input_file_bytes,omitempty"`
}

func (m *ExecuteRequest) Reset()                    { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteRequest) ProtoMessage()               {}
func (*ExecuteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ExecuteRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *ExecuteRequest) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *ExecuteRequest) GetSkipCacheLookup() bool {
	if m != nil {
		return m.SkipCacheLookup
	}
	return false
}

func (m *ExecuteRequest) GetTotalInputFileCount() int32 {
	if m != nil {
		return m.TotalInputFileCount
	}
	return 0
}

func (m *ExecuteRequest) GetTotalInputFileBytes() int64 {
	if m != nil {
		return m.TotalInputFileBytes
	}
	return 0
}

// The response message for
// [Execution.Execute][google.devtools.remoteexecution.v1test.Execution.Execute],
// which will be contained in the [response field][google.longrunning.Operation.response] of the
// [Operation][google.longrunning.Operation].
type ExecuteResponse struct {
	// The result of the action.
	Result *ActionResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	// True if the result was served from cache, false if it was executed.
	CachedResult bool `protobuf:"varint,2,opt,name=cached_result,json=cachedResult" json:"cached_result,omitempty"`
}

func (m *ExecuteResponse) Reset()                    { *m = ExecuteResponse{} }
func (m *ExecuteResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteResponse) ProtoMessage()               {}
func (*ExecuteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ExecuteResponse) GetResult() *ActionResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *ExecuteResponse) GetCachedResult() bool {
	if m != nil {
		return m.CachedResult
	}
	return false
}

// Metadata about an ongoing [execution][google.devtools.remoteexecution.v1test.Execution.Execute],
// which will be
// contained in the [metadata field][google.longrunning.Operation.response] of
// the [Operation][google.longrunning.Operation].
type ExecuteOperationMetadata struct {
	Stage ExecuteOperationMetadata_Stage `protobuf:"varint,1,opt,name=stage,enum=google.devtools.remoteexecution.v1test.ExecuteOperationMetadata_Stage" json:"stage,omitempty"`
	// The digest of the [Action][google.devtools.remoteexecution.v1test.Action]
	// being executed.
	ActionDigest *Digest `protobuf:"bytes,2,opt,name=action_digest,json=actionDigest" json:"action_digest,omitempty"`
	// If set, the client can use this name with
	// [ByteStream.Read][google.bytestream.ByteStream.Read] to stream the
	// standard output.
	StdoutStreamName string `protobuf:"bytes,3,opt,name=stdout_stream_name,json=stdoutStreamName" json:"stdout_stream_name,omitempty"`
	// If set, the client can use this name with
	// [ByteStream.Read][google.bytestream.ByteStream.Read] to stream the
	// standard error.
	StderrStreamName string `protobuf:"bytes,4,opt,name=stderr_stream_name,json=stderrStreamName" json:"stderr_stream_name,omitempty"`
}

func (m *ExecuteOperationMetadata) Reset()                    { *m = ExecuteOperationMetadata{} }
func (m *ExecuteOperationMetadata) String() string            { return proto.CompactTextString(m) }
func (*ExecuteOperationMetadata) ProtoMessage()               {}
func (*ExecuteOperationMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ExecuteOperationMetadata) GetStage() ExecuteOperationMetadata_Stage {
	if m != nil {
		return m.Stage
	}
	return ExecuteOperationMetadata_UNKNOWN
}

func (m *ExecuteOperationMetadata) GetActionDigest() *Digest {
	if m != nil {
		return m.ActionDigest
	}
	return nil
}

func (m *ExecuteOperationMetadata) GetStdoutStreamName() string {
	if m != nil {
		return m.StdoutStreamName
	}
	return ""
}

func (m *ExecuteOperationMetadata) GetStderrStreamName() string {
	if m != nil {
		return m.StderrStreamName
	}
	return ""
}

// A request message for
// [ActionCache.GetActionResult][google.devtools.remoteexecution.v1test.ActionCache.GetActionResult].
type GetActionResultRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName" json:"instance_name,omitempty"`
	// The digest of the [Action][google.devtools.remoteexecution.v1test.Action]
	// whose result is requested.
	ActionDigest *Digest `protobuf:"bytes,2,opt,name=action_digest,json=actionDigest" json:"action_digest,omitempty"`
}

func (m *GetActionResultRequest) Reset()                    { *m = GetActionResultRequest{} }
func (m *GetActionResultRequest) String() string            { return proto.CompactTextString(m) }
func (*GetActionResultRequest) ProtoMessage()               {}
func (*GetActionResultRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetActionResultRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *GetActionResultRequest) GetActionDigest() *Digest {
	if m != nil {
		return m.ActionDigest
	}
	return nil
}

// A request message for
// [ActionCache.UpdateActionResult][google.devtools.remoteexecution.v1test.ActionCache.UpdateActionResult].
type UpdateActionResultRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName" json:"instance_name,omitempty"`
	// The digest of the [Action][google.devtools.remoteexecution.v1test.Action]
	// whose result is being uploaded.
	ActionDigest *Digest `protobuf:"bytes,2,opt,name=action_digest,json=actionDigest" json:"action_digest,omitempty"`
	// The [ActionResult][google.devtools.remoteexecution.v1test.ActionResult]
	// to store in the cache.
	ActionResult *ActionResult `protobuf:"bytes,3,opt,name=action_result,json=actionResult" json:"action_result,omitempty"`
}

func (m *UpdateActionResultRequest) Reset()                    { *m = UpdateActionResultRequest{} }
func (m *UpdateActionResultRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateActionResultRequest) ProtoMessage()               {}
func (*UpdateActionResultRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *UpdateActionResultRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *UpdateActionResultRequest) GetActionDigest() *Digest {
	if m != nil {
		return m.ActionDigest
	}
	return nil
}

func (m *UpdateActionResultRequest) GetActionResult() *ActionResult {
	if m != nil {
		return m.ActionResult
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.FindMissingBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.FindMissingBlobs].
type FindMissingBlobsRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName" json:"instance_name,omitempty"`
	// A list of the blobs to check.
	BlobDigests []*Digest `protobuf:"bytes,2,rep,name=blob_digests,json=blobDigests" json:"blob_digests,omitempty"`
}

func (m *FindMissingBlobsRequest) Reset()                    { *m = FindMissingBlobsRequest{} }
func (m *FindMissingBlobsRequest) String() string            { return proto.CompactTextString(m) }
func (*FindMissingBlobsRequest) ProtoMessage()               {}
func (*FindMissingBlobsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *FindMissingBlobsRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *FindMissingBlobsRequest) GetBlobDigests() []*Digest {
	if m != nil {
		return m.BlobDigests
	}
	return nil
}

// A response message for
// [ContentAddressableStorage.FindMissingBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.FindMissingBlobs].
type FindMissingBlobsResponse struct {
	// A list of the blobs requested *not* present in the storage.
	MissingBlobDigests []*Digest `protobuf:"bytes,2,rep,name=missing_blob_digests,json=missingBlobDigests" json:"missing_blob_digests,omitempty"`
}

func (m *FindMissingBlobsResponse) Reset()                    { *m = FindMissingBlobsResponse{} }
func (m *FindMissingBlobsResponse) String() string            { return proto.CompactTextString(m) }
func (*FindMissingBlobsResponse) ProtoMessage()               {}
func (*FindMissingBlobsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *FindMissingBlobsResponse) GetMissingBlobDigests() []*Digest {
	if m != nil {
		return m.MissingBlobDigests
	}
	return nil
}

// A single request message for
// [ContentAddressableStorage.BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs].
type UpdateBlobRequest struct {
	// The digest of the blob. This MUST be the digest of `data`.
	ContentDigest *Digest `protobuf:"bytes,1,opt,name=content_digest,json=contentDigest" json:"content_digest,omitempty"`
	// The raw binary data.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *UpdateBlobRequest) Reset()                    { *m = UpdateBlobRequest{} }
func (m *UpdateBlobRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateBlobRequest) ProtoMessage()               {}
func (*UpdateBlobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *UpdateBlobRequest) GetContentDigest() *Digest {
	if m != nil {
		return m.ContentDigest
	}
	return nil
}

func (m *UpdateBlobRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs].
type BatchUpdateBlobsRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName" json:"instance_name,omitempty"`
	// The individual upload requests.
	Requests []*UpdateBlobRequest `protobuf:"bytes,2,rep,name=requests" json:"requests,omitempty"`
}

func (m *BatchUpdateBlobsRequest) Reset()                    { *m = BatchUpdateBlobsRequest{} }
func (m *BatchUpdateBlobsRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchUpdateBlobsRequest) ProtoMessage()               {}
func (*BatchUpdateBlobsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *BatchUpdateBlobsRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *BatchUpdateBlobsRequest) GetRequests() []*UpdateBlobRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// A response message for
// [ContentAddressableStorage.BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs].
type BatchUpdateBlobsResponse struct {
	// The responses to the requests.
	Responses []*BatchUpdateBlobsResponse_Response `protobuf:"bytes,1,rep,name=responses" json:"responses,omitempty"`
}

func (m *BatchUpdateBlobsResponse) Reset()                    { *m = BatchUpdateBlobsResponse{} }
func (m *BatchUpdateBlobsResponse) String() string            { return proto.CompactTextString(m) }
func (*BatchUpdateBlobsResponse) ProtoMessage()               {}
func (*BatchUpdateBlobsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *BatchUpdateBlobsResponse) GetResponses() []*BatchUpdateBlobsResponse_Response {
	if m != nil {
		return m.Responses
	}
	return nil
}

// A response corresponding to a single blob that the client tried to upload.
type BatchUpdateBlobsResponse_Response struct {
	// The digest to which this response corresponds.
	BlobDigest *Digest `protobuf:"bytes,1,opt,name=blob_digest,json=blobDigest" json:"blob_digest,omitempty"`
	// The result of attempting to upload that blob.
	Status *google_rpc.Status `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
}

func (m *BatchUpdateBlobsResponse_Response) Reset()         { *m = BatchUpdateBlobsResponse_Response{} }
func (m *BatchUpdateBlobsResponse_Response) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateBlobsResponse_Response) ProtoMessage()    {}
func (*BatchUpdateBlobsResponse_Response) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{19, 0}
}

func (m *BatchUpdateBlobsResponse_Response) GetBlobDigest() *Digest {
	if m != nil {
		return m.BlobDigest
	}
	return nil
}

func (m *BatchUpdateBlobsResponse_Response) GetStatus() *google_rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.GetTree][google.devtools.remoteexecution.v1test.ContentAddressableStorage.GetTree].
type GetTreeRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName" json:"instance_name,omitempty"`
	// The digest of the root, which must be an encoded
	// [Directory][google.devtools.remoteexecution.v1test.Directory] message
	// stored in the [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	RootDigest *Digest `protobuf:"bytes,2,opt,name=root_digest,json=rootDigest" json:"root_digest,omitempty"`
	// A maximum page size to request. If present, the server will request no more
	// than this many items. Regardless of whether a page size is specified, the
	// server may place its own limit on the number of items to be returned and
	// require the client to retrieve more items using a subsequent request.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// A page token, which must be a value received in a previous
	// [GetTreeResponse][google.devtools.remoteexecution.v1test.GetTreeResponse].
	// If present, the server will use it to return the following page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *GetTreeRequest) Reset()                    { *m = GetTreeRequest{} }
func (m *GetTreeRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTreeRequest) ProtoMessage()               {}
func (*GetTreeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *GetTreeRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *GetTreeRequest) GetRootDigest() *Digest {
	if m != nil {
		return m.RootDigest
	}
	return nil
}

func (m *GetTreeRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *GetTreeRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response message for
// [ContentAddressableStorage.GetTree][google.devtools.remoteexecution.v1test.ContentAddressableStorage.GetTree].
type GetTreeResponse struct {
	// The directories descended from the requested root.
	Directories []*Directory `protobuf:"bytes,1,rep,name=directories" json:"directories,omitempty"`
	// If present, signifies that there are more results which the client can
	// retrieve by passing this as the page_token in a subsequent
	// [request][google.devtools.remoteexecution.v1test.GetTreeRequest].
	// If empty, signifies that this is the last page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *GetTreeResponse) Reset()                    { *m = GetTreeResponse{} }
func (m *GetTreeResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTreeResponse) ProtoMessage()               {}
func (*GetTreeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *GetTreeResponse) GetDirectories() []*Directory {
	if m != nil {
		return m.Directories
	}
	return nil
}

func (m *GetTreeResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*Action)(nil), "google.devtools.remoteexecution.v1test.Action")
	proto.RegisterType((*Command)(nil), "google.devtools.remoteexecution.v1test.Command")
	proto.RegisterType((*Command_EnvironmentVariable)(nil), "google.devtools.remoteexecution.v1test.Command.EnvironmentVariable")
	proto.RegisterType((*Platform)(nil), "google.devtools.remoteexecution.v1test.Platform")
	proto.RegisterType((*Platform_Property)(nil), "google.devtools.remoteexecution.v1test.Platform.Property")
	proto.RegisterType((*Directory)(nil), "google.devtools.remoteexecution.v1test.Directory")
	proto.RegisterType((*FileNode)(nil), "google.devtools.remoteexecution.v1test.FileNode")
	proto.RegisterType((*DirectoryNode)(nil), "google.devtools.remoteexecution.v1test.DirectoryNode")
	proto.RegisterType((*Digest)(nil), "google.devtools.remoteexecution.v1test.Digest")
	proto.RegisterType((*ActionResult)(nil), "google.devtools.remoteexecution.v1test.ActionResult")
	proto.RegisterType((*OutputFile)(nil), "google.devtools.remoteexecution.v1test.OutputFile")
	proto.RegisterType((*OutputDirectory)(nil), "google.devtools.remoteexecution.v1test.OutputDirectory")
	proto.RegisterType((*ExecuteRequest)(nil), "google.devtools.remoteexecution.v1test.ExecuteRequest")
	proto.RegisterType((*ExecuteResponse)(nil), "google.devtools.remoteexecution.v1test.ExecuteResponse")
	proto.RegisterType((*ExecuteOperationMetadata)(nil), "google.devtools.remoteexecution.v1test.ExecuteOperationMetadata")
	proto.RegisterType((*GetActionResultRequest)(nil), "google.devtools.remoteexecution.v1test.GetActionResultRequest")
	proto.RegisterType((*UpdateActionResultRequest)(nil), "google.devtools.remoteexecution.v1test.UpdateActionResultRequest")
	proto.RegisterType((*FindMissingBlobsRequest)(nil), "google.devtools.remoteexecution.v1test.FindMissingBlobsRequest")
	proto.RegisterType((*FindMissingBlobsResponse)(nil), "google.devtools.remoteexecution.v1test.FindMissingBlobsResponse")
	proto.RegisterType((*UpdateBlobRequest)(nil), "google.devtools.remoteexecution.v1test.UpdateBlobRequest")
	proto.RegisterType((*BatchUpdateBlobsRequest)(nil), "google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest")
	proto.RegisterType((*BatchUpdateBlobsResponse)(nil), "google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse")
	proto.RegisterType((*BatchUpdateBlobsResponse_Response)(nil), "google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse.Response")
	proto.RegisterType((*GetTreeRequest)(nil), "google.devtools.remoteexecution.v1test.GetTreeRequest")
	proto.RegisterType((*GetTreeResponse)(nil), "google.devtools.remoteexecution.v1test.GetTreeResponse")
	proto.RegisterEnum("google.devtools.remoteexecution.v1test.ExecuteOperationMetadata_Stage", ExecuteOperationMetadata_Stage_name, ExecuteOperationMetadata_Stage_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Execution service

type ExecutionClient interface {
	// Execute an action remotely.
	//
	// In order to execute an action, the client must first upload all of the
	// inputs, as well as the [Command][google.devtools.remoteexecution.v1test.Command]
	// to run, into the [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	// It then calls `Execute` with an [Action][google.devtools.remoteexecution.v1test.Action]
	// referring to them. The server will run the action and eventually return the
	// result.
	//
	// The input `Action`'s fields MUST meet the various canonicalization
	// requirements specified in the documentation for their types so that it has
	// the same digest as other logically equivalent `Action`s. The server MAY
	// enforce the requirements and return errors if a non-canonical input is
	// received. It MAY also proceed without verifying some or all of the
	// requirements, such as for performance reasons. If the server does not
	// verify the requirement, then it will treat the `Action` as distinct from
	// another logically equivalent action if they hash differently.
	//
	// Returns a [google.longrunning.Operation][google.longrunning.Operation]
	// describing the resulting execution, with eventual `response`
	// [ExecuteResponse][google.devtools.remoteexecution.v1test.ExecuteResponse].
	// The `metadata` on the operation is of type
	// [ExecuteOperationMetadata][google.devtools.remoteexecution.v1test.ExecuteOperationMetadata].
	//
	// To query the operation, you can use the
	// [Operations API][google.longrunning.Operations.GetOperation]. If you wish
	// to allow the server to stream operations updates, rather than requiring
	// client polling, you can use the
	// [Watcher API][google.watcher.v1.Watcher.Watch] with the Operation's `name`
	// as the `target`.
	//
	// When using the Watcher API, the initial `data` will be the `Operation` at
	// the time of the request. Updates will be provided periodically by the
	// server until the `Operation` completes, at which point the response message
	// will (assuming no error) be at `data.response`.
	//
	// The server NEED NOT implement other methods or functionality of the
	// Operation and Watcher APIs.
	//
	// Errors discovered during creation of the `Operation` will be reported
	// as gRPC Status errors, while errors that occurred while running the
	// `Operation` will be reported in the `Operation` error field.
	// The possible errors include:
	// * `INVALID_ARGUMENT`: One or more arguments are invalid.
	// * `FAILED_PRECONDITION`: One or more errors occurred in setting up the
	//   action requested, such as a missing input or no worker being available.
	//   The client may be able to fix the errors and retry.
	// * `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to run
	//   the action.
	// * `UNAVAILABLE`: Due to a transient condition, such as all workers being
	//   occupied (and the server does not support a queue), the action could not
	//   be started. The client should retry.
	// * `INTERNAL`: An internal error occurred in the execution engine or the
	//   worker.
	// * `DEADLINE_EXCEEDED`: The execution timed out.
	Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type executionClient struct {
	cc *grpc.ClientConn
}

func NewExecutionClient(cc *grpc.ClientConn) ExecutionClient {
	return &executionClient{cc}
}

func (c *executionClient) Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.Execution/Execute", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Execution service

type ExecutionServer interface {
	// Execute an action remotely.
	//
	// In order to execute an action, the client must first upload all of the
	// inputs, as well as the [Command][google.devtools.remoteexecution.v1test.Command]
	// to run, into the [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	// It then calls `Execute` with an [Action][google.devtools.remoteexecution.v1test.Action]
	// referring to them. The server will run the action and eventually return the
	// result.
	//
	// The input `Action`'s fields MUST meet the various canonicalization
	// requirements specified in the documentation for their types so that it has
	// the same digest as other logically equivalent `Action`s. The server MAY
	// enforce the requirements and return errors if a non-canonical input is
	// received. It MAY also proceed without verifying some or all of the
	// requirements, such as for performance reasons. If the server does not
	// verify the requirement, then it will treat the `Action` as distinct from
	// another logically equivalent action if they hash differently.
	//
	// Returns a [google.longrunning.Operation][google.longrunning.Operation]
	// describing the resulting execution, with eventual `response`
	// [ExecuteResponse][google.devtools.remoteexecution.v1test.ExecuteResponse].
	// The `metadata` on the operation is of type
	// [ExecuteOperationMetadata][google.devtools.remoteexecution.v1test.ExecuteOperationMetadata].
	//
	// To query the operation, you can use the
	// [Operations API][google.longrunning.Operations.GetOperation]. If you wish
	// to allow the server to stream operations updates, rather than requiring
	// client polling, you can use the
	// [Watcher API][google.watcher.v1.Watcher.Watch] with the Operation's `name`
	// as the `target`.
	//
	// When using the Watcher API, the initial `data` will be the `Operation` at
	// the time of the request. Updates will be provided periodically by the
	// server until the `Operation` completes, at which point the response message
	// will (assuming no error) be at `data.response`.
	//
	// The server NEED NOT implement other methods or functionality of the
	// Operation and Watcher APIs.
	//
	// Errors discovered during creation of the `Operation` will be reported
	// as gRPC Status errors, while errors that occurred while running the
	// `Operation` will be reported in the `Operation` error field.
	// The possible errors include:
	// * `INVALID_ARGUMENT`: One or more arguments are invalid.
	// * `FAILED_PRECONDITION`: One or more errors occurred in setting up the
	//   action requested, such as a missing input or no worker being available.
	//   The client may be able to fix the errors and retry.
	// * `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to run
	//   the action.
	// * `UNAVAILABLE`: Due to a transient condition, such as all workers being
	//   occupied (and the server does not support a queue), the action could not
	//   be started. The client should retry.
	// * `INTERNAL`: An internal error occurred in the execution engine or the
	//   worker.
	// * `DEADLINE_EXCEEDED`: The execution timed out.
	Execute(context.Context, *ExecuteRequest) (*google_longrunning.Operation, error)
}

func RegisterExecutionServer(s *grpc.Server, srv ExecutionServer) {
	s.RegisterService(&_Execution_serviceDesc, srv)
}

func _Execution_Execute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionServer).Execute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.Execution/Execute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionServer).Execute(ctx, req.(*ExecuteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Execution_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteexecution.v1test.Execution",
	HandlerType: (*ExecutionServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Execute",
			Handler:    _Execution_Execute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteexecution/v1test/remote_execution.proto",
}

// Client API for ActionCache service

type ActionCacheClient interface {
	// Retrieve a cached execution result.
	//
	// Errors:
	// * `NOT_FOUND`: The requested `ActionResult` is not in the cache.
	GetActionResult(ctx context.Context, in *GetActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error)
	// Upload a new execution result.
	//
	// This method is intended for servers which implement the distributed cache
	// independently of the [Execution][google.devtools.remoteexecution.v1test.Execution]
	// API. As a result, it is OPTIONAL for servers to implement.
	//
	// Errors:
	// * `NOT_IMPLEMENTED`: This method is not supported by the server.
	// * `RESOURCE_EXHAUSTED`: There is insufficient storage space to add the
	//   entry to the cache.
	UpdateActionResult(ctx context.Context, in *UpdateActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error)
}

type actionCacheClient struct {
	cc *grpc.ClientConn
}

func NewActionCacheClient(cc *grpc.ClientConn) ActionCacheClient {
	return &actionCacheClient{cc}
}

func (c *actionCacheClient) GetActionResult(ctx context.Context, in *GetActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error) {
	out := new(ActionResult)
	err := grpc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ActionCache/GetActionResult", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionCacheClient) UpdateActionResult(ctx context.Context, in *UpdateActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error) {
	out := new(ActionResult)
	err := grpc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ActionCache/UpdateActionResult", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ActionCache service

type ActionCacheServer interface {
	// Retrieve a cached execution result.
	//
	// Errors:
	// * `NOT_FOUND`: The requested `ActionResult` is not in the cache.
	GetActionResult(context.Context, *GetActionResultRequest) (*ActionResult, error)
	// Upload a new execution result.
	//
	// This method is intended for servers which implement the distributed cache
	// independently of the [Execution][google.devtools.remoteexecution.v1test.Execution]
	// API. As a result, it is OPTIONAL for servers to implement.
	//
	// Errors:
	// * `NOT_IMPLEMENTED`: This method is not supported by the server.
	// * `RESOURCE_EXHAUSTED`: There is insufficient storage space to add the
	//   entry to the cache.
	UpdateActionResult(context.Context, *UpdateActionResultRequest) (*ActionResult, error)
}

func RegisterActionCacheServer(s *grpc.Server, srv ActionCacheServer) {
	s.RegisterService(&_ActionCache_serviceDesc, srv)
}

func _ActionCache_GetActionResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetActionResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionCacheServer).GetActionResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ActionCache/GetActionResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionCacheServer).GetActionResult(ctx, req.(*GetActionResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionCache_UpdateActionResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActionResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionCacheServer).UpdateActionResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ActionCache/UpdateActionResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionCacheServer).UpdateActionResult(ctx, req.(*UpdateActionResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ActionCache_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteexecution.v1test.ActionCache",
	HandlerType: (*ActionCacheServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetActionResult",
			Handler:    _ActionCache_GetActionResult_Handler,
		},
		{
			MethodName: "UpdateActionResult",
			Handler:    _ActionCache_UpdateActionResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteexecution/v1test/remote_execution.proto",
}

// Client API for ContentAddressableStorage service

type ContentAddressableStorageClient interface {
	// Determine if blobs are present in the CAS.
	//
	// Clients can use this API before uploading blobs to determine which ones are
	// already present in the CAS and do not need to be uploaded again.
	//
	// There are no method-specific errors.
	FindMissingBlobs(ctx context.Context, in *FindMissingBlobsRequest, opts ...grpc.CallOption) (*FindMissingBlobsResponse, error)
	// Upload many blobs at once.
	//
	// The client MUST NOT upload blobs with a combined total size of more than 10
	// MiB using this API. Such requests should either be split into smaller
	// chunks or uploaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling [UpdateBlob][] on each individual
	// blob, in parallel. The requests may succeed or fail independently.
	//
	// Errors:
	// * `INVALID_ARGUMENT`: The client attempted to upload more than 10 MiB of
	//   data.
	//
	// Individual requests may return the following errors, additionally:
	// * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
	// * `INVALID_ARGUMENT`: The [Digest][google.devtools.remoteexecution.v1test.Digest]
	// does not match the provided data.
	BatchUpdateBlobs(ctx context.Context, in *BatchUpdateBlobsRequest, opts ...grpc.CallOption) (*BatchUpdateBlobsResponse, error)
	// Fetch the entire directory tree rooted at a node.
	//
	// This request must be targeted at a
	// [Directory][google.devtools.remoteexecution.v1test.Directory] stored in the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage]
	// (CAS). The server will enumerate the `Directory` tree recursively and
	// return every node descended from the root.
	// The exact traversal order is unspecified and, unless retrieving subsequent
	// pages from an earlier request, is not guaranteed to be stable across
	// multiple invocations of `GetTree`.
	//
	// If part of the tree is missing from the CAS, the server will return the
	// portion present and omit the rest.
	//
	// * `NOT_FOUND`: The requested tree root is not present in the CAS.
	GetTree(ctx context.Context, in *GetTreeRequest, opts ...grpc.CallOption) (*GetTreeResponse, error)
}

type contentAddressableStorageClient struct {
	cc *grpc.ClientConn
}

func NewContentAddressableStorageClient(cc *grpc.ClientConn) ContentAddressableStorageClient {
	return &contentAddressableStorageClient{cc}
}

func (c *contentAddressableStorageClient) FindMissingBlobs(ctx context.Context, in *FindMissingBlobsRequest, opts ...grpc.CallOption) (*FindMissingBlobsResponse, error) {
	out := new(FindMissingBlobsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/FindMissingBlobs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) BatchUpdateBlobs(ctx context.Context, in *BatchUpdateBlobsRequest, opts ...grpc.CallOption) (*BatchUpdateBlobsResponse, error) {
	out := new(BatchUpdateBlobsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/BatchUpdateBlobs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) GetTree(ctx context.Context, in *GetTreeRequest, opts ...grpc.CallOption) (*GetTreeResponse, error) {
	out := new(GetTreeResponse)
	err := grpc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/GetTree", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ContentAddressableStorage service

type ContentAddressableStorageServer interface {
	// Determine if blobs are present in the CAS.
	//
	// Clients can use this API before uploading blobs to determine which ones are
	// already present in the CAS and do not need to be uploaded again.
	//
	// There are no method-specific errors.
	FindMissingBlobs(context.Context, *FindMissingBlobsRequest) (*FindMissingBlobsResponse, error)
	// Upload many blobs at once.
	//
	// The client MUST NOT upload blobs with a combined total size of more than 10
	// MiB using this API. Such requests should either be split into smaller
	// chunks or uploaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling [UpdateBlob][] on each individual
	// blob, in parallel. The requests may succeed or fail independently.
	//
	// Errors:
	// * `INVALID_ARGUMENT`: The client attempted to upload more than 10 MiB of
	//   data.
	//
	// Individual requests may return the following errors, additionally:
	// * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
	// * `INVALID_ARGUMENT`: The [Digest][google.devtools.remoteexecution.v1test.Digest]
	// does not match the provided data.
	BatchUpdateBlobs(context.Context, *BatchUpdateBlobsRequest) (*BatchUpdateBlobsResponse, error)
	// Fetch the entire directory tree rooted at a node.
	//
	// This request must be targeted at a
	// [Directory][google.devtools.remoteexecution.v1test.Directory] stored in the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage]
	// (CAS). The server will enumerate the `Directory` tree recursively and
	// return every node descended from the root.
	// The exact traversal order is unspecified and, unless retrieving subsequent
	// pages from an earlier request, is not guaranteed to be stable across
	// multiple invocations of `GetTree`.
	//
	// If part of the tree is missing from the CAS, the server will return the
	// portion present and omit the rest.
	//
	// * `NOT_FOUND`: The requested tree root is not present in the CAS.
	GetTree(context.Context, *GetTreeRequest) (*GetTreeResponse, error)
}

func RegisterContentAddressableStorageServer(s *grpc.Server, srv ContentAddressableStorageServer) {
	s.RegisterService(&_ContentAddressableStorage_serviceDesc, srv)
}

func _ContentAddressableStorage_FindMissingBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindMissingBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).FindMissingBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/FindMissingBlobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).FindMissingBlobs(ctx, req.(*FindMissingBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_BatchUpdateBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).BatchUpdateBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/BatchUpdateBlobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).BatchUpdateBlobs(ctx, req.(*BatchUpdateBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_GetTree_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTreeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).GetTree(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/GetTree",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).GetTree(ctx, req.(*GetTreeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ContentAddressableStorage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteexecution.v1test.ContentAddressableStorage",
	HandlerType: (*ContentAddressableStorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindMissingBlobs",
			Handler:    _ContentAddressableStorage_FindMissingBlobs_Handler,
		},
		{
			MethodName: "BatchUpdateBlobs",
			Handler:    _ContentAddressableStorage_BatchUpdateBlobs_Handler,
		},
		{
			MethodName: "GetTree",
			Handler:    _ContentAddressableStorage_GetTree_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteexecution/v1test/remote_execution.proto",
}

func init() {
	proto.RegisterFile("google/devtools/remoteexecution/v1test/remote_execution.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1747 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcb, 0x6f, 0x1c, 0x49,
	0x19, 0xa7, 0x67, 0x3c, 0xaf, 0x6f, 0xc6, 0xaf, 0x5a, 0xb3, 0x99, 0xcc, 0x6e, 0x90, 0xe9, 0x95,
	0x56, 0xd6, 0x68, 0xb7, 0x07, 0x3b, 0xbb, 0x44, 0x78, 0x15, 0x82, 0x3d, 0x1e, 0x3b, 0x51, 0x1c,
	0xdb, 0x69, 0x7b, 0xf2, 0x22, 0x52, 0xd3, 0x33, 0x5d, 0x1e, 0x37, 0x9e, 0xe9, 0x6a, 0xaa, 0x6a,
	0x1c, 0x27, 0x21, 0x1c, 0x10, 0x12, 0x07, 0x04, 0x12, 0x44, 0x08, 0x24, 0x6e, 0x48, 0x08, 0x09,
	0x71, 0xe2, 0x3f, 0x80, 0x3f, 0x80, 0x03, 0x5c, 0x38, 0x23, 0x4e, 0x9c, 0x38, 0x23, 0x24, 0x50,
	0x3d, 0x7a, 0x5e, 0xb6, 0x49, 0x8f, 0x1d, 0x4b, 0x7b, 0xeb, 0xfa, 0xaa, 0xbe, 0xdf, 0xf7, 0xfe,
	0xbe, 0xaa, 0x86, 0x9b, 0x2d, 0x42, 0x5a, 0x6d, 0x5c, 0xf1, 0xf0, 0x11, 0x27, 0xa4, 0xcd, 0x2a,
	0x14, 0x77, 0x08, 0xc7, 0xf8, 0x18, 0x37, 0xbb, 0xdc, 0x27, 0x41, 0xe5, 0x68, 0x91, 0x63, 0xc6,
	0x35, 0xd9, 0xe9, 0xd1, 0xad, 0x90, 0x12, 0x4e, 0xd0, 0x87, 0x8a, 0xdd, 0x8a, 0xd8, 0xad, 0x11,
	0x76, 0x4b, 0xb1, 0x97, 0xde, 0xd7, 0x62, 0xdc, 0xd0, 0xaf, 0xb8, 0x41, 0x40, 0xb8, 0x2b, 0x76,
	0x99, 0x42, 0x29, 0x7d, 0xa0, 0x77, 0xdb, 0x24, 0x68, 0xd1, 0x6e, 0x10, 0xf8, 0x41, 0xab, 0x42,
	0x42, 0x4c, 0x87, 0x0e, 0x7d, 0x49, 0x1f, 0x92, 0xab, 0x46, 0x77, 0xbf, 0xe2, 0x75, 0xd5, 0x01,
	0xbd, 0x7f, 0x45, 0xef, 0xd3, 0xb0, 0x59, 0x61, 0xdc, 0xe5, 0x5d, 0xcd, 0x68, 0xfe, 0x21, 0x09,
	0xe9, 0x95, 0xa6, 0x38, 0x89, 0xea, 0x30, 0xd5, 0x24, 0x9d, 0x8e, 0x1b, 0x78, 0x8e, 0xe7, 0xb7,
	0x30, 0xe3, 0x45, 0x63, 0xde, 0x58, 0xc8, 0x2f, 0x59, 0x56, 0x3c, 0x3b, 0xac, 0x35, 0xc9, 0x65,
	0x4f, 0x6a, 0x14, 0xb5, 0x44, 0x4f, 0x60, 0xd6, 0x0f, 0xc2, 0x2e, 0x77, 0x28, 0x21, 0x3c, 0x42,
	0x4e, 0x9c, 0x0b, 0x79, 0x5a, 0x02, 0xd9, 0x84, 0x70, 0x8d, 0xfd, 0x65, 0x28, 0x90, 0x2e, 0x17,
	0xe0, 0xfb, 0x7e, 0x1b, 0xb3, 0x62, 0x72, 0x3e, 0xb9, 0x90, 0xb3, 0xf3, 0x8a, 0xb6, 0x2e, 0x48,
	0xe8, 0x63, 0x40, 0xfa, 0x88, 0xe7, 0x53, 0xdc, 0xe4, 0x84, 0xfa, 0x98, 0x15, 0x27, 0xe4, 0xc1,
	0x59, 0xb5, 0xb3, 0xd6, 0xdf, 0x40, 0x9b, 0x90, 0x0d, 0xdb, 0x2e, 0xdf, 0x27, 0xb4, 0x53, 0x4c,
	0x49, 0x25, 0xbf, 0x12, 0x57, 0xc9, 0x1d, 0xcd, 0x67, 0xf7, 0x10, 0xd0, 0x75, 0xc8, 0x70, 0xbf,
	0x83, 0x49, 0x97, 0x17, 0xd3, 0x12, 0xec, 0x6a, 0x04, 0x16, 0x05, 0xca, 0x5a, 0xd3, 0x81, 0xb2,
	0xa3, 0x93, 0x68, 0x1e, 0x0a, 0x1e, 0x71, 0x02, 0xc2, 0x9d, 0xa6, 0xdb, 0x3c, 0xc0, 0xc5, 0xcc,
	0xbc, 0xb1, 0x90, 0xb5, 0xc1, 0x23, 0x5b, 0x84, 0x57, 0x05, 0xc5, 0xfc, 0xbb, 0x01, 0x99, 0xaa,
	0x72, 0x32, 0x7a, 0x1f, 0x72, 0x2e, 0x6d, 0x75, 0x3b, 0x38, 0xe0, 0xac, 0x68, 0x48, 0xb3, 0xfa,
	0x04, 0x74, 0x0c, 0x5f, 0xc4, 0xc1, 0x91, 0x4f, 0x49, 0x20, 0xd6, 0xce, 0x91, 0x4b, 0x7d, 0xb7,
	0x21, 0x3c, 0x95, 0x98, 0x4f, 0x2e, 0xe4, 0x97, 0xaa, 0x71, 0x6d, 0xd3, 0xd2, 0xac, 0x5a, 0x1f,
	0xec, 0x81, 0xc6, 0xb2, 0xe7, 0xf0, 0x49, 0x22, 0x2b, 0xdd, 0x82, 0x77, 0x4e, 0x39, 0x8c, 0x10,
	0x4c, 0x04, 0x6e, 0x07, 0xcb, 0xd4, 0xca, 0xd9, 0xf2, 0x1b, 0xcd, 0x41, 0xea, 0xc8, 0x6d, 0x77,
	0xb1, 0xcc, 0x8a, 0x9c, 0xad, 0x16, 0xe6, 0xaf, 0x0c, 0xc8, 0x46, 0x2e, 0x45, 0x8f, 0x01, 0x42,
	0x2a, 0xb2, 0x9e, 0x8b, 0xe8, 0x19, 0x52, 0xf9, 0xaf, 0x8d, 0x1b, 0x18, 0x6b, 0x47, 0x41, 0x3c,
	0xb7, 0x07, 0xc0, 0x4a, 0x9f, 0x40, 0x36, 0xa2, 0x8f, 0xa1, 0xdd, 0xef, 0x0d, 0xc8, 0x45, 0x79,
	0xf3, 0x1c, 0xad, 0x43, 0x4a, 0x25, 0xa0, 0xd2, 0x2c, 0x76, 0xca, 0x88, 0x14, 0xdd, 0x22, 0x1e,
	0xb6, 0x15, 0x3b, 0x7a, 0x08, 0xf9, 0xc1, 0x2c, 0x55, 0x41, 0xfa, 0x34, 0x7e, 0x95, 0x68, 0x7d,
	0x24, 0xe4, 0x20, 0x92, 0xf9, 0x23, 0x03, 0xb2, 0x91, 0xb0, 0x53, 0xad, 0x5c, 0x87, 0xf4, 0x85,
	0x4a, 0x53, 0x73, 0xa3, 0x0f, 0x60, 0xd2, 0x67, 0xba, 0x13, 0x8a, 0x80, 0x17, 0x27, 0x64, 0xf6,
	0x16, 0x7c, 0x56, 0xeb, 0xd1, 0xcc, 0x43, 0x98, 0x1c, 0xd2, 0xf5, 0x32, 0x35, 0x32, 0x3f, 0x83,
	0xb4, 0xee, 0x16, 0x08, 0x26, 0x0e, 0x5c, 0x76, 0x10, 0x49, 0x11, 0xdf, 0xe8, 0x1a, 0x00, 0xf3,
	0x5f, 0x60, 0xa7, 0xf1, 0x9c, 0x4b, 0x87, 0x1b, 0x0b, 0x49, 0x3b, 0x27, 0x28, 0xab, 0x82, 0x60,
	0xfe, 0x25, 0x09, 0x05, 0xd5, 0x1e, 0x6d, 0xcc, 0xba, 0x6d, 0x8e, 0xea, 0x23, 0x1d, 0x47, 0x85,
	0x68, 0x29, 0xae, 0x6e, 0xdb, 0xbd, 0xce, 0x34, 0xdc, 0xa5, 0xf6, 0x4f, 0xed, 0x52, 0x49, 0x09,
	0x7e, 0x63, 0x3c, 0xf0, 0x9e, 0x67, 0x4f, 0x6b, 0x6f, 0xef, 0x41, 0x0e, 0x1f, 0xfb, 0xdc, 0x69,
	0x12, 0x4f, 0x85, 0x26, 0x65, 0x67, 0x05, 0xa1, 0x2a, 0xa2, 0x20, 0x7c, 0xc1, 0x3d, 0x22, 0x5a,
	0xb5, 0xfb, 0x4c, 0x76, 0xbf, 0x82, 0x9d, 0x53, 0x14, 0xdb, 0x7d, 0x86, 0x76, 0x61, 0x52, 0x6f,
	0xeb, 0xb8, 0xa4, 0xcf, 0x15, 0x97, 0x82, 0x02, 0xd1, 0x31, 0x51, 0x32, 0x31, 0xa5, 0x52, 0x66,
	0xa6, 0x27, 0x13, 0x53, 0xda, 0x97, 0x29, 0xb6, 0xb5, 0xcc, 0xec, 0xb9, 0x65, 0x62, 0x4a, 0xd5,
	0xca, 0xfc, 0xad, 0x01, 0xd0, 0x0f, 0x84, 0x48, 0x8b, 0xd0, 0xe5, 0xbd, 0xb4, 0x10, 0xdf, 0x6f,
	0xad, 0x1c, 0x8a, 0x90, 0x69, 0x92, 0x80, 0xe3, 0x80, 0x17, 0x93, 0xd2, 0xb6, 0x68, 0x19, 0xaf,
	0x50, 0x3a, 0x30, 0x3d, 0x12, 0xd4, 0xcb, 0xd4, 0xd6, 0x7c, 0x9d, 0x80, 0x29, 0x25, 0x1d, 0xdb,
	0xf8, 0x3b, 0xdd, 0xa8, 0x9e, 0x03, 0xc6, 0xdd, 0xa0, 0x89, 0x9d, 0x81, 0x12, 0x2d, 0x44, 0xc4,
	0x2d, 0x5d, 0xaa, 0xae, 0x2c, 0x92, 0x71, 0xe5, 0xeb, 0xd2, 0xd2, 0xdc, 0xa8, 0x0c, 0xb3, 0xec,
	0xd0, 0x0f, 0xd5, 0xdc, 0x73, 0xda, 0x84, 0x1c, 0x76, 0x43, 0xe9, 0xb7, 0xac, 0x3d, 0x2d, 0x36,
	0xe4, 0xf4, 0xdb, 0x94, 0x64, 0x74, 0x1d, 0xde, 0xe5, 0x84, 0xbb, 0x6d, 0x47, 0x5d, 0x2e, 0x44,
	0x35, 0x3a, 0x4d, 0xd2, 0x0d, 0xb8, 0x4e, 0xeb, 0x77, 0xe4, 0xee, 0x9d, 0x40, 0x47, 0xb9, 0x2a,
	0xb6, 0x4e, 0x65, 0x52, 0x95, 0x9f, 0x92, 0x95, 0x3f, 0xc2, 0xa4, 0x7a, 0xc0, 0x0f, 0x0c, 0x98,
	0xee, 0x79, 0x85, 0x85, 0x24, 0x60, 0x18, 0x6d, 0x42, 0x9a, 0xca, 0x86, 0xa0, 0xef, 0x48, 0x9f,
	0x8c, 0x69, 0xb1, 0xe4, 0xb5, 0x35, 0x86, 0x70, 0xb2, 0x34, 0xd9, 0x73, 0x34, 0x68, 0x42, 0xe5,
	0x82, 0x22, 0xaa, 0xc3, 0xe6, 0xbf, 0x13, 0x50, 0xd4, 0x6a, 0x6c, 0x47, 0xd7, 0xbf, 0x7b, 0x98,
	0xbb, 0x9e, 0xcb, 0x5d, 0xf4, 0x14, 0x52, 0x8c, 0xbb, 0x2d, 0x15, 0x9e, 0xa9, 0xa5, 0xf5, 0xb8,
	0xea, 0x9c, 0x05, 0x68, 0xed, 0x0a, 0x34, 0x5b, 0x81, 0x8a, 0x2a, 0x54, 0x11, 0xba, 0xd8, 0xf5,
	0xad, 0xa0, 0x40, 0x74, 0xe5, 0x7f, 0x04, 0x48, 0xb7, 0x13, 0xc6, 0x29, 0x76, 0x3b, 0x2a, 0xbd,
	0x92, 0x32, 0xbd, 0x66, 0xd4, 0xce, 0xae, 0xdc, 0x90, 0x29, 0xa6, 0x4e, 0x8b, 0x46, 0x30, 0x78,
	0x7a, 0xa2, 0x77, 0x1a, 0x53, 0xda, 0x3f, 0x6d, 0x6e, 0x43, 0x4a, 0x1a, 0x80, 0xf2, 0x90, 0xa9,
	0x6f, 0xdd, 0xdd, 0xda, 0x7e, 0xb8, 0x35, 0xf3, 0x05, 0x34, 0x0d, 0xf9, 0xea, 0x4a, 0xf5, 0x76,
	0xcd, 0xa9, 0xde, 0xae, 0x55, 0xef, 0xce, 0x18, 0x08, 0x20, 0x7d, 0xbf, 0x5e, 0xab, 0xd7, 0xd6,
	0x66, 0x12, 0x68, 0x12, 0x72, 0xb5, 0x47, 0xb5, 0x6a, 0x7d, 0xef, 0xce, 0xd6, 0xc6, 0x4c, 0x52,
	0x2c, 0xab, 0xdb, 0xf7, 0x76, 0x36, 0x6b, 0x7b, 0xb5, 0xb5, 0x99, 0x09, 0xf3, 0x67, 0x06, 0xbc,
	0xbb, 0x81, 0xf9, 0x50, 0xf4, 0xc6, 0xa9, 0x90, 0xcb, 0xf0, 0xa0, 0xf9, 0x2f, 0x03, 0xae, 0xd6,
	0x43, 0xcf, 0xe5, 0xf8, 0x73, 0xa5, 0x17, 0x7a, 0xdc, 0x03, 0xd5, 0xe9, 0x9c, 0xbc, 0x40, 0x8d,
	0x68, 0x68, 0x5d, 0x04, 0x3f, 0x35, 0xe0, 0xca, 0xba, 0x1f, 0x78, 0xf7, 0x7c, 0xc6, 0xfc, 0xa0,
	0xb5, 0xda, 0x26, 0x0d, 0x36, 0x96, 0xc1, 0xf7, 0xa1, 0xd0, 0x68, 0x93, 0x86, 0x36, 0x37, 0x9a,
	0xdf, 0xe3, 0xda, 0x9b, 0x17, 0x18, 0xea, 0x9b, 0x99, 0xdf, 0x85, 0xe2, 0x49, 0x95, 0x74, 0x9f,
	0xf8, 0x16, 0xcc, 0x75, 0x14, 0xdd, 0x79, 0x0b, 0x62, 0x51, 0xa7, 0x2f, 0x23, 0x92, 0xfe, 0x3d,
	0x98, 0x55, 0x39, 0x20, 0x88, 0x91, 0x2b, 0xe4, 0x53, 0x4e, 0xce, 0x99, 0x0b, 0x3f, 0xe5, 0x24,
	0x4a, 0xff, 0x02, 0x25, 0x9a, 0x83, 0x4c, 0x92, 0x82, 0x2d, 0xbf, 0xcd, 0x9f, 0x1b, 0x70, 0x65,
	0xd5, 0xe5, 0xcd, 0x83, 0xbe, 0x16, 0xe3, 0x45, 0xa4, 0x0e, 0x59, 0xaa, 0xce, 0x47, 0x6e, 0x89,
	0x7d, 0xb1, 0x3f, 0x61, 0xb8, 0xdd, 0x83, 0x32, 0x7f, 0x9c, 0x80, 0xe2, 0x49, 0xbd, 0x74, 0x58,
	0x5a, 0x90, 0xa3, 0xfa, 0x3b, 0xba, 0xb3, 0xdf, 0x89, 0x2b, 0xf4, 0x2c, 0x50, 0x2b, 0xfa, 0xb0,
	0xfb, 0xd8, 0xa5, 0x1f, 0x1a, 0x90, 0xed, 0x49, 0xdd, 0x86, 0xfc, 0x40, 0x12, 0x9c, 0x33, 0x24,
	0xd0, 0x4f, 0x3d, 0x54, 0x86, 0xb4, 0x7a, 0xcc, 0xeb, 0xb2, 0x45, 0x11, 0x16, 0x0d, 0x9b, 0xa2,
	0x83, 0xf3, 0x2e, 0xb3, 0xf5, 0x09, 0xf3, 0x4f, 0x06, 0x4c, 0x6d, 0x60, 0xbe, 0x47, 0xf1, 0x78,
	0xb3, 0x7d, 0x1b, 0xf2, 0x17, 0x7f, 0xb8, 0x03, 0xed, 0xbf, 0xd9, 0xdf, 0x83, 0x5c, 0xe8, 0xb6,
	0xb0, 0x23, 0x2e, 0xd9, 0xb2, 0x33, 0xa4, 0xec, 0xac, 0x20, 0xec, 0xfa, 0x2f, 0xe4, 0x15, 0x54,
	0x6e, 0x72, 0x72, 0x88, 0x03, 0xdd, 0xde, 0xe5, 0xf1, 0x3d, 0x41, 0x30, 0x7f, 0x62, 0xc0, 0x74,
	0xcf, 0x08, 0xed, 0xd5, 0xdd, 0xe1, 0x37, 0x93, 0x8a, 0xe6, 0xe2, 0xd8, 0x6f, 0xa6, 0xa1, 0xf7,
	0x12, 0xfa, 0x10, 0xa6, 0x03, 0x7c, 0xcc, 0x9d, 0x01, 0x65, 0xd4, 0xf3, 0x6f, 0x52, 0x90, 0x77,
	0x22, 0x85, 0x96, 0x7e, 0x63, 0x40, 0xae, 0x16, 0x61, 0xa2, 0x5f, 0x18, 0x90, 0xd1, 0x13, 0x15,
	0x7d, 0x75, 0xcc, 0x11, 0xac, 0x83, 0x52, 0xba, 0x16, 0xf1, 0x0d, 0xfc, 0xef, 0xb1, 0x7a, 0xf3,
	0xd9, 0xfc, 0xf4, 0xfb, 0x7f, 0xfd, 0xc7, 0xeb, 0x44, 0xc5, 0x2c, 0x47, 0xff, 0x9e, 0x5e, 0x0e,
	0x85, 0xf0, 0x66, 0xb9, 0xfc, 0xaa, 0xa2, 0x3a, 0x26, 0x5b, 0x56, 0xa2, 0xf0, 0xb2, 0x51, 0x5e,
	0xfa, 0x4f, 0x12, 0xf2, 0xaa, 0xad, 0xca, 0x3b, 0x14, 0xfa, 0xa7, 0x72, 0xe4, 0xd0, 0xd3, 0xe6,
	0xeb, 0x71, 0x35, 0x3e, 0x7d, 0x10, 0x96, 0xce, 0xd5, 0xdf, 0x4d, 0x57, 0x1a, 0xf4, 0x4d, 0xf4,
	0xf8, 0x8d, 0x06, 0x7d, 0xac, 0xa6, 0x09, 0xab, 0xbc, 0x1c, 0x1a, 0x59, 0x96, 0x78, 0xc7, 0xbd,
	0x1a, 0x25, 0xf6, 0x1f, 0x75, 0xaf, 0xd0, 0x7f, 0x0d, 0x40, 0x27, 0xe7, 0x24, 0x5a, 0x19, 0xaf,
	0xcd, 0xbc, 0x3d, 0x93, 0x43, 0x69, 0xf2, 0xb7, 0x4b, 0x97, 0x67, 0xf2, 0xf2, 0xf0, 0x00, 0x5e,
	0xfa, 0x65, 0x0a, 0xae, 0x56, 0x55, 0x2b, 0x5f, 0xf1, 0x3c, 0x8a, 0x19, 0x13, 0xcf, 0x8b, 0x5d,
	0x4e, 0xa8, 0xb8, 0x24, 0xfd, 0xd9, 0x80, 0x99, 0xd1, 0x09, 0x86, 0x6e, 0xc5, 0xff, 0x87, 0x71,
	0xea, 0x38, 0x2e, 0x7d, 0xe3, 0xfc, 0x00, 0xaa, 0xb2, 0xcd, 0x1b, 0xd2, 0x4f, 0x8b, 0xe6, 0x47,
	0xff, 0xc7, 0x4f, 0xa2, 0x1b, 0xb2, 0xe5, 0xfd, 0x3e, 0xc4, 0xb2, 0x51, 0x96, 0x06, 0x8d, 0xb6,
	0xe9, 0xf8, 0x06, 0x9d, 0x31, 0xcd, 0xe2, 0x1b, 0x74, 0xd6, 0x84, 0x18, 0xc3, 0xa0, 0x46, 0x1f,
	0x42, 0x18, 0xf4, 0x37, 0x03, 0x32, 0xba, 0xef, 0xc5, 0x6f, 0x2c, 0xc3, 0xdd, 0xbe, 0x74, 0x63,
	0x6c, 0x3e, 0xad, 0xf5, 0x53, 0xa9, 0xf5, 0x03, 0xb4, 0xf7, 0x26, 0xad, 0x2b, 0x2f, 0x07, 0x26,
	0x45, 0x94, 0xa3, 0x83, 0xa4, 0xc1, 0x0c, 0x6d, 0x29, 0x29, 0xab, 0x7f, 0x34, 0xa0, 0xdc, 0x24,
	0x9d, 0x98, 0xca, 0xad, 0xce, 0xd9, 0x92, 0xde, 0xeb, 0xb9, 0x3b, 0x94, 0x70, 0xb2, 0x63, 0x3c,
	0xa9, 0x6b, 0xfe, 0x16, 0x69, 0xbb, 0x41, 0xcb, 0x22, 0xb4, 0x55, 0x69, 0xe1, 0x40, 0xfe, 0x65,
	0xad, 0xa8, 0x2d, 0x37, 0xf4, 0xd9, 0x9b, 0xfe, 0xe4, 0x7f, 0x36, 0x42, 0xfe, 0x75, 0x22, 0x69,
	0xd7, 0x1e, 0xfd, 0x2e, 0x71, 0x6d, 0x43, 0xa1, 0x8f, 0x08, 0xb7, 0x1e, 0x2c, 0xee, 0x61, 0xc6,
	0x1b, 0x69, 0x29, 0xe7, 0xfa, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0xde, 0xd9, 0x80, 0xd0, 0x30,
	0x18, 0x00, 0x00,
}
