// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/clouderrorreporting/v1beta1/error_group_service.proto

package clouderrorreporting

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A request to return an individual group.
type GetGroupRequest struct {
	// [Required] The group resource name. Written as
	// <code>projects/<var>projectID</var>/groups/<var>group_name</var></code>.
	// Call
	// <a href="/error-reporting/reference/rest/v1beta1/projects.groupStats/list">
	// <code>groupStats.list</code></a> to return a list of groups belonging to
	// this project.
	//
	// Example: <code>projects/my-project-123/groups/my-group</code>
	GroupName string `protobuf:"bytes,1,opt,name=group_name,json=groupName" json:"group_name,omitempty"`
}

func (m *GetGroupRequest) Reset()                    { *m = GetGroupRequest{} }
func (m *GetGroupRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGroupRequest) ProtoMessage()               {}
func (*GetGroupRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *GetGroupRequest) GetGroupName() string {
	if m != nil {
		return m.GroupName
	}
	return ""
}

// A request to replace the existing data for the given group.
type UpdateGroupRequest struct {
	// [Required] The group which replaces the resource on the server.
	Group *ErrorGroup `protobuf:"bytes,1,opt,name=group" json:"group,omitempty"`
}

func (m *UpdateGroupRequest) Reset()                    { *m = UpdateGroupRequest{} }
func (m *UpdateGroupRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateGroupRequest) ProtoMessage()               {}
func (*UpdateGroupRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *UpdateGroupRequest) GetGroup() *ErrorGroup {
	if m != nil {
		return m.Group
	}
	return nil
}

func init() {
	proto.RegisterType((*GetGroupRequest)(nil), "google.devtools.clouderrorreporting.v1beta1.GetGroupRequest")
	proto.RegisterType((*UpdateGroupRequest)(nil), "google.devtools.clouderrorreporting.v1beta1.UpdateGroupRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ErrorGroupService service

type ErrorGroupServiceClient interface {
	// Get the specified group.
	GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*ErrorGroup, error)
	// Replace the data for the specified group.
	// Fails if the group does not exist.
	UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*ErrorGroup, error)
}

type errorGroupServiceClient struct {
	cc *grpc.ClientConn
}

func NewErrorGroupServiceClient(cc *grpc.ClientConn) ErrorGroupServiceClient {
	return &errorGroupServiceClient{cc}
}

func (c *errorGroupServiceClient) GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*ErrorGroup, error) {
	out := new(ErrorGroup)
	err := grpc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/GetGroup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *errorGroupServiceClient) UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*ErrorGroup, error) {
	out := new(ErrorGroup)
	err := grpc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/UpdateGroup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ErrorGroupService service

type ErrorGroupServiceServer interface {
	// Get the specified group.
	GetGroup(context.Context, *GetGroupRequest) (*ErrorGroup, error)
	// Replace the data for the specified group.
	// Fails if the group does not exist.
	UpdateGroup(context.Context, *UpdateGroupRequest) (*ErrorGroup, error)
}

func RegisterErrorGroupServiceServer(s *grpc.Server, srv ErrorGroupServiceServer) {
	s.RegisterService(&_ErrorGroupService_serviceDesc, srv)
}

func _ErrorGroupService_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorGroupServiceServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorGroupServiceServer).GetGroup(ctx, req.(*GetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ErrorGroupService_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorGroupServiceServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/UpdateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorGroupServiceServer).UpdateGroup(ctx, req.(*UpdateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ErrorGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouderrorreporting.v1beta1.ErrorGroupService",
	HandlerType: (*ErrorGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetGroup",
			Handler:    _ErrorGroupService_GetGroup_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _ErrorGroupService_UpdateGroup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/clouderrorreporting/v1beta1/error_group_service.proto",
}

func init() {
	proto.RegisterFile("google/devtools/clouderrorreporting/v1beta1/error_group_service.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 381 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x92, 0x4f, 0x4a, 0x03, 0x31,
	0x18, 0xc5, 0x99, 0x8a, 0x62, 0xd3, 0x85, 0x98, 0x85, 0xc8, 0xa0, 0x20, 0x75, 0xa3, 0x2d, 0x24,
	0x4e, 0x5d, 0x58, 0xfc, 0x83, 0x50, 0x29, 0x5d, 0x29, 0xa5, 0xa2, 0x0b, 0x17, 0x96, 0x74, 0x1a,
	0xc2, 0xc8, 0x4c, 0xbe, 0x31, 0x93, 0x76, 0x23, 0x6e, 0x3c, 0x80, 0x1b, 0x6f, 0xe1, 0xda, 0x0b,
	0x78, 0x04, 0xf1, 0x0a, 0x1e, 0x44, 0x26, 0xe9, 0x1f, 0x6d, 0x2b, 0x38, 0xdd, 0xbe, 0xe4, 0x7b,
	0xef, 0x97, 0x97, 0x0f, 0xd5, 0x05, 0x80, 0x08, 0x39, 0xed, 0xf2, 0xbe, 0x06, 0x08, 0x13, 0xea,
	0x87, 0xd0, 0xeb, 0x72, 0xa5, 0x40, 0x29, 0x1e, 0x83, 0xd2, 0x81, 0x14, 0xb4, 0xef, 0x75, 0xb8,
	0x66, 0x1e, 0x35, 0x72, 0x5b, 0x28, 0xe8, 0xc5, 0xed, 0x84, 0xab, 0x7e, 0xe0, 0x73, 0x12, 0x2b,
	0xd0, 0x80, 0xcb, 0xd6, 0x86, 0x0c, 0x6d, 0xc8, 0x0c, 0x1b, 0x32, 0xb0, 0x71, 0x37, 0x06, 0x99,
	0x2c, 0x0e, 0x28, 0x93, 0x12, 0x34, 0xd3, 0x01, 0xc8, 0xc4, 0x5a, 0xb9, 0xd5, 0x2c, 0x44, 0x3e,
	0x44, 0x11, 0x48, 0x3b, 0x59, 0xdc, 0x43, 0x2b, 0x0d, 0xae, 0x1b, 0x29, 0x5e, 0x8b, 0xdf, 0xf7,
	0x78, 0xa2, 0xf1, 0x26, 0x42, 0x16, 0x57, 0xb2, 0x88, 0xaf, 0x3b, 0x5b, 0xce, 0x4e, 0xbe, 0x95,
	0x37, 0xca, 0x05, 0x8b, 0x78, 0xd1, 0x47, 0xf8, 0x2a, 0xee, 0x32, 0xcd, 0x7f, 0x0d, 0x9d, 0xa3,
	0x45, 0x73, 0xc5, 0xdc, 0x2f, 0x54, 0x0e, 0x48, 0x86, 0xc7, 0x91, 0x7a, 0x2a, 0x5b, 0x3b, 0xeb,
	0x52, 0x79, 0x5e, 0x40, 0xab, 0x63, 0xf5, 0xd2, 0xf6, 0x86, 0xdf, 0x1c, 0xb4, 0x3c, 0xa4, 0xc5,
	0xc7, 0x99, 0x22, 0x26, 0x1e, 0xe9, 0xce, 0x0b, 0x58, 0xf4, 0x9e, 0x3e, 0xbf, 0x5e, 0x72, 0x65,
	0xbc, 0x3b, 0xea, 0xf3, 0x61, 0xdc, 0xd6, 0x49, 0xac, 0xe0, 0x8e, 0xfb, 0x3a, 0xa1, 0x25, 0x6a,
	0xd4, 0x84, 0x96, 0x1e, 0xf1, 0xbb, 0x83, 0x0a, 0x3f, 0x2a, 0xc3, 0xa7, 0x99, 0xb2, 0xa7, 0xcb,
	0x9e, 0x1f, 0xbe, 0x6a, 0xe0, 0x2b, 0xee, 0x24, 0x3c, 0xf9, 0x13, 0xfe, 0xd0, 0x7e, 0x48, 0xed,
	0xc3, 0x41, 0xe9, 0xe2, 0x64, 0x09, 0xae, 0xad, 0x4d, 0xfd, 0x60, 0x33, 0xdd, 0xb9, 0xa6, 0x73,
	0x73, 0x3b, 0xb0, 0x11, 0x10, 0x32, 0x29, 0x08, 0x28, 0x41, 0x05, 0x97, 0x66, 0x23, 0xa9, 0x3d,
	0x62, 0x71, 0x90, 0xfc, 0x6b, 0x9d, 0x8f, 0x66, 0x9c, 0xbd, 0xe6, 0xb6, 0x1b, 0x36, 0xe0, 0x2c,
	0x3d, 0xb4, 0x0d, 0xb4, 0x46, 0x7c, 0xd7, 0x5e, 0x2d, 0x9d, 0xec, 0x2c, 0x99, 0xc0, 0xfd, 0xef,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x9c, 0xb7, 0x37, 0x79, 0xd0, 0x03, 0x00, 0x00,
}
