// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/pubsub/v1/pubsub.proto

/*
Package pubsub is a generated protocol buffer package.

It is generated from these files:
	google/pubsub/v1/pubsub.proto

It has these top-level messages:
	Topic
	PubsubMessage
	GetTopicRequest
	PublishRequest
	PublishResponse
	ListTopicsRequest
	ListTopicsResponse
	ListTopicSubscriptionsRequest
	ListTopicSubscriptionsResponse
	DeleteTopicRequest
	Subscription
	PushConfig
	ReceivedMessage
	GetSubscriptionRequest
	UpdateSubscriptionRequest
	ListSubscriptionsRequest
	ListSubscriptionsResponse
	DeleteSubscriptionRequest
	ModifyPushConfigRequest
	PullRequest
	PullResponse
	ModifyAckDeadlineRequest
	AcknowledgeRequest
	StreamingPullRequest
	StreamingPullResponse
	CreateSnapshotRequest
	Snapshot
	ListSnapshotsRequest
	ListSnapshotsResponse
	DeleteSnapshotRequest
	SeekRequest
	SeekResponse
*/
package pubsub

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A topic resource.
type Topic struct {
	// The name of the topic. It must have the format
	// `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
	// and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
	// underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
	// signs (`%`). It must be between 3 and 255 characters in length, and it
	// must not start with `"goog"`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *Topic) Reset()                    { *m = Topic{} }
func (m *Topic) String() string            { return proto.CompactTextString(m) }
func (*Topic) ProtoMessage()               {}
func (*Topic) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Topic) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A message data and its attributes. The message payload must not be empty;
// it must contain either a non-empty data field, or at least one attribute.
type PubsubMessage struct {
	// The message payload.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Optional attributes for this message.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ID of this message, assigned by the server when the message is published.
	// Guaranteed to be unique within the topic. This value may be read by a
	// subscriber that receives a `PubsubMessage` via a `Pull` call or a push
	// delivery. It must not be populated by the publisher in a `Publish` call.
	MessageId string `protobuf:"bytes,3,opt,name=message_id,json=messageId" json:"message_id,omitempty"`
	// The time at which the message was published, populated by the server when
	// it receives the `Publish` call. It must not be populated by the
	// publisher in a `Publish` call.
	PublishTime *google_protobuf4.Timestamp `protobuf:"bytes,4,opt,name=publish_time,json=publishTime" json:"publish_time,omitempty"`
}

func (m *PubsubMessage) Reset()                    { *m = PubsubMessage{} }
func (m *PubsubMessage) String() string            { return proto.CompactTextString(m) }
func (*PubsubMessage) ProtoMessage()               {}
func (*PubsubMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *PubsubMessage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *PubsubMessage) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *PubsubMessage) GetMessageId() string {
	if m != nil {
		return m.MessageId
	}
	return ""
}

func (m *PubsubMessage) GetPublishTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.PublishTime
	}
	return nil
}

// Request for the GetTopic method.
type GetTopicRequest struct {
	// The name of the topic to get.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
}

func (m *GetTopicRequest) Reset()                    { *m = GetTopicRequest{} }
func (m *GetTopicRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTopicRequest) ProtoMessage()               {}
func (*GetTopicRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GetTopicRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// Request for the Publish method.
type PublishRequest struct {
	// The messages in the request will be published on this topic.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
	// The messages to publish.
	Messages []*PubsubMessage `protobuf:"bytes,2,rep,name=messages" json:"messages,omitempty"`
}

func (m *PublishRequest) Reset()                    { *m = PublishRequest{} }
func (m *PublishRequest) String() string            { return proto.CompactTextString(m) }
func (*PublishRequest) ProtoMessage()               {}
func (*PublishRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *PublishRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *PublishRequest) GetMessages() []*PubsubMessage {
	if m != nil {
		return m.Messages
	}
	return nil
}

// Response for the `Publish` method.
type PublishResponse struct {
	// The server-assigned ID of each published message, in the same order as
	// the messages in the request. IDs are guaranteed to be unique within
	// the topic.
	MessageIds []string `protobuf:"bytes,1,rep,name=message_ids,json=messageIds" json:"message_ids,omitempty"`
}

func (m *PublishResponse) Reset()                    { *m = PublishResponse{} }
func (m *PublishResponse) String() string            { return proto.CompactTextString(m) }
func (*PublishResponse) ProtoMessage()               {}
func (*PublishResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *PublishResponse) GetMessageIds() []string {
	if m != nil {
		return m.MessageIds
	}
	return nil
}

// Request for the `ListTopics` method.
type ListTopicsRequest struct {
	// The name of the cloud project that topics belong to.
	// Format is `projects/{project}`.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Maximum number of topics to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListTopicsResponse`; indicates that this is
	// a continuation of a prior `ListTopics` call, and that the system should
	// return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListTopicsRequest) Reset()                    { *m = ListTopicsRequest{} }
func (m *ListTopicsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTopicsRequest) ProtoMessage()               {}
func (*ListTopicsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ListTopicsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListTopicsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTopicsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListTopics` method.
type ListTopicsResponse struct {
	// The resulting topics.
	Topics []*Topic `protobuf:"bytes,1,rep,name=topics" json:"topics,omitempty"`
	// If not empty, indicates that there may be more topics that match the
	// request; this value should be passed in a new `ListTopicsRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTopicsResponse) Reset()                    { *m = ListTopicsResponse{} }
func (m *ListTopicsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTopicsResponse) ProtoMessage()               {}
func (*ListTopicsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ListTopicsResponse) GetTopics() []*Topic {
	if m != nil {
		return m.Topics
	}
	return nil
}

func (m *ListTopicsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `ListTopicSubscriptions` method.
type ListTopicSubscriptionsRequest struct {
	// The name of the topic that subscriptions are attached to.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
	// Maximum number of subscription names to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListTopicSubscriptionsResponse`; indicates
	// that this is a continuation of a prior `ListTopicSubscriptions` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListTopicSubscriptionsRequest) Reset()                    { *m = ListTopicSubscriptionsRequest{} }
func (m *ListTopicSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsRequest) ProtoMessage()               {}
func (*ListTopicSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ListTopicSubscriptionsRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *ListTopicSubscriptionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTopicSubscriptionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListTopicSubscriptions` method.
type ListTopicSubscriptionsResponse struct {
	// The names of the subscriptions that match the request.
	Subscriptions []string `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new
	// `ListTopicSubscriptionsRequest` to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTopicSubscriptionsResponse) Reset()                    { *m = ListTopicSubscriptionsResponse{} }
func (m *ListTopicSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsResponse) ProtoMessage()               {}
func (*ListTopicSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListTopicSubscriptionsResponse) GetSubscriptions() []string {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListTopicSubscriptionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `DeleteTopic` method.
type DeleteTopicRequest struct {
	// Name of the topic to delete.
	// Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
}

func (m *DeleteTopicRequest) Reset()                    { *m = DeleteTopicRequest{} }
func (m *DeleteTopicRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTopicRequest) ProtoMessage()               {}
func (*DeleteTopicRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DeleteTopicRequest) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// A subscription resource.
type Subscription struct {
	// The name of the subscription. It must have the format
	// `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
	// start with a letter, and contain only letters (`[A-Za-z]`), numbers
	// (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
	// plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
	// in length, and it must not start with `"goog"`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of the topic from which this subscription is receiving messages.
	// Format is `projects/{project}/topics/{topic}`.
	// The value of this field will be `_deleted-topic_` if the topic has been
	// deleted.
	Topic string `protobuf:"bytes,2,opt,name=topic" json:"topic,omitempty"`
	// If push delivery is used with this subscription, this field is
	// used to configure it. An empty `pushConfig` signifies that the subscriber
	// will pull and ack messages using API methods.
	PushConfig *PushConfig `protobuf:"bytes,4,opt,name=push_config,json=pushConfig" json:"push_config,omitempty"`
	// This value is the maximum time after a subscriber receives a message
	// before the subscriber should acknowledge the message. After message
	// delivery but before the ack deadline expires and before the message is
	// acknowledged, it is an outstanding message and will not be delivered
	// again during that time (on a best-effort basis).
	//
	// For pull subscriptions, this value is used as the initial value for the ack
	// deadline. To override this value for a given message, call
	// `ModifyAckDeadline` with the corresponding `ack_id` if using
	// pull.
	// The minimum custom deadline you can specify is 10 seconds.
	// The maximum custom deadline you can specify is 600 seconds (10 minutes).
	// If this parameter is 0, a default value of 10 seconds is used.
	//
	// For push delivery, this value is also used to set the request timeout for
	// the call to the push endpoint.
	//
	// If the subscriber never acknowledges the message, the Pub/Sub
	// system will eventually redeliver the message.
	AckDeadlineSeconds int32 `protobuf:"varint,5,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds" json:"ack_deadline_seconds,omitempty"`
	// Indicates whether to retain acknowledged messages. If true, then
	// messages are not expunged from the subscription's backlog, even if they are
	// acknowledged, until they fall out of the `message_retention_duration`
	// window.
	RetainAckedMessages bool `protobuf:"varint,7,opt,name=retain_acked_messages,json=retainAckedMessages" json:"retain_acked_messages,omitempty"`
	// How long to retain unacknowledged messages in the subscription's backlog,
	// from the moment a message is published.
	// If `retain_acked_messages` is true, then this also configures the retention
	// of acknowledged messages, and thus configures how far back in time a `Seek`
	// can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
	// minutes.
	MessageRetentionDuration *google_protobuf1.Duration `protobuf:"bytes,8,opt,name=message_retention_duration,json=messageRetentionDuration" json:"message_retention_duration,omitempty"`
}

func (m *Subscription) Reset()                    { *m = Subscription{} }
func (m *Subscription) String() string            { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()               {}
func (*Subscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Subscription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subscription) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *Subscription) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

func (m *Subscription) GetAckDeadlineSeconds() int32 {
	if m != nil {
		return m.AckDeadlineSeconds
	}
	return 0
}

func (m *Subscription) GetRetainAckedMessages() bool {
	if m != nil {
		return m.RetainAckedMessages
	}
	return false
}

func (m *Subscription) GetMessageRetentionDuration() *google_protobuf1.Duration {
	if m != nil {
		return m.MessageRetentionDuration
	}
	return nil
}

// Configuration for a push delivery endpoint.
type PushConfig struct {
	// A URL locating the endpoint to which messages should be pushed.
	// For example, a Webhook endpoint might use "https://example.com/push".
	PushEndpoint string `protobuf:"bytes,1,opt,name=push_endpoint,json=pushEndpoint" json:"push_endpoint,omitempty"`
	// Endpoint configuration attributes.
	//
	// Every endpoint has a set of API supported attributes that can be used to
	// control different aspects of the message delivery.
	//
	// The currently supported attribute is `x-goog-version`, which you can
	// use to change the format of the pushed message. This attribute
	// indicates the version of the data expected by the endpoint. This
	// controls the shape of the pushed message (i.e., its fields and metadata).
	// The endpoint version is based on the version of the Pub/Sub API.
	//
	// If not present during the `CreateSubscription` call, it will default to
	// the version of the API used to make such call. If not present during a
	// `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
	// calls will always return a valid version, even if the subscription was
	// created without this attribute.
	//
	// The possible values for this attribute are:
	//
	// * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
	// * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *PushConfig) Reset()                    { *m = PushConfig{} }
func (m *PushConfig) String() string            { return proto.CompactTextString(m) }
func (*PushConfig) ProtoMessage()               {}
func (*PushConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *PushConfig) GetPushEndpoint() string {
	if m != nil {
		return m.PushEndpoint
	}
	return ""
}

func (m *PushConfig) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// A message and its corresponding acknowledgment ID.
type ReceivedMessage struct {
	// This ID can be used to acknowledge the received message.
	AckId string `protobuf:"bytes,1,opt,name=ack_id,json=ackId" json:"ack_id,omitempty"`
	// The message.
	Message *PubsubMessage `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (m *ReceivedMessage) Reset()                    { *m = ReceivedMessage{} }
func (m *ReceivedMessage) String() string            { return proto.CompactTextString(m) }
func (*ReceivedMessage) ProtoMessage()               {}
func (*ReceivedMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ReceivedMessage) GetAckId() string {
	if m != nil {
		return m.AckId
	}
	return ""
}

func (m *ReceivedMessage) GetMessage() *PubsubMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

// Request for the GetSubscription method.
type GetSubscriptionRequest struct {
	// The name of the subscription to get.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetSubscriptionRequest) Reset()                    { *m = GetSubscriptionRequest{} }
func (m *GetSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriptionRequest) ProtoMessage()               {}
func (*GetSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetSubscriptionRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

// Request for the UpdateSubscription method.
type UpdateSubscriptionRequest struct {
	// The updated subscription object.
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// Indicates which fields in the provided subscription to update.
	// Must be specified and non-empty.
	UpdateMask *google_protobuf3.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateSubscriptionRequest) Reset()                    { *m = UpdateSubscriptionRequest{} }
func (m *UpdateSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateSubscriptionRequest) ProtoMessage()               {}
func (*UpdateSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *UpdateSubscriptionRequest) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

func (m *UpdateSubscriptionRequest) GetUpdateMask() *google_protobuf3.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for the `ListSubscriptions` method.
type ListSubscriptionsRequest struct {
	// The name of the cloud project that subscriptions belong to.
	// Format is `projects/{project}`.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Maximum number of subscriptions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListSubscriptionsResponse`; indicates that
	// this is a continuation of a prior `ListSubscriptions` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListSubscriptionsRequest) Reset()                    { *m = ListSubscriptionsRequest{} }
func (m *ListSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSubscriptionsRequest) ProtoMessage()               {}
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ListSubscriptionsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListSubscriptionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSubscriptionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListSubscriptions` method.
type ListSubscriptionsResponse struct {
	// The subscriptions that match the request.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new
	// `ListSubscriptionsRequest` to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListSubscriptionsResponse) Reset()                    { *m = ListSubscriptionsResponse{} }
func (m *ListSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSubscriptionsResponse) ProtoMessage()               {}
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListSubscriptionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the DeleteSubscription method.
type DeleteSubscriptionRequest struct {
	// The subscription to delete.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *DeleteSubscriptionRequest) Reset()                    { *m = DeleteSubscriptionRequest{} }
func (m *DeleteSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSubscriptionRequest) ProtoMessage()               {}
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *DeleteSubscriptionRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

// Request for the ModifyPushConfig method.
type ModifyPushConfigRequest struct {
	// The name of the subscription.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The push configuration for future deliveries.
	//
	// An empty `pushConfig` indicates that the Pub/Sub system should
	// stop pushing messages from the given subscription and allow
	// messages to be pulled and acknowledged - effectively pausing
	// the subscription if `Pull` is not called.
	PushConfig *PushConfig `protobuf:"bytes,2,opt,name=push_config,json=pushConfig" json:"push_config,omitempty"`
}

func (m *ModifyPushConfigRequest) Reset()                    { *m = ModifyPushConfigRequest{} }
func (m *ModifyPushConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*ModifyPushConfigRequest) ProtoMessage()               {}
func (*ModifyPushConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ModifyPushConfigRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *ModifyPushConfigRequest) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

// Request for the `Pull` method.
type PullRequest struct {
	// The subscription from which messages should be pulled.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// If this field set to true, the system will respond immediately even if
	// it there are no messages available to return in the `Pull` response.
	// Otherwise, the system may wait (for a bounded amount of time) until at
	// least one message is available, rather than returning no messages. The
	// client may cancel the request if it does not wish to wait any longer for
	// the response.
	ReturnImmediately bool `protobuf:"varint,2,opt,name=return_immediately,json=returnImmediately" json:"return_immediately,omitempty"`
	// The maximum number of messages returned for this request. The Pub/Sub
	// system may return fewer than the number specified.
	MaxMessages int32 `protobuf:"varint,3,opt,name=max_messages,json=maxMessages" json:"max_messages,omitempty"`
}

func (m *PullRequest) Reset()                    { *m = PullRequest{} }
func (m *PullRequest) String() string            { return proto.CompactTextString(m) }
func (*PullRequest) ProtoMessage()               {}
func (*PullRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *PullRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *PullRequest) GetReturnImmediately() bool {
	if m != nil {
		return m.ReturnImmediately
	}
	return false
}

func (m *PullRequest) GetMaxMessages() int32 {
	if m != nil {
		return m.MaxMessages
	}
	return 0
}

// Response for the `Pull` method.
type PullResponse struct {
	// Received Pub/Sub messages. The Pub/Sub system will return zero messages if
	// there are no more available in the backlog. The Pub/Sub system may return
	// fewer than the `maxMessages` requested even if there are more messages
	// available in the backlog.
	ReceivedMessages []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages" json:"received_messages,omitempty"`
}

func (m *PullResponse) Reset()                    { *m = PullResponse{} }
func (m *PullResponse) String() string            { return proto.CompactTextString(m) }
func (*PullResponse) ProtoMessage()               {}
func (*PullResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *PullResponse) GetReceivedMessages() []*ReceivedMessage {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

// Request for the ModifyAckDeadline method.
type ModifyAckDeadlineRequest struct {
	// The name of the subscription.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// List of acknowledgment IDs.
	AckIds []string `protobuf:"bytes,4,rep,name=ack_ids,json=ackIds" json:"ack_ids,omitempty"`
	// The new ack deadline with respect to the time this request was sent to
	// the Pub/Sub system. For example, if the value is 10, the new
	// ack deadline will expire 10 seconds after the `ModifyAckDeadline` call
	// was made. Specifying zero may immediately make the message available for
	// another pull request.
	// The minimum deadline you can specify is 0 seconds.
	// The maximum deadline you can specify is 600 seconds (10 minutes).
	AckDeadlineSeconds int32 `protobuf:"varint,3,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds" json:"ack_deadline_seconds,omitempty"`
}

func (m *ModifyAckDeadlineRequest) Reset()                    { *m = ModifyAckDeadlineRequest{} }
func (m *ModifyAckDeadlineRequest) String() string            { return proto.CompactTextString(m) }
func (*ModifyAckDeadlineRequest) ProtoMessage()               {}
func (*ModifyAckDeadlineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *ModifyAckDeadlineRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *ModifyAckDeadlineRequest) GetAckIds() []string {
	if m != nil {
		return m.AckIds
	}
	return nil
}

func (m *ModifyAckDeadlineRequest) GetAckDeadlineSeconds() int32 {
	if m != nil {
		return m.AckDeadlineSeconds
	}
	return 0
}

// Request for the Acknowledge method.
type AcknowledgeRequest struct {
	// The subscription whose message is being acknowledged.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The acknowledgment ID for the messages being acknowledged that was returned
	// by the Pub/Sub system in the `Pull` response. Must not be empty.
	AckIds []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds" json:"ack_ids,omitempty"`
}

func (m *AcknowledgeRequest) Reset()                    { *m = AcknowledgeRequest{} }
func (m *AcknowledgeRequest) String() string            { return proto.CompactTextString(m) }
func (*AcknowledgeRequest) ProtoMessage()               {}
func (*AcknowledgeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *AcknowledgeRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *AcknowledgeRequest) GetAckIds() []string {
	if m != nil {
		return m.AckIds
	}
	return nil
}

// Request for the `StreamingPull` streaming RPC method. This request is used to
// establish the initial stream as well as to stream acknowledgements and ack
// deadline modifications from the client to the server.
type StreamingPullRequest struct {
	// The subscription for which to initialize the new stream. This must be
	// provided in the first request on the stream, and must not be set in
	// subsequent requests from client to server.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// List of acknowledgement IDs for acknowledging previously received messages
	// (received on this stream or a different stream). If an ack ID has expired,
	// the corresponding message may be redelivered later. Acknowledging a message
	// more than once will not result in an error. If the acknowledgement ID is
	// malformed, the stream will be aborted with status `INVALID_ARGUMENT`.
	AckIds []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds" json:"ack_ids,omitempty"`
	// The list of new ack deadlines for the IDs listed in
	// `modify_deadline_ack_ids`. The size of this list must be the same as the
	// size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
	// with `INVALID_ARGUMENT`. Each element in this list is applied to the
	// element in the same position in `modify_deadline_ack_ids`. The new ack
	// deadline is with respect to the time this request was sent to the Pub/Sub
	// system. Must be >= 0. For example, if the value is 10, the new ack deadline
	// will expire 10 seconds after this request is received. If the value is 0,
	// the message is immediately made available for another streaming or
	// non-streaming pull request. If the value is < 0 (an error), the stream will
	// be aborted with status `INVALID_ARGUMENT`.
	ModifyDeadlineSeconds []int32 `protobuf:"varint,3,rep,packed,name=modify_deadline_seconds,json=modifyDeadlineSeconds" json:"modify_deadline_seconds,omitempty"`
	// List of acknowledgement IDs whose deadline will be modified based on the
	// corresponding element in `modify_deadline_seconds`. This field can be used
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted.
	ModifyDeadlineAckIds []string `protobuf:"bytes,4,rep,name=modify_deadline_ack_ids,json=modifyDeadlineAckIds" json:"modify_deadline_ack_ids,omitempty"`
	// The ack deadline to use for the stream. This must be provided in the
	// first request on the stream, but it can also be updated on subsequent
	// requests from client to server. The minimum deadline you can specify is 10
	// seconds. The maximum deadline you can specify is 600 seconds (10 minutes).
	StreamAckDeadlineSeconds int32 `protobuf:"varint,5,opt,name=stream_ack_deadline_seconds,json=streamAckDeadlineSeconds" json:"stream_ack_deadline_seconds,omitempty"`
}

func (m *StreamingPullRequest) Reset()                    { *m = StreamingPullRequest{} }
func (m *StreamingPullRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamingPullRequest) ProtoMessage()               {}
func (*StreamingPullRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *StreamingPullRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *StreamingPullRequest) GetAckIds() []string {
	if m != nil {
		return m.AckIds
	}
	return nil
}

func (m *StreamingPullRequest) GetModifyDeadlineSeconds() []int32 {
	if m != nil {
		return m.ModifyDeadlineSeconds
	}
	return nil
}

func (m *StreamingPullRequest) GetModifyDeadlineAckIds() []string {
	if m != nil {
		return m.ModifyDeadlineAckIds
	}
	return nil
}

func (m *StreamingPullRequest) GetStreamAckDeadlineSeconds() int32 {
	if m != nil {
		return m.StreamAckDeadlineSeconds
	}
	return 0
}

// Response for the `StreamingPull` method. This response is used to stream
// messages from the server to the client.
type StreamingPullResponse struct {
	// Received Pub/Sub messages. This will not be empty.
	ReceivedMessages []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages" json:"received_messages,omitempty"`
}

func (m *StreamingPullResponse) Reset()                    { *m = StreamingPullResponse{} }
func (m *StreamingPullResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamingPullResponse) ProtoMessage()               {}
func (*StreamingPullResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *StreamingPullResponse) GetReceivedMessages() []*ReceivedMessage {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

// Request for the `CreateSnapshot` method.
type CreateSnapshotRequest struct {
	// Optional user-provided name for this snapshot.
	// If the name is not provided in the request, the server will assign a random
	// name for this snapshot on the same project as the subscription.
	// Note that for REST API requests, you must specify a name.
	// Format is `projects/{project}/snapshots/{snap}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The subscription whose backlog the snapshot retains.
	// Specifically, the created snapshot is guaranteed to retain:
	//  (a) The existing backlog on the subscription. More precisely, this is
	//      defined as the messages in the subscription's backlog that are
	//      unacknowledged upon the successful completion of the
	//      `CreateSnapshot` request; as well as:
	//  (b) Any messages published to the subscription's topic following the
	//      successful completion of the CreateSnapshot request.
	// Format is `projects/{project}/subscriptions/{sub}`.
	Subscription string `protobuf:"bytes,2,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *CreateSnapshotRequest) Reset()                    { *m = CreateSnapshotRequest{} }
func (m *CreateSnapshotRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateSnapshotRequest) ProtoMessage()               {}
func (*CreateSnapshotRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *CreateSnapshotRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateSnapshotRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

// A snapshot resource.
type Snapshot struct {
	// The name of the snapshot.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of the topic from which this snapshot is retaining messages.
	Topic string `protobuf:"bytes,2,opt,name=topic" json:"topic,omitempty"`
	// The snapshot is guaranteed to exist up until this time.
	// A newly-created snapshot expires no later than 7 days from the time of its
	// creation. Its exact lifetime is determined at creation by the existing
	// backlog in the source subscription. Specifically, the lifetime of the
	// snapshot is `7 days - (age of oldest unacked message in the subscription)`.
	// For example, consider a subscription whose oldest unacked message is 3 days
	// old. If a snapshot is created from this subscription, the snapshot -- which
	// will always capture this 3-day-old backlog as long as the snapshot
	// exists -- will expire in 4 days.
	ExpireTime *google_protobuf4.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime" json:"expire_time,omitempty"`
}

func (m *Snapshot) Reset()                    { *m = Snapshot{} }
func (m *Snapshot) String() string            { return proto.CompactTextString(m) }
func (*Snapshot) ProtoMessage()               {}
func (*Snapshot) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *Snapshot) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Snapshot) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *Snapshot) GetExpireTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

// Request for the `ListSnapshots` method.
type ListSnapshotsRequest struct {
	// The name of the cloud project that snapshots belong to.
	// Format is `projects/{project}`.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Maximum number of snapshots to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListSnapshotsResponse`; indicates that this
	// is a continuation of a prior `ListSnapshots` call, and that the system
	// should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListSnapshotsRequest) Reset()                    { *m = ListSnapshotsRequest{} }
func (m *ListSnapshotsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSnapshotsRequest) ProtoMessage()               {}
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *ListSnapshotsRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListSnapshotsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSnapshotsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListSnapshots` method.
type ListSnapshotsResponse struct {
	// The resulting snapshots.
	Snapshots []*Snapshot `protobuf:"bytes,1,rep,name=snapshots" json:"snapshots,omitempty"`
	// If not empty, indicates that there may be more snapshot that match the
	// request; this value should be passed in a new `ListSnapshotsRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListSnapshotsResponse) Reset()                    { *m = ListSnapshotsResponse{} }
func (m *ListSnapshotsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSnapshotsResponse) ProtoMessage()               {}
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *ListSnapshotsResponse) GetSnapshots() []*Snapshot {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

func (m *ListSnapshotsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `DeleteSnapshot` method.
type DeleteSnapshotRequest struct {
	// The name of the snapshot to delete.
	// Format is `projects/{project}/snapshots/{snap}`.
	Snapshot string `protobuf:"bytes,1,opt,name=snapshot" json:"snapshot,omitempty"`
}

func (m *DeleteSnapshotRequest) Reset()                    { *m = DeleteSnapshotRequest{} }
func (m *DeleteSnapshotRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSnapshotRequest) ProtoMessage()               {}
func (*DeleteSnapshotRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *DeleteSnapshotRequest) GetSnapshot() string {
	if m != nil {
		return m.Snapshot
	}
	return ""
}

// Request for the `Seek` method.
type SeekRequest struct {
	// The subscription to affect.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// Types that are valid to be assigned to Target:
	//	*SeekRequest_Time
	//	*SeekRequest_Snapshot
	Target isSeekRequest_Target `protobuf_oneof:"target"`
}

func (m *SeekRequest) Reset()                    { *m = SeekRequest{} }
func (m *SeekRequest) String() string            { return proto.CompactTextString(m) }
func (*SeekRequest) ProtoMessage()               {}
func (*SeekRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

type isSeekRequest_Target interface {
	isSeekRequest_Target()
}

type SeekRequest_Time struct {
	Time *google_protobuf4.Timestamp `protobuf:"bytes,2,opt,name=time,oneof"`
}
type SeekRequest_Snapshot struct {
	Snapshot string `protobuf:"bytes,3,opt,name=snapshot,oneof"`
}

func (*SeekRequest_Time) isSeekRequest_Target()     {}
func (*SeekRequest_Snapshot) isSeekRequest_Target() {}

func (m *SeekRequest) GetTarget() isSeekRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SeekRequest) GetSubscription() string {
	if m != nil {
		return m.Subscription
	}
	return ""
}

func (m *SeekRequest) GetTime() *google_protobuf4.Timestamp {
	if x, ok := m.GetTarget().(*SeekRequest_Time); ok {
		return x.Time
	}
	return nil
}

func (m *SeekRequest) GetSnapshot() string {
	if x, ok := m.GetTarget().(*SeekRequest_Snapshot); ok {
		return x.Snapshot
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SeekRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SeekRequest_OneofMarshaler, _SeekRequest_OneofUnmarshaler, _SeekRequest_OneofSizer, []interface{}{
		(*SeekRequest_Time)(nil),
		(*SeekRequest_Snapshot)(nil),
	}
}

func _SeekRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SeekRequest)
	// target
	switch x := m.Target.(type) {
	case *SeekRequest_Time:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Time); err != nil {
			return err
		}
	case *SeekRequest_Snapshot:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Snapshot)
	case nil:
	default:
		return fmt.Errorf("SeekRequest.Target has unexpected type %T", x)
	}
	return nil
}

func _SeekRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SeekRequest)
	switch tag {
	case 2: // target.time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf4.Timestamp)
		err := b.DecodeMessage(msg)
		m.Target = &SeekRequest_Time{msg}
		return true, err
	case 3: // target.snapshot
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Target = &SeekRequest_Snapshot{x}
		return true, err
	default:
		return false, nil
	}
}

func _SeekRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SeekRequest)
	// target
	switch x := m.Target.(type) {
	case *SeekRequest_Time:
		s := proto.Size(x.Time)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SeekRequest_Snapshot:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Snapshot)))
		n += len(x.Snapshot)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type SeekResponse struct {
}

func (m *SeekResponse) Reset()                    { *m = SeekResponse{} }
func (m *SeekResponse) String() string            { return proto.CompactTextString(m) }
func (*SeekResponse) ProtoMessage()               {}
func (*SeekResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func init() {
	proto.RegisterType((*Topic)(nil), "google.pubsub.v1.Topic")
	proto.RegisterType((*PubsubMessage)(nil), "google.pubsub.v1.PubsubMessage")
	proto.RegisterType((*GetTopicRequest)(nil), "google.pubsub.v1.GetTopicRequest")
	proto.RegisterType((*PublishRequest)(nil), "google.pubsub.v1.PublishRequest")
	proto.RegisterType((*PublishResponse)(nil), "google.pubsub.v1.PublishResponse")
	proto.RegisterType((*ListTopicsRequest)(nil), "google.pubsub.v1.ListTopicsRequest")
	proto.RegisterType((*ListTopicsResponse)(nil), "google.pubsub.v1.ListTopicsResponse")
	proto.RegisterType((*ListTopicSubscriptionsRequest)(nil), "google.pubsub.v1.ListTopicSubscriptionsRequest")
	proto.RegisterType((*ListTopicSubscriptionsResponse)(nil), "google.pubsub.v1.ListTopicSubscriptionsResponse")
	proto.RegisterType((*DeleteTopicRequest)(nil), "google.pubsub.v1.DeleteTopicRequest")
	proto.RegisterType((*Subscription)(nil), "google.pubsub.v1.Subscription")
	proto.RegisterType((*PushConfig)(nil), "google.pubsub.v1.PushConfig")
	proto.RegisterType((*ReceivedMessage)(nil), "google.pubsub.v1.ReceivedMessage")
	proto.RegisterType((*GetSubscriptionRequest)(nil), "google.pubsub.v1.GetSubscriptionRequest")
	proto.RegisterType((*UpdateSubscriptionRequest)(nil), "google.pubsub.v1.UpdateSubscriptionRequest")
	proto.RegisterType((*ListSubscriptionsRequest)(nil), "google.pubsub.v1.ListSubscriptionsRequest")
	proto.RegisterType((*ListSubscriptionsResponse)(nil), "google.pubsub.v1.ListSubscriptionsResponse")
	proto.RegisterType((*DeleteSubscriptionRequest)(nil), "google.pubsub.v1.DeleteSubscriptionRequest")
	proto.RegisterType((*ModifyPushConfigRequest)(nil), "google.pubsub.v1.ModifyPushConfigRequest")
	proto.RegisterType((*PullRequest)(nil), "google.pubsub.v1.PullRequest")
	proto.RegisterType((*PullResponse)(nil), "google.pubsub.v1.PullResponse")
	proto.RegisterType((*ModifyAckDeadlineRequest)(nil), "google.pubsub.v1.ModifyAckDeadlineRequest")
	proto.RegisterType((*AcknowledgeRequest)(nil), "google.pubsub.v1.AcknowledgeRequest")
	proto.RegisterType((*StreamingPullRequest)(nil), "google.pubsub.v1.StreamingPullRequest")
	proto.RegisterType((*StreamingPullResponse)(nil), "google.pubsub.v1.StreamingPullResponse")
	proto.RegisterType((*CreateSnapshotRequest)(nil), "google.pubsub.v1.CreateSnapshotRequest")
	proto.RegisterType((*Snapshot)(nil), "google.pubsub.v1.Snapshot")
	proto.RegisterType((*ListSnapshotsRequest)(nil), "google.pubsub.v1.ListSnapshotsRequest")
	proto.RegisterType((*ListSnapshotsResponse)(nil), "google.pubsub.v1.ListSnapshotsResponse")
	proto.RegisterType((*DeleteSnapshotRequest)(nil), "google.pubsub.v1.DeleteSnapshotRequest")
	proto.RegisterType((*SeekRequest)(nil), "google.pubsub.v1.SeekRequest")
	proto.RegisterType((*SeekResponse)(nil), "google.pubsub.v1.SeekResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Subscriber service

type SubscriberClient interface {
	// Creates a subscription to a given topic.
	// If the subscription already exists, returns `ALREADY_EXISTS`.
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic, conforming
	// to the
	// [resource name format](https://cloud.google.com/pubsub/docs/overview#names).
	// The generated name is populated in the returned Subscription object.
	// Note that for REST API requests, you must specify a name in the request.
	CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Updates an existing subscription. Note that certain properties of a
	// subscription, such as its topic, are not modifiable.
	UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All messages retained in the subscription
	// are immediately dropped. Calls to `Pull` after deletion will return
	// `NOT_FOUND`. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription or its topic unless the same topic is specified.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted. Note that this does not modify the
	// subscription-level `ackDeadlineSeconds` used for subsequent messages.
	ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Acknowledges the messages associated with the `ack_ids` in the
	// `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return `UNAVAILABLE` if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error)
	// (EXPERIMENTAL) StreamingPull is an experimental feature. This RPC will
	// respond with UNIMPLEMENTED errors unless you have been invited to test
	// this feature. Contact cloud-pubsub@google.com with any questions.
	//
	// Establishes a stream with the server, which sends messages down to the
	// client. The client streams acknowledgements and ack deadline modifications
	// back to the server. The server will close the stream and return the status
	// on any error. The server may close the stream with status `OK` to reassign
	// server-side resources, in which case, the client should re-establish the
	// stream. `UNAVAILABLE` may also be returned in the case of a transient error
	// (e.g., a server restart). These should also be retried by the client. Flow
	// control can be achieved by configuring the underlying RPC channel.
	StreamingPull(ctx context.Context, opts ...grpc.CallOption) (Subscriber_StreamingPullClient, error)
	// Modifies the `PushConfig` for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified by
	// an empty `PushConfig`) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for delivery
	// continuously through the call regardless of changes to the `PushConfig`.
	ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Lists the existing snapshots.
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Creates a snapshot from the requested subscription.
	// If the snapshot already exists, returns `ALREADY_EXISTS`.
	// If the requested subscription doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this snapshot on the same project as the subscription, conforming
	// to the
	// [resource name format](https://cloud.google.com/pubsub/docs/overview#names).
	// The generated name is populated in the returned Snapshot object.
	// Note that for REST API requests, you must specify a name in the request.
	CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Removes an existing snapshot. All messages retained in the snapshot
	// are immediately dropped. After a snapshot is deleted, a new one may be
	// created with the same name, but the new one has no association with the old
	// snapshot or its subscription, unless the same subscription is specified.
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Seeks an existing subscription to a point in time or to a given snapshot,
	// whichever is provided in the request.
	Seek(ctx context.Context, in *SeekRequest, opts ...grpc.CallOption) (*SeekResponse, error)
}

type subscriberClient struct {
	cc *grpc.ClientConn
}

func NewSubscriberClient(cc *grpc.ClientConn) SubscriberClient {
	return &subscriberClient{cc}
}

func (c *subscriberClient) CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/CreateSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/GetSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/UpdateSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ListSubscriptions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/DeleteSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ModifyAckDeadline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/Acknowledge", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error) {
	out := new(PullResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/Pull", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) StreamingPull(ctx context.Context, opts ...grpc.CallOption) (Subscriber_StreamingPullClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Subscriber_serviceDesc.Streams[0], c.cc, "/google.pubsub.v1.Subscriber/StreamingPull", opts...)
	if err != nil {
		return nil, err
	}
	x := &subscriberStreamingPullClient{stream}
	return x, nil
}

type Subscriber_StreamingPullClient interface {
	Send(*StreamingPullRequest) error
	Recv() (*StreamingPullResponse, error)
	grpc.ClientStream
}

type subscriberStreamingPullClient struct {
	grpc.ClientStream
}

func (x *subscriberStreamingPullClient) Send(m *StreamingPullRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *subscriberStreamingPullClient) Recv() (*StreamingPullResponse, error) {
	m := new(StreamingPullResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *subscriberClient) ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ModifyPushConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ListSnapshots", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/CreateSnapshot", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/DeleteSnapshot", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Seek(ctx context.Context, in *SeekRequest, opts ...grpc.CallOption) (*SeekResponse, error) {
	out := new(SeekResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/Seek", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Subscriber service

type SubscriberServer interface {
	// Creates a subscription to a given topic.
	// If the subscription already exists, returns `ALREADY_EXISTS`.
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic, conforming
	// to the
	// [resource name format](https://cloud.google.com/pubsub/docs/overview#names).
	// The generated name is populated in the returned Subscription object.
	// Note that for REST API requests, you must specify a name in the request.
	CreateSubscription(context.Context, *Subscription) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error)
	// Updates an existing subscription. Note that certain properties of a
	// subscription, such as its topic, are not modifiable.
	UpdateSubscription(context.Context, *UpdateSubscriptionRequest) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All messages retained in the subscription
	// are immediately dropped. Calls to `Pull` after deletion will return
	// `NOT_FOUND`. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription or its topic unless the same topic is specified.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*google_protobuf2.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted. Note that this does not modify the
	// subscription-level `ackDeadlineSeconds` used for subsequent messages.
	ModifyAckDeadline(context.Context, *ModifyAckDeadlineRequest) (*google_protobuf2.Empty, error)
	// Acknowledges the messages associated with the `ack_ids` in the
	// `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(context.Context, *AcknowledgeRequest) (*google_protobuf2.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return `UNAVAILABLE` if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(context.Context, *PullRequest) (*PullResponse, error)
	// (EXPERIMENTAL) StreamingPull is an experimental feature. This RPC will
	// respond with UNIMPLEMENTED errors unless you have been invited to test
	// this feature. Contact cloud-pubsub@google.com with any questions.
	//
	// Establishes a stream with the server, which sends messages down to the
	// client. The client streams acknowledgements and ack deadline modifications
	// back to the server. The server will close the stream and return the status
	// on any error. The server may close the stream with status `OK` to reassign
	// server-side resources, in which case, the client should re-establish the
	// stream. `UNAVAILABLE` may also be returned in the case of a transient error
	// (e.g., a server restart). These should also be retried by the client. Flow
	// control can be achieved by configuring the underlying RPC channel.
	StreamingPull(Subscriber_StreamingPullServer) error
	// Modifies the `PushConfig` for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified by
	// an empty `PushConfig`) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for delivery
	// continuously through the call regardless of changes to the `PushConfig`.
	ModifyPushConfig(context.Context, *ModifyPushConfigRequest) (*google_protobuf2.Empty, error)
	// Lists the existing snapshots.
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Creates a snapshot from the requested subscription.
	// If the snapshot already exists, returns `ALREADY_EXISTS`.
	// If the requested subscription doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this snapshot on the same project as the subscription, conforming
	// to the
	// [resource name format](https://cloud.google.com/pubsub/docs/overview#names).
	// The generated name is populated in the returned Snapshot object.
	// Note that for REST API requests, you must specify a name in the request.
	CreateSnapshot(context.Context, *CreateSnapshotRequest) (*Snapshot, error)
	// Removes an existing snapshot. All messages retained in the snapshot
	// are immediately dropped. After a snapshot is deleted, a new one may be
	// created with the same name, but the new one has no association with the old
	// snapshot or its subscription, unless the same subscription is specified.
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*google_protobuf2.Empty, error)
	// Seeks an existing subscription to a point in time or to a given snapshot,
	// whichever is provided in the request.
	Seek(context.Context, *SeekRequest) (*SeekResponse, error)
}

func RegisterSubscriberServer(s *grpc.Server, srv SubscriberServer) {
	s.RegisterService(&_Subscriber_serviceDesc, srv)
}

func _Subscriber_CreateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Subscription)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/CreateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSubscription(ctx, req.(*Subscription))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_GetSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).GetSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/GetSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).GetSubscription(ctx, req.(*GetSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_UpdateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).UpdateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/UpdateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).UpdateSubscription(ctx, req.(*UpdateSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ListSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/DeleteSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyAckDeadline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyAckDeadlineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ModifyAckDeadline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, req.(*ModifyAckDeadlineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Acknowledge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Acknowledge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/Acknowledge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Acknowledge(ctx, req.(*AcknowledgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Pull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Pull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/Pull",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Pull(ctx, req.(*PullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_StreamingPull_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SubscriberServer).StreamingPull(&subscriberStreamingPullServer{stream})
}

type Subscriber_StreamingPullServer interface {
	Send(*StreamingPullResponse) error
	Recv() (*StreamingPullRequest, error)
	grpc.ServerStream
}

type subscriberStreamingPullServer struct {
	grpc.ServerStream
}

func (x *subscriberStreamingPullServer) Send(m *StreamingPullResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *subscriberStreamingPullServer) Recv() (*StreamingPullRequest, error) {
	m := new(StreamingPullRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Subscriber_ModifyPushConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyPushConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ModifyPushConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, req.(*ModifyPushConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ListSnapshots",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_CreateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/CreateSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSnapshot(ctx, req.(*CreateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/DeleteSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Seek_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SeekRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Seek(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/Seek",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Seek(ctx, req.(*SeekRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Subscriber_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1.Subscriber",
	HandlerType: (*SubscriberServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSubscription",
			Handler:    _Subscriber_CreateSubscription_Handler,
		},
		{
			MethodName: "GetSubscription",
			Handler:    _Subscriber_GetSubscription_Handler,
		},
		{
			MethodName: "UpdateSubscription",
			Handler:    _Subscriber_UpdateSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _Subscriber_ListSubscriptions_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _Subscriber_DeleteSubscription_Handler,
		},
		{
			MethodName: "ModifyAckDeadline",
			Handler:    _Subscriber_ModifyAckDeadline_Handler,
		},
		{
			MethodName: "Acknowledge",
			Handler:    _Subscriber_Acknowledge_Handler,
		},
		{
			MethodName: "Pull",
			Handler:    _Subscriber_Pull_Handler,
		},
		{
			MethodName: "ModifyPushConfig",
			Handler:    _Subscriber_ModifyPushConfig_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _Subscriber_ListSnapshots_Handler,
		},
		{
			MethodName: "CreateSnapshot",
			Handler:    _Subscriber_CreateSnapshot_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _Subscriber_DeleteSnapshot_Handler,
		},
		{
			MethodName: "Seek",
			Handler:    _Subscriber_Seek_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingPull",
			Handler:       _Subscriber_StreamingPull_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/pubsub/v1/pubsub.proto",
}

// Client API for Publisher service

type PublisherClient interface {
	// Creates the given topic with the given name.
	CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error)
	// Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
	// does not exist. The message payload must not be empty; it must contain
	//  either a non-empty data field, or at least one attribute.
	Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error)
	// Lists matching topics.
	ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
	// does not exist. After a topic is deleted, a new topic may be created with
	// the same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted, but their `topic` field is set to `_deleted-topic_`.
	DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type publisherClient struct {
	cc *grpc.ClientConn
}

func NewPublisherClient(cc *grpc.ClientConn) PublisherClient {
	return &publisherClient{cc}
}

func (c *publisherClient) CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/CreateTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error) {
	out := new(PublishResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/Publish", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/GetTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error) {
	out := new(ListTopicsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/ListTopics", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error) {
	out := new(ListTopicSubscriptionsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/ListTopicSubscriptions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/DeleteTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Publisher service

type PublisherServer interface {
	// Creates the given topic with the given name.
	CreateTopic(context.Context, *Topic) (*Topic, error)
	// Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
	// does not exist. The message payload must not be empty; it must contain
	//  either a non-empty data field, or at least one attribute.
	Publish(context.Context, *PublishRequest) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(context.Context, *GetTopicRequest) (*Topic, error)
	// Lists matching topics.
	ListTopics(context.Context, *ListTopicsRequest) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(context.Context, *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
	// does not exist. After a topic is deleted, a new topic may be created with
	// the same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted, but their `topic` field is set to `_deleted-topic_`.
	DeleteTopic(context.Context, *DeleteTopicRequest) (*google_protobuf2.Empty, error)
}

func RegisterPublisherServer(s *grpc.Server, srv PublisherServer) {
	s.RegisterService(&_Publisher_serviceDesc, srv)
}

func _Publisher_CreateTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Topic)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).CreateTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/CreateTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).CreateTopic(ctx, req.(*Topic))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_Publish_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).Publish(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/Publish",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).Publish(ctx, req.(*PublishRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_GetTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).GetTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/GetTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).GetTopic(ctx, req.(*GetTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/ListTopics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopics(ctx, req.(*ListTopicsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopicSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/ListTopicSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, req.(*ListTopicSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_DeleteTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).DeleteTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/DeleteTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).DeleteTopic(ctx, req.(*DeleteTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Publisher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1.Publisher",
	HandlerType: (*PublisherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTopic",
			Handler:    _Publisher_CreateTopic_Handler,
		},
		{
			MethodName: "Publish",
			Handler:    _Publisher_Publish_Handler,
		},
		{
			MethodName: "GetTopic",
			Handler:    _Publisher_GetTopic_Handler,
		},
		{
			MethodName: "ListTopics",
			Handler:    _Publisher_ListTopics_Handler,
		},
		{
			MethodName: "ListTopicSubscriptions",
			Handler:    _Publisher_ListTopicSubscriptions_Handler,
		},
		{
			MethodName: "DeleteTopic",
			Handler:    _Publisher_DeleteTopic_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/pubsub/v1/pubsub.proto",
}

func init() { proto.RegisterFile("google/pubsub/v1/pubsub.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1867 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0xcb, 0x73, 0xdb, 0xc6,
	0x19, 0x0f, 0x48, 0x3d, 0xa8, 0x0f, 0x94, 0x65, 0x6f, 0x25, 0x9b, 0x86, 0x5f, 0x12, 0xec, 0x5a,
	0x0c, 0x63, 0x93, 0x32, 0x33, 0x49, 0x13, 0xbb, 0x4a, 0x46, 0x96, 0x5c, 0x47, 0x9d, 0xb8, 0x51,
	0x21, 0xb7, 0x9d, 0xe9, 0xa1, 0x1c, 0x90, 0x58, 0x51, 0x08, 0x89, 0x87, 0xb1, 0x80, 0x2a, 0xa6,
	0xcd, 0x4c, 0x9b, 0x74, 0x3a, 0xd3, 0x69, 0x0f, 0x4d, 0x7b, 0x6c, 0x0e, 0x9d, 0xe9, 0xad, 0xc7,
	0x1e, 0x7a, 0xec, 0x3f, 0xd1, 0x7f, 0xa1, 0x87, 0xfe, 0x09, 0x3d, 0x76, 0xf6, 0x01, 0x12, 0x20,
	0x16, 0x7c, 0x28, 0xe3, 0x1b, 0xb8, 0xfb, 0xed, 0xfe, 0x7e, 0xdf, 0xfb, 0xd3, 0x0a, 0x6e, 0x75,
	0x3d, 0xaf, 0xdb, 0xc7, 0x0d, 0x3f, 0x6a, 0x93, 0xa8, 0xdd, 0x38, 0x7b, 0x24, 0xbe, 0xea, 0x7e,
	0xe0, 0x85, 0x1e, 0xba, 0xcc, 0xb7, 0xeb, 0x62, 0xf1, 0xec, 0x91, 0x76, 0x53, 0x1c, 0x30, 0x7d,
	0xbb, 0x61, 0xba, 0xae, 0x17, 0x9a, 0xa1, 0xed, 0xb9, 0x84, 0xcb, 0x6b, 0xb7, 0xe3, 0xeb, 0xe8,
	0xaf, 0x76, 0x74, 0xd2, 0xb0, 0xa2, 0x80, 0x09, 0x88, 0xfd, 0x1b, 0xe3, 0xfb, 0xd8, 0xf1, 0xc3,
	0x81, 0xd8, 0xdc, 0x1c, 0xdf, 0x3c, 0xb1, 0x71, 0xdf, 0x6a, 0x39, 0x26, 0xe9, 0x09, 0x89, 0x3b,
	0xe3, 0x12, 0xa1, 0xed, 0x60, 0x12, 0x9a, 0x8e, 0xcf, 0x05, 0xf4, 0x1b, 0xb0, 0xf8, 0xd2, 0xf3,
	0xed, 0x0e, 0x42, 0xb0, 0xe0, 0x9a, 0x0e, 0xae, 0x28, 0x9b, 0x4a, 0x75, 0xc5, 0x60, 0xdf, 0xfa,
	0x57, 0x05, 0x58, 0x3d, 0x62, 0x8a, 0xbc, 0xc0, 0x84, 0x98, 0x5d, 0x4c, 0xa5, 0x2c, 0x33, 0x34,
	0x99, 0x54, 0xd9, 0x60, 0xdf, 0xe8, 0x13, 0x00, 0x33, 0x0c, 0x03, 0xbb, 0x1d, 0x85, 0x98, 0x54,
	0x0a, 0x9b, 0xc5, 0xaa, 0xda, 0x6c, 0xd4, 0xc7, 0xed, 0x50, 0x4f, 0x5d, 0x54, 0xdf, 0x1b, 0x9e,
	0x78, 0xe6, 0x86, 0xc1, 0xc0, 0x48, 0x5c, 0x81, 0x6e, 0x01, 0x38, 0x5c, 0xac, 0x65, 0x5b, 0x95,
	0x22, 0x23, 0xb4, 0x22, 0x56, 0x0e, 0x2d, 0xb4, 0x0b, 0x65, 0x3f, 0x6a, 0xf7, 0x6d, 0x72, 0xda,
	0xa2, 0xda, 0x54, 0x16, 0x36, 0x95, 0xaa, 0xda, 0xd4, 0x86, 0x88, 0x42, 0xd5, 0xfa, 0xcb, 0x58,
	0x55, 0x43, 0x15, 0xf2, 0x74, 0x45, 0xdb, 0x85, 0xb5, 0x31, 0x70, 0x74, 0x19, 0x8a, 0x3d, 0x3c,
	0x10, 0xaa, 0xd3, 0x4f, 0xb4, 0x0e, 0x8b, 0x67, 0x66, 0x3f, 0xc2, 0x95, 0x02, 0x5b, 0xe3, 0x3f,
	0x1e, 0x17, 0xde, 0x53, 0xf4, 0x6d, 0x58, 0x7b, 0x8e, 0x43, 0x66, 0x33, 0x03, 0xbf, 0x8a, 0x30,
	0x09, 0xa9, 0x70, 0x48, 0x7f, 0x8b, 0x0b, 0xf8, 0x0f, 0xbd, 0x03, 0x97, 0x8e, 0x38, 0xec, 0x44,
	0x39, 0xf4, 0x04, 0x4a, 0x42, 0xb7, 0xd8, 0x78, 0x77, 0xa6, 0x18, 0xcf, 0x18, 0x1e, 0xd0, 0x9b,
	0xb0, 0x36, 0x04, 0x21, 0xbe, 0xe7, 0x12, 0x8c, 0xee, 0x80, 0x3a, 0xb2, 0x1e, 0xa9, 0x28, 0x9b,
	0xc5, 0xea, 0x8a, 0x01, 0x43, 0xf3, 0x11, 0xdd, 0x86, 0x2b, 0x1f, 0xdb, 0x84, 0xab, 0x40, 0x62,
	0x6e, 0x15, 0x58, 0xf6, 0x03, 0xef, 0x53, 0xdc, 0x09, 0x05, 0xbb, 0xf8, 0x27, 0xba, 0x01, 0x2b,
	0x3e, 0xbd, 0x8c, 0xd8, 0x9f, 0x71, 0x73, 0x2c, 0x1a, 0x25, 0xba, 0x70, 0x6c, 0x7f, 0x86, 0xa9,
	0xab, 0xd8, 0x66, 0xe8, 0xf5, 0xb0, 0x1b, 0xbb, 0x8a, 0xae, 0xbc, 0xa4, 0x0b, 0xba, 0x03, 0x28,
	0x09, 0x25, 0x18, 0x36, 0x60, 0x89, 0xa9, 0xce, 0xc9, 0xa9, 0xcd, 0x6b, 0x59, 0x7d, 0xb9, 0x7d,
	0x85, 0x18, 0xba, 0x0f, 0x6b, 0x2e, 0x3e, 0x0f, 0x5b, 0x09, 0x28, 0xee, 0x97, 0x55, 0xba, 0x7c,
	0x34, 0x84, 0x7b, 0x05, 0xb7, 0x86, 0x70, 0xc7, 0x51, 0x9b, 0x74, 0x02, 0xdb, 0x67, 0xc9, 0x36,
	0xd9, 0x03, 0xdf, 0x44, 0x43, 0x17, 0x6e, 0xe7, 0x41, 0x0a, 0x6d, 0xef, 0xc1, 0x2a, 0x49, 0x6e,
	0x08, 0x8f, 0xa4, 0x17, 0x67, 0x56, 0xb1, 0x06, 0xe8, 0x00, 0xf7, 0x71, 0x88, 0x67, 0x88, 0xc0,
	0x7f, 0x16, 0xa0, 0x9c, 0xe4, 0x24, 0xcb, 0xf1, 0xd1, 0xd1, 0x42, 0xd2, 0x24, 0xbb, 0xa0, 0xfa,
	0x11, 0x39, 0x6d, 0x75, 0x3c, 0xf7, 0xc4, 0xee, 0x8a, 0x14, 0xbb, 0x29, 0x8b, 0x4b, 0x72, 0xba,
	0xcf, 0x64, 0x0c, 0xf0, 0x87, 0xdf, 0x68, 0x07, 0xd6, 0xcd, 0x4e, 0xaf, 0x65, 0x61, 0xd3, 0xea,
	0xdb, 0x2e, 0x6e, 0x11, 0xdc, 0xf1, 0x5c, 0x8b, 0x54, 0x16, 0x99, 0x71, 0x91, 0xd9, 0xe9, 0x1d,
	0x88, 0xad, 0x63, 0xbe, 0x83, 0x9a, 0xb0, 0x11, 0xe0, 0xd0, 0xb4, 0xdd, 0x96, 0xd9, 0xe9, 0x61,
	0xab, 0x35, 0x4c, 0x89, 0xe5, 0x4d, 0xa5, 0x5a, 0x32, 0xbe, 0xc5, 0x37, 0xf7, 0xe8, 0x9e, 0xc8,
	0x02, 0x82, 0x7e, 0x02, 0x5a, 0x1c, 0xe9, 0x01, 0x0e, 0xb1, 0x4b, 0x75, 0x6c, 0xc5, 0xf5, 0xb3,
	0x52, 0x62, 0x9c, 0xaf, 0x67, 0xca, 0xc2, 0x81, 0x10, 0x30, 0x2a, 0xe2, 0xb0, 0x11, 0x9f, 0x8d,
	0x77, 0xf4, 0x7f, 0x29, 0x00, 0x23, 0xcd, 0xd0, 0x5d, 0x58, 0x65, 0xc6, 0xc0, 0xae, 0xe5, 0x7b,
	0xb6, 0x1b, 0x67, 0x48, 0x99, 0x2e, 0x3e, 0x13, 0x6b, 0xe8, 0x63, 0x49, 0x15, 0x7c, 0x30, 0xc9,
	0x60, 0x93, 0x4a, 0xe0, 0x37, 0x2d, 0x52, 0x1d, 0x58, 0x33, 0x70, 0x07, 0xdb, 0x67, 0x43, 0x6b,
	0xa1, 0x0d, 0x58, 0xa2, 0x2e, 0xb1, 0xad, 0x38, 0x46, 0xcc, 0x4e, 0xef, 0xd0, 0x42, 0xef, 0xc3,
	0xb2, 0x30, 0x03, 0xbb, 0x65, 0x86, 0xe2, 0x13, 0xcb, 0xeb, 0xdf, 0x85, 0xab, 0xcf, 0x71, 0x98,
	0x0c, 0xb0, 0x38, 0x1c, 0x75, 0x28, 0x27, 0xa3, 0x3b, 0xb6, 0x57, 0x72, 0x4d, 0xff, 0x5a, 0x81,
	0xeb, 0x3f, 0xf2, 0x2d, 0x33, 0xc4, 0xb2, 0x1b, 0x9e, 0x4a, 0x6e, 0x50, 0x9b, 0xb7, 0xb3, 0xdc,
	0x52, 0x87, 0x53, 0x67, 0xd0, 0x13, 0x50, 0x23, 0x06, 0xc0, 0x1a, 0xa2, 0x50, 0x2f, 0xdb, 0x26,
	0xbe, 0x47, 0x7b, 0xe6, 0x0b, 0x93, 0xf4, 0x0c, 0xe0, 0xe2, 0xf4, 0x5b, 0xf7, 0xa1, 0x42, 0xf3,
	0x5a, 0x5a, 0x45, 0x5e, 0x4f, 0xad, 0xfc, 0x9d, 0x02, 0xd7, 0x25, 0x90, 0xa2, 0x8a, 0x1c, 0xc8,
	0xaa, 0xc8, 0x74, 0x8b, 0x5c, 0xb0, 0xca, 0x7c, 0x08, 0xd7, 0x79, 0x95, 0xb9, 0xa8, 0x77, 0x7f,
	0x09, 0xd7, 0x5e, 0x78, 0x96, 0x7d, 0x32, 0x48, 0x14, 0x88, 0xd9, 0x8f, 0x8f, 0x97, 0x9f, 0xc2,
	0x7c, 0xe5, 0x47, 0xff, 0x52, 0x01, 0xf5, 0x28, 0xea, 0xf7, 0xe7, 0x81, 0x7c, 0x08, 0x28, 0xc0,
	0x61, 0x14, 0xb8, 0x2d, 0xdb, 0x71, 0xb0, 0x65, 0x9b, 0x21, 0xee, 0x0f, 0x18, 0x72, 0xc9, 0xb8,
	0xc2, 0x77, 0x0e, 0x47, 0x1b, 0x68, 0x0b, 0xca, 0x8e, 0x79, 0x3e, 0x2a, 0x53, 0x45, 0xe6, 0x6c,
	0xd5, 0x31, 0xcf, 0xe3, 0xf2, 0xa4, 0xff, 0x0c, 0xca, 0x9c, 0x84, 0x70, 0xe1, 0x0f, 0xe0, 0x4a,
	0x20, 0x92, 0x72, 0x74, 0x8e, 0xbb, 0x71, 0x2b, 0xab, 0xda, 0x58, 0xfe, 0x1a, 0x97, 0x83, 0xf4,
	0x02, 0xa1, 0x01, 0x53, 0xe1, 0x46, 0xde, 0x1b, 0xd5, 0xd3, 0x79, 0x54, 0xbe, 0x06, 0xcb, 0xbc,
	0x24, 0x90, 0xca, 0x02, 0xeb, 0x49, 0x4b, 0xac, 0x26, 0x90, 0xdc, 0xf2, 0x5d, 0xcc, 0x2b, 0xdf,
	0xfa, 0x0f, 0x01, 0xed, 0x75, 0x7a, 0xae, 0xf7, 0xf3, 0x3e, 0xb6, 0xba, 0x17, 0x25, 0x51, 0x48,
	0x92, 0xd0, 0x7f, 0x5d, 0x80, 0xf5, 0xe3, 0x30, 0xc0, 0xa6, 0x63, 0xbb, 0xdd, 0x79, 0xbd, 0x99,
	0x77, 0x2b, 0x7a, 0x17, 0xae, 0x39, 0xcc, 0x66, 0x32, 0xed, 0x8a, 0xd5, 0x45, 0x63, 0x83, 0x6f,
	0x8f, 0xf7, 0xa7, 0x77, 0xb2, 0xe7, 0xd2, 0xb6, 0x5b, 0x4f, 0x9f, 0xdb, 0xe3, 0x70, 0xbb, 0x70,
	0x83, 0x30, 0x1d, 0x5a, 0x13, 0xfa, 0x61, 0x85, 0x8b, 0xec, 0x65, 0xcd, 0xda, 0x85, 0x8d, 0x31,
	0x13, 0xbc, 0xa6, 0x58, 0xfa, 0x04, 0x36, 0xf6, 0x03, 0x4c, 0x8b, 0xb1, 0x6b, 0xfa, 0xe4, 0xd4,
	0x0b, 0x63, 0x63, 0xcb, 0x46, 0x86, 0x71, 0x07, 0x14, 0x24, 0x05, 0xe0, 0x15, 0x94, 0xe2, 0xab,
	0xe6, 0x18, 0x3b, 0x9e, 0x80, 0x8a, 0xcf, 0x7d, 0x3b, 0xc0, 0x7c, 0xb2, 0x2f, 0x4e, 0x9d, 0xec,
	0x81, 0x8b, 0xd3, 0x05, 0xbd, 0x0f, 0xeb, 0xac, 0x7e, 0x0a, 0xd8, 0xd7, 0x5c, 0xae, 0x07, 0xb0,
	0x31, 0x86, 0x26, 0x5c, 0xf3, 0x1e, 0xac, 0x90, 0x78, 0x51, 0xb8, 0x44, 0x93, 0x54, 0xe9, 0xd8,
	0xce, 0x23, 0xe1, 0x99, 0xab, 0xf3, 0xdb, 0xb0, 0x21, 0xaa, 0xf3, 0x98, 0xb3, 0x34, 0x28, 0xc5,
	0xb7, 0x09, 0x55, 0x87, 0xbf, 0xf5, 0xdf, 0x2b, 0xa0, 0x1e, 0x63, 0xdc, 0x9b, 0x27, 0x8b, 0x76,
	0x60, 0x81, 0xf9, 0xa1, 0x30, 0xcd, 0x0f, 0x1f, 0xbd, 0x61, 0x30, 0x49, 0x74, 0x33, 0xc1, 0x80,
	0x99, 0xec, 0xa3, 0x37, 0x46, 0x1c, 0x9e, 0x96, 0x60, 0x29, 0x34, 0x83, 0x2e, 0x0e, 0xf5, 0x4b,
	0x50, 0xe6, 0x64, 0xb8, 0xd1, 0x9a, 0xff, 0x5d, 0x03, 0x10, 0xbd, 0xa6, 0x8d, 0x03, 0xf4, 0x5b,
	0x05, 0x90, 0x88, 0xc7, 0x24, 0x9f, 0x29, 0xdd, 0x4e, 0x9b, 0xb2, 0xaf, 0xef, 0x7c, 0xf1, 0xef,
	0xff, 0xfc, 0xb9, 0x50, 0xd3, 0xbe, 0x4d, 0xff, 0x6c, 0xff, 0x05, 0x8d, 0xc3, 0x5d, 0x11, 0x0a,
	0xa4, 0x51, 0x6b, 0xa4, 0x5a, 0x65, 0xa3, 0xf6, 0xf9, 0x63, 0xa5, 0x86, 0xfe, 0xa4, 0xb0, 0x3f,
	0xf7, 0x52, 0x2c, 0xaa, 0x59, 0x14, 0xf9, 0x1c, 0x34, 0x95, 0xcf, 0x3b, 0x8c, 0x4f, 0x03, 0x3d,
	0x64, 0x7c, 0x92, 0xf8, 0x93, 0x78, 0xa1, 0xbf, 0x2a, 0x80, 0xb2, 0xa3, 0x13, 0x7a, 0x2b, 0x8b,
	0x96, 0x3b, 0x60, 0x4d, 0xa5, 0xb6, 0xcb, 0xa8, 0x7d, 0xa7, 0xd9, 0xcc, 0x50, 0xab, 0xcf, 0x62,
	0xb7, 0xaf, 0x15, 0xfe, 0x47, 0x66, 0x6a, 0x98, 0x41, 0xb5, 0x2c, 0x68, 0xde, 0x90, 0xa5, 0xbd,
	0x35, 0x93, 0x2c, 0x0f, 0x1f, 0xbd, 0xce, 0xd8, 0x56, 0xd1, 0x7d, 0xc6, 0x56, 0x70, 0x4b, 0x70,
	0xfc, 0x3c, 0x4d, 0x12, 0xfd, 0x51, 0x89, 0xff, 0x8c, 0x9a, 0x66, 0xc1, 0xdc, 0x31, 0x48, 0xbb,
	0x9a, 0x49, 0x87, 0x67, 0x8e, 0x1f, 0x0e, 0x62, 0xa7, 0xd6, 0xe6, 0x74, 0xea, 0xdf, 0x14, 0xb8,
	0x92, 0xe9, 0xe6, 0x32, 0x8b, 0xe5, 0xb5, 0xfc, 0x5c, 0x42, 0xdf, 0x67, 0x84, 0x0e, 0xf4, 0x0f,
	0xe7, 0x22, 0xf4, 0xd8, 0x19, 0xc7, 0xa1, 0x7e, 0xfd, 0x4a, 0x01, 0x35, 0xd1, 0xe8, 0xd1, 0xbd,
	0x2c, 0xbf, 0xec, 0x1c, 0x90, 0xcb, 0xec, 0x80, 0x31, 0xfb, 0x40, 0x7f, 0x7f, 0x3e, 0x66, 0xe6,
	0x08, 0x81, 0x72, 0xfa, 0x8d, 0x02, 0x0b, 0xb4, 0x39, 0xa2, 0x5b, 0xb2, 0x01, 0x71, 0x38, 0x37,
	0xc8, 0x42, 0x3e, 0xd9, 0x53, 0xe3, 0x90, 0xd7, 0x9b, 0xf3, 0xb1, 0xf1, 0xa3, 0x7e, 0x9f, 0xd2,
	0xb0, 0x60, 0x35, 0xd5, 0xab, 0xd1, 0x7d, 0x49, 0x8a, 0x49, 0xe6, 0x19, 0x6d, 0x7b, 0xaa, 0x1c,
	0x27, 0x58, 0x55, 0x76, 0x14, 0x9a, 0xfb, 0x97, 0xc7, 0x27, 0x6b, 0xf4, 0x66, 0x5e, 0x94, 0x64,
	0xa6, 0xef, 0x5c, 0x57, 0x1c, 0x32, 0xe5, 0xf7, 0xf5, 0x0f, 0x2e, 0x12, 0x24, 0x23, 0x18, 0x6a,
	0x88, 0x3f, 0x28, 0xb0, 0x9a, 0x6a, 0x8d, 0x32, 0x4b, 0xc8, 0x3a, 0xb5, 0xcc, 0x12, 0xd2, 0x1e,
	0xab, 0xd7, 0x18, 0xdb, 0x7b, 0x48, 0xcf, 0xcf, 0xf7, 0x21, 0xf8, 0x97, 0x0a, 0x5c, 0x4a, 0xcf,
	0x36, 0x48, 0x82, 0x23, 0x9d, 0x7e, 0xb4, 0x09, 0x8d, 0x5b, 0x7f, 0xc0, 0x38, 0xdc, 0xd7, 0xb6,
	0xe4, 0xcd, 0x24, 0xc6, 0x17, 0x05, 0xf1, 0x57, 0x0a, 0x5c, 0x4a, 0x37, 0x6d, 0x19, 0x0b, 0x69,
	0x5b, 0xcf, 0xf5, 0xd9, 0x43, 0xc6, 0x60, 0xbb, 0xc6, 0xdb, 0x59, 0x8c, 0x98, 0xc7, 0x82, 0xe5,
	0x09, 0x6d, 0xba, 0xb2, 0x3c, 0x49, 0x4c, 0x06, 0xd2, 0xd6, 0x90, 0xe8, 0xd5, 0x17, 0xcd, 0x13,
	0x82, 0x71, 0xef, 0xb1, 0x52, 0x6b, 0xfe, 0x65, 0x09, 0x56, 0xc4, 0x9b, 0x25, 0x0e, 0xd0, 0xa7,
	0xa0, 0x72, 0xd3, 0xf3, 0x57, 0xe8, 0xbc, 0xa7, 0x40, 0x2d, 0x6f, 0x43, 0x7f, 0x93, 0xb1, 0xb9,
	0xab, 0xdd, 0x96, 0xba, 0x81, 0x3f, 0x20, 0x0a, 0x1f, 0x7c, 0xa1, 0xc0, 0xb2, 0x40, 0x46, 0x9b,
	0xd2, 0x67, 0x8e, 0xc4, 0x6b, 0xad, 0xb6, 0x35, 0x41, 0x42, 0x58, 0xa2, 0xc9, 0xb0, 0x1f, 0xe8,
	0xdb, 0x0c, 0x9b, 0x61, 0xc9, 0xc1, 0xc5, 0xfb, 0x33, 0x25, 0xe1, 0x41, 0x29, 0x7e, 0x3f, 0x46,
	0x5b, 0xd2, 0x49, 0x22, 0xf9, 0xb2, 0x97, 0xaf, 0xf7, 0x36, 0xc3, 0xde, 0x42, 0x77, 0xa6, 0x60,
	0xd3, 0xc8, 0x83, 0xd1, 0x23, 0x2c, 0xba, 0x2b, 0xcf, 0xb1, 0xd4, 0x6b, 0xb0, 0x76, 0x6f, 0xb2,
	0x90, 0x50, 0x3f, 0x4d, 0x41, 0x96, 0x85, 0xe2, 0xfd, 0xf6, 0x1f, 0x0a, 0x5c, 0x95, 0xbf, 0x92,
	0xa2, 0xc6, 0x04, 0x24, 0xe9, 0x5c, 0xb0, 0x33, 0xfb, 0x01, 0x41, 0x33, 0x3d, 0x65, 0xe5, 0x5b,
	0x6a, 0x6c, 0x46, 0x08, 0x41, 0x4d, 0xbc, 0xb4, 0xca, 0x3a, 0x5d, 0xf6, 0x21, 0x36, 0x37, 0x55,
	0x85, 0xa9, 0x6a, 0xd3, 0xbc, 0xf5, 0x74, 0x00, 0xeb, 0x1d, 0xcf, 0xc9, 0x60, 0x3d, 0x55, 0xf9,
	0x23, 0xdc, 0x11, 0xbd, 0xf6, 0x48, 0xf9, 0xe9, 0xbb, 0x42, 0xa0, 0xeb, 0xf5, 0x4d, 0xb7, 0x5b,
	0xf7, 0x82, 0x6e, 0xa3, 0x8b, 0x5d, 0x06, 0xda, 0xe0, 0x5b, 0xa6, 0x6f, 0x93, 0xd1, 0x3f, 0xa9,
	0x9e, 0xf0, 0xaf, 0xff, 0x29, 0xca, 0xdf, 0x0b, 0x57, 0x9f, 0xf3, 0xb3, 0xfb, 0x7d, 0x2f, 0xb2,
	0x68, 0x4c, 0x1f, 0x47, 0xed, 0xfa, 0x8f, 0x1f, 0xb5, 0x97, 0xd8, 0xf1, 0xb7, 0xff, 0x1f, 0x00,
	0x00, 0xff, 0xff, 0x93, 0x6b, 0x90, 0xee, 0xe2, 0x1a, 0x00, 0x00,
}
