// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/billing.proto

package serviceconfig

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "google.golang.org/genproto/googleapis/api/metric"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Billing related configuration of the service.
//
// The following example shows how to configure metrics for billing:
//
//     metrics:
//     - name: library.googleapis.com/read_calls
//       metric_kind: DELTA
//       value_type: INT64
//     - name: library.googleapis.com/write_calls
//       metric_kind: DELTA
//       value_type: INT64
//     billing:
//       metrics:
//       - library.googleapis.com/read_calls
//       - library.googleapis.com/write_calls
//
// The next example shows how to enable billing status check and customize the
// check behavior. It makes sure billing status check is included in the `Check`
// method of [Service Control API](https://cloud.google.com/service-control/).
// In the example, "google.storage.Get" method can be served when the billing
// status is either `current` or `delinquent`, while "google.storage.Write"
// method can only be served when the billing status is `current`:
//
//     billing:
//       rules:
//       - selector: google.storage.Get
//         allowed_statuses:
//         - current
//         - delinquent
//       - selector: google.storage.Write
//         allowed_statuses: current
//
// Mostly services should only allow `current` status when serving requests.
// In addition, services can choose to allow both `current` and `delinquent`
// statuses when serving read-only requests to resources. If there's no
// matching selector for operation, no billing status check will be performed.
//
type Billing struct {
	// Names of the metrics to report to billing. Each name must
	// be defined in [Service.metrics][google.api.Service.metrics] section.
	Metrics []string `protobuf:"bytes,1,rep,name=metrics" json:"metrics,omitempty"`
	// A list of billing status rules for configuring billing status check.
	Rules []*BillingStatusRule `protobuf:"bytes,5,rep,name=rules" json:"rules,omitempty"`
}

func (m *Billing) Reset()                    { *m = Billing{} }
func (m *Billing) String() string            { return proto.CompactTextString(m) }
func (*Billing) ProtoMessage()               {}
func (*Billing) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *Billing) GetMetrics() []string {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *Billing) GetRules() []*BillingStatusRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// Defines the billing status requirements for operations.
//
// When used with
// [Service Control API](https://cloud.google.com/service-control/), the
// following statuses are supported:
//
// - **current**: the associated billing account is up to date and capable of
//                paying for resource usages.
// - **delinquent**: the associated billing account has a correctable problem,
//                   such as late payment.
//
// Mostly services should only allow `current` status when serving requests.
// In addition, services can choose to allow both `current` and `delinquent`
// statuses when serving read-only requests to resources. If the list of
// allowed_statuses is empty, it means no billing requirement.
//
type BillingStatusRule struct {
	// Selects the operation names to which this rule applies.
	// Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
	Selector string `protobuf:"bytes,1,opt,name=selector" json:"selector,omitempty"`
	// Allowed billing statuses. The billing status check passes if the actual
	// billing status matches any of the provided values here.
	AllowedStatuses []string `protobuf:"bytes,2,rep,name=allowed_statuses,json=allowedStatuses" json:"allowed_statuses,omitempty"`
}

func (m *BillingStatusRule) Reset()                    { *m = BillingStatusRule{} }
func (m *BillingStatusRule) String() string            { return proto.CompactTextString(m) }
func (*BillingStatusRule) ProtoMessage()               {}
func (*BillingStatusRule) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *BillingStatusRule) GetSelector() string {
	if m != nil {
		return m.Selector
	}
	return ""
}

func (m *BillingStatusRule) GetAllowedStatuses() []string {
	if m != nil {
		return m.AllowedStatuses
	}
	return nil
}

func init() {
	proto.RegisterType((*Billing)(nil), "google.api.Billing")
	proto.RegisterType((*BillingStatusRule)(nil), "google.api.BillingStatusRule")
}

func init() { proto.RegisterFile("google/api/billing.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 253 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x90, 0x4f, 0x4b, 0x03, 0x31,
	0x10, 0xc5, 0x59, 0x4b, 0xad, 0x8d, 0xe2, 0x9f, 0xbd, 0x18, 0x16, 0x85, 0xa5, 0xa7, 0xf5, 0x92,
	0x05, 0x7b, 0xf4, 0xb6, 0xe0, 0xbd, 0x6c, 0x2f, 0xd2, 0x8b, 0xa4, 0x71, 0x0c, 0x81, 0x34, 0xb3,
	0x64, 0xb2, 0xfa, 0xf5, 0xc5, 0x24, 0xea, 0x4a, 0x8f, 0x6f, 0x7e, 0xef, 0x65, 0xe6, 0x85, 0x71,
	0x8d, 0xa8, 0x2d, 0xb4, 0x72, 0x30, 0xed, 0xde, 0x58, 0x6b, 0x9c, 0x16, 0x83, 0xc7, 0x80, 0x25,
	0x4b, 0x44, 0xc8, 0xc1, 0x54, 0x77, 0x13, 0x97, 0x74, 0x0e, 0x83, 0x0c, 0x06, 0x1d, 0x25, 0x67,
	0x75, 0x3b, 0xa1, 0x07, 0x08, 0xde, 0xa8, 0x04, 0x56, 0x2f, 0x6c, 0xd1, 0xa5, 0x37, 0x4b, 0xce,
	0x16, 0x09, 0x11, 0x2f, 0xea, 0x59, 0xb3, 0xec, 0x7f, 0x64, 0xb9, 0x66, 0x73, 0x3f, 0x5a, 0x20,
	0x3e, 0xaf, 0x67, 0xcd, 0xf9, 0xe3, 0xbd, 0xf8, 0xdb, 0x2b, 0x72, 0x7a, 0x1b, 0x64, 0x18, 0xa9,
	0x1f, 0x2d, 0xf4, 0xc9, 0xbb, 0xda, 0xb1, 0x9b, 0x23, 0x56, 0x56, 0xec, 0x8c, 0xc0, 0x82, 0x0a,
	0xe8, 0x79, 0x51, 0x17, 0xcd, 0xb2, 0xff, 0xd5, 0xe5, 0x03, 0xbb, 0x96, 0xd6, 0xe2, 0x27, 0xbc,
	0xbd, 0x52, 0x4c, 0x00, 0xf1, 0x93, 0x78, 0xc8, 0x55, 0x9e, 0x6f, 0xf3, 0xb8, 0xd3, 0xec, 0x52,
	0xe1, 0x61, 0x72, 0x46, 0x77, 0x91, 0x77, 0x6d, 0xbe, 0x5b, 0x6d, 0x8a, 0xdd, 0x73, 0x66, 0x1a,
	0xad, 0x74, 0x5a, 0xa0, 0xd7, 0xad, 0x06, 0x17, 0x3b, 0xb7, 0x09, 0xc9, 0xc1, 0x50, 0xfc, 0x0f,
	0x02, 0xff, 0x61, 0x14, 0x28, 0x74, 0xef, 0x46, 0x3f, 0xfd, 0x53, 0xfb, 0xd3, 0x98, 0x58, 0x7f,
	0x05, 0x00, 0x00, 0xff, 0xff, 0xd1, 0x90, 0x2d, 0x32, 0x84, 0x01, 0x00, 0x00,
}
