package bootkube

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	machineConfigServerTLSSecretFileName = "machine-config-server-tls-secret.yaml.template"
)

var _ asset.WritableAsset = (*MachineConfigServerTLSSecret)(nil)

// MachineConfigServerTLSSecret is the constant to represent contents of machine_configservertlssecret.yaml.template file
type MachineConfigServerTLSSecret struct {
	fileName string
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *MachineConfigServerTLSSecret) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *MachineConfigServerTLSSecret) Name() string {
	return "MachineConfigServerTLSSecret"
}

// Generate generates the actual files by this asset
func (t *MachineConfigServerTLSSecret) Generate(parents asset.Parents) error {
	t.fileName = machineConfigServerTLSSecretFileName
	data, err := content.GetBootkubeTemplate(t.fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, t.fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *MachineConfigServerTLSSecret) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *MachineConfigServerTLSSecret) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, machineConfigServerTLSSecretFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
