// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53resolver

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateResolverEndpointIpAddress = "AssociateResolverEndpointIpAddress"

// AssociateResolverEndpointIpAddressRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResolverEndpointIpAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResolverEndpointIpAddress for more information on using the AssociateResolverEndpointIpAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateResolverEndpointIpAddressRequest method.
//    req, resp := client.AssociateResolverEndpointIpAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress
func (c *Route53Resolver) AssociateResolverEndpointIpAddressRequest(input *AssociateResolverEndpointIpAddressInput) (req *request.Request, output *AssociateResolverEndpointIpAddressOutput) {
	op := &request.Operation{
		Name:       opAssociateResolverEndpointIpAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateResolverEndpointIpAddressInput{}
	}

	output = &AssociateResolverEndpointIpAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResolverEndpointIpAddress API operation for Amazon Route 53 Resolver.
//
// Adds IP addresses to an inbound or an outbound resolver endpoint. If you
// want to adding more than one IP address, submit one AssociateResolverEndpointIpAddress
// request for each IP address.
//
// To remove an IP address from an endpoint, see DisassociateResolverEndpointIpAddress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation AssociateResolverEndpointIpAddress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource that you tried to create already exists.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request caused one or more limits to be exceeded.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress
func (c *Route53Resolver) AssociateResolverEndpointIpAddress(input *AssociateResolverEndpointIpAddressInput) (*AssociateResolverEndpointIpAddressOutput, error) {
	req, out := c.AssociateResolverEndpointIpAddressRequest(input)
	return out, req.Send()
}

// AssociateResolverEndpointIpAddressWithContext is the same as AssociateResolverEndpointIpAddress with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResolverEndpointIpAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) AssociateResolverEndpointIpAddressWithContext(ctx aws.Context, input *AssociateResolverEndpointIpAddressInput, opts ...request.Option) (*AssociateResolverEndpointIpAddressOutput, error) {
	req, out := c.AssociateResolverEndpointIpAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResolverRule = "AssociateResolverRule"

// AssociateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResolverRule for more information on using the AssociateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateResolverRuleRequest method.
//    req, resp := client.AssociateResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule
func (c *Route53Resolver) AssociateResolverRuleRequest(input *AssociateResolverRuleInput) (req *request.Request, output *AssociateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opAssociateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateResolverRuleInput{}
	}

	output = &AssociateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResolverRule API operation for Amazon Route 53 Resolver.
//
// Associates a resolver rule with a VPC. When you associate a rule with a VPC,
// Resolver forwards all DNS queries for the domain name that is specified in
// the rule and that originate in the VPC. The queries are forwarded to the
// IP addresses for the DNS resolvers that are specified in the rule. For more
// information about rules, see CreateResolverRule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation AssociateResolverRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource isn't available.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource that you tried to create already exists.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule
func (c *Route53Resolver) AssociateResolverRule(input *AssociateResolverRuleInput) (*AssociateResolverRuleOutput, error) {
	req, out := c.AssociateResolverRuleRequest(input)
	return out, req.Send()
}

// AssociateResolverRuleWithContext is the same as AssociateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) AssociateResolverRuleWithContext(ctx aws.Context, input *AssociateResolverRuleInput, opts ...request.Option) (*AssociateResolverRuleOutput, error) {
	req, out := c.AssociateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverEndpoint = "CreateResolverEndpoint"

// CreateResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResolverEndpoint for more information on using the CreateResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResolverEndpointRequest method.
//    req, resp := client.CreateResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint
func (c *Route53Resolver) CreateResolverEndpointRequest(input *CreateResolverEndpointInput) (req *request.Request, output *CreateResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverEndpointInput{}
	}

	output = &CreateResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Creates a resolver endpoint. There are two types of resolver endpoints, inbound
// and outbound:
//
//    * An inbound resolver endpoint forwards DNS queries to the DNS service
//    for a VPC from your network or another VPC.
//
//    * An outbound resolver endpoint forwards DNS queries from the DNS service
//    for a VPC to your network or another VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateResolverEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource that you tried to create already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request caused one or more limits to be exceeded.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint
func (c *Route53Resolver) CreateResolverEndpoint(input *CreateResolverEndpointInput) (*CreateResolverEndpointOutput, error) {
	req, out := c.CreateResolverEndpointRequest(input)
	return out, req.Send()
}

// CreateResolverEndpointWithContext is the same as CreateResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateResolverEndpointWithContext(ctx aws.Context, input *CreateResolverEndpointInput, opts ...request.Option) (*CreateResolverEndpointOutput, error) {
	req, out := c.CreateResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverRule = "CreateResolverRule"

// CreateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResolverRule for more information on using the CreateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResolverRuleRequest method.
//    req, resp := client.CreateResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule
func (c *Route53Resolver) CreateResolverRuleRequest(input *CreateResolverRuleInput) (req *request.Request, output *CreateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opCreateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverRuleInput{}
	}

	output = &CreateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResolverRule API operation for Amazon Route 53 Resolver.
//
// For DNS queries that originate in your VPCs, specifies which resolver endpoint
// the queries pass through, one domain name that you want to forward to your
// network, and the IP addresses of the DNS resolvers in your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateResolverRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request caused one or more limits to be exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource that you tried to create already exists.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource isn't available.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule
func (c *Route53Resolver) CreateResolverRule(input *CreateResolverRuleInput) (*CreateResolverRuleOutput, error) {
	req, out := c.CreateResolverRuleRequest(input)
	return out, req.Send()
}

// CreateResolverRuleWithContext is the same as CreateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateResolverRuleWithContext(ctx aws.Context, input *CreateResolverRuleInput, opts ...request.Option) (*CreateResolverRuleOutput, error) {
	req, out := c.CreateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResolverEndpoint = "DeleteResolverEndpoint"

// DeleteResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResolverEndpoint for more information on using the DeleteResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResolverEndpointRequest method.
//    req, resp := client.DeleteResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint
func (c *Route53Resolver) DeleteResolverEndpointRequest(input *DeleteResolverEndpointInput) (req *request.Request, output *DeleteResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResolverEndpointInput{}
	}

	output = &DeleteResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Deletes a resolver endpoint. The effect of deleting a resolver endpoint depends
// on whether it's an inbound or an outbound resolver endpoint:
//
//    * Inbound: DNS queries from your network or another VPC are no longer
//    routed to the DNS service for the specified VPC.
//
//    * Outbound: DNS queries from a VPC are no longer routed to your network
//    or to another VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteResolverEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint
func (c *Route53Resolver) DeleteResolverEndpoint(input *DeleteResolverEndpointInput) (*DeleteResolverEndpointOutput, error) {
	req, out := c.DeleteResolverEndpointRequest(input)
	return out, req.Send()
}

// DeleteResolverEndpointWithContext is the same as DeleteResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteResolverEndpointWithContext(ctx aws.Context, input *DeleteResolverEndpointInput, opts ...request.Option) (*DeleteResolverEndpointOutput, error) {
	req, out := c.DeleteResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResolverRule = "DeleteResolverRule"

// DeleteResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResolverRule for more information on using the DeleteResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResolverRuleRequest method.
//    req, resp := client.DeleteResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule
func (c *Route53Resolver) DeleteResolverRuleRequest(input *DeleteResolverRuleInput) (req *request.Request, output *DeleteResolverRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResolverRuleInput{}
	}

	output = &DeleteResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResolverRule API operation for Amazon Route 53 Resolver.
//
// Deletes a resolver rule. Before you can delete a resolver rule, you must
// disassociate it from all the VPCs that you associated the resolver rule with.
// For more infomation, see DisassociateResolverRule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteResolverRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource that you tried to update or delete is currently in use.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule
func (c *Route53Resolver) DeleteResolverRule(input *DeleteResolverRuleInput) (*DeleteResolverRuleOutput, error) {
	req, out := c.DeleteResolverRuleRequest(input)
	return out, req.Send()
}

// DeleteResolverRuleWithContext is the same as DeleteResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteResolverRuleWithContext(ctx aws.Context, input *DeleteResolverRuleInput, opts ...request.Option) (*DeleteResolverRuleOutput, error) {
	req, out := c.DeleteResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResolverEndpointIpAddress = "DisassociateResolverEndpointIpAddress"

// DisassociateResolverEndpointIpAddressRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResolverEndpointIpAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResolverEndpointIpAddress for more information on using the DisassociateResolverEndpointIpAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateResolverEndpointIpAddressRequest method.
//    req, resp := client.DisassociateResolverEndpointIpAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress
func (c *Route53Resolver) DisassociateResolverEndpointIpAddressRequest(input *DisassociateResolverEndpointIpAddressInput) (req *request.Request, output *DisassociateResolverEndpointIpAddressOutput) {
	op := &request.Operation{
		Name:       opDisassociateResolverEndpointIpAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateResolverEndpointIpAddressInput{}
	}

	output = &DisassociateResolverEndpointIpAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResolverEndpointIpAddress API operation for Amazon Route 53 Resolver.
//
// Removes IP addresses from an inbound or an outbound resolver endpoint. If
// you want to remove more than one IP address, submit one DisassociateResolverEndpointIpAddress
// request for each IP address.
//
// To add an IP address to an endpoint, see AssociateResolverEndpointIpAddress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DisassociateResolverEndpointIpAddress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The resource that you tried to create already exists.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress
func (c *Route53Resolver) DisassociateResolverEndpointIpAddress(input *DisassociateResolverEndpointIpAddressInput) (*DisassociateResolverEndpointIpAddressOutput, error) {
	req, out := c.DisassociateResolverEndpointIpAddressRequest(input)
	return out, req.Send()
}

// DisassociateResolverEndpointIpAddressWithContext is the same as DisassociateResolverEndpointIpAddress with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResolverEndpointIpAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DisassociateResolverEndpointIpAddressWithContext(ctx aws.Context, input *DisassociateResolverEndpointIpAddressInput, opts ...request.Option) (*DisassociateResolverEndpointIpAddressOutput, error) {
	req, out := c.DisassociateResolverEndpointIpAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResolverRule = "DisassociateResolverRule"

// DisassociateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResolverRule for more information on using the DisassociateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateResolverRuleRequest method.
//    req, resp := client.DisassociateResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule
func (c *Route53Resolver) DisassociateResolverRuleRequest(input *DisassociateResolverRuleInput) (req *request.Request, output *DisassociateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opDisassociateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateResolverRuleInput{}
	}

	output = &DisassociateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResolverRule API operation for Amazon Route 53 Resolver.
//
// Removes the association between a specified resolver rule and a specified
// VPC.
//
// If you disassociate a resolver rule from a VPC, Resolver stops forwarding
// DNS queries for the domain name that you specified in the resolver rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DisassociateResolverRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule
func (c *Route53Resolver) DisassociateResolverRule(input *DisassociateResolverRuleInput) (*DisassociateResolverRuleOutput, error) {
	req, out := c.DisassociateResolverRuleRequest(input)
	return out, req.Send()
}

// DisassociateResolverRuleWithContext is the same as DisassociateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DisassociateResolverRuleWithContext(ctx aws.Context, input *DisassociateResolverRuleInput, opts ...request.Option) (*DisassociateResolverRuleOutput, error) {
	req, out := c.DisassociateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverEndpoint = "GetResolverEndpoint"

// GetResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverEndpoint for more information on using the GetResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverEndpointRequest method.
//    req, resp := client.GetResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint
func (c *Route53Resolver) GetResolverEndpointRequest(input *GetResolverEndpointInput) (req *request.Request, output *GetResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opGetResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverEndpointInput{}
	}

	output = &GetResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified resolver endpoint, such as whether it's
// an inbound or an outbound resolver endpoint, and the current status of the
// endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint
func (c *Route53Resolver) GetResolverEndpoint(input *GetResolverEndpointInput) (*GetResolverEndpointOutput, error) {
	req, out := c.GetResolverEndpointRequest(input)
	return out, req.Send()
}

// GetResolverEndpointWithContext is the same as GetResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverEndpointWithContext(ctx aws.Context, input *GetResolverEndpointInput, opts ...request.Option) (*GetResolverEndpointOutput, error) {
	req, out := c.GetResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverRule = "GetResolverRule"

// GetResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverRule for more information on using the GetResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverRuleRequest method.
//    req, resp := client.GetResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule
func (c *Route53Resolver) GetResolverRuleRequest(input *GetResolverRuleInput) (req *request.Request, output *GetResolverRuleOutput) {
	op := &request.Operation{
		Name:       opGetResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRuleInput{}
	}

	output = &GetResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverRule API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified resolver rule, such as the domain name
// that the rule forwards DNS queries for and the ID of the outbound resolver
// endpoint that the rule is associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule
func (c *Route53Resolver) GetResolverRule(input *GetResolverRuleInput) (*GetResolverRuleOutput, error) {
	req, out := c.GetResolverRuleRequest(input)
	return out, req.Send()
}

// GetResolverRuleWithContext is the same as GetResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverRuleWithContext(ctx aws.Context, input *GetResolverRuleInput, opts ...request.Option) (*GetResolverRuleOutput, error) {
	req, out := c.GetResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverRuleAssociation = "GetResolverRuleAssociation"

// GetResolverRuleAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverRuleAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverRuleAssociation for more information on using the GetResolverRuleAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverRuleAssociationRequest method.
//    req, resp := client.GetResolverRuleAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation
func (c *Route53Resolver) GetResolverRuleAssociationRequest(input *GetResolverRuleAssociationInput) (req *request.Request, output *GetResolverRuleAssociationOutput) {
	op := &request.Operation{
		Name:       opGetResolverRuleAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRuleAssociationInput{}
	}

	output = &GetResolverRuleAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverRuleAssociation API operation for Amazon Route 53 Resolver.
//
// Gets information about an association between a specified resolver rule and
// a VPC. You associate a resolver rule and a VPC using AssociateResolverRule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverRuleAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation
func (c *Route53Resolver) GetResolverRuleAssociation(input *GetResolverRuleAssociationInput) (*GetResolverRuleAssociationOutput, error) {
	req, out := c.GetResolverRuleAssociationRequest(input)
	return out, req.Send()
}

// GetResolverRuleAssociationWithContext is the same as GetResolverRuleAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverRuleAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverRuleAssociationWithContext(ctx aws.Context, input *GetResolverRuleAssociationInput, opts ...request.Option) (*GetResolverRuleAssociationOutput, error) {
	req, out := c.GetResolverRuleAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverRulePolicy = "GetResolverRulePolicy"

// GetResolverRulePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverRulePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverRulePolicy for more information on using the GetResolverRulePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResolverRulePolicyRequest method.
//    req, resp := client.GetResolverRulePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy
func (c *Route53Resolver) GetResolverRulePolicyRequest(input *GetResolverRulePolicyInput) (req *request.Request, output *GetResolverRulePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResolverRulePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRulePolicyInput{}
	}

	output = &GetResolverRulePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverRulePolicy API operation for Amazon Route 53 Resolver.
//
// Gets information about a resolver rule policy. A resolver rule policy specifies
// the Resolver operations and resources that you want to allow another AWS
// account to be able to use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverRulePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeUnknownResourceException "UnknownResourceException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy
func (c *Route53Resolver) GetResolverRulePolicy(input *GetResolverRulePolicyInput) (*GetResolverRulePolicyOutput, error) {
	req, out := c.GetResolverRulePolicyRequest(input)
	return out, req.Send()
}

// GetResolverRulePolicyWithContext is the same as GetResolverRulePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverRulePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverRulePolicyWithContext(ctx aws.Context, input *GetResolverRulePolicyInput, opts ...request.Option) (*GetResolverRulePolicyOutput, error) {
	req, out := c.GetResolverRulePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResolverEndpointIpAddresses = "ListResolverEndpointIpAddresses"

// ListResolverEndpointIpAddressesRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverEndpointIpAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverEndpointIpAddresses for more information on using the ListResolverEndpointIpAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverEndpointIpAddressesRequest method.
//    req, resp := client.ListResolverEndpointIpAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses
func (c *Route53Resolver) ListResolverEndpointIpAddressesRequest(input *ListResolverEndpointIpAddressesInput) (req *request.Request, output *ListResolverEndpointIpAddressesOutput) {
	op := &request.Operation{
		Name:       opListResolverEndpointIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverEndpointIpAddressesInput{}
	}

	output = &ListResolverEndpointIpAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverEndpointIpAddresses API operation for Amazon Route 53 Resolver.
//
// Gets the IP addresses for a specified resolver endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverEndpointIpAddresses for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses
func (c *Route53Resolver) ListResolverEndpointIpAddresses(input *ListResolverEndpointIpAddressesInput) (*ListResolverEndpointIpAddressesOutput, error) {
	req, out := c.ListResolverEndpointIpAddressesRequest(input)
	return out, req.Send()
}

// ListResolverEndpointIpAddressesWithContext is the same as ListResolverEndpointIpAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverEndpointIpAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointIpAddressesWithContext(ctx aws.Context, input *ListResolverEndpointIpAddressesInput, opts ...request.Option) (*ListResolverEndpointIpAddressesOutput, error) {
	req, out := c.ListResolverEndpointIpAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverEndpointIpAddressesPages iterates over the pages of a ListResolverEndpointIpAddresses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverEndpointIpAddresses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverEndpointIpAddresses operation.
//    pageNum := 0
//    err := client.ListResolverEndpointIpAddressesPages(params,
//        func(page *ListResolverEndpointIpAddressesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverEndpointIpAddressesPages(input *ListResolverEndpointIpAddressesInput, fn func(*ListResolverEndpointIpAddressesOutput, bool) bool) error {
	return c.ListResolverEndpointIpAddressesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverEndpointIpAddressesPagesWithContext same as ListResolverEndpointIpAddressesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointIpAddressesPagesWithContext(ctx aws.Context, input *ListResolverEndpointIpAddressesInput, fn func(*ListResolverEndpointIpAddressesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverEndpointIpAddressesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverEndpointIpAddressesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListResolverEndpointIpAddressesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListResolverEndpoints = "ListResolverEndpoints"

// ListResolverEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverEndpoints for more information on using the ListResolverEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverEndpointsRequest method.
//    req, resp := client.ListResolverEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints
func (c *Route53Resolver) ListResolverEndpointsRequest(input *ListResolverEndpointsInput) (req *request.Request, output *ListResolverEndpointsOutput) {
	op := &request.Operation{
		Name:       opListResolverEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverEndpointsInput{}
	}

	output = &ListResolverEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverEndpoints API operation for Amazon Route 53 Resolver.
//
// Lists all the resolver endpoints that were created using the current AWS
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverEndpoints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints
func (c *Route53Resolver) ListResolverEndpoints(input *ListResolverEndpointsInput) (*ListResolverEndpointsOutput, error) {
	req, out := c.ListResolverEndpointsRequest(input)
	return out, req.Send()
}

// ListResolverEndpointsWithContext is the same as ListResolverEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointsWithContext(ctx aws.Context, input *ListResolverEndpointsInput, opts ...request.Option) (*ListResolverEndpointsOutput, error) {
	req, out := c.ListResolverEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverEndpointsPages iterates over the pages of a ListResolverEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverEndpoints operation.
//    pageNum := 0
//    err := client.ListResolverEndpointsPages(params,
//        func(page *ListResolverEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverEndpointsPages(input *ListResolverEndpointsInput, fn func(*ListResolverEndpointsOutput, bool) bool) error {
	return c.ListResolverEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverEndpointsPagesWithContext same as ListResolverEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointsPagesWithContext(ctx aws.Context, input *ListResolverEndpointsInput, fn func(*ListResolverEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListResolverEndpointsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListResolverRuleAssociations = "ListResolverRuleAssociations"

// ListResolverRuleAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverRuleAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverRuleAssociations for more information on using the ListResolverRuleAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverRuleAssociationsRequest method.
//    req, resp := client.ListResolverRuleAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations
func (c *Route53Resolver) ListResolverRuleAssociationsRequest(input *ListResolverRuleAssociationsInput) (req *request.Request, output *ListResolverRuleAssociationsOutput) {
	op := &request.Operation{
		Name:       opListResolverRuleAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverRuleAssociationsInput{}
	}

	output = &ListResolverRuleAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverRuleAssociations API operation for Amazon Route 53 Resolver.
//
// Lists the associations that were created between resolver rules and VPCs
// using the current AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverRuleAssociations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations
func (c *Route53Resolver) ListResolverRuleAssociations(input *ListResolverRuleAssociationsInput) (*ListResolverRuleAssociationsOutput, error) {
	req, out := c.ListResolverRuleAssociationsRequest(input)
	return out, req.Send()
}

// ListResolverRuleAssociationsWithContext is the same as ListResolverRuleAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverRuleAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRuleAssociationsWithContext(ctx aws.Context, input *ListResolverRuleAssociationsInput, opts ...request.Option) (*ListResolverRuleAssociationsOutput, error) {
	req, out := c.ListResolverRuleAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverRuleAssociationsPages iterates over the pages of a ListResolverRuleAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverRuleAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverRuleAssociations operation.
//    pageNum := 0
//    err := client.ListResolverRuleAssociationsPages(params,
//        func(page *ListResolverRuleAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverRuleAssociationsPages(input *ListResolverRuleAssociationsInput, fn func(*ListResolverRuleAssociationsOutput, bool) bool) error {
	return c.ListResolverRuleAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverRuleAssociationsPagesWithContext same as ListResolverRuleAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRuleAssociationsPagesWithContext(ctx aws.Context, input *ListResolverRuleAssociationsInput, fn func(*ListResolverRuleAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverRuleAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverRuleAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListResolverRuleAssociationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListResolverRules = "ListResolverRules"

// ListResolverRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverRules for more information on using the ListResolverRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResolverRulesRequest method.
//    req, resp := client.ListResolverRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules
func (c *Route53Resolver) ListResolverRulesRequest(input *ListResolverRulesInput) (req *request.Request, output *ListResolverRulesOutput) {
	op := &request.Operation{
		Name:       opListResolverRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverRulesInput{}
	}

	output = &ListResolverRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverRules API operation for Amazon Route 53 Resolver.
//
// Lists the resolver rules that were created using the current AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules
func (c *Route53Resolver) ListResolverRules(input *ListResolverRulesInput) (*ListResolverRulesOutput, error) {
	req, out := c.ListResolverRulesRequest(input)
	return out, req.Send()
}

// ListResolverRulesWithContext is the same as ListResolverRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRulesWithContext(ctx aws.Context, input *ListResolverRulesInput, opts ...request.Option) (*ListResolverRulesOutput, error) {
	req, out := c.ListResolverRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverRulesPages iterates over the pages of a ListResolverRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResolverRules operation.
//    pageNum := 0
//    err := client.ListResolverRulesPages(params,
//        func(page *ListResolverRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Resolver) ListResolverRulesPages(input *ListResolverRulesInput, fn func(*ListResolverRulesOutput, bool) bool) error {
	return c.ListResolverRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverRulesPagesWithContext same as ListResolverRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRulesPagesWithContext(ctx aws.Context, input *ListResolverRulesInput, fn func(*ListResolverRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListResolverRulesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource
func (c *Route53Resolver) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Route 53 Resolver.
//
// Lists the tags that you associated with the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The value that you specified for NextToken in a List request isn't valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource
func (c *Route53Resolver) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResolverRulePolicy = "PutResolverRulePolicy"

// PutResolverRulePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResolverRulePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResolverRulePolicy for more information on using the PutResolverRulePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResolverRulePolicyRequest method.
//    req, resp := client.PutResolverRulePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy
func (c *Route53Resolver) PutResolverRulePolicyRequest(input *PutResolverRulePolicyInput) (req *request.Request, output *PutResolverRulePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResolverRulePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResolverRulePolicyInput{}
	}

	output = &PutResolverRulePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResolverRulePolicy API operation for Amazon Route 53 Resolver.
//
// Specifies the Resolver operations and resources that you want to allow another
// AWS account to be able to use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation PutResolverRulePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidPolicyDocument "InvalidPolicyDocument"
//   The specified resolver rule policy is invalid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeUnknownResourceException "UnknownResourceException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy
func (c *Route53Resolver) PutResolverRulePolicy(input *PutResolverRulePolicyInput) (*PutResolverRulePolicyOutput, error) {
	req, out := c.PutResolverRulePolicyRequest(input)
	return out, req.Send()
}

// PutResolverRulePolicyWithContext is the same as PutResolverRulePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResolverRulePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) PutResolverRulePolicyWithContext(ctx aws.Context, input *PutResolverRulePolicyInput, opts ...request.Option) (*PutResolverRulePolicyOutput, error) {
	req, out := c.PutResolverRulePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource
func (c *Route53Resolver) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon Route 53 Resolver.
//
// Adds one or more tags to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request caused one or more limits to be exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInvalidTagException "InvalidTagException"
//   The specified tag is invalid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource
func (c *Route53Resolver) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource
func (c *Route53Resolver) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon Route 53 Resolver.
//
// Removes one or more tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource
func (c *Route53Resolver) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResolverEndpoint = "UpdateResolverEndpoint"

// UpdateResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResolverEndpoint for more information on using the UpdateResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResolverEndpointRequest method.
//    req, resp := client.UpdateResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint
func (c *Route53Resolver) UpdateResolverEndpointRequest(input *UpdateResolverEndpointInput) (req *request.Request, output *UpdateResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResolverEndpointInput{}
	}

	output = &UpdateResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Updates the name of an inbound or an outbound resolver endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateResolverEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint
func (c *Route53Resolver) UpdateResolverEndpoint(input *UpdateResolverEndpointInput) (*UpdateResolverEndpointOutput, error) {
	req, out := c.UpdateResolverEndpointRequest(input)
	return out, req.Send()
}

// UpdateResolverEndpointWithContext is the same as UpdateResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateResolverEndpointWithContext(ctx aws.Context, input *UpdateResolverEndpointInput, opts ...request.Option) (*UpdateResolverEndpointOutput, error) {
	req, out := c.UpdateResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResolverRule = "UpdateResolverRule"

// UpdateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResolverRule for more information on using the UpdateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResolverRuleRequest method.
//    req, resp := client.UpdateResolverRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule
func (c *Route53Resolver) UpdateResolverRuleRequest(input *UpdateResolverRuleInput) (req *request.Request, output *UpdateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResolverRuleInput{}
	}

	output = &UpdateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResolverRule API operation for Amazon Route 53 Resolver.
//
// Updates settings for a specified resolver rule. ResolverRuleId is required,
// and all other parameters are optional. If you don't specify a parameter,
// it retains its current value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateResolverRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more parameters in this request are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource doesn't exist.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource isn't available.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request caused one or more limits to be exceeded.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   We encountered an unknown error. Try again in a few minutes.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule
func (c *Route53Resolver) UpdateResolverRule(input *UpdateResolverRuleInput) (*UpdateResolverRuleOutput, error) {
	req, out := c.UpdateResolverRuleRequest(input)
	return out, req.Send()
}

// UpdateResolverRuleWithContext is the same as UpdateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateResolverRuleWithContext(ctx aws.Context, input *UpdateResolverRuleInput, opts ...request.Option) (*UpdateResolverRuleOutput, error) {
	req, out := c.UpdateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateResolverEndpointIpAddressInput struct {
	_ struct{} `type:"structure"`

	// Either the IPv4 address that you want to add to a resolver endpoint or a
	// subnet ID. If you specify a subnet ID, Resolver chooses an IP address for
	// you from the available IPs in the specified subnet.
	//
	// IpAddress is a required field
	IpAddress *IpAddressUpdate `type:"structure" required:"true"`

	// The ID of the resolver endpoint that you want to associate IP addresses with.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateResolverEndpointIpAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverEndpointIpAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResolverEndpointIpAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResolverEndpointIpAddressInput"}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.IpAddress != nil {
		if err := s.IpAddress.Validate(); err != nil {
			invalidParams.AddNested("IpAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAddress sets the IpAddress field's value.
func (s *AssociateResolverEndpointIpAddressInput) SetIpAddress(v *IpAddressUpdate) *AssociateResolverEndpointIpAddressInput {
	s.IpAddress = v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *AssociateResolverEndpointIpAddressInput) SetResolverEndpointId(v string) *AssociateResolverEndpointIpAddressInput {
	s.ResolverEndpointId = &v
	return s
}

type AssociateResolverEndpointIpAddressOutput struct {
	_ struct{} `type:"structure"`

	// The response to an AssociateResolverEndpointIpAddress request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s AssociateResolverEndpointIpAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverEndpointIpAddressOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *AssociateResolverEndpointIpAddressOutput) SetResolverEndpoint(v *ResolverEndpoint) *AssociateResolverEndpointIpAddressOutput {
	s.ResolverEndpoint = v
	return s
}

type AssociateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// A name for the association that you're creating between a resolver rule and
	// a VPC.
	Name *string `type:"string"`

	// The ID of the resolver rule that you want to associate with the VPC. To list
	// the existing resolver rules, use ListResolverRules.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`

	// The ID of the VPC that you want to associate the resolver rule with.
	//
	// VPCId is a required field
	VPCId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}
	if s.VPCId == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCId"))
	}
	if s.VPCId != nil && len(*s.VPCId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AssociateResolverRuleInput) SetName(v string) *AssociateResolverRuleInput {
	s.Name = &v
	return s
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *AssociateResolverRuleInput) SetResolverRuleId(v string) *AssociateResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *AssociateResolverRuleInput) SetVPCId(v string) *AssociateResolverRuleInput {
	s.VPCId = &v
	return s
}

type AssociateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the AssociateResolverRule request, including the status
	// of the request.
	ResolverRuleAssociation *ResolverRuleAssociation `type:"structure"`
}

// String returns the string representation
func (s AssociateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRuleAssociation sets the ResolverRuleAssociation field's value.
func (s *AssociateResolverRuleOutput) SetResolverRuleAssociation(v *ResolverRuleAssociation) *AssociateResolverRuleOutput {
	s.ResolverRuleAssociation = v
	return s
}

type CreateResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of executing the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	//
	// CreatorRequestId is a required field
	CreatorRequestId *string `min:"1" type:"string" required:"true"`

	// Specify the applicable value:
	//
	//    * INBOUND: Resolver forwards DNS queries to the DNS service for a VPC
	//    from your network or another VPC
	//
	//    * OUTBOUND: Resolver forwards DNS queries from the DNS service for a VPC
	//    to your network or another VPC
	//
	// Direction is a required field
	Direction *string `type:"string" required:"true" enum:"ResolverEndpointDirection"`

	// The subnets and IP addresses in your VPC that you want DNS queries to pass
	// through on the way from your VPCs to your network (for outbound endpoints)
	// or on the way from your network to your VPCs (for inbound resolver endpoints).
	//
	// IpAddresses is a required field
	IpAddresses []*IpAddressRequest `min:"1" type:"list" required:"true"`

	// A friendly name that lets you easily find a configuration in the Resolver
	// dashboard in the Route 53 console.
	Name *string `type:"string"`

	// The ID of one or more security groups that you want to use to control access
	// to this VPC. The security group that you specify must include one or more
	// inbound rules (for inbound resolver endpoints) or outbound rules (for outbound
	// resolver endpoints).
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `type:"list" required:"true"`

	// A list of the tag keys and values that you want to associate with the endpoint.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverEndpointInput"}
	if s.CreatorRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorRequestId"))
	}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.Direction == nil {
		invalidParams.Add(request.NewErrParamRequired("Direction"))
	}
	if s.IpAddresses == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddresses"))
	}
	if s.IpAddresses != nil && len(s.IpAddresses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpAddresses", 1))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.IpAddresses != nil {
		for i, v := range s.IpAddresses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IpAddresses", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateResolverEndpointInput) SetCreatorRequestId(v string) *CreateResolverEndpointInput {
	s.CreatorRequestId = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *CreateResolverEndpointInput) SetDirection(v string) *CreateResolverEndpointInput {
	s.Direction = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *CreateResolverEndpointInput) SetIpAddresses(v []*IpAddressRequest) *CreateResolverEndpointInput {
	s.IpAddresses = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverEndpointInput) SetName(v string) *CreateResolverEndpointInput {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateResolverEndpointInput) SetSecurityGroupIds(v []*string) *CreateResolverEndpointInput {
	s.SecurityGroupIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverEndpointInput) SetTags(v []*Tag) *CreateResolverEndpointInput {
	s.Tags = v
	return s
}

type CreateResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the CreateResolverEndpoint request, including the status
	// of the request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s CreateResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *CreateResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *CreateResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type CreateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of executing the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	//
	// CreatorRequestId is a required field
	CreatorRequestId *string `min:"1" type:"string" required:"true"`

	// DNS queries for this domain name are forwarded to the IP addresses that you
	// specify in TargetIps. If a query matches multiple resolver rules (example.com
	// and www.example.com), outbound DNS queries are routed using the resolver
	// rule that contains the most specific domain name (www.example.com).
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// A friendly name that lets you easily find a rule in the Resolver dashboard
	// in the Route 53 console.
	Name *string `type:"string"`

	// The ID of the outbound resolver endpoint that you want to use to route DNS
	// queries to the IP addresses that you specify in TargetIps.
	ResolverEndpointId *string `min:"1" type:"string"`

	// Specify FORWARD. Other resolver rule types aren't supported.
	//
	// RuleType is a required field
	RuleType *string `type:"string" required:"true" enum:"RuleTypeOption"`

	// A list of the tag keys and values that you want to associate with the endpoint.
	Tags []*Tag `type:"list"`

	// The IPs that you want Resolver to forward DNS queries to. You can specify
	// only IPv4 addresses. Separate IP addresses with a comma.
	TargetIps []*TargetAddress `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverRuleInput"}
	if s.CreatorRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorRequestId"))
	}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.RuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleType"))
	}
	if s.TargetIps != nil && len(s.TargetIps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetIps", 1))
	}
	if s.TargetIps != nil {
		for i, v := range s.TargetIps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetIps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateResolverRuleInput) SetCreatorRequestId(v string) *CreateResolverRuleInput {
	s.CreatorRequestId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateResolverRuleInput) SetDomainName(v string) *CreateResolverRuleInput {
	s.DomainName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverRuleInput) SetName(v string) *CreateResolverRuleInput {
	s.Name = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *CreateResolverRuleInput) SetResolverEndpointId(v string) *CreateResolverRuleInput {
	s.ResolverEndpointId = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *CreateResolverRuleInput) SetRuleType(v string) *CreateResolverRuleInput {
	s.RuleType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverRuleInput) SetTags(v []*Tag) *CreateResolverRuleInput {
	s.Tags = v
	return s
}

// SetTargetIps sets the TargetIps field's value.
func (s *CreateResolverRuleInput) SetTargetIps(v []*TargetAddress) *CreateResolverRuleInput {
	s.TargetIps = v
	return s
}

type CreateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the CreateResolverRule request, including the status of
	// the request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation
func (s CreateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *CreateResolverRuleOutput) SetResolverRule(v *ResolverRule) *CreateResolverRuleOutput {
	s.ResolverRule = v
	return s
}

type DeleteResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver endpoint that you want to delete.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResolverEndpointInput"}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *DeleteResolverEndpointInput) SetResolverEndpointId(v string) *DeleteResolverEndpointInput {
	s.ResolverEndpointId = &v
	return s
}

type DeleteResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DeleteResolverEndpoint request, including the status
	// of the request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s DeleteResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *DeleteResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *DeleteResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type DeleteResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver rule that you want to delete.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *DeleteResolverRuleInput) SetResolverRuleId(v string) *DeleteResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

type DeleteResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DeleteResolverRule request, including the status of
	// the request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation
func (s DeleteResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *DeleteResolverRuleOutput) SetResolverRule(v *ResolverRule) *DeleteResolverRuleOutput {
	s.ResolverRule = v
	return s
}

type DisassociateResolverEndpointIpAddressInput struct {
	_ struct{} `type:"structure"`

	// The IPv4 address that you want to remove from a resolver endpoint.
	//
	// IpAddress is a required field
	IpAddress *IpAddressUpdate `type:"structure" required:"true"`

	// The ID of the resolver endpoint that you want to disassociate an IP address
	// from.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateResolverEndpointIpAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverEndpointIpAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResolverEndpointIpAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResolverEndpointIpAddressInput"}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.IpAddress != nil {
		if err := s.IpAddress.Validate(); err != nil {
			invalidParams.AddNested("IpAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAddress sets the IpAddress field's value.
func (s *DisassociateResolverEndpointIpAddressInput) SetIpAddress(v *IpAddressUpdate) *DisassociateResolverEndpointIpAddressInput {
	s.IpAddress = v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *DisassociateResolverEndpointIpAddressInput) SetResolverEndpointId(v string) *DisassociateResolverEndpointIpAddressInput {
	s.ResolverEndpointId = &v
	return s
}

type DisassociateResolverEndpointIpAddressOutput struct {
	_ struct{} `type:"structure"`

	// The response to an DisassociateResolverEndpointIpAddress request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s DisassociateResolverEndpointIpAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverEndpointIpAddressOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *DisassociateResolverEndpointIpAddressOutput) SetResolverEndpoint(v *ResolverEndpoint) *DisassociateResolverEndpointIpAddressOutput {
	s.ResolverEndpoint = v
	return s
}

type DisassociateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver rule that you want to disassociate from the specified
	// VPC.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`

	// The ID of the VPC that you want to disassociate the resolver rule from.
	//
	// VPCId is a required field
	VPCId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}
	if s.VPCId == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCId"))
	}
	if s.VPCId != nil && len(*s.VPCId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *DisassociateResolverRuleInput) SetResolverRuleId(v string) *DisassociateResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *DisassociateResolverRuleInput) SetVPCId(v string) *DisassociateResolverRuleInput {
	s.VPCId = &v
	return s
}

type DisassociateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DisassociateResolverRule request, including the status
	// of the request.
	ResolverRuleAssociation *ResolverRuleAssociation `type:"structure"`
}

// String returns the string representation
func (s DisassociateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRuleAssociation sets the ResolverRuleAssociation field's value.
func (s *DisassociateResolverRuleOutput) SetResolverRuleAssociation(v *ResolverRuleAssociation) *DisassociateResolverRuleOutput {
	s.ResolverRuleAssociation = v
	return s
}

// For List operations, an optional specification to return a subset of objects,
// such as resolver endpoints or resolver rules.
type Filter struct {
	_ struct{} `type:"structure"`

	// When you're using a List operation and you want the operation to return a
	// subset of objects, such as resolver endpoints or resolver rules, the name
	// of the parameter that you want to use to filter objects. For example, to
	// list only inbound resolver endpoints, specify Direction for the value of
	// Name.
	Name *string `min:"1" type:"string"`

	// When you're using a List operation and you want the operation to return a
	// subset of objects, such as resolver endpoints or resolver rules, the value
	// of the parameter that you want to use to filter objects. For example, to
	// list only inbound resolver endpoints, specify INBOUND for the value of Values.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type GetResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver endpoint that you want to get information about.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverEndpointInput"}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *GetResolverEndpointInput) SetResolverEndpointId(v string) *GetResolverEndpointInput {
	s.ResolverEndpointId = &v
	return s
}

type GetResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resolver endpoint that you specified in a GetResolverEndpoint
	// request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s GetResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *GetResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *GetResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type GetResolverRuleAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver rule association that you want to get information
	// about.
	//
	// ResolverRuleAssociationId is a required field
	ResolverRuleAssociationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverRuleAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRuleAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRuleAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverRuleAssociationInput"}
	if s.ResolverRuleAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleAssociationId"))
	}
	if s.ResolverRuleAssociationId != nil && len(*s.ResolverRuleAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleAssociationId sets the ResolverRuleAssociationId field's value.
func (s *GetResolverRuleAssociationInput) SetResolverRuleAssociationId(v string) *GetResolverRuleAssociationInput {
	s.ResolverRuleAssociationId = &v
	return s
}

type GetResolverRuleAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resolver rule association that you specified in a GetResolverRuleAssociation
	// request.
	ResolverRuleAssociation *ResolverRuleAssociation `type:"structure"`
}

// String returns the string representation
func (s GetResolverRuleAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRuleAssociationOutput) GoString() string {
	return s.String()
}

// SetResolverRuleAssociation sets the ResolverRuleAssociation field's value.
func (s *GetResolverRuleAssociationOutput) SetResolverRuleAssociation(v *ResolverRuleAssociation) *GetResolverRuleAssociationOutput {
	s.ResolverRuleAssociation = v
	return s
}

type GetResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver rule that you want to get information about.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *GetResolverRuleInput) SetResolverRuleId(v string) *GetResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

type GetResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resolver rule that you specified in a GetResolverRule
	// request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation
func (s GetResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *GetResolverRuleOutput) SetResolverRule(v *ResolverRule) *GetResolverRuleOutput {
	s.ResolverRule = v
	return s
}

type GetResolverRulePolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver rule policy that you want to get information about.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverRulePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRulePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRulePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverRulePolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetResolverRulePolicyInput) SetArn(v string) *GetResolverRulePolicyInput {
	s.Arn = &v
	return s
}

type GetResolverRulePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resolver rule policy that you specified in a GetResolverRulePolicy
	// request.
	ResolverRulePolicy *string `type:"string"`
}

// String returns the string representation
func (s GetResolverRulePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResolverRulePolicyOutput) GoString() string {
	return s.String()
}

// SetResolverRulePolicy sets the ResolverRulePolicy field's value.
func (s *GetResolverRulePolicyOutput) SetResolverRulePolicy(v string) *GetResolverRulePolicyOutput {
	s.ResolverRulePolicy = &v
	return s
}

// In an CreateResolverEndpoint request, a subnet and IP address that you want
// to use for DNS queries.
type IpAddressRequest struct {
	_ struct{} `type:"structure"`

	// The IP address that you want to use for DNS queries.
	Ip *string `min:"7" type:"string"`

	// The subnet that contains the IP address.
	//
	// SubnetId is a required field
	SubnetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IpAddressRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAddressRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpAddressRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpAddressRequest"}
	if s.Ip != nil && len(*s.Ip) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 7))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *IpAddressRequest) SetIp(v string) *IpAddressRequest {
	s.Ip = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *IpAddressRequest) SetSubnetId(v string) *IpAddressRequest {
	s.SubnetId = &v
	return s
}

// In the response to a GetResolverEndpoint request, information about the IP
// addresses that the resolver endpoint uses for DNS queries.
type IpAddressResponse struct {
	_ struct{} `type:"structure"`

	// The date and time that the IP address was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// One IP address that the resolver endpoint uses for DNS queries.
	Ip *string `min:"7" type:"string"`

	// The ID of one IP address.
	IpId *string `min:"1" type:"string"`

	// The date and time that the IP address was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// A status code that gives the current status of the request.
	Status *string `type:"string" enum:"IpAddressStatus"`

	// A message that provides additional information about the status of the request.
	StatusMessage *string `type:"string"`

	// The ID of one subnet.
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IpAddressResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAddressResponse) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *IpAddressResponse) SetCreationTime(v string) *IpAddressResponse {
	s.CreationTime = &v
	return s
}

// SetIp sets the Ip field's value.
func (s *IpAddressResponse) SetIp(v string) *IpAddressResponse {
	s.Ip = &v
	return s
}

// SetIpId sets the IpId field's value.
func (s *IpAddressResponse) SetIpId(v string) *IpAddressResponse {
	s.IpId = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *IpAddressResponse) SetModificationTime(v string) *IpAddressResponse {
	s.ModificationTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IpAddressResponse) SetStatus(v string) *IpAddressResponse {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *IpAddressResponse) SetStatusMessage(v string) *IpAddressResponse {
	s.StatusMessage = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *IpAddressResponse) SetSubnetId(v string) *IpAddressResponse {
	s.SubnetId = &v
	return s
}

// In an UpdateResolverEndpoint request, information about an IP address to
// update.
type IpAddressUpdate struct {
	_ struct{} `type:"structure"`

	// The new IP address.
	Ip *string `min:"7" type:"string"`

	// Only when removing an IP address from a resolver endpoint: The ID of the
	// IP address that you want to remove. To get this ID, use GetResolverEndpoint.
	IpId *string `min:"1" type:"string"`

	// The ID of the subnet that includes the IP address that you want to update.
	// To get this ID, use GetResolverEndpoint.
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IpAddressUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAddressUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpAddressUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpAddressUpdate"}
	if s.Ip != nil && len(*s.Ip) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 7))
	}
	if s.IpId != nil && len(*s.IpId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpId", 1))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *IpAddressUpdate) SetIp(v string) *IpAddressUpdate {
	s.Ip = &v
	return s
}

// SetIpId sets the IpId field's value.
func (s *IpAddressUpdate) SetIpId(v string) *IpAddressUpdate {
	s.IpId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *IpAddressUpdate) SetSubnetId(v string) *IpAddressUpdate {
	s.SubnetId = &v
	return s
}

type ListResolverEndpointIpAddressesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of IP addresses that you want to return in the response
	// to a ListResolverEndpointIpAddresses request. If you don't specify a value
	// for MaxResults, Resolver returns up to 100 IP addresses.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverEndpointIpAddresses request, omit this value.
	//
	// If the specified resolver endpoint has more than MaxResults IP addresses,
	// you can submit another ListResolverEndpointIpAddresses request to get the
	// next group of IP addresses. In the next request, specify the value of NextToken
	// from the previous response.
	NextToken *string `type:"string"`

	// The ID of the resolver endpoint that you want to get IP addresses for.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResolverEndpointIpAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverEndpointIpAddressesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverEndpointIpAddressesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverEndpointIpAddressesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointIpAddressesInput) SetMaxResults(v int64) *ListResolverEndpointIpAddressesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointIpAddressesInput) SetNextToken(v string) *ListResolverEndpointIpAddressesInput {
	s.NextToken = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *ListResolverEndpointIpAddressesInput) SetResolverEndpointId(v string) *ListResolverEndpointIpAddressesInput {
	s.ResolverEndpointId = &v
	return s
}

type ListResolverEndpointIpAddressesOutput struct {
	_ struct{} `type:"structure"`

	// The IP addresses that DNS queries pass through on their way to your network
	// (outbound endpoint) or on the way to Resolver (inbound endpoint).
	IpAddresses []*IpAddressResponse `type:"list"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the specified endpoint has more than MaxResults IP addresses, you can
	// submit another ListResolverEndpointIpAddresses request to get the next group
	// of IP addresses. In the next request, specify the value of NextToken from
	// the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResolverEndpointIpAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverEndpointIpAddressesOutput) GoString() string {
	return s.String()
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *ListResolverEndpointIpAddressesOutput) SetIpAddresses(v []*IpAddressResponse) *ListResolverEndpointIpAddressesOutput {
	s.IpAddresses = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointIpAddressesOutput) SetMaxResults(v int64) *ListResolverEndpointIpAddressesOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointIpAddressesOutput) SetNextToken(v string) *ListResolverEndpointIpAddressesOutput {
	s.NextToken = &v
	return s
}

type ListResolverEndpointsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of resolver endpoints, such
	// as all inbound resolver endpoints.
	//
	// If you submit a second or subsequent ListResolverEndpoints request and specify
	// the NextToken parameter, you must use the same values for Filters, if any,
	// as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of resolver endpoints that you want to return in the response
	// to a ListResolverEndpoints request. If you don't specify a value for MaxResults,
	// Resolver returns up to 100 resolver endpoints.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverEndpoints request, omit this value.
	//
	// If you have more than MaxResults resolver endpoints, you can submit another
	// ListResolverEndpoints request to get the next group of resolver endpoints.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResolverEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverEndpointsInput) SetFilters(v []*Filter) *ListResolverEndpointsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointsInput) SetMaxResults(v int64) *ListResolverEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointsInput) SetNextToken(v string) *ListResolverEndpointsInput {
	s.NextToken = &v
	return s
}

type ListResolverEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults IP addresses match the specified criteria, you can
	// submit another ListResolverEndpoint request to get the next group of results.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The resolver endpoints that were created by using the current AWS account,
	// and that match the specified filters, if any.
	ResolverEndpoints []*ResolverEndpoint `type:"list"`
}

// String returns the string representation
func (s ListResolverEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverEndpointsOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointsOutput) SetMaxResults(v int64) *ListResolverEndpointsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointsOutput) SetNextToken(v string) *ListResolverEndpointsOutput {
	s.NextToken = &v
	return s
}

// SetResolverEndpoints sets the ResolverEndpoints field's value.
func (s *ListResolverEndpointsOutput) SetResolverEndpoints(v []*ResolverEndpoint) *ListResolverEndpointsOutput {
	s.ResolverEndpoints = v
	return s
}

type ListResolverRuleAssociationsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of resolver rules, such as resolver
	// rules that are associated with the same VPC ID.
	//
	// If you submit a second or subsequent ListResolverRuleAssociations request
	// and specify the NextToken parameter, you must use the same values for Filters,
	// if any, as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of rule associations that you want to return in the response
	// to a ListResolverRuleAssociations request. If you don't specify a value for
	// MaxResults, Resolver returns up to 100 rule associations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverRuleAssociation request, omit this value.
	//
	// If you have more than MaxResults rule associations, you can submit another
	// ListResolverRuleAssociation request to get the next group of rule associations.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResolverRuleAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverRuleAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverRuleAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverRuleAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverRuleAssociationsInput) SetFilters(v []*Filter) *ListResolverRuleAssociationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRuleAssociationsInput) SetMaxResults(v int64) *ListResolverRuleAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRuleAssociationsInput) SetNextToken(v string) *ListResolverRuleAssociationsInput {
	s.NextToken = &v
	return s
}

type ListResolverRuleAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults rule associations match the specified criteria, you
	// can submit another ListResolverRuleAssociation request to get the next group
	// of results. In the next request, specify the value of NextToken from the
	// previous response.
	NextToken *string `type:"string"`

	// The associations that were created between resolver rules and VPCs using
	// the current AWS account, and that match the specified filters, if any.
	ResolverRuleAssociations []*ResolverRuleAssociation `type:"list"`
}

// String returns the string representation
func (s ListResolverRuleAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverRuleAssociationsOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRuleAssociationsOutput) SetMaxResults(v int64) *ListResolverRuleAssociationsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRuleAssociationsOutput) SetNextToken(v string) *ListResolverRuleAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetResolverRuleAssociations sets the ResolverRuleAssociations field's value.
func (s *ListResolverRuleAssociationsOutput) SetResolverRuleAssociations(v []*ResolverRuleAssociation) *ListResolverRuleAssociationsOutput {
	s.ResolverRuleAssociations = v
	return s
}

type ListResolverRulesInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of resolver rules, such as all
	// resolver rules that are associated with the same resolver endpoint.
	//
	// If you submit a second or subsequent ListResolverRules request and specify
	// the NextToken parameter, you must use the same values for Filters, if any,
	// as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of resolver rules that you want to return in the response
	// to a ListResolverRules request. If you don't specify a value for MaxResults,
	// Resolver returns up to 100 resolver rules.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverRules request, omit this value.
	//
	// If you have more than MaxResults resolver rules, you can submit another ListResolverRules
	// request to get the next group of resolver rules. In the next request, specify
	// the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResolverRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverRulesInput) SetFilters(v []*Filter) *ListResolverRulesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRulesInput) SetMaxResults(v int64) *ListResolverRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRulesInput) SetNextToken(v string) *ListResolverRulesInput {
	s.NextToken = &v
	return s
}

type ListResolverRulesOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults resolver rules match the specified criteria, you
	// can submit another ListResolverRules request to get the next group of results.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The resolver rules that were created using the current AWS account and that
	// match the specified filters, if any.
	ResolverRules []*ResolverRule `type:"list"`
}

// String returns the string representation
func (s ListResolverRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResolverRulesOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRulesOutput) SetMaxResults(v int64) *ListResolverRulesOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRulesOutput) SetNextToken(v string) *ListResolverRulesOutput {
	s.NextToken = &v
	return s
}

// SetResolverRules sets the ResolverRules field's value.
func (s *ListResolverRulesOutput) SetResolverRules(v []*ResolverRule) *ListResolverRulesOutput {
	s.ResolverRules = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tags that you want to return in the response to a ListTagsForResource
	// request. If you don't specify a value for MaxResults, Resolver returns up
	// to 100 tags.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListTagsForResource request, omit this value.
	//
	// If you have more than MaxResults tags, you can submit another ListTagsForResource
	// request to get the next group of tags for the resource. In the next request,
	// specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) for the resource that you want to list tags
	// for.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults tags match the specified criteria, you can submit
	// another ListTagsForResource request to get the next group of results. In
	// the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The tags that are associated with the resource that you specified in the
	// ListTagsForResource request.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PutResolverRulePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the account that you want to grant permissions
	// to.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// An AWS Identity and Access Management policy statement that lists the permissions
	// that you want to grant to another AWS account.
	//
	// ResolverRulePolicy is a required field
	ResolverRulePolicy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutResolverRulePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResolverRulePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResolverRulePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResolverRulePolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ResolverRulePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRulePolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *PutResolverRulePolicyInput) SetArn(v string) *PutResolverRulePolicyInput {
	s.Arn = &v
	return s
}

// SetResolverRulePolicy sets the ResolverRulePolicy field's value.
func (s *PutResolverRulePolicyInput) SetResolverRulePolicy(v string) *PutResolverRulePolicyInput {
	s.ResolverRulePolicy = &v
	return s
}

// The response to a PutResolverRulePolicy request.
type PutResolverRulePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Whether the PutResolverRulePolicy request was successful.
	ReturnValue *bool `type:"boolean"`
}

// String returns the string representation
func (s PutResolverRulePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResolverRulePolicyOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *PutResolverRulePolicyOutput) SetReturnValue(v bool) *PutResolverRulePolicyOutput {
	s.ReturnValue = &v
	return s
}

// In the response to a CreateResolverEndpoint, DeleteResolverEndpoint, GetResolverEndpoint,
// ListResolverEndpoints, or UpdateResolverEndpoint request, a complex type
// that contains settings for an existing inbound or outbound resolver endpoint.
type ResolverEndpoint struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the resolver endpoint.
	Arn *string `min:"1" type:"string"`

	// The date and time that the endpoint was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string that identifies the request that created the resolver endpoint.
	// The CreatorRequestId allows failed requests to be retried without the risk
	// of executing the operation twice.
	CreatorRequestId *string `min:"1" type:"string"`

	// Indicates whether the resolver endpoint allows inbound or outbound DNS queries:
	//
	//    * INBOUND: allows DNS queries to your VPC from your network or another
	//    VPC
	//
	//    * OUTBOUND: allows DNS queries from your VPC to your network or another
	//    VPC
	Direction *string `type:"string" enum:"ResolverEndpointDirection"`

	// The ID of the VPC that you want to create the resolver endpoint in.
	HostVPCId *string `min:"1" type:"string"`

	// The ID of the resolver endpoint.
	Id *string `min:"1" type:"string"`

	// The number of IP addresses that the resolver endpoint can use for DNS queries.
	IpAddressCount *int64 `type:"integer"`

	// The date and time that the endpoint was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// The name that you assigned to the resolver endpoint when you submitted a
	// CreateResolverEndpoint request.
	Name *string `type:"string"`

	// The ID of one or more security groups that control access to this VPC. The
	// security group must include one or more inbound resolver rules.
	SecurityGroupIds []*string `type:"list"`

	// A code that specifies the current status of the resolver endpoint.
	Status *string `type:"string" enum:"ResolverEndpointStatus"`

	// A detailed description of the status of the resolver endpoint.
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s ResolverEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverEndpoint) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResolverEndpoint) SetArn(v string) *ResolverEndpoint {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResolverEndpoint) SetCreationTime(v string) *ResolverEndpoint {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *ResolverEndpoint) SetCreatorRequestId(v string) *ResolverEndpoint {
	s.CreatorRequestId = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *ResolverEndpoint) SetDirection(v string) *ResolverEndpoint {
	s.Direction = &v
	return s
}

// SetHostVPCId sets the HostVPCId field's value.
func (s *ResolverEndpoint) SetHostVPCId(v string) *ResolverEndpoint {
	s.HostVPCId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverEndpoint) SetId(v string) *ResolverEndpoint {
	s.Id = &v
	return s
}

// SetIpAddressCount sets the IpAddressCount field's value.
func (s *ResolverEndpoint) SetIpAddressCount(v int64) *ResolverEndpoint {
	s.IpAddressCount = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *ResolverEndpoint) SetModificationTime(v string) *ResolverEndpoint {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverEndpoint) SetName(v string) *ResolverEndpoint {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *ResolverEndpoint) SetSecurityGroupIds(v []*string) *ResolverEndpoint {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverEndpoint) SetStatus(v string) *ResolverEndpoint {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResolverEndpoint) SetStatusMessage(v string) *ResolverEndpoint {
	s.StatusMessage = &v
	return s
}

// For queries that originate in your VPC, detailed information about a resolver
// rule, which specifies how to route DNS queries out of the VPC. The ResolverRule
// parameter appears in the response to a CreateResolverRule, DeleteResolverRule,
// GetResolverRule, ListResolverRules, or UpdateResolverRule request.
type ResolverRule struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the resolver rule specified by Id.
	Arn *string `min:"1" type:"string"`

	// A unique string that you specified when you created the resolver rule. CreatorRequestIdidentifies
	// the request and allows failed requests to be retried without the risk of
	// executing the operation twice.
	CreatorRequestId *string `min:"1" type:"string"`

	// DNS queries for this domain name are forwarded to the IP addresses that are
	// specified in TargetIps. If a query matches multiple resolver rules (example.com
	// and www.example.com), the query is routed using the resolver rule that contains
	// the most specific domain name (www.example.com).
	DomainName *string `min:"1" type:"string"`

	// The ID that Resolver assigned to the resolver rule when you created it.
	Id *string `min:"1" type:"string"`

	// The name for the resolver rule, which you specified when you created the
	// resolver rule.
	Name *string `type:"string"`

	// When a rule is shared with another AWS account, the account ID of the account
	// that the rule is shared with.
	OwnerId *string `min:"12" type:"string"`

	// The ID of the endpoint that the rule is associated with.
	ResolverEndpointId *string `min:"1" type:"string"`

	// This value is always FORWARD. Other resolver rule types aren't supported.
	RuleType *string `type:"string" enum:"RuleTypeOption"`

	// Whether the rules is shared and, if so, whether the current account is sharing
	// the rule with another account, or another account is sharing the rule with
	// the current account.
	ShareStatus *string `type:"string" enum:"ShareStatus"`

	// A code that specifies the current status of the resolver rule.
	Status *string `type:"string" enum:"ResolverRuleStatus"`

	// A detailed description of the status of a resolver rule.
	StatusMessage *string `type:"string"`

	// An array that contains the IP addresses and ports that you want to forward
	TargetIps []*TargetAddress `min:"1" type:"list"`
}

// String returns the string representation
func (s ResolverRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverRule) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResolverRule) SetArn(v string) *ResolverRule {
	s.Arn = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *ResolverRule) SetCreatorRequestId(v string) *ResolverRule {
	s.CreatorRequestId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ResolverRule) SetDomainName(v string) *ResolverRule {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverRule) SetId(v string) *ResolverRule {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverRule) SetName(v string) *ResolverRule {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ResolverRule) SetOwnerId(v string) *ResolverRule {
	s.OwnerId = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *ResolverRule) SetResolverEndpointId(v string) *ResolverRule {
	s.ResolverEndpointId = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *ResolverRule) SetRuleType(v string) *ResolverRule {
	s.RuleType = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *ResolverRule) SetShareStatus(v string) *ResolverRule {
	s.ShareStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverRule) SetStatus(v string) *ResolverRule {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResolverRule) SetStatusMessage(v string) *ResolverRule {
	s.StatusMessage = &v
	return s
}

// SetTargetIps sets the TargetIps field's value.
func (s *ResolverRule) SetTargetIps(v []*TargetAddress) *ResolverRule {
	s.TargetIps = v
	return s
}

// In the response to an AssociateResolverRule, DisassociateResolverRule, or
// ListResolverRuleAssociations request, information about an association between
// a resolver rule and a VPC.
type ResolverRuleAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the association between a resolver rule and a VPC. Resolver assigns
	// this value when you submit an AssociateResolverRule request.
	Id *string `min:"1" type:"string"`

	// The name of an association between a resolver rule and a VPC.
	Name *string `type:"string"`

	// The ID of the resolver rule that you associated with the VPC that is specified
	// by VPCId.
	ResolverRuleId *string `min:"1" type:"string"`

	// A code that specifies the current status of the association between a resolver
	// rule and a VPC.
	Status *string `type:"string" enum:"ResolverRuleAssociationStatus"`

	// A detailed description of the status of the association between a resolver
	// rule and a VPC.
	StatusMessage *string `type:"string"`

	// The ID of the VPC that you associated the resolver rule with.
	VPCId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResolverRuleAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverRuleAssociation) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ResolverRuleAssociation) SetId(v string) *ResolverRuleAssociation {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverRuleAssociation) SetName(v string) *ResolverRuleAssociation {
	s.Name = &v
	return s
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *ResolverRuleAssociation) SetResolverRuleId(v string) *ResolverRuleAssociation {
	s.ResolverRuleId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverRuleAssociation) SetStatus(v string) *ResolverRuleAssociation {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResolverRuleAssociation) SetStatusMessage(v string) *ResolverRuleAssociation {
	s.StatusMessage = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *ResolverRuleAssociation) SetVPCId(v string) *ResolverRuleAssociation {
	s.VPCId = &v
	return s
}

// In an UpdateResolverRule request, information about the changes that you
// want to make.
type ResolverRuleConfig struct {
	_ struct{} `type:"structure"`

	// The new name for the resolver rule. The name that you specify appears in
	// the Resolver dashboard in the Route 53 console.
	Name *string `type:"string"`

	// The ID of the new outbound resolver endpoint that you want to use to route
	// DNS queries to the IP addresses that you specify in TargetIps.
	ResolverEndpointId *string `min:"1" type:"string"`

	// For DNS queries that originate in your VPC, the new IP addresses that you
	// want to route outbound DNS queries to.
	TargetIps []*TargetAddress `min:"1" type:"list"`
}

// String returns the string representation
func (s ResolverRuleConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolverRuleConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolverRuleConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolverRuleConfig"}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.TargetIps != nil && len(s.TargetIps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetIps", 1))
	}
	if s.TargetIps != nil {
		for i, v := range s.TargetIps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetIps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ResolverRuleConfig) SetName(v string) *ResolverRuleConfig {
	s.Name = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *ResolverRuleConfig) SetResolverEndpointId(v string) *ResolverRuleConfig {
	s.ResolverEndpointId = &v
	return s
}

// SetTargetIps sets the TargetIps field's value.
func (s *ResolverRuleConfig) SetTargetIps(v []*TargetAddress) *ResolverRuleConfig {
	s.TargetIps = v
	return s
}

// One tag that you want to add to the specified resource. A tag consists of
// a Key (a name for the tag) and a Value.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name for the tag. For example, if you want to associate Resolver resources
	// with the account IDs of your customers for billing purposes, the value of
	// Key might be account-id.
	Key *string `type:"string"`

	// The value for the tag. For example, if Key is account-id, then Value might
	// be the ID of the customer account that you're creating the resource for.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource that you want to add tags
	// to. To get the ARN for a resource, use the applicable Get or List command:
	//
	//    * GetResolverEndpoint
	//
	//    * GetResolverRule
	//
	//    * GetResolverRuleAssociation
	//
	//    * ListResolverEndpoints
	//
	//    * ListResolverRuleAssociations
	//
	//    * ListResolverRules
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags that you want to add to the specified resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// In a CreateResolverRule request, an array of the IPs that you want to forward
// DNS queries to.
type TargetAddress struct {
	_ struct{} `type:"structure"`

	// One IP address that you want to forward DNS queries to. You can specify only
	// IPv4 addresses.
	//
	// Ip is a required field
	Ip *string `min:"7" type:"string" required:"true"`

	// The port at Ip that you want to forward DNS queries to.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s TargetAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetAddress) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetAddress) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetAddress"}
	if s.Ip == nil {
		invalidParams.Add(request.NewErrParamRequired("Ip"))
	}
	if s.Ip != nil && len(*s.Ip) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *TargetAddress) SetIp(v string) *TargetAddress {
	s.Ip = &v
	return s
}

// SetPort sets the Port field's value.
func (s *TargetAddress) SetPort(v int64) *TargetAddress {
	s.Port = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource that you want to remove tags
	// from. To get the ARN for a resource, use the applicable Get or List command:
	//
	//    * GetResolverEndpoint
	//
	//    * GetResolverRule
	//
	//    * GetResolverRuleAssociation
	//
	//    * ListResolverEndpoints
	//
	//    * ListResolverRuleAssociations
	//
	//    * ListResolverRules
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags that you want to remove to the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the resolver endpoint that you want to update.
	Name *string `type:"string"`

	// The ID of the resolver endpoint that you want to update.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResolverEndpointInput"}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateResolverEndpointInput) SetName(v string) *UpdateResolverEndpointInput {
	s.Name = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *UpdateResolverEndpointInput) SetResolverEndpointId(v string) *UpdateResolverEndpointInput {
	s.ResolverEndpointId = &v
	return s
}

type UpdateResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The response to an UpdateResolverEndpoint request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation
func (s UpdateResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *UpdateResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *UpdateResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type UpdateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The new settings for the resolver rule.
	//
	// Config is a required field
	Config *ResolverRuleConfig `type:"structure" required:"true"`

	// The ID of the resolver rule that you want to update.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResolverRuleInput"}
	if s.Config == nil {
		invalidParams.Add(request.NewErrParamRequired("Config"))
	}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}
	if s.Config != nil {
		if err := s.Config.Validate(); err != nil {
			invalidParams.AddNested("Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfig sets the Config field's value.
func (s *UpdateResolverRuleInput) SetConfig(v *ResolverRuleConfig) *UpdateResolverRuleInput {
	s.Config = v
	return s
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *UpdateResolverRuleInput) SetResolverRuleId(v string) *UpdateResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

type UpdateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// The response to an UpdateResolverRule request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation
func (s UpdateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *UpdateResolverRuleOutput) SetResolverRule(v *ResolverRule) *UpdateResolverRuleOutput {
	s.ResolverRule = v
	return s
}

const (
	// IpAddressStatusCreating is a IpAddressStatus enum value
	IpAddressStatusCreating = "CREATING"

	// IpAddressStatusFailedCreation is a IpAddressStatus enum value
	IpAddressStatusFailedCreation = "FAILED_CREATION"

	// IpAddressStatusAttaching is a IpAddressStatus enum value
	IpAddressStatusAttaching = "ATTACHING"

	// IpAddressStatusAttached is a IpAddressStatus enum value
	IpAddressStatusAttached = "ATTACHED"

	// IpAddressStatusRemapDetaching is a IpAddressStatus enum value
	IpAddressStatusRemapDetaching = "REMAP_DETACHING"

	// IpAddressStatusRemapAttaching is a IpAddressStatus enum value
	IpAddressStatusRemapAttaching = "REMAP_ATTACHING"

	// IpAddressStatusDetaching is a IpAddressStatus enum value
	IpAddressStatusDetaching = "DETACHING"

	// IpAddressStatusFailedResourceGone is a IpAddressStatus enum value
	IpAddressStatusFailedResourceGone = "FAILED_RESOURCE_GONE"

	// IpAddressStatusDeleting is a IpAddressStatus enum value
	IpAddressStatusDeleting = "DELETING"

	// IpAddressStatusDeleteFailedFasExpired is a IpAddressStatus enum value
	IpAddressStatusDeleteFailedFasExpired = "DELETE_FAILED_FAS_EXPIRED"
)

const (
	// ResolverEndpointDirectionInbound is a ResolverEndpointDirection enum value
	ResolverEndpointDirectionInbound = "INBOUND"

	// ResolverEndpointDirectionOutbound is a ResolverEndpointDirection enum value
	ResolverEndpointDirectionOutbound = "OUTBOUND"
)

const (
	// ResolverEndpointStatusCreating is a ResolverEndpointStatus enum value
	ResolverEndpointStatusCreating = "CREATING"

	// ResolverEndpointStatusOperational is a ResolverEndpointStatus enum value
	ResolverEndpointStatusOperational = "OPERATIONAL"

	// ResolverEndpointStatusUpdating is a ResolverEndpointStatus enum value
	ResolverEndpointStatusUpdating = "UPDATING"

	// ResolverEndpointStatusAutoRecovering is a ResolverEndpointStatus enum value
	ResolverEndpointStatusAutoRecovering = "AUTO_RECOVERING"

	// ResolverEndpointStatusActionNeeded is a ResolverEndpointStatus enum value
	ResolverEndpointStatusActionNeeded = "ACTION_NEEDED"

	// ResolverEndpointStatusDeleting is a ResolverEndpointStatus enum value
	ResolverEndpointStatusDeleting = "DELETING"
)

const (
	// ResolverRuleAssociationStatusCreating is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusCreating = "CREATING"

	// ResolverRuleAssociationStatusComplete is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusComplete = "COMPLETE"

	// ResolverRuleAssociationStatusDeleting is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusDeleting = "DELETING"

	// ResolverRuleAssociationStatusFailed is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusFailed = "FAILED"

	// ResolverRuleAssociationStatusOverridden is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusOverridden = "OVERRIDDEN"
)

const (
	// ResolverRuleStatusComplete is a ResolverRuleStatus enum value
	ResolverRuleStatusComplete = "COMPLETE"

	// ResolverRuleStatusDeleting is a ResolverRuleStatus enum value
	ResolverRuleStatusDeleting = "DELETING"

	// ResolverRuleStatusUpdating is a ResolverRuleStatus enum value
	ResolverRuleStatusUpdating = "UPDATING"

	// ResolverRuleStatusFailed is a ResolverRuleStatus enum value
	ResolverRuleStatusFailed = "FAILED"
)

const (
	// RuleTypeOptionForward is a RuleTypeOption enum value
	RuleTypeOptionForward = "FORWARD"

	// RuleTypeOptionSystem is a RuleTypeOption enum value
	RuleTypeOptionSystem = "SYSTEM"

	// RuleTypeOptionRecursive is a RuleTypeOption enum value
	RuleTypeOptionRecursive = "RECURSIVE"
)

const (
	// ShareStatusNotShared is a ShareStatus enum value
	ShareStatusNotShared = "NOT_SHARED"

	// ShareStatusSharedWithMe is a ShareStatus enum value
	ShareStatusSharedWithMe = "SHARED_WITH_ME"

	// ShareStatusSharedByMe is a ShareStatus enum value
	ShareStatusSharedByMe = "SHARED_BY_ME"
)
