package cdn

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/cdn/mgmt/2019-06-15-preview/cdn"

// Action enumerates the values for action.
type Action string

const (
	// Allow ...
	Allow Action = "Allow"
	// Block ...
	Block Action = "Block"
	// Log ...
	Log Action = "Log"
	// Redirect ...
	Redirect Action = "Redirect"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{Allow, Block, Log, Redirect}
}

// CacheBehavior enumerates the values for cache behavior.
type CacheBehavior string

const (
	// BypassCache ...
	BypassCache CacheBehavior = "BypassCache"
	// Override ...
	Override CacheBehavior = "Override"
	// SetIfMissing ...
	SetIfMissing CacheBehavior = "SetIfMissing"
)

// PossibleCacheBehaviorValues returns an array of possible values for the CacheBehavior const type.
func PossibleCacheBehaviorValues() []CacheBehavior {
	return []CacheBehavior{BypassCache, Override, SetIfMissing}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceAzureKeyVault ...
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	// CertificateSourceCdn ...
	CertificateSourceCdn CertificateSource = "Cdn"
	// CertificateSourceCustomDomainHTTPSParameters ...
	CertificateSourceCustomDomainHTTPSParameters CertificateSource = "CustomDomainHttpsParameters"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceAzureKeyVault, CertificateSourceCdn, CertificateSourceCustomDomainHTTPSParameters}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// Dedicated ...
	Dedicated CertificateType = "Dedicated"
	// Shared ...
	Shared CertificateType = "Shared"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{Dedicated, Shared}
}

// CustomDomainResourceState enumerates the values for custom domain resource state.
type CustomDomainResourceState string

const (
	// Active ...
	Active CustomDomainResourceState = "Active"
	// Creating ...
	Creating CustomDomainResourceState = "Creating"
	// Deleting ...
	Deleting CustomDomainResourceState = "Deleting"
)

// PossibleCustomDomainResourceStateValues returns an array of possible values for the CustomDomainResourceState const type.
func PossibleCustomDomainResourceStateValues() []CustomDomainResourceState {
	return []CustomDomainResourceState{Active, Creating, Deleting}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// Disabled ...
	Disabled CustomHTTPSProvisioningState = "Disabled"
	// Disabling ...
	Disabling CustomHTTPSProvisioningState = "Disabling"
	// Enabled ...
	Enabled CustomHTTPSProvisioningState = "Enabled"
	// Enabling ...
	Enabling CustomHTTPSProvisioningState = "Enabling"
	// Failed ...
	Failed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{Disabled, Disabling, Enabled, Enabling, Failed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CertificateDeleted ...
	CertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CertificateDeployed ...
	CertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// DeletingCertificate ...
	DeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// DeployingCertificate ...
	DeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// DomainControlValidationRequestApproved ...
	DomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// DomainControlValidationRequestRejected ...
	DomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// DomainControlValidationRequestTimedOut ...
	DomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// IssuingCertificate ...
	IssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// PendingDomainControlValidationREquestApproval ...
	PendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// SubmittingDomainControlValidationRequest ...
	SubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CertificateDeleted, CertificateDeployed, DeletingCertificate, DeployingCertificate, DomainControlValidationRequestApproved, DomainControlValidationRequestRejected, DomainControlValidationRequestTimedOut, IssuingCertificate, PendingDomainControlValidationREquestApproval, SubmittingDomainControlValidationRequest}
}

// CustomRuleEnabledState enumerates the values for custom rule enabled state.
type CustomRuleEnabledState string

const (
	// CustomRuleEnabledStateDisabled ...
	CustomRuleEnabledStateDisabled CustomRuleEnabledState = "Disabled"
	// CustomRuleEnabledStateEnabled ...
	CustomRuleEnabledStateEnabled CustomRuleEnabledState = "Enabled"
)

// PossibleCustomRuleEnabledStateValues returns an array of possible values for the CustomRuleEnabledState const type.
func PossibleCustomRuleEnabledStateValues() []CustomRuleEnabledState {
	return []CustomRuleEnabledState{CustomRuleEnabledStateDisabled, CustomRuleEnabledStateEnabled}
}

// DestinationProtocol enumerates the values for destination protocol.
type DestinationProtocol string

const (
	// HTTP ...
	HTTP DestinationProtocol = "Http"
	// HTTPS ...
	HTTPS DestinationProtocol = "Https"
	// MatchRequest ...
	MatchRequest DestinationProtocol = "MatchRequest"
)

// PossibleDestinationProtocolValues returns an array of possible values for the DestinationProtocol const type.
func PossibleDestinationProtocolValues() []DestinationProtocol {
	return []DestinationProtocol{HTTP, HTTPS, MatchRequest}
}

// EndpointResourceState enumerates the values for endpoint resource state.
type EndpointResourceState string

const (
	// EndpointResourceStateCreating ...
	EndpointResourceStateCreating EndpointResourceState = "Creating"
	// EndpointResourceStateDeleting ...
	EndpointResourceStateDeleting EndpointResourceState = "Deleting"
	// EndpointResourceStateRunning ...
	EndpointResourceStateRunning EndpointResourceState = "Running"
	// EndpointResourceStateStarting ...
	EndpointResourceStateStarting EndpointResourceState = "Starting"
	// EndpointResourceStateStopped ...
	EndpointResourceStateStopped EndpointResourceState = "Stopped"
	// EndpointResourceStateStopping ...
	EndpointResourceStateStopping EndpointResourceState = "Stopping"
)

// PossibleEndpointResourceStateValues returns an array of possible values for the EndpointResourceState const type.
func PossibleEndpointResourceStateValues() []EndpointResourceState {
	return []EndpointResourceState{EndpointResourceStateCreating, EndpointResourceStateDeleting, EndpointResourceStateRunning, EndpointResourceStateStarting, EndpointResourceStateStopped, EndpointResourceStateStopping}
}

// GeoFilterActions enumerates the values for geo filter actions.
type GeoFilterActions string

const (
	// GeoFilterActionsAllow ...
	GeoFilterActionsAllow GeoFilterActions = "Allow"
	// GeoFilterActionsBlock ...
	GeoFilterActionsBlock GeoFilterActions = "Block"
)

// PossibleGeoFilterActionsValues returns an array of possible values for the GeoFilterActions const type.
func PossibleGeoFilterActionsValues() []GeoFilterActions {
	return []GeoFilterActions{GeoFilterActionsAllow, GeoFilterActionsBlock}
}

// HeaderAction enumerates the values for header action.
type HeaderAction string

const (
	// Append ...
	Append HeaderAction = "Append"
	// Delete ...
	Delete HeaderAction = "Delete"
	// Overwrite ...
	Overwrite HeaderAction = "Overwrite"
)

// PossibleHeaderActionValues returns an array of possible values for the HeaderAction const type.
func PossibleHeaderActionValues() []HeaderAction {
	return []HeaderAction{Append, Delete, Overwrite}
}

// ManagedRuleEnabledState enumerates the values for managed rule enabled state.
type ManagedRuleEnabledState string

const (
	// ManagedRuleEnabledStateDisabled ...
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
	// ManagedRuleEnabledStateEnabled ...
	ManagedRuleEnabledStateEnabled ManagedRuleEnabledState = "Enabled"
)

// PossibleManagedRuleEnabledStateValues returns an array of possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{ManagedRuleEnabledStateDisabled, ManagedRuleEnabledStateEnabled}
}

// MatchVariable enumerates the values for match variable.
type MatchVariable string

const (
	// Cookies ...
	Cookies MatchVariable = "Cookies"
	// Country ...
	Country MatchVariable = "Country"
	// PostArgs ...
	PostArgs MatchVariable = "PostArgs"
	// QueryString ...
	QueryString MatchVariable = "QueryString"
	// RemoteAddr ...
	RemoteAddr MatchVariable = "RemoteAddr"
	// RequestBody ...
	RequestBody MatchVariable = "RequestBody"
	// RequestHeader ...
	RequestHeader MatchVariable = "RequestHeader"
	// RequestMethod ...
	RequestMethod MatchVariable = "RequestMethod"
	// RequestURI ...
	RequestURI MatchVariable = "RequestUri"
)

// PossibleMatchVariableValues returns an array of possible values for the MatchVariable const type.
func PossibleMatchVariableValues() []MatchVariable {
	return []MatchVariable{Cookies, Country, PostArgs, QueryString, RemoteAddr, RequestBody, RequestHeader, RequestMethod, RequestURI}
}

// Name enumerates the values for name.
type Name string

const (
	// NameDeliveryRuleCondition ...
	NameDeliveryRuleCondition Name = "DeliveryRuleCondition"
	// NameIsDevice ...
	NameIsDevice Name = "IsDevice"
	// NamePostArgs ...
	NamePostArgs Name = "PostArgs"
	// NameQueryString ...
	NameQueryString Name = "QueryString"
	// NameRemoteAddress ...
	NameRemoteAddress Name = "RemoteAddress"
	// NameRequestBody ...
	NameRequestBody Name = "RequestBody"
	// NameRequestHeader ...
	NameRequestHeader Name = "RequestHeader"
	// NameRequestMethod ...
	NameRequestMethod Name = "RequestMethod"
	// NameRequestScheme ...
	NameRequestScheme Name = "RequestScheme"
	// NameRequestURI ...
	NameRequestURI Name = "RequestUri"
	// NameURLFileExtension ...
	NameURLFileExtension Name = "UrlFileExtension"
	// NameURLFileName ...
	NameURLFileName Name = "UrlFileName"
	// NameURLPath ...
	NameURLPath Name = "UrlPath"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{NameDeliveryRuleCondition, NameIsDevice, NamePostArgs, NameQueryString, NameRemoteAddress, NameRequestBody, NameRequestHeader, NameRequestMethod, NameRequestScheme, NameRequestURI, NameURLFileExtension, NameURLFileName, NameURLPath}
}

// NameBasicDeliveryRuleAction enumerates the values for name basic delivery rule action.
type NameBasicDeliveryRuleAction string

const (
	// NameCacheExpiration ...
	NameCacheExpiration NameBasicDeliveryRuleAction = "CacheExpiration"
	// NameDeliveryRuleAction ...
	NameDeliveryRuleAction NameBasicDeliveryRuleAction = "DeliveryRuleAction"
	// NameModifyRequestHeader ...
	NameModifyRequestHeader NameBasicDeliveryRuleAction = "ModifyRequestHeader"
	// NameModifyResponseHeader ...
	NameModifyResponseHeader NameBasicDeliveryRuleAction = "ModifyResponseHeader"
	// NameURLRedirect ...
	NameURLRedirect NameBasicDeliveryRuleAction = "UrlRedirect"
)

// PossibleNameBasicDeliveryRuleActionValues returns an array of possible values for the NameBasicDeliveryRuleAction const type.
func PossibleNameBasicDeliveryRuleActionValues() []NameBasicDeliveryRuleAction {
	return []NameBasicDeliveryRuleAction{NameCacheExpiration, NameDeliveryRuleAction, NameModifyRequestHeader, NameModifyResponseHeader, NameURLRedirect}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// Any ...
	Any Operator = "Any"
	// BeginsWith ...
	BeginsWith Operator = "BeginsWith"
	// Contains ...
	Contains Operator = "Contains"
	// EndsWith ...
	EndsWith Operator = "EndsWith"
	// Equal ...
	Equal Operator = "Equal"
	// GeoMatch ...
	GeoMatch Operator = "GeoMatch"
	// GreaterThan ...
	GreaterThan Operator = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// IPMatch ...
	IPMatch Operator = "IPMatch"
	// LessThan ...
	LessThan Operator = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual Operator = "LessThanOrEqual"
	// RegEx ...
	RegEx Operator = "RegEx"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{Any, BeginsWith, Contains, EndsWith, Equal, GeoMatch, GreaterThan, GreaterThanOrEqual, IPMatch, LessThan, LessThanOrEqual, RegEx}
}

// OptimizationType enumerates the values for optimization type.
type OptimizationType string

const (
	// DynamicSiteAcceleration ...
	DynamicSiteAcceleration OptimizationType = "DynamicSiteAcceleration"
	// GeneralMediaStreaming ...
	GeneralMediaStreaming OptimizationType = "GeneralMediaStreaming"
	// GeneralWebDelivery ...
	GeneralWebDelivery OptimizationType = "GeneralWebDelivery"
	// LargeFileDownload ...
	LargeFileDownload OptimizationType = "LargeFileDownload"
	// VideoOnDemandMediaStreaming ...
	VideoOnDemandMediaStreaming OptimizationType = "VideoOnDemandMediaStreaming"
)

// PossibleOptimizationTypeValues returns an array of possible values for the OptimizationType const type.
func PossibleOptimizationTypeValues() []OptimizationType {
	return []OptimizationType{DynamicSiteAcceleration, GeneralMediaStreaming, GeneralWebDelivery, LargeFileDownload, VideoOnDemandMediaStreaming}
}

// OriginResourceState enumerates the values for origin resource state.
type OriginResourceState string

const (
	// OriginResourceStateActive ...
	OriginResourceStateActive OriginResourceState = "Active"
	// OriginResourceStateCreating ...
	OriginResourceStateCreating OriginResourceState = "Creating"
	// OriginResourceStateDeleting ...
	OriginResourceStateDeleting OriginResourceState = "Deleting"
)

// PossibleOriginResourceStateValues returns an array of possible values for the OriginResourceState const type.
func PossibleOriginResourceStateValues() []OriginResourceState {
	return []OriginResourceState{OriginResourceStateActive, OriginResourceStateCreating, OriginResourceStateDeleting}
}

// PolicyEnabledState enumerates the values for policy enabled state.
type PolicyEnabledState string

const (
	// PolicyEnabledStateDisabled ...
	PolicyEnabledStateDisabled PolicyEnabledState = "Disabled"
	// PolicyEnabledStateEnabled ...
	PolicyEnabledStateEnabled PolicyEnabledState = "Enabled"
)

// PossiblePolicyEnabledStateValues returns an array of possible values for the PolicyEnabledState const type.
func PossiblePolicyEnabledStateValues() []PolicyEnabledState {
	return []PolicyEnabledState{PolicyEnabledStateDisabled, PolicyEnabledStateEnabled}
}

// PolicyMode enumerates the values for policy mode.
type PolicyMode string

const (
	// Detection ...
	Detection PolicyMode = "Detection"
	// Prevention ...
	Prevention PolicyMode = "Prevention"
)

// PossiblePolicyModeValues returns an array of possible values for the PolicyMode const type.
func PossiblePolicyModeValues() []PolicyMode {
	return []PolicyMode{Detection, Prevention}
}

// PolicyResourceState enumerates the values for policy resource state.
type PolicyResourceState string

const (
	// PolicyResourceStateCreating ...
	PolicyResourceStateCreating PolicyResourceState = "Creating"
	// PolicyResourceStateDeleting ...
	PolicyResourceStateDeleting PolicyResourceState = "Deleting"
	// PolicyResourceStateDisabled ...
	PolicyResourceStateDisabled PolicyResourceState = "Disabled"
	// PolicyResourceStateDisabling ...
	PolicyResourceStateDisabling PolicyResourceState = "Disabling"
	// PolicyResourceStateEnabled ...
	PolicyResourceStateEnabled PolicyResourceState = "Enabled"
	// PolicyResourceStateEnabling ...
	PolicyResourceStateEnabling PolicyResourceState = "Enabling"
)

// PossiblePolicyResourceStateValues returns an array of possible values for the PolicyResourceState const type.
func PossiblePolicyResourceStateValues() []PolicyResourceState {
	return []PolicyResourceState{PolicyResourceStateCreating, PolicyResourceStateDeleting, PolicyResourceStateDisabled, PolicyResourceStateDisabling, PolicyResourceStateEnabled, PolicyResourceStateEnabling}
}

// PostArgsOperator enumerates the values for post args operator.
type PostArgsOperator string

const (
	// PostArgsOperatorAny ...
	PostArgsOperatorAny PostArgsOperator = "Any"
	// PostArgsOperatorBeginsWith ...
	PostArgsOperatorBeginsWith PostArgsOperator = "BeginsWith"
	// PostArgsOperatorContains ...
	PostArgsOperatorContains PostArgsOperator = "Contains"
	// PostArgsOperatorEndsWith ...
	PostArgsOperatorEndsWith PostArgsOperator = "EndsWith"
	// PostArgsOperatorEqual ...
	PostArgsOperatorEqual PostArgsOperator = "Equal"
	// PostArgsOperatorGreaterThan ...
	PostArgsOperatorGreaterThan PostArgsOperator = "GreaterThan"
	// PostArgsOperatorGreaterThanOrEqual ...
	PostArgsOperatorGreaterThanOrEqual PostArgsOperator = "GreaterThanOrEqual"
	// PostArgsOperatorLessThan ...
	PostArgsOperatorLessThan PostArgsOperator = "LessThan"
	// PostArgsOperatorLessThanOrEqual ...
	PostArgsOperatorLessThanOrEqual PostArgsOperator = "LessThanOrEqual"
)

// PossiblePostArgsOperatorValues returns an array of possible values for the PostArgsOperator const type.
func PossiblePostArgsOperatorValues() []PostArgsOperator {
	return []PostArgsOperator{PostArgsOperatorAny, PostArgsOperatorBeginsWith, PostArgsOperatorContains, PostArgsOperatorEndsWith, PostArgsOperatorEqual, PostArgsOperatorGreaterThan, PostArgsOperatorGreaterThanOrEqual, PostArgsOperatorLessThan, PostArgsOperatorLessThanOrEqual}
}

// ProfileResourceState enumerates the values for profile resource state.
type ProfileResourceState string

const (
	// ProfileResourceStateActive ...
	ProfileResourceStateActive ProfileResourceState = "Active"
	// ProfileResourceStateCreating ...
	ProfileResourceStateCreating ProfileResourceState = "Creating"
	// ProfileResourceStateDeleting ...
	ProfileResourceStateDeleting ProfileResourceState = "Deleting"
	// ProfileResourceStateDisabled ...
	ProfileResourceStateDisabled ProfileResourceState = "Disabled"
)

// PossibleProfileResourceStateValues returns an array of possible values for the ProfileResourceState const type.
func PossibleProfileResourceStateValues() []ProfileResourceState {
	return []ProfileResourceState{ProfileResourceStateActive, ProfileResourceStateCreating, ProfileResourceStateDeleting, ProfileResourceStateDisabled}
}

// ProtocolType enumerates the values for protocol type.
type ProtocolType string

const (
	// IPBased ...
	IPBased ProtocolType = "IPBased"
	// ServerNameIndication ...
	ServerNameIndication ProtocolType = "ServerNameIndication"
)

// PossibleProtocolTypeValues returns an array of possible values for the ProtocolType const type.
func PossibleProtocolTypeValues() []ProtocolType {
	return []ProtocolType{IPBased, ServerNameIndication}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateFailed, ProvisioningStateSucceeded}
}

// QueryStringCachingBehavior enumerates the values for query string caching behavior.
type QueryStringCachingBehavior string

const (
	// BypassCaching ...
	BypassCaching QueryStringCachingBehavior = "BypassCaching"
	// IgnoreQueryString ...
	IgnoreQueryString QueryStringCachingBehavior = "IgnoreQueryString"
	// NotSet ...
	NotSet QueryStringCachingBehavior = "NotSet"
	// UseQueryString ...
	UseQueryString QueryStringCachingBehavior = "UseQueryString"
)

// PossibleQueryStringCachingBehaviorValues returns an array of possible values for the QueryStringCachingBehavior const type.
func PossibleQueryStringCachingBehaviorValues() []QueryStringCachingBehavior {
	return []QueryStringCachingBehavior{BypassCaching, IgnoreQueryString, NotSet, UseQueryString}
}

// QueryStringOperator enumerates the values for query string operator.
type QueryStringOperator string

const (
	// QueryStringOperatorAny ...
	QueryStringOperatorAny QueryStringOperator = "Any"
	// QueryStringOperatorBeginsWith ...
	QueryStringOperatorBeginsWith QueryStringOperator = "BeginsWith"
	// QueryStringOperatorContains ...
	QueryStringOperatorContains QueryStringOperator = "Contains"
	// QueryStringOperatorEndsWith ...
	QueryStringOperatorEndsWith QueryStringOperator = "EndsWith"
	// QueryStringOperatorEqual ...
	QueryStringOperatorEqual QueryStringOperator = "Equal"
	// QueryStringOperatorGreaterThan ...
	QueryStringOperatorGreaterThan QueryStringOperator = "GreaterThan"
	// QueryStringOperatorGreaterThanOrEqual ...
	QueryStringOperatorGreaterThanOrEqual QueryStringOperator = "GreaterThanOrEqual"
	// QueryStringOperatorLessThan ...
	QueryStringOperatorLessThan QueryStringOperator = "LessThan"
	// QueryStringOperatorLessThanOrEqual ...
	QueryStringOperatorLessThanOrEqual QueryStringOperator = "LessThanOrEqual"
)

// PossibleQueryStringOperatorValues returns an array of possible values for the QueryStringOperator const type.
func PossibleQueryStringOperatorValues() []QueryStringOperator {
	return []QueryStringOperator{QueryStringOperatorAny, QueryStringOperatorBeginsWith, QueryStringOperatorContains, QueryStringOperatorEndsWith, QueryStringOperatorEqual, QueryStringOperatorGreaterThan, QueryStringOperatorGreaterThanOrEqual, QueryStringOperatorLessThan, QueryStringOperatorLessThanOrEqual}
}

// RedirectType enumerates the values for redirect type.
type RedirectType string

const (
	// Found ...
	Found RedirectType = "Found"
	// Moved ...
	Moved RedirectType = "Moved"
	// PermanentRedirect ...
	PermanentRedirect RedirectType = "PermanentRedirect"
	// TemporaryRedirect ...
	TemporaryRedirect RedirectType = "TemporaryRedirect"
)

// PossibleRedirectTypeValues returns an array of possible values for the RedirectType const type.
func PossibleRedirectTypeValues() []RedirectType {
	return []RedirectType{Found, Moved, PermanentRedirect, TemporaryRedirect}
}

// RemoteAddressOperator enumerates the values for remote address operator.
type RemoteAddressOperator string

const (
	// RemoteAddressOperatorAny ...
	RemoteAddressOperatorAny RemoteAddressOperator = "Any"
	// RemoteAddressOperatorGeoMatch ...
	RemoteAddressOperatorGeoMatch RemoteAddressOperator = "GeoMatch"
	// RemoteAddressOperatorIPMatch ...
	RemoteAddressOperatorIPMatch RemoteAddressOperator = "IPMatch"
)

// PossibleRemoteAddressOperatorValues returns an array of possible values for the RemoteAddressOperator const type.
func PossibleRemoteAddressOperatorValues() []RemoteAddressOperator {
	return []RemoteAddressOperator{RemoteAddressOperatorAny, RemoteAddressOperatorGeoMatch, RemoteAddressOperatorIPMatch}
}

// RequestBodyOperator enumerates the values for request body operator.
type RequestBodyOperator string

const (
	// RequestBodyOperatorAny ...
	RequestBodyOperatorAny RequestBodyOperator = "Any"
	// RequestBodyOperatorBeginsWith ...
	RequestBodyOperatorBeginsWith RequestBodyOperator = "BeginsWith"
	// RequestBodyOperatorContains ...
	RequestBodyOperatorContains RequestBodyOperator = "Contains"
	// RequestBodyOperatorEndsWith ...
	RequestBodyOperatorEndsWith RequestBodyOperator = "EndsWith"
	// RequestBodyOperatorEqual ...
	RequestBodyOperatorEqual RequestBodyOperator = "Equal"
	// RequestBodyOperatorGreaterThan ...
	RequestBodyOperatorGreaterThan RequestBodyOperator = "GreaterThan"
	// RequestBodyOperatorGreaterThanOrEqual ...
	RequestBodyOperatorGreaterThanOrEqual RequestBodyOperator = "GreaterThanOrEqual"
	// RequestBodyOperatorLessThan ...
	RequestBodyOperatorLessThan RequestBodyOperator = "LessThan"
	// RequestBodyOperatorLessThanOrEqual ...
	RequestBodyOperatorLessThanOrEqual RequestBodyOperator = "LessThanOrEqual"
)

// PossibleRequestBodyOperatorValues returns an array of possible values for the RequestBodyOperator const type.
func PossibleRequestBodyOperatorValues() []RequestBodyOperator {
	return []RequestBodyOperator{RequestBodyOperatorAny, RequestBodyOperatorBeginsWith, RequestBodyOperatorContains, RequestBodyOperatorEndsWith, RequestBodyOperatorEqual, RequestBodyOperatorGreaterThan, RequestBodyOperatorGreaterThanOrEqual, RequestBodyOperatorLessThan, RequestBodyOperatorLessThanOrEqual}
}

// RequestHeaderOperator enumerates the values for request header operator.
type RequestHeaderOperator string

const (
	// RequestHeaderOperatorAny ...
	RequestHeaderOperatorAny RequestHeaderOperator = "Any"
	// RequestHeaderOperatorBeginsWith ...
	RequestHeaderOperatorBeginsWith RequestHeaderOperator = "BeginsWith"
	// RequestHeaderOperatorContains ...
	RequestHeaderOperatorContains RequestHeaderOperator = "Contains"
	// RequestHeaderOperatorEndsWith ...
	RequestHeaderOperatorEndsWith RequestHeaderOperator = "EndsWith"
	// RequestHeaderOperatorEqual ...
	RequestHeaderOperatorEqual RequestHeaderOperator = "Equal"
	// RequestHeaderOperatorGreaterThan ...
	RequestHeaderOperatorGreaterThan RequestHeaderOperator = "GreaterThan"
	// RequestHeaderOperatorGreaterThanOrEqual ...
	RequestHeaderOperatorGreaterThanOrEqual RequestHeaderOperator = "GreaterThanOrEqual"
	// RequestHeaderOperatorLessThan ...
	RequestHeaderOperatorLessThan RequestHeaderOperator = "LessThan"
	// RequestHeaderOperatorLessThanOrEqual ...
	RequestHeaderOperatorLessThanOrEqual RequestHeaderOperator = "LessThanOrEqual"
)

// PossibleRequestHeaderOperatorValues returns an array of possible values for the RequestHeaderOperator const type.
func PossibleRequestHeaderOperatorValues() []RequestHeaderOperator {
	return []RequestHeaderOperator{RequestHeaderOperatorAny, RequestHeaderOperatorBeginsWith, RequestHeaderOperatorContains, RequestHeaderOperatorEndsWith, RequestHeaderOperatorEqual, RequestHeaderOperatorGreaterThan, RequestHeaderOperatorGreaterThanOrEqual, RequestHeaderOperatorLessThan, RequestHeaderOperatorLessThanOrEqual}
}

// RequestURIOperator enumerates the values for request uri operator.
type RequestURIOperator string

const (
	// RequestURIOperatorAny ...
	RequestURIOperatorAny RequestURIOperator = "Any"
	// RequestURIOperatorBeginsWith ...
	RequestURIOperatorBeginsWith RequestURIOperator = "BeginsWith"
	// RequestURIOperatorContains ...
	RequestURIOperatorContains RequestURIOperator = "Contains"
	// RequestURIOperatorEndsWith ...
	RequestURIOperatorEndsWith RequestURIOperator = "EndsWith"
	// RequestURIOperatorEqual ...
	RequestURIOperatorEqual RequestURIOperator = "Equal"
	// RequestURIOperatorGreaterThan ...
	RequestURIOperatorGreaterThan RequestURIOperator = "GreaterThan"
	// RequestURIOperatorGreaterThanOrEqual ...
	RequestURIOperatorGreaterThanOrEqual RequestURIOperator = "GreaterThanOrEqual"
	// RequestURIOperatorLessThan ...
	RequestURIOperatorLessThan RequestURIOperator = "LessThan"
	// RequestURIOperatorLessThanOrEqual ...
	RequestURIOperatorLessThanOrEqual RequestURIOperator = "LessThanOrEqual"
)

// PossibleRequestURIOperatorValues returns an array of possible values for the RequestURIOperator const type.
func PossibleRequestURIOperatorValues() []RequestURIOperator {
	return []RequestURIOperator{RequestURIOperatorAny, RequestURIOperatorBeginsWith, RequestURIOperatorContains, RequestURIOperatorEndsWith, RequestURIOperatorEqual, RequestURIOperatorGreaterThan, RequestURIOperatorGreaterThanOrEqual, RequestURIOperatorLessThan, RequestURIOperatorLessThanOrEqual}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// MicrosoftCdnProfilesEndpoints ...
	MicrosoftCdnProfilesEndpoints ResourceType = "Microsoft.Cdn/Profiles/Endpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{MicrosoftCdnProfilesEndpoints}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// CustomVerizon ...
	CustomVerizon SkuName = "Custom_Verizon"
	// PremiumVerizon ...
	PremiumVerizon SkuName = "Premium_Verizon"
	// StandardAkamai ...
	StandardAkamai SkuName = "Standard_Akamai"
	// StandardChinaCdn ...
	StandardChinaCdn SkuName = "Standard_ChinaCdn"
	// StandardMicrosoft ...
	StandardMicrosoft SkuName = "Standard_Microsoft"
	// StandardVerizon ...
	StandardVerizon SkuName = "Standard_Verizon"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{CustomVerizon, PremiumVerizon, StandardAkamai, StandardChinaCdn, StandardMicrosoft, StandardVerizon}
}

// Transform enumerates the values for transform.
type Transform string

const (
	// Lowercase ...
	Lowercase Transform = "Lowercase"
	// Uppercase ...
	Uppercase Transform = "Uppercase"
)

// PossibleTransformValues returns an array of possible values for the Transform const type.
func PossibleTransformValues() []Transform {
	return []Transform{Lowercase, Uppercase}
}

// URLFileExtensionOperator enumerates the values for url file extension operator.
type URLFileExtensionOperator string

const (
	// URLFileExtensionOperatorAny ...
	URLFileExtensionOperatorAny URLFileExtensionOperator = "Any"
	// URLFileExtensionOperatorBeginsWith ...
	URLFileExtensionOperatorBeginsWith URLFileExtensionOperator = "BeginsWith"
	// URLFileExtensionOperatorContains ...
	URLFileExtensionOperatorContains URLFileExtensionOperator = "Contains"
	// URLFileExtensionOperatorEndsWith ...
	URLFileExtensionOperatorEndsWith URLFileExtensionOperator = "EndsWith"
	// URLFileExtensionOperatorEqual ...
	URLFileExtensionOperatorEqual URLFileExtensionOperator = "Equal"
	// URLFileExtensionOperatorGreaterThan ...
	URLFileExtensionOperatorGreaterThan URLFileExtensionOperator = "GreaterThan"
	// URLFileExtensionOperatorGreaterThanOrEqual ...
	URLFileExtensionOperatorGreaterThanOrEqual URLFileExtensionOperator = "GreaterThanOrEqual"
	// URLFileExtensionOperatorLessThan ...
	URLFileExtensionOperatorLessThan URLFileExtensionOperator = "LessThan"
	// URLFileExtensionOperatorLessThanOrEqual ...
	URLFileExtensionOperatorLessThanOrEqual URLFileExtensionOperator = "LessThanOrEqual"
)

// PossibleURLFileExtensionOperatorValues returns an array of possible values for the URLFileExtensionOperator const type.
func PossibleURLFileExtensionOperatorValues() []URLFileExtensionOperator {
	return []URLFileExtensionOperator{URLFileExtensionOperatorAny, URLFileExtensionOperatorBeginsWith, URLFileExtensionOperatorContains, URLFileExtensionOperatorEndsWith, URLFileExtensionOperatorEqual, URLFileExtensionOperatorGreaterThan, URLFileExtensionOperatorGreaterThanOrEqual, URLFileExtensionOperatorLessThan, URLFileExtensionOperatorLessThanOrEqual}
}

// URLFileNameOperator enumerates the values for url file name operator.
type URLFileNameOperator string

const (
	// URLFileNameOperatorAny ...
	URLFileNameOperatorAny URLFileNameOperator = "Any"
	// URLFileNameOperatorBeginsWith ...
	URLFileNameOperatorBeginsWith URLFileNameOperator = "BeginsWith"
	// URLFileNameOperatorContains ...
	URLFileNameOperatorContains URLFileNameOperator = "Contains"
	// URLFileNameOperatorEndsWith ...
	URLFileNameOperatorEndsWith URLFileNameOperator = "EndsWith"
	// URLFileNameOperatorEqual ...
	URLFileNameOperatorEqual URLFileNameOperator = "Equal"
	// URLFileNameOperatorGreaterThan ...
	URLFileNameOperatorGreaterThan URLFileNameOperator = "GreaterThan"
	// URLFileNameOperatorGreaterThanOrEqual ...
	URLFileNameOperatorGreaterThanOrEqual URLFileNameOperator = "GreaterThanOrEqual"
	// URLFileNameOperatorLessThan ...
	URLFileNameOperatorLessThan URLFileNameOperator = "LessThan"
	// URLFileNameOperatorLessThanOrEqual ...
	URLFileNameOperatorLessThanOrEqual URLFileNameOperator = "LessThanOrEqual"
)

// PossibleURLFileNameOperatorValues returns an array of possible values for the URLFileNameOperator const type.
func PossibleURLFileNameOperatorValues() []URLFileNameOperator {
	return []URLFileNameOperator{URLFileNameOperatorAny, URLFileNameOperatorBeginsWith, URLFileNameOperatorContains, URLFileNameOperatorEndsWith, URLFileNameOperatorEqual, URLFileNameOperatorGreaterThan, URLFileNameOperatorGreaterThanOrEqual, URLFileNameOperatorLessThan, URLFileNameOperatorLessThanOrEqual}
}

// URLPathOperator enumerates the values for url path operator.
type URLPathOperator string

const (
	// URLPathOperatorAny ...
	URLPathOperatorAny URLPathOperator = "Any"
	// URLPathOperatorBeginsWith ...
	URLPathOperatorBeginsWith URLPathOperator = "BeginsWith"
	// URLPathOperatorContains ...
	URLPathOperatorContains URLPathOperator = "Contains"
	// URLPathOperatorEndsWith ...
	URLPathOperatorEndsWith URLPathOperator = "EndsWith"
	// URLPathOperatorEqual ...
	URLPathOperatorEqual URLPathOperator = "Equal"
	// URLPathOperatorGreaterThan ...
	URLPathOperatorGreaterThan URLPathOperator = "GreaterThan"
	// URLPathOperatorGreaterThanOrEqual ...
	URLPathOperatorGreaterThanOrEqual URLPathOperator = "GreaterThanOrEqual"
	// URLPathOperatorLessThan ...
	URLPathOperatorLessThan URLPathOperator = "LessThan"
	// URLPathOperatorLessThanOrEqual ...
	URLPathOperatorLessThanOrEqual URLPathOperator = "LessThanOrEqual"
	// URLPathOperatorWildcard ...
	URLPathOperatorWildcard URLPathOperator = "Wildcard"
)

// PossibleURLPathOperatorValues returns an array of possible values for the URLPathOperator const type.
func PossibleURLPathOperatorValues() []URLPathOperator {
	return []URLPathOperator{URLPathOperatorAny, URLPathOperatorBeginsWith, URLPathOperatorContains, URLPathOperatorEndsWith, URLPathOperatorEqual, URLPathOperatorGreaterThan, URLPathOperatorGreaterThanOrEqual, URLPathOperatorLessThan, URLPathOperatorLessThanOrEqual, URLPathOperatorWildcard}
}

// ActionType defines the action to take on rule match.
type ActionType struct {
	// ActionType - Describes type of action. Possible values include: 'Allow', 'Block', 'Log', 'Redirect'
	ActionType Action `json:"actionType,omitempty"`
	// RedirectURL - If action type is redirect, this field represents URL to be re-directed.
	RedirectURL *string `json:"redirectUrl,omitempty"`
	// CustomBlockResponseStatusCode - If the action type is block, customer can override the response status code.
	CustomBlockResponseStatusCode *int32 `json:"customBlockResponseStatusCode,omitempty"`
	// CustomBlockResponseBody - If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
	CustomBlockResponseBody *string `json:"customBlockResponseBody,omitempty"`
}

// CacheExpirationActionParameters defines the parameters for the cache expiration action.
type CacheExpirationActionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// CacheBehavior - Caching behavior for the requests. Possible values include: 'BypassCache', 'Override', 'SetIfMissing'
	CacheBehavior CacheBehavior `json:"cacheBehavior,omitempty"`
	// CacheType - The level at which the content needs to be cached.
	CacheType *string `json:"cacheType,omitempty"`
	// CacheDuration - The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
	CacheDuration *string `json:"cacheDuration,omitempty"`
}

// CertificateSourceParameters defines the parameters for using CDN managed certificate for securing custom
// domain.
type CertificateSourceParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// CertificateType - Type of certificate used. Possible values include: 'Shared', 'Dedicated'
	CertificateType CertificateType `json:"certificateType,omitempty"`
}

// CheckNameAvailabilityInput input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// Name - The resource name to validate.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource whose name is to be validated.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityOutput output of check name availability API.
type CheckNameAvailabilityOutput struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason why the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty"`
}

// CidrIPAddress CIDR Ip address
type CidrIPAddress struct {
	// BaseIPAddress - Ip address itself.
	BaseIPAddress *string `json:"baseIpAddress,omitempty"`
	// PrefixLength - The length of the prefix of the ip address.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
}

// CustomDomain friendly domain name mapping to the endpoint hostname that the customer provides for
// branding purposes, e.g. www.contoso.com.
type CustomDomain struct {
	autorest.Response       `json:"-"`
	*CustomDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomain.
func (cd CustomDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.CustomDomainProperties != nil {
		objectMap["properties"] = cd.CustomDomainProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomDomain struct.
func (cd *CustomDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customDomainProperties CustomDomainProperties
				err = json.Unmarshal(*v, &customDomainProperties)
				if err != nil {
					return err
				}
				cd.CustomDomainProperties = &customDomainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cd.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicCustomDomainHTTPSParameters the JSON object that contains the properties to secure a custom domain.
type BasicCustomDomainHTTPSParameters interface {
	AsManagedHTTPSParameters() (*ManagedHTTPSParameters, bool)
	AsUserManagedHTTPSParameters() (*UserManagedHTTPSParameters, bool)
	AsCustomDomainHTTPSParameters() (*CustomDomainHTTPSParameters, bool)
}

// CustomDomainHTTPSParameters the JSON object that contains the properties to secure a custom domain.
type CustomDomainHTTPSParameters struct {
	// ProtocolType - Defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ServerNameIndication', 'IPBased'
	ProtocolType ProtocolType `json:"protocolType,omitempty"`
	// CertificateSource - Possible values include: 'CertificateSourceCustomDomainHTTPSParameters', 'CertificateSourceCdn', 'CertificateSourceAzureKeyVault'
	CertificateSource CertificateSource `json:"certificateSource,omitempty"`
}

func unmarshalBasicCustomDomainHTTPSParameters(body []byte) (BasicCustomDomainHTTPSParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["certificateSource"] {
	case string(CertificateSourceCdn):
		var mhp ManagedHTTPSParameters
		err := json.Unmarshal(body, &mhp)
		return mhp, err
	case string(CertificateSourceAzureKeyVault):
		var umhp UserManagedHTTPSParameters
		err := json.Unmarshal(body, &umhp)
		return umhp, err
	default:
		var cdhp CustomDomainHTTPSParameters
		err := json.Unmarshal(body, &cdhp)
		return cdhp, err
	}
}
func unmarshalBasicCustomDomainHTTPSParametersArray(body []byte) ([]BasicCustomDomainHTTPSParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cdhpArray := make([]BasicCustomDomainHTTPSParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cdhp, err := unmarshalBasicCustomDomainHTTPSParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		cdhpArray[index] = cdhp
	}
	return cdhpArray, nil
}

// MarshalJSON is the custom marshaler for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) MarshalJSON() ([]byte, error) {
	cdhp.CertificateSource = CertificateSourceCustomDomainHTTPSParameters
	objectMap := make(map[string]interface{})
	if cdhp.ProtocolType != "" {
		objectMap["protocolType"] = cdhp.ProtocolType
	}
	if cdhp.CertificateSource != "" {
		objectMap["certificateSource"] = cdhp.CertificateSource
	}
	return json.Marshal(objectMap)
}

// AsManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) AsManagedHTTPSParameters() (*ManagedHTTPSParameters, bool) {
	return nil, false
}

// AsUserManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) AsUserManagedHTTPSParameters() (*UserManagedHTTPSParameters, bool) {
	return nil, false
}

// AsCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) AsCustomDomainHTTPSParameters() (*CustomDomainHTTPSParameters, bool) {
	return &cdhp, true
}

// AsBasicCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) AsBasicCustomDomainHTTPSParameters() (BasicCustomDomainHTTPSParameters, bool) {
	return &cdhp, true
}

// CustomDomainListResult result of the request to list custom domains. It contains a list of custom domain
// objects and a URL link to get the next set of results.
type CustomDomainListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN CustomDomains within an endpoint.
	Value *[]CustomDomain `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomDomainListResultIterator provides access to a complete listing of CustomDomain values.
type CustomDomainListResultIterator struct {
	i    int
	page CustomDomainListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomDomainListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomDomainListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomDomainListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomDomainListResultIterator) Response() CustomDomainListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomDomainListResultIterator) Value() CustomDomain {
	if !iter.page.NotDone() {
		return CustomDomain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomDomainListResultIterator type.
func NewCustomDomainListResultIterator(page CustomDomainListResultPage) CustomDomainListResultIterator {
	return CustomDomainListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cdlr CustomDomainListResult) IsEmpty() bool {
	return cdlr.Value == nil || len(*cdlr.Value) == 0
}

// customDomainListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdlr CustomDomainListResult) customDomainListResultPreparer(ctx context.Context) (*http.Request, error) {
	if cdlr.NextLink == nil || len(to.String(cdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdlr.NextLink)))
}

// CustomDomainListResultPage contains a page of CustomDomain values.
type CustomDomainListResultPage struct {
	fn   func(context.Context, CustomDomainListResult) (CustomDomainListResult, error)
	cdlr CustomDomainListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomDomainListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cdlr)
	if err != nil {
		return err
	}
	page.cdlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomDomainListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomDomainListResultPage) NotDone() bool {
	return !page.cdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomDomainListResultPage) Response() CustomDomainListResult {
	return page.cdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomDomainListResultPage) Values() []CustomDomain {
	if page.cdlr.IsEmpty() {
		return nil
	}
	return *page.cdlr.Value
}

// Creates a new instance of the CustomDomainListResultPage type.
func NewCustomDomainListResultPage(getNextPage func(context.Context, CustomDomainListResult) (CustomDomainListResult, error)) CustomDomainListResultPage {
	return CustomDomainListResultPage{fn: getNextPage}
}

// CustomDomainParameters the customDomain JSON object required for custom domain creation or update.
type CustomDomainParameters struct {
	*CustomDomainPropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainParameters.
func (cdp CustomDomainParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdp.CustomDomainPropertiesParameters != nil {
		objectMap["properties"] = cdp.CustomDomainPropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomDomainParameters struct.
func (cdp *CustomDomainParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customDomainPropertiesParameters CustomDomainPropertiesParameters
				err = json.Unmarshal(*v, &customDomainPropertiesParameters)
				if err != nil {
					return err
				}
				cdp.CustomDomainPropertiesParameters = &customDomainPropertiesParameters
			}
		}
	}

	return nil
}

// CustomDomainProperties the JSON object that contains the properties of the custom domain to create.
type CustomDomainProperties struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// ResourceState - READ-ONLY; Resource status of the custom domain. Possible values include: 'Creating', 'Active', 'Deleting'
	ResourceState CustomDomainResourceState `json:"resourceState,omitempty"`
	// CustomHTTPSProvisioningState - READ-ONLY; Provisioning status of Custom Https of the custom domain. Possible values include: 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Failed'
	CustomHTTPSProvisioningState CustomHTTPSProvisioningState `json:"customHttpsProvisioningState,omitempty"`
	// CustomHTTPSProvisioningSubstate - READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. Possible values include: 'SubmittingDomainControlValidationRequest', 'PendingDomainControlValidationREquestApproval', 'DomainControlValidationRequestApproved', 'DomainControlValidationRequestRejected', 'DomainControlValidationRequestTimedOut', 'IssuingCertificate', 'DeployingCertificate', 'CertificateDeployed', 'DeletingCertificate', 'CertificateDeleted'
	CustomHTTPSProvisioningSubstate CustomHTTPSProvisioningSubstate `json:"customHttpsProvisioningSubstate,omitempty"`
	// ValidationData - Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China.
	ValidationData *string `json:"validationData,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the custom domain.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// CustomDomainPropertiesParameters the JSON object that contains the properties of the custom domain to
// create.
type CustomDomainPropertiesParameters struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// CustomDomainsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomDomainsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomDomainsCreateFuture) Result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.CustomDomainsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.CustomDomainsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cd.Response.Response, err = future.GetResult(sender); err == nil && cd.Response.Response.StatusCode != http.StatusNoContent {
		cd, err = client.CreateResponder(cd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.CustomDomainsCreateFuture", "Result", cd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomDomainsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomDomainsDeleteFuture) Result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.CustomDomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.CustomDomainsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cd.Response.Response, err = future.GetResult(sender); err == nil && cd.Response.Response.StatusCode != http.StatusNoContent {
		cd, err = client.DeleteResponder(cd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.CustomDomainsDeleteFuture", "Result", cd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomRule defines the common attributes for a custom rule that can be included in a waf policy
type CustomRule struct {
	// Name - Defines the name of the custom rule
	Name *string `json:"name,omitempty"`
	// EnabledState - Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified. Possible values include: 'CustomRuleEnabledStateDisabled', 'CustomRuleEnabledStateEnabled'
	EnabledState CustomRuleEnabledState `json:"enabledState,omitempty"`
	// Priority - Defines in what order this rule be evaluated in the overall list of custom rules
	Priority *int32 `json:"priority,omitempty"`
	// MatchConditions - List of match conditions.
	MatchConditions *[]MatchCondition `json:"matchConditions,omitempty"`
	// Action - Describes what action to be applied when rule matches
	Action *ActionType `json:"action,omitempty"`
}

// CustomRuleList defines contents of custom rules
type CustomRuleList struct {
	// Rules - List of rules
	Rules *[]CustomRule `json:"rules,omitempty"`
}

// DeepCreatedOrigin the main origin of CDN content which is added when creating a CDN endpoint.
type DeepCreatedOrigin struct {
	// Name - Origin name
	Name                         *string `json:"name,omitempty"`
	*DeepCreatedOriginProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeepCreatedOrigin.
func (dco DeepCreatedOrigin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dco.Name != nil {
		objectMap["name"] = dco.Name
	}
	if dco.DeepCreatedOriginProperties != nil {
		objectMap["properties"] = dco.DeepCreatedOriginProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeepCreatedOrigin struct.
func (dco *DeepCreatedOrigin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dco.Name = &name
			}
		case "properties":
			if v != nil {
				var deepCreatedOriginProperties DeepCreatedOriginProperties
				err = json.Unmarshal(*v, &deepCreatedOriginProperties)
				if err != nil {
					return err
				}
				dco.DeepCreatedOriginProperties = &deepCreatedOriginProperties
			}
		}
	}

	return nil
}

// DeepCreatedOriginProperties properties of the origin created on the CDN endpoint.
type DeepCreatedOriginProperties struct {
	// HostName - The address of the origin. It can be a domain name, IPv4 address, or IPv6 address.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
}

// DeliveryRule a rule that specifies a set of actions and conditions
type DeliveryRule struct {
	// Name - Name of the rule
	Name *string `json:"name,omitempty"`
	// Order - The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32 `json:"order,omitempty"`
	// Conditions - A list of conditions that must be matched for the actions to be executed
	Conditions *[]BasicDeliveryRuleCondition `json:"conditions,omitempty"`
	// Actions - A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions *[]BasicDeliveryRuleAction `json:"actions,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DeliveryRule struct.
func (dr *DeliveryRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dr.Name = &name
			}
		case "order":
			if v != nil {
				var order int32
				err = json.Unmarshal(*v, &order)
				if err != nil {
					return err
				}
				dr.Order = &order
			}
		case "conditions":
			if v != nil {
				conditions, err := unmarshalBasicDeliveryRuleConditionArray(*v)
				if err != nil {
					return err
				}
				dr.Conditions = &conditions
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicDeliveryRuleActionArray(*v)
				if err != nil {
					return err
				}
				dr.Actions = &actions
			}
		}
	}

	return nil
}

// BasicDeliveryRuleAction an action for the delivery rule.
type BasicDeliveryRuleAction interface {
	AsURLRedirectAction() (*URLRedirectAction, bool)
	AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool)
	AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool)
	AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool)
	AsDeliveryRuleAction() (*DeliveryRuleAction, bool)
}

// DeliveryRuleAction an action for the delivery rule.
type DeliveryRuleAction struct {
	// Name - Possible values include: 'NameDeliveryRuleAction', 'NameURLRedirect', 'NameModifyRequestHeader', 'NameModifyResponseHeader', 'NameCacheExpiration'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

func unmarshalBasicDeliveryRuleAction(body []byte) (BasicDeliveryRuleAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["name"] {
	case string(NameURLRedirect):
		var ura URLRedirectAction
		err := json.Unmarshal(body, &ura)
		return ura, err
	case string(NameModifyRequestHeader):
		var drrha DeliveryRuleRequestHeaderAction
		err := json.Unmarshal(body, &drrha)
		return drrha, err
	case string(NameModifyResponseHeader):
		var drrha DeliveryRuleResponseHeaderAction
		err := json.Unmarshal(body, &drrha)
		return drrha, err
	case string(NameCacheExpiration):
		var drcea DeliveryRuleCacheExpirationAction
		err := json.Unmarshal(body, &drcea)
		return drcea, err
	default:
		var dra DeliveryRuleAction
		err := json.Unmarshal(body, &dra)
		return dra, err
	}
}
func unmarshalBasicDeliveryRuleActionArray(body []byte) ([]BasicDeliveryRuleAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	draArray := make([]BasicDeliveryRuleAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dra, err := unmarshalBasicDeliveryRuleAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		draArray[index] = dra
	}
	return draArray, nil
}

// MarshalJSON is the custom marshaler for DeliveryRuleAction.
func (dra DeliveryRuleAction) MarshalJSON() ([]byte, error) {
	dra.Name = NameDeliveryRuleAction
	objectMap := make(map[string]interface{})
	if dra.Name != "" {
		objectMap["name"] = dra.Name
	}
	return json.Marshal(objectMap)
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return &dra, true
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &dra, true
}

// DeliveryRuleCacheExpirationAction defines the cache expiration action for the delivery rule.
type DeliveryRuleCacheExpirationAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *CacheExpirationActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleAction', 'NameURLRedirect', 'NameModifyRequestHeader', 'NameModifyResponseHeader', 'NameCacheExpiration'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) MarshalJSON() ([]byte, error) {
	drcea.Name = NameCacheExpiration
	objectMap := make(map[string]interface{})
	if drcea.Parameters != nil {
		objectMap["parameters"] = drcea.Parameters
	}
	if drcea.Name != "" {
		objectMap["name"] = drcea.Name
	}
	return json.Marshal(objectMap)
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return &drcea, true
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &drcea, true
}

// BasicDeliveryRuleCondition a condition for the delivery rule.
type BasicDeliveryRuleCondition interface {
	AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool)
	AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool)
	AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool)
	AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool)
	AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool)
	AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool)
	AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool)
	AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool)
	AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool)
	AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool)
	AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool)
	AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool)
	AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool)
}

// DeliveryRuleCondition a condition for the delivery rule.
type DeliveryRuleCondition struct {
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

func unmarshalBasicDeliveryRuleCondition(body []byte) (BasicDeliveryRuleCondition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["name"] {
	case string(NameRemoteAddress):
		var drrac DeliveryRuleRemoteAddressCondition
		err := json.Unmarshal(body, &drrac)
		return drrac, err
	case string(NameRequestMethod):
		var drrmc DeliveryRuleRequestMethodCondition
		err := json.Unmarshal(body, &drrmc)
		return drrmc, err
	case string(NameQueryString):
		var drqsc DeliveryRuleQueryStringCondition
		err := json.Unmarshal(body, &drqsc)
		return drqsc, err
	case string(NamePostArgs):
		var drpac DeliveryRulePostArgsCondition
		err := json.Unmarshal(body, &drpac)
		return drpac, err
	case string(NameRequestURI):
		var drruc DeliveryRuleRequestURICondition
		err := json.Unmarshal(body, &drruc)
		return drruc, err
	case string(NameRequestHeader):
		var drrhc DeliveryRuleRequestHeaderCondition
		err := json.Unmarshal(body, &drrhc)
		return drrhc, err
	case string(NameRequestBody):
		var drrbc DeliveryRuleRequestBodyCondition
		err := json.Unmarshal(body, &drrbc)
		return drrbc, err
	case string(NameRequestScheme):
		var drrsc DeliveryRuleRequestSchemeCondition
		err := json.Unmarshal(body, &drrsc)
		return drrsc, err
	case string(NameURLPath):
		var drupc DeliveryRuleURLPathCondition
		err := json.Unmarshal(body, &drupc)
		return drupc, err
	case string(NameURLFileExtension):
		var drufec DeliveryRuleURLFileExtensionCondition
		err := json.Unmarshal(body, &drufec)
		return drufec, err
	case string(NameURLFileName):
		var drufnc DeliveryRuleURLFileNameCondition
		err := json.Unmarshal(body, &drufnc)
		return drufnc, err
	case string(NameIsDevice):
		var dridc DeliveryRuleIsDeviceCondition
		err := json.Unmarshal(body, &dridc)
		return dridc, err
	default:
		var drc DeliveryRuleCondition
		err := json.Unmarshal(body, &drc)
		return drc, err
	}
}
func unmarshalBasicDeliveryRuleConditionArray(body []byte) ([]BasicDeliveryRuleCondition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	drcArray := make([]BasicDeliveryRuleCondition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		drc, err := unmarshalBasicDeliveryRuleCondition(*rawMessage)
		if err != nil {
			return nil, err
		}
		drcArray[index] = drc
	}
	return drcArray, nil
}

// MarshalJSON is the custom marshaler for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) MarshalJSON() ([]byte, error) {
	drc.Name = NameDeliveryRuleCondition
	objectMap := make(map[string]interface{})
	if drc.Name != "" {
		objectMap["name"] = drc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return &drc, true
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drc, true
}

// DeliveryRuleIsDeviceCondition defines the IsDevice condition for the delivery rule.
type DeliveryRuleIsDeviceCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *IsDeviceMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) MarshalJSON() ([]byte, error) {
	dridc.Name = NameIsDevice
	objectMap := make(map[string]interface{})
	if dridc.Parameters != nil {
		objectMap["parameters"] = dridc.Parameters
	}
	if dridc.Name != "" {
		objectMap["name"] = dridc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return &dridc, true
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &dridc, true
}

// DeliveryRulePostArgsCondition defines the PostArgs condition for the delivery rule.
type DeliveryRulePostArgsCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *PostArgsMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) MarshalJSON() ([]byte, error) {
	drpac.Name = NamePostArgs
	objectMap := make(map[string]interface{})
	if drpac.Parameters != nil {
		objectMap["parameters"] = drpac.Parameters
	}
	if drpac.Name != "" {
		objectMap["name"] = drpac.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return &drpac, true
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drpac, true
}

// DeliveryRuleQueryStringCondition defines the QueryString condition for the delivery rule.
type DeliveryRuleQueryStringCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *QueryStringMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) MarshalJSON() ([]byte, error) {
	drqsc.Name = NameQueryString
	objectMap := make(map[string]interface{})
	if drqsc.Parameters != nil {
		objectMap["parameters"] = drqsc.Parameters
	}
	if drqsc.Name != "" {
		objectMap["name"] = drqsc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return &drqsc, true
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drqsc, true
}

// DeliveryRuleRemoteAddressCondition defines the RemoteAddress condition for the delivery rule.
type DeliveryRuleRemoteAddressCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RemoteAddressMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) MarshalJSON() ([]byte, error) {
	drrac.Name = NameRemoteAddress
	objectMap := make(map[string]interface{})
	if drrac.Parameters != nil {
		objectMap["parameters"] = drrac.Parameters
	}
	if drrac.Name != "" {
		objectMap["name"] = drrac.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return &drrac, true
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrac, true
}

// DeliveryRuleRequestBodyCondition defines the RequestBody condition for the delivery rule.
type DeliveryRuleRequestBodyCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestBodyMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) MarshalJSON() ([]byte, error) {
	drrbc.Name = NameRequestBody
	objectMap := make(map[string]interface{})
	if drrbc.Parameters != nil {
		objectMap["parameters"] = drrbc.Parameters
	}
	if drrbc.Name != "" {
		objectMap["name"] = drrbc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return &drrbc, true
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrbc, true
}

// DeliveryRuleRequestHeaderAction defines the request header action for the delivery rule.
type DeliveryRuleRequestHeaderAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *HeaderActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleAction', 'NameURLRedirect', 'NameModifyRequestHeader', 'NameModifyResponseHeader', 'NameCacheExpiration'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) MarshalJSON() ([]byte, error) {
	drrha.Name = NameModifyRequestHeader
	objectMap := make(map[string]interface{})
	if drrha.Parameters != nil {
		objectMap["parameters"] = drrha.Parameters
	}
	if drrha.Name != "" {
		objectMap["name"] = drrha.Name
	}
	return json.Marshal(objectMap)
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return &drrha, true
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &drrha, true
}

// DeliveryRuleRequestHeaderCondition defines the RequestHeader condition for the delivery rule.
type DeliveryRuleRequestHeaderCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestHeaderMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) MarshalJSON() ([]byte, error) {
	drrhc.Name = NameRequestHeader
	objectMap := make(map[string]interface{})
	if drrhc.Parameters != nil {
		objectMap["parameters"] = drrhc.Parameters
	}
	if drrhc.Name != "" {
		objectMap["name"] = drrhc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return &drrhc, true
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrhc, true
}

// DeliveryRuleRequestMethodCondition defines the RequestMethod condition for the delivery rule.
type DeliveryRuleRequestMethodCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestMethodMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) MarshalJSON() ([]byte, error) {
	drrmc.Name = NameRequestMethod
	objectMap := make(map[string]interface{})
	if drrmc.Parameters != nil {
		objectMap["parameters"] = drrmc.Parameters
	}
	if drrmc.Name != "" {
		objectMap["name"] = drrmc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return &drrmc, true
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrmc, true
}

// DeliveryRuleRequestSchemeCondition defines the RequestScheme condition for the delivery rule.
type DeliveryRuleRequestSchemeCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestSchemeMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) MarshalJSON() ([]byte, error) {
	drrsc.Name = NameRequestScheme
	objectMap := make(map[string]interface{})
	if drrsc.Parameters != nil {
		objectMap["parameters"] = drrsc.Parameters
	}
	if drrsc.Name != "" {
		objectMap["name"] = drrsc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return &drrsc, true
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrsc, true
}

// DeliveryRuleRequestURICondition defines the RequestUri condition for the delivery rule.
type DeliveryRuleRequestURICondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestURIMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) MarshalJSON() ([]byte, error) {
	drruc.Name = NameRequestURI
	objectMap := make(map[string]interface{})
	if drruc.Parameters != nil {
		objectMap["parameters"] = drruc.Parameters
	}
	if drruc.Name != "" {
		objectMap["name"] = drruc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return &drruc, true
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drruc, true
}

// DeliveryRuleResponseHeaderAction defines the response header action for the delivery rule.
type DeliveryRuleResponseHeaderAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *HeaderActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleAction', 'NameURLRedirect', 'NameModifyRequestHeader', 'NameModifyResponseHeader', 'NameCacheExpiration'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) MarshalJSON() ([]byte, error) {
	drrha.Name = NameModifyResponseHeader
	objectMap := make(map[string]interface{})
	if drrha.Parameters != nil {
		objectMap["parameters"] = drrha.Parameters
	}
	if drrha.Name != "" {
		objectMap["name"] = drrha.Name
	}
	return json.Marshal(objectMap)
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return &drrha, true
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &drrha, true
}

// DeliveryRuleURLFileExtensionCondition defines the UrlFileExtension condition for the delivery rule.
type DeliveryRuleURLFileExtensionCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *URLFileExtensionMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) MarshalJSON() ([]byte, error) {
	drufec.Name = NameURLFileExtension
	objectMap := make(map[string]interface{})
	if drufec.Parameters != nil {
		objectMap["parameters"] = drufec.Parameters
	}
	if drufec.Name != "" {
		objectMap["name"] = drufec.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return &drufec, true
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drufec, true
}

// DeliveryRuleURLFileNameCondition defines the UrlFileName condition for the delivery rule.
type DeliveryRuleURLFileNameCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *URLFileNameMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) MarshalJSON() ([]byte, error) {
	drufnc.Name = NameURLFileName
	objectMap := make(map[string]interface{})
	if drufnc.Parameters != nil {
		objectMap["parameters"] = drufnc.Parameters
	}
	if drufnc.Name != "" {
		objectMap["name"] = drufnc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return &drufnc, true
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drufnc, true
}

// DeliveryRuleURLPathCondition defines the UrlPath condition for the delivery rule.
type DeliveryRuleURLPathCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *URLPathMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameRemoteAddress', 'NameRequestMethod', 'NameQueryString', 'NamePostArgs', 'NameRequestURI', 'NameRequestHeader', 'NameRequestBody', 'NameRequestScheme', 'NameURLPath', 'NameURLFileExtension', 'NameURLFileName', 'NameIsDevice'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) MarshalJSON() ([]byte, error) {
	drupc.Name = NameURLPath
	objectMap := make(map[string]interface{})
	if drupc.Parameters != nil {
		objectMap["parameters"] = drupc.Parameters
	}
	if drupc.Name != "" {
		objectMap["name"] = drupc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return &drupc, true
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drupc, true
}

// EdgeNode edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users.
type EdgeNode struct {
	*EdgeNodeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeNode.
func (en EdgeNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if en.EdgeNodeProperties != nil {
		objectMap["properties"] = en.EdgeNodeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EdgeNode struct.
func (en *EdgeNode) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var edgeNodeProperties EdgeNodeProperties
				err = json.Unmarshal(*v, &edgeNodeProperties)
				if err != nil {
					return err
				}
				en.EdgeNodeProperties = &edgeNodeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				en.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				en.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				en.Type = &typeVar
			}
		}
	}

	return nil
}

// EdgeNodeProperties the JSON object that contains the properties required to create an edgenode.
type EdgeNodeProperties struct {
	// IPAddressGroups - List of ip address groups.
	IPAddressGroups *[]IPAddressGroup `json:"ipAddressGroups,omitempty"`
}

// EdgenodeResult result of the request to list CDN edgenodes. It contains a list of ip address group and a
// URL link to get the next set of results.
type EdgenodeResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Edge node of CDN service.
	Value *[]EdgeNode `json:"value,omitempty"`
	// NextLink - URL to get the next set of edgenode list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EdgenodeResultIterator provides access to a complete listing of EdgeNode values.
type EdgenodeResultIterator struct {
	i    int
	page EdgenodeResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EdgenodeResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgenodeResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EdgenodeResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EdgenodeResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EdgenodeResultIterator) Response() EdgenodeResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EdgenodeResultIterator) Value() EdgeNode {
	if !iter.page.NotDone() {
		return EdgeNode{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EdgenodeResultIterator type.
func NewEdgenodeResultIterator(page EdgenodeResultPage) EdgenodeResultIterator {
	return EdgenodeResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (er EdgenodeResult) IsEmpty() bool {
	return er.Value == nil || len(*er.Value) == 0
}

// edgenodeResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (er EdgenodeResult) edgenodeResultPreparer(ctx context.Context) (*http.Request, error) {
	if er.NextLink == nil || len(to.String(er.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(er.NextLink)))
}

// EdgenodeResultPage contains a page of EdgeNode values.
type EdgenodeResultPage struct {
	fn func(context.Context, EdgenodeResult) (EdgenodeResult, error)
	er EdgenodeResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EdgenodeResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgenodeResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.er)
	if err != nil {
		return err
	}
	page.er = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EdgenodeResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EdgenodeResultPage) NotDone() bool {
	return !page.er.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EdgenodeResultPage) Response() EdgenodeResult {
	return page.er
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EdgenodeResultPage) Values() []EdgeNode {
	if page.er.IsEmpty() {
		return nil
	}
	return *page.er.Value
}

// Creates a new instance of the EdgenodeResultPage type.
func NewEdgenodeResultPage(getNextPage func(context.Context, EdgenodeResult) (EdgenodeResult, error)) EdgenodeResultPage {
	return EdgenodeResultPage{fn: getNextPage}
}

// Endpoint CDN endpoint is the entity within a CDN profile containing configuration information such as
// origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format
// <endpointname>.azureedge.net.
type Endpoint struct {
	autorest.Response   `json:"-"`
	*EndpointProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Endpoint.
func (e Endpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.EndpointProperties != nil {
		objectMap["properties"] = e.EndpointProperties
	}
	if e.Location != nil {
		objectMap["location"] = e.Location
	}
	if e.Tags != nil {
		objectMap["tags"] = e.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Endpoint struct.
func (e *Endpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var endpointProperties EndpointProperties
				err = json.Unmarshal(*v, &endpointProperties)
				if err != nil {
					return err
				}
				e.EndpointProperties = &endpointProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				e.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				e.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		}
	}

	return nil
}

// EndpointListResult result of the request to list endpoints. It contains a list of endpoint objects and a
// URL link to get the next set of results.
type EndpointListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN endpoints within a profile
	Value *[]Endpoint `json:"value,omitempty"`
	// NextLink - URL to get the next set of endpoint objects if there is any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EndpointListResultIterator provides access to a complete listing of Endpoint values.
type EndpointListResultIterator struct {
	i    int
	page EndpointListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EndpointListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointListResultIterator) Response() EndpointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointListResultIterator) Value() Endpoint {
	if !iter.page.NotDone() {
		return Endpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EndpointListResultIterator type.
func NewEndpointListResultIterator(page EndpointListResultPage) EndpointListResultIterator {
	return EndpointListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EndpointListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// endpointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EndpointListResult) endpointListResultPreparer(ctx context.Context) (*http.Request, error) {
	if elr.NextLink == nil || len(to.String(elr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EndpointListResultPage contains a page of Endpoint values.
type EndpointListResultPage struct {
	fn  func(context.Context, EndpointListResult) (EndpointListResult, error)
	elr EndpointListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.elr)
	if err != nil {
		return err
	}
	page.elr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EndpointListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointListResultPage) Response() EndpointListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointListResultPage) Values() []Endpoint {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// Creates a new instance of the EndpointListResultPage type.
func NewEndpointListResultPage(getNextPage func(context.Context, EndpointListResult) (EndpointListResult, error)) EndpointListResultPage {
	return EndpointListResultPage{fn: getNextPage}
}

// EndpointProperties the JSON object that contains the properties required to create an endpoint.
type EndpointProperties struct {
	// HostName - READ-ONLY; The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
	HostName *string `json:"hostName,omitempty"`
	// Origins - The source of the content being delivered via CDN.
	Origins *[]DeepCreatedOrigin `json:"origins,omitempty"`
	// ResourceState - READ-ONLY; Resource status of the endpoint. Possible values include: 'EndpointResourceStateCreating', 'EndpointResourceStateDeleting', 'EndpointResourceStateRunning', 'EndpointResourceStateStarting', 'EndpointResourceStateStopped', 'EndpointResourceStateStopping'
	ResourceState EndpointResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// OriginHostHeader - The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// OriginPath - A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL. Possible values include: 'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization. Possible values include: 'GeneralWebDelivery', 'GeneralMediaStreaming', 'VideoOnDemandMediaStreaming', 'LargeFileDownload', 'DynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// ProbePath - Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path.
	ProbePath *string `json:"probePath,omitempty"`
	// GeoFilters - List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
	// DeliveryPolicy - A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy `json:"deliveryPolicy,omitempty"`
	// WebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for the endpoint (if applicable)
	WebApplicationFirewallPolicyLink *EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// EndpointPropertiesUpdateParameters the JSON object containing endpoint update parameters.
type EndpointPropertiesUpdateParameters struct {
	// OriginHostHeader - The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// OriginPath - A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL. Possible values include: 'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization. Possible values include: 'GeneralWebDelivery', 'GeneralMediaStreaming', 'VideoOnDemandMediaStreaming', 'LargeFileDownload', 'DynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// ProbePath - Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path.
	ProbePath *string `json:"probePath,omitempty"`
	// GeoFilters - List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
	// DeliveryPolicy - A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy `json:"deliveryPolicy,omitempty"`
	// WebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for the endpoint (if applicable)
	WebApplicationFirewallPolicyLink *EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// EndpointPropertiesUpdateParametersDeliveryPolicy a policy that specifies the delivery rules to be used
// for an endpoint.
type EndpointPropertiesUpdateParametersDeliveryPolicy struct {
	// Description - User-friendly description of the policy.
	Description *string `json:"description,omitempty"`
	// Rules - A list of the delivery rules.
	Rules *[]DeliveryRule `json:"rules,omitempty"`
}

// EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink defines the Web Application Firewall
// policy for the endpoint (if applicable)
type EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// EndpointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsCreateFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsCreateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsDeleteFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsLoadContentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsLoadContentFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsLoadContentFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsLoadContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsLoadContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsPurgeContentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsPurgeContentFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsPurgeContentFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsPurgeContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsPurgeContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsStartFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsStartFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.StartResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsStartFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsStopFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsStopFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.StopResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsStopFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsUpdateFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.UpdateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsUpdateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointType defines the ARM Resource ID for the linked endpoints
type EndpointType struct {
	// ID - ARM Resource ID string.
	ID *string `json:"id,omitempty"`
}

// EndpointUpdateParameters properties required to create or update an endpoint.
type EndpointUpdateParameters struct {
	// Tags - Endpoint tags.
	Tags                                map[string]*string `json:"tags"`
	*EndpointPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointUpdateParameters.
func (eup EndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eup.Tags != nil {
		objectMap["tags"] = eup.Tags
	}
	if eup.EndpointPropertiesUpdateParameters != nil {
		objectMap["properties"] = eup.EndpointPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EndpointUpdateParameters struct.
func (eup *EndpointUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				eup.Tags = tags
			}
		case "properties":
			if v != nil {
				var endpointPropertiesUpdateParameters EndpointPropertiesUpdateParameters
				err = json.Unmarshal(*v, &endpointPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				eup.EndpointPropertiesUpdateParameters = &endpointPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// ErrorResponse error response indicates CDN service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// GeoFilter rules defining user's geo access within a CDN endpoint.
type GeoFilter struct {
	// RelativePath - Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
	RelativePath *string `json:"relativePath,omitempty"`
	// Action - Action of the geo filter, i.e. allow or block access. Possible values include: 'GeoFilterActionsBlock', 'GeoFilterActionsAllow'
	Action GeoFilterActions `json:"action,omitempty"`
	// CountryCodes - Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
	CountryCodes *[]string `json:"countryCodes,omitempty"`
}

// HeaderActionParameters defines the parameters for the request header action.
type HeaderActionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// HeaderAction - Action to perform. Possible values include: 'Append', 'Overwrite', 'Delete'
	HeaderAction HeaderAction `json:"headerAction,omitempty"`
	// HeaderName - Name of the header to modify
	HeaderName *string `json:"headerName,omitempty"`
	// Value - Value for the specified action
	Value *string `json:"value,omitempty"`
}

// IPAddressGroup CDN Ip address group
type IPAddressGroup struct {
	// DeliveryRegion - The delivery region of the ip address group
	DeliveryRegion *string `json:"deliveryRegion,omitempty"`
	// Ipv4Addresses - The list of ip v4 addresses.
	Ipv4Addresses *[]CidrIPAddress `json:"ipv4Addresses,omitempty"`
	// Ipv6Addresses - The list of ip v6 addresses.
	Ipv6Addresses *[]CidrIPAddress `json:"ipv6Addresses,omitempty"`
}

// IsDeviceMatchConditionParameters defines the parameters for IsDevice match conditions
type IsDeviceMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched
	Operator *string `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// KeyVaultCertificateSourceParameters describes the parameters for using a user's KeyVault certificate for
// securing custom domain.
type KeyVaultCertificateSourceParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// SubscriptionID - Subscription Id of the user's Key Vault containing the SSL certificate
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Resource group of the user's Key Vault containing the SSL certificate
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// VaultName - The name of the user's Key Vault containing the SSL certificate
	VaultName *string `json:"vaultName,omitempty"`
	// SecretName - The name of Key Vault Secret (representing the full certificate PFX) in Key Vault.
	SecretName *string `json:"secretName,omitempty"`
	// SecretVersion - The version(GUID) of Key Vault Secret in Key Vault.
	SecretVersion *string `json:"secretVersion,omitempty"`
	// UpdateRule - Describes the action that shall be taken when the certificate is updated in Key Vault.
	UpdateRule *string `json:"updateRule,omitempty"`
	// DeleteRule - Describes the action that shall be taken when the certificate is removed from Key Vault.
	DeleteRule *string `json:"deleteRule,omitempty"`
}

// LoadParameters parameters required for content load.
type LoadParameters struct {
	// ContentPaths - The path to the content to be loaded. Path should be a relative file URL of the origin.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// ManagedHTTPSParameters defines the certificate source parameters using CDN managed certificate for
// enabling SSL.
type ManagedHTTPSParameters struct {
	// CertificateSourceParameters - Defines the certificate source parameters using CDN managed certificate for enabling SSL.
	CertificateSourceParameters *CertificateSourceParameters `json:"certificateSourceParameters,omitempty"`
	// ProtocolType - Defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ServerNameIndication', 'IPBased'
	ProtocolType ProtocolType `json:"protocolType,omitempty"`
	// CertificateSource - Possible values include: 'CertificateSourceCustomDomainHTTPSParameters', 'CertificateSourceCdn', 'CertificateSourceAzureKeyVault'
	CertificateSource CertificateSource `json:"certificateSource,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) MarshalJSON() ([]byte, error) {
	mhp.CertificateSource = CertificateSourceCdn
	objectMap := make(map[string]interface{})
	if mhp.CertificateSourceParameters != nil {
		objectMap["certificateSourceParameters"] = mhp.CertificateSourceParameters
	}
	if mhp.ProtocolType != "" {
		objectMap["protocolType"] = mhp.ProtocolType
	}
	if mhp.CertificateSource != "" {
		objectMap["certificateSource"] = mhp.CertificateSource
	}
	return json.Marshal(objectMap)
}

// AsManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) AsManagedHTTPSParameters() (*ManagedHTTPSParameters, bool) {
	return &mhp, true
}

// AsUserManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) AsUserManagedHTTPSParameters() (*UserManagedHTTPSParameters, bool) {
	return nil, false
}

// AsCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) AsCustomDomainHTTPSParameters() (*CustomDomainHTTPSParameters, bool) {
	return nil, false
}

// AsBasicCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) AsBasicCustomDomainHTTPSParameters() (BasicCustomDomainHTTPSParameters, bool) {
	return &mhp, true
}

// ManagedRuleDefinition describes a managed rule definition.
type ManagedRuleDefinition struct {
	// RuleID - READ-ONLY; Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty"`
	// Description - READ-ONLY; Describes the functionality of the managed rule.
	Description *string `json:"description,omitempty"`
}

// ManagedRuleGroupDefinition describes a managed rule group.
type ManagedRuleGroupDefinition struct {
	// RuleGroupName - READ-ONLY; Name of the managed rule group.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Description - READ-ONLY; Description of the managed rule group.
	Description *string `json:"description,omitempty"`
	// Rules - READ-ONLY; List of rules within the managed rule group.
	Rules *[]ManagedRuleDefinition `json:"rules,omitempty"`
}

// ManagedRuleGroupOverride defines a managed rule group override setting.
type ManagedRuleGroupOverride struct {
	// RuleGroupName - Describes the managed rule group within the rule set to override
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Rules - List of rules that will be disabled. If none specified, all rules in the group will be disabled.
	Rules *[]ManagedRuleOverride `json:"rules,omitempty"`
}

// ManagedRuleOverride defines a managed rule group override setting.
type ManagedRuleOverride struct {
	// RuleID - Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty"`
	// EnabledState - Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified. Possible values include: 'ManagedRuleEnabledStateDisabled', 'ManagedRuleEnabledStateEnabled'
	EnabledState ManagedRuleEnabledState `json:"enabledState,omitempty"`
	// Action - Describes the override action to be applied when rule matches.
	Action *ActionType `json:"action,omitempty"`
}

// ManagedRuleSet defines a managed rule set.
type ManagedRuleSet struct {
	// RuleSetType - Defines the rule set type to use.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - Defines the version of the rule set to use.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// AnomalyScore - Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
	AnomalyScore *int32 `json:"anomalyScore,omitempty"`
	// RuleGroupOverrides - Defines the rule overrides to apply to the rule set.
	RuleGroupOverrides *[]ManagedRuleGroupOverride `json:"ruleGroupOverrides,omitempty"`
}

// ManagedRuleSetDefinition describes a managed rule set definition.
type ManagedRuleSetDefinition struct {
	// ManagedRuleSetDefinitionProperties - Describes managed rule set definition properties.
	*ManagedRuleSetDefinitionProperties `json:"properties,omitempty"`
	// Sku - The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedRuleSetDefinition.
func (mrsd ManagedRuleSetDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrsd.ManagedRuleSetDefinitionProperties != nil {
		objectMap["properties"] = mrsd.ManagedRuleSetDefinitionProperties
	}
	if mrsd.Sku != nil {
		objectMap["sku"] = mrsd.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedRuleSetDefinition struct.
func (mrsd *ManagedRuleSetDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedRuleSetDefinitionProperties ManagedRuleSetDefinitionProperties
				err = json.Unmarshal(*v, &managedRuleSetDefinitionProperties)
				if err != nil {
					return err
				}
				mrsd.ManagedRuleSetDefinitionProperties = &managedRuleSetDefinitionProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mrsd.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mrsd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mrsd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mrsd.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedRuleSetDefinitionList list of managed rule set definitions available for use in a policy.
type ManagedRuleSetDefinitionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of managed rule set definitions.
	Value *[]ManagedRuleSetDefinition `json:"value,omitempty"`
	// NextLink - URL to retrieve next set of managed rule set definitions.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedRuleSetDefinitionListIterator provides access to a complete listing of ManagedRuleSetDefinition
// values.
type ManagedRuleSetDefinitionListIterator struct {
	i    int
	page ManagedRuleSetDefinitionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedRuleSetDefinitionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedRuleSetDefinitionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedRuleSetDefinitionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedRuleSetDefinitionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedRuleSetDefinitionListIterator) Response() ManagedRuleSetDefinitionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedRuleSetDefinitionListIterator) Value() ManagedRuleSetDefinition {
	if !iter.page.NotDone() {
		return ManagedRuleSetDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedRuleSetDefinitionListIterator type.
func NewManagedRuleSetDefinitionListIterator(page ManagedRuleSetDefinitionListPage) ManagedRuleSetDefinitionListIterator {
	return ManagedRuleSetDefinitionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrsdl ManagedRuleSetDefinitionList) IsEmpty() bool {
	return mrsdl.Value == nil || len(*mrsdl.Value) == 0
}

// managedRuleSetDefinitionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrsdl ManagedRuleSetDefinitionList) managedRuleSetDefinitionListPreparer(ctx context.Context) (*http.Request, error) {
	if mrsdl.NextLink == nil || len(to.String(mrsdl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrsdl.NextLink)))
}

// ManagedRuleSetDefinitionListPage contains a page of ManagedRuleSetDefinition values.
type ManagedRuleSetDefinitionListPage struct {
	fn    func(context.Context, ManagedRuleSetDefinitionList) (ManagedRuleSetDefinitionList, error)
	mrsdl ManagedRuleSetDefinitionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedRuleSetDefinitionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedRuleSetDefinitionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mrsdl)
	if err != nil {
		return err
	}
	page.mrsdl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedRuleSetDefinitionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedRuleSetDefinitionListPage) NotDone() bool {
	return !page.mrsdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedRuleSetDefinitionListPage) Response() ManagedRuleSetDefinitionList {
	return page.mrsdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedRuleSetDefinitionListPage) Values() []ManagedRuleSetDefinition {
	if page.mrsdl.IsEmpty() {
		return nil
	}
	return *page.mrsdl.Value
}

// Creates a new instance of the ManagedRuleSetDefinitionListPage type.
func NewManagedRuleSetDefinitionListPage(getNextPage func(context.Context, ManagedRuleSetDefinitionList) (ManagedRuleSetDefinitionList, error)) ManagedRuleSetDefinitionListPage {
	return ManagedRuleSetDefinitionListPage{fn: getNextPage}
}

// ManagedRuleSetDefinitionProperties properties for a managed rule set definition.
type ManagedRuleSetDefinitionProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the managed rule set.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// RuleSetType - READ-ONLY; Type of the managed rule set.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - READ-ONLY; Version of the managed rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// RuleGroups - READ-ONLY; Rule groups of the managed rule set.
	RuleGroups *[]ManagedRuleGroupDefinition `json:"ruleGroups,omitempty"`
}

// ManagedRuleSetList defines the list of managed rule sets for the policy.
type ManagedRuleSetList struct {
	// ManagedRuleSets - List of rule sets.
	ManagedRuleSets *[]ManagedRuleSet `json:"managedRuleSets,omitempty"`
}

// MatchCondition define match conditions
type MatchCondition struct {
	// MatchVariable - Match variable to compare against. Possible values include: 'RemoteAddr', 'Country', 'RequestMethod', 'RequestHeader', 'RequestURI', 'QueryString', 'RequestBody', 'Cookies', 'PostArgs'
	MatchVariable MatchVariable `json:"matchVariable,omitempty"`
	// Selector - Selector can used to match a specific key for QueryString, RequestUri, RequestHeaders or RequestBody.
	Selector *string `json:"selector,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'Any', 'IPMatch', 'GeoMatch', 'Equal', 'Contains', 'LessThan', 'GreaterThan', 'LessThanOrEqual', 'GreaterThanOrEqual', 'BeginsWith', 'EndsWith', 'RegEx'
	Operator Operator `json:"operator,omitempty"`
	// NegateCondition - Describes if the result of this condition should be negated.
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValue - List of possible match values.
	MatchValue *[]string `json:"matchValue,omitempty"`
}

// Operation CDN REST API operation
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.Cdn
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationsListResult result of the request to list CDN operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN operations supported by the CDN resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsListResultIterator provides access to a complete listing of Operation values.
type OperationsListResultIterator struct {
	i    int
	page OperationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListResultIterator) Response() OperationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListResultIterator type.
func NewOperationsListResultIterator(page OperationsListResultPage) OperationsListResultIterator {
	return OperationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationsListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationsListResult) operationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationsListResultPage contains a page of Operation values.
type OperationsListResultPage struct {
	fn  func(context.Context, OperationsListResult) (OperationsListResult, error)
	olr OperationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListResultPage) Response() OperationsListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationsListResultPage type.
func NewOperationsListResultPage(getNextPage func(context.Context, OperationsListResult) (OperationsListResult, error)) OperationsListResultPage {
	return OperationsListResultPage{fn: getNextPage}
}

// Origin CDN origin is the source of the content being delivered via CDN. When the edge nodes represented
// by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of
// the configured origins.
type Origin struct {
	autorest.Response `json:"-"`
	*OriginProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Origin.
func (o Origin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.OriginProperties != nil {
		objectMap["properties"] = o.OriginProperties
	}
	if o.Location != nil {
		objectMap["location"] = o.Location
	}
	if o.Tags != nil {
		objectMap["tags"] = o.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Origin struct.
func (o *Origin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originProperties OriginProperties
				err = json.Unmarshal(*v, &originProperties)
				if err != nil {
					return err
				}
				o.OriginProperties = &originProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				o.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				o.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		}
	}

	return nil
}

// OriginListResult result of the request to list origins. It contains a list of origin objects and a URL
// link to get the next set of results.
type OriginListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN origins within an endpoint
	Value *[]Origin `json:"value,omitempty"`
	// NextLink - URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OriginListResultIterator provides access to a complete listing of Origin values.
type OriginListResultIterator struct {
	i    int
	page OriginListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OriginListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OriginListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OriginListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OriginListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OriginListResultIterator) Response() OriginListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OriginListResultIterator) Value() Origin {
	if !iter.page.NotDone() {
		return Origin{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OriginListResultIterator type.
func NewOriginListResultIterator(page OriginListResultPage) OriginListResultIterator {
	return OriginListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OriginListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// originListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OriginListResult) originListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OriginListResultPage contains a page of Origin values.
type OriginListResultPage struct {
	fn  func(context.Context, OriginListResult) (OriginListResult, error)
	olr OriginListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OriginListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OriginListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OriginListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OriginListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OriginListResultPage) Response() OriginListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OriginListResultPage) Values() []Origin {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OriginListResultPage type.
func NewOriginListResultPage(getNextPage func(context.Context, OriginListResult) (OriginListResult, error)) OriginListResultPage {
	return OriginListResultPage{fn: getNextPage}
}

// OriginProperties the JSON object that contains the properties of the origin.
type OriginProperties struct {
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the https port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// ResourceState - READ-ONLY; Resource status of the origin. Possible values include: 'OriginResourceStateCreating', 'OriginResourceStateActive', 'OriginResourceStateDeleting'
	ResourceState OriginResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the origin.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// OriginPropertiesParameters the JSON object that contains the properties of the origin.
type OriginPropertiesParameters struct {
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
}

// OriginsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OriginsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *OriginsUpdateFuture) Result(client OriginsClient) (o Origin, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.OriginsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.OriginsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.UpdateResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.OriginsUpdateFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OriginUpdateParameters origin properties needed for origin creation or update.
type OriginUpdateParameters struct {
	*OriginPropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginUpdateParameters.
func (oup OriginUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oup.OriginPropertiesParameters != nil {
		objectMap["properties"] = oup.OriginPropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OriginUpdateParameters struct.
func (oup *OriginUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originPropertiesParameters OriginPropertiesParameters
				err = json.Unmarshal(*v, &originPropertiesParameters)
				if err != nil {
					return err
				}
				oup.OriginPropertiesParameters = &originPropertiesParameters
			}
		}
	}

	return nil
}

// PoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PoliciesCreateOrUpdateFuture) Result(client PoliciesClient) (wafp WebApplicationFirewallPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.PoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.PoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wafp.Response.Response, err = future.GetResult(sender); err == nil && wafp.Response.Response.StatusCode != http.StatusNoContent {
		wafp, err = client.CreateOrUpdateResponder(wafp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.PoliciesCreateOrUpdateFuture", "Result", wafp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PoliciesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PoliciesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PoliciesUpdateFuture) Result(client PoliciesClient) (wafp WebApplicationFirewallPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.PoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.PoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wafp.Response.Response, err = future.GetResult(sender); err == nil && wafp.Response.Response.StatusCode != http.StatusNoContent {
		wafp, err = client.UpdateResponder(wafp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.PoliciesUpdateFuture", "Result", wafp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PolicySettings defines contents of a web application firewall global configuration
type PolicySettings struct {
	// EnabledState - describes if the policy is in enabled state or disabled state. Possible values include: 'PolicyEnabledStateDisabled', 'PolicyEnabledStateEnabled'
	EnabledState PolicyEnabledState `json:"enabledState,omitempty"`
	// Mode - Describes if it is in detection mode or prevention mode at policy level. Possible values include: 'Prevention', 'Detection'
	Mode PolicyMode `json:"mode,omitempty"`
	// DefaultRedirectURL - If action type is redirect, this field represents the default redirect URL for the client.
	DefaultRedirectURL *string `json:"defaultRedirectUrl,omitempty"`
	// DefaultCustomBlockResponseStatusCode - If the action type is block, this field defines the default customer overridable http response status code.
	DefaultCustomBlockResponseStatusCode *int32 `json:"defaultCustomBlockResponseStatusCode,omitempty"`
	// DefaultCustomBlockResponseBody - If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
	DefaultCustomBlockResponseBody *string `json:"defaultCustomBlockResponseBody,omitempty"`
}

// PostArgsMatchConditionParameters defines the parameters for PostArgs match conditions
type PostArgsMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Selector - Name of PostArg to be matched
	Selector *string `json:"selector,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'PostArgsOperatorAny', 'PostArgsOperatorEqual', 'PostArgsOperatorContains', 'PostArgsOperatorBeginsWith', 'PostArgsOperatorEndsWith', 'PostArgsOperatorLessThan', 'PostArgsOperatorLessThanOrEqual', 'PostArgsOperatorGreaterThan', 'PostArgsOperatorGreaterThanOrEqual'
	Operator PostArgsOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// Profile CDN profile is a logical grouping of endpoints that share the same settings, such as CDN
// provider and pricing tier.
type Profile struct {
	autorest.Response `json:"-"`
	// Sku - The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
	Sku                *Sku `json:"sku,omitempty"`
	*ProfileProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Sku != nil {
		objectMap["sku"] = p.Sku
	}
	if p.ProfileProperties != nil {
		objectMap["properties"] = p.ProfileProperties
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				p.Sku = &sku
			}
		case "properties":
			if v != nil {
				var profileProperties ProfileProperties
				err = json.Unmarshal(*v, &profileProperties)
				if err != nil {
					return err
				}
				p.ProfileProperties = &profileProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProfileListResult result of the request to list profiles. It contains a list of profile objects and a
// URL link to get the next set of results.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN profiles within a resource group.
	Value *[]Profile `json:"value,omitempty"`
	// NextLink - URL to get the next set of profile objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProfileListResultIterator provides access to a complete listing of Profile values.
type ProfileListResultIterator struct {
	i    int
	page ProfileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProfileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProfileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProfileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProfileListResultIterator) Response() ProfileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProfileListResultIterator) Value() Profile {
	if !iter.page.NotDone() {
		return Profile{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProfileListResultIterator type.
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return ProfileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProfileListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// profileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProfileListResult) profileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProfileListResultPage contains a page of Profile values.
type ProfileListResultPage struct {
	fn  func(context.Context, ProfileListResult) (ProfileListResult, error)
	plr ProfileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProfileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProfileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProfileListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProfileListResultPage) Response() ProfileListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProfileListResultPage) Values() []Profile {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProfileListResultPage type.
func NewProfileListResultPage(getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return ProfileListResultPage{fn: getNextPage}
}

// ProfileProperties the JSON object that contains the properties required to create a profile.
type ProfileProperties struct {
	// ResourceState - READ-ONLY; Resource status of the profile. Possible values include: 'ProfileResourceStateCreating', 'ProfileResourceStateActive', 'ProfileResourceStateDeleting', 'ProfileResourceStateDisabled'
	ResourceState ProfileResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the profile.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ProfilesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesCreateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.CreateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.ProfilesCreateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfilesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesDeleteFuture) Result(client ProfilesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ProfilesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesUpdateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.UpdateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.ProfilesUpdateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfileUpdateParameters properties required to update a profile.
type ProfileUpdateParameters struct {
	// Tags - Profile tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ProfileUpdateParameters.
func (pup ProfileUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pup.Tags != nil {
		objectMap["tags"] = pup.Tags
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// PurgeParameters parameters required for content purge.
type PurgeParameters struct {
	// ContentPaths - The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// QueryStringMatchConditionParameters defines the parameters for QueryString match conditions
type QueryStringMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'QueryStringOperatorAny', 'QueryStringOperatorEqual', 'QueryStringOperatorContains', 'QueryStringOperatorBeginsWith', 'QueryStringOperatorEndsWith', 'QueryStringOperatorLessThan', 'QueryStringOperatorLessThanOrEqual', 'QueryStringOperatorGreaterThan', 'QueryStringOperatorGreaterThanOrEqual'
	Operator QueryStringOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// RateLimitRule defines a rate limiting rule that can be included in a waf policy
type RateLimitRule struct {
	// RateLimitThreshold - Defines rate limit threshold.
	RateLimitThreshold *int32 `json:"rateLimitThreshold,omitempty"`
	// RateLimitDurationInMinutes - Defines rate limit duration. Default is 1 minute.
	RateLimitDurationInMinutes *int32 `json:"rateLimitDurationInMinutes,omitempty"`
	// Name - Defines the name of the custom rule
	Name *string `json:"name,omitempty"`
	// EnabledState - Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified. Possible values include: 'CustomRuleEnabledStateDisabled', 'CustomRuleEnabledStateEnabled'
	EnabledState CustomRuleEnabledState `json:"enabledState,omitempty"`
	// Priority - Defines in what order this rule be evaluated in the overall list of custom rules
	Priority *int32 `json:"priority,omitempty"`
	// MatchConditions - List of match conditions.
	MatchConditions *[]MatchCondition `json:"matchConditions,omitempty"`
	// Action - Describes what action to be applied when rule matches
	Action *ActionType `json:"action,omitempty"`
}

// RateLimitRuleList defines contents of rate limit rules
type RateLimitRuleList struct {
	// Rules - List of rules
	Rules *[]RateLimitRule `json:"rules,omitempty"`
}

// RemoteAddressMatchConditionParameters defines the parameters for RemoteAddress match conditions
type RemoteAddressMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'RemoteAddressOperatorAny', 'RemoteAddressOperatorIPMatch', 'RemoteAddressOperatorGeoMatch'
	Operator RemoteAddressOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// RequestBodyMatchConditionParameters defines the parameters for RequestBody match conditions
type RequestBodyMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'RequestBodyOperatorAny', 'RequestBodyOperatorEqual', 'RequestBodyOperatorContains', 'RequestBodyOperatorBeginsWith', 'RequestBodyOperatorEndsWith', 'RequestBodyOperatorLessThan', 'RequestBodyOperatorLessThanOrEqual', 'RequestBodyOperatorGreaterThan', 'RequestBodyOperatorGreaterThanOrEqual'
	Operator RequestBodyOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// RequestHeaderMatchConditionParameters defines the parameters for RequestHeader match conditions
type RequestHeaderMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Selector - Name of Header to be matched
	Selector *string `json:"selector,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'RequestHeaderOperatorAny', 'RequestHeaderOperatorEqual', 'RequestHeaderOperatorContains', 'RequestHeaderOperatorBeginsWith', 'RequestHeaderOperatorEndsWith', 'RequestHeaderOperatorLessThan', 'RequestHeaderOperatorLessThanOrEqual', 'RequestHeaderOperatorGreaterThan', 'RequestHeaderOperatorGreaterThanOrEqual'
	Operator RequestHeaderOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// RequestMethodMatchConditionParameters defines the parameters for RequestMethod match conditions
type RequestMethodMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched
	Operator *string `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
}

// RequestSchemeMatchConditionParameters defines the parameters for RequestScheme match conditions
type RequestSchemeMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched
	Operator *string `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
}

// RequestURIMatchConditionParameters defines the parameters for RequestUri match conditions
type RequestURIMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'RequestURIOperatorAny', 'RequestURIOperatorEqual', 'RequestURIOperatorContains', 'RequestURIOperatorBeginsWith', 'RequestURIOperatorEndsWith', 'RequestURIOperatorLessThan', 'RequestURIOperatorLessThanOrEqual', 'RequestURIOperatorGreaterThan', 'RequestURIOperatorGreaterThanOrEqual'
	Operator RequestURIOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceUsage output of check resource usage API.
type ResourceUsage struct {
	// ResourceType - READ-ONLY; Resource type for which the usage is provided.
	ResourceType *string `json:"resourceType,omitempty"`
	// Unit - READ-ONLY; Unit of the usage. e.g. Count.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; Actual value of usage on the specified resource type.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; Quota of the specified resource type.
	Limit *int32 `json:"limit,omitempty"`
}

// ResourceUsageListResult output of check resource usage API.
type ResourceUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of resource usages.
	Value *[]ResourceUsage `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceUsageListResultIterator provides access to a complete listing of ResourceUsage values.
type ResourceUsageListResultIterator struct {
	i    int
	page ResourceUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceUsageListResultIterator) Response() ResourceUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceUsageListResultIterator) Value() ResourceUsage {
	if !iter.page.NotDone() {
		return ResourceUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceUsageListResultIterator type.
func NewResourceUsageListResultIterator(page ResourceUsageListResultPage) ResourceUsageListResultIterator {
	return ResourceUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rulr ResourceUsageListResult) IsEmpty() bool {
	return rulr.Value == nil || len(*rulr.Value) == 0
}

// resourceUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rulr ResourceUsageListResult) resourceUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rulr.NextLink == nil || len(to.String(rulr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rulr.NextLink)))
}

// ResourceUsageListResultPage contains a page of ResourceUsage values.
type ResourceUsageListResultPage struct {
	fn   func(context.Context, ResourceUsageListResult) (ResourceUsageListResult, error)
	rulr ResourceUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rulr)
	if err != nil {
		return err
	}
	page.rulr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceUsageListResultPage) NotDone() bool {
	return !page.rulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceUsageListResultPage) Response() ResourceUsageListResult {
	return page.rulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceUsageListResultPage) Values() []ResourceUsage {
	if page.rulr.IsEmpty() {
		return nil
	}
	return *page.rulr.Value
}

// Creates a new instance of the ResourceUsageListResultPage type.
func NewResourceUsageListResultPage(getNextPage func(context.Context, ResourceUsageListResult) (ResourceUsageListResult, error)) ResourceUsageListResultPage {
	return ResourceUsageListResultPage{fn: getNextPage}
}

// Sku the pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
type Sku struct {
	// Name - Name of the pricing tier. Possible values include: 'StandardVerizon', 'PremiumVerizon', 'CustomVerizon', 'StandardAkamai', 'StandardChinaCdn', 'StandardMicrosoft'
	Name SkuName `json:"name,omitempty"`
}

// SsoURI the URI required to login to the supplemental portal from the Azure portal.
type SsoURI struct {
	autorest.Response `json:"-"`
	// SsoURIValue - READ-ONLY; The URI used to login to the supplemental portal.
	SsoURIValue *string `json:"ssoUriValue,omitempty"`
}

// SupportedOptimizationTypesListResult the result of the GetSupportedOptimizationTypes API
type SupportedOptimizationTypesListResult struct {
	autorest.Response `json:"-"`
	// SupportedOptimizationTypes - READ-ONLY; Supported optimization types for a profile.
	SupportedOptimizationTypes *[]OptimizationType `json:"supportedOptimizationTypes,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// URLFileExtensionMatchConditionParameters defines the parameters for UrlFileExtension match conditions
type URLFileExtensionMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'URLFileExtensionOperatorAny', 'URLFileExtensionOperatorEqual', 'URLFileExtensionOperatorContains', 'URLFileExtensionOperatorBeginsWith', 'URLFileExtensionOperatorEndsWith', 'URLFileExtensionOperatorLessThan', 'URLFileExtensionOperatorLessThanOrEqual', 'URLFileExtensionOperatorGreaterThan', 'URLFileExtensionOperatorGreaterThanOrEqual'
	Operator URLFileExtensionOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// URLFileNameMatchConditionParameters defines the parameters for UrlFilename match conditions
type URLFileNameMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'URLFileNameOperatorAny', 'URLFileNameOperatorEqual', 'URLFileNameOperatorContains', 'URLFileNameOperatorBeginsWith', 'URLFileNameOperatorEndsWith', 'URLFileNameOperatorLessThan', 'URLFileNameOperatorLessThanOrEqual', 'URLFileNameOperatorGreaterThan', 'URLFileNameOperatorGreaterThanOrEqual'
	Operator URLFileNameOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// URLPathMatchConditionParameters defines the parameters for UrlPath match conditions
type URLPathMatchConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'URLPathOperatorAny', 'URLPathOperatorEqual', 'URLPathOperatorContains', 'URLPathOperatorBeginsWith', 'URLPathOperatorEndsWith', 'URLPathOperatorLessThan', 'URLPathOperatorLessThanOrEqual', 'URLPathOperatorGreaterThan', 'URLPathOperatorGreaterThanOrEqual', 'URLPathOperatorWildcard'
	Operator URLPathOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// URLRedirectAction defines the url redirect action for the delivery rule.
type URLRedirectAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *URLRedirectActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleAction', 'NameURLRedirect', 'NameModifyRequestHeader', 'NameModifyResponseHeader', 'NameCacheExpiration'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for URLRedirectAction.
func (ura URLRedirectAction) MarshalJSON() ([]byte, error) {
	ura.Name = NameURLRedirect
	objectMap := make(map[string]interface{})
	if ura.Parameters != nil {
		objectMap["parameters"] = ura.Parameters
	}
	if ura.Name != "" {
		objectMap["name"] = ura.Name
	}
	return json.Marshal(objectMap)
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return &ura, true
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &ura, true
}

// URLRedirectActionParameters defines the parameters for the url redirect action.
type URLRedirectActionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// RedirectType - The redirect type the rule will use when redirecting traffic. Possible values include: 'Moved', 'Found', 'TemporaryRedirect', 'PermanentRedirect'
	RedirectType RedirectType `json:"redirectType,omitempty"`
	// DestinationProtocol - Protocol to use for the redirect. The default value is MatchRequest. Possible values include: 'MatchRequest', 'HTTP', 'HTTPS'
	DestinationProtocol DestinationProtocol `json:"destinationProtocol,omitempty"`
	// CustomPath - The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
	CustomPath *string `json:"customPath,omitempty"`
	// CustomHostname - Host to redirect. Leave empty to use the incoming host as the destination host.
	CustomHostname *string `json:"customHostname,omitempty"`
	// CustomQueryString - The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
	CustomQueryString *string `json:"customQueryString,omitempty"`
	// CustomFragment - Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
	CustomFragment *string `json:"customFragment,omitempty"`
}

// UserManagedHTTPSParameters defines the certificate source parameters using user's keyvault certificate
// for enabling SSL.
type UserManagedHTTPSParameters struct {
	// CertificateSourceParameters - Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
	CertificateSourceParameters *KeyVaultCertificateSourceParameters `json:"certificateSourceParameters,omitempty"`
	// ProtocolType - Defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ServerNameIndication', 'IPBased'
	ProtocolType ProtocolType `json:"protocolType,omitempty"`
	// CertificateSource - Possible values include: 'CertificateSourceCustomDomainHTTPSParameters', 'CertificateSourceCdn', 'CertificateSourceAzureKeyVault'
	CertificateSource CertificateSource `json:"certificateSource,omitempty"`
}

// MarshalJSON is the custom marshaler for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) MarshalJSON() ([]byte, error) {
	umhp.CertificateSource = CertificateSourceAzureKeyVault
	objectMap := make(map[string]interface{})
	if umhp.CertificateSourceParameters != nil {
		objectMap["certificateSourceParameters"] = umhp.CertificateSourceParameters
	}
	if umhp.ProtocolType != "" {
		objectMap["protocolType"] = umhp.ProtocolType
	}
	if umhp.CertificateSource != "" {
		objectMap["certificateSource"] = umhp.CertificateSource
	}
	return json.Marshal(objectMap)
}

// AsManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) AsManagedHTTPSParameters() (*ManagedHTTPSParameters, bool) {
	return nil, false
}

// AsUserManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) AsUserManagedHTTPSParameters() (*UserManagedHTTPSParameters, bool) {
	return &umhp, true
}

// AsCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) AsCustomDomainHTTPSParameters() (*CustomDomainHTTPSParameters, bool) {
	return nil, false
}

// AsBasicCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) AsBasicCustomDomainHTTPSParameters() (BasicCustomDomainHTTPSParameters, bool) {
	return &umhp, true
}

// ValidateCustomDomainInput input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// ValidateCustomDomainOutput output of custom domain validation.
type ValidateCustomDomainOutput struct {
	autorest.Response `json:"-"`
	// CustomDomainValidated - READ-ONLY; Indicates whether the custom domain is valid or not.
	CustomDomainValidated *bool `json:"customDomainValidated,omitempty"`
	// Reason - READ-ONLY; The reason why the custom domain is not valid.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; Error message describing why the custom domain is not valid.
	Message *string `json:"message,omitempty"`
}

// ValidateProbeInput input of the validate probe API.
type ValidateProbeInput struct {
	// ProbeURL - The probe URL to validate.
	ProbeURL *string `json:"probeURL,omitempty"`
}

// ValidateProbeOutput output of the validate probe API.
type ValidateProbeOutput struct {
	autorest.Response `json:"-"`
	// IsValid - READ-ONLY; Indicates whether the probe URL is accepted or not.
	IsValid *bool `json:"isValid,omitempty"`
	// ErrorCode - READ-ONLY; Specifies the error code when the probe url is not accepted.
	ErrorCode *string `json:"errorCode,omitempty"`
	// Message - READ-ONLY; The detailed error message describing why the probe URL is not accepted.
	Message *string `json:"message,omitempty"`
}

// WebApplicationFirewallPolicy defines web application firewall policy for Azure CDN.
type WebApplicationFirewallPolicy struct {
	autorest.Response `json:"-"`
	// WebApplicationFirewallPolicyProperties - Properties of the web application firewall policy.
	*WebApplicationFirewallPolicyProperties `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Sku - The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
	Sku *Sku `json:"sku,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicy.
func (wafp WebApplicationFirewallPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafp.WebApplicationFirewallPolicyProperties != nil {
		objectMap["properties"] = wafp.WebApplicationFirewallPolicyProperties
	}
	if wafp.Etag != nil {
		objectMap["etag"] = wafp.Etag
	}
	if wafp.Sku != nil {
		objectMap["sku"] = wafp.Sku
	}
	if wafp.Location != nil {
		objectMap["location"] = wafp.Location
	}
	if wafp.Tags != nil {
		objectMap["tags"] = wafp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebApplicationFirewallPolicy struct.
func (wafp *WebApplicationFirewallPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webApplicationFirewallPolicyProperties WebApplicationFirewallPolicyProperties
				err = json.Unmarshal(*v, &webApplicationFirewallPolicyProperties)
				if err != nil {
					return err
				}
				wafp.WebApplicationFirewallPolicyProperties = &webApplicationFirewallPolicyProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				wafp.Etag = &etag
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				wafp.Sku = &sku
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wafp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wafp.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wafp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wafp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wafp.Type = &typeVar
			}
		}
	}

	return nil
}

// WebApplicationFirewallPolicyList defines a list of WebApplicationFirewallPolicies for Azure CDN. It
// contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Azure CDN WebApplicationFirewallPolicies within a resource group.
	Value *[]WebApplicationFirewallPolicy `json:"value,omitempty"`
	// NextLink - URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebApplicationFirewallPolicyListIterator provides access to a complete listing of
// WebApplicationFirewallPolicy values.
type WebApplicationFirewallPolicyListIterator struct {
	i    int
	page WebApplicationFirewallPolicyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebApplicationFirewallPolicyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebApplicationFirewallPolicyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebApplicationFirewallPolicyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebApplicationFirewallPolicyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebApplicationFirewallPolicyListIterator) Response() WebApplicationFirewallPolicyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebApplicationFirewallPolicyListIterator) Value() WebApplicationFirewallPolicy {
	if !iter.page.NotDone() {
		return WebApplicationFirewallPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebApplicationFirewallPolicyListIterator type.
func NewWebApplicationFirewallPolicyListIterator(page WebApplicationFirewallPolicyListPage) WebApplicationFirewallPolicyListIterator {
	return WebApplicationFirewallPolicyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wafpl WebApplicationFirewallPolicyList) IsEmpty() bool {
	return wafpl.Value == nil || len(*wafpl.Value) == 0
}

// webApplicationFirewallPolicyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wafpl WebApplicationFirewallPolicyList) webApplicationFirewallPolicyListPreparer(ctx context.Context) (*http.Request, error) {
	if wafpl.NextLink == nil || len(to.String(wafpl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wafpl.NextLink)))
}

// WebApplicationFirewallPolicyListPage contains a page of WebApplicationFirewallPolicy values.
type WebApplicationFirewallPolicyListPage struct {
	fn    func(context.Context, WebApplicationFirewallPolicyList) (WebApplicationFirewallPolicyList, error)
	wafpl WebApplicationFirewallPolicyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebApplicationFirewallPolicyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebApplicationFirewallPolicyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wafpl)
	if err != nil {
		return err
	}
	page.wafpl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebApplicationFirewallPolicyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebApplicationFirewallPolicyListPage) NotDone() bool {
	return !page.wafpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebApplicationFirewallPolicyListPage) Response() WebApplicationFirewallPolicyList {
	return page.wafpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebApplicationFirewallPolicyListPage) Values() []WebApplicationFirewallPolicy {
	if page.wafpl.IsEmpty() {
		return nil
	}
	return *page.wafpl.Value
}

// Creates a new instance of the WebApplicationFirewallPolicyListPage type.
func NewWebApplicationFirewallPolicyListPage(getNextPage func(context.Context, WebApplicationFirewallPolicyList) (WebApplicationFirewallPolicyList, error)) WebApplicationFirewallPolicyListPage {
	return WebApplicationFirewallPolicyListPage{fn: getNextPage}
}

// WebApplicationFirewallPolicyPatchParameters properties required to update a
// CdnWebApplicationFirewallPolicy.
type WebApplicationFirewallPolicyPatchParameters struct {
	// Tags - CdnWebApplicationFirewallPolicy tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicyPatchParameters.
func (wafppp WebApplicationFirewallPolicyPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafppp.Tags != nil {
		objectMap["tags"] = wafppp.Tags
	}
	return json.Marshal(objectMap)
}

// WebApplicationFirewallPolicyProperties defines CDN web application firewall policy properties.
type WebApplicationFirewallPolicyProperties struct {
	// PolicySettings - Describes  policySettings for policy
	PolicySettings *PolicySettings `json:"policySettings,omitempty"`
	// RateLimitRules - Describes rate limit rules inside the policy.
	RateLimitRules *RateLimitRuleList `json:"rateLimitRules,omitempty"`
	// CustomRules - Describes custom rules inside the policy.
	CustomRules *CustomRuleList `json:"customRules,omitempty"`
	// ManagedRules - Describes managed rules inside the policy.
	ManagedRules *ManagedRuleSetList `json:"managedRules,omitempty"`
	// CdnEndpointLinks - READ-ONLY; Describes Azure CDN endpoints associated with this Web Application Firewall policy.
	CdnEndpointLinks *[]EndpointType `json:"cdnEndpointLinks,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the WebApplicationFirewallPolicy. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ResourceState - READ-ONLY; Possible values include: 'PolicyResourceStateCreating', 'PolicyResourceStateEnabling', 'PolicyResourceStateEnabled', 'PolicyResourceStateDisabling', 'PolicyResourceStateDisabled', 'PolicyResourceStateDeleting'
	ResourceState PolicyResourceState `json:"resourceState,omitempty"`
}
