package personalizer

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/personalizer/v1.0/personalizer"

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// BadRequest Request could not be understood by the server.
	BadRequest ErrorCode = "BadRequest"
	// InternalServerError A generic error has occurred on the server.
	InternalServerError ErrorCode = "InternalServerError"
	// ResourceNotFound Requested resource does not exist on the server.
	ResourceNotFound ErrorCode = "ResourceNotFound"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{BadRequest, InternalServerError, ResourceNotFound}
}

// Error the error object.
type Error struct {
	// Code - High level error code. Possible values include: 'BadRequest', 'ResourceNotFound', 'InternalServerError'
	Code ErrorCode `json:"code,omitempty"`
	// Message - A message explaining the error reported by the service.
	Message *string `json:"message,omitempty"`
	// Target - Error source element.
	Target *string `json:"target,omitempty"`
	// Details - An array of details about specific errors that led to this reported error.
	Details *[]Error `json:"details,omitempty"`
	// InnerError - Finer error details.
	InnerError *InternalError `json:"innerError,omitempty"`
}

// ErrorResponse used to return an error to the client
type ErrorResponse struct {
	// Error - The error object.
	Error *Error `json:"error,omitempty"`
}

// InternalError an object containing more specific information than the parent object about the error.
type InternalError struct {
	// Code - Detailed error code.
	Code *string `json:"code,omitempty"`
	// Innererror - The error object.
	Innererror *InternalError `json:"innererror,omitempty"`
}

// RankableAction an action with it's associated features used for ranking.
type RankableAction struct {
	// ID - Id of the action.
	ID *string `json:"id,omitempty"`
	// Features - List of dictionaries containing features.
	Features *[]interface{} `json:"features,omitempty"`
}

// RankedAction a ranked action with its resulting probability.
type RankedAction struct {
	// ID - READ-ONLY; Id of the action
	ID *string `json:"id,omitempty"`
	// Probability - READ-ONLY; Probability of the action
	Probability *float64 `json:"probability,omitempty"`
}

// RankRequest request a set of actions to be ranked by the Personalizer service.
type RankRequest struct {
	// ContextFeatures - Features of the context used for Personalizer as a
	// dictionary of dictionaries. This depends on the application, and
	// typically includes features about the current user, their
	// device, profile information, data about time and date, etc.
	ContextFeatures *[]interface{} `json:"contextFeatures,omitempty"`
	// Actions - The set of actions the Personalizer service can pick from.
	// The set should not contain more than 50 actions.
	// The order of the actions does not affect the rank result but the order
	// should match the sequence your application would have used to display them.
	Actions *[]RankableAction `json:"actions,omitempty"`
	// ExcludedActions - The set of action ids to exclude from ranking.
	ExcludedActions *[]string `json:"excludedActions,omitempty"`
	// EventID - Optionally pass an eventId that uniquely identifies this Rank event.
	// If null, the service generates a unique eventId. The eventId will be used for
	// associating this request with its reward, as well as seeding the pseudo-random
	// generator when making a Personalizer call.
	EventID *string `json:"eventId,omitempty"`
	// DeferActivation - Send false if the user will see the rank results, therefore
	// Personalizer will expect a Reward call, otherwise it will assign the default
	// Reward to the event. Send true if it is possible the user will not see the
	// rank results, because the page is rendering later, or the Rank results may be
	// overridden by code further downstream.
	DeferActivation *bool `json:"deferActivation,omitempty"`
}

// RankResponse a resulting ordered list of actions that result from a rank request.
type RankResponse struct {
	autorest.Response `json:"-"`
	// Ranking - READ-ONLY; The calculated ranking for the current request.
	Ranking *[]RankedAction `json:"ranking,omitempty"`
	// EventID - READ-ONLY; The eventId for the round trip from request to response.
	EventID *string `json:"eventId,omitempty"`
	// RewardActionID - READ-ONLY; The action chosen by the Personalizer service. This is the action for which to report the reward. This might not be the
	// first found in 'ranking' if an action in the request in first position was part of the excluded ids.
	RewardActionID *string `json:"rewardActionId,omitempty"`
}

// RewardRequest reward given to a rank response.
type RewardRequest struct {
	// Value - Reward to be assigned to an action. Value should be between -1 and 1 inclusive.
	Value *float64 `json:"value,omitempty"`
}
