package scheduler

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/scheduler/mgmt/2016-03-01/scheduler"

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobActionType enumerates the values for job action type.
type JobActionType string

const (
	// HTTP ...
	HTTP JobActionType = "Http"
	// HTTPS ...
	HTTPS JobActionType = "Https"
	// ServiceBusQueue ...
	ServiceBusQueue JobActionType = "ServiceBusQueue"
	// ServiceBusTopic ...
	ServiceBusTopic JobActionType = "ServiceBusTopic"
	// StorageQueue ...
	StorageQueue JobActionType = "StorageQueue"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleJobActionTypeValues returns an array of possible values for the JobActionType const type.
func PossibleJobActionTypeValues() []JobActionType {
	return []JobActionType{HTTP, HTTPS, ServiceBusQueue, ServiceBusTopic, StorageQueue}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobCollectionState enumerates the values for job collection state.
type JobCollectionState string

const (
	// Deleted ...
	Deleted JobCollectionState = "Deleted"
	// Disabled ...
	Disabled JobCollectionState = "Disabled"
	// Enabled ...
	Enabled JobCollectionState = "Enabled"
	// Suspended ...
	Suspended JobCollectionState = "Suspended"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleJobCollectionStateValues returns an array of possible values for the JobCollectionState const type.
func PossibleJobCollectionStateValues() []JobCollectionState {
	return []JobCollectionState{Deleted, Disabled, Enabled, Suspended}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobExecutionStatus enumerates the values for job execution status.
type JobExecutionStatus string

const (
	// Completed ...
	Completed JobExecutionStatus = "Completed"
	// Failed ...
	Failed JobExecutionStatus = "Failed"
	// Postponed ...
	Postponed JobExecutionStatus = "Postponed"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleJobExecutionStatusValues returns an array of possible values for the JobExecutionStatus const type.
func PossibleJobExecutionStatusValues() []JobExecutionStatus {
	return []JobExecutionStatus{Completed, Failed, Postponed}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobHistoryActionName enumerates the values for job history action name.
type JobHistoryActionName string

const (
	// ErrorAction ...
	ErrorAction JobHistoryActionName = "ErrorAction"
	// MainAction ...
	MainAction JobHistoryActionName = "MainAction"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleJobHistoryActionNameValues returns an array of possible values for the JobHistoryActionName const type.
func PossibleJobHistoryActionNameValues() []JobHistoryActionName {
	return []JobHistoryActionName{ErrorAction, MainAction}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobScheduleDay enumerates the values for job schedule day.
type JobScheduleDay string

const (
	// JobScheduleDayFriday ...
	JobScheduleDayFriday JobScheduleDay = "Friday"
	// JobScheduleDayMonday ...
	JobScheduleDayMonday JobScheduleDay = "Monday"
	// JobScheduleDaySaturday ...
	JobScheduleDaySaturday JobScheduleDay = "Saturday"
	// JobScheduleDaySunday ...
	JobScheduleDaySunday JobScheduleDay = "Sunday"
	// JobScheduleDayThursday ...
	JobScheduleDayThursday JobScheduleDay = "Thursday"
	// JobScheduleDayTuesday ...
	JobScheduleDayTuesday JobScheduleDay = "Tuesday"
	// JobScheduleDayWednesday ...
	JobScheduleDayWednesday JobScheduleDay = "Wednesday"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleJobScheduleDayValues returns an array of possible values for the JobScheduleDay const type.
func PossibleJobScheduleDayValues() []JobScheduleDay {
	return []JobScheduleDay{JobScheduleDayFriday, JobScheduleDayMonday, JobScheduleDaySaturday, JobScheduleDaySunday, JobScheduleDayThursday, JobScheduleDayTuesday, JobScheduleDayWednesday}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobState enumerates the values for job state.
type JobState string

const (
	// JobStateCompleted ...
	JobStateCompleted JobState = "Completed"
	// JobStateDisabled ...
	JobStateDisabled JobState = "Disabled"
	// JobStateEnabled ...
	JobStateEnabled JobState = "Enabled"
	// JobStateFaulted ...
	JobStateFaulted JobState = "Faulted"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleJobStateValues returns an array of possible values for the JobState const type.
func PossibleJobStateValues() []JobState {
	return []JobState{JobStateCompleted, JobStateDisabled, JobStateEnabled, JobStateFaulted}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// Day ...
	Day RecurrenceFrequency = "Day"
	// Hour ...
	Hour RecurrenceFrequency = "Hour"
	// Minute ...
	Minute RecurrenceFrequency = "Minute"
	// Month ...
	Month RecurrenceFrequency = "Month"
	// Week ...
	Week RecurrenceFrequency = "Week"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{Day, Hour, Minute, Month, Week}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// RetryType enumerates the values for retry type.
type RetryType string

const (
	// Fixed ...
	Fixed RetryType = "Fixed"
	// None ...
	None RetryType = "None"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleRetryTypeValues returns an array of possible values for the RetryType const type.
func PossibleRetryTypeValues() []RetryType {
	return []RetryType{Fixed, None}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// ServiceBusAuthenticationType enumerates the values for service bus authentication type.
type ServiceBusAuthenticationType string

const (
	// NotSpecified ...
	NotSpecified ServiceBusAuthenticationType = "NotSpecified"
	// SharedAccessKey ...
	SharedAccessKey ServiceBusAuthenticationType = "SharedAccessKey"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleServiceBusAuthenticationTypeValues returns an array of possible values for the ServiceBusAuthenticationType const type.
func PossibleServiceBusAuthenticationTypeValues() []ServiceBusAuthenticationType {
	return []ServiceBusAuthenticationType{NotSpecified, SharedAccessKey}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// ServiceBusTransportType enumerates the values for service bus transport type.
type ServiceBusTransportType string

const (
	// ServiceBusTransportTypeAMQP ...
	ServiceBusTransportTypeAMQP ServiceBusTransportType = "AMQP"
	// ServiceBusTransportTypeNetMessaging ...
	ServiceBusTransportTypeNetMessaging ServiceBusTransportType = "NetMessaging"
	// ServiceBusTransportTypeNotSpecified ...
	ServiceBusTransportTypeNotSpecified ServiceBusTransportType = "NotSpecified"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleServiceBusTransportTypeValues returns an array of possible values for the ServiceBusTransportType const type.
func PossibleServiceBusTransportTypeValues() []ServiceBusTransportType {
	return []ServiceBusTransportType{ServiceBusTransportTypeAMQP, ServiceBusTransportTypeNetMessaging, ServiceBusTransportTypeNotSpecified}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// SkuDefinition enumerates the values for sku definition.
type SkuDefinition string

const (
	// Free ...
	Free SkuDefinition = "Free"
	// P10Premium ...
	P10Premium SkuDefinition = "P10Premium"
	// P20Premium ...
	P20Premium SkuDefinition = "P20Premium"
	// Standard ...
	Standard SkuDefinition = "Standard"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleSkuDefinitionValues returns an array of possible values for the SkuDefinition const type.
func PossibleSkuDefinitionValues() []SkuDefinition {
	return []SkuDefinition{Free, P10Premium, P20Premium, Standard}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Type enumerates the values for type.
type Type string

const (
	// TypeActiveDirectoryOAuth ...
	TypeActiveDirectoryOAuth Type = "ActiveDirectoryOAuth"
	// TypeBasic ...
	TypeBasic Type = "Basic"
	// TypeClientCertificate ...
	TypeClientCertificate Type = "ClientCertificate"
	// TypeHTTPAuthentication ...
	TypeHTTPAuthentication Type = "HttpAuthentication"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeActiveDirectoryOAuth, TypeBasic, TypeClientCertificate, TypeHTTPAuthentication}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// BasicAuthentication ...
type BasicAuthentication struct {
	// Username - Gets or sets the username.
	Username *string `json:"username,omitempty"`
	// Password - Gets or sets the password, return value will always be empty.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeHTTPAuthentication', 'TypeClientCertificate', 'TypeBasic', 'TypeActiveDirectoryOAuth'
	Type Type `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// MarshalJSON is the custom marshaler for BasicAuthentication.
func (ba BasicAuthentication) MarshalJSON() ([]byte, error) {
	ba.Type = TypeBasic
	objectMap := make(map[string]interface{})
	if ba.Username != nil {
		objectMap["username"] = ba.Username
	}
	if ba.Password != nil {
		objectMap["password"] = ba.Password
	}
	if ba.Type != "" {
		objectMap["type"] = ba.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsClientCertAuthentication is the BasicHTTPAuthentication implementation for BasicAuthentication.
func (ba BasicAuthentication) AsClientCertAuthentication() (*ClientCertAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsBasicAuthentication is the BasicHTTPAuthentication implementation for BasicAuthentication.
func (ba BasicAuthentication) AsBasicAuthentication() (*BasicAuthentication, bool) {
	return &ba, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsOAuthAuthentication is the BasicHTTPAuthentication implementation for BasicAuthentication.
func (ba BasicAuthentication) AsOAuthAuthentication() (*OAuthAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsHTTPAuthentication is the BasicHTTPAuthentication implementation for BasicAuthentication.
func (ba BasicAuthentication) AsHTTPAuthentication() (*HTTPAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsBasicHTTPAuthentication is the BasicHTTPAuthentication implementation for BasicAuthentication.
func (ba BasicAuthentication) AsBasicHTTPAuthentication() (BasicHTTPAuthentication, bool) {
	return &ba, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// ClientCertAuthentication ...
type ClientCertAuthentication struct {
	// Password - Gets or sets the certificate password, return value will always be empty.
	Password *string `json:"password,omitempty"`
	// Pfx - Gets or sets the pfx certificate. Accepts certification in base64 encoding, return value will always be empty.
	Pfx *string `json:"pfx,omitempty"`
	// CertificateThumbprint - Gets or sets the certificate thumbprint.
	CertificateThumbprint *string `json:"certificateThumbprint,omitempty"`
	// CertificateExpirationDate - Gets or sets the certificate expiration date.
	CertificateExpirationDate *date.Time `json:"certificateExpirationDate,omitempty"`
	// CertificateSubjectName - Gets or sets the certificate subject name.
	CertificateSubjectName *string `json:"certificateSubjectName,omitempty"`
	// Type - Possible values include: 'TypeHTTPAuthentication', 'TypeClientCertificate', 'TypeBasic', 'TypeActiveDirectoryOAuth'
	Type Type `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// MarshalJSON is the custom marshaler for ClientCertAuthentication.
func (cca ClientCertAuthentication) MarshalJSON() ([]byte, error) {
	cca.Type = TypeClientCertificate
	objectMap := make(map[string]interface{})
	if cca.Password != nil {
		objectMap["password"] = cca.Password
	}
	if cca.Pfx != nil {
		objectMap["pfx"] = cca.Pfx
	}
	if cca.CertificateThumbprint != nil {
		objectMap["certificateThumbprint"] = cca.CertificateThumbprint
	}
	if cca.CertificateExpirationDate != nil {
		objectMap["certificateExpirationDate"] = cca.CertificateExpirationDate
	}
	if cca.CertificateSubjectName != nil {
		objectMap["certificateSubjectName"] = cca.CertificateSubjectName
	}
	if cca.Type != "" {
		objectMap["type"] = cca.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsClientCertAuthentication is the BasicHTTPAuthentication implementation for ClientCertAuthentication.
func (cca ClientCertAuthentication) AsClientCertAuthentication() (*ClientCertAuthentication, bool) {
	return &cca, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsBasicAuthentication is the BasicHTTPAuthentication implementation for ClientCertAuthentication.
func (cca ClientCertAuthentication) AsBasicAuthentication() (*BasicAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsOAuthAuthentication is the BasicHTTPAuthentication implementation for ClientCertAuthentication.
func (cca ClientCertAuthentication) AsOAuthAuthentication() (*OAuthAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsHTTPAuthentication is the BasicHTTPAuthentication implementation for ClientCertAuthentication.
func (cca ClientCertAuthentication) AsHTTPAuthentication() (*HTTPAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsBasicHTTPAuthentication is the BasicHTTPAuthentication implementation for ClientCertAuthentication.
func (cca ClientCertAuthentication) AsBasicHTTPAuthentication() (BasicHTTPAuthentication, bool) {
	return &cca, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// BasicHTTPAuthentication ...
type BasicHTTPAuthentication interface {
	AsClientCertAuthentication() (*ClientCertAuthentication, bool)
	AsBasicAuthentication() (*BasicAuthentication, bool)
	AsOAuthAuthentication() (*OAuthAuthentication, bool)
	AsHTTPAuthentication() (*HTTPAuthentication, bool)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// HTTPAuthentication ...
type HTTPAuthentication struct {
	// Type - Possible values include: 'TypeHTTPAuthentication', 'TypeClientCertificate', 'TypeBasic', 'TypeActiveDirectoryOAuth'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicHTTPAuthentication(body []byte) (BasicHTTPAuthentication, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeClientCertificate):
		var cca ClientCertAuthentication
		err := json.Unmarshal(body, &cca)
		return cca, err
	case string(TypeBasic):
		var ba BasicAuthentication
		err := json.Unmarshal(body, &ba)
		return ba, err
	case string(TypeActiveDirectoryOAuth):
		var oaa OAuthAuthentication
		err := json.Unmarshal(body, &oaa)
		return oaa, err
	default:
		var ha HTTPAuthentication
		err := json.Unmarshal(body, &ha)
		return ha, err
	}
}
func unmarshalBasicHTTPAuthenticationArray(body []byte) ([]BasicHTTPAuthentication, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	haArray := make([]BasicHTTPAuthentication, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ha, err := unmarshalBasicHTTPAuthentication(*rawMessage)
		if err != nil {
			return nil, err
		}
		haArray[index] = ha
	}
	return haArray, nil
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// MarshalJSON is the custom marshaler for HTTPAuthentication.
func (ha HTTPAuthentication) MarshalJSON() ([]byte, error) {
	ha.Type = TypeHTTPAuthentication
	objectMap := make(map[string]interface{})
	if ha.Type != "" {
		objectMap["type"] = ha.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsClientCertAuthentication is the BasicHTTPAuthentication implementation for HTTPAuthentication.
func (ha HTTPAuthentication) AsClientCertAuthentication() (*ClientCertAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsBasicAuthentication is the BasicHTTPAuthentication implementation for HTTPAuthentication.
func (ha HTTPAuthentication) AsBasicAuthentication() (*BasicAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsOAuthAuthentication is the BasicHTTPAuthentication implementation for HTTPAuthentication.
func (ha HTTPAuthentication) AsOAuthAuthentication() (*OAuthAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsHTTPAuthentication is the BasicHTTPAuthentication implementation for HTTPAuthentication.
func (ha HTTPAuthentication) AsHTTPAuthentication() (*HTTPAuthentication, bool) {
	return &ha, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsBasicHTTPAuthentication is the BasicHTTPAuthentication implementation for HTTPAuthentication.
func (ha HTTPAuthentication) AsBasicHTTPAuthentication() (BasicHTTPAuthentication, bool) {
	return &ha, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// HTTPRequest ...
type HTTPRequest struct {
	// Authentication - Gets or sets the authentication method of the request.
	Authentication BasicHTTPAuthentication `json:"authentication,omitempty"`
	// URI - Gets or sets the URI of the request.
	URI *string `json:"uri,omitempty"`
	// Method - Gets or sets the method of the request.
	Method *string `json:"method,omitempty"`
	// Body - Gets or sets the request body.
	Body *string `json:"body,omitempty"`
	// Headers - Gets or sets the headers.
	Headers map[string]*string `json:"headers"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// MarshalJSON is the custom marshaler for HTTPRequest.
func (hr HTTPRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["authentication"] = hr.Authentication
	if hr.URI != nil {
		objectMap["uri"] = hr.URI
	}
	if hr.Method != nil {
		objectMap["method"] = hr.Method
	}
	if hr.Body != nil {
		objectMap["body"] = hr.Body
	}
	if hr.Headers != nil {
		objectMap["headers"] = hr.Headers
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// UnmarshalJSON is the custom unmarshaler for HTTPRequest struct.
func (hr *HTTPRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "authentication":
			if v != nil {
				authentication, err := unmarshalBasicHTTPAuthentication(*v)
				if err != nil {
					return err
				}
				hr.Authentication = authentication
			}
		case "uri":
			if v != nil {
				var URI string
				err = json.Unmarshal(*v, &URI)
				if err != nil {
					return err
				}
				hr.URI = &URI
			}
		case "method":
			if v != nil {
				var method string
				err = json.Unmarshal(*v, &method)
				if err != nil {
					return err
				}
				hr.Method = &method
			}
		case "body":
			if v != nil {
				var body1 string
				err = json.Unmarshal(*v, &body1)
				if err != nil {
					return err
				}
				hr.Body = &body1
			}
		case "headers":
			if v != nil {
				var headers map[string]*string
				err = json.Unmarshal(*v, &headers)
				if err != nil {
					return err
				}
				hr.Headers = headers
			}
		}
	}

	return nil
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobAction ...
type JobAction struct {
	// Type - Gets or sets the job action type. Possible values include: 'HTTP', 'HTTPS', 'StorageQueue', 'ServiceBusQueue', 'ServiceBusTopic'
	Type JobActionType `json:"type,omitempty"`
	// Request - Gets or sets the http requests.
	Request *HTTPRequest `json:"request,omitempty"`
	// QueueMessage - Gets or sets the storage queue message.
	QueueMessage *StorageQueueMessage `json:"queueMessage,omitempty"`
	// ServiceBusQueueMessage - Gets or sets the service bus queue message.
	ServiceBusQueueMessage *ServiceBusQueueMessage `json:"serviceBusQueueMessage,omitempty"`
	// ServiceBusTopicMessage - Gets or sets the service bus topic message.
	ServiceBusTopicMessage *ServiceBusTopicMessage `json:"serviceBusTopicMessage,omitempty"`
	// RetryPolicy - Gets or sets the retry policy.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`
	// ErrorAction - Gets or sets the error action.
	ErrorAction *JobErrorAction `json:"errorAction,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobCollectionDefinition ...
type JobCollectionDefinition struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Gets the job collection resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Gets the job collection resource type.
	Type *string `json:"type,omitempty"`
	// Name - Gets or sets the job collection resource name.
	Name *string `json:"name,omitempty"`
	// Location - Gets or sets the storage account location.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets the tags.
	Tags map[string]*string `json:"tags"`
	// Properties - Gets or sets the job collection properties.
	Properties *JobCollectionProperties `json:"properties,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// MarshalJSON is the custom marshaler for JobCollectionDefinition.
func (jcd JobCollectionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jcd.Name != nil {
		objectMap["name"] = jcd.Name
	}
	if jcd.Location != nil {
		objectMap["location"] = jcd.Location
	}
	if jcd.Tags != nil {
		objectMap["tags"] = jcd.Tags
	}
	if jcd.Properties != nil {
		objectMap["properties"] = jcd.Properties
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobCollectionListResult ...
type JobCollectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Gets the job collections.
	Value *[]JobCollectionDefinition `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of job collections.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobCollectionListResultIterator provides access to a complete listing of JobCollectionDefinition values.
type JobCollectionListResultIterator struct {
	i    int
	page JobCollectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCollectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobCollectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCollectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Response returns the raw server response from the last page request.
func (iter JobCollectionListResultIterator) Response() JobCollectionListResult {
	return iter.page.Response()
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCollectionListResultIterator) Value() JobCollectionDefinition {
	if !iter.page.NotDone() {
		return JobCollectionDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Creates a new instance of the JobCollectionListResultIterator type.
func NewJobCollectionListResultIterator(page JobCollectionListResultPage) JobCollectionListResultIterator {
	return JobCollectionListResultIterator{page: page}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// IsEmpty returns true if the ListResult contains no values.
func (jclr JobCollectionListResult) IsEmpty() bool {
	return jclr.Value == nil || len(*jclr.Value) == 0
}

// jobCollectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jclr JobCollectionListResult) jobCollectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jclr.NextLink == nil || len(to.String(jclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jclr.NextLink)))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobCollectionListResultPage contains a page of JobCollectionDefinition values.
type JobCollectionListResultPage struct {
	fn   func(context.Context, JobCollectionListResult) (JobCollectionListResult, error)
	jclr JobCollectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCollectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jclr)
	if err != nil {
		return err
	}
	page.jclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobCollectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCollectionListResultPage) NotDone() bool {
	return !page.jclr.IsEmpty()
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Response returns the raw server response from the last page request.
func (page JobCollectionListResultPage) Response() JobCollectionListResult {
	return page.jclr
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCollectionListResultPage) Values() []JobCollectionDefinition {
	if page.jclr.IsEmpty() {
		return nil
	}
	return *page.jclr.Value
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Creates a new instance of the JobCollectionListResultPage type.
func NewJobCollectionListResultPage(getNextPage func(context.Context, JobCollectionListResult) (JobCollectionListResult, error)) JobCollectionListResultPage {
	return JobCollectionListResultPage{fn: getNextPage}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobCollectionProperties ...
type JobCollectionProperties struct {
	// Sku - Gets or sets the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// State - Gets or sets the state. Possible values include: 'Enabled', 'Disabled', 'Suspended', 'Deleted'
	State JobCollectionState `json:"state,omitempty"`
	// Quota - Gets or sets the job collection quota.
	Quota *JobCollectionQuota `json:"quota,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobCollectionQuota ...
type JobCollectionQuota struct {
	// MaxJobCount - Gets or set the maximum job count.
	MaxJobCount *int32 `json:"maxJobCount,omitempty"`
	// MaxJobOccurrence - Gets or sets the maximum job occurrence.
	MaxJobOccurrence *int32 `json:"maxJobOccurrence,omitempty"`
	// MaxRecurrence - Gets or set the maximum recurrence.
	MaxRecurrence *JobMaxRecurrence `json:"maxRecurrence,omitempty"`
}

// JobCollectionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobCollectionsDeleteFuture struct {
	azure.Future
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobCollectionsDeleteFuture) Result(client JobCollectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "scheduler.JobCollectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("scheduler.JobCollectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobCollectionsDisableFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobCollectionsDisableFuture struct {
	azure.Future
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobCollectionsDisableFuture) Result(client JobCollectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "scheduler.JobCollectionsDisableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("scheduler.JobCollectionsDisableFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobCollectionsEnableFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobCollectionsEnableFuture struct {
	azure.Future
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobCollectionsEnableFuture) Result(client JobCollectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "scheduler.JobCollectionsEnableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("scheduler.JobCollectionsEnableFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobDefinition ...
type JobDefinition struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Gets the job resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Gets the job resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Gets the job resource name.
	Name *string `json:"name,omitempty"`
	// Properties - Gets or sets the job properties.
	Properties *JobProperties `json:"properties,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobErrorAction ...
type JobErrorAction struct {
	// Type - Gets or sets the job error action type. Possible values include: 'HTTP', 'HTTPS', 'StorageQueue', 'ServiceBusQueue', 'ServiceBusTopic'
	Type JobActionType `json:"type,omitempty"`
	// Request - Gets or sets the http requests.
	Request *HTTPRequest `json:"request,omitempty"`
	// QueueMessage - Gets or sets the storage queue message.
	QueueMessage *StorageQueueMessage `json:"queueMessage,omitempty"`
	// ServiceBusQueueMessage - Gets or sets the service bus queue message.
	ServiceBusQueueMessage *ServiceBusQueueMessage `json:"serviceBusQueueMessage,omitempty"`
	// ServiceBusTopicMessage - Gets or sets the service bus topic message.
	ServiceBusTopicMessage *ServiceBusTopicMessage `json:"serviceBusTopicMessage,omitempty"`
	// RetryPolicy - Gets or sets the retry policy.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobHistoryDefinition ...
type JobHistoryDefinition struct {
	// ID - READ-ONLY; Gets the job history identifier.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Gets the job history resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Gets the job history name.
	Name *string `json:"name,omitempty"`
	// Properties - READ-ONLY; Gets or sets the job history properties.
	Properties *JobHistoryDefinitionProperties `json:"properties,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobHistoryDefinitionProperties ...
type JobHistoryDefinitionProperties struct {
	// StartTime - READ-ONLY; Gets the start time for this job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; Gets the end time for this job.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExpectedExecutionTime - READ-ONLY; Gets the expected execution time for this job.
	ExpectedExecutionTime *date.Time `json:"expectedExecutionTime,omitempty"`
	// ActionName - READ-ONLY; Gets the job history action name. Possible values include: 'MainAction', 'ErrorAction'
	ActionName JobHistoryActionName `json:"actionName,omitempty"`
	// Status - READ-ONLY; Gets the job history status. Possible values include: 'Completed', 'Failed', 'Postponed'
	Status JobExecutionStatus `json:"status,omitempty"`
	// Message - READ-ONLY; Gets the message for the job history.
	Message *string `json:"message,omitempty"`
	// RetryCount - READ-ONLY; Gets the retry count for job.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// RepeatCount - READ-ONLY; Gets the repeat count for the job.
	RepeatCount *int32 `json:"repeatCount,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobHistoryFilter ...
type JobHistoryFilter struct {
	// Status - Gets or sets the job execution status. Possible values include: 'Completed', 'Failed', 'Postponed'
	Status JobExecutionStatus `json:"status,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobHistoryListResult ...
type JobHistoryListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the job histories under job.
	Value *[]JobHistoryDefinition `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of job histories.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobHistoryListResultIterator provides access to a complete listing of JobHistoryDefinition values.
type JobHistoryListResultIterator struct {
	i    int
	page JobHistoryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobHistoryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobHistoryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobHistoryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobHistoryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Response returns the raw server response from the last page request.
func (iter JobHistoryListResultIterator) Response() JobHistoryListResult {
	return iter.page.Response()
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobHistoryListResultIterator) Value() JobHistoryDefinition {
	if !iter.page.NotDone() {
		return JobHistoryDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Creates a new instance of the JobHistoryListResultIterator type.
func NewJobHistoryListResultIterator(page JobHistoryListResultPage) JobHistoryListResultIterator {
	return JobHistoryListResultIterator{page: page}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// IsEmpty returns true if the ListResult contains no values.
func (jhlr JobHistoryListResult) IsEmpty() bool {
	return jhlr.Value == nil || len(*jhlr.Value) == 0
}

// jobHistoryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jhlr JobHistoryListResult) jobHistoryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jhlr.NextLink == nil || len(to.String(jhlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jhlr.NextLink)))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobHistoryListResultPage contains a page of JobHistoryDefinition values.
type JobHistoryListResultPage struct {
	fn   func(context.Context, JobHistoryListResult) (JobHistoryListResult, error)
	jhlr JobHistoryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobHistoryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobHistoryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jhlr)
	if err != nil {
		return err
	}
	page.jhlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobHistoryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobHistoryListResultPage) NotDone() bool {
	return !page.jhlr.IsEmpty()
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Response returns the raw server response from the last page request.
func (page JobHistoryListResultPage) Response() JobHistoryListResult {
	return page.jhlr
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page JobHistoryListResultPage) Values() []JobHistoryDefinition {
	if page.jhlr.IsEmpty() {
		return nil
	}
	return *page.jhlr.Value
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Creates a new instance of the JobHistoryListResultPage type.
func NewJobHistoryListResultPage(getNextPage func(context.Context, JobHistoryListResult) (JobHistoryListResult, error)) JobHistoryListResultPage {
	return JobHistoryListResultPage{fn: getNextPage}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobListResult ...
type JobListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets all jobs under job collection.
	Value *[]JobDefinition `json:"value,omitempty"`
	// NextLink - Gets or sets the URL to get the next set of jobs.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobListResultIterator provides access to a complete listing of JobDefinition values.
type JobListResultIterator struct {
	i    int
	page JobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Response returns the raw server response from the last page request.
func (iter JobListResultIterator) Response() JobListResult {
	return iter.page.Response()
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListResultIterator) Value() JobDefinition {
	if !iter.page.NotDone() {
		return JobDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Creates a new instance of the JobListResultIterator type.
func NewJobListResultIterator(page JobListResultPage) JobListResultIterator {
	return JobListResultIterator{page: page}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// IsEmpty returns true if the ListResult contains no values.
func (jlr JobListResult) IsEmpty() bool {
	return jlr.Value == nil || len(*jlr.Value) == 0
}

// jobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jlr JobListResult) jobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jlr.NextLink == nil || len(to.String(jlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jlr.NextLink)))
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobListResultPage contains a page of JobDefinition values.
type JobListResultPage struct {
	fn  func(context.Context, JobListResult) (JobListResult, error)
	jlr JobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jlr)
	if err != nil {
		return err
	}
	page.jlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListResultPage) NotDone() bool {
	return !page.jlr.IsEmpty()
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Response returns the raw server response from the last page request.
func (page JobListResultPage) Response() JobListResult {
	return page.jlr
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListResultPage) Values() []JobDefinition {
	if page.jlr.IsEmpty() {
		return nil
	}
	return *page.jlr.Value
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Creates a new instance of the JobListResultPage type.
func NewJobListResultPage(getNextPage func(context.Context, JobListResult) (JobListResult, error)) JobListResultPage {
	return JobListResultPage{fn: getNextPage}
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobMaxRecurrence ...
type JobMaxRecurrence struct {
	// Frequency - Gets or sets the frequency of recurrence (second, minute, hour, day, week, month). Possible values include: 'Minute', 'Hour', 'Day', 'Week', 'Month'
	Frequency RecurrenceFrequency `json:"frequency,omitempty"`
	// Interval - Gets or sets the interval between retries.
	Interval *int32 `json:"interval,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobProperties ...
type JobProperties struct {
	// StartTime - Gets or sets the job start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Action - Gets or sets the job action.
	Action *JobAction `json:"action,omitempty"`
	// Recurrence - Gets or sets the job recurrence.
	Recurrence *JobRecurrence `json:"recurrence,omitempty"`
	// State - Gets or set the job state. Possible values include: 'JobStateEnabled', 'JobStateDisabled', 'JobStateFaulted', 'JobStateCompleted'
	State JobState `json:"state,omitempty"`
	// Status - READ-ONLY; Gets the job status.
	Status *JobStatus `json:"status,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobRecurrence ...
type JobRecurrence struct {
	// Frequency - Gets or sets the frequency of recurrence (second, minute, hour, day, week, month). Possible values include: 'Minute', 'Hour', 'Day', 'Week', 'Month'
	Frequency RecurrenceFrequency `json:"frequency,omitempty"`
	// Interval - Gets or sets the interval between retries.
	Interval *int32 `json:"interval,omitempty"`
	// Count - Gets or sets the maximum number of times that the job should run.
	Count *int32 `json:"count,omitempty"`
	// EndTime - Gets or sets the time at which the job will complete.
	EndTime  *date.Time             `json:"endTime,omitempty"`
	Schedule *JobRecurrenceSchedule `json:"schedule,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobRecurrenceSchedule ...
type JobRecurrenceSchedule struct {
	// WeekDays - Gets or sets the days of the week that the job should execute on.
	WeekDays *[]DayOfWeek `json:"weekDays,omitempty"`
	// Hours - Gets or sets the hours of the day that the job should execute at.
	Hours *[]int32 `json:"hours,omitempty"`
	// Minutes - Gets or sets the minutes of the hour that the job should execute at.
	Minutes *[]int32 `json:"minutes,omitempty"`
	// MonthDays - Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
	MonthDays *[]int32 `json:"monthDays,omitempty"`
	// MonthlyOccurrences - Gets or sets the occurrences of days within a month.
	MonthlyOccurrences *[]JobRecurrenceScheduleMonthlyOccurrence `json:"monthlyOccurrences,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobRecurrenceScheduleMonthlyOccurrence ...
type JobRecurrenceScheduleMonthlyOccurrence struct {
	// Day - Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday. Possible values include: 'JobScheduleDayMonday', 'JobScheduleDayTuesday', 'JobScheduleDayWednesday', 'JobScheduleDayThursday', 'JobScheduleDayFriday', 'JobScheduleDaySaturday', 'JobScheduleDaySunday'
	Day JobScheduleDay `json:"day,omitempty"`
	// Occurrence - Gets or sets the occurrence. Must be between -5 and 5.
	Occurrence *int32 `json:"Occurrence,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobStateFilter ...
type JobStateFilter struct {
	// State - Gets or sets the job state. Possible values include: 'JobStateEnabled', 'JobStateDisabled', 'JobStateFaulted', 'JobStateCompleted'
	State JobState `json:"state,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// JobStatus ...
type JobStatus struct {
	// ExecutionCount - READ-ONLY; Gets the number of times this job has executed.
	ExecutionCount *int32 `json:"executionCount,omitempty"`
	// FailureCount - READ-ONLY; Gets the number of times this job has failed.
	FailureCount *int32 `json:"failureCount,omitempty"`
	// FaultedCount - READ-ONLY; Gets the number of faulted occurrences (occurrences that were retried and failed as many times as the retry policy states).
	FaultedCount *int32 `json:"faultedCount,omitempty"`
	// LastExecutionTime - READ-ONLY; Gets the time the last occurrence executed in ISO-8601 format.  Could be empty if job has not run yet.
	LastExecutionTime *date.Time `json:"lastExecutionTime,omitempty"`
	// NextExecutionTime - READ-ONLY; Gets the time of the next occurrence in ISO-8601 format. Could be empty if the job is completed.
	NextExecutionTime *date.Time `json:"nextExecutionTime,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// OAuthAuthentication ...
type OAuthAuthentication struct {
	// Secret - Gets or sets the secret, return value will always be empty.
	Secret *string `json:"secret,omitempty"`
	// Tenant - Gets or sets the tenant.
	Tenant *string `json:"tenant,omitempty"`
	// Audience - Gets or sets the audience.
	Audience *string `json:"audience,omitempty"`
	// ClientID - Gets or sets the client identifier.
	ClientID *string `json:"clientId,omitempty"`
	// Type - Possible values include: 'TypeHTTPAuthentication', 'TypeClientCertificate', 'TypeBasic', 'TypeActiveDirectoryOAuth'
	Type Type `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// MarshalJSON is the custom marshaler for OAuthAuthentication.
func (oaa OAuthAuthentication) MarshalJSON() ([]byte, error) {
	oaa.Type = TypeActiveDirectoryOAuth
	objectMap := make(map[string]interface{})
	if oaa.Secret != nil {
		objectMap["secret"] = oaa.Secret
	}
	if oaa.Tenant != nil {
		objectMap["tenant"] = oaa.Tenant
	}
	if oaa.Audience != nil {
		objectMap["audience"] = oaa.Audience
	}
	if oaa.ClientID != nil {
		objectMap["clientId"] = oaa.ClientID
	}
	if oaa.Type != "" {
		objectMap["type"] = oaa.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsClientCertAuthentication is the BasicHTTPAuthentication implementation for OAuthAuthentication.
func (oaa OAuthAuthentication) AsClientCertAuthentication() (*ClientCertAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsBasicAuthentication is the BasicHTTPAuthentication implementation for OAuthAuthentication.
func (oaa OAuthAuthentication) AsBasicAuthentication() (*BasicAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsOAuthAuthentication is the BasicHTTPAuthentication implementation for OAuthAuthentication.
func (oaa OAuthAuthentication) AsOAuthAuthentication() (*OAuthAuthentication, bool) {
	return &oaa, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsHTTPAuthentication is the BasicHTTPAuthentication implementation for OAuthAuthentication.
func (oaa OAuthAuthentication) AsHTTPAuthentication() (*HTTPAuthentication, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// AsBasicHTTPAuthentication is the BasicHTTPAuthentication implementation for OAuthAuthentication.
func (oaa OAuthAuthentication) AsBasicHTTPAuthentication() (BasicHTTPAuthentication, bool) {
	return &oaa, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// RetryPolicy ...
type RetryPolicy struct {
	// RetryType - Gets or sets the retry strategy to be used. Possible values include: 'None', 'Fixed'
	RetryType RetryType `json:"retryType,omitempty"`
	// RetryInterval - Gets or sets the retry interval between retries, specify duration in ISO 8601 format.
	RetryInterval *string `json:"retryInterval,omitempty"`
	// RetryCount - Gets or sets the number of times a retry should be attempted.
	RetryCount *int32 `json:"retryCount,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// ServiceBusAuthentication ...
type ServiceBusAuthentication struct {
	// SasKey - Gets or sets the SAS key.
	SasKey *string `json:"sasKey,omitempty"`
	// SasKeyName - Gets or sets the SAS key name.
	SasKeyName *string `json:"sasKeyName,omitempty"`
	// Type - Gets or sets the authentication type. Possible values include: 'NotSpecified', 'SharedAccessKey'
	Type ServiceBusAuthenticationType `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// ServiceBusBrokeredMessageProperties ...
type ServiceBusBrokeredMessageProperties struct {
	// ContentType - Gets or sets the content type.
	ContentType *string `json:"contentType,omitempty"`
	// CorrelationID - Gets or sets the correlation ID.
	CorrelationID *string `json:"correlationId,omitempty"`
	// ForcePersistence - Gets or sets the force persistence.
	ForcePersistence *bool `json:"forcePersistence,omitempty"`
	// Label - Gets or sets the label.
	Label *string `json:"label,omitempty"`
	// MessageID - Gets or sets the message ID.
	MessageID *string `json:"messageId,omitempty"`
	// PartitionKey - Gets or sets the partition key.
	PartitionKey *string `json:"partitionKey,omitempty"`
	// ReplyTo - Gets or sets the reply to.
	ReplyTo *string `json:"replyTo,omitempty"`
	// ReplyToSessionID - Gets or sets the reply to session ID.
	ReplyToSessionID *string `json:"replyToSessionId,omitempty"`
	// ScheduledEnqueueTimeUtc - Gets or sets the scheduled enqueue time UTC.
	ScheduledEnqueueTimeUtc *date.Time `json:"scheduledEnqueueTimeUtc,omitempty"`
	// SessionID - Gets or sets the session ID.
	SessionID *string `json:"sessionId,omitempty"`
	// TimeToLive - Gets or sets the time to live.
	TimeToLive *string `json:"timeToLive,omitempty"`
	// To - Gets or sets the to.
	To *string `json:"to,omitempty"`
	// ViaPartitionKey - Gets or sets the via partition key.
	ViaPartitionKey *string `json:"viaPartitionKey,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// ServiceBusMessage ...
type ServiceBusMessage struct {
	// Authentication - Gets or sets the Service Bus authentication.
	Authentication *ServiceBusAuthentication `json:"authentication,omitempty"`
	// BrokeredMessageProperties - Gets or sets the brokered message properties.
	BrokeredMessageProperties *ServiceBusBrokeredMessageProperties `json:"brokeredMessageProperties,omitempty"`
	// CustomMessageProperties - Gets or sets the custom message properties.
	CustomMessageProperties map[string]*string `json:"customMessageProperties"`
	// Message - Gets or sets the message.
	Message *string `json:"message,omitempty"`
	// Namespace - Gets or sets the namespace.
	Namespace *string `json:"namespace,omitempty"`
	// TransportType - Gets or sets the transport type. Possible values include: 'ServiceBusTransportTypeNotSpecified', 'ServiceBusTransportTypeNetMessaging', 'ServiceBusTransportTypeAMQP'
	TransportType ServiceBusTransportType `json:"transportType,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// MarshalJSON is the custom marshaler for ServiceBusMessage.
func (sbm ServiceBusMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbm.Authentication != nil {
		objectMap["authentication"] = sbm.Authentication
	}
	if sbm.BrokeredMessageProperties != nil {
		objectMap["brokeredMessageProperties"] = sbm.BrokeredMessageProperties
	}
	if sbm.CustomMessageProperties != nil {
		objectMap["customMessageProperties"] = sbm.CustomMessageProperties
	}
	if sbm.Message != nil {
		objectMap["message"] = sbm.Message
	}
	if sbm.Namespace != nil {
		objectMap["namespace"] = sbm.Namespace
	}
	if sbm.TransportType != "" {
		objectMap["transportType"] = sbm.TransportType
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// ServiceBusQueueMessage ...
type ServiceBusQueueMessage struct {
	// QueueName - Gets or sets the queue name.
	QueueName *string `json:"queueName,omitempty"`
	// Authentication - Gets or sets the Service Bus authentication.
	Authentication *ServiceBusAuthentication `json:"authentication,omitempty"`
	// BrokeredMessageProperties - Gets or sets the brokered message properties.
	BrokeredMessageProperties *ServiceBusBrokeredMessageProperties `json:"brokeredMessageProperties,omitempty"`
	// CustomMessageProperties - Gets or sets the custom message properties.
	CustomMessageProperties map[string]*string `json:"customMessageProperties"`
	// Message - Gets or sets the message.
	Message *string `json:"message,omitempty"`
	// Namespace - Gets or sets the namespace.
	Namespace *string `json:"namespace,omitempty"`
	// TransportType - Gets or sets the transport type. Possible values include: 'ServiceBusTransportTypeNotSpecified', 'ServiceBusTransportTypeNetMessaging', 'ServiceBusTransportTypeAMQP'
	TransportType ServiceBusTransportType `json:"transportType,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// MarshalJSON is the custom marshaler for ServiceBusQueueMessage.
func (sbqm ServiceBusQueueMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbqm.QueueName != nil {
		objectMap["queueName"] = sbqm.QueueName
	}
	if sbqm.Authentication != nil {
		objectMap["authentication"] = sbqm.Authentication
	}
	if sbqm.BrokeredMessageProperties != nil {
		objectMap["brokeredMessageProperties"] = sbqm.BrokeredMessageProperties
	}
	if sbqm.CustomMessageProperties != nil {
		objectMap["customMessageProperties"] = sbqm.CustomMessageProperties
	}
	if sbqm.Message != nil {
		objectMap["message"] = sbqm.Message
	}
	if sbqm.Namespace != nil {
		objectMap["namespace"] = sbqm.Namespace
	}
	if sbqm.TransportType != "" {
		objectMap["transportType"] = sbqm.TransportType
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// ServiceBusTopicMessage ...
type ServiceBusTopicMessage struct {
	// TopicPath - Gets or sets the topic path.
	TopicPath *string `json:"topicPath,omitempty"`
	// Authentication - Gets or sets the Service Bus authentication.
	Authentication *ServiceBusAuthentication `json:"authentication,omitempty"`
	// BrokeredMessageProperties - Gets or sets the brokered message properties.
	BrokeredMessageProperties *ServiceBusBrokeredMessageProperties `json:"brokeredMessageProperties,omitempty"`
	// CustomMessageProperties - Gets or sets the custom message properties.
	CustomMessageProperties map[string]*string `json:"customMessageProperties"`
	// Message - Gets or sets the message.
	Message *string `json:"message,omitempty"`
	// Namespace - Gets or sets the namespace.
	Namespace *string `json:"namespace,omitempty"`
	// TransportType - Gets or sets the transport type. Possible values include: 'ServiceBusTransportTypeNotSpecified', 'ServiceBusTransportTypeNetMessaging', 'ServiceBusTransportTypeAMQP'
	TransportType ServiceBusTransportType `json:"transportType,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// MarshalJSON is the custom marshaler for ServiceBusTopicMessage.
func (sbtm ServiceBusTopicMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbtm.TopicPath != nil {
		objectMap["topicPath"] = sbtm.TopicPath
	}
	if sbtm.Authentication != nil {
		objectMap["authentication"] = sbtm.Authentication
	}
	if sbtm.BrokeredMessageProperties != nil {
		objectMap["brokeredMessageProperties"] = sbtm.BrokeredMessageProperties
	}
	if sbtm.CustomMessageProperties != nil {
		objectMap["customMessageProperties"] = sbtm.CustomMessageProperties
	}
	if sbtm.Message != nil {
		objectMap["message"] = sbtm.Message
	}
	if sbtm.Namespace != nil {
		objectMap["namespace"] = sbtm.Namespace
	}
	if sbtm.TransportType != "" {
		objectMap["transportType"] = sbtm.TransportType
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// Sku ...
type Sku struct {
	// Name - Gets or set the SKU. Possible values include: 'Standard', 'Free', 'P10Premium', 'P20Premium'
	Name SkuDefinition `json:"name,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2016-06-01/logic instead.
// StorageQueueMessage ...
type StorageQueueMessage struct {
	// StorageAccount - Gets or sets the storage account name.
	StorageAccount *string `json:"storageAccount,omitempty"`
	// QueueName - Gets or sets the queue name.
	QueueName *string `json:"queueName,omitempty"`
	// SasToken - Gets or sets the SAS key.
	SasToken *string `json:"sasToken,omitempty"`
	// Message - Gets or sets the message.
	Message *string `json:"message,omitempty"`
}
