package softwareplanapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/softwareplan/mgmt/2019-06-01-preview/softwareplan"
	"github.com/Azure/go-autorest/autorest"
)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	Register(ctx context.Context) (result autorest.Response, err error)
}

var _ ClientAPI = (*softwareplan.Client)(nil)

// HybridUseBenefitClientAPI contains the set of methods on the HybridUseBenefitClient type.
type HybridUseBenefitClientAPI interface {
	Create(ctx context.Context, scope string, planID string, body softwareplan.HybridUseBenefitModel) (result softwareplan.HybridUseBenefitModel, err error)
	Delete(ctx context.Context, scope string, planID string) (result autorest.Response, err error)
	Get(ctx context.Context, scope string, planID string) (result softwareplan.HybridUseBenefitModel, err error)
	List(ctx context.Context, scope string, filter string) (result softwareplan.HybridUseBenefitListResultPage, err error)
	Update(ctx context.Context, scope string, planID string, body softwareplan.HybridUseBenefitModel) (result softwareplan.HybridUseBenefitModel, err error)
}

var _ HybridUseBenefitClientAPI = (*softwareplan.HybridUseBenefitClient)(nil)

// HybridUseBenefitRevisionClientAPI contains the set of methods on the HybridUseBenefitRevisionClient type.
type HybridUseBenefitRevisionClientAPI interface {
	List(ctx context.Context, scope string, planID string) (result softwareplan.HybridUseBenefitListResultPage, err error)
}

var _ HybridUseBenefitRevisionClientAPI = (*softwareplan.HybridUseBenefitRevisionClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context, scope string) (result softwareplan.OperationListPage, err error)
}

var _ OperationsClientAPI = (*softwareplan.OperationsClient)(nil)
