// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/datatransfer/v1/transfer.proto

package datatransfer

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// DEPRECATED. Represents data transfer type.
type TransferType int32 // Deprecated: Do not use.
const (
	// Invalid or Unknown transfer type placeholder.
	TransferType_TRANSFER_TYPE_UNSPECIFIED TransferType = 0
	// Batch data transfer.
	TransferType_BATCH TransferType = 1
	// Streaming data transfer. Streaming data source currently doesn't
	// support multiple transfer configs per project.
	TransferType_STREAMING TransferType = 2
)

var TransferType_name = map[int32]string{
	0: "TRANSFER_TYPE_UNSPECIFIED",
	1: "BATCH",
	2: "STREAMING",
}

var TransferType_value = map[string]int32{
	"TRANSFER_TYPE_UNSPECIFIED": 0,
	"BATCH":                     1,
	"STREAMING":                 2,
}

func (x TransferType) String() string {
	return proto.EnumName(TransferType_name, int32(x))
}

func (TransferType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_90c2574420b818ad, []int{0}
}

// Represents data transfer run state.
type TransferState int32

const (
	// State placeholder.
	TransferState_TRANSFER_STATE_UNSPECIFIED TransferState = 0
	// Data transfer is scheduled and is waiting to be picked up by
	// data transfer backend.
	TransferState_PENDING TransferState = 2
	// Data transfer is in progress.
	TransferState_RUNNING TransferState = 3
	// Data transfer completed successfully.
	TransferState_SUCCEEDED TransferState = 4
	// Data transfer failed.
	TransferState_FAILED TransferState = 5
	// Data transfer is cancelled.
	TransferState_CANCELLED TransferState = 6
)

var TransferState_name = map[int32]string{
	0: "TRANSFER_STATE_UNSPECIFIED",
	2: "PENDING",
	3: "RUNNING",
	4: "SUCCEEDED",
	5: "FAILED",
	6: "CANCELLED",
}

var TransferState_value = map[string]int32{
	"TRANSFER_STATE_UNSPECIFIED": 0,
	"PENDING":                    2,
	"RUNNING":                    3,
	"SUCCEEDED":                  4,
	"FAILED":                     5,
	"CANCELLED":                  6,
}

func (x TransferState) String() string {
	return proto.EnumName(TransferState_name, int32(x))
}

func (TransferState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_90c2574420b818ad, []int{1}
}

// Represents data transfer user facing message severity.
type TransferMessage_MessageSeverity int32

const (
	// No severity specified.
	TransferMessage_MESSAGE_SEVERITY_UNSPECIFIED TransferMessage_MessageSeverity = 0
	// Informational message.
	TransferMessage_INFO TransferMessage_MessageSeverity = 1
	// Warning message.
	TransferMessage_WARNING TransferMessage_MessageSeverity = 2
	// Error message.
	TransferMessage_ERROR TransferMessage_MessageSeverity = 3
	// Debug message.
	TransferMessage_DEBUG TransferMessage_MessageSeverity = 4
)

var TransferMessage_MessageSeverity_name = map[int32]string{
	0: "MESSAGE_SEVERITY_UNSPECIFIED",
	1: "INFO",
	2: "WARNING",
	3: "ERROR",
	4: "DEBUG",
}

var TransferMessage_MessageSeverity_value = map[string]int32{
	"MESSAGE_SEVERITY_UNSPECIFIED": 0,
	"INFO":                         1,
	"WARNING":                      2,
	"ERROR":                        3,
	"DEBUG":                        4,
}

func (x TransferMessage_MessageSeverity) String() string {
	return proto.EnumName(TransferMessage_MessageSeverity_name, int32(x))
}

func (TransferMessage_MessageSeverity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_90c2574420b818ad, []int{3, 0}
}

// Options customizing the data transfer schedule.
type ScheduleOptions struct {
	// If true, automatic scheduling of data transfer runs for this configuration
	// will be disabled. The runs can be started on ad-hoc basis using
	// StartManualTransferRuns API. When automatic scheduling is disabled, the
	// TransferConfig.schedule field will be ignored.
	DisableAutoScheduling bool `protobuf:"varint,3,opt,name=disable_auto_scheduling,json=disableAutoScheduling,proto3" json:"disable_auto_scheduling,omitempty"`
	// Specifies time to start scheduling transfer runs. The first run will be
	// scheduled at or after the start time according to a recurrence pattern
	// defined in the schedule string. The start time can be changed at any
	// moment. The time when a data transfer can be trigerred manually is not
	// limited by this option.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Defines time to stop scheduling transfer runs. A transfer run cannot be
	// scheduled at or after the end time. The end time can be changed at any
	// moment. The time when a data transfer can be trigerred manually is not
	// limited by this option.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ScheduleOptions) Reset()         { *m = ScheduleOptions{} }
func (m *ScheduleOptions) String() string { return proto.CompactTextString(m) }
func (*ScheduleOptions) ProtoMessage()    {}
func (*ScheduleOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_90c2574420b818ad, []int{0}
}

func (m *ScheduleOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScheduleOptions.Unmarshal(m, b)
}
func (m *ScheduleOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScheduleOptions.Marshal(b, m, deterministic)
}
func (m *ScheduleOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScheduleOptions.Merge(m, src)
}
func (m *ScheduleOptions) XXX_Size() int {
	return xxx_messageInfo_ScheduleOptions.Size(m)
}
func (m *ScheduleOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ScheduleOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ScheduleOptions proto.InternalMessageInfo

func (m *ScheduleOptions) GetDisableAutoScheduling() bool {
	if m != nil {
		return m.DisableAutoScheduling
	}
	return false
}

func (m *ScheduleOptions) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ScheduleOptions) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Represents a data transfer configuration. A transfer configuration
// contains all metadata needed to perform a data transfer. For example,
// `destination_dataset_id` specifies where data should be stored.
// When a new transfer configuration is created, the specified
// `destination_dataset_id` is created when needed and shared with the
// appropriate data source service account.
type TransferConfig struct {
	// The resource name of the transfer config.
	// Transfer config names have the form of
	// `projects/{project_id}/locations/{region}/transferConfigs/{config_id}`.
	// The name is automatically generated based on the config_id specified in
	// CreateTransferConfigRequest along with project_id and region. If config_id
	// is not provided, usually a uuid, even though it is not guaranteed or
	// required, will be generated for config_id.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The BigQuery target dataset id.
	DestinationDatasetId string `protobuf:"bytes,2,opt,name=destination_dataset_id,json=destinationDatasetId,proto3" json:"destination_dataset_id,omitempty"`
	// User specified display name for the data transfer.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Data source id. Cannot be changed once data transfer is created.
	DataSourceId string `protobuf:"bytes,5,opt,name=data_source_id,json=dataSourceId,proto3" json:"data_source_id,omitempty"`
	// Data transfer specific parameters.
	Params *_struct.Struct `protobuf:"bytes,9,opt,name=params,proto3" json:"params,omitempty"`
	// Data transfer schedule.
	// If the data source does not support a custom schedule, this should be
	// empty. If it is empty, the default value for the data source will be
	// used.
	// The specified times are in UTC.
	// Examples of valid format:
	// `1st,3rd monday of month 15:30`,
	// `every wed,fri of jan,jun 13:15`, and
	// `first sunday of quarter 00:00`.
	// See more explanation about the format here:
	// https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
	// NOTE: the granularity should be at least 8 hours, or less frequent.
	Schedule string `protobuf:"bytes,7,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Options customizing the data transfer schedule.
	ScheduleOptions *ScheduleOptions `protobuf:"bytes,24,opt,name=schedule_options,json=scheduleOptions,proto3" json:"schedule_options,omitempty"`
	// The number of days to look back to automatically refresh the data.
	// For example, if `data_refresh_window_days = 10`, then every day
	// BigQuery reingests data for [today-10, today-1], rather than ingesting data
	// for just [today-1].
	// Only valid if the data source supports the feature. Set the value to  0
	// to use the default value.
	DataRefreshWindowDays int32 `protobuf:"varint,12,opt,name=data_refresh_window_days,json=dataRefreshWindowDays,proto3" json:"data_refresh_window_days,omitempty"`
	// Is this config disabled. When set to true, no runs are scheduled
	// for a given transfer.
	Disabled bool `protobuf:"varint,13,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Output only. Data transfer modification time. Ignored by server on input.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Next time when data transfer will run.
	NextRunTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=next_run_time,json=nextRunTime,proto3" json:"next_run_time,omitempty"`
	// Output only. State of the most recently updated transfer run.
	State TransferState `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferState" json:"state,omitempty"`
	// Deprecated. Unique ID of the user on whose behalf transfer is done.
	UserId int64 `protobuf:"varint,11,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Output only. Region in which BigQuery dataset is located.
	DatasetRegion string `protobuf:"bytes,14,opt,name=dataset_region,json=datasetRegion,proto3" json:"dataset_region,omitempty"`
	// A unique identifier used for identifying a transfer setup stored on
	// external partner side. The token is opaque to DTS and can only be
	// interpreted by partner. Partner data source should create a mapping between
	// the config id and the token to validate that a transfer config/run is
	// legitimate.
	PartnerToken string `protobuf:"bytes,22,opt,name=partner_token,json=partnerToken,proto3" json:"partner_token,omitempty"`
	// Transfer settings managed by partner data sources. It is stored as
	// key-value pairs and used for DTS UI display purpose only. Two reasons we
	// don't want to store them together with 'params' are:
	//  - The connection info is provided by partner and not editable in DTS UI
	//    which is different from the immutable parameter. It will be confusing to
	//    add another boolean to DataSourceParameter to differentiate them.
	//  - The connection info can be any arbitrary key-value pairs. Adding them to
	//    params fields requires partner to provide definition for them in data
	//    source definition. It will be friendlier to avoid that for partners.
	PartnerConnectionInfo *_struct.Struct `protobuf:"bytes,23,opt,name=partner_connection_info,json=partnerConnectionInfo,proto3" json:"partner_connection_info,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}        `json:"-"`
	XXX_unrecognized      []byte          `json:"-"`
	XXX_sizecache         int32           `json:"-"`
}

func (m *TransferConfig) Reset()         { *m = TransferConfig{} }
func (m *TransferConfig) String() string { return proto.CompactTextString(m) }
func (*TransferConfig) ProtoMessage()    {}
func (*TransferConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_90c2574420b818ad, []int{1}
}

func (m *TransferConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransferConfig.Unmarshal(m, b)
}
func (m *TransferConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransferConfig.Marshal(b, m, deterministic)
}
func (m *TransferConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransferConfig.Merge(m, src)
}
func (m *TransferConfig) XXX_Size() int {
	return xxx_messageInfo_TransferConfig.Size(m)
}
func (m *TransferConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TransferConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TransferConfig proto.InternalMessageInfo

func (m *TransferConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TransferConfig) GetDestinationDatasetId() string {
	if m != nil {
		return m.DestinationDatasetId
	}
	return ""
}

func (m *TransferConfig) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *TransferConfig) GetDataSourceId() string {
	if m != nil {
		return m.DataSourceId
	}
	return ""
}

func (m *TransferConfig) GetParams() *_struct.Struct {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *TransferConfig) GetSchedule() string {
	if m != nil {
		return m.Schedule
	}
	return ""
}

func (m *TransferConfig) GetScheduleOptions() *ScheduleOptions {
	if m != nil {
		return m.ScheduleOptions
	}
	return nil
}

func (m *TransferConfig) GetDataRefreshWindowDays() int32 {
	if m != nil {
		return m.DataRefreshWindowDays
	}
	return 0
}

func (m *TransferConfig) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

func (m *TransferConfig) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *TransferConfig) GetNextRunTime() *timestamp.Timestamp {
	if m != nil {
		return m.NextRunTime
	}
	return nil
}

func (m *TransferConfig) GetState() TransferState {
	if m != nil {
		return m.State
	}
	return TransferState_TRANSFER_STATE_UNSPECIFIED
}

func (m *TransferConfig) GetUserId() int64 {
	if m != nil {
		return m.UserId
	}
	return 0
}

func (m *TransferConfig) GetDatasetRegion() string {
	if m != nil {
		return m.DatasetRegion
	}
	return ""
}

func (m *TransferConfig) GetPartnerToken() string {
	if m != nil {
		return m.PartnerToken
	}
	return ""
}

func (m *TransferConfig) GetPartnerConnectionInfo() *_struct.Struct {
	if m != nil {
		return m.PartnerConnectionInfo
	}
	return nil
}

// Represents a data transfer run.
type TransferRun struct {
	// The resource name of the transfer run.
	// Transfer run names have the form
	// `projects/{project_id}/locations/{location}/transferConfigs/{config_id}/runs/{run_id}`.
	// The name is ignored when creating a transfer run.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User labels.
	Labels map[string]string `protobuf:"bytes,22,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Minimum time after which a transfer run can be started.
	ScheduleTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=schedule_time,json=scheduleTime,proto3" json:"schedule_time,omitempty"`
	// For batch transfer runs, specifies the date and time that
	// data should be ingested.
	RunTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=run_time,json=runTime,proto3" json:"run_time,omitempty"`
	// Status of the transfer run.
	ErrorStatus *status.Status `protobuf:"bytes,21,opt,name=error_status,json=errorStatus,proto3" json:"error_status,omitempty"`
	// Output only. Time when transfer run was started.
	// Parameter ignored by server for input requests.
	StartTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time when transfer run ended.
	// Parameter ignored by server for input requests.
	EndTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Last time the data transfer run state was updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Data transfer specific parameters.
	Params *_struct.Struct `protobuf:"bytes,9,opt,name=params,proto3" json:"params,omitempty"`
	// Output only. The BigQuery target dataset id.
	DestinationDatasetId string `protobuf:"bytes,2,opt,name=destination_dataset_id,json=destinationDatasetId,proto3" json:"destination_dataset_id,omitempty"`
	// Output only. Data source id.
	DataSourceId string `protobuf:"bytes,7,opt,name=data_source_id,json=dataSourceId,proto3" json:"data_source_id,omitempty"`
	// Data transfer run state. Ignored for input requests.
	State TransferState `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferState" json:"state,omitempty"`
	// Deprecated. Unique ID of the user on whose behalf transfer is done.
	UserId int64 `protobuf:"varint,11,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Output only. Describes the schedule of this transfer run if it was
	// created as part of a regular schedule. For batch transfer runs that are
	// scheduled manually, this is empty.
	// NOTE: the system might choose to delay the schedule depending on the
	// current load, so `schedule_time` doesn't always match this.
	Schedule string `protobuf:"bytes,12,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Output only. This is the same token initialized from TransferConfig.
	// Partner token is a unique identifier used for identifying a transfer setup
	// stored on external partner side. The token is opaque to DTS and can only be
	// interpreted by partner. Partner data source should create a mapping between
	// the config id and the token to validate that a transfer config/run is
	// legitimate.
	PartnerToken         string   `protobuf:"bytes,28,opt,name=partner_token,json=partnerToken,proto3" json:"partner_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TransferRun) Reset()         { *m = TransferRun{} }
func (m *TransferRun) String() string { return proto.CompactTextString(m) }
func (*TransferRun) ProtoMessage()    {}
func (*TransferRun) Descriptor() ([]byte, []int) {
	return fileDescriptor_90c2574420b818ad, []int{2}
}

func (m *TransferRun) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransferRun.Unmarshal(m, b)
}
func (m *TransferRun) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransferRun.Marshal(b, m, deterministic)
}
func (m *TransferRun) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransferRun.Merge(m, src)
}
func (m *TransferRun) XXX_Size() int {
	return xxx_messageInfo_TransferRun.Size(m)
}
func (m *TransferRun) XXX_DiscardUnknown() {
	xxx_messageInfo_TransferRun.DiscardUnknown(m)
}

var xxx_messageInfo_TransferRun proto.InternalMessageInfo

func (m *TransferRun) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TransferRun) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *TransferRun) GetScheduleTime() *timestamp.Timestamp {
	if m != nil {
		return m.ScheduleTime
	}
	return nil
}

func (m *TransferRun) GetRunTime() *timestamp.Timestamp {
	if m != nil {
		return m.RunTime
	}
	return nil
}

func (m *TransferRun) GetErrorStatus() *status.Status {
	if m != nil {
		return m.ErrorStatus
	}
	return nil
}

func (m *TransferRun) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TransferRun) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *TransferRun) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *TransferRun) GetParams() *_struct.Struct {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *TransferRun) GetDestinationDatasetId() string {
	if m != nil {
		return m.DestinationDatasetId
	}
	return ""
}

func (m *TransferRun) GetDataSourceId() string {
	if m != nil {
		return m.DataSourceId
	}
	return ""
}

func (m *TransferRun) GetState() TransferState {
	if m != nil {
		return m.State
	}
	return TransferState_TRANSFER_STATE_UNSPECIFIED
}

func (m *TransferRun) GetUserId() int64 {
	if m != nil {
		return m.UserId
	}
	return 0
}

func (m *TransferRun) GetSchedule() string {
	if m != nil {
		return m.Schedule
	}
	return ""
}

func (m *TransferRun) GetPartnerToken() string {
	if m != nil {
		return m.PartnerToken
	}
	return ""
}

// Represents a user facing message for a particular data transfer run.
type TransferMessage struct {
	// Time when message was logged.
	MessageTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=message_time,json=messageTime,proto3" json:"message_time,omitempty"`
	// Message severity.
	Severity TransferMessage_MessageSeverity `protobuf:"varint,2,opt,name=severity,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferMessage_MessageSeverity" json:"severity,omitempty"`
	// Message text.
	MessageText          string   `protobuf:"bytes,3,opt,name=message_text,json=messageText,proto3" json:"message_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TransferMessage) Reset()         { *m = TransferMessage{} }
func (m *TransferMessage) String() string { return proto.CompactTextString(m) }
func (*TransferMessage) ProtoMessage()    {}
func (*TransferMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_90c2574420b818ad, []int{3}
}

func (m *TransferMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransferMessage.Unmarshal(m, b)
}
func (m *TransferMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransferMessage.Marshal(b, m, deterministic)
}
func (m *TransferMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransferMessage.Merge(m, src)
}
func (m *TransferMessage) XXX_Size() int {
	return xxx_messageInfo_TransferMessage.Size(m)
}
func (m *TransferMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_TransferMessage.DiscardUnknown(m)
}

var xxx_messageInfo_TransferMessage proto.InternalMessageInfo

func (m *TransferMessage) GetMessageTime() *timestamp.Timestamp {
	if m != nil {
		return m.MessageTime
	}
	return nil
}

func (m *TransferMessage) GetSeverity() TransferMessage_MessageSeverity {
	if m != nil {
		return m.Severity
	}
	return TransferMessage_MESSAGE_SEVERITY_UNSPECIFIED
}

func (m *TransferMessage) GetMessageText() string {
	if m != nil {
		return m.MessageText
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.TransferType", TransferType_name, TransferType_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.TransferState", TransferState_name, TransferState_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.TransferMessage_MessageSeverity", TransferMessage_MessageSeverity_name, TransferMessage_MessageSeverity_value)
	proto.RegisterType((*ScheduleOptions)(nil), "google.cloud.bigquery.datatransfer.v1.ScheduleOptions")
	proto.RegisterType((*TransferConfig)(nil), "google.cloud.bigquery.datatransfer.v1.TransferConfig")
	proto.RegisterType((*TransferRun)(nil), "google.cloud.bigquery.datatransfer.v1.TransferRun")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.bigquery.datatransfer.v1.TransferRun.LabelsEntry")
	proto.RegisterType((*TransferMessage)(nil), "google.cloud.bigquery.datatransfer.v1.TransferMessage")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/datatransfer/v1/transfer.proto", fileDescriptor_90c2574420b818ad)
}

var fileDescriptor_90c2574420b818ad = []byte{
	// 1126 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xdf, 0x6e, 0xdb, 0xb6,
	0x17, 0xfe, 0xc9, 0x8e, 0xff, 0x1d, 0xd9, 0x89, 0x41, 0x34, 0x8d, 0x7e, 0x41, 0xb7, 0x79, 0xd9,
	0x0a, 0x64, 0xbd, 0x90, 0x91, 0xac, 0xed, 0xd6, 0x15, 0xeb, 0xe0, 0xd8, 0x4a, 0xe6, 0xad, 0x75,
	0x52, 0x4a, 0x49, 0xd1, 0x21, 0x80, 0x46, 0x5b, 0xb4, 0x2a, 0xd4, 0xa1, 0x34, 0x8a, 0x4a, 0xeb,
	0xd7, 0xd9, 0xcd, 0x80, 0xbd, 0xc1, 0xb0, 0xeb, 0xdd, 0xec, 0x45, 0xf6, 0x1a, 0x83, 0x28, 0x4a,
	0xf0, 0x9c, 0x62, 0x4e, 0x0a, 0xec, 0xca, 0x3c, 0x3c, 0xe7, 0xfb, 0x78, 0xc8, 0xf3, 0x9d, 0x23,
	0xc3, 0x7d, 0x3f, 0x0c, 0xfd, 0x19, 0xed, 0x4e, 0x66, 0x61, 0xe2, 0x75, 0xc7, 0x81, 0xff, 0x53,
	0x42, 0xf9, 0xbc, 0xeb, 0x11, 0x41, 0x04, 0x27, 0x2c, 0x9e, 0x52, 0xde, 0xbd, 0xdc, 0xeb, 0xe6,
	0x6b, 0x33, 0xe2, 0xa1, 0x08, 0xd1, 0xdd, 0x0c, 0x65, 0x4a, 0x94, 0x99, 0xa3, 0xcc, 0x45, 0x94,
	0x79, 0xb9, 0xb7, 0x7d, 0x47, 0x91, 0x93, 0x28, 0xe8, 0x12, 0xc6, 0x42, 0x41, 0x44, 0x10, 0xb2,
	0x38, 0x23, 0x29, 0xbc, 0xd2, 0x1a, 0x27, 0xd3, 0x6e, 0x2c, 0x78, 0x32, 0x11, 0xca, 0xfb, 0xd1,
	0xb2, 0x57, 0x04, 0x17, 0x34, 0x16, 0xe4, 0x22, 0x52, 0x01, 0x5b, 0x2a, 0x80, 0x47, 0x93, 0x6e,
	0x2c, 0x88, 0x48, 0x14, 0xef, 0xce, 0xef, 0x1a, 0x6c, 0xd8, 0x93, 0x57, 0xd4, 0x4b, 0x66, 0xf4,
	0x38, 0x92, 0x27, 0xa2, 0x87, 0xb0, 0xe5, 0x05, 0x31, 0x19, 0xcf, 0xa8, 0x4b, 0x12, 0x11, 0xba,
	0x71, 0xe6, 0x0f, 0x98, 0x6f, 0x94, 0x3b, 0xda, 0x6e, 0x1d, 0x6f, 0x2a, 0x77, 0x2f, 0x11, 0xa1,
	0x5d, 0x38, 0xd1, 0x23, 0x80, 0x58, 0x10, 0x2e, 0xdc, 0xf4, 0x74, 0x43, 0xeb, 0x68, 0xbb, 0xfa,
	0xfe, 0xb6, 0xa9, 0x6e, 0x9f, 0xa7, 0x66, 0x3a, 0x79, 0x6a, 0xb8, 0x21, 0xa3, 0x53, 0x1b, 0x3d,
	0x80, 0x3a, 0x65, 0x5e, 0x06, 0x2c, 0xad, 0x04, 0xd6, 0x28, 0xf3, 0x52, 0x6b, 0xe7, 0x97, 0x2a,
	0xac, 0x3b, 0xea, 0x0d, 0xfb, 0x21, 0x9b, 0x06, 0x3e, 0x42, 0xb0, 0xc6, 0x88, 0x3a, 0xbe, 0x81,
	0xe5, 0x1a, 0xdd, 0x87, 0xdb, 0x1e, 0x8d, 0x45, 0xc0, 0xe4, 0x93, 0xba, 0xe9, 0xcb, 0xc7, 0x54,
	0xb8, 0x81, 0x27, 0xcf, 0x6a, 0xe0, 0x5b, 0x0b, 0xde, 0x41, 0xe6, 0x1c, 0x7a, 0xe8, 0x63, 0x68,
	0x7a, 0x41, 0x1c, 0xcd, 0xc8, 0xdc, 0x95, 0x8c, 0x65, 0x19, 0xab, 0xab, 0xbd, 0x51, 0x4a, 0xfc,
	0x29, 0xac, 0xa7, 0x64, 0x6e, 0x1c, 0x26, 0x7c, 0x42, 0x53, 0xc2, 0x8a, 0x0c, 0x6a, 0xa6, 0xbb,
	0xb6, 0xdc, 0x1c, 0x7a, 0xa8, 0x0b, 0xd5, 0x88, 0x70, 0x72, 0x11, 0x1b, 0x0d, 0x79, 0xb5, 0xad,
	0x2b, 0x57, 0xb3, 0x65, 0x31, 0xb1, 0x0a, 0x43, 0xdb, 0x50, 0x57, 0x6f, 0x4e, 0x8d, 0x9a, 0x24,
	0x2c, 0x6c, 0x44, 0xa0, 0x9d, 0xaf, 0xdd, 0x30, 0x2b, 0x98, 0x61, 0x48, 0xda, 0x87, 0xe6, 0xb5,
	0x84, 0x66, 0x2e, 0x95, 0x1b, 0x6f, 0xc4, 0x4b, 0xf5, 0xff, 0x02, 0x0c, 0x79, 0x2b, 0x4e, 0xa7,
	0x9c, 0xc6, 0xaf, 0xdc, 0x37, 0x01, 0xf3, 0xc2, 0x37, 0xae, 0x47, 0xe6, 0xb1, 0xd1, 0xec, 0x68,
	0xbb, 0x15, 0xbc, 0x99, 0xfa, 0x71, 0xe6, 0x7e, 0x21, 0xbd, 0x03, 0x32, 0x97, 0x79, 0x2b, 0x65,
	0x78, 0x46, 0x4b, 0x2a, 0xa5, 0xb0, 0xd1, 0x63, 0xd0, 0x93, 0xc8, 0x23, 0x82, 0x66, 0x45, 0x5e,
	0x5b, 0x59, 0x64, 0xc8, 0xc2, 0xa5, 0x3c, 0x9e, 0x40, 0x8b, 0xd1, 0xb7, 0xc2, 0xe5, 0x09, 0xcb,
	0xe0, 0xf5, 0x95, 0x70, 0x3d, 0x05, 0xe0, 0x84, 0x49, 0xfc, 0x77, 0x50, 0x49, 0x55, 0x4f, 0x0d,
	0xe8, 0x68, 0xbb, 0xeb, 0xfb, 0xf7, 0xaf, 0xf9, 0x52, 0xb9, 0xb4, 0xec, 0x14, 0x8b, 0x33, 0x0a,
	0xb4, 0x05, 0xb5, 0x24, 0xa6, 0x3c, 0x2d, 0xb6, 0xde, 0xd1, 0x76, 0xcb, 0xb8, 0x9a, 0x9a, 0x43,
	0x0f, 0xdd, 0xcd, 0xc4, 0x90, 0x2a, 0x8b, 0x53, 0x3f, 0x08, 0x99, 0xb1, 0x2e, 0x6b, 0xd7, 0x52,
	0xbb, 0x58, 0x6e, 0xa2, 0x4f, 0xa0, 0x15, 0x11, 0x2e, 0x18, 0xe5, 0xae, 0x08, 0x5f, 0x53, 0x66,
	0xdc, 0xce, 0x24, 0xa3, 0x36, 0x9d, 0x74, 0x0f, 0x1d, 0xc3, 0x56, 0x1e, 0x34, 0x09, 0x19, 0xa3,
	0x13, 0x29, 0xdc, 0x80, 0x4d, 0x43, 0x63, 0xeb, 0xdf, 0x35, 0xb4, 0xa9, 0x70, 0xfd, 0x02, 0x36,
	0x64, 0xd3, 0x70, 0xe7, 0x8f, 0x2a, 0xe8, 0xf9, 0x75, 0x70, 0xc2, 0xde, 0xd9, 0x26, 0x67, 0x50,
	0x9d, 0x91, 0x31, 0x9d, 0xc5, 0xc6, 0xed, 0x4e, 0x79, 0x57, 0xdf, 0x7f, 0x72, 0xc3, 0x67, 0xc2,
	0x09, 0x33, 0x9f, 0x4a, 0x02, 0x8b, 0x09, 0x3e, 0xc7, 0x8a, 0x0d, 0x7d, 0x03, 0xad, 0x42, 0xb2,
	0xb2, 0x7a, 0xe5, 0x95, 0xd5, 0x6b, 0xe6, 0x80, 0x7c, 0x3a, 0x14, 0x95, 0x87, 0xd5, 0xd3, 0x81,
	0xab, 0xaa, 0x3f, 0x80, 0x26, 0xe5, 0x3c, 0xe4, 0x6e, 0x36, 0xf1, 0x8c, 0x4d, 0x09, 0x45, 0x39,
	0x94, 0x47, 0x13, 0xd3, 0x96, 0x1e, 0xac, 0xcb, 0xb8, 0xcc, 0x58, 0x1a, 0x63, 0x6b, 0xef, 0x3b,
	0xc6, 0x2a, 0xd7, 0x1e, 0x63, 0xcb, 0xbd, 0x51, 0xbd, 0x51, 0x6f, 0xdc, 0x78, 0xba, 0xbc, 0xdf,
	0x34, 0xbc, 0x3a, 0xea, 0x6a, 0xef, 0x18, 0x75, 0x45, 0xa3, 0xd5, 0xff, 0xc3, 0x46, 0x5b, 0x1c,
	0x8f, 0xcd, 0xa5, 0xf1, 0x78, 0xa5, 0xbb, 0xee, 0x5c, 0xed, 0xae, 0xed, 0x47, 0xa0, 0x2f, 0xe8,
	0x14, 0xb5, 0xa1, 0xfc, 0x9a, 0xce, 0x55, 0x2b, 0xa4, 0x4b, 0x74, 0x0b, 0x2a, 0x97, 0x64, 0x96,
	0x50, 0xf5, 0x22, 0x99, 0xf1, 0x55, 0xe9, 0x4b, 0x6d, 0xe7, 0xb7, 0x12, 0x6c, 0xe4, 0xd9, 0x3e,
	0xa3, 0x71, 0x4c, 0x7c, 0x8a, 0xbe, 0x86, 0xe6, 0x45, 0xb6, 0xbc, 0xee, 0x97, 0x4f, 0x57, 0xf1,
	0xb2, 0x80, 0x63, 0xa8, 0xc7, 0xf4, 0x92, 0xf2, 0x40, 0xcc, 0xe5, 0x79, 0xeb, 0xfb, 0x87, 0x37,
	0x7c, 0x36, 0x95, 0x88, 0xa9, 0x7e, 0x6d, 0xc5, 0x86, 0x0b, 0xde, 0xf4, 0x5b, 0x56, 0xa4, 0x48,
	0xdf, 0x8a, 0xfc, 0x5b, 0x96, 0xa7, 0x41, 0xdf, 0x8a, 0x9d, 0x1f, 0x61, 0x63, 0x09, 0x8f, 0x3a,
	0x70, 0xe7, 0x99, 0x65, 0xdb, 0xbd, 0x23, 0xcb, 0xb5, 0xad, 0x33, 0x0b, 0x0f, 0x9d, 0x97, 0xee,
	0xe9, 0xc8, 0x3e, 0xb1, 0xfa, 0xc3, 0xc3, 0xa1, 0x35, 0x68, 0xff, 0x0f, 0xd5, 0x61, 0x6d, 0x38,
	0x3a, 0x3c, 0x6e, 0x6b, 0x48, 0x87, 0xda, 0x8b, 0x1e, 0x1e, 0x0d, 0x47, 0x47, 0xed, 0x12, 0x6a,
	0x40, 0xc5, 0xc2, 0xf8, 0x18, 0xb7, 0xcb, 0xe9, 0x72, 0x60, 0x1d, 0x9c, 0x1e, 0xb5, 0xd7, 0xee,
	0x7d, 0x0f, 0xcd, 0x3c, 0x63, 0x67, 0x1e, 0x51, 0xf4, 0x01, 0xfc, 0xdf, 0xc1, 0xbd, 0x91, 0x7d,
	0x68, 0x61, 0xd7, 0x79, 0x79, 0x62, 0x2d, 0x71, 0x37, 0xa0, 0x72, 0xd0, 0x73, 0xfa, 0xdf, 0xb6,
	0x35, 0xd4, 0x82, 0x86, 0xed, 0x60, 0xab, 0xf7, 0x4c, 0xd2, 0x6f, 0x97, 0x0c, 0xed, 0x5e, 0x0c,
	0xad, 0x7f, 0xa8, 0x06, 0x7d, 0x08, 0xdb, 0x05, 0x9b, 0xed, 0xf4, 0x9c, 0x65, 0x3a, 0x1d, 0x6a,
	0x27, 0xd6, 0x68, 0x90, 0x25, 0xa8, 0x43, 0x0d, 0x9f, 0x8e, 0x64, 0xb6, 0x65, 0xc9, 0x7e, 0xda,
	0xef, 0x5b, 0xd6, 0xc0, 0x1a, 0xb4, 0xd7, 0x10, 0x40, 0xf5, 0xb0, 0x37, 0x7c, 0x6a, 0x0d, 0xda,
	0x95, 0xd4, 0xd5, 0xef, 0x8d, 0xfa, 0xd6, 0xd3, 0xd4, 0xac, 0x1e, 0xfc, 0xa5, 0xc1, 0x67, 0x93,
	0xf0, 0xe2, 0x7a, 0xe5, 0x39, 0x28, 0x12, 0x3c, 0x49, 0x15, 0x70, 0xa2, 0xfd, 0xf0, 0x5c, 0xe1,
	0xfc, 0x70, 0x46, 0x98, 0x6f, 0x86, 0xdc, 0xef, 0xfa, 0x94, 0x49, 0x7d, 0x74, 0x33, 0x17, 0x89,
	0x82, 0x78, 0xc5, 0xdf, 0xcb, 0xc7, 0x8b, 0xf6, 0xcf, 0xa5, 0xca, 0x51, 0xff, 0x60, 0xe0, 0xfc,
	0x5a, 0xba, 0x7b, 0x94, 0x71, 0xf7, 0x65, 0x4e, 0x07, 0x81, 0xff, 0x5c, 0xe6, 0x94, 0x36, 0x70,
	0x9e, 0x86, 0x79, 0xb6, 0xf7, 0x67, 0x1e, 0x77, 0x2e, 0xe3, 0xce, 0xf3, 0xb8, 0xf3, 0xc5, 0xb8,
	0xf3, 0xb3, 0xbd, 0x71, 0x55, 0x66, 0xf5, 0xf9, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x47, 0x73,
	0xb4, 0xb0, 0xf3, 0x0a, 0x00, 0x00,
}
