package iothubapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/provisioningservices/mgmt/2017-08-21-preview/iothub"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result iothub.OperationListResultPage, err error)
}

var _ OperationsClientAPI = (*iothub.OperationsClient)(nil)

// DpsCertificateClientAPI contains the set of methods on the DpsCertificateClient type.
type DpsCertificateClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, provisioningServiceName string, certificateName string, certificateDescription iothub.CertificateBodyDescription, ifMatch string) (result iothub.CertificateResponse, err error)
	Delete(ctx context.Context, resourceGroupName string, ifMatch string, provisioningServiceName string, certificateName string, certificatename string, certificaterawBytes []byte, certificateisVerified *bool, certificatepurpose iothub.CertificatePurpose, certificatecreated *date.Time, certificatelastUpdated *date.Time, certificatehasPrivateKey *bool, certificatenonce string) (result autorest.Response, err error)
	GenerateVerificationCode(ctx context.Context, certificateName string, ifMatch string, resourceGroupName string, provisioningServiceName string, certificatename string, certificaterawBytes []byte, certificateisVerified *bool, certificatepurpose iothub.CertificatePurpose, certificatecreated *date.Time, certificatelastUpdated *date.Time, certificatehasPrivateKey *bool, certificatenonce string) (result iothub.VerificationCodeResponse, err error)
	Get(ctx context.Context, certificateName string, resourceGroupName string, provisioningServiceName string, ifMatch string) (result iothub.CertificateResponse, err error)
	VerifyCertificate(ctx context.Context, certificateName string, ifMatch string, request iothub.VerificationCodeRequest, resourceGroupName string, provisioningServiceName string, certificatename string, certificaterawBytes []byte, certificateisVerified *bool, certificatepurpose iothub.CertificatePurpose, certificatecreated *date.Time, certificatelastUpdated *date.Time, certificatehasPrivateKey *bool, certificatenonce string) (result iothub.CertificateResponse, err error)
}

var _ DpsCertificateClientAPI = (*iothub.DpsCertificateClient)(nil)

// IotDpsResourceClientAPI contains the set of methods on the IotDpsResourceClient type.
type IotDpsResourceClientAPI interface {
	CheckNameAvailability(ctx context.Context, arguments iothub.OperationInputs) (result iothub.NameAvailabilityInfo, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, provisioningServiceName string, iotDpsDescription iothub.ProvisioningServiceDescription) (result iothub.IotDpsResourceCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result iothub.IotDpsResourceDeleteFuture, err error)
	Get(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result iothub.ProvisioningServiceDescription, err error)
	GetKeysForKeyName(ctx context.Context, provisioningServiceName string, keyName string, resourceGroupName string) (result iothub.SharedAccessSignatureAuthorizationRuleAccessRightsDescription, err error)
	GetOperationResult(ctx context.Context, operationID string, resourceGroupName string, provisioningServiceName string, asyncinfo string) (result iothub.AsyncOperationResult, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result iothub.ProvisioningServiceDescriptionListResultPage, err error)
	ListBySubscription(ctx context.Context) (result iothub.ProvisioningServiceDescriptionListResultPage, err error)
	ListKeys(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result iothub.SharedAccessSignatureAuthorizationRuleListResultPage, err error)
	ListValidSkus(ctx context.Context, provisioningServiceName string, resourceGroupName string) (result iothub.IotDpsSkuDefinitionListResultPage, err error)
}

var _ IotDpsResourceClientAPI = (*iothub.IotDpsResourceClient)(nil)

// DpsCertificatesClientAPI contains the set of methods on the DpsCertificatesClient type.
type DpsCertificatesClientAPI interface {
	List(ctx context.Context, resourceGroupName string, provisioningServiceName string) (result iothub.CertificateListDescription, err error)
}

var _ DpsCertificatesClientAPI = (*iothub.DpsCertificatesClient)(nil)
