package hybriddata

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/hybriddatamanager/mgmt/2016-06-01/hybriddata"

// IsJobCancellable enumerates the values for is job cancellable.
type IsJobCancellable string

const (
	// Cancellable ...
	Cancellable IsJobCancellable = "Cancellable"
	// NotCancellable ...
	NotCancellable IsJobCancellable = "NotCancellable"
)

// PossibleIsJobCancellableValues returns an array of possible values for the IsJobCancellable const type.
func PossibleIsJobCancellableValues() []IsJobCancellable {
	return []IsJobCancellable{Cancellable, NotCancellable}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// Cancelled ...
	Cancelled JobStatus = "Cancelled"
	// Cancelling ...
	Cancelling JobStatus = "Cancelling"
	// Failed ...
	Failed JobStatus = "Failed"
	// InProgress ...
	InProgress JobStatus = "InProgress"
	// None ...
	None JobStatus = "None"
	// Succeeded ...
	Succeeded JobStatus = "Succeeded"
	// WaitingForAction ...
	WaitingForAction JobStatus = "WaitingForAction"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{Cancelled, Cancelling, Failed, InProgress, None, Succeeded, WaitingForAction}
}

// RunLocation enumerates the values for run location.
type RunLocation string

const (
	// RunLocationAustraliaeast ...
	RunLocationAustraliaeast RunLocation = "australiaeast"
	// RunLocationAustraliasoutheast ...
	RunLocationAustraliasoutheast RunLocation = "australiasoutheast"
	// RunLocationBrazilsouth ...
	RunLocationBrazilsouth RunLocation = "brazilsouth"
	// RunLocationCanadacentral ...
	RunLocationCanadacentral RunLocation = "canadacentral"
	// RunLocationCanadaeast ...
	RunLocationCanadaeast RunLocation = "canadaeast"
	// RunLocationCentralindia ...
	RunLocationCentralindia RunLocation = "centralindia"
	// RunLocationCentralus ...
	RunLocationCentralus RunLocation = "centralus"
	// RunLocationEastasia ...
	RunLocationEastasia RunLocation = "eastasia"
	// RunLocationEastus ...
	RunLocationEastus RunLocation = "eastus"
	// RunLocationEastus2 ...
	RunLocationEastus2 RunLocation = "eastus2"
	// RunLocationJapaneast ...
	RunLocationJapaneast RunLocation = "japaneast"
	// RunLocationJapanwest ...
	RunLocationJapanwest RunLocation = "japanwest"
	// RunLocationKoreacentral ...
	RunLocationKoreacentral RunLocation = "koreacentral"
	// RunLocationKoreasouth ...
	RunLocationKoreasouth RunLocation = "koreasouth"
	// RunLocationNone ...
	RunLocationNone RunLocation = "none"
	// RunLocationNorthcentralus ...
	RunLocationNorthcentralus RunLocation = "northcentralus"
	// RunLocationNortheurope ...
	RunLocationNortheurope RunLocation = "northeurope"
	// RunLocationSouthcentralus ...
	RunLocationSouthcentralus RunLocation = "southcentralus"
	// RunLocationSoutheastasia ...
	RunLocationSoutheastasia RunLocation = "southeastasia"
	// RunLocationSouthindia ...
	RunLocationSouthindia RunLocation = "southindia"
	// RunLocationUksouth ...
	RunLocationUksouth RunLocation = "uksouth"
	// RunLocationUkwest ...
	RunLocationUkwest RunLocation = "ukwest"
	// RunLocationWestcentralus ...
	RunLocationWestcentralus RunLocation = "westcentralus"
	// RunLocationWesteurope ...
	RunLocationWesteurope RunLocation = "westeurope"
	// RunLocationWestindia ...
	RunLocationWestindia RunLocation = "westindia"
	// RunLocationWestus ...
	RunLocationWestus RunLocation = "westus"
	// RunLocationWestus2 ...
	RunLocationWestus2 RunLocation = "westus2"
)

// PossibleRunLocationValues returns an array of possible values for the RunLocation const type.
func PossibleRunLocationValues() []RunLocation {
	return []RunLocation{RunLocationAustraliaeast, RunLocationAustraliasoutheast, RunLocationBrazilsouth, RunLocationCanadacentral, RunLocationCanadaeast, RunLocationCentralindia, RunLocationCentralus, RunLocationEastasia, RunLocationEastus, RunLocationEastus2, RunLocationJapaneast, RunLocationJapanwest, RunLocationKoreacentral, RunLocationKoreasouth, RunLocationNone, RunLocationNorthcentralus, RunLocationNortheurope, RunLocationSouthcentralus, RunLocationSoutheastasia, RunLocationSouthindia, RunLocationUksouth, RunLocationUkwest, RunLocationWestcentralus, RunLocationWesteurope, RunLocationWestindia, RunLocationWestus, RunLocationWestus2}
}

// State enumerates the values for state.
type State string

const (
	// Disabled ...
	Disabled State = "Disabled"
	// Enabled ...
	Enabled State = "Enabled"
	// Supported ...
	Supported State = "Supported"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{Disabled, Enabled, Supported}
}

// SupportedAlgorithm enumerates the values for supported algorithm.
type SupportedAlgorithm string

const (
	// SupportedAlgorithmNone ...
	SupportedAlgorithmNone SupportedAlgorithm = "None"
	// SupportedAlgorithmPlainText ...
	SupportedAlgorithmPlainText SupportedAlgorithm = "PlainText"
	// SupportedAlgorithmRSA15 ...
	SupportedAlgorithmRSA15 SupportedAlgorithm = "RSA1_5"
	// SupportedAlgorithmRSAOAEP ...
	SupportedAlgorithmRSAOAEP SupportedAlgorithm = "RSA_OAEP"
)

// PossibleSupportedAlgorithmValues returns an array of possible values for the SupportedAlgorithm const type.
func PossibleSupportedAlgorithmValues() []SupportedAlgorithm {
	return []SupportedAlgorithm{SupportedAlgorithmNone, SupportedAlgorithmPlainText, SupportedAlgorithmRSA15, SupportedAlgorithmRSAOAEP}
}

// UserConfirmation enumerates the values for user confirmation.
type UserConfirmation string

const (
	// NotRequired ...
	NotRequired UserConfirmation = "NotRequired"
	// Required ...
	Required UserConfirmation = "Required"
)

// PossibleUserConfirmationValues returns an array of possible values for the UserConfirmation const type.
func PossibleUserConfirmationValues() []UserConfirmation {
	return []UserConfirmation{NotRequired, Required}
}

// AvailableProviderOperation class represents provider operation
type AvailableProviderOperation struct {
	// Name - Gets or Sets Name of the operations
	Name *string `json:"name,omitempty"`
	// Display - Gets or sets Display information
	// Contains the localized display information for this particular operation/action
	Display *AvailableProviderOperationDisplay `json:"display,omitempty"`
	// Origin - Gets or sets Origin
	// The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX.
	// Default value is “user,system”
	Origin *string `json:"origin,omitempty"`
	// Properties - Gets or sets Properties
	// Reserved for future use
	Properties interface{} `json:"properties,omitempty"`
}

// AvailableProviderOperationDisplay contains the localized display information for this particular
// operation / action.
// These value will be used by several clients for
// (1) custom role definitions for RBAC;
// (2) complex query filters for the event service; and (3) audit history / records for management
// operations.
type AvailableProviderOperationDisplay struct {
	// Provider - Gets or sets Provider
	// The localized friendly form of the resource provider name – it is expected to also include the publisher/company responsible.
	// It should use Title Casing and begin with “Microsoft” for 1st party services.
	Provider *string `json:"provider,omitempty"`
	// Resource - Gets or sets Resource
	// The localized friendly form of the resource type related to this action/operation – it should match the public documentation for the resource provider.
	// It should use Title Casing – for examples, please refer to the “name” section.
	Resource *string `json:"resource,omitempty"`
	// Operation - Gets or sets Operation
	// The localized friendly name for the operation, as it should be shown to the user.
	// It should be concise (to fit in drop downs) but clear (i.e. self-documenting). It should use Title Casing and include the entity/resource to which it applies.
	Operation *string `json:"operation,omitempty"`
	// Description - Gets or sets Description
	// The localized friendly description for the operation, as it should be shown to the user.
	// It should be thorough, yet concise – it will be used in tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// AvailableProviderOperations class for set of operations used for discovery of available provider
// operations.
type AvailableProviderOperations struct {
	autorest.Response `json:"-"`
	// Value - List of operations.
	Value *[]AvailableProviderOperation `json:"value,omitempty"`
	// NextLink - Link for the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableProviderOperationsIterator provides access to a complete listing of AvailableProviderOperation
// values.
type AvailableProviderOperationsIterator struct {
	i    int
	page AvailableProviderOperationsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableProviderOperationsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableProviderOperationsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableProviderOperationsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableProviderOperationsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableProviderOperationsIterator) Response() AvailableProviderOperations {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableProviderOperationsIterator) Value() AvailableProviderOperation {
	if !iter.page.NotDone() {
		return AvailableProviderOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableProviderOperationsIterator type.
func NewAvailableProviderOperationsIterator(page AvailableProviderOperationsPage) AvailableProviderOperationsIterator {
	return AvailableProviderOperationsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apo AvailableProviderOperations) IsEmpty() bool {
	return apo.Value == nil || len(*apo.Value) == 0
}

// availableProviderOperationsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apo AvailableProviderOperations) availableProviderOperationsPreparer(ctx context.Context) (*http.Request, error) {
	if apo.NextLink == nil || len(to.String(apo.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apo.NextLink)))
}

// AvailableProviderOperationsPage contains a page of AvailableProviderOperation values.
type AvailableProviderOperationsPage struct {
	fn  func(context.Context, AvailableProviderOperations) (AvailableProviderOperations, error)
	apo AvailableProviderOperations
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableProviderOperationsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableProviderOperationsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.apo)
	if err != nil {
		return err
	}
	page.apo = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableProviderOperationsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableProviderOperationsPage) NotDone() bool {
	return !page.apo.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableProviderOperationsPage) Response() AvailableProviderOperations {
	return page.apo
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableProviderOperationsPage) Values() []AvailableProviderOperation {
	if page.apo.IsEmpty() {
		return nil
	}
	return *page.apo.Value
}

// Creates a new instance of the AvailableProviderOperationsPage type.
func NewAvailableProviderOperationsPage(getNextPage func(context.Context, AvailableProviderOperations) (AvailableProviderOperations, error)) AvailableProviderOperationsPage {
	return AvailableProviderOperationsPage{fn: getNextPage}
}

// CustomerSecret the pair of customer secret.
type CustomerSecret struct {
	// KeyIdentifier - The identifier to the data service input object which this secret corresponds to.
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// KeyValue - It contains the encrypted customer secret.
	KeyValue *string `json:"keyValue,omitempty"`
	// Algorithm - The encryption algorithm used to encrypt data. Possible values include: 'SupportedAlgorithmNone', 'SupportedAlgorithmRSA15', 'SupportedAlgorithmRSAOAEP', 'SupportedAlgorithmPlainText'
	Algorithm SupportedAlgorithm `json:"algorithm,omitempty"`
}

// DataManager the DataManager resource.
type DataManager struct {
	autorest.Response `json:"-"`
	// Etag - Etag of the Resource.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; The Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The Resource Name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The Resource type.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East
	// US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo
	// region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for DataManager.
func (dm DataManager) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dm.Etag != nil {
		objectMap["etag"] = dm.Etag
	}
	if dm.Location != nil {
		objectMap["location"] = dm.Location
	}
	if dm.Tags != nil {
		objectMap["tags"] = dm.Tags
	}
	if dm.Sku != nil {
		objectMap["sku"] = dm.Sku
	}
	return json.Marshal(objectMap)
}

// DataManagerList dataManager resources Collection.
type DataManagerList struct {
	autorest.Response `json:"-"`
	// Value - List of data manager resources.
	Value *[]DataManager `json:"value,omitempty"`
	// NextLink - Link for the next set of data stores.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataManagersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DataManagersCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DataManagersCreateFuture) Result(client DataManagersClient) (dm DataManager, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.DataManagersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.DataManagersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dm.Response.Response, err = future.GetResult(sender); err == nil && dm.Response.Response.StatusCode != http.StatusNoContent {
		dm, err = client.CreateResponder(dm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybriddata.DataManagersCreateFuture", "Result", dm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DataManagersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DataManagersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DataManagersDeleteFuture) Result(client DataManagersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.DataManagersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.DataManagersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DataManagersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DataManagersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DataManagersUpdateFuture) Result(client DataManagersClient) (dm DataManager, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.DataManagersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.DataManagersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dm.Response.Response, err = future.GetResult(sender); err == nil && dm.Response.Response.StatusCode != http.StatusNoContent {
		dm, err = client.UpdateResponder(dm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybriddata.DataManagersUpdateFuture", "Result", dm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DataManagerUpdateParameter the DataManagerUpdateParameter.
type DataManagerUpdateParameter struct {
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups).
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DataManagerUpdateParameter.
func (dmup DataManagerUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmup.Sku != nil {
		objectMap["sku"] = dmup.Sku
	}
	if dmup.Tags != nil {
		objectMap["tags"] = dmup.Tags
	}
	return json.Marshal(objectMap)
}

// DataService data Service.
type DataService struct {
	autorest.Response `json:"-"`
	// DataServiceProperties - DataService properties.
	*DataServiceProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataService.
func (ds DataService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.DataServiceProperties != nil {
		objectMap["properties"] = ds.DataServiceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataService struct.
func (ds *DataService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataServiceProperties DataServiceProperties
				err = json.Unmarshal(*v, &dataServiceProperties)
				if err != nil {
					return err
				}
				ds.DataServiceProperties = &dataServiceProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ds.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ds.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ds.Type = &typeVar
			}
		}
	}

	return nil
}

// DataServiceList data Service Collection.
type DataServiceList struct {
	autorest.Response `json:"-"`
	// Value - List of data services.
	Value *[]DataService `json:"value,omitempty"`
	// NextLink - Link for the next set of data services.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataServiceListIterator provides access to a complete listing of DataService values.
type DataServiceListIterator struct {
	i    int
	page DataServiceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataServiceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataServiceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataServiceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataServiceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataServiceListIterator) Response() DataServiceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataServiceListIterator) Value() DataService {
	if !iter.page.NotDone() {
		return DataService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataServiceListIterator type.
func NewDataServiceListIterator(page DataServiceListPage) DataServiceListIterator {
	return DataServiceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsl DataServiceList) IsEmpty() bool {
	return dsl.Value == nil || len(*dsl.Value) == 0
}

// dataServiceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsl DataServiceList) dataServiceListPreparer(ctx context.Context) (*http.Request, error) {
	if dsl.NextLink == nil || len(to.String(dsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsl.NextLink)))
}

// DataServiceListPage contains a page of DataService values.
type DataServiceListPage struct {
	fn  func(context.Context, DataServiceList) (DataServiceList, error)
	dsl DataServiceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataServiceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataServiceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dsl)
	if err != nil {
		return err
	}
	page.dsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataServiceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataServiceListPage) NotDone() bool {
	return !page.dsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataServiceListPage) Response() DataServiceList {
	return page.dsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataServiceListPage) Values() []DataService {
	if page.dsl.IsEmpty() {
		return nil
	}
	return *page.dsl.Value
}

// Creates a new instance of the DataServiceListPage type.
func NewDataServiceListPage(getNextPage func(context.Context, DataServiceList) (DataServiceList, error)) DataServiceListPage {
	return DataServiceListPage{fn: getNextPage}
}

// DataServiceProperties data Service properties.
type DataServiceProperties struct {
	// State - State of the data service. Possible values include: 'Disabled', 'Enabled', 'Supported'
	State State `json:"state,omitempty"`
	// SupportedDataSinkTypes - Supported data store types which can be used as a sink.
	SupportedDataSinkTypes *[]string `json:"supportedDataSinkTypes,omitempty"`
	// SupportedDataSourceTypes - Supported data store types which can be used as a source.
	SupportedDataSourceTypes *[]string `json:"supportedDataSourceTypes,omitempty"`
}

// DataStore data store.
type DataStore struct {
	autorest.Response `json:"-"`
	// DataStoreProperties - DataStore properties.
	*DataStoreProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataStore.
func (ds DataStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.DataStoreProperties != nil {
		objectMap["properties"] = ds.DataStoreProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataStore struct.
func (ds *DataStore) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataStoreProperties DataStoreProperties
				err = json.Unmarshal(*v, &dataStoreProperties)
				if err != nil {
					return err
				}
				ds.DataStoreProperties = &dataStoreProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ds.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ds.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ds.Type = &typeVar
			}
		}
	}

	return nil
}

// DataStoreFilter contains the information about the filters for the DataStore.
type DataStoreFilter struct {
	// DataStoreTypeID - The data store type id.
	DataStoreTypeID *string `json:"dataStoreTypeId,omitempty"`
}

// DataStoreList data Store Collection.
type DataStoreList struct {
	autorest.Response `json:"-"`
	// Value - List of data stores.
	Value *[]DataStore `json:"value,omitempty"`
	// NextLink - Link for the next set of data stores.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataStoreListIterator provides access to a complete listing of DataStore values.
type DataStoreListIterator struct {
	i    int
	page DataStoreListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataStoreListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataStoreListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataStoreListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataStoreListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataStoreListIterator) Response() DataStoreList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataStoreListIterator) Value() DataStore {
	if !iter.page.NotDone() {
		return DataStore{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataStoreListIterator type.
func NewDataStoreListIterator(page DataStoreListPage) DataStoreListIterator {
	return DataStoreListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsl DataStoreList) IsEmpty() bool {
	return dsl.Value == nil || len(*dsl.Value) == 0
}

// dataStoreListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsl DataStoreList) dataStoreListPreparer(ctx context.Context) (*http.Request, error) {
	if dsl.NextLink == nil || len(to.String(dsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsl.NextLink)))
}

// DataStoreListPage contains a page of DataStore values.
type DataStoreListPage struct {
	fn  func(context.Context, DataStoreList) (DataStoreList, error)
	dsl DataStoreList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataStoreListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataStoreListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dsl)
	if err != nil {
		return err
	}
	page.dsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataStoreListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataStoreListPage) NotDone() bool {
	return !page.dsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataStoreListPage) Response() DataStoreList {
	return page.dsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataStoreListPage) Values() []DataStore {
	if page.dsl.IsEmpty() {
		return nil
	}
	return *page.dsl.Value
}

// Creates a new instance of the DataStoreListPage type.
func NewDataStoreListPage(getNextPage func(context.Context, DataStoreList) (DataStoreList, error)) DataStoreListPage {
	return DataStoreListPage{fn: getNextPage}
}

// DataStoreProperties data Store for sources and sinks
type DataStoreProperties struct {
	// RepositoryID - Arm Id for the manager resource to which the data source is associated. This is optional.
	RepositoryID *string `json:"repositoryId,omitempty"`
	// State - State of the data source. Possible values include: 'Disabled', 'Enabled', 'Supported'
	State State `json:"state,omitempty"`
	// ExtendedProperties - A generic json used differently by each data source type.
	ExtendedProperties interface{} `json:"extendedProperties,omitempty"`
	// DataStoreTypeID - The arm id of the data store type.
	DataStoreTypeID *string `json:"dataStoreTypeId,omitempty"`
	// CustomerSecrets - List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
	CustomerSecrets *[]CustomerSecret `json:"customerSecrets,omitempty"`
}

// DataStoresCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DataStoresCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DataStoresCreateOrUpdateFuture) Result(client DataStoresClient) (ds DataStore, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.DataStoresCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.DataStoresCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ds.Response.Response, err = future.GetResult(sender); err == nil && ds.Response.Response.StatusCode != http.StatusNoContent {
		ds, err = client.CreateOrUpdateResponder(ds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybriddata.DataStoresCreateOrUpdateFuture", "Result", ds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DataStoresDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DataStoresDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DataStoresDeleteFuture) Result(client DataStoresClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.DataStoresDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.DataStoresDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DataStoreType data Store Type.
type DataStoreType struct {
	autorest.Response `json:"-"`
	// DataStoreTypeProperties - DataStoreType properties.
	*DataStoreTypeProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataStoreType.
func (dst DataStoreType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dst.DataStoreTypeProperties != nil {
		objectMap["properties"] = dst.DataStoreTypeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataStoreType struct.
func (dst *DataStoreType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataStoreTypeProperties DataStoreTypeProperties
				err = json.Unmarshal(*v, &dataStoreTypeProperties)
				if err != nil {
					return err
				}
				dst.DataStoreTypeProperties = &dataStoreTypeProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dst.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dst.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dst.Type = &typeVar
			}
		}
	}

	return nil
}

// DataStoreTypeList data Store Type Collection.
type DataStoreTypeList struct {
	autorest.Response `json:"-"`
	// Value - List of DataStoreType.
	Value *[]DataStoreType `json:"value,omitempty"`
	// NextLink - Link for the next set of data store types.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataStoreTypeListIterator provides access to a complete listing of DataStoreType values.
type DataStoreTypeListIterator struct {
	i    int
	page DataStoreTypeListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataStoreTypeListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataStoreTypeListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataStoreTypeListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataStoreTypeListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataStoreTypeListIterator) Response() DataStoreTypeList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataStoreTypeListIterator) Value() DataStoreType {
	if !iter.page.NotDone() {
		return DataStoreType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataStoreTypeListIterator type.
func NewDataStoreTypeListIterator(page DataStoreTypeListPage) DataStoreTypeListIterator {
	return DataStoreTypeListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dstl DataStoreTypeList) IsEmpty() bool {
	return dstl.Value == nil || len(*dstl.Value) == 0
}

// dataStoreTypeListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dstl DataStoreTypeList) dataStoreTypeListPreparer(ctx context.Context) (*http.Request, error) {
	if dstl.NextLink == nil || len(to.String(dstl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dstl.NextLink)))
}

// DataStoreTypeListPage contains a page of DataStoreType values.
type DataStoreTypeListPage struct {
	fn   func(context.Context, DataStoreTypeList) (DataStoreTypeList, error)
	dstl DataStoreTypeList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataStoreTypeListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataStoreTypeListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dstl)
	if err != nil {
		return err
	}
	page.dstl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataStoreTypeListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataStoreTypeListPage) NotDone() bool {
	return !page.dstl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataStoreTypeListPage) Response() DataStoreTypeList {
	return page.dstl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataStoreTypeListPage) Values() []DataStoreType {
	if page.dstl.IsEmpty() {
		return nil
	}
	return *page.dstl.Value
}

// Creates a new instance of the DataStoreTypeListPage type.
func NewDataStoreTypeListPage(getNextPage func(context.Context, DataStoreTypeList) (DataStoreTypeList, error)) DataStoreTypeListPage {
	return DataStoreTypeListPage{fn: getNextPage}
}

// DataStoreTypeProperties data Store Type properties.
type DataStoreTypeProperties struct {
	// RepositoryType - Arm type for the manager resource to which the data source type is associated. This is optional.
	RepositoryType *string `json:"repositoryType,omitempty"`
	// State - State of the data store type. Possible values include: 'Disabled', 'Enabled', 'Supported'
	State State `json:"state,omitempty"`
	// SupportedDataServicesAsSink - Supported data services where it can be used as a sink.
	SupportedDataServicesAsSink *[]string `json:"supportedDataServicesAsSink,omitempty"`
	// SupportedDataServicesAsSource - Supported data services where it can be used as a source.
	SupportedDataServicesAsSource *[]string `json:"supportedDataServicesAsSource,omitempty"`
}

// DmsBaseObject base class for all objects under DataManager Service
type DmsBaseObject struct {
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
}

// Error top level error for the job.
type Error struct {
	// Code - Error code that can be used to programmatically identify the error.
	Code *string `json:"code,omitempty"`
	// Message - Describes the error in detail and provides debugging information.
	Message *string `json:"message,omitempty"`
}

// ErrorDetails error Details
type ErrorDetails struct {
	// ErrorMessage - Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorCode - Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// RecommendedAction - Recommended action for the error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// ExceptionMessage - Contains the non localized exception message
	ExceptionMessage *string `json:"exceptionMessage,omitempty"`
}

// Job data service job.
type Job struct {
	autorest.Response `json:"-"`
	// Status - Status of the job. Possible values include: 'None', 'InProgress', 'Succeeded', 'WaitingForAction', 'Failed', 'Cancelled', 'Cancelling'
	Status JobStatus `json:"status,omitempty"`
	// StartTime - Time at which the job was started in UTC ISO 8601 format.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Time at which the job ended in UTC ISO 8601 format.
	EndTime *date.Time `json:"endTime,omitempty"`
	// JobProperties - Job properties.
	*JobProperties `json:"properties,omitempty"`
	// Error - Top level error for the job.
	Error *Error `json:"error,omitempty"`
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.Status != "" {
		objectMap["status"] = j.Status
	}
	if j.StartTime != nil {
		objectMap["startTime"] = j.StartTime
	}
	if j.EndTime != nil {
		objectMap["endTime"] = j.EndTime
	}
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	if j.Error != nil {
		objectMap["error"] = j.Error
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status JobStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				j.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				j.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				j.EndTime = &endTime
			}
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "error":
			if v != nil {
				var errorVar Error
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				j.Error = &errorVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobDefinition job Definition.
type JobDefinition struct {
	autorest.Response `json:"-"`
	// JobDefinitionProperties - JobDefinition properties.
	*JobDefinitionProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobDefinition.
func (jd JobDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jd.JobDefinitionProperties != nil {
		objectMap["properties"] = jd.JobDefinitionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobDefinition struct.
func (jd *JobDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobDefinitionProperties JobDefinitionProperties
				err = json.Unmarshal(*v, &jobDefinitionProperties)
				if err != nil {
					return err
				}
				jd.JobDefinitionProperties = &jobDefinitionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jd.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jd.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jd.Type = &typeVar
			}
		}
	}

	return nil
}

// JobDefinitionFilter contains the supported job definition filters.
type JobDefinitionFilter struct {
	// State - The state of the job definition. Possible values include: 'Disabled', 'Enabled', 'Supported'
	State State `json:"state,omitempty"`
	// DataSource - The data source associated with the job definition
	DataSource *string `json:"dataSource,omitempty"`
	// LastModified - The last modified date time of the data source.
	LastModified *date.Time `json:"lastModified,omitempty"`
}

// JobDefinitionList job Definition Collection.
type JobDefinitionList struct {
	autorest.Response `json:"-"`
	// Value - List of job definitions.
	Value *[]JobDefinition `json:"value,omitempty"`
	// NextLink - Link for the next set of job definitions.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobDefinitionListIterator provides access to a complete listing of JobDefinition values.
type JobDefinitionListIterator struct {
	i    int
	page JobDefinitionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobDefinitionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobDefinitionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobDefinitionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobDefinitionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobDefinitionListIterator) Response() JobDefinitionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobDefinitionListIterator) Value() JobDefinition {
	if !iter.page.NotDone() {
		return JobDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobDefinitionListIterator type.
func NewJobDefinitionListIterator(page JobDefinitionListPage) JobDefinitionListIterator {
	return JobDefinitionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jdl JobDefinitionList) IsEmpty() bool {
	return jdl.Value == nil || len(*jdl.Value) == 0
}

// jobDefinitionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jdl JobDefinitionList) jobDefinitionListPreparer(ctx context.Context) (*http.Request, error) {
	if jdl.NextLink == nil || len(to.String(jdl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jdl.NextLink)))
}

// JobDefinitionListPage contains a page of JobDefinition values.
type JobDefinitionListPage struct {
	fn  func(context.Context, JobDefinitionList) (JobDefinitionList, error)
	jdl JobDefinitionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobDefinitionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobDefinitionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jdl)
	if err != nil {
		return err
	}
	page.jdl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobDefinitionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobDefinitionListPage) NotDone() bool {
	return !page.jdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobDefinitionListPage) Response() JobDefinitionList {
	return page.jdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobDefinitionListPage) Values() []JobDefinition {
	if page.jdl.IsEmpty() {
		return nil
	}
	return *page.jdl.Value
}

// Creates a new instance of the JobDefinitionListPage type.
func NewJobDefinitionListPage(getNextPage func(context.Context, JobDefinitionList) (JobDefinitionList, error)) JobDefinitionListPage {
	return JobDefinitionListPage{fn: getNextPage}
}

// JobDefinitionProperties job Definition
type JobDefinitionProperties struct {
	// DataSourceID - Data Source Id associated to the job definition.
	DataSourceID *string `json:"dataSourceId,omitempty"`
	// DataSinkID - Data Sink Id associated to the job definition.
	DataSinkID *string `json:"dataSinkId,omitempty"`
	// Schedules - Schedule for running the job definition
	Schedules *[]Schedule `json:"schedules,omitempty"`
	// State - State of the job definition. Possible values include: 'Disabled', 'Enabled', 'Supported'
	State State `json:"state,omitempty"`
	// LastModifiedTime - Last modified time of the job definition.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// RunLocation - This is the preferred geo location for the job to run. Possible values include: 'RunLocationNone', 'RunLocationAustraliaeast', 'RunLocationAustraliasoutheast', 'RunLocationBrazilsouth', 'RunLocationCanadacentral', 'RunLocationCanadaeast', 'RunLocationCentralindia', 'RunLocationCentralus', 'RunLocationEastasia', 'RunLocationEastus', 'RunLocationEastus2', 'RunLocationJapaneast', 'RunLocationJapanwest', 'RunLocationKoreacentral', 'RunLocationKoreasouth', 'RunLocationSoutheastasia', 'RunLocationSouthcentralus', 'RunLocationSouthindia', 'RunLocationNorthcentralus', 'RunLocationNortheurope', 'RunLocationUksouth', 'RunLocationUkwest', 'RunLocationWestcentralus', 'RunLocationWesteurope', 'RunLocationWestindia', 'RunLocationWestus', 'RunLocationWestus2'
	RunLocation RunLocation `json:"runLocation,omitempty"`
	// UserConfirmation - Enum to detect if user confirmation is required. If not passed will default to NotRequired. Possible values include: 'NotRequired', 'Required'
	UserConfirmation UserConfirmation `json:"userConfirmation,omitempty"`
	// DataServiceInput - A generic json used differently by each data service type.
	DataServiceInput interface{} `json:"dataServiceInput,omitempty"`
	// CustomerSecrets - List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
	CustomerSecrets *[]CustomerSecret `json:"customerSecrets,omitempty"`
}

// JobDefinitionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type JobDefinitionsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobDefinitionsCreateOrUpdateFuture) Result(client JobDefinitionsClient) (jd JobDefinition, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.JobDefinitionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.JobDefinitionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if jd.Response.Response, err = future.GetResult(sender); err == nil && jd.Response.Response.StatusCode != http.StatusNoContent {
		jd, err = client.CreateOrUpdateResponder(jd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "hybriddata.JobDefinitionsCreateOrUpdateFuture", "Result", jd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobDefinitionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobDefinitionsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobDefinitionsDeleteFuture) Result(client JobDefinitionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.JobDefinitionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.JobDefinitionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobDefinitionsRunFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobDefinitionsRunFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobDefinitionsRunFuture) Result(client JobDefinitionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.JobDefinitionsRunFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.JobDefinitionsRunFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobDetails job details.
type JobDetails struct {
	// JobStages - List of stages that ran in the job
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// JobDefinition - JobDefinition at the time of the run
	JobDefinition *JobDefinition `json:"jobDefinition,omitempty"`
	// ErrorDetails - Error details for failure. This is optional.
	ErrorDetails *[]ErrorDetails `json:"errorDetails,omitempty"`
	// ItemDetailsLink - Item Details Link to download files or see details
	ItemDetailsLink *string `json:"itemDetailsLink,omitempty"`
}

// JobFilter contains the information about the filters for the job.
type JobFilter struct {
	// Status - The status of the job. Possible values include: 'None', 'InProgress', 'Succeeded', 'WaitingForAction', 'Failed', 'Cancelled', 'Cancelling'
	Status JobStatus `json:"status,omitempty"`
	// StartTime - The start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// JobList job Collection.
type JobList struct {
	autorest.Response `json:"-"`
	// Value - List of jobs.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - Link for the next set of jobs.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobListIterator provides access to a complete listing of Job values.
type JobListIterator struct {
	i    int
	page JobListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListIterator) Response() JobList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobListIterator type.
func NewJobListIterator(page JobListPage) JobListIterator {
	return JobListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jl JobList) IsEmpty() bool {
	return jl.Value == nil || len(*jl.Value) == 0
}

// jobListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jl JobList) jobListPreparer(ctx context.Context) (*http.Request, error) {
	if jl.NextLink == nil || len(to.String(jl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jl.NextLink)))
}

// JobListPage contains a page of Job values.
type JobListPage struct {
	fn func(context.Context, JobList) (JobList, error)
	jl JobList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jl)
	if err != nil {
		return err
	}
	page.jl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListPage) NotDone() bool {
	return !page.jl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListPage) Response() JobList {
	return page.jl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListPage) Values() []Job {
	if page.jl.IsEmpty() {
		return nil
	}
	return *page.jl.Value
}

// Creates a new instance of the JobListPage type.
func NewJobListPage(getNextPage func(context.Context, JobList) (JobList, error)) JobListPage {
	return JobListPage{fn: getNextPage}
}

// JobProperties job Properties
type JobProperties struct {
	// IsCancellable - Describes whether the job is cancellable. Possible values include: 'NotCancellable', 'Cancellable'
	IsCancellable IsJobCancellable `json:"isCancellable,omitempty"`
	// BytesProcessed - Number of bytes processed by the job as of now.
	BytesProcessed *int64 `json:"bytesProcessed,omitempty"`
	// ItemsProcessed - Number of items processed by the job as of now
	ItemsProcessed *int64 `json:"itemsProcessed,omitempty"`
	// TotalBytesToProcess - Number of bytes to be processed by the job in total.
	TotalBytesToProcess *int64 `json:"totalBytesToProcess,omitempty"`
	// TotalItemsToProcess - Number of items to be processed by the job in total
	TotalItemsToProcess *int64 `json:"totalItemsToProcess,omitempty"`
	// Details - Details of a job run. This field will only be sent for expand details filter.
	Details *JobDetails `json:"details,omitempty"`
	// DataSourceName - Name of the data source on which the job was triggered.
	DataSourceName *string `json:"dataSourceName,omitempty"`
	// DataSinkName - Name of the data sink on which the job was triggered.
	DataSinkName *string `json:"dataSinkName,omitempty"`
}

// JobsCancelFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsCancelFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsCancelFuture) Result(client JobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.JobsCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.JobsCancelFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobsResumeFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsResumeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsResumeFuture) Result(client JobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hybriddata.JobsResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("hybriddata.JobsResumeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobStages job stages.
type JobStages struct {
	// StageName - Name of the job stage.
	StageName *string `json:"stageName,omitempty"`
	// StageStatus - Status of the job stage. Possible values include: 'None', 'InProgress', 'Succeeded', 'WaitingForAction', 'Failed', 'Cancelled', 'Cancelling'
	StageStatus JobStatus `json:"stageStatus,omitempty"`
	// JobStageDetails - Job Stage Details
	JobStageDetails interface{} `json:"jobStageDetails,omitempty"`
	// ErrorDetails - Error details for the stage. This is optional
	ErrorDetails *[]ErrorDetails `json:"errorDetails,omitempty"`
}

// Key encryption Key.
type Key struct {
	// KeyModulus - Modulus of the encryption key.
	KeyModulus *string `json:"keyModulus,omitempty"`
	// KeyExponent - Exponent of the encryption key.
	KeyExponent *string `json:"keyExponent,omitempty"`
	// EncryptionChunkSizeInBytes - The maximum byte size that can be encrypted by the key. For a key size larger than the size, break into chunks and encrypt each chunk, append each encrypted chunk with : to mark the end of the chunk.
	EncryptionChunkSizeInBytes *int32 `json:"encryptionChunkSizeInBytes,omitempty"`
}

// PublicKey public key
type PublicKey struct {
	autorest.Response `json:"-"`
	// PublicKeyProperties - Public key property.
	*PublicKeyProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PublicKey.
func (pk PublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pk.PublicKeyProperties != nil {
		objectMap["properties"] = pk.PublicKeyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublicKey struct.
func (pk *PublicKey) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var publicKeyProperties PublicKeyProperties
				err = json.Unmarshal(*v, &publicKeyProperties)
				if err != nil {
					return err
				}
				pk.PublicKeyProperties = &publicKeyProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pk.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pk.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pk.Type = &typeVar
			}
		}
	}

	return nil
}

// PublicKeyList publicKey Collection
type PublicKeyList struct {
	autorest.Response `json:"-"`
	// Value - List of public keys.
	Value *[]PublicKey `json:"value,omitempty"`
	// NextLink - Link for the next set of public keys.
	NextLink *string `json:"nextLink,omitempty"`
}

// PublicKeyListIterator provides access to a complete listing of PublicKey values.
type PublicKeyListIterator struct {
	i    int
	page PublicKeyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublicKeyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicKeyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PublicKeyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublicKeyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublicKeyListIterator) Response() PublicKeyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublicKeyListIterator) Value() PublicKey {
	if !iter.page.NotDone() {
		return PublicKey{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PublicKeyListIterator type.
func NewPublicKeyListIterator(page PublicKeyListPage) PublicKeyListIterator {
	return PublicKeyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pkl PublicKeyList) IsEmpty() bool {
	return pkl.Value == nil || len(*pkl.Value) == 0
}

// publicKeyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pkl PublicKeyList) publicKeyListPreparer(ctx context.Context) (*http.Request, error) {
	if pkl.NextLink == nil || len(to.String(pkl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pkl.NextLink)))
}

// PublicKeyListPage contains a page of PublicKey values.
type PublicKeyListPage struct {
	fn  func(context.Context, PublicKeyList) (PublicKeyList, error)
	pkl PublicKeyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublicKeyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicKeyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pkl)
	if err != nil {
		return err
	}
	page.pkl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PublicKeyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublicKeyListPage) NotDone() bool {
	return !page.pkl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublicKeyListPage) Response() PublicKeyList {
	return page.pkl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublicKeyListPage) Values() []PublicKey {
	if page.pkl.IsEmpty() {
		return nil
	}
	return *page.pkl.Value
}

// Creates a new instance of the PublicKeyListPage type.
func NewPublicKeyListPage(getNextPage func(context.Context, PublicKeyList) (PublicKeyList, error)) PublicKeyListPage {
	return PublicKeyListPage{fn: getNextPage}
}

// PublicKeyProperties publicKey Properties
type PublicKeyProperties struct {
	// DataServiceLevel1Key - Level one public key for encryption
	DataServiceLevel1Key *Key `json:"dataServiceLevel1Key,omitempty"`
	// DataServiceLevel2Key - Level two public key for encryption
	DataServiceLevel2Key *Key `json:"dataServiceLevel2Key,omitempty"`
}

// Resource model of the Resource.
type Resource struct {
	// ID - READ-ONLY; The Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The Resource Name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The Resource type.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East
	// US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo
	// region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	return json.Marshal(objectMap)
}

// RunParameters run parameters for a job.
type RunParameters struct {
	// UserConfirmation - Enum to detect if user confirmation is required. If not passed will default to NotRequired. Possible values include: 'NotRequired', 'Required'
	UserConfirmation UserConfirmation `json:"userConfirmation,omitempty"`
	// DataServiceInput - A generic json used differently by each data service type.
	DataServiceInput interface{} `json:"dataServiceInput,omitempty"`
	// CustomerSecrets - List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
	CustomerSecrets *[]CustomerSecret `json:"customerSecrets,omitempty"`
}

// Schedule schedule for the job run.
type Schedule struct {
	// Name - Name of the schedule.
	Name *string `json:"name,omitempty"`
	// PolicyList - A list of repetition intervals in ISO 8601 format.
	PolicyList *[]string `json:"policyList,omitempty"`
}

// Sku the sku type.
type Sku struct {
	// Name - The sku name. Required for data manager creation, optional for update.
	Name *string `json:"name,omitempty"`
	// Tier - The sku tier. This is based on the SKU name.
	Tier *string `json:"tier,omitempty"`
}
