package serialconsole

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ListConsoleClient is the azure Virtual Machine Serial Console allows you to access serial console of a Virtual
// Machine
type ListConsoleClient struct {
	BaseClient
}

// NewListConsoleClient creates an instance of the ListConsoleClient client.
func NewListConsoleClient(subscriptionID string) ListConsoleClient {
	return NewListConsoleClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewListConsoleClientWithBaseURI creates an instance of the ListConsoleClient client.
func NewListConsoleClientWithBaseURI(baseURI string, subscriptionID string) ListConsoleClient {
	return ListConsoleClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Disabled gets if Serial Console is disabled for a subscription.
func (client ListConsoleClient) Disabled(ctx context.Context) (result GetDisabledResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListConsoleClient.Disabled")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DisabledPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "serialconsole.ListConsoleClient", "Disabled", nil, "Failure preparing request")
		return
	}

	resp, err := client.DisabledSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "serialconsole.ListConsoleClient", "Disabled", resp, "Failure sending request")
		return
	}

	result, err = client.DisabledResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "serialconsole.ListConsoleClient", "Disabled", resp, "Failure responding to request")
	}

	return
}

// DisabledPreparer prepares the Disabled request.
func (client ListConsoleClient) DisabledPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"default":        autorest.Encode("path", "default"),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.SerialConsole/consoleServices/{default}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DisabledSender sends the Disabled request. The method will close the
// http.Response Body if it receives an error.
func (client ListConsoleClient) DisabledSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DisabledResponder handles the response to the Disabled request. The method always
// closes the http.Response Body.
func (client ListConsoleClient) DisabledResponder(resp *http.Response) (result GetDisabledResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
