package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DiagnosticsClient is the webSite Management Client
type DiagnosticsClient struct {
	BaseClient
}

// NewDiagnosticsClient creates an instance of the DiagnosticsClient client.
func NewDiagnosticsClient(subscriptionID string) DiagnosticsClient {
	return NewDiagnosticsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDiagnosticsClientWithBaseURI creates an instance of the DiagnosticsClient client.
func NewDiagnosticsClientWithBaseURI(baseURI string, subscriptionID string) DiagnosticsClient {
	return DiagnosticsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ExecuteSiteAnalysis execute Analysis
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - category Name
// analysisName - analysis Resource Name
// startTime - start Time
// endTime - end Time
// timeGrain - time Grain
func (client DiagnosticsClient) ExecuteSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DiagnosticAnalysis, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ExecuteSiteAnalysis")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ExecuteSiteAnalysis", err.Error())
	}

	req, err := client.ExecuteSiteAnalysisPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysis", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteSiteAnalysisSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysis", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteSiteAnalysisResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysis", resp, "Failure responding to request")
	}

	return
}

// ExecuteSiteAnalysisPreparer prepares the ExecuteSiteAnalysis request.
func (client DiagnosticsClient) ExecuteSiteAnalysisPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"analysisName":       autorest.Encode("path", analysisName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteSiteAnalysisSender sends the ExecuteSiteAnalysis request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ExecuteSiteAnalysisSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ExecuteSiteAnalysisResponder handles the response to the ExecuteSiteAnalysis request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ExecuteSiteAnalysisResponder(resp *http.Response) (result DiagnosticAnalysis, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ExecuteSiteAnalysisSlot execute Analysis
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - category Name
// analysisName - analysis Resource Name
// slot - slot Name
// startTime - start Time
// endTime - end Time
// timeGrain - time Grain
func (client DiagnosticsClient) ExecuteSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DiagnosticAnalysis, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ExecuteSiteAnalysisSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ExecuteSiteAnalysisSlot", err.Error())
	}

	req, err := client.ExecuteSiteAnalysisSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysisSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteSiteAnalysisSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysisSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteSiteAnalysisSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteAnalysisSlot", resp, "Failure responding to request")
	}

	return
}

// ExecuteSiteAnalysisSlotPreparer prepares the ExecuteSiteAnalysisSlot request.
func (client DiagnosticsClient) ExecuteSiteAnalysisSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"analysisName":       autorest.Encode("path", analysisName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteSiteAnalysisSlotSender sends the ExecuteSiteAnalysisSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ExecuteSiteAnalysisSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ExecuteSiteAnalysisSlotResponder handles the response to the ExecuteSiteAnalysisSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ExecuteSiteAnalysisSlotResponder(resp *http.Response) (result DiagnosticAnalysis, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ExecuteSiteDetector execute Detector
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// detectorName - detector Resource Name
// diagnosticCategory - category Name
// startTime - start Time
// endTime - end Time
// timeGrain - time Grain
func (client DiagnosticsClient) ExecuteSiteDetector(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DiagnosticDetectorResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ExecuteSiteDetector")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ExecuteSiteDetector", err.Error())
	}

	req, err := client.ExecuteSiteDetectorPreparer(ctx, resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetector", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteSiteDetectorSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetector", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteSiteDetectorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetector", resp, "Failure responding to request")
	}

	return
}

// ExecuteSiteDetectorPreparer prepares the ExecuteSiteDetector request.
func (client DiagnosticsClient) ExecuteSiteDetectorPreparer(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":       autorest.Encode("path", detectorName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteSiteDetectorSender sends the ExecuteSiteDetector request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ExecuteSiteDetectorSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ExecuteSiteDetectorResponder handles the response to the ExecuteSiteDetector request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ExecuteSiteDetectorResponder(resp *http.Response) (result DiagnosticDetectorResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ExecuteSiteDetectorSlot execute Detector
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// detectorName - detector Resource Name
// diagnosticCategory - category Name
// slot - slot Name
// startTime - start Time
// endTime - end Time
// timeGrain - time Grain
func (client DiagnosticsClient) ExecuteSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DiagnosticDetectorResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ExecuteSiteDetectorSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ExecuteSiteDetectorSlot", err.Error())
	}

	req, err := client.ExecuteSiteDetectorSlotPreparer(ctx, resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetectorSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExecuteSiteDetectorSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetectorSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ExecuteSiteDetectorSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ExecuteSiteDetectorSlot", resp, "Failure responding to request")
	}

	return
}

// ExecuteSiteDetectorSlotPreparer prepares the ExecuteSiteDetectorSlot request.
func (client DiagnosticsClient) ExecuteSiteDetectorSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":       autorest.Encode("path", detectorName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExecuteSiteDetectorSlotSender sends the ExecuteSiteDetectorSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ExecuteSiteDetectorSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ExecuteSiteDetectorSlotResponder handles the response to the ExecuteSiteDetectorSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ExecuteSiteDetectorSlotResponder(resp *http.Response) (result DiagnosticDetectorResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentDetectorResponse get Hosting Environment Detector Response
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - app Service Environment Name
// detectorName - detector Resource Name
// startTime - start Time
// endTime - end Time
// timeGrain - time Grain
func (client DiagnosticsClient) GetHostingEnvironmentDetectorResponse(ctx context.Context, resourceGroupName string, name string, detectorName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DetectorResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetHostingEnvironmentDetectorResponse")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "GetHostingEnvironmentDetectorResponse", err.Error())
	}

	req, err := client.GetHostingEnvironmentDetectorResponsePreparer(ctx, resourceGroupName, name, detectorName, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetHostingEnvironmentDetectorResponse", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentDetectorResponseSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetHostingEnvironmentDetectorResponse", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostingEnvironmentDetectorResponseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetHostingEnvironmentDetectorResponse", resp, "Failure responding to request")
	}

	return
}

// GetHostingEnvironmentDetectorResponsePreparer prepares the GetHostingEnvironmentDetectorResponse request.
func (client DiagnosticsClient) GetHostingEnvironmentDetectorResponsePreparer(ctx context.Context, resourceGroupName string, name string, detectorName string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":      autorest.Encode("path", detectorName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors/{detectorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentDetectorResponseSender sends the GetHostingEnvironmentDetectorResponse request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetHostingEnvironmentDetectorResponseSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentDetectorResponseResponder handles the response to the GetHostingEnvironmentDetectorResponse request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetHostingEnvironmentDetectorResponseResponder(resp *http.Response) (result DetectorResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteAnalysis get Site Analysis
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
// analysisName - analysis Name
func (client DiagnosticsClient) GetSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string) (result DiagnosticAnalysis, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteAnalysis")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "GetSiteAnalysis", err.Error())
	}

	req, err := client.GetSiteAnalysisPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysis", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteAnalysisSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysis", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteAnalysisResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysis", resp, "Failure responding to request")
	}

	return
}

// GetSiteAnalysisPreparer prepares the GetSiteAnalysis request.
func (client DiagnosticsClient) GetSiteAnalysisPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"analysisName":       autorest.Encode("path", analysisName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteAnalysisSender sends the GetSiteAnalysis request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteAnalysisSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteAnalysisResponder handles the response to the GetSiteAnalysis request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteAnalysisResponder(resp *http.Response) (result DiagnosticAnalysis, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteAnalysisSlot get Site Analysis
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
// analysisName - analysis Name
// slot - slot - optional
func (client DiagnosticsClient) GetSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string) (result DiagnosticAnalysis, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteAnalysisSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "GetSiteAnalysisSlot", err.Error())
	}

	req, err := client.GetSiteAnalysisSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, analysisName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysisSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteAnalysisSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysisSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteAnalysisSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteAnalysisSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteAnalysisSlotPreparer prepares the GetSiteAnalysisSlot request.
func (client DiagnosticsClient) GetSiteAnalysisSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"analysisName":       autorest.Encode("path", analysisName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteAnalysisSlotSender sends the GetSiteAnalysisSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteAnalysisSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteAnalysisSlotResponder handles the response to the GetSiteAnalysisSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteAnalysisSlotResponder(resp *http.Response) (result DiagnosticAnalysis, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteDetector get Detector
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
// detectorName - detector Name
func (client DiagnosticsClient) GetSiteDetector(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string) (result DiagnosticDetectorCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteDetector")
		defer func() {
			sc := -1
			if result.ddc.Response.Response != nil {
				sc = result.ddc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "GetSiteDetector", err.Error())
	}

	result.fn = client.getSiteDetectorNextResults
	req, err := client.GetSiteDetectorPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetector", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDetectorSender(req)
	if err != nil {
		result.ddc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetector", resp, "Failure sending request")
		return
	}

	result.ddc, err = client.GetSiteDetectorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetector", resp, "Failure responding to request")
	}

	return
}

// GetSiteDetectorPreparer prepares the GetSiteDetector request.
func (client DiagnosticsClient) GetSiteDetectorPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":       autorest.Encode("path", detectorName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDetectorSender sends the GetSiteDetector request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDetectorSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDetectorResponder handles the response to the GetSiteDetector request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDetectorResponder(resp *http.Response) (result DiagnosticDetectorCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteDetectorNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) getSiteDetectorNextResults(ctx context.Context, lastResults DiagnosticDetectorCollection) (result DiagnosticDetectorCollection, err error) {
	req, err := lastResults.diagnosticDetectorCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteDetectorSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteDetectorResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteDetectorComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) GetSiteDetectorComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string) (result DiagnosticDetectorCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteDetector")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteDetector(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName)
	return
}

// GetSiteDetectorResponse get site detector response
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// detectorName - detector Resource Name
// startTime - start Time
// endTime - end Time
// timeGrain - time Grain
func (client DiagnosticsClient) GetSiteDetectorResponse(ctx context.Context, resourceGroupName string, siteName string, detectorName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DetectorResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteDetectorResponse")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "GetSiteDetectorResponse", err.Error())
	}

	req, err := client.GetSiteDetectorResponsePreparer(ctx, resourceGroupName, siteName, detectorName, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorResponse", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDetectorResponseSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorResponse", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteDetectorResponseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorResponse", resp, "Failure responding to request")
	}

	return
}

// GetSiteDetectorResponsePreparer prepares the GetSiteDetectorResponse request.
func (client DiagnosticsClient) GetSiteDetectorResponsePreparer(ctx context.Context, resourceGroupName string, siteName string, detectorName string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":      autorest.Encode("path", detectorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors/{detectorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDetectorResponseSender sends the GetSiteDetectorResponse request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDetectorResponseSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDetectorResponseResponder handles the response to the GetSiteDetectorResponse request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDetectorResponseResponder(resp *http.Response) (result DetectorResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteDetectorResponseSlot get site detector response
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// detectorName - detector Resource Name
// slot - slot Name
// startTime - start Time
// endTime - end Time
// timeGrain - time Grain
func (client DiagnosticsClient) GetSiteDetectorResponseSlot(ctx context.Context, resourceGroupName string, siteName string, detectorName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result DetectorResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteDetectorResponseSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: timeGrain,
			Constraints: []validation.Constraint{{Target: "timeGrain", Name: validation.Pattern, Rule: `PT[1-9][0-9]+[SMH]`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "GetSiteDetectorResponseSlot", err.Error())
	}

	req, err := client.GetSiteDetectorResponseSlotPreparer(ctx, resourceGroupName, siteName, detectorName, slot, startTime, endTime, timeGrain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorResponseSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDetectorResponseSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorResponseSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteDetectorResponseSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorResponseSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteDetectorResponseSlotPreparer prepares the GetSiteDetectorResponseSlot request.
func (client DiagnosticsClient) GetSiteDetectorResponseSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, detectorName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":      autorest.Encode("path", detectorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if startTime != nil {
		queryParameters["startTime"] = autorest.Encode("query", *startTime)
	}
	if endTime != nil {
		queryParameters["endTime"] = autorest.Encode("query", *endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors/{detectorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDetectorResponseSlotSender sends the GetSiteDetectorResponseSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDetectorResponseSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDetectorResponseSlotResponder handles the response to the GetSiteDetectorResponseSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDetectorResponseSlotResponder(resp *http.Response) (result DetectorResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteDetectorSlot get Detector
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
// detectorName - detector Name
// slot - slot Name
func (client DiagnosticsClient) GetSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string) (result DiagnosticDetectorCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteDetectorSlot")
		defer func() {
			sc := -1
			if result.ddc.Response.Response != nil {
				sc = result.ddc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "GetSiteDetectorSlot", err.Error())
	}

	result.fn = client.getSiteDetectorSlotNextResults
	req, err := client.GetSiteDetectorSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDetectorSlotSender(req)
	if err != nil {
		result.ddc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorSlot", resp, "Failure sending request")
		return
	}

	result.ddc, err = client.GetSiteDetectorSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDetectorSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteDetectorSlotPreparer prepares the GetSiteDetectorSlot request.
func (client DiagnosticsClient) GetSiteDetectorSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"detectorName":       autorest.Encode("path", detectorName),
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDetectorSlotSender sends the GetSiteDetectorSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDetectorSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDetectorSlotResponder handles the response to the GetSiteDetectorSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDetectorSlotResponder(resp *http.Response) (result DiagnosticDetectorCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteDetectorSlotNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) getSiteDetectorSlotNextResults(ctx context.Context, lastResults DiagnosticDetectorCollection) (result DiagnosticDetectorCollection, err error) {
	req, err := lastResults.diagnosticDetectorCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteDetectorSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteDetectorSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "getSiteDetectorSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteDetectorSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) GetSiteDetectorSlotComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string) (result DiagnosticDetectorCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteDetectorSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteDetectorSlot(ctx, resourceGroupName, siteName, diagnosticCategory, detectorName, slot)
	return
}

// GetSiteDiagnosticCategory get Diagnostics Category
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
func (client DiagnosticsClient) GetSiteDiagnosticCategory(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticCategory, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteDiagnosticCategory")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "GetSiteDiagnosticCategory", err.Error())
	}

	req, err := client.GetSiteDiagnosticCategoryPreparer(ctx, resourceGroupName, siteName, diagnosticCategory)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategory", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDiagnosticCategorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategory", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteDiagnosticCategoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategory", resp, "Failure responding to request")
	}

	return
}

// GetSiteDiagnosticCategoryPreparer prepares the GetSiteDiagnosticCategory request.
func (client DiagnosticsClient) GetSiteDiagnosticCategoryPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDiagnosticCategorySender sends the GetSiteDiagnosticCategory request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDiagnosticCategorySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDiagnosticCategoryResponder handles the response to the GetSiteDiagnosticCategory request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDiagnosticCategoryResponder(resp *http.Response) (result DiagnosticCategory, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteDiagnosticCategorySlot get Diagnostics Category
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
// slot - slot Name
func (client DiagnosticsClient) GetSiteDiagnosticCategorySlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticCategory, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.GetSiteDiagnosticCategorySlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "GetSiteDiagnosticCategorySlot", err.Error())
	}

	req, err := client.GetSiteDiagnosticCategorySlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategorySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteDiagnosticCategorySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategorySlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteDiagnosticCategorySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "GetSiteDiagnosticCategorySlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteDiagnosticCategorySlotPreparer prepares the GetSiteDiagnosticCategorySlot request.
func (client DiagnosticsClient) GetSiteDiagnosticCategorySlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteDiagnosticCategorySlotSender sends the GetSiteDiagnosticCategorySlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) GetSiteDiagnosticCategorySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteDiagnosticCategorySlotResponder handles the response to the GetSiteDiagnosticCategorySlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) GetSiteDiagnosticCategorySlotResponder(resp *http.Response) (result DiagnosticCategory, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHostingEnvironmentDetectorResponses list Hosting Environment Detector Responses
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site Name
func (client DiagnosticsClient) ListHostingEnvironmentDetectorResponses(ctx context.Context, resourceGroupName string, name string) (result DetectorResponseCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListHostingEnvironmentDetectorResponses")
		defer func() {
			sc := -1
			if result.drc.Response.Response != nil {
				sc = result.drc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ListHostingEnvironmentDetectorResponses", err.Error())
	}

	result.fn = client.listHostingEnvironmentDetectorResponsesNextResults
	req, err := client.ListHostingEnvironmentDetectorResponsesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListHostingEnvironmentDetectorResponses", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHostingEnvironmentDetectorResponsesSender(req)
	if err != nil {
		result.drc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListHostingEnvironmentDetectorResponses", resp, "Failure sending request")
		return
	}

	result.drc, err = client.ListHostingEnvironmentDetectorResponsesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListHostingEnvironmentDetectorResponses", resp, "Failure responding to request")
	}

	return
}

// ListHostingEnvironmentDetectorResponsesPreparer prepares the ListHostingEnvironmentDetectorResponses request.
func (client DiagnosticsClient) ListHostingEnvironmentDetectorResponsesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHostingEnvironmentDetectorResponsesSender sends the ListHostingEnvironmentDetectorResponses request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListHostingEnvironmentDetectorResponsesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHostingEnvironmentDetectorResponsesResponder handles the response to the ListHostingEnvironmentDetectorResponses request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListHostingEnvironmentDetectorResponsesResponder(resp *http.Response) (result DetectorResponseCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listHostingEnvironmentDetectorResponsesNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listHostingEnvironmentDetectorResponsesNextResults(ctx context.Context, lastResults DetectorResponseCollection) (result DetectorResponseCollection, err error) {
	req, err := lastResults.detectorResponseCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listHostingEnvironmentDetectorResponsesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListHostingEnvironmentDetectorResponsesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listHostingEnvironmentDetectorResponsesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListHostingEnvironmentDetectorResponsesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listHostingEnvironmentDetectorResponsesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListHostingEnvironmentDetectorResponsesComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListHostingEnvironmentDetectorResponsesComplete(ctx context.Context, resourceGroupName string, name string) (result DetectorResponseCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListHostingEnvironmentDetectorResponses")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListHostingEnvironmentDetectorResponses(ctx, resourceGroupName, name)
	return
}

// ListSiteAnalyses get Site Analyses
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
func (client DiagnosticsClient) ListSiteAnalyses(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticAnalysisCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteAnalyses")
		defer func() {
			sc := -1
			if result.dac.Response.Response != nil {
				sc = result.dac.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ListSiteAnalyses", err.Error())
	}

	result.fn = client.listSiteAnalysesNextResults
	req, err := client.ListSiteAnalysesPreparer(ctx, resourceGroupName, siteName, diagnosticCategory)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalyses", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteAnalysesSender(req)
	if err != nil {
		result.dac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalyses", resp, "Failure sending request")
		return
	}

	result.dac, err = client.ListSiteAnalysesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalyses", resp, "Failure responding to request")
	}

	return
}

// ListSiteAnalysesPreparer prepares the ListSiteAnalyses request.
func (client DiagnosticsClient) ListSiteAnalysesPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteAnalysesSender sends the ListSiteAnalyses request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteAnalysesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteAnalysesResponder handles the response to the ListSiteAnalyses request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteAnalysesResponder(resp *http.Response) (result DiagnosticAnalysisCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteAnalysesNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteAnalysesNextResults(ctx context.Context, lastResults DiagnosticAnalysisCollection) (result DiagnosticAnalysisCollection, err error) {
	req, err := lastResults.diagnosticAnalysisCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteAnalysesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteAnalysesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteAnalysesComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteAnalysesComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticAnalysisCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteAnalyses")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteAnalyses(ctx, resourceGroupName, siteName, diagnosticCategory)
	return
}

// ListSiteAnalysesSlot get Site Analyses
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
// slot - slot Name
func (client DiagnosticsClient) ListSiteAnalysesSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticAnalysisCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteAnalysesSlot")
		defer func() {
			sc := -1
			if result.dac.Response.Response != nil {
				sc = result.dac.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ListSiteAnalysesSlot", err.Error())
	}

	result.fn = client.listSiteAnalysesSlotNextResults
	req, err := client.ListSiteAnalysesSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalysesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteAnalysesSlotSender(req)
	if err != nil {
		result.dac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalysesSlot", resp, "Failure sending request")
		return
	}

	result.dac, err = client.ListSiteAnalysesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteAnalysesSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteAnalysesSlotPreparer prepares the ListSiteAnalysesSlot request.
func (client DiagnosticsClient) ListSiteAnalysesSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteAnalysesSlotSender sends the ListSiteAnalysesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteAnalysesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteAnalysesSlotResponder handles the response to the ListSiteAnalysesSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteAnalysesSlotResponder(resp *http.Response) (result DiagnosticAnalysisCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteAnalysesSlotNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteAnalysesSlotNextResults(ctx context.Context, lastResults DiagnosticAnalysisCollection) (result DiagnosticAnalysisCollection, err error) {
	req, err := lastResults.diagnosticAnalysisCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteAnalysesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteAnalysesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteAnalysesSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteAnalysesSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteAnalysesSlotComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticAnalysisCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteAnalysesSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteAnalysesSlot(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	return
}

// ListSiteDetectorResponses list Site Detector Responses
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
func (client DiagnosticsClient) ListSiteDetectorResponses(ctx context.Context, resourceGroupName string, siteName string) (result DetectorResponseCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDetectorResponses")
		defer func() {
			sc := -1
			if result.drc.Response.Response != nil {
				sc = result.drc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ListSiteDetectorResponses", err.Error())
	}

	result.fn = client.listSiteDetectorResponsesNextResults
	req, err := client.ListSiteDetectorResponsesPreparer(ctx, resourceGroupName, siteName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorResponses", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDetectorResponsesSender(req)
	if err != nil {
		result.drc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorResponses", resp, "Failure sending request")
		return
	}

	result.drc, err = client.ListSiteDetectorResponsesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorResponses", resp, "Failure responding to request")
	}

	return
}

// ListSiteDetectorResponsesPreparer prepares the ListSiteDetectorResponses request.
func (client DiagnosticsClient) ListSiteDetectorResponsesPreparer(ctx context.Context, resourceGroupName string, siteName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDetectorResponsesSender sends the ListSiteDetectorResponses request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDetectorResponsesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDetectorResponsesResponder handles the response to the ListSiteDetectorResponses request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDetectorResponsesResponder(resp *http.Response) (result DetectorResponseCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDetectorResponsesNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDetectorResponsesNextResults(ctx context.Context, lastResults DetectorResponseCollection) (result DetectorResponseCollection, err error) {
	req, err := lastResults.detectorResponseCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorResponsesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDetectorResponsesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorResponsesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDetectorResponsesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorResponsesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDetectorResponsesComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDetectorResponsesComplete(ctx context.Context, resourceGroupName string, siteName string) (result DetectorResponseCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDetectorResponses")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteDetectorResponses(ctx, resourceGroupName, siteName)
	return
}

// ListSiteDetectorResponsesSlot list Site Detector Responses
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// slot - slot Name
func (client DiagnosticsClient) ListSiteDetectorResponsesSlot(ctx context.Context, resourceGroupName string, siteName string, slot string) (result DetectorResponseCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDetectorResponsesSlot")
		defer func() {
			sc := -1
			if result.drc.Response.Response != nil {
				sc = result.drc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ListSiteDetectorResponsesSlot", err.Error())
	}

	result.fn = client.listSiteDetectorResponsesSlotNextResults
	req, err := client.ListSiteDetectorResponsesSlotPreparer(ctx, resourceGroupName, siteName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorResponsesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDetectorResponsesSlotSender(req)
	if err != nil {
		result.drc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorResponsesSlot", resp, "Failure sending request")
		return
	}

	result.drc, err = client.ListSiteDetectorResponsesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorResponsesSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteDetectorResponsesSlotPreparer prepares the ListSiteDetectorResponsesSlot request.
func (client DiagnosticsClient) ListSiteDetectorResponsesSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDetectorResponsesSlotSender sends the ListSiteDetectorResponsesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDetectorResponsesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDetectorResponsesSlotResponder handles the response to the ListSiteDetectorResponsesSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDetectorResponsesSlotResponder(resp *http.Response) (result DetectorResponseCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDetectorResponsesSlotNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDetectorResponsesSlotNextResults(ctx context.Context, lastResults DetectorResponseCollection) (result DetectorResponseCollection, err error) {
	req, err := lastResults.detectorResponseCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorResponsesSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDetectorResponsesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorResponsesSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDetectorResponsesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorResponsesSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDetectorResponsesSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDetectorResponsesSlotComplete(ctx context.Context, resourceGroupName string, siteName string, slot string) (result DetectorResponseCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDetectorResponsesSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteDetectorResponsesSlot(ctx, resourceGroupName, siteName, slot)
	return
}

// ListSiteDetectors get Detectors
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
func (client DiagnosticsClient) ListSiteDetectors(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticDetectorCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDetectors")
		defer func() {
			sc := -1
			if result.ddc.Response.Response != nil {
				sc = result.ddc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ListSiteDetectors", err.Error())
	}

	result.fn = client.listSiteDetectorsNextResults
	req, err := client.ListSiteDetectorsPreparer(ctx, resourceGroupName, siteName, diagnosticCategory)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectors", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDetectorsSender(req)
	if err != nil {
		result.ddc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectors", resp, "Failure sending request")
		return
	}

	result.ddc, err = client.ListSiteDetectorsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectors", resp, "Failure responding to request")
	}

	return
}

// ListSiteDetectorsPreparer prepares the ListSiteDetectors request.
func (client DiagnosticsClient) ListSiteDetectorsPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDetectorsSender sends the ListSiteDetectors request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDetectorsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDetectorsResponder handles the response to the ListSiteDetectors request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDetectorsResponder(resp *http.Response) (result DiagnosticDetectorCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDetectorsNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDetectorsNextResults(ctx context.Context, lastResults DiagnosticDetectorCollection) (result DiagnosticDetectorCollection, err error) {
	req, err := lastResults.diagnosticDetectorCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDetectorsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDetectorsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDetectorsComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDetectorsComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result DiagnosticDetectorCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDetectors")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteDetectors(ctx, resourceGroupName, siteName, diagnosticCategory)
	return
}

// ListSiteDetectorsSlot get Detectors
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// diagnosticCategory - diagnostic Category
// slot - slot Name
func (client DiagnosticsClient) ListSiteDetectorsSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticDetectorCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDetectorsSlot")
		defer func() {
			sc := -1
			if result.ddc.Response.Response != nil {
				sc = result.ddc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ListSiteDetectorsSlot", err.Error())
	}

	result.fn = client.listSiteDetectorsSlotNextResults
	req, err := client.ListSiteDetectorsSlotPreparer(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDetectorsSlotSender(req)
	if err != nil {
		result.ddc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorsSlot", resp, "Failure sending request")
		return
	}

	result.ddc, err = client.ListSiteDetectorsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDetectorsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteDetectorsSlotPreparer prepares the ListSiteDetectorsSlot request.
func (client DiagnosticsClient) ListSiteDetectorsSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticCategory": autorest.Encode("path", diagnosticCategory),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"siteName":           autorest.Encode("path", siteName),
		"slot":               autorest.Encode("path", slot),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDetectorsSlotSender sends the ListSiteDetectorsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDetectorsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDetectorsSlotResponder handles the response to the ListSiteDetectorsSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDetectorsSlotResponder(resp *http.Response) (result DiagnosticDetectorCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDetectorsSlotNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDetectorsSlotNextResults(ctx context.Context, lastResults DiagnosticDetectorCollection) (result DiagnosticDetectorCollection, err error) {
	req, err := lastResults.diagnosticDetectorCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDetectorsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDetectorsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDetectorsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDetectorsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDetectorsSlotComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result DiagnosticDetectorCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDetectorsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteDetectorsSlot(ctx, resourceGroupName, siteName, diagnosticCategory, slot)
	return
}

// ListSiteDiagnosticCategories get Diagnostics Categories
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
func (client DiagnosticsClient) ListSiteDiagnosticCategories(ctx context.Context, resourceGroupName string, siteName string) (result DiagnosticCategoryCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDiagnosticCategories")
		defer func() {
			sc := -1
			if result.dcc.Response.Response != nil {
				sc = result.dcc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ListSiteDiagnosticCategories", err.Error())
	}

	result.fn = client.listSiteDiagnosticCategoriesNextResults
	req, err := client.ListSiteDiagnosticCategoriesPreparer(ctx, resourceGroupName, siteName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategories", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDiagnosticCategoriesSender(req)
	if err != nil {
		result.dcc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategories", resp, "Failure sending request")
		return
	}

	result.dcc, err = client.ListSiteDiagnosticCategoriesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategories", resp, "Failure responding to request")
	}

	return
}

// ListSiteDiagnosticCategoriesPreparer prepares the ListSiteDiagnosticCategories request.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesPreparer(ctx context.Context, resourceGroupName string, siteName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDiagnosticCategoriesSender sends the ListSiteDiagnosticCategories request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDiagnosticCategoriesResponder handles the response to the ListSiteDiagnosticCategories request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesResponder(resp *http.Response) (result DiagnosticCategoryCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDiagnosticCategoriesNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDiagnosticCategoriesNextResults(ctx context.Context, lastResults DiagnosticCategoryCollection) (result DiagnosticCategoryCollection, err error) {
	req, err := lastResults.diagnosticCategoryCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDiagnosticCategoriesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDiagnosticCategoriesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDiagnosticCategoriesComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesComplete(ctx context.Context, resourceGroupName string, siteName string) (result DiagnosticCategoryCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDiagnosticCategories")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteDiagnosticCategories(ctx, resourceGroupName, siteName)
	return
}

// ListSiteDiagnosticCategoriesSlot get Diagnostics Categories
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// siteName - site Name
// slot - slot Name
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlot(ctx context.Context, resourceGroupName string, siteName string, slot string) (result DiagnosticCategoryCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDiagnosticCategoriesSlot")
		defer func() {
			sc := -1
			if result.dcc.Response.Response != nil {
				sc = result.dcc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.DiagnosticsClient", "ListSiteDiagnosticCategoriesSlot", err.Error())
	}

	result.fn = client.listSiteDiagnosticCategoriesSlotNextResults
	req, err := client.ListSiteDiagnosticCategoriesSlotPreparer(ctx, resourceGroupName, siteName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategoriesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteDiagnosticCategoriesSlotSender(req)
	if err != nil {
		result.dcc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategoriesSlot", resp, "Failure sending request")
		return
	}

	result.dcc, err = client.ListSiteDiagnosticCategoriesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "ListSiteDiagnosticCategoriesSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteDiagnosticCategoriesSlotPreparer prepares the ListSiteDiagnosticCategoriesSlot request.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlotPreparer(ctx context.Context, resourceGroupName string, siteName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteName":          autorest.Encode("path", siteName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteDiagnosticCategoriesSlotSender sends the ListSiteDiagnosticCategoriesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteDiagnosticCategoriesSlotResponder handles the response to the ListSiteDiagnosticCategoriesSlot request. The method always
// closes the http.Response Body.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlotResponder(resp *http.Response) (result DiagnosticCategoryCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteDiagnosticCategoriesSlotNextResults retrieves the next set of results, if any.
func (client DiagnosticsClient) listSiteDiagnosticCategoriesSlotNextResults(ctx context.Context, lastResults DiagnosticCategoryCollection) (result DiagnosticCategoryCollection, err error) {
	req, err := lastResults.diagnosticCategoryCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteDiagnosticCategoriesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteDiagnosticCategoriesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DiagnosticsClient", "listSiteDiagnosticCategoriesSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteDiagnosticCategoriesSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiagnosticsClient) ListSiteDiagnosticCategoriesSlotComplete(ctx context.Context, resourceGroupName string, siteName string, slot string) (result DiagnosticCategoryCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticsClient.ListSiteDiagnosticCategoriesSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteDiagnosticCategoriesSlot(ctx, resourceGroupName, siteName, slot)
	return
}
