// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptMatch = "AcceptMatch"

// AcceptMatchRequest generates a "aws/request.Request" representing the
// client's request for the AcceptMatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptMatch for more information on using the AcceptMatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptMatchRequest method.
//    req, resp := client.AcceptMatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AcceptMatch
func (c *GameLift) AcceptMatchRequest(input *AcceptMatchInput) (req *request.Request, output *AcceptMatchOutput) {
	op := &request.Operation{
		Name:       opAcceptMatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptMatchInput{}
	}

	output = &AcceptMatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptMatch API operation for Amazon GameLift.
//
// Registers a player's acceptance or rejection of a proposed FlexMatch match.
// A matchmaking configuration may require player acceptance; if so, then matches
// built with that configuration cannot be completed unless all players accept
// the proposed match within a specified time limit.
//
// When FlexMatch builds a match, all the matchmaking tickets involved in the
// proposed match are placed into status REQUIRES_ACCEPTANCE. This is a trigger
// for your game to get acceptance from all players in the ticket. Acceptances
// are only valid for tickets when they are in this status; all other acceptances
// result in an error.
//
// To register acceptance, specify the ticket ID, a response, and one or more
// players. Once all players have registered acceptance, the matchmaking tickets
// advance to status PLACING, where a new game session is created for the match.
//
// If any player rejects the match, or if acceptances are not received before
// a specified timeout, the proposed match is dropped. The matchmaking tickets
// are then handled in one of two ways: For tickets where all players accepted
// the match, the ticket status is returned to SEARCHING to find a new match.
// For tickets where one or more players failed to accept the match, the ticket
// status is set to FAILED, and processing is terminated. A new matchmaking
// request for these players can be submitted as needed.
//
// Matchmaking-related operations include:
//
//    * StartMatchmaking
//
//    * DescribeMatchmaking
//
//    * StopMatchmaking
//
//    * AcceptMatch
//
//    * StartMatchBackfill
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation AcceptMatch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AcceptMatch
func (c *GameLift) AcceptMatch(input *AcceptMatchInput) (*AcceptMatchOutput, error) {
	req, out := c.AcceptMatchRequest(input)
	return out, req.Send()
}

// AcceptMatchWithContext is the same as AcceptMatch with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptMatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) AcceptMatchWithContext(ctx aws.Context, input *AcceptMatchInput, opts ...request.Option) (*AcceptMatchOutput, error) {
	req, out := c.AcceptMatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias
func (c *GameLift) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &CreateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlias API operation for Amazon GameLift.
//
// Creates an alias for a fleet. In most situations, you can use an alias ID
// in place of a fleet ID. By using a fleet alias instead of a specific fleet
// ID, you can switch gameplay and players to a new fleet without changing your
// game client or other game components. For example, for games in production,
// using an alias allows you to seamlessly redirect your player base to a new
// game server update.
//
// Amazon GameLift supports two types of routing strategies for aliases: simple
// and terminal. A simple alias points to an active fleet. A terminal alias
// is used to display messaging or link to a URL instead of routing players
// to an active fleet. For example, you might use a terminal alias when a game
// version is no longer supported and you want to direct players to an upgrade
// site.
//
// To create a fleet alias, specify an alias name, routing strategy, and optional
// description. Each simple alias can point to only one fleet, but a fleet can
// have multiple aliases. If successful, a new alias record is returned, including
// an alias ID, which you can reference when creating a game session. You can
// reassign an alias to another fleet by calling UpdateAlias.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias
func (c *GameLift) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBuild = "CreateBuild"

// CreateBuildRequest generates a "aws/request.Request" representing the
// client's request for the CreateBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBuild for more information on using the CreateBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBuildRequest method.
//    req, resp := client.CreateBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild
func (c *GameLift) CreateBuildRequest(input *CreateBuildInput) (req *request.Request, output *CreateBuildOutput) {
	op := &request.Operation{
		Name:       opCreateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBuildInput{}
	}

	output = &CreateBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBuild API operation for Amazon GameLift.
//
// Creates a new Amazon GameLift build record for your game server binary files
// and points to the location of your game server build files in an Amazon Simple
// Storage Service (Amazon S3) location.
//
// Game server binaries must be combined into a .zip file for use with Amazon
// GameLift. See Uploading Your Game (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
// for more information.
//
// To create new builds quickly and easily, use the AWS CLI command upload-build
// (http://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html).
// This helper command uploads your build and creates a new build record in
// one step, and automatically handles the necessary permissions. See  Upload
// Build Files to Amazon GameLift (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html)
// for more help.
//
// The CreateBuild operation should be used only when you need to manually upload
// your build files, as in the following scenarios:
//
//    * Store a build file in an Amazon S3 bucket under your own AWS account.
//    To use this option, you must first give Amazon GameLift access to that
//    Amazon S3 bucket. See  Create a Build with Files in Amazon S3 (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build)
//    for detailed help. To create a new build record using files in your Amazon
//    S3 bucket, call CreateBuild and specify a build name, operating system,
//    and the storage location of your game build.
//
//    * Upload a build file directly to Amazon GameLift's Amazon S3 account.
//    To use this option, you first call CreateBuild with a build name and operating
//    system. This action creates a new build record and returns an Amazon S3
//    storage location (bucket and key only) and temporary access credentials.
//    Use the credentials to manually upload your build file to the storage
//    location (see the Amazon S3 topic Uploading Objects (http://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html)).
//    You can upload files to a location only once.
//
// If successful, this operation creates a new build record with a unique build
// ID and places it in INITIALIZED status. You can use DescribeBuild to check
// the status of your build. A build must be in READY status before it can be
// used to create fleets.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild
func (c *GameLift) CreateBuild(input *CreateBuildInput) (*CreateBuildOutput, error) {
	req, out := c.CreateBuildRequest(input)
	return out, req.Send()
}

// CreateBuildWithContext is the same as CreateBuild with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateBuildWithContext(ctx aws.Context, input *CreateBuildInput, opts ...request.Option) (*CreateBuildOutput, error) {
	req, out := c.CreateBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFleetRequest method.
//    req, resp := client.CreateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet
func (c *GameLift) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for Amazon GameLift.
//
// Creates a new fleet to run your game servers. A fleet is a set of Amazon
// Elastic Compute Cloud (Amazon EC2) instances, each of which can run multiple
// server processes to host game sessions. You set up a fleet to use instances
// with certain hardware specifications (see Amazon EC2 Instance Types (http://aws.amazon.com/ec2/instance-types/)
// for more information), and deploy your game build to run on each instance.
//
// To create a new fleet, you must specify the following: (1) a fleet name,
// (2) the build ID of a successfully uploaded game build, (3) an EC2 instance
// type, and (4) a run-time configuration, which describes the server processes
// to run on each instance in the fleet. If you don't specify a fleet type (on-demand
// or spot), the new fleet uses on-demand instances by default.
//
// You can also configure the new fleet with the following settings:
//
//    * Fleet description
//
//    * Access permissions for inbound traffic
//
//    * Fleet-wide game session protection
//
//    * Resource usage limits
//
//    * VPC peering connection (see VPC Peering with Amazon GameLift Fleets
//    (http://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html))
//
// If you use Amazon CloudWatch for metrics, you can add the new fleet to a
// metric group. By adding multiple fleets to a metric group, you can view aggregated
// metrics for all the fleets in the group.
//
// If the CreateFleet call is successful, Amazon GameLift performs the following
// tasks. You can track the process of a fleet by checking the fleet status
// or by monitoring fleet creation events:
//
//    * Creates a fleet record. Status: NEW.
//
//    * Begins writing events to the fleet event log, which can be accessed
//    in the Amazon GameLift console.
//
// Sets the fleet's target capacity to 1 (desired instances), which triggers
//    Amazon GameLift to start one new EC2 instance.
//
//    * Downloads the game build to the new instance and installs it. Statuses:
//    DOWNLOADING, VALIDATING, BUILDING.
//
//    * Starts launching server processes on the instance. If the fleet is configured
//    to run multiple server processes per instance, Amazon GameLift staggers
//    each launch by a few seconds. Status: ACTIVATING.
//
//    * Sets the fleet's status to ACTIVE as soon as one server process is ready
//    to host a game session.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet
func (c *GameLift) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGameSession = "CreateGameSession"

// CreateGameSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateGameSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGameSession for more information on using the CreateGameSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGameSessionRequest method.
//    req, resp := client.CreateGameSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession
func (c *GameLift) CreateGameSessionRequest(input *CreateGameSessionInput) (req *request.Request, output *CreateGameSessionOutput) {
	op := &request.Operation{
		Name:       opCreateGameSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGameSessionInput{}
	}

	output = &CreateGameSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGameSession API operation for Amazon GameLift.
//
// Creates a multiplayer game session for players. This action creates a game
// session record and assigns an available server process in the specified fleet
// to host the game session. A fleet must have an ACTIVE status before a game
// session can be created in it.
//
// To create a game session, specify either fleet ID or alias ID and indicate
// a maximum number of players to allow in the game session. You can also provide
// a name and game-specific properties for this game session. If successful,
// a GameSession object is returned containing the game session properties and
// other settings you specified.
//
// Idempotency tokens. You can add a token that uniquely identifies game session
// requests. This is useful for ensuring that game session requests are idempotent.
// Multiple requests with the same idempotency token are processed only once;
// subsequent requests return the original result. All response values are the
// same with the exception of game session status, which may change.
//
// Resource creation limits. If you are creating a game session on a fleet with
// a resource creation limit policy in force, then you must specify a creator
// ID. Without this ID, Amazon GameLift has no way to evaluate the policy for
// this new game session request.
//
// Player acceptance policy. By default, newly created game sessions are open
// to new players. You can restrict new player access by using UpdateGameSession
// to change the game session's player session creation policy.
//
// Game session logs. Logs are retained for all active game sessions for 14
// days. To access the logs, call GetGameSessionLogUrl to download the log files.
//
// Available in Amazon GameLift Local.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateGameSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeFleetCapacityExceededException "FleetCapacityExceededException"
//   The specified fleet has no available instances to fulfill a CreateGameSession
//   request. Clients can retry such requests immediately or after a waiting period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A game session with this custom ID string already exists in this fleet. Resolve
//   this conflict before retrying this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession
func (c *GameLift) CreateGameSession(input *CreateGameSessionInput) (*CreateGameSessionOutput, error) {
	req, out := c.CreateGameSessionRequest(input)
	return out, req.Send()
}

// CreateGameSessionWithContext is the same as CreateGameSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGameSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateGameSessionWithContext(ctx aws.Context, input *CreateGameSessionInput, opts ...request.Option) (*CreateGameSessionOutput, error) {
	req, out := c.CreateGameSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGameSessionQueue = "CreateGameSessionQueue"

// CreateGameSessionQueueRequest generates a "aws/request.Request" representing the
// client's request for the CreateGameSessionQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGameSessionQueue for more information on using the CreateGameSessionQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGameSessionQueueRequest method.
//    req, resp := client.CreateGameSessionQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue
func (c *GameLift) CreateGameSessionQueueRequest(input *CreateGameSessionQueueInput) (req *request.Request, output *CreateGameSessionQueueOutput) {
	op := &request.Operation{
		Name:       opCreateGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGameSessionQueueInput{}
	}

	output = &CreateGameSessionQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGameSessionQueue API operation for Amazon GameLift.
//
// Establishes a new queue for processing requests to place new game sessions.
// A queue identifies where new game sessions can be hosted -- by specifying
// a list of destinations (fleets or aliases) -- and how long requests can wait
// in the queue before timing out. You can set up a queue to try to place game
// sessions on fleets in multiple regions. To add placement requests to a queue,
// call StartGameSessionPlacement and reference the queue name.
//
// Destination order. When processing a request for a game session, Amazon GameLift
// tries each destination in order until it finds one with available resources
// to host the new game session. A queue's default order is determined by how
// destinations are listed. The default order is overridden when a game session
// placement request provides player latency information. Player latency information
// enables Amazon GameLift to prioritize destinations where players report the
// lowest average latency, as a result placing the new game session where the
// majority of players will have the best possible gameplay experience.
//
// Player latency policies. For placement requests containing player latency
// information, use player latency policies to protect individual players from
// very high latencies. With a latency cap, even when a destination can deliver
// a low latency for most players, the game is not placed where any individual
// player is reporting latency higher than a policy's maximum. A queue can have
// multiple latency policies, which are enforced consecutively starting with
// the policy with the lowest latency cap. Use multiple policies to gradually
// relax latency controls; for example, you might set a policy with a low latency
// cap for the first 60 seconds, a second policy with a higher cap for the next
// 60 seconds, etc.
//
// To create a new queue, provide a name, timeout value, a list of destinations
// and, if desired, a set of latency policies. If successful, a new queue object
// is returned.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateGameSessionQueue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue
func (c *GameLift) CreateGameSessionQueue(input *CreateGameSessionQueueInput) (*CreateGameSessionQueueOutput, error) {
	req, out := c.CreateGameSessionQueueRequest(input)
	return out, req.Send()
}

// CreateGameSessionQueueWithContext is the same as CreateGameSessionQueue with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGameSessionQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateGameSessionQueueWithContext(ctx aws.Context, input *CreateGameSessionQueueInput, opts ...request.Option) (*CreateGameSessionQueueOutput, error) {
	req, out := c.CreateGameSessionQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMatchmakingConfiguration = "CreateMatchmakingConfiguration"

// CreateMatchmakingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateMatchmakingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMatchmakingConfiguration for more information on using the CreateMatchmakingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMatchmakingConfigurationRequest method.
//    req, resp := client.CreateMatchmakingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingConfiguration
func (c *GameLift) CreateMatchmakingConfigurationRequest(input *CreateMatchmakingConfigurationInput) (req *request.Request, output *CreateMatchmakingConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateMatchmakingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMatchmakingConfigurationInput{}
	}

	output = &CreateMatchmakingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMatchmakingConfiguration API operation for Amazon GameLift.
//
// Defines a new matchmaking configuration for use with FlexMatch. A matchmaking
// configuration sets out guidelines for matching players and getting the matches
// into games. You can set up multiple matchmaking configurations to handle
// the scenarios needed for your game. Each matchmaking ticket (StartMatchmaking
// or StartMatchBackfill) specifies a configuration for the match and provides
// player attributes to support the configuration being used.
//
// To create a matchmaking configuration, at a minimum you must specify the
// following: configuration name; a rule set that governs how to evaluate players
// and find acceptable matches; a game session queue to use when placing a new
// game session for the match; and the maximum time allowed for a matchmaking
// attempt.
//
// Player acceptance -- In each configuration, you have the option to require
// that all players accept participation in a proposed match. To enable this
// feature, set AcceptanceRequired to true and specify a time limit for player
// acceptance. Players have the option to accept or reject a proposed match,
// and a match does not move ahead to game session placement unless all matched
// players accept.
//
// Matchmaking status notification -- There are two ways to track the progress
// of matchmaking tickets: (1) polling ticket status with DescribeMatchmaking;
// or (2) receiving notifications with Amazon Simple Notification Service (SNS).
// To use notifications, you first need to set up an SNS topic to receive the
// notifications, and provide the topic ARN in the matchmaking configuration
// (see  Setting up Notifications for Matchmaking (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-notification.html)).
// Since notifications promise only "best effort" delivery, we recommend calling
// DescribeMatchmaking if no notifications are received within 30 seconds.
//
// Operations related to match configurations and rule sets include:
//
//    * CreateMatchmakingConfiguration
//
//    * DescribeMatchmakingConfigurations
//
//    * UpdateMatchmakingConfiguration
//
//    * DeleteMatchmakingConfiguration
//
//    * CreateMatchmakingRuleSet
//
//    * DescribeMatchmakingRuleSets
//
//    * ValidateMatchmakingRuleSet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateMatchmakingConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingConfiguration
func (c *GameLift) CreateMatchmakingConfiguration(input *CreateMatchmakingConfigurationInput) (*CreateMatchmakingConfigurationOutput, error) {
	req, out := c.CreateMatchmakingConfigurationRequest(input)
	return out, req.Send()
}

// CreateMatchmakingConfigurationWithContext is the same as CreateMatchmakingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMatchmakingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateMatchmakingConfigurationWithContext(ctx aws.Context, input *CreateMatchmakingConfigurationInput, opts ...request.Option) (*CreateMatchmakingConfigurationOutput, error) {
	req, out := c.CreateMatchmakingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMatchmakingRuleSet = "CreateMatchmakingRuleSet"

// CreateMatchmakingRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateMatchmakingRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMatchmakingRuleSet for more information on using the CreateMatchmakingRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMatchmakingRuleSetRequest method.
//    req, resp := client.CreateMatchmakingRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingRuleSet
func (c *GameLift) CreateMatchmakingRuleSetRequest(input *CreateMatchmakingRuleSetInput) (req *request.Request, output *CreateMatchmakingRuleSetOutput) {
	op := &request.Operation{
		Name:       opCreateMatchmakingRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMatchmakingRuleSetInput{}
	}

	output = &CreateMatchmakingRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMatchmakingRuleSet API operation for Amazon GameLift.
//
// Creates a new rule set for FlexMatch matchmaking. A rule set describes the
// type of match to create, such as the number and size of teams, and sets the
// parameters for acceptable player matches, such as minimum skill level or
// character type. Rule sets are used in matchmaking configurations, which define
// how matchmaking requests are handled. Each MatchmakingConfiguration uses
// one rule set; you can set up multiple rule sets to handle the scenarios that
// suit your game (such as for different game modes), and create a separate
// matchmaking configuration for each rule set. See additional information on
// rule set content in the MatchmakingRuleSet structure. For help creating rule
// sets, including useful examples, see the topic  Adding FlexMatch to Your
// Game (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-intro.html).
//
// Once created, matchmaking rule sets cannot be changed or deleted, so we recommend
// checking the rule set syntax using ValidateMatchmakingRuleSet before creating
// the rule set.
//
// To create a matchmaking rule set, provide the set of rules and a unique name.
// Rule sets must be defined in the same region as the matchmaking configuration
// they will be used with. Rule sets cannot be edited or deleted. If you need
// to change a rule set, create a new one with the necessary edits and then
// update matchmaking configurations to use the new rule set.
//
// Operations related to match configurations and rule sets include:
//
//    * CreateMatchmakingConfiguration
//
//    * DescribeMatchmakingConfigurations
//
//    * UpdateMatchmakingConfiguration
//
//    * DeleteMatchmakingConfiguration
//
//    * CreateMatchmakingRuleSet
//
//    * DescribeMatchmakingRuleSets
//
//    * ValidateMatchmakingRuleSet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateMatchmakingRuleSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingRuleSet
func (c *GameLift) CreateMatchmakingRuleSet(input *CreateMatchmakingRuleSetInput) (*CreateMatchmakingRuleSetOutput, error) {
	req, out := c.CreateMatchmakingRuleSetRequest(input)
	return out, req.Send()
}

// CreateMatchmakingRuleSetWithContext is the same as CreateMatchmakingRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMatchmakingRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateMatchmakingRuleSetWithContext(ctx aws.Context, input *CreateMatchmakingRuleSetInput, opts ...request.Option) (*CreateMatchmakingRuleSetOutput, error) {
	req, out := c.CreateMatchmakingRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlayerSession = "CreatePlayerSession"

// CreatePlayerSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlayerSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlayerSession for more information on using the CreatePlayerSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePlayerSessionRequest method.
//    req, resp := client.CreatePlayerSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession
func (c *GameLift) CreatePlayerSessionRequest(input *CreatePlayerSessionInput) (req *request.Request, output *CreatePlayerSessionOutput) {
	op := &request.Operation{
		Name:       opCreatePlayerSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlayerSessionInput{}
	}

	output = &CreatePlayerSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlayerSession API operation for Amazon GameLift.
//
// Adds a player to a game session and creates a player session record. Before
// a player can be added, a game session must have an ACTIVE status, have a
// creation policy of ALLOW_ALL, and have an open player slot. To add a group
// of players to a game session, use CreatePlayerSessions.
//
// To create a player session, specify a game session ID, player ID, and optionally
// a string of player data. If successful, the player is added to the game session
// and a new PlayerSession object is returned. Player sessions cannot be updated.
//
// Available in Amazon GameLift Local.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreatePlayerSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidGameSessionStatusException "InvalidGameSessionStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the game instance. Resolve
//   the conflict before retrying.
//
//   * ErrCodeGameSessionFullException "GameSessionFullException"
//   The game instance is currently full and cannot allow the requested player(s)
//   to join. Clients can retry such requests immediately or after a waiting period.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession
func (c *GameLift) CreatePlayerSession(input *CreatePlayerSessionInput) (*CreatePlayerSessionOutput, error) {
	req, out := c.CreatePlayerSessionRequest(input)
	return out, req.Send()
}

// CreatePlayerSessionWithContext is the same as CreatePlayerSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlayerSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreatePlayerSessionWithContext(ctx aws.Context, input *CreatePlayerSessionInput, opts ...request.Option) (*CreatePlayerSessionOutput, error) {
	req, out := c.CreatePlayerSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlayerSessions = "CreatePlayerSessions"

// CreatePlayerSessionsRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlayerSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlayerSessions for more information on using the CreatePlayerSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePlayerSessionsRequest method.
//    req, resp := client.CreatePlayerSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions
func (c *GameLift) CreatePlayerSessionsRequest(input *CreatePlayerSessionsInput) (req *request.Request, output *CreatePlayerSessionsOutput) {
	op := &request.Operation{
		Name:       opCreatePlayerSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlayerSessionsInput{}
	}

	output = &CreatePlayerSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlayerSessions API operation for Amazon GameLift.
//
// Adds a group of players to a game session. This action is useful with a team
// matching feature. Before players can be added, a game session must have an
// ACTIVE status, have a creation policy of ALLOW_ALL, and have an open player
// slot. To add a single player to a game session, use CreatePlayerSession.
//
// To create player sessions, specify a game session ID, a list of player IDs,
// and optionally a set of player data strings. If successful, the players are
// added to the game session and a set of new PlayerSession objects is returned.
// Player sessions cannot be updated.
//
// Available in Amazon GameLift Local.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreatePlayerSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidGameSessionStatusException "InvalidGameSessionStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the game instance. Resolve
//   the conflict before retrying.
//
//   * ErrCodeGameSessionFullException "GameSessionFullException"
//   The game instance is currently full and cannot allow the requested player(s)
//   to join. Clients can retry such requests immediately or after a waiting period.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions
func (c *GameLift) CreatePlayerSessions(input *CreatePlayerSessionsInput) (*CreatePlayerSessionsOutput, error) {
	req, out := c.CreatePlayerSessionsRequest(input)
	return out, req.Send()
}

// CreatePlayerSessionsWithContext is the same as CreatePlayerSessions with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlayerSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreatePlayerSessionsWithContext(ctx aws.Context, input *CreatePlayerSessionsInput, opts ...request.Option) (*CreatePlayerSessionsOutput, error) {
	req, out := c.CreatePlayerSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcPeeringAuthorization = "CreateVpcPeeringAuthorization"

// CreateVpcPeeringAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcPeeringAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcPeeringAuthorization for more information on using the CreateVpcPeeringAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpcPeeringAuthorizationRequest method.
//    req, resp := client.CreateVpcPeeringAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringAuthorization
func (c *GameLift) CreateVpcPeeringAuthorizationRequest(input *CreateVpcPeeringAuthorizationInput) (req *request.Request, output *CreateVpcPeeringAuthorizationOutput) {
	op := &request.Operation{
		Name:       opCreateVpcPeeringAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcPeeringAuthorizationInput{}
	}

	output = &CreateVpcPeeringAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcPeeringAuthorization API operation for Amazon GameLift.
//
// Requests authorization to create or delete a peer connection between the
// VPC for your Amazon GameLift fleet and a virtual private cloud (VPC) in your
// AWS account. VPC peering enables the game servers on your fleet to communicate
// directly with other AWS resources. Once you've received authorization, call
// CreateVpcPeeringConnection to establish the peering connection. For more
// information, see VPC Peering with Amazon GameLift Fleets (http://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
//
// You can peer with VPCs that are owned by any AWS account you have access
// to, including the account that you use to manage your Amazon GameLift fleets.
// You cannot peer with VPCs that are in different regions.
//
// To request authorization to create a connection, call this operation from
// the AWS account with the VPC that you want to peer to your Amazon GameLift
// fleet. For example, to enable your game servers to retrieve data from a DynamoDB
// table, use the account that manages that DynamoDB resource. Identify the
// following values: (1) The ID of the VPC that you want to peer with, and (2)
// the ID of the AWS account that you use to manage Amazon GameLift. If successful,
// VPC peering is authorized for the specified VPC.
//
// To request authorization to delete a connection, call this operation from
// the AWS account with the VPC that is peered with your Amazon GameLift fleet.
// Identify the following values: (1) VPC ID that you want to delete the peering
// connection for, and (2) ID of the AWS account that you use to manage Amazon
// GameLift.
//
// The authorization remains valid for 24 hours unless it is canceled by a call
// to DeleteVpcPeeringAuthorization. You must create or delete the peering connection
// while the authorization is valid.
//
// VPC peering connection operations include:
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateVpcPeeringAuthorization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringAuthorization
func (c *GameLift) CreateVpcPeeringAuthorization(input *CreateVpcPeeringAuthorizationInput) (*CreateVpcPeeringAuthorizationOutput, error) {
	req, out := c.CreateVpcPeeringAuthorizationRequest(input)
	return out, req.Send()
}

// CreateVpcPeeringAuthorizationWithContext is the same as CreateVpcPeeringAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcPeeringAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateVpcPeeringAuthorizationWithContext(ctx aws.Context, input *CreateVpcPeeringAuthorizationInput, opts ...request.Option) (*CreateVpcPeeringAuthorizationOutput, error) {
	req, out := c.CreateVpcPeeringAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcPeeringConnection = "CreateVpcPeeringConnection"

// CreateVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcPeeringConnection for more information on using the CreateVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpcPeeringConnectionRequest method.
//    req, resp := client.CreateVpcPeeringConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringConnection
func (c *GameLift) CreateVpcPeeringConnectionRequest(input *CreateVpcPeeringConnectionInput) (req *request.Request, output *CreateVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcPeeringConnectionInput{}
	}

	output = &CreateVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcPeeringConnection API operation for Amazon GameLift.
//
// Establishes a VPC peering connection between a virtual private cloud (VPC)
// in an AWS account with the VPC for your Amazon GameLift fleet. VPC peering
// enables the game servers on your fleet to communicate directly with other
// AWS resources. You can peer with VPCs in any AWS account that you have access
// to, including the account that you use to manage your Amazon GameLift fleets.
// You cannot peer with VPCs that are in different regions. For more information,
// see VPC Peering with Amazon GameLift Fleets (http://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
//
// Before calling this operation to establish the peering connection, you first
// need to call CreateVpcPeeringAuthorization and identify the VPC you want
// to peer with. Once the authorization for the specified VPC is issued, you
// have 24 hours to establish the connection. These two operations handle all
// tasks necessary to peer the two VPCs, including acceptance, updating routing
// tables, etc.
//
// To establish the connection, call this operation from the AWS account that
// is used to manage the Amazon GameLift fleets. Identify the following values:
// (1) The ID of the fleet you want to be enable a VPC peering connection for;
// (2) The AWS account with the VPC that you want to peer with; and (3) The
// ID of the VPC you want to peer with. This operation is asynchronous. If successful,
// a VpcPeeringConnection request is created. You can use continuous polling
// to track the request's status using DescribeVpcPeeringConnections, or by
// monitoring fleet events for success or failure using DescribeFleetEvents.
//
// VPC peering connection operations include:
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateVpcPeeringConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringConnection
func (c *GameLift) CreateVpcPeeringConnection(input *CreateVpcPeeringConnectionInput) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// CreateVpcPeeringConnectionWithContext is the same as CreateVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateVpcPeeringConnectionWithContext(ctx aws.Context, input *CreateVpcPeeringConnectionInput, opts ...request.Option) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlias for more information on using the DeleteAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAliasRequest method.
//    req, resp := client.DeleteAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias
func (c *GameLift) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlias API operation for Amazon GameLift.
//
// Deletes an alias. This action removes all record of the alias. Game clients
// attempting to access a server process using the deleted alias receive an
// error. To delete an alias, specify the alias ID to be deleted.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias
func (c *GameLift) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	return out, req.Send()
}

// DeleteAliasWithContext is the same as DeleteAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteAliasWithContext(ctx aws.Context, input *DeleteAliasInput, opts ...request.Option) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBuild = "DeleteBuild"

// DeleteBuildRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBuild for more information on using the DeleteBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBuildRequest method.
//    req, resp := client.DeleteBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild
func (c *GameLift) DeleteBuildRequest(input *DeleteBuildInput) (req *request.Request, output *DeleteBuildOutput) {
	op := &request.Operation{
		Name:       opDeleteBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBuildInput{}
	}

	output = &DeleteBuildOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBuild API operation for Amazon GameLift.
//
// Deletes a build. This action permanently deletes the build record and any
// uploaded build files.
//
// To delete a build, specify its ID. Deleting a build does not affect the status
// of any active fleets using the build, but you can no longer create new fleets
// with the deleted build.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild
func (c *GameLift) DeleteBuild(input *DeleteBuildInput) (*DeleteBuildOutput, error) {
	req, out := c.DeleteBuildRequest(input)
	return out, req.Send()
}

// DeleteBuildWithContext is the same as DeleteBuild with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteBuildWithContext(ctx aws.Context, input *DeleteBuildInput, opts ...request.Option) (*DeleteBuildOutput, error) {
	req, out := c.DeleteBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleet for more information on using the DeleteFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFleetRequest method.
//    req, resp := client.DeleteFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet
func (c *GameLift) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFleet API operation for Amazon GameLift.
//
// Deletes everything related to a fleet. Before deleting a fleet, you must
// set the fleet's desired capacity to zero. See UpdateFleetCapacity.
//
// This action removes the fleet's resources and the fleet record. Once a fleet
// is deleted, you can no longer use that fleet.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet
func (c *GameLift) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	return out, req.Send()
}

// DeleteFleetWithContext is the same as DeleteFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteFleetWithContext(ctx aws.Context, input *DeleteFleetInput, opts ...request.Option) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGameSessionQueue = "DeleteGameSessionQueue"

// DeleteGameSessionQueueRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGameSessionQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGameSessionQueue for more information on using the DeleteGameSessionQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGameSessionQueueRequest method.
//    req, resp := client.DeleteGameSessionQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue
func (c *GameLift) DeleteGameSessionQueueRequest(input *DeleteGameSessionQueueInput) (req *request.Request, output *DeleteGameSessionQueueOutput) {
	op := &request.Operation{
		Name:       opDeleteGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGameSessionQueueInput{}
	}

	output = &DeleteGameSessionQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGameSessionQueue API operation for Amazon GameLift.
//
// Deletes a game session queue. This action means that any StartGameSessionPlacement
// requests that reference this queue will fail. To delete a queue, specify
// the queue name.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteGameSessionQueue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue
func (c *GameLift) DeleteGameSessionQueue(input *DeleteGameSessionQueueInput) (*DeleteGameSessionQueueOutput, error) {
	req, out := c.DeleteGameSessionQueueRequest(input)
	return out, req.Send()
}

// DeleteGameSessionQueueWithContext is the same as DeleteGameSessionQueue with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGameSessionQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteGameSessionQueueWithContext(ctx aws.Context, input *DeleteGameSessionQueueInput, opts ...request.Option) (*DeleteGameSessionQueueOutput, error) {
	req, out := c.DeleteGameSessionQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMatchmakingConfiguration = "DeleteMatchmakingConfiguration"

// DeleteMatchmakingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMatchmakingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMatchmakingConfiguration for more information on using the DeleteMatchmakingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMatchmakingConfigurationRequest method.
//    req, resp := client.DeleteMatchmakingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingConfiguration
func (c *GameLift) DeleteMatchmakingConfigurationRequest(input *DeleteMatchmakingConfigurationInput) (req *request.Request, output *DeleteMatchmakingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteMatchmakingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMatchmakingConfigurationInput{}
	}

	output = &DeleteMatchmakingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMatchmakingConfiguration API operation for Amazon GameLift.
//
// Permanently removes a FlexMatch matchmaking configuration. To delete, specify
// the configuration name. A matchmaking configuration cannot be deleted if
// it is being used in any active matchmaking tickets.
//
// Operations related to match configurations and rule sets include:
//
//    * CreateMatchmakingConfiguration
//
//    * DescribeMatchmakingConfigurations
//
//    * UpdateMatchmakingConfiguration
//
//    * DeleteMatchmakingConfiguration
//
//    * CreateMatchmakingRuleSet
//
//    * DescribeMatchmakingRuleSets
//
//    * ValidateMatchmakingRuleSet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteMatchmakingConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingConfiguration
func (c *GameLift) DeleteMatchmakingConfiguration(input *DeleteMatchmakingConfigurationInput) (*DeleteMatchmakingConfigurationOutput, error) {
	req, out := c.DeleteMatchmakingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteMatchmakingConfigurationWithContext is the same as DeleteMatchmakingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMatchmakingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteMatchmakingConfigurationWithContext(ctx aws.Context, input *DeleteMatchmakingConfigurationInput, opts ...request.Option) (*DeleteMatchmakingConfigurationOutput, error) {
	req, out := c.DeleteMatchmakingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScalingPolicy = "DeleteScalingPolicy"

// DeleteScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScalingPolicy for more information on using the DeleteScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScalingPolicyRequest method.
//    req, resp := client.DeleteScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy
func (c *GameLift) DeleteScalingPolicyRequest(input *DeleteScalingPolicyInput) (req *request.Request, output *DeleteScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPolicyInput{}
	}

	output = &DeleteScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScalingPolicy API operation for Amazon GameLift.
//
// Deletes a fleet scaling policy. This action means that the policy is no longer
// in force and removes all record of it. To delete a scaling policy, specify
// both the scaling policy name and the fleet ID it is associated with.
//
// To temporarily suspend scaling policies, call StopFleetActions. This operation
// suspends all policies for the fleet.
//
// Operations related to fleet capacity scaling include:
//
//    * DescribeFleetCapacity
//
//    * UpdateFleetCapacity
//
//    * DescribeEC2InstanceLimits
//
//    * Manage scaling policies:
//
// PutScalingPolicy (auto-scaling)
//
// DescribeScalingPolicies (auto-scaling)
//
// DeleteScalingPolicy (auto-scaling)
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy
func (c *GameLift) DeleteScalingPolicy(input *DeleteScalingPolicyInput) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	return out, req.Send()
}

// DeleteScalingPolicyWithContext is the same as DeleteScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteScalingPolicyWithContext(ctx aws.Context, input *DeleteScalingPolicyInput, opts ...request.Option) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcPeeringAuthorization = "DeleteVpcPeeringAuthorization"

// DeleteVpcPeeringAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcPeeringAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcPeeringAuthorization for more information on using the DeleteVpcPeeringAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpcPeeringAuthorizationRequest method.
//    req, resp := client.DeleteVpcPeeringAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringAuthorization
func (c *GameLift) DeleteVpcPeeringAuthorizationRequest(input *DeleteVpcPeeringAuthorizationInput) (req *request.Request, output *DeleteVpcPeeringAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcPeeringAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringAuthorizationInput{}
	}

	output = &DeleteVpcPeeringAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcPeeringAuthorization API operation for Amazon GameLift.
//
// Cancels a pending VPC peering authorization for the specified VPC. If the
// authorization has already been used to create a peering connection, call
// DeleteVpcPeeringConnection to remove the connection.
//
// VPC peering connection operations include:
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteVpcPeeringAuthorization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringAuthorization
func (c *GameLift) DeleteVpcPeeringAuthorization(input *DeleteVpcPeeringAuthorizationInput) (*DeleteVpcPeeringAuthorizationOutput, error) {
	req, out := c.DeleteVpcPeeringAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteVpcPeeringAuthorizationWithContext is the same as DeleteVpcPeeringAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcPeeringAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteVpcPeeringAuthorizationWithContext(ctx aws.Context, input *DeleteVpcPeeringAuthorizationInput, opts ...request.Option) (*DeleteVpcPeeringAuthorizationOutput, error) {
	req, out := c.DeleteVpcPeeringAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcPeeringConnection = "DeleteVpcPeeringConnection"

// DeleteVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcPeeringConnection for more information on using the DeleteVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpcPeeringConnectionRequest method.
//    req, resp := client.DeleteVpcPeeringConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection
func (c *GameLift) DeleteVpcPeeringConnectionRequest(input *DeleteVpcPeeringConnectionInput) (req *request.Request, output *DeleteVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringConnectionInput{}
	}

	output = &DeleteVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcPeeringConnection API operation for Amazon GameLift.
//
// Removes a VPC peering connection. To delete the connection, you must have
// a valid authorization for the VPC peering connection that you want to delete.
// You can check for an authorization by calling DescribeVpcPeeringAuthorizations
// or request a new one using CreateVpcPeeringAuthorization.
//
// Once a valid authorization exists, call this operation from the AWS account
// that is used to manage the Amazon GameLift fleets. Identify the connection
// to delete by the connection ID and fleet ID. If successful, the connection
// is removed.
//
// VPC peering connection operations include:
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteVpcPeeringConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection
func (c *GameLift) DeleteVpcPeeringConnection(input *DeleteVpcPeeringConnectionInput) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// DeleteVpcPeeringConnectionWithContext is the same as DeleteVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteVpcPeeringConnectionWithContext(ctx aws.Context, input *DeleteVpcPeeringConnectionInput, opts ...request.Option) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlias = "DescribeAlias"

// DescribeAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlias for more information on using the DescribeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAliasRequest method.
//    req, resp := client.DescribeAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias
func (c *GameLift) DescribeAliasRequest(input *DescribeAliasInput) (req *request.Request, output *DescribeAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAliasInput{}
	}

	output = &DescribeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlias API operation for Amazon GameLift.
//
// Retrieves properties for an alias. This operation returns all alias metadata
// and settings. To get an alias's target fleet ID only, use ResolveAlias.
//
// To get alias properties, specify the alias ID. If successful, the requested
// alias record is returned.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias
func (c *GameLift) DescribeAlias(input *DescribeAliasInput) (*DescribeAliasOutput, error) {
	req, out := c.DescribeAliasRequest(input)
	return out, req.Send()
}

// DescribeAliasWithContext is the same as DescribeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeAliasWithContext(ctx aws.Context, input *DescribeAliasInput, opts ...request.Option) (*DescribeAliasOutput, error) {
	req, out := c.DescribeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBuild = "DescribeBuild"

// DescribeBuildRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBuild for more information on using the DescribeBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBuildRequest method.
//    req, resp := client.DescribeBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild
func (c *GameLift) DescribeBuildRequest(input *DescribeBuildInput) (req *request.Request, output *DescribeBuildOutput) {
	op := &request.Operation{
		Name:       opDescribeBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBuildInput{}
	}

	output = &DescribeBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBuild API operation for Amazon GameLift.
//
// Retrieves properties for a build. To request a build record, specify a build
// ID. If successful, an object containing the build properties is returned.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild
func (c *GameLift) DescribeBuild(input *DescribeBuildInput) (*DescribeBuildOutput, error) {
	req, out := c.DescribeBuildRequest(input)
	return out, req.Send()
}

// DescribeBuildWithContext is the same as DescribeBuild with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeBuildWithContext(ctx aws.Context, input *DescribeBuildInput, opts ...request.Option) (*DescribeBuildOutput, error) {
	req, out := c.DescribeBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEC2InstanceLimits = "DescribeEC2InstanceLimits"

// DescribeEC2InstanceLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEC2InstanceLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEC2InstanceLimits for more information on using the DescribeEC2InstanceLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEC2InstanceLimitsRequest method.
//    req, resp := client.DescribeEC2InstanceLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits
func (c *GameLift) DescribeEC2InstanceLimitsRequest(input *DescribeEC2InstanceLimitsInput) (req *request.Request, output *DescribeEC2InstanceLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeEC2InstanceLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEC2InstanceLimitsInput{}
	}

	output = &DescribeEC2InstanceLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEC2InstanceLimits API operation for Amazon GameLift.
//
// Retrieves the following information for the specified EC2 instance type:
//
//    * maximum number of instances allowed per AWS account (service limit)
//
//    * current usage level for the AWS account
//
// Service limits vary depending on region. Available regions for Amazon GameLift
// can be found in the AWS Management Console for Amazon GameLift (see the drop-down
// list in the upper right corner).
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeEC2InstanceLimits for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits
func (c *GameLift) DescribeEC2InstanceLimits(input *DescribeEC2InstanceLimitsInput) (*DescribeEC2InstanceLimitsOutput, error) {
	req, out := c.DescribeEC2InstanceLimitsRequest(input)
	return out, req.Send()
}

// DescribeEC2InstanceLimitsWithContext is the same as DescribeEC2InstanceLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEC2InstanceLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeEC2InstanceLimitsWithContext(ctx aws.Context, input *DescribeEC2InstanceLimitsInput, opts ...request.Option) (*DescribeEC2InstanceLimitsOutput, error) {
	req, out := c.DescribeEC2InstanceLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetAttributes = "DescribeFleetAttributes"

// DescribeFleetAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetAttributes for more information on using the DescribeFleetAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetAttributesRequest method.
//    req, resp := client.DescribeFleetAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes
func (c *GameLift) DescribeFleetAttributesRequest(input *DescribeFleetAttributesInput) (req *request.Request, output *DescribeFleetAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetAttributesInput{}
	}

	output = &DescribeFleetAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetAttributes API operation for Amazon GameLift.
//
// Retrieves fleet properties, including metadata, status, and configuration,
// for one or more fleets. You can request attributes for all fleets, or specify
// a list of one or more fleet IDs. When requesting multiple fleets, use the
// pagination parameters to retrieve results as a set of sequential pages. If
// successful, a FleetAttributes object is returned for each requested fleet
// ID. When specifying a list of fleet IDs, attribute objects are returned only
// for fleets that currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes
func (c *GameLift) DescribeFleetAttributes(input *DescribeFleetAttributesInput) (*DescribeFleetAttributesOutput, error) {
	req, out := c.DescribeFleetAttributesRequest(input)
	return out, req.Send()
}

// DescribeFleetAttributesWithContext is the same as DescribeFleetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetAttributesWithContext(ctx aws.Context, input *DescribeFleetAttributesInput, opts ...request.Option) (*DescribeFleetAttributesOutput, error) {
	req, out := c.DescribeFleetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetCapacity = "DescribeFleetCapacity"

// DescribeFleetCapacityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetCapacity for more information on using the DescribeFleetCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetCapacityRequest method.
//    req, resp := client.DescribeFleetCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity
func (c *GameLift) DescribeFleetCapacityRequest(input *DescribeFleetCapacityInput) (req *request.Request, output *DescribeFleetCapacityOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetCapacityInput{}
	}

	output = &DescribeFleetCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetCapacity API operation for Amazon GameLift.
//
// Retrieves the current status of fleet capacity for one or more fleets. This
// information includes the number of instances that have been requested for
// the fleet and the number currently active. You can request capacity for all
// fleets, or specify a list of one or more fleet IDs. When requesting multiple
// fleets, use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, a FleetCapacity object is returned for each requested
// fleet ID. When specifying a list of fleet IDs, attribute objects are returned
// only for fleets that currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetCapacity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity
func (c *GameLift) DescribeFleetCapacity(input *DescribeFleetCapacityInput) (*DescribeFleetCapacityOutput, error) {
	req, out := c.DescribeFleetCapacityRequest(input)
	return out, req.Send()
}

// DescribeFleetCapacityWithContext is the same as DescribeFleetCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetCapacityWithContext(ctx aws.Context, input *DescribeFleetCapacityInput, opts ...request.Option) (*DescribeFleetCapacityOutput, error) {
	req, out := c.DescribeFleetCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetEvents = "DescribeFleetEvents"

// DescribeFleetEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetEvents for more information on using the DescribeFleetEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetEventsRequest method.
//    req, resp := client.DescribeFleetEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents
func (c *GameLift) DescribeFleetEventsRequest(input *DescribeFleetEventsInput) (req *request.Request, output *DescribeFleetEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetEventsInput{}
	}

	output = &DescribeFleetEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetEvents API operation for Amazon GameLift.
//
// Retrieves entries from the specified fleet's event log. You can specify a
// time range to limit the result set. Use the pagination parameters to retrieve
// results as a set of sequential pages. If successful, a collection of event
// log entries matching the request are returned.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents
func (c *GameLift) DescribeFleetEvents(input *DescribeFleetEventsInput) (*DescribeFleetEventsOutput, error) {
	req, out := c.DescribeFleetEventsRequest(input)
	return out, req.Send()
}

// DescribeFleetEventsWithContext is the same as DescribeFleetEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetEventsWithContext(ctx aws.Context, input *DescribeFleetEventsInput, opts ...request.Option) (*DescribeFleetEventsOutput, error) {
	req, out := c.DescribeFleetEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetPortSettings = "DescribeFleetPortSettings"

// DescribeFleetPortSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetPortSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetPortSettings for more information on using the DescribeFleetPortSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetPortSettingsRequest method.
//    req, resp := client.DescribeFleetPortSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings
func (c *GameLift) DescribeFleetPortSettingsRequest(input *DescribeFleetPortSettingsInput) (req *request.Request, output *DescribeFleetPortSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetPortSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetPortSettingsInput{}
	}

	output = &DescribeFleetPortSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetPortSettings API operation for Amazon GameLift.
//
// Retrieves the inbound connection permissions for a fleet. Connection permissions
// include a range of IP addresses and port settings that incoming traffic can
// use to access server processes in the fleet. To get a fleet's inbound connection
// permissions, specify a fleet ID. If successful, a collection of IpPermission
// objects is returned for the requested fleet ID. If the requested fleet has
// been deleted, the result set is empty.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetPortSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings
func (c *GameLift) DescribeFleetPortSettings(input *DescribeFleetPortSettingsInput) (*DescribeFleetPortSettingsOutput, error) {
	req, out := c.DescribeFleetPortSettingsRequest(input)
	return out, req.Send()
}

// DescribeFleetPortSettingsWithContext is the same as DescribeFleetPortSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetPortSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetPortSettingsWithContext(ctx aws.Context, input *DescribeFleetPortSettingsInput, opts ...request.Option) (*DescribeFleetPortSettingsOutput, error) {
	req, out := c.DescribeFleetPortSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetUtilization = "DescribeFleetUtilization"

// DescribeFleetUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetUtilization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetUtilization for more information on using the DescribeFleetUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetUtilizationRequest method.
//    req, resp := client.DescribeFleetUtilizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization
func (c *GameLift) DescribeFleetUtilizationRequest(input *DescribeFleetUtilizationInput) (req *request.Request, output *DescribeFleetUtilizationOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetUtilizationInput{}
	}

	output = &DescribeFleetUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetUtilization API operation for Amazon GameLift.
//
// Retrieves utilization statistics for one or more fleets. You can request
// utilization data for all fleets, or specify a list of one or more fleet IDs.
// When requesting multiple fleets, use the pagination parameters to retrieve
// results as a set of sequential pages. If successful, a FleetUtilization object
// is returned for each requested fleet ID. When specifying a list of fleet
// IDs, utilization objects are returned only for fleets that currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetUtilization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization
func (c *GameLift) DescribeFleetUtilization(input *DescribeFleetUtilizationInput) (*DescribeFleetUtilizationOutput, error) {
	req, out := c.DescribeFleetUtilizationRequest(input)
	return out, req.Send()
}

// DescribeFleetUtilizationWithContext is the same as DescribeFleetUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetUtilizationWithContext(ctx aws.Context, input *DescribeFleetUtilizationInput, opts ...request.Option) (*DescribeFleetUtilizationOutput, error) {
	req, out := c.DescribeFleetUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameSessionDetails = "DescribeGameSessionDetails"

// DescribeGameSessionDetailsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessionDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessionDetails for more information on using the DescribeGameSessionDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGameSessionDetailsRequest method.
//    req, resp := client.DescribeGameSessionDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails
func (c *GameLift) DescribeGameSessionDetailsRequest(input *DescribeGameSessionDetailsInput) (req *request.Request, output *DescribeGameSessionDetailsOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionDetailsInput{}
	}

	output = &DescribeGameSessionDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessionDetails API operation for Amazon GameLift.
//
// Retrieves properties, including the protection policy in force, for one or
// more game sessions. This action can be used in several ways: (1) provide
// a GameSessionId or GameSessionArn to request details for a specific game
// session; (2) provide either a FleetId or an AliasId to request properties
// for all game sessions running on a fleet.
//
// To get game session record(s), specify just one of the following: game session
// ID, fleet ID, or alias ID. You can filter this request by game session status.
// Use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, a GameSessionDetail object is returned for each session
// matching the request.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessionDetails for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails
func (c *GameLift) DescribeGameSessionDetails(input *DescribeGameSessionDetailsInput) (*DescribeGameSessionDetailsOutput, error) {
	req, out := c.DescribeGameSessionDetailsRequest(input)
	return out, req.Send()
}

// DescribeGameSessionDetailsWithContext is the same as DescribeGameSessionDetails with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessionDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionDetailsWithContext(ctx aws.Context, input *DescribeGameSessionDetailsInput, opts ...request.Option) (*DescribeGameSessionDetailsOutput, error) {
	req, out := c.DescribeGameSessionDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameSessionPlacement = "DescribeGameSessionPlacement"

// DescribeGameSessionPlacementRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessionPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessionPlacement for more information on using the DescribeGameSessionPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGameSessionPlacementRequest method.
//    req, resp := client.DescribeGameSessionPlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement
func (c *GameLift) DescribeGameSessionPlacementRequest(input *DescribeGameSessionPlacementInput) (req *request.Request, output *DescribeGameSessionPlacementOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionPlacementInput{}
	}

	output = &DescribeGameSessionPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessionPlacement API operation for Amazon GameLift.
//
// Retrieves properties and current status of a game session placement request.
// To get game session placement details, specify the placement ID. If successful,
// a GameSessionPlacement object is returned.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessionPlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement
func (c *GameLift) DescribeGameSessionPlacement(input *DescribeGameSessionPlacementInput) (*DescribeGameSessionPlacementOutput, error) {
	req, out := c.DescribeGameSessionPlacementRequest(input)
	return out, req.Send()
}

// DescribeGameSessionPlacementWithContext is the same as DescribeGameSessionPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessionPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionPlacementWithContext(ctx aws.Context, input *DescribeGameSessionPlacementInput, opts ...request.Option) (*DescribeGameSessionPlacementOutput, error) {
	req, out := c.DescribeGameSessionPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameSessionQueues = "DescribeGameSessionQueues"

// DescribeGameSessionQueuesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessionQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessionQueues for more information on using the DescribeGameSessionQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGameSessionQueuesRequest method.
//    req, resp := client.DescribeGameSessionQueuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues
func (c *GameLift) DescribeGameSessionQueuesRequest(input *DescribeGameSessionQueuesInput) (req *request.Request, output *DescribeGameSessionQueuesOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionQueuesInput{}
	}

	output = &DescribeGameSessionQueuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessionQueues API operation for Amazon GameLift.
//
// Retrieves the properties for one or more game session queues. When requesting
// multiple queues, use the pagination parameters to retrieve results as a set
// of sequential pages. If successful, a GameSessionQueue object is returned
// for each requested queue. When specifying a list of queues, objects are returned
// only for queues that currently exist in the region.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessionQueues for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues
func (c *GameLift) DescribeGameSessionQueues(input *DescribeGameSessionQueuesInput) (*DescribeGameSessionQueuesOutput, error) {
	req, out := c.DescribeGameSessionQueuesRequest(input)
	return out, req.Send()
}

// DescribeGameSessionQueuesWithContext is the same as DescribeGameSessionQueues with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessionQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionQueuesWithContext(ctx aws.Context, input *DescribeGameSessionQueuesInput, opts ...request.Option) (*DescribeGameSessionQueuesOutput, error) {
	req, out := c.DescribeGameSessionQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameSessions = "DescribeGameSessions"

// DescribeGameSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessions for more information on using the DescribeGameSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGameSessionsRequest method.
//    req, resp := client.DescribeGameSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions
func (c *GameLift) DescribeGameSessionsRequest(input *DescribeGameSessionsInput) (req *request.Request, output *DescribeGameSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionsInput{}
	}

	output = &DescribeGameSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessions API operation for Amazon GameLift.
//
// Retrieves a set of one or more game sessions. Request a specific game session
// or request all game sessions on a fleet. Alternatively, use SearchGameSessions
// to request a set of active game sessions that are filtered by certain criteria.
// To retrieve protection policy settings for game sessions, use DescribeGameSessionDetails.
//
// To get game sessions, specify one of the following: game session ID, fleet
// ID, or alias ID. You can filter this request by game session status. Use
// the pagination parameters to retrieve results as a set of sequential pages.
// If successful, a GameSession object is returned for each game session matching
// the request.
//
// Available in Amazon GameLift Local.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions
func (c *GameLift) DescribeGameSessions(input *DescribeGameSessionsInput) (*DescribeGameSessionsOutput, error) {
	req, out := c.DescribeGameSessionsRequest(input)
	return out, req.Send()
}

// DescribeGameSessionsWithContext is the same as DescribeGameSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionsWithContext(ctx aws.Context, input *DescribeGameSessionsInput, opts ...request.Option) (*DescribeGameSessionsOutput, error) {
	req, out := c.DescribeGameSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstances for more information on using the DescribeInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstancesRequest method.
//    req, resp := client.DescribeInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances
func (c *GameLift) DescribeInstancesRequest(input *DescribeInstancesInput) (req *request.Request, output *DescribeInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	output = &DescribeInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstances API operation for Amazon GameLift.
//
// Retrieves information about a fleet's instances, including instance IDs.
// Use this action to get details on all instances in the fleet or get details
// on one specific instance.
//
// To get a specific instance, specify fleet ID and instance ID. To get all
// instances in a fleet, specify a fleet ID only. Use the pagination parameters
// to retrieve results as a set of sequential pages. If successful, an Instance
// object is returned for each result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances
func (c *GameLift) DescribeInstances(input *DescribeInstancesInput) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	return out, req.Send()
}

// DescribeInstancesWithContext is the same as DescribeInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeInstancesWithContext(ctx aws.Context, input *DescribeInstancesInput, opts ...request.Option) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMatchmaking = "DescribeMatchmaking"

// DescribeMatchmakingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMatchmaking operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMatchmaking for more information on using the DescribeMatchmaking
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMatchmakingRequest method.
//    req, resp := client.DescribeMatchmakingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmaking
func (c *GameLift) DescribeMatchmakingRequest(input *DescribeMatchmakingInput) (req *request.Request, output *DescribeMatchmakingOutput) {
	op := &request.Operation{
		Name:       opDescribeMatchmaking,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMatchmakingInput{}
	}

	output = &DescribeMatchmakingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMatchmaking API operation for Amazon GameLift.
//
// Retrieves one or more matchmaking tickets. Use this operation to retrieve
// ticket information, including status and--once a successful match is made--acquire
// connection information for the resulting new game session.
//
// You can use this operation to track the progress of matchmaking requests
// (through polling) as an alternative to using event notifications. See more
// details on tracking matchmaking requests through polling or notifications
// in StartMatchmaking.
//
// To request matchmaking tickets, provide a list of up to 10 ticket IDs. If
// the request is successful, a ticket object is returned for each requested
// ID that currently exists.
//
// Matchmaking-related operations include:
//
//    * StartMatchmaking
//
//    * DescribeMatchmaking
//
//    * StopMatchmaking
//
//    * AcceptMatch
//
//    * StartMatchBackfill
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeMatchmaking for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmaking
func (c *GameLift) DescribeMatchmaking(input *DescribeMatchmakingInput) (*DescribeMatchmakingOutput, error) {
	req, out := c.DescribeMatchmakingRequest(input)
	return out, req.Send()
}

// DescribeMatchmakingWithContext is the same as DescribeMatchmaking with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMatchmaking for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeMatchmakingWithContext(ctx aws.Context, input *DescribeMatchmakingInput, opts ...request.Option) (*DescribeMatchmakingOutput, error) {
	req, out := c.DescribeMatchmakingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMatchmakingConfigurations = "DescribeMatchmakingConfigurations"

// DescribeMatchmakingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMatchmakingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMatchmakingConfigurations for more information on using the DescribeMatchmakingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMatchmakingConfigurationsRequest method.
//    req, resp := client.DescribeMatchmakingConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations
func (c *GameLift) DescribeMatchmakingConfigurationsRequest(input *DescribeMatchmakingConfigurationsInput) (req *request.Request, output *DescribeMatchmakingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeMatchmakingConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMatchmakingConfigurationsInput{}
	}

	output = &DescribeMatchmakingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMatchmakingConfigurations API operation for Amazon GameLift.
//
// Retrieves the details of FlexMatch matchmaking configurations. with this
// operation, you have the following options: (1) retrieve all existing configurations,
// (2) provide the names of one or more configurations to retrieve, or (3) retrieve
// all configurations that use a specified rule set name. When requesting multiple
// items, use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, a configuration is returned for each requested name.
// When specifying a list of names, only configurations that currently exist
// are returned.
//
// Operations related to match configurations and rule sets include:
//
//    * CreateMatchmakingConfiguration
//
//    * DescribeMatchmakingConfigurations
//
//    * UpdateMatchmakingConfiguration
//
//    * DeleteMatchmakingConfiguration
//
//    * CreateMatchmakingRuleSet
//
//    * DescribeMatchmakingRuleSets
//
//    * ValidateMatchmakingRuleSet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeMatchmakingConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations
func (c *GameLift) DescribeMatchmakingConfigurations(input *DescribeMatchmakingConfigurationsInput) (*DescribeMatchmakingConfigurationsOutput, error) {
	req, out := c.DescribeMatchmakingConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeMatchmakingConfigurationsWithContext is the same as DescribeMatchmakingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMatchmakingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeMatchmakingConfigurationsWithContext(ctx aws.Context, input *DescribeMatchmakingConfigurationsInput, opts ...request.Option) (*DescribeMatchmakingConfigurationsOutput, error) {
	req, out := c.DescribeMatchmakingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMatchmakingRuleSets = "DescribeMatchmakingRuleSets"

// DescribeMatchmakingRuleSetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMatchmakingRuleSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMatchmakingRuleSets for more information on using the DescribeMatchmakingRuleSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMatchmakingRuleSetsRequest method.
//    req, resp := client.DescribeMatchmakingRuleSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets
func (c *GameLift) DescribeMatchmakingRuleSetsRequest(input *DescribeMatchmakingRuleSetsInput) (req *request.Request, output *DescribeMatchmakingRuleSetsOutput) {
	op := &request.Operation{
		Name:       opDescribeMatchmakingRuleSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMatchmakingRuleSetsInput{}
	}

	output = &DescribeMatchmakingRuleSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMatchmakingRuleSets API operation for Amazon GameLift.
//
// Retrieves the details for FlexMatch matchmaking rule sets. You can request
// all existing rule sets for the region, or provide a list of one or more rule
// set names. When requesting multiple items, use the pagination parameters
// to retrieve results as a set of sequential pages. If successful, a rule set
// is returned for each requested name.
//
// Operations related to match configurations and rule sets include:
//
//    * CreateMatchmakingConfiguration
//
//    * DescribeMatchmakingConfigurations
//
//    * UpdateMatchmakingConfiguration
//
//    * DeleteMatchmakingConfiguration
//
//    * CreateMatchmakingRuleSet
//
//    * DescribeMatchmakingRuleSets
//
//    * ValidateMatchmakingRuleSet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeMatchmakingRuleSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets
func (c *GameLift) DescribeMatchmakingRuleSets(input *DescribeMatchmakingRuleSetsInput) (*DescribeMatchmakingRuleSetsOutput, error) {
	req, out := c.DescribeMatchmakingRuleSetsRequest(input)
	return out, req.Send()
}

// DescribeMatchmakingRuleSetsWithContext is the same as DescribeMatchmakingRuleSets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMatchmakingRuleSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeMatchmakingRuleSetsWithContext(ctx aws.Context, input *DescribeMatchmakingRuleSetsInput, opts ...request.Option) (*DescribeMatchmakingRuleSetsOutput, error) {
	req, out := c.DescribeMatchmakingRuleSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePlayerSessions = "DescribePlayerSessions"

// DescribePlayerSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlayerSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePlayerSessions for more information on using the DescribePlayerSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePlayerSessionsRequest method.
//    req, resp := client.DescribePlayerSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions
func (c *GameLift) DescribePlayerSessionsRequest(input *DescribePlayerSessionsInput) (req *request.Request, output *DescribePlayerSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribePlayerSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePlayerSessionsInput{}
	}

	output = &DescribePlayerSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePlayerSessions API operation for Amazon GameLift.
//
// Retrieves properties for one or more player sessions. This action can be
// used in several ways: (1) provide a PlayerSessionId to request properties
// for a specific player session; (2) provide a GameSessionId to request properties
// for all player sessions in the specified game session; (3) provide a PlayerId
// to request properties for all player sessions of a specified player.
//
// To get game session record(s), specify only one of the following: a player
// session ID, a game session ID, or a player ID. You can filter this request
// by player session status. Use the pagination parameters to retrieve results
// as a set of sequential pages. If successful, a PlayerSession object is returned
// for each session matching the request.
//
// Available in Amazon GameLift Local.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribePlayerSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions
func (c *GameLift) DescribePlayerSessions(input *DescribePlayerSessionsInput) (*DescribePlayerSessionsOutput, error) {
	req, out := c.DescribePlayerSessionsRequest(input)
	return out, req.Send()
}

// DescribePlayerSessionsWithContext is the same as DescribePlayerSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlayerSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribePlayerSessionsWithContext(ctx aws.Context, input *DescribePlayerSessionsInput, opts ...request.Option) (*DescribePlayerSessionsOutput, error) {
	req, out := c.DescribePlayerSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRuntimeConfiguration = "DescribeRuntimeConfiguration"

// DescribeRuntimeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRuntimeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRuntimeConfiguration for more information on using the DescribeRuntimeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRuntimeConfigurationRequest method.
//    req, resp := client.DescribeRuntimeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration
func (c *GameLift) DescribeRuntimeConfigurationRequest(input *DescribeRuntimeConfigurationInput) (req *request.Request, output *DescribeRuntimeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeRuntimeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRuntimeConfigurationInput{}
	}

	output = &DescribeRuntimeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRuntimeConfiguration API operation for Amazon GameLift.
//
// Retrieves the current run-time configuration for the specified fleet. The
// run-time configuration tells Amazon GameLift how to launch server processes
// on instances in the fleet.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeRuntimeConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration
func (c *GameLift) DescribeRuntimeConfiguration(input *DescribeRuntimeConfigurationInput) (*DescribeRuntimeConfigurationOutput, error) {
	req, out := c.DescribeRuntimeConfigurationRequest(input)
	return out, req.Send()
}

// DescribeRuntimeConfigurationWithContext is the same as DescribeRuntimeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRuntimeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeRuntimeConfigurationWithContext(ctx aws.Context, input *DescribeRuntimeConfigurationInput, opts ...request.Option) (*DescribeRuntimeConfigurationOutput, error) {
	req, out := c.DescribeRuntimeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScalingPolicies = "DescribeScalingPolicies"

// DescribeScalingPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingPolicies for more information on using the DescribeScalingPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingPoliciesRequest method.
//    req, resp := client.DescribeScalingPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies
func (c *GameLift) DescribeScalingPoliciesRequest(input *DescribeScalingPoliciesInput) (req *request.Request, output *DescribeScalingPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingPoliciesInput{}
	}

	output = &DescribeScalingPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingPolicies API operation for Amazon GameLift.
//
// Retrieves all scaling policies applied to a fleet.
//
// To get a fleet's scaling policies, specify the fleet ID. You can filter this
// request by policy status, such as to retrieve only active scaling policies.
// Use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, set of ScalingPolicy objects is returned for the fleet.
//
// A fleet may have all of its scaling policies suspended (StopFleetActions).
// This action does not affect the status of the scaling policies, which remains
// ACTIVE. To see whether a fleet's scaling policies are in force or suspended,
// call DescribeFleetAttributes and check the stopped actions.
//
// Operations related to fleet capacity scaling include:
//
//    * DescribeFleetCapacity
//
//    * UpdateFleetCapacity
//
//    * DescribeEC2InstanceLimits
//
//    * Manage scaling policies:
//
// PutScalingPolicy (auto-scaling)
//
// DescribeScalingPolicies (auto-scaling)
//
// DeleteScalingPolicy (auto-scaling)
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeScalingPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies
func (c *GameLift) DescribeScalingPolicies(input *DescribeScalingPoliciesInput) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	return out, req.Send()
}

// DescribeScalingPoliciesWithContext is the same as DescribeScalingPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeScalingPoliciesWithContext(ctx aws.Context, input *DescribeScalingPoliciesInput, opts ...request.Option) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVpcPeeringAuthorizations = "DescribeVpcPeeringAuthorizations"

// DescribeVpcPeeringAuthorizationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcPeeringAuthorizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVpcPeeringAuthorizations for more information on using the DescribeVpcPeeringAuthorizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVpcPeeringAuthorizationsRequest method.
//    req, resp := client.DescribeVpcPeeringAuthorizationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations
func (c *GameLift) DescribeVpcPeeringAuthorizationsRequest(input *DescribeVpcPeeringAuthorizationsInput) (req *request.Request, output *DescribeVpcPeeringAuthorizationsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcPeeringAuthorizations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcPeeringAuthorizationsInput{}
	}

	output = &DescribeVpcPeeringAuthorizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcPeeringAuthorizations API operation for Amazon GameLift.
//
// Retrieves valid VPC peering authorizations that are pending for the AWS account.
// This operation returns all VPC peering authorizations and requests for peering.
// This includes those initiated and received by this account.
//
// VPC peering connection operations include:
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeVpcPeeringAuthorizations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations
func (c *GameLift) DescribeVpcPeeringAuthorizations(input *DescribeVpcPeeringAuthorizationsInput) (*DescribeVpcPeeringAuthorizationsOutput, error) {
	req, out := c.DescribeVpcPeeringAuthorizationsRequest(input)
	return out, req.Send()
}

// DescribeVpcPeeringAuthorizationsWithContext is the same as DescribeVpcPeeringAuthorizations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVpcPeeringAuthorizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeVpcPeeringAuthorizationsWithContext(ctx aws.Context, input *DescribeVpcPeeringAuthorizationsInput, opts ...request.Option) (*DescribeVpcPeeringAuthorizationsOutput, error) {
	req, out := c.DescribeVpcPeeringAuthorizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVpcPeeringConnections = "DescribeVpcPeeringConnections"

// DescribeVpcPeeringConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcPeeringConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVpcPeeringConnections for more information on using the DescribeVpcPeeringConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVpcPeeringConnectionsRequest method.
//    req, resp := client.DescribeVpcPeeringConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections
func (c *GameLift) DescribeVpcPeeringConnectionsRequest(input *DescribeVpcPeeringConnectionsInput) (req *request.Request, output *DescribeVpcPeeringConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcPeeringConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcPeeringConnectionsInput{}
	}

	output = &DescribeVpcPeeringConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcPeeringConnections API operation for Amazon GameLift.
//
// Retrieves information on VPC peering connections. Use this operation to get
// peering information for all fleets or for one specific fleet ID.
//
// To retrieve connection information, call this operation from the AWS account
// that is used to manage the Amazon GameLift fleets. Specify a fleet ID or
// leave the parameter empty to retrieve all connection records. If successful,
// the retrieved information includes both active and pending connections. Active
// connections identify the IpV4 CIDR block that the VPC uses to connect.
//
// VPC peering connection operations include:
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeVpcPeeringConnections for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections
func (c *GameLift) DescribeVpcPeeringConnections(input *DescribeVpcPeeringConnectionsInput) (*DescribeVpcPeeringConnectionsOutput, error) {
	req, out := c.DescribeVpcPeeringConnectionsRequest(input)
	return out, req.Send()
}

// DescribeVpcPeeringConnectionsWithContext is the same as DescribeVpcPeeringConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVpcPeeringConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeVpcPeeringConnectionsWithContext(ctx aws.Context, input *DescribeVpcPeeringConnectionsInput, opts ...request.Option) (*DescribeVpcPeeringConnectionsOutput, error) {
	req, out := c.DescribeVpcPeeringConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGameSessionLogUrl = "GetGameSessionLogUrl"

// GetGameSessionLogUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetGameSessionLogUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGameSessionLogUrl for more information on using the GetGameSessionLogUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGameSessionLogUrlRequest method.
//    req, resp := client.GetGameSessionLogUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl
func (c *GameLift) GetGameSessionLogUrlRequest(input *GetGameSessionLogUrlInput) (req *request.Request, output *GetGameSessionLogUrlOutput) {
	op := &request.Operation{
		Name:       opGetGameSessionLogUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGameSessionLogUrlInput{}
	}

	output = &GetGameSessionLogUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGameSessionLogUrl API operation for Amazon GameLift.
//
// Retrieves the location of stored game session logs for a specified game session.
// When a game session is terminated, Amazon GameLift automatically stores the
// logs in Amazon S3 and retains them for 14 days. Use this URL to download
// the logs.
//
// See the AWS Service Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift)
// page for maximum log file sizes. Log files that exceed this limit are not
// saved.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation GetGameSessionLogUrl for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl
func (c *GameLift) GetGameSessionLogUrl(input *GetGameSessionLogUrlInput) (*GetGameSessionLogUrlOutput, error) {
	req, out := c.GetGameSessionLogUrlRequest(input)
	return out, req.Send()
}

// GetGameSessionLogUrlWithContext is the same as GetGameSessionLogUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetGameSessionLogUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) GetGameSessionLogUrlWithContext(ctx aws.Context, input *GetGameSessionLogUrlInput, opts ...request.Option) (*GetGameSessionLogUrlOutput, error) {
	req, out := c.GetGameSessionLogUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceAccess = "GetInstanceAccess"

// GetInstanceAccessRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceAccess for more information on using the GetInstanceAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceAccessRequest method.
//    req, resp := client.GetInstanceAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess
func (c *GameLift) GetInstanceAccessRequest(input *GetInstanceAccessInput) (req *request.Request, output *GetInstanceAccessOutput) {
	op := &request.Operation{
		Name:       opGetInstanceAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceAccessInput{}
	}

	output = &GetInstanceAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceAccess API operation for Amazon GameLift.
//
// Requests remote access to a fleet instance. Remote access is useful for debugging,
// gathering benchmarking data, or watching activity in real time.
//
// Access requires credentials that match the operating system of the instance.
// For a Windows instance, Amazon GameLift returns a user name and password
// as strings for use with a Windows Remote Desktop client. For a Linux instance,
// Amazon GameLift returns a user name and RSA private key, also as strings,
// for use with an SSH client. The private key must be saved in the proper format
// to a .pem file before using. If you're making this request using the AWS
// CLI, saving the secret can be handled as part of the GetInstanceAccess request.
// (See the example later in this topic). For more information on remote access,
// see Remotely Accessing an Instance (http://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html).
//
// To request access to a specific instance, specify the IDs of the instance
// and the fleet it belongs to. If successful, an InstanceAccess object is returned
// containing the instance's IP address and a set of credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation GetInstanceAccess for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess
func (c *GameLift) GetInstanceAccess(input *GetInstanceAccessInput) (*GetInstanceAccessOutput, error) {
	req, out := c.GetInstanceAccessRequest(input)
	return out, req.Send()
}

// GetInstanceAccessWithContext is the same as GetInstanceAccess with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) GetInstanceAccessWithContext(ctx aws.Context, input *GetInstanceAccessInput, opts ...request.Option) (*GetInstanceAccessOutput, error) {
	req, out := c.GetInstanceAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAliases for more information on using the ListAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAliasesRequest method.
//    req, resp := client.ListAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases
func (c *GameLift) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for Amazon GameLift.
//
// Retrieves all aliases for this AWS account. You can filter the result set
// by alias name and/or routing strategy type. Use the pagination parameters
// to retrieve results in sequential pages.
//
// Returned aliases are not listed in any particular order.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListAliases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases
func (c *GameLift) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	return out, req.Send()
}

// ListAliasesWithContext is the same as ListAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListAliasesWithContext(ctx aws.Context, input *ListAliasesInput, opts ...request.Option) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBuilds = "ListBuilds"

// ListBuildsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuilds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuilds for more information on using the ListBuilds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBuildsRequest method.
//    req, resp := client.ListBuildsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds
func (c *GameLift) ListBuildsRequest(input *ListBuildsInput) (req *request.Request, output *ListBuildsOutput) {
	op := &request.Operation{
		Name:       opListBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBuildsInput{}
	}

	output = &ListBuildsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuilds API operation for Amazon GameLift.
//
// Retrieves build records for all builds associated with the AWS account in
// use. You can limit results to builds that are in a specific status by using
// the Status parameter. Use the pagination parameters to retrieve results in
// a set of sequential pages.
//
// Build records are not listed in any particular order.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListBuilds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds
func (c *GameLift) ListBuilds(input *ListBuildsInput) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	return out, req.Send()
}

// ListBuildsWithContext is the same as ListBuilds with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuilds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListBuildsWithContext(ctx aws.Context, input *ListBuildsInput, opts ...request.Option) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFleets = "ListFleets"

// ListFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFleets for more information on using the ListFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFleetsRequest method.
//    req, resp := client.ListFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets
func (c *GameLift) ListFleetsRequest(input *ListFleetsInput) (req *request.Request, output *ListFleetsOutput) {
	op := &request.Operation{
		Name:       opListFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFleetsInput{}
	}

	output = &ListFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFleets API operation for Amazon GameLift.
//
// Retrieves a collection of fleet records for this AWS account. You can filter
// the result set by build ID. Use the pagination parameters to retrieve results
// in sequential pages.
//
// Fleet records are not listed in any particular order.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListFleets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets
func (c *GameLift) ListFleets(input *ListFleetsInput) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	return out, req.Send()
}

// ListFleetsWithContext is the same as ListFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListFleetsWithContext(ctx aws.Context, input *ListFleetsInput, opts ...request.Option) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutScalingPolicy for more information on using the PutScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutScalingPolicyRequest method.
//    req, resp := client.PutScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy
func (c *GameLift) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	output = &PutScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutScalingPolicy API operation for Amazon GameLift.
//
// Creates or updates a scaling policy for a fleet. Scaling policies are used
// to automatically scale a fleet's hosting capacity to meet player demand.
// An active scaling policy instructs Amazon GameLift to track a fleet metric
// and automatically change the fleet's capacity when a certain threshold is
// reached. There are two types of scaling policies: target-based and rule-based.
// Use a target-based policy to quickly and efficiently manage fleet scaling;
// this option is the most commonly used. Use rule-based policies when you need
// to exert fine-grained control over auto-scaling.
//
// Fleets can have multiple scaling policies of each type in force at the same
// time; you can have one target-based policy, one or multiple rule-based scaling
// policies, or both. We recommend caution, however, because multiple auto-scaling
// policies can have unintended consequences.
//
// You can temporarily suspend all scaling policies for a fleet by calling StopFleetActions
// with the fleet action AUTO_SCALING. To resume scaling policies, call StartFleetActions
// with the same fleet action. To stop just one scaling policy--or to permanently
// remove it, you must delete the policy with DeleteScalingPolicy.
//
// Learn more about how to work with auto-scaling in Set Up Fleet Automatic
// Scaling (http://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html).
//
// Target-based policy
//
// A target-based policy tracks a single metric: PercentAvailableGameSessions.
// This metric tells us how much of a fleet's hosting capacity is ready to host
// game sessions but is not currently in use. This is the fleet's buffer; it
// measures the additional player demand that the fleet could handle at current
// capacity. With a target-based policy, you set your ideal buffer size and
// leave it to Amazon GameLift to take whatever action is needed to maintain
// that target.
//
// For example, you might choose to maintain a 10% buffer for a fleet that has
// the capacity to host 100 simultaneous game sessions. This policy tells Amazon
// GameLift to take action whenever the fleet's available capacity falls below
// or rises above 10 game sessions. Amazon GameLift will start new instances
// or stop unused instances in order to return to the 10% buffer.
//
// To create or update a target-based policy, specify a fleet ID and name, and
// set the policy type to "TargetBased". Specify the metric to track (PercentAvailableGameSessions)
// and reference a TargetConfiguration object with your desired buffer value.
// Exclude all other parameters. On a successful request, the policy name is
// returned. The scaling policy is automatically in force as soon as it's successfully
// created. If the fleet's auto-scaling actions are temporarily suspended, the
// new policy will be in force once the fleet actions are restarted.
//
// Rule-based policy
//
// A rule-based policy tracks specified fleet metric, sets a threshold value,
// and specifies the type of action to initiate when triggered. With a rule-based
// policy, you can select from several available fleet metrics. Each policy
// specifies whether to scale up or scale down (and by how much), so you need
// one policy for each type of action.
//
// For example, a policy may make the following statement: "If the percentage
// of idle instances is greater than 20% for more than 15 minutes, then reduce
// the fleet capacity by 10%."
//
// A policy's rule statement has the following structure:
//
// If [MetricName] is [ComparisonOperator][Threshold] for [EvaluationPeriods]
// minutes, then [ScalingAdjustmentType] to/by [ScalingAdjustment].
//
// To implement the example, the rule statement would look like this:
//
// If [PercentIdleInstances] is [GreaterThanThreshold][20] for [15] minutes,
// then [PercentChangeInCapacity] to/by [10].
//
// To create or update a scaling policy, specify a unique combination of name
// and fleet ID, and set the policy type to "RuleBased". Specify the parameter
// values for a policy rule statement. On a successful request, the policy name
// is returned. Scaling policies are automatically in force as soon as they're
// successfully created. If the fleet's auto-scaling actions are temporarily
// suspended, the new policy will be in force once the fleet actions are restarted.
//
// Operations related to fleet capacity scaling include:
//
//    * DescribeFleetCapacity
//
//    * UpdateFleetCapacity
//
//    * DescribeEC2InstanceLimits
//
//    * Manage scaling policies:
//
// PutScalingPolicy (auto-scaling)
//
// DescribeScalingPolicies (auto-scaling)
//
// DeleteScalingPolicy (auto-scaling)
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation PutScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy
func (c *GameLift) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	return out, req.Send()
}

// PutScalingPolicyWithContext is the same as PutScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) PutScalingPolicyWithContext(ctx aws.Context, input *PutScalingPolicyInput, opts ...request.Option) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestUploadCredentials = "RequestUploadCredentials"

// RequestUploadCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the RequestUploadCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestUploadCredentials for more information on using the RequestUploadCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RequestUploadCredentialsRequest method.
//    req, resp := client.RequestUploadCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials
func (c *GameLift) RequestUploadCredentialsRequest(input *RequestUploadCredentialsInput) (req *request.Request, output *RequestUploadCredentialsOutput) {
	op := &request.Operation{
		Name:       opRequestUploadCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestUploadCredentialsInput{}
	}

	output = &RequestUploadCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestUploadCredentials API operation for Amazon GameLift.
//
// Retrieves a fresh set of credentials for use when uploading a new set of
// game build files to Amazon GameLift's Amazon S3. This is done as part of
// the build creation process; see CreateBuild.
//
// To request new credentials, specify the build ID as returned with an initial
// CreateBuild request. If successful, a new set of credentials are returned,
// along with the S3 storage location associated with the build ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation RequestUploadCredentials for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials
func (c *GameLift) RequestUploadCredentials(input *RequestUploadCredentialsInput) (*RequestUploadCredentialsOutput, error) {
	req, out := c.RequestUploadCredentialsRequest(input)
	return out, req.Send()
}

// RequestUploadCredentialsWithContext is the same as RequestUploadCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See RequestUploadCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) RequestUploadCredentialsWithContext(ctx aws.Context, input *RequestUploadCredentialsInput, opts ...request.Option) (*RequestUploadCredentialsOutput, error) {
	req, out := c.RequestUploadCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResolveAlias = "ResolveAlias"

// ResolveAliasRequest generates a "aws/request.Request" representing the
// client's request for the ResolveAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResolveAlias for more information on using the ResolveAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResolveAliasRequest method.
//    req, resp := client.ResolveAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias
func (c *GameLift) ResolveAliasRequest(input *ResolveAliasInput) (req *request.Request, output *ResolveAliasOutput) {
	op := &request.Operation{
		Name:       opResolveAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveAliasInput{}
	}

	output = &ResolveAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResolveAlias API operation for Amazon GameLift.
//
// Retrieves the fleet ID that a specified alias is currently pointing to.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ResolveAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias
func (c *GameLift) ResolveAlias(input *ResolveAliasInput) (*ResolveAliasOutput, error) {
	req, out := c.ResolveAliasRequest(input)
	return out, req.Send()
}

// ResolveAliasWithContext is the same as ResolveAlias with the addition of
// the ability to pass a context and additional request options.
//
// See ResolveAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ResolveAliasWithContext(ctx aws.Context, input *ResolveAliasInput, opts ...request.Option) (*ResolveAliasOutput, error) {
	req, out := c.ResolveAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchGameSessions = "SearchGameSessions"

// SearchGameSessionsRequest generates a "aws/request.Request" representing the
// client's request for the SearchGameSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchGameSessions for more information on using the SearchGameSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchGameSessionsRequest method.
//    req, resp := client.SearchGameSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions
func (c *GameLift) SearchGameSessionsRequest(input *SearchGameSessionsInput) (req *request.Request, output *SearchGameSessionsOutput) {
	op := &request.Operation{
		Name:       opSearchGameSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchGameSessionsInput{}
	}

	output = &SearchGameSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchGameSessions API operation for Amazon GameLift.
//
// Retrieves all active game sessions that match a set of search criteria and
// sorts them in a specified order. You can search or sort by the following
// game session attributes:
//
//    * gameSessionId -- Unique identifier for the game session. You can use
//    either a GameSessionId or GameSessionArn value.
//
//    * gameSessionName -- Name assigned to a game session. This value is set
//    when requesting a new game session with CreateGameSession or updating
//    with UpdateGameSession. Game session names do not need to be unique to
//    a game session.
//
//    * gameSessionProperties -- Custom data defined in a game session's GameProperty
//    parameter. GameProperty values are stored as key:value pairs; the filter
//    expression must indicate the key and a string to search the data values
//    for. For example, to search for game sessions with custom data containing
//    the key:value pair "gameMode:brawl", specify the following: gameSessionProperties.gameMode
//    = "brawl". All custom data values are searched as strings.
//
//    * maximumSessions -- Maximum number of player sessions allowed for a game
//    session. This value is set when requesting a new game session with CreateGameSession
//    or updating with UpdateGameSession.
//
//    * creationTimeMillis -- Value indicating when a game session was created.
//    It is expressed in Unix time as milliseconds.
//
//    * playerSessionCount -- Number of players currently connected to a game
//    session. This value changes rapidly as players join the session or drop
//    out.
//
//    * hasAvailablePlayerSessions -- Boolean value indicating whether a game
//    session has reached its maximum number of players. It is highly recommended
//    that all search requests include this filter attribute to optimize search
//    performance and return only sessions that players can join.
//
// Returned values for playerSessionCount and hasAvailablePlayerSessions change
// quickly as players join sessions and others drop out. Results should be considered
// a snapshot in time. Be sure to refresh search results often, and handle sessions
// that fill up before a player can join.
//
// To search or sort, specify either a fleet ID or an alias ID, and provide
// a search filter expression, a sort expression, or both. If successful, a
// collection of GameSession objects matching the request is returned. Use the
// pagination parameters to retrieve results as a set of sequential pages.
//
// You can search for game sessions one fleet at a time only. To find game sessions
// across multiple fleets, you must search each fleet separately and combine
// the results. This search feature finds only game sessions that are in ACTIVE
// status. To locate games in statuses other than active, use DescribeGameSessionDetails.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation SearchGameSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions
func (c *GameLift) SearchGameSessions(input *SearchGameSessionsInput) (*SearchGameSessionsOutput, error) {
	req, out := c.SearchGameSessionsRequest(input)
	return out, req.Send()
}

// SearchGameSessionsWithContext is the same as SearchGameSessions with the addition of
// the ability to pass a context and additional request options.
//
// See SearchGameSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) SearchGameSessionsWithContext(ctx aws.Context, input *SearchGameSessionsInput, opts ...request.Option) (*SearchGameSessionsOutput, error) {
	req, out := c.SearchGameSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFleetActions = "StartFleetActions"

// StartFleetActionsRequest generates a "aws/request.Request" representing the
// client's request for the StartFleetActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFleetActions for more information on using the StartFleetActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartFleetActionsRequest method.
//    req, resp := client.StartFleetActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartFleetActions
func (c *GameLift) StartFleetActionsRequest(input *StartFleetActionsInput) (req *request.Request, output *StartFleetActionsOutput) {
	op := &request.Operation{
		Name:       opStartFleetActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFleetActionsInput{}
	}

	output = &StartFleetActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFleetActions API operation for Amazon GameLift.
//
// Resumes activity on a fleet that was suspended with StopFleetActions. Currently,
// this operation is used to restart a fleet's auto-scaling activity.
//
// To start fleet actions, specify the fleet ID and the type of actions to restart.
// When auto-scaling fleet actions are restarted, Amazon GameLift once again
// initiates scaling events as triggered by the fleet's scaling policies. If
// actions on the fleet were never stopped, this operation will have no effect.
// You can view a fleet's stopped actions using DescribeFleetAttributes.
//
// Operations related to fleet capacity scaling include:
//
//    * DescribeFleetCapacity
//
//    * UpdateFleetCapacity
//
//    * DescribeEC2InstanceLimits
//
//    * Manage scaling policies:
//
// PutScalingPolicy (auto-scaling)
//
// DescribeScalingPolicies (auto-scaling)
//
// DeleteScalingPolicy (auto-scaling)
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StartFleetActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartFleetActions
func (c *GameLift) StartFleetActions(input *StartFleetActionsInput) (*StartFleetActionsOutput, error) {
	req, out := c.StartFleetActionsRequest(input)
	return out, req.Send()
}

// StartFleetActionsWithContext is the same as StartFleetActions with the addition of
// the ability to pass a context and additional request options.
//
// See StartFleetActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StartFleetActionsWithContext(ctx aws.Context, input *StartFleetActionsInput, opts ...request.Option) (*StartFleetActionsOutput, error) {
	req, out := c.StartFleetActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartGameSessionPlacement = "StartGameSessionPlacement"

// StartGameSessionPlacementRequest generates a "aws/request.Request" representing the
// client's request for the StartGameSessionPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartGameSessionPlacement for more information on using the StartGameSessionPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartGameSessionPlacementRequest method.
//    req, resp := client.StartGameSessionPlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacement
func (c *GameLift) StartGameSessionPlacementRequest(input *StartGameSessionPlacementInput) (req *request.Request, output *StartGameSessionPlacementOutput) {
	op := &request.Operation{
		Name:       opStartGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartGameSessionPlacementInput{}
	}

	output = &StartGameSessionPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartGameSessionPlacement API operation for Amazon GameLift.
//
// Places a request for a new game session in a queue (see CreateGameSessionQueue).
// When processing a placement request, Amazon GameLift searches for available
// resources on the queue's destinations, scanning each until it finds resources
// or the placement request times out.
//
// A game session placement request can also request player sessions. When a
// new game session is successfully created, Amazon GameLift creates a player
// session for each player included in the request.
//
// When placing a game session, by default Amazon GameLift tries each fleet
// in the order they are listed in the queue configuration. Ideally, a queue's
// destinations are listed in preference order.
//
// Alternatively, when requesting a game session with players, you can also
// provide latency data for each player in relevant regions. Latency data indicates
// the performance lag a player experiences when connected to a fleet in the
// region. Amazon GameLift uses latency data to reorder the list of destinations
// to place the game session in a region with minimal lag. If latency data is
// provided for multiple players, Amazon GameLift calculates each region's average
// lag for all players and reorders to get the best game play across all players.
//
// To place a new game session request, specify the following:
//
//    * The queue name and a set of game session properties and settings
//
//    * A unique ID (such as a UUID) for the placement. You use this ID to track
//    the status of the placement request
//
//    * (Optional) A set of IDs and player data for each player you want to
//    join to the new game session
//
//    * Latency data for all players (if you want to optimize game play for
//    the players)
//
// If successful, a new game session placement is created.
//
// To track the status of a placement request, call DescribeGameSessionPlacement
// and check the request's status. If the status is FULFILLED, a new game session
// has been created and a game session ARN and region are referenced. If the
// placement request times out, you can resubmit the request or retry it with
// a different queue.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StartGameSessionPlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacement
func (c *GameLift) StartGameSessionPlacement(input *StartGameSessionPlacementInput) (*StartGameSessionPlacementOutput, error) {
	req, out := c.StartGameSessionPlacementRequest(input)
	return out, req.Send()
}

// StartGameSessionPlacementWithContext is the same as StartGameSessionPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See StartGameSessionPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StartGameSessionPlacementWithContext(ctx aws.Context, input *StartGameSessionPlacementInput, opts ...request.Option) (*StartGameSessionPlacementOutput, error) {
	req, out := c.StartGameSessionPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMatchBackfill = "StartMatchBackfill"

// StartMatchBackfillRequest generates a "aws/request.Request" representing the
// client's request for the StartMatchBackfill operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMatchBackfill for more information on using the StartMatchBackfill
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMatchBackfillRequest method.
//    req, resp := client.StartMatchBackfillRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchBackfill
func (c *GameLift) StartMatchBackfillRequest(input *StartMatchBackfillInput) (req *request.Request, output *StartMatchBackfillOutput) {
	op := &request.Operation{
		Name:       opStartMatchBackfill,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMatchBackfillInput{}
	}

	output = &StartMatchBackfillOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMatchBackfill API operation for Amazon GameLift.
//
// Finds new players to fill open slots in an existing game session. This operation
// can be used to add players to matched games that start with fewer than the
// maximum number of players or to replace players when they drop out. By backfilling
// with the same matchmaker used to create the original match, you ensure that
// new players meet the match criteria and maintain a consistent experience
// throughout the game session. You can backfill a match anytime after a game
// session has been created.
//
// To request a match backfill, specify a unique ticket ID, the existing game
// session's ARN, a matchmaking configuration, and a set of data that describes
// all current players in the game session. If successful, a match backfill
// ticket is created and returned with status set to QUEUED. The ticket is placed
// in the matchmaker's ticket pool and processed. Track the status of the ticket
// to respond as needed. For more detail how to set up backfilling, see  Backfill
// Existing Games with FlexMatch (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-backfill.html).
//
// The process of finding backfill matches is essentially identical to the initial
// matchmaking process. The matchmaker searches the pool and groups tickets
// together to form potential matches, allowing only one backfill ticket per
// potential match. Once the a match is formed, the matchmaker creates player
// sessions for the new players. All tickets in the match are updated with the
// game session's connection information, and the GameSession object is updated
// to include matchmaker data on the new players. For more detail on how match
// backfill requests are processed, see  How Amazon GameLift FlexMatch Works
// (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-intro.html).
//
// Matchmaking-related operations include:
//
//    * StartMatchmaking
//
//    * DescribeMatchmaking
//
//    * StopMatchmaking
//
//    * AcceptMatch
//
//    * StartMatchBackfill
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StartMatchBackfill for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchBackfill
func (c *GameLift) StartMatchBackfill(input *StartMatchBackfillInput) (*StartMatchBackfillOutput, error) {
	req, out := c.StartMatchBackfillRequest(input)
	return out, req.Send()
}

// StartMatchBackfillWithContext is the same as StartMatchBackfill with the addition of
// the ability to pass a context and additional request options.
//
// See StartMatchBackfill for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StartMatchBackfillWithContext(ctx aws.Context, input *StartMatchBackfillInput, opts ...request.Option) (*StartMatchBackfillOutput, error) {
	req, out := c.StartMatchBackfillRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMatchmaking = "StartMatchmaking"

// StartMatchmakingRequest generates a "aws/request.Request" representing the
// client's request for the StartMatchmaking operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMatchmaking for more information on using the StartMatchmaking
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMatchmakingRequest method.
//    req, resp := client.StartMatchmakingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchmaking
func (c *GameLift) StartMatchmakingRequest(input *StartMatchmakingInput) (req *request.Request, output *StartMatchmakingOutput) {
	op := &request.Operation{
		Name:       opStartMatchmaking,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMatchmakingInput{}
	}

	output = &StartMatchmakingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMatchmaking API operation for Amazon GameLift.
//
// Uses FlexMatch to create a game match for a group of players based on custom
// matchmaking rules, and starts a new game for the matched players. Each matchmaking
// request specifies the type of match to build (team configuration, rules for
// an acceptable match, etc.). The request also specifies the players to find
// a match for and where to host the new game session for optimal performance.
// A matchmaking request might start with a single player or a group of players
// who want to play together. FlexMatch finds additional players as needed to
// fill the match. Match type, rules, and the queue used to place a new game
// session are defined in a MatchmakingConfiguration. For complete information
// on setting up and using FlexMatch, see the topic  Adding FlexMatch to Your
// Game (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-intro.html).
//
// To start matchmaking, provide a unique ticket ID, specify a matchmaking configuration,
// and include the players to be matched. You must also include a set of player
// attributes relevant for the matchmaking configuration. If successful, a matchmaking
// ticket is returned with status set to QUEUED. Track the status of the ticket
// to respond as needed and acquire game session connection information for
// successfully completed matches.
//
// Tracking ticket status -- A couple of options are available for tracking
// the status of matchmaking requests:
//
//    * Polling -- Call DescribeMatchmaking. This operation returns the full
//    ticket object, including current status and (for completed tickets) game
//    session connection info. We recommend polling no more than once every
//    10 seconds.
//
//    * Notifications -- Get event notifications for changes in ticket status
//    using Amazon Simple Notification Service (SNS). Notifications are easy
//    to set up (see CreateMatchmakingConfiguration) and typically deliver match
//    status changes faster and more efficiently than polling. We recommend
//    that you use polling to back up to notifications (since delivery is not
//    guaranteed) and call DescribeMatchmaking only when notifications are not
//    received within 30 seconds.
//
// Processing a matchmaking request -- FlexMatch handles a matchmaking request
// as follows:
//
// Your client code submits a StartMatchmaking request for one or more players
// and tracks the status of the request ticket.
//
// FlexMatch uses this ticket and others in process to build an acceptable match.
// When a potential match is identified, all tickets in the proposed match are
// advanced to the next status.
//
// If the match requires player acceptance (set in the matchmaking configuration),
// the tickets move into status REQUIRES_ACCEPTANCE. This status triggers your
// client code to solicit acceptance from all players in every ticket involved
// in the match, and then call AcceptMatch for each player. If any player rejects
// or fails to accept the match before a specified timeout, the proposed match
// is dropped (see AcceptMatch for more details).
//
// Once a match is proposed and accepted, the matchmaking tickets move into
// status PLACING. FlexMatch locates resources for a new game session using
// the game session queue (set in the matchmaking configuration) and creates
// the game session based on the match data.
//
// When the match is successfully placed, the matchmaking tickets move into
// COMPLETED status. Connection information (including game session endpoint
// and player session) is added to the matchmaking tickets. Matched players
// can use the connection information to join the game.
//
// Matchmaking-related operations include:
//
//    * StartMatchmaking
//
//    * DescribeMatchmaking
//
//    * StopMatchmaking
//
//    * AcceptMatch
//
//    * StartMatchBackfill
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StartMatchmaking for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchmaking
func (c *GameLift) StartMatchmaking(input *StartMatchmakingInput) (*StartMatchmakingOutput, error) {
	req, out := c.StartMatchmakingRequest(input)
	return out, req.Send()
}

// StartMatchmakingWithContext is the same as StartMatchmaking with the addition of
// the ability to pass a context and additional request options.
//
// See StartMatchmaking for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StartMatchmakingWithContext(ctx aws.Context, input *StartMatchmakingInput, opts ...request.Option) (*StartMatchmakingOutput, error) {
	req, out := c.StartMatchmakingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopFleetActions = "StopFleetActions"

// StopFleetActionsRequest generates a "aws/request.Request" representing the
// client's request for the StopFleetActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopFleetActions for more information on using the StopFleetActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopFleetActionsRequest method.
//    req, resp := client.StopFleetActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopFleetActions
func (c *GameLift) StopFleetActionsRequest(input *StopFleetActionsInput) (req *request.Request, output *StopFleetActionsOutput) {
	op := &request.Operation{
		Name:       opStopFleetActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopFleetActionsInput{}
	}

	output = &StopFleetActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopFleetActions API operation for Amazon GameLift.
//
// Suspends activity on a fleet. Currently, this operation is used to stop a
// fleet's auto-scaling activity. It is used to temporarily stop scaling events
// triggered by the fleet's scaling policies. The policies can be retained and
// auto-scaling activity can be restarted using StartFleetActions. You can view
// a fleet's stopped actions using DescribeFleetAttributes.
//
// To stop fleet actions, specify the fleet ID and the type of actions to suspend.
// When auto-scaling fleet actions are stopped, Amazon GameLift no longer initiates
// scaling events except to maintain the fleet's desired instances setting (FleetCapacity.
// Changes to the fleet's capacity must be done manually using UpdateFleetCapacity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StopFleetActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopFleetActions
func (c *GameLift) StopFleetActions(input *StopFleetActionsInput) (*StopFleetActionsOutput, error) {
	req, out := c.StopFleetActionsRequest(input)
	return out, req.Send()
}

// StopFleetActionsWithContext is the same as StopFleetActions with the addition of
// the ability to pass a context and additional request options.
//
// See StopFleetActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StopFleetActionsWithContext(ctx aws.Context, input *StopFleetActionsInput, opts ...request.Option) (*StopFleetActionsOutput, error) {
	req, out := c.StopFleetActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopGameSessionPlacement = "StopGameSessionPlacement"

// StopGameSessionPlacementRequest generates a "aws/request.Request" representing the
// client's request for the StopGameSessionPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopGameSessionPlacement for more information on using the StopGameSessionPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopGameSessionPlacementRequest method.
//    req, resp := client.StopGameSessionPlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacement
func (c *GameLift) StopGameSessionPlacementRequest(input *StopGameSessionPlacementInput) (req *request.Request, output *StopGameSessionPlacementOutput) {
	op := &request.Operation{
		Name:       opStopGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopGameSessionPlacementInput{}
	}

	output = &StopGameSessionPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopGameSessionPlacement API operation for Amazon GameLift.
//
// Cancels a game session placement that is in PENDING status. To stop a placement,
// provide the placement ID values. If successful, the placement is moved to
// CANCELLED status.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StopGameSessionPlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacement
func (c *GameLift) StopGameSessionPlacement(input *StopGameSessionPlacementInput) (*StopGameSessionPlacementOutput, error) {
	req, out := c.StopGameSessionPlacementRequest(input)
	return out, req.Send()
}

// StopGameSessionPlacementWithContext is the same as StopGameSessionPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See StopGameSessionPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StopGameSessionPlacementWithContext(ctx aws.Context, input *StopGameSessionPlacementInput, opts ...request.Option) (*StopGameSessionPlacementOutput, error) {
	req, out := c.StopGameSessionPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMatchmaking = "StopMatchmaking"

// StopMatchmakingRequest generates a "aws/request.Request" representing the
// client's request for the StopMatchmaking operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMatchmaking for more information on using the StopMatchmaking
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopMatchmakingRequest method.
//    req, resp := client.StopMatchmakingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopMatchmaking
func (c *GameLift) StopMatchmakingRequest(input *StopMatchmakingInput) (req *request.Request, output *StopMatchmakingOutput) {
	op := &request.Operation{
		Name:       opStopMatchmaking,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopMatchmakingInput{}
	}

	output = &StopMatchmakingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopMatchmaking API operation for Amazon GameLift.
//
// Cancels a matchmaking ticket that is currently being processed. To stop the
// matchmaking operation, specify the ticket ID. If successful, work on the
// ticket is stopped, and the ticket status is changed to CANCELLED.
//
// Matchmaking-related operations include:
//
//    * StartMatchmaking
//
//    * DescribeMatchmaking
//
//    * StopMatchmaking
//
//    * AcceptMatch
//
//    * StartMatchBackfill
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StopMatchmaking for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopMatchmaking
func (c *GameLift) StopMatchmaking(input *StopMatchmakingInput) (*StopMatchmakingOutput, error) {
	req, out := c.StopMatchmakingRequest(input)
	return out, req.Send()
}

// StopMatchmakingWithContext is the same as StopMatchmaking with the addition of
// the ability to pass a context and additional request options.
//
// See StopMatchmaking for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StopMatchmakingWithContext(ctx aws.Context, input *StopMatchmakingInput, opts ...request.Option) (*StopMatchmakingOutput, error) {
	req, out := c.StopMatchmakingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAlias for more information on using the UpdateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAliasRequest method.
//    req, resp := client.UpdateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateAlias
func (c *GameLift) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *UpdateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	output = &UpdateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAlias API operation for Amazon GameLift.
//
// Updates properties for an alias. To update properties, specify the alias
// ID to be updated and provide the information to be changed. To reassign an
// alias to another fleet, provide an updated routing strategy. If successful,
// the updated alias record is returned.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateAlias
func (c *GameLift) UpdateAlias(input *UpdateAliasInput) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	return out, req.Send()
}

// UpdateAliasWithContext is the same as UpdateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateAliasWithContext(ctx aws.Context, input *UpdateAliasInput, opts ...request.Option) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBuild = "UpdateBuild"

// UpdateBuildRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBuild for more information on using the UpdateBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBuildRequest method.
//    req, resp := client.UpdateBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateBuild
func (c *GameLift) UpdateBuildRequest(input *UpdateBuildInput) (req *request.Request, output *UpdateBuildOutput) {
	op := &request.Operation{
		Name:       opUpdateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBuildInput{}
	}

	output = &UpdateBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBuild API operation for Amazon GameLift.
//
// Updates metadata in a build record, including the build name and version.
// To update the metadata, specify the build ID to update and provide the new
// values. If successful, a build object containing the updated metadata is
// returned.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateBuild
func (c *GameLift) UpdateBuild(input *UpdateBuildInput) (*UpdateBuildOutput, error) {
	req, out := c.UpdateBuildRequest(input)
	return out, req.Send()
}

// UpdateBuildWithContext is the same as UpdateBuild with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateBuildWithContext(ctx aws.Context, input *UpdateBuildInput, opts ...request.Option) (*UpdateBuildOutput, error) {
	req, out := c.UpdateBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetAttributes = "UpdateFleetAttributes"

// UpdateFleetAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetAttributes for more information on using the UpdateFleetAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFleetAttributesRequest method.
//    req, resp := client.UpdateFleetAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetAttributes
func (c *GameLift) UpdateFleetAttributesRequest(input *UpdateFleetAttributesInput) (req *request.Request, output *UpdateFleetAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetAttributesInput{}
	}

	output = &UpdateFleetAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleetAttributes API operation for Amazon GameLift.
//
// Updates fleet properties, including name and description, for a fleet. To
// update metadata, specify the fleet ID and the property values that you want
// to change. If successful, the fleet ID for the updated fleet is returned.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateFleetAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetAttributes
func (c *GameLift) UpdateFleetAttributes(input *UpdateFleetAttributesInput) (*UpdateFleetAttributesOutput, error) {
	req, out := c.UpdateFleetAttributesRequest(input)
	return out, req.Send()
}

// UpdateFleetAttributesWithContext is the same as UpdateFleetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateFleetAttributesWithContext(ctx aws.Context, input *UpdateFleetAttributesInput, opts ...request.Option) (*UpdateFleetAttributesOutput, error) {
	req, out := c.UpdateFleetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetCapacity = "UpdateFleetCapacity"

// UpdateFleetCapacityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetCapacity for more information on using the UpdateFleetCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFleetCapacityRequest method.
//    req, resp := client.UpdateFleetCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetCapacity
func (c *GameLift) UpdateFleetCapacityRequest(input *UpdateFleetCapacityInput) (req *request.Request, output *UpdateFleetCapacityOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetCapacityInput{}
	}

	output = &UpdateFleetCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleetCapacity API operation for Amazon GameLift.
//
// Updates capacity settings for a fleet. Use this action to specify the number
// of EC2 instances (hosts) that you want this fleet to contain. Before calling
// this action, you may want to call DescribeEC2InstanceLimits to get the maximum
// capacity based on the fleet's EC2 instance type.
//
// Specify minimum and maximum number of instances. Amazon GameLift will not
// change fleet capacity to values fall outside of this range. This is particularly
// important when using auto-scaling (see PutScalingPolicy) to allow capacity
// to adjust based on player demand while imposing limits on automatic adjustments.
//
// To update fleet capacity, specify the fleet ID and the number of instances
// you want the fleet to host. If successful, Amazon GameLift starts or terminates
// instances so that the fleet's active instance count matches the desired instance
// count. You can view a fleet's current capacity information by calling DescribeFleetCapacity.
// If the desired instance count is higher than the instance type's limit, the
// "Limit Exceeded" exception occurs.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateFleetCapacity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetCapacity
func (c *GameLift) UpdateFleetCapacity(input *UpdateFleetCapacityInput) (*UpdateFleetCapacityOutput, error) {
	req, out := c.UpdateFleetCapacityRequest(input)
	return out, req.Send()
}

// UpdateFleetCapacityWithContext is the same as UpdateFleetCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateFleetCapacityWithContext(ctx aws.Context, input *UpdateFleetCapacityInput, opts ...request.Option) (*UpdateFleetCapacityOutput, error) {
	req, out := c.UpdateFleetCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetPortSettings = "UpdateFleetPortSettings"

// UpdateFleetPortSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetPortSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetPortSettings for more information on using the UpdateFleetPortSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFleetPortSettingsRequest method.
//    req, resp := client.UpdateFleetPortSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetPortSettings
func (c *GameLift) UpdateFleetPortSettingsRequest(input *UpdateFleetPortSettingsInput) (req *request.Request, output *UpdateFleetPortSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetPortSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetPortSettingsInput{}
	}

	output = &UpdateFleetPortSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleetPortSettings API operation for Amazon GameLift.
//
// Updates port settings for a fleet. To update settings, specify the fleet
// ID to be updated and list the permissions you want to update. List the permissions
// you want to add in InboundPermissionAuthorizations, and permissions you want
// to remove in InboundPermissionRevocations. Permissions to be removed must
// match existing fleet permissions. If successful, the fleet ID for the updated
// fleet is returned.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateFleetPortSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetPortSettings
func (c *GameLift) UpdateFleetPortSettings(input *UpdateFleetPortSettingsInput) (*UpdateFleetPortSettingsOutput, error) {
	req, out := c.UpdateFleetPortSettingsRequest(input)
	return out, req.Send()
}

// UpdateFleetPortSettingsWithContext is the same as UpdateFleetPortSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetPortSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateFleetPortSettingsWithContext(ctx aws.Context, input *UpdateFleetPortSettingsInput, opts ...request.Option) (*UpdateFleetPortSettingsOutput, error) {
	req, out := c.UpdateFleetPortSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGameSession = "UpdateGameSession"

// UpdateGameSessionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGameSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGameSession for more information on using the UpdateGameSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGameSessionRequest method.
//    req, resp := client.UpdateGameSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSession
func (c *GameLift) UpdateGameSessionRequest(input *UpdateGameSessionInput) (req *request.Request, output *UpdateGameSessionOutput) {
	op := &request.Operation{
		Name:       opUpdateGameSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameSessionInput{}
	}

	output = &UpdateGameSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGameSession API operation for Amazon GameLift.
//
// Updates game session properties. This includes the session name, maximum
// player count, protection policy, which controls whether or not an active
// game session can be terminated during a scale-down event, and the player
// session creation policy, which controls whether or not new players can join
// the session. To update a game session, specify the game session ID and the
// values you want to change. If successful, an updated GameSession object is
// returned.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateGameSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidGameSessionStatusException "InvalidGameSessionStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the game instance. Resolve
//   the conflict before retrying.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSession
func (c *GameLift) UpdateGameSession(input *UpdateGameSessionInput) (*UpdateGameSessionOutput, error) {
	req, out := c.UpdateGameSessionRequest(input)
	return out, req.Send()
}

// UpdateGameSessionWithContext is the same as UpdateGameSession with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGameSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateGameSessionWithContext(ctx aws.Context, input *UpdateGameSessionInput, opts ...request.Option) (*UpdateGameSessionOutput, error) {
	req, out := c.UpdateGameSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGameSessionQueue = "UpdateGameSessionQueue"

// UpdateGameSessionQueueRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGameSessionQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGameSessionQueue for more information on using the UpdateGameSessionQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGameSessionQueueRequest method.
//    req, resp := client.UpdateGameSessionQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionQueue
func (c *GameLift) UpdateGameSessionQueueRequest(input *UpdateGameSessionQueueInput) (req *request.Request, output *UpdateGameSessionQueueOutput) {
	op := &request.Operation{
		Name:       opUpdateGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameSessionQueueInput{}
	}

	output = &UpdateGameSessionQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGameSessionQueue API operation for Amazon GameLift.
//
// Updates settings for a game session queue, which determines how new game
// session requests in the queue are processed. To update settings, specify
// the queue name to be updated and provide the new settings. When updating
// destinations, provide a complete list of destinations.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateGameSessionQueue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionQueue
func (c *GameLift) UpdateGameSessionQueue(input *UpdateGameSessionQueueInput) (*UpdateGameSessionQueueOutput, error) {
	req, out := c.UpdateGameSessionQueueRequest(input)
	return out, req.Send()
}

// UpdateGameSessionQueueWithContext is the same as UpdateGameSessionQueue with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGameSessionQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateGameSessionQueueWithContext(ctx aws.Context, input *UpdateGameSessionQueueInput, opts ...request.Option) (*UpdateGameSessionQueueOutput, error) {
	req, out := c.UpdateGameSessionQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMatchmakingConfiguration = "UpdateMatchmakingConfiguration"

// UpdateMatchmakingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMatchmakingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMatchmakingConfiguration for more information on using the UpdateMatchmakingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMatchmakingConfigurationRequest method.
//    req, resp := client.UpdateMatchmakingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateMatchmakingConfiguration
func (c *GameLift) UpdateMatchmakingConfigurationRequest(input *UpdateMatchmakingConfigurationInput) (req *request.Request, output *UpdateMatchmakingConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateMatchmakingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMatchmakingConfigurationInput{}
	}

	output = &UpdateMatchmakingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMatchmakingConfiguration API operation for Amazon GameLift.
//
// Updates settings for a FlexMatch matchmaking configuration. To update settings,
// specify the configuration name to be updated and provide the new settings.
//
// Operations related to match configurations and rule sets include:
//
//    * CreateMatchmakingConfiguration
//
//    * DescribeMatchmakingConfigurations
//
//    * UpdateMatchmakingConfiguration
//
//    * DeleteMatchmakingConfiguration
//
//    * CreateMatchmakingRuleSet
//
//    * DescribeMatchmakingRuleSets
//
//    * ValidateMatchmakingRuleSet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateMatchmakingConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateMatchmakingConfiguration
func (c *GameLift) UpdateMatchmakingConfiguration(input *UpdateMatchmakingConfigurationInput) (*UpdateMatchmakingConfigurationOutput, error) {
	req, out := c.UpdateMatchmakingConfigurationRequest(input)
	return out, req.Send()
}

// UpdateMatchmakingConfigurationWithContext is the same as UpdateMatchmakingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMatchmakingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateMatchmakingConfigurationWithContext(ctx aws.Context, input *UpdateMatchmakingConfigurationInput, opts ...request.Option) (*UpdateMatchmakingConfigurationOutput, error) {
	req, out := c.UpdateMatchmakingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuntimeConfiguration = "UpdateRuntimeConfiguration"

// UpdateRuntimeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuntimeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuntimeConfiguration for more information on using the UpdateRuntimeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuntimeConfigurationRequest method.
//    req, resp := client.UpdateRuntimeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateRuntimeConfiguration
func (c *GameLift) UpdateRuntimeConfigurationRequest(input *UpdateRuntimeConfigurationInput) (req *request.Request, output *UpdateRuntimeConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateRuntimeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuntimeConfigurationInput{}
	}

	output = &UpdateRuntimeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuntimeConfiguration API operation for Amazon GameLift.
//
// Updates the current run-time configuration for the specified fleet, which
// tells Amazon GameLift how to launch server processes on instances in the
// fleet. You can update a fleet's run-time configuration at any time after
// the fleet is created; it does not need to be in an ACTIVE status.
//
// To update run-time configuration, specify the fleet ID and provide a RuntimeConfiguration
// object with the updated collection of server process configurations.
//
// Each instance in a Amazon GameLift fleet checks regularly for an updated
// run-time configuration and changes how it launches server processes to comply
// with the latest version. Existing server processes are not affected by the
// update; they continue to run until they end, while Amazon GameLift simply
// adds new server processes to fit the current run-time configuration. As a
// result, the run-time configuration changes are applied gradually as existing
// processes shut down and new processes are launched in Amazon GameLift's normal
// process recycling activity.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateRuntimeConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateRuntimeConfiguration
func (c *GameLift) UpdateRuntimeConfiguration(input *UpdateRuntimeConfigurationInput) (*UpdateRuntimeConfigurationOutput, error) {
	req, out := c.UpdateRuntimeConfigurationRequest(input)
	return out, req.Send()
}

// UpdateRuntimeConfigurationWithContext is the same as UpdateRuntimeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuntimeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateRuntimeConfigurationWithContext(ctx aws.Context, input *UpdateRuntimeConfigurationInput, opts ...request.Option) (*UpdateRuntimeConfigurationOutput, error) {
	req, out := c.UpdateRuntimeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateMatchmakingRuleSet = "ValidateMatchmakingRuleSet"

// ValidateMatchmakingRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the ValidateMatchmakingRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateMatchmakingRuleSet for more information on using the ValidateMatchmakingRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ValidateMatchmakingRuleSetRequest method.
//    req, resp := client.ValidateMatchmakingRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ValidateMatchmakingRuleSet
func (c *GameLift) ValidateMatchmakingRuleSetRequest(input *ValidateMatchmakingRuleSetInput) (req *request.Request, output *ValidateMatchmakingRuleSetOutput) {
	op := &request.Operation{
		Name:       opValidateMatchmakingRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateMatchmakingRuleSetInput{}
	}

	output = &ValidateMatchmakingRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateMatchmakingRuleSet API operation for Amazon GameLift.
//
// Validates the syntax of a matchmaking rule or rule set. This operation checks
// that the rule set uses syntactically correct JSON and that it conforms to
// allowed property expressions. To validate syntax, provide a rule set string.
//
// Operations related to match configurations and rule sets include:
//
//    * CreateMatchmakingConfiguration
//
//    * DescribeMatchmakingConfigurations
//
//    * UpdateMatchmakingConfiguration
//
//    * DeleteMatchmakingConfiguration
//
//    * CreateMatchmakingRuleSet
//
//    * DescribeMatchmakingRuleSets
//
//    * ValidateMatchmakingRuleSet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ValidateMatchmakingRuleSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnsupportedRegionException "UnsupportedRegionException"
//   The requested operation is not supported in the region specified.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ValidateMatchmakingRuleSet
func (c *GameLift) ValidateMatchmakingRuleSet(input *ValidateMatchmakingRuleSetInput) (*ValidateMatchmakingRuleSetOutput, error) {
	req, out := c.ValidateMatchmakingRuleSetRequest(input)
	return out, req.Send()
}

// ValidateMatchmakingRuleSetWithContext is the same as ValidateMatchmakingRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateMatchmakingRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ValidateMatchmakingRuleSetWithContext(ctx aws.Context, input *ValidateMatchmakingRuleSetInput, opts ...request.Option) (*ValidateMatchmakingRuleSetOutput, error) {
	req, out := c.ValidateMatchmakingRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the input for a request action.
type AcceptMatchInput struct {
	_ struct{} `type:"structure"`

	// Player response to the proposed match.
	//
	// AcceptanceType is a required field
	AcceptanceType *string `type:"string" required:"true" enum:"AcceptanceType"`

	// Unique identifier for a player delivering the response. This parameter can
	// include one or multiple player IDs.
	//
	// PlayerIds is a required field
	PlayerIds []*string `type:"list" required:"true"`

	// Unique identifier for a matchmaking ticket. The ticket must be in status
	// REQUIRES_ACCEPTANCE; otherwise this request will fail.
	//
	// TicketId is a required field
	TicketId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptMatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptMatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptMatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptMatchInput"}
	if s.AcceptanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceptanceType"))
	}
	if s.PlayerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerIds"))
	}
	if s.TicketId == nil {
		invalidParams.Add(request.NewErrParamRequired("TicketId"))
	}
	if s.TicketId != nil && len(*s.TicketId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TicketId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptanceType sets the AcceptanceType field's value.
func (s *AcceptMatchInput) SetAcceptanceType(v string) *AcceptMatchInput {
	s.AcceptanceType = &v
	return s
}

// SetPlayerIds sets the PlayerIds field's value.
func (s *AcceptMatchInput) SetPlayerIds(v []*string) *AcceptMatchInput {
	s.PlayerIds = v
	return s
}

// SetTicketId sets the TicketId field's value.
func (s *AcceptMatchInput) SetTicketId(v string) *AcceptMatchInput {
	s.TicketId = &v
	return s
}

type AcceptMatchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptMatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptMatchOutput) GoString() string {
	return s.String()
}

// Properties describing a fleet alias.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
type Alias struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias; alias ARNs are unique across all regions.
	AliasArn *string `min:"1" type:"string"`

	// Unique identifier for an alias; alias IDs are unique within a region.
	AliasId *string `type:"string"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// Human-readable description of an alias.
	Description *string `type:"string"`

	// Time stamp indicating when this data object was last modified. Format is
	// a number expressed in Unix time as milliseconds (for example "1469498468.057").
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Descriptive label that is associated with an alias. Alias names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Alias configuration for the alias, including routing type and settings.
	RoutingStrategy *RoutingStrategy `type:"structure"`
}

// String returns the string representation
func (s Alias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alias) GoString() string {
	return s.String()
}

// SetAliasArn sets the AliasArn field's value.
func (s *Alias) SetAliasArn(v string) *Alias {
	s.AliasArn = &v
	return s
}

// SetAliasId sets the AliasId field's value.
func (s *Alias) SetAliasId(v string) *Alias {
	s.AliasId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Alias) SetCreationTime(v time.Time) *Alias {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Alias) SetDescription(v string) *Alias {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Alias) SetLastUpdatedTime(v time.Time) *Alias {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Alias) SetName(v string) *Alias {
	s.Name = &v
	return s
}

// SetRoutingStrategy sets the RoutingStrategy field's value.
func (s *Alias) SetRoutingStrategy(v *RoutingStrategy) *Alias {
	s.RoutingStrategy = v
	return s
}

// Values for use in Player attribute key:value pairs. This object lets you
// specify an attribute value using any of the valid data types: string, number,
// string array or data map. Each AttributeValue object can use only one of
// the available properties.
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// For number values, expressed as double.
	N *float64 `type:"double"`

	// For single string values. Maximum string length is 100 characters.
	S *string `min:"1" type:"string"`

	// For a map of up to 10 data type:value pairs. Maximum length for each string
	// value is 100 characters.
	SDM map[string]*float64 `type:"map"`

	// For a list of up to 10 strings. Maximum length for each string is 100 characters.
	// Duplicate values are not recognized; all occurrences of the repeated value
	// after the first of a repeated value are ignored.
	SL []*string `type:"list"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeValue"}
	if s.S != nil && len(*s.S) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetN sets the N field's value.
func (s *AttributeValue) SetN(v float64) *AttributeValue {
	s.N = &v
	return s
}

// SetS sets the S field's value.
func (s *AttributeValue) SetS(v string) *AttributeValue {
	s.S = &v
	return s
}

// SetSDM sets the SDM field's value.
func (s *AttributeValue) SetSDM(v map[string]*float64) *AttributeValue {
	s.SDM = v
	return s
}

// SetSL sets the SL field's value.
func (s *AttributeValue) SetSL(v []*string) *AttributeValue {
	s.SL = v
	return s
}

// Temporary access credentials used for uploading game build files to Amazon
// GameLift. They are valid for a limited time. If they expire before you upload
// your game build, get a new set by calling RequestUploadCredentials.
type AwsCredentials struct {
	_ struct{} `type:"structure"`

	// Temporary key allowing access to the Amazon GameLift S3 account.
	AccessKeyId *string `min:"1" type:"string"`

	// Temporary secret key allowing access to the Amazon GameLift S3 account.
	SecretAccessKey *string `min:"1" type:"string"`

	// Token used to associate a specific build ID with the files uploaded using
	// these credentials.
	SessionToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AwsCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCredentials) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AwsCredentials) SetAccessKeyId(v string) *AwsCredentials {
	s.AccessKeyId = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *AwsCredentials) SetSecretAccessKey(v string) *AwsCredentials {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *AwsCredentials) SetSessionToken(v string) *AwsCredentials {
	s.SessionToken = &v
	return s
}

// Properties describing a game build.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
type Build struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build.
	BuildId *string `type:"string"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// Descriptive label that is associated with a build. Build names do not need
	// to be unique. It can be set using CreateBuild or UpdateBuild.
	Name *string `type:"string"`

	// Operating system that the game server binaries are built to run on. This
	// value determines the type of fleet resources that you can use for this build.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// File size of the uploaded game build, expressed in bytes. When the build
	// status is INITIALIZED, this value is 0.
	SizeOnDisk *int64 `min:"1" type:"long"`

	// Current status of the build.
	//
	// Possible build statuses include the following:
	//
	//    * INITIALIZED -- A new build has been defined, but no files have been
	//    uploaded. You cannot create fleets for builds that are in this status.
	//    When a build is successfully created, the build status is set to this
	//    value.
	//
	//    * READY -- The game build has been successfully uploaded. You can now
	//    create new fleets for this build.
	//
	//    * FAILED -- The game build upload failed. You cannot create new fleets
	//    for this build.
	Status *string `type:"string" enum:"BuildStatus"`

	// Version that is associated with this build. Version strings do not need to
	// be unique. This value can be set using CreateBuild or UpdateBuild.
	Version *string `type:"string"`
}

// String returns the string representation
func (s Build) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Build) GoString() string {
	return s.String()
}

// SetBuildId sets the BuildId field's value.
func (s *Build) SetBuildId(v string) *Build {
	s.BuildId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Build) SetCreationTime(v time.Time) *Build {
	s.CreationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Build) SetName(v string) *Build {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *Build) SetOperatingSystem(v string) *Build {
	s.OperatingSystem = &v
	return s
}

// SetSizeOnDisk sets the SizeOnDisk field's value.
func (s *Build) SetSizeOnDisk(v int64) *Build {
	s.SizeOnDisk = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Build) SetStatus(v string) *Build {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Build) SetVersion(v string) *Build {
	s.Version = &v
	return s
}

// Represents the input for a request action.
type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Human-readable description of an alias.
	Description *string `min:"1" type:"string"`

	// Descriptive label that is associated with an alias. Alias names do not need
	// to be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Object that specifies the fleet and routing type to use for the alias.
	//
	// RoutingStrategy is a required field
	RoutingStrategy *RoutingStrategy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoutingStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingStrategy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAliasInput) SetDescription(v string) *CreateAliasInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAliasInput) SetName(v string) *CreateAliasInput {
	s.Name = &v
	return s
}

// SetRoutingStrategy sets the RoutingStrategy field's value.
func (s *CreateAliasInput) SetRoutingStrategy(v *RoutingStrategy) *CreateAliasInput {
	s.RoutingStrategy = v
	return s
}

// Represents the returned data in response to a request action.
type CreateAliasOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created alias record.
	Alias *Alias `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *CreateAliasOutput) SetAlias(v *Alias) *CreateAliasOutput {
	s.Alias = v
	return s
}

// Represents the input for a request action.
type CreateBuildInput struct {
	_ struct{} `type:"structure"`

	// Descriptive label that is associated with a build. Build names do not need
	// to be unique. You can use UpdateBuild to change this value later.
	Name *string `min:"1" type:"string"`

	// Operating system that the game server binaries are built to run on. This
	// value determines the type of fleet resources that you can use for this build.
	// If your game build contains multiple executables, they all must run on the
	// same operating system. If an operating system is not specified when creating
	// a build, Amazon GameLift uses the default value (WINDOWS_2012). This value
	// cannot be changed later.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// Information indicating where your game build files are stored. Use this parameter
	// only when creating a build with files stored in an Amazon S3 bucket that
	// you own. The storage location must specify an Amazon S3 bucket name and key,
	// as well as a role ARN that you set up to allow Amazon GameLift to access
	// your Amazon S3 bucket. The S3 bucket must be in the same region that you
	// want to create a new build in.
	StorageLocation *S3Location `type:"structure"`

	// Version that is associated with this build. Version strings do not need to
	// be unique. You can use UpdateBuild to change this value later.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBuildInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}
	if s.StorageLocation != nil {
		if err := s.StorageLocation.Validate(); err != nil {
			invalidParams.AddNested("StorageLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateBuildInput) SetName(v string) *CreateBuildInput {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *CreateBuildInput) SetOperatingSystem(v string) *CreateBuildInput {
	s.OperatingSystem = &v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *CreateBuildInput) SetStorageLocation(v *S3Location) *CreateBuildInput {
	s.StorageLocation = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateBuildInput) SetVersion(v string) *CreateBuildInput {
	s.Version = &v
	return s
}

// Represents the returned data in response to a request action.
type CreateBuildOutput struct {
	_ struct{} `type:"structure"`

	// The newly created build record, including a unique build ID and status.
	Build *Build `type:"structure"`

	// Amazon S3 location for your game build file, including bucket name and key.
	StorageLocation *S3Location `type:"structure"`

	// This element is returned only when the operation is called without a storage
	// location. It contains credentials to use when you are uploading a build file
	// to an Amazon S3 bucket that is owned by Amazon GameLift. Credentials have
	// a limited life span. To refresh these credentials, call RequestUploadCredentials.
	UploadCredentials *AwsCredentials `type:"structure"`
}

// String returns the string representation
func (s CreateBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *CreateBuildOutput) SetBuild(v *Build) *CreateBuildOutput {
	s.Build = v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *CreateBuildOutput) SetStorageLocation(v *S3Location) *CreateBuildOutput {
	s.StorageLocation = v
	return s
}

// SetUploadCredentials sets the UploadCredentials field's value.
func (s *CreateBuildOutput) SetUploadCredentials(v *AwsCredentials) *CreateBuildOutput {
	s.UploadCredentials = v
	return s
}

// Represents the input for a request action.
type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to be deployed on the new fleet. The build
	// must have been successfully uploaded to Amazon GameLift and be in a READY
	// status. This fleet setting cannot be changed once the fleet is created.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`

	// Human-readable description of a fleet.
	Description *string `min:"1" type:"string"`

	// Range of IP addresses and port settings that permit inbound traffic to access
	// server processes running on the fleet. If no inbound permissions are set,
	// including both IP address range and port range, the server processes in the
	// fleet cannot accept connections. You can specify one or more sets of permissions
	// for a fleet.
	EC2InboundPermissions []*IpPermission `type:"list"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	//
	// EC2InstanceType is a required field
	EC2InstanceType *string `type:"string" required:"true" enum:"EC2InstanceType"`

	// Indicates whether to use on-demand instances or spot instances for this fleet.
	// If empty, the default is ON_DEMAND. Both categories of instances use identical
	// hardware and configurations, based on the instance type selected for this
	// fleet. You can acquire on-demand instances at any time for a fixed price
	// and keep them as long as you need them. Spot instances have lower prices,
	// but spot pricing is variable, and while in use they can be interrupted (with
	// a two-minute notification). Learn more about Amazon GameLift spot instances
	// with at  Choose Computing Resources (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html).
	FleetType *string `type:"string" enum:"FleetType"`

	// This parameter is no longer used. Instead, to specify where Amazon GameLift
	// should store log files once a server process shuts down, use the Amazon GameLift
	// server API ProcessReady() and specify one or more directory paths in logParameters.
	// See more information in the Server API Reference (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process).
	LogPaths []*string `type:"list"`

	// Name of a metric group to add this fleet to. A metric group tracks metrics
	// across all fleets in the group. Use an existing metric group name to add
	// this fleet to the group, or use a new name to create a new metric group.
	// A fleet can only be included in one metric group at a time.
	MetricGroups []*string `type:"list"`

	// Descriptive label that is associated with a fleet. Fleet names do not need
	// to be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Game session protection policy to apply to all instances in this fleet. If
	// this parameter is not set, instances in this fleet default to no protection.
	// You can change a fleet's protection policy using UpdateFleetAttributes, but
	// this change will only affect sessions created after the policy change. You
	// can also set protection for individual instances using UpdateGameSession.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// Unique identifier for the AWS account with the VPC that you want to peer
	// your Amazon GameLift fleet with. You can find your Account ID in the AWS
	// Management Console under account settings.
	PeerVpcAwsAccountId *string `min:"1" type:"string"`

	// Unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same region where your fleet is deployed.
	// To get VPC information, including IDs, use the Virtual Private Cloud service
	// tools, including the VPC Dashboard in the AWS Management Console.
	PeerVpcId *string `min:"1" type:"string"`

	// Policy that limits the number of game sessions an individual player can create
	// over a span of time for this fleet.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy `type:"structure"`

	// Instructions for launching server processes on each instance in the fleet.
	// The run-time configuration for a fleet has a collection of server process
	// configurations, one for each type of server process to run on an instance.
	// A server process configuration specifies the location of the server executable,
	// launch parameters, and the number of concurrent processes with that configuration
	// to maintain on each instance. A CreateFleet request must include a run-time
	// configuration with at least one server process configuration; otherwise the
	// request fails with an invalid request exception. (This parameter replaces
	// the parameters ServerLaunchPath and ServerLaunchParameters; requests that
	// contain values for these parameters instead of a run-time configuration will
	// continue to work.)
	RuntimeConfiguration *RuntimeConfiguration `type:"structure"`

	// This parameter is no longer used. Instead, specify server launch parameters
	// in the RuntimeConfiguration parameter. (Requests that specify a server launch
	// path and launch parameters instead of a run-time configuration will continue
	// to work.)
	ServerLaunchParameters *string `min:"1" type:"string"`

	// This parameter is no longer used. Instead, specify a server launch path using
	// the RuntimeConfiguration parameter. (Requests that specify a server launch
	// path and launch parameters instead of a run-time configuration will continue
	// to work.)
	ServerLaunchPath *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EC2InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("EC2InstanceType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PeerVpcAwsAccountId != nil && len(*s.PeerVpcAwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcAwsAccountId", 1))
	}
	if s.PeerVpcId != nil && len(*s.PeerVpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcId", 1))
	}
	if s.ServerLaunchParameters != nil && len(*s.ServerLaunchParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerLaunchParameters", 1))
	}
	if s.ServerLaunchPath != nil && len(*s.ServerLaunchPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerLaunchPath", 1))
	}
	if s.EC2InboundPermissions != nil {
		for i, v := range s.EC2InboundPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EC2InboundPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RuntimeConfiguration != nil {
		if err := s.RuntimeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RuntimeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *CreateFleetInput) SetBuildId(v string) *CreateFleetInput {
	s.BuildId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFleetInput) SetDescription(v string) *CreateFleetInput {
	s.Description = &v
	return s
}

// SetEC2InboundPermissions sets the EC2InboundPermissions field's value.
func (s *CreateFleetInput) SetEC2InboundPermissions(v []*IpPermission) *CreateFleetInput {
	s.EC2InboundPermissions = v
	return s
}

// SetEC2InstanceType sets the EC2InstanceType field's value.
func (s *CreateFleetInput) SetEC2InstanceType(v string) *CreateFleetInput {
	s.EC2InstanceType = &v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *CreateFleetInput) SetFleetType(v string) *CreateFleetInput {
	s.FleetType = &v
	return s
}

// SetLogPaths sets the LogPaths field's value.
func (s *CreateFleetInput) SetLogPaths(v []*string) *CreateFleetInput {
	s.LogPaths = v
	return s
}

// SetMetricGroups sets the MetricGroups field's value.
func (s *CreateFleetInput) SetMetricGroups(v []*string) *CreateFleetInput {
	s.MetricGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFleetInput) SetName(v string) *CreateFleetInput {
	s.Name = &v
	return s
}

// SetNewGameSessionProtectionPolicy sets the NewGameSessionProtectionPolicy field's value.
func (s *CreateFleetInput) SetNewGameSessionProtectionPolicy(v string) *CreateFleetInput {
	s.NewGameSessionProtectionPolicy = &v
	return s
}

// SetPeerVpcAwsAccountId sets the PeerVpcAwsAccountId field's value.
func (s *CreateFleetInput) SetPeerVpcAwsAccountId(v string) *CreateFleetInput {
	s.PeerVpcAwsAccountId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *CreateFleetInput) SetPeerVpcId(v string) *CreateFleetInput {
	s.PeerVpcId = &v
	return s
}

// SetResourceCreationLimitPolicy sets the ResourceCreationLimitPolicy field's value.
func (s *CreateFleetInput) SetResourceCreationLimitPolicy(v *ResourceCreationLimitPolicy) *CreateFleetInput {
	s.ResourceCreationLimitPolicy = v
	return s
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *CreateFleetInput) SetRuntimeConfiguration(v *RuntimeConfiguration) *CreateFleetInput {
	s.RuntimeConfiguration = v
	return s
}

// SetServerLaunchParameters sets the ServerLaunchParameters field's value.
func (s *CreateFleetInput) SetServerLaunchParameters(v string) *CreateFleetInput {
	s.ServerLaunchParameters = &v
	return s
}

// SetServerLaunchPath sets the ServerLaunchPath field's value.
func (s *CreateFleetInput) SetServerLaunchPath(v string) *CreateFleetInput {
	s.ServerLaunchPath = &v
	return s
}

// Represents the returned data in response to a request action.
type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// Properties for the newly created fleet.
	FleetAttributes *FleetAttributes `type:"structure"`
}

// String returns the string representation
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetFleetAttributes sets the FleetAttributes field's value.
func (s *CreateFleetOutput) SetFleetAttributes(v *FleetAttributes) *CreateFleetOutput {
	s.FleetAttributes = v
	return s
}

// Represents the input for a request action.
type CreateGameSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias associated with the fleet to create a game
	// session in. Each request must reference either a fleet ID or alias ID, but
	// not both.
	AliasId *string `type:"string"`

	// Unique identifier for a player or entity creating the game session. This
	// ID is used to enforce a resource protection policy (if one exists) that limits
	// the number of concurrent active game sessions one player can have.
	CreatorId *string `min:"1" type:"string"`

	// Unique identifier for a fleet to create a game session in. Each request must
	// reference either a fleet ID or alias ID, but not both.
	FleetId *string `type:"string"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameProperties []*GameProperty `type:"list"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string `min:"1" type:"string"`

	// This parameter is no longer preferred. Please use IdempotencyToken instead.
	// Custom string that uniquely identifies a request for a new game session.
	// Maximum token length is 48 characters. If provided, this string is included
	// in the new game session's ID. (A game session ARN has the following format:
	// arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string or idempotency
	// token>.)
	GameSessionId *string `min:"1" type:"string"`

	// Custom string that uniquely identifies a request for a new game session.
	// Maximum token length is 48 characters. If provided, this string is included
	// in the new game session's ID. (A game session ARN has the following format:
	// arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string or idempotency
	// token>.) Idempotency tokens remain in use for 30 days after a game session
	// has ended; game session objects are retained for this time period and then
	// deleted.
	IdempotencyToken *string `min:"1" type:"string"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	//
	// MaximumPlayerSessionCount is a required field
	MaximumPlayerSessionCount *int64 `type:"integer" required:"true"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateGameSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGameSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGameSessionInput"}
	if s.CreatorId != nil && len(*s.CreatorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorId", 1))
	}
	if s.GameSessionData != nil && len(*s.GameSessionData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionData", 1))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.MaximumPlayerSessionCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumPlayerSessionCount"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.GameProperties != nil {
		for i, v := range s.GameProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GameProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *CreateGameSessionInput) SetAliasId(v string) *CreateGameSessionInput {
	s.AliasId = &v
	return s
}

// SetCreatorId sets the CreatorId field's value.
func (s *CreateGameSessionInput) SetCreatorId(v string) *CreateGameSessionInput {
	s.CreatorId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *CreateGameSessionInput) SetFleetId(v string) *CreateGameSessionInput {
	s.FleetId = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *CreateGameSessionInput) SetGameProperties(v []*GameProperty) *CreateGameSessionInput {
	s.GameProperties = v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *CreateGameSessionInput) SetGameSessionData(v string) *CreateGameSessionInput {
	s.GameSessionData = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *CreateGameSessionInput) SetGameSessionId(v string) *CreateGameSessionInput {
	s.GameSessionId = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateGameSessionInput) SetIdempotencyToken(v string) *CreateGameSessionInput {
	s.IdempotencyToken = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *CreateGameSessionInput) SetMaximumPlayerSessionCount(v int64) *CreateGameSessionInput {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGameSessionInput) SetName(v string) *CreateGameSessionInput {
	s.Name = &v
	return s
}

// Represents the returned data in response to a request action.
type CreateGameSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created game session record.
	GameSession *GameSession `type:"structure"`
}

// String returns the string representation
func (s CreateGameSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionOutput) GoString() string {
	return s.String()
}

// SetGameSession sets the GameSession field's value.
func (s *CreateGameSessionOutput) SetGameSession(v *GameSession) *CreateGameSessionOutput {
	s.GameSession = v
	return s
}

// Represents the input for a request action.
type CreateGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// List of fleets that can be used to fulfill game session placement requests
	// in the queue. Fleets are identified by either a fleet ARN or a fleet alias
	// ARN. Destinations are listed in default preference order.
	Destinations []*GameSessionQueueDestination `type:"list"`

	// Descriptive label that is associated with game session queue. Queue names
	// must be unique within each region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Collection of latency policies to apply when processing game sessions placement
	// requests with player latency information. Multiple policies are evaluated
	// in order of the maximum latency value, starting with the lowest latency values.
	// With just one policy, it is enforced at the start of the game session placement
	// for the duration period. With multiple policies, each policy is enforced
	// consecutively for its duration period. For example, a queue might enforce
	// a 60-second policy followed by a 120-second policy, and then no policy for
	// the remainder of the placement. A player latency policy must set a value
	// for MaximumIndividualPlayerLatencyMilliseconds; if none is set, this API
	// requests will fail.
	PlayerLatencyPolicies []*PlayerLatencyPolicy `type:"list"`

	// Maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGameSessionQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGameSessionQueueInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *CreateGameSessionQueueInput) SetDestinations(v []*GameSessionQueueDestination) *CreateGameSessionQueueInput {
	s.Destinations = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGameSessionQueueInput) SetName(v string) *CreateGameSessionQueueInput {
	s.Name = &v
	return s
}

// SetPlayerLatencyPolicies sets the PlayerLatencyPolicies field's value.
func (s *CreateGameSessionQueueInput) SetPlayerLatencyPolicies(v []*PlayerLatencyPolicy) *CreateGameSessionQueueInput {
	s.PlayerLatencyPolicies = v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *CreateGameSessionQueueInput) SetTimeoutInSeconds(v int64) *CreateGameSessionQueueInput {
	s.TimeoutInSeconds = &v
	return s
}

// Represents the returned data in response to a request action.
type CreateGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created game session queue.
	GameSessionQueue *GameSessionQueue `type:"structure"`
}

// String returns the string representation
func (s CreateGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionQueueOutput) GoString() string {
	return s.String()
}

// SetGameSessionQueue sets the GameSessionQueue field's value.
func (s *CreateGameSessionQueueOutput) SetGameSessionQueue(v *GameSessionQueue) *CreateGameSessionQueueOutput {
	s.GameSessionQueue = v
	return s
}

// Represents the input for a request action.
type CreateMatchmakingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Flag that determines whether or not a match that was created with this configuration
	// must be accepted by the matched players. To require acceptance, set to TRUE.
	//
	// AcceptanceRequired is a required field
	AcceptanceRequired *bool `type:"boolean" required:"true"`

	// Length of time (in seconds) to wait for players to accept a proposed match.
	// If any player rejects the match or fails to accept before the timeout, the
	// ticket continues to look for an acceptable match.
	AcceptanceTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Number of player slots in a match to keep open for future players. For example,
	// if the configuration's rule set specifies a match for a single 12-person
	// team, and the additional player count is set to 2, only 10 players are selected
	// for the match.
	AdditionalPlayerCount *int64 `type:"integer"`

	// Information to attached to all events related to the matchmaking configuration.
	CustomEventData *string `type:"string"`

	// Meaningful description of the matchmaking configuration.
	Description *string `min:"1" type:"string"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match.
	GameProperties []*GameProperty `type:"list"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match.
	GameSessionData *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session queue and uniquely identifies it. Format
	// is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	// These queues are used when placing game sessions for matches that are created
	// with this matchmaking configuration. Queues can be located in any region.
	//
	// GameSessionQueueArns is a required field
	GameSessionQueueArns []*string `type:"list" required:"true"`

	// Unique identifier for a matchmaking configuration. This name is used to identify
	// the configuration associated with a matchmaking request or ticket.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// SNS topic ARN that is set up to receive matchmaking notifications.
	NotificationTarget *string `type:"string"`

	// Maximum duration, in seconds, that a matchmaking ticket can remain in process
	// before timing out. Requests that time out can be resubmitted as needed.
	//
	// RequestTimeoutSeconds is a required field
	RequestTimeoutSeconds *int64 `min:"1" type:"integer" required:"true"`

	// Unique identifier for a matchmaking rule set to use with this configuration.
	// A matchmaking configuration can only use rule sets that are defined in the
	// same region.
	//
	// RuleSetName is a required field
	RuleSetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMatchmakingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMatchmakingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMatchmakingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMatchmakingConfigurationInput"}
	if s.AcceptanceRequired == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceptanceRequired"))
	}
	if s.AcceptanceTimeoutSeconds != nil && *s.AcceptanceTimeoutSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("AcceptanceTimeoutSeconds", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GameSessionData != nil && len(*s.GameSessionData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionData", 1))
	}
	if s.GameSessionQueueArns == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionQueueArns"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RequestTimeoutSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestTimeoutSeconds"))
	}
	if s.RequestTimeoutSeconds != nil && *s.RequestTimeoutSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RequestTimeoutSeconds", 1))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}
	if s.RuleSetName != nil && len(*s.RuleSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetName", 1))
	}
	if s.GameProperties != nil {
		for i, v := range s.GameProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GameProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptanceRequired sets the AcceptanceRequired field's value.
func (s *CreateMatchmakingConfigurationInput) SetAcceptanceRequired(v bool) *CreateMatchmakingConfigurationInput {
	s.AcceptanceRequired = &v
	return s
}

// SetAcceptanceTimeoutSeconds sets the AcceptanceTimeoutSeconds field's value.
func (s *CreateMatchmakingConfigurationInput) SetAcceptanceTimeoutSeconds(v int64) *CreateMatchmakingConfigurationInput {
	s.AcceptanceTimeoutSeconds = &v
	return s
}

// SetAdditionalPlayerCount sets the AdditionalPlayerCount field's value.
func (s *CreateMatchmakingConfigurationInput) SetAdditionalPlayerCount(v int64) *CreateMatchmakingConfigurationInput {
	s.AdditionalPlayerCount = &v
	return s
}

// SetCustomEventData sets the CustomEventData field's value.
func (s *CreateMatchmakingConfigurationInput) SetCustomEventData(v string) *CreateMatchmakingConfigurationInput {
	s.CustomEventData = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateMatchmakingConfigurationInput) SetDescription(v string) *CreateMatchmakingConfigurationInput {
	s.Description = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *CreateMatchmakingConfigurationInput) SetGameProperties(v []*GameProperty) *CreateMatchmakingConfigurationInput {
	s.GameProperties = v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *CreateMatchmakingConfigurationInput) SetGameSessionData(v string) *CreateMatchmakingConfigurationInput {
	s.GameSessionData = &v
	return s
}

// SetGameSessionQueueArns sets the GameSessionQueueArns field's value.
func (s *CreateMatchmakingConfigurationInput) SetGameSessionQueueArns(v []*string) *CreateMatchmakingConfigurationInput {
	s.GameSessionQueueArns = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMatchmakingConfigurationInput) SetName(v string) *CreateMatchmakingConfigurationInput {
	s.Name = &v
	return s
}

// SetNotificationTarget sets the NotificationTarget field's value.
func (s *CreateMatchmakingConfigurationInput) SetNotificationTarget(v string) *CreateMatchmakingConfigurationInput {
	s.NotificationTarget = &v
	return s
}

// SetRequestTimeoutSeconds sets the RequestTimeoutSeconds field's value.
func (s *CreateMatchmakingConfigurationInput) SetRequestTimeoutSeconds(v int64) *CreateMatchmakingConfigurationInput {
	s.RequestTimeoutSeconds = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *CreateMatchmakingConfigurationInput) SetRuleSetName(v string) *CreateMatchmakingConfigurationInput {
	s.RuleSetName = &v
	return s
}

// Represents the returned data in response to a request action.
type CreateMatchmakingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created matchmaking configuration.
	Configuration *MatchmakingConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateMatchmakingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMatchmakingConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateMatchmakingConfigurationOutput) SetConfiguration(v *MatchmakingConfiguration) *CreateMatchmakingConfigurationOutput {
	s.Configuration = v
	return s
}

// Represents the input for a request action.
type CreateMatchmakingRuleSetInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a matchmaking rule set. This name is used to identify
	// the rule set associated with a matchmaking configuration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Collection of matchmaking rules, formatted as a JSON string. (Note that comments
	// are not allowed in JSON, but most elements support a description field.)
	//
	// RuleSetBody is a required field
	RuleSetBody *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMatchmakingRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMatchmakingRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMatchmakingRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMatchmakingRuleSetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RuleSetBody == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetBody"))
	}
	if s.RuleSetBody != nil && len(*s.RuleSetBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetBody", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateMatchmakingRuleSetInput) SetName(v string) *CreateMatchmakingRuleSetInput {
	s.Name = &v
	return s
}

// SetRuleSetBody sets the RuleSetBody field's value.
func (s *CreateMatchmakingRuleSetInput) SetRuleSetBody(v string) *CreateMatchmakingRuleSetInput {
	s.RuleSetBody = &v
	return s
}

// Represents the returned data in response to a request action.
type CreateMatchmakingRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created matchmaking rule set.
	//
	// RuleSet is a required field
	RuleSet *MatchmakingRuleSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateMatchmakingRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMatchmakingRuleSetOutput) GoString() string {
	return s.String()
}

// SetRuleSet sets the RuleSet field's value.
func (s *CreateMatchmakingRuleSetOutput) SetRuleSet(v *MatchmakingRuleSet) *CreateMatchmakingRuleSetOutput {
	s.RuleSet = v
	return s
}

// Represents the input for a request action.
type CreatePlayerSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to add a player to.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// Unique identifier for a player. Player IDs are developer-defined.
	//
	// PlayerId is a required field
	PlayerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePlayerSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlayerSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlayerSessionInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.PlayerData != nil && len(*s.PlayerData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerData", 1))
	}
	if s.PlayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerId"))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *CreatePlayerSessionInput) SetGameSessionId(v string) *CreatePlayerSessionInput {
	s.GameSessionId = &v
	return s
}

// SetPlayerData sets the PlayerData field's value.
func (s *CreatePlayerSessionInput) SetPlayerData(v string) *CreatePlayerSessionInput {
	s.PlayerData = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *CreatePlayerSessionInput) SetPlayerId(v string) *CreatePlayerSessionInput {
	s.PlayerId = &v
	return s
}

// Represents the returned data in response to a request action.
type CreatePlayerSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created player session record.
	PlayerSession *PlayerSession `type:"structure"`
}

// String returns the string representation
func (s CreatePlayerSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionOutput) GoString() string {
	return s.String()
}

// SetPlayerSession sets the PlayerSession field's value.
func (s *CreatePlayerSessionOutput) SetPlayerSession(v *PlayerSession) *CreatePlayerSessionOutput {
	s.PlayerSession = v
	return s
}

// Represents the input for a request action.
type CreatePlayerSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to add players to.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Map of string pairs, each specifying a player ID and a set of developer-defined
	// information related to the player. Amazon GameLift does not use this data,
	// so it can be formatted as needed for use in the game. Player data strings
	// for player IDs not included in the PlayerIds parameter are ignored.
	PlayerDataMap map[string]*string `type:"map"`

	// List of unique identifiers for the players to be added.
	//
	// PlayerIds is a required field
	PlayerIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreatePlayerSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlayerSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlayerSessionsInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.PlayerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerIds"))
	}
	if s.PlayerIds != nil && len(s.PlayerIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *CreatePlayerSessionsInput) SetGameSessionId(v string) *CreatePlayerSessionsInput {
	s.GameSessionId = &v
	return s
}

// SetPlayerDataMap sets the PlayerDataMap field's value.
func (s *CreatePlayerSessionsInput) SetPlayerDataMap(v map[string]*string) *CreatePlayerSessionsInput {
	s.PlayerDataMap = v
	return s
}

// SetPlayerIds sets the PlayerIds field's value.
func (s *CreatePlayerSessionsInput) SetPlayerIds(v []*string) *CreatePlayerSessionsInput {
	s.PlayerIds = v
	return s
}

// Represents the returned data in response to a request action.
type CreatePlayerSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of player session objects created for the added players.
	PlayerSessions []*PlayerSession `type:"list"`
}

// String returns the string representation
func (s CreatePlayerSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionsOutput) GoString() string {
	return s.String()
}

// SetPlayerSessions sets the PlayerSessions field's value.
func (s *CreatePlayerSessionsOutput) SetPlayerSessions(v []*PlayerSession) *CreatePlayerSessionsOutput {
	s.PlayerSessions = v
	return s
}

// Represents the input for a request action.
type CreateVpcPeeringAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the AWS account that you use to manage your Amazon
	// GameLift fleet. You can find your Account ID in the AWS Management Console
	// under account settings.
	//
	// GameLiftAwsAccountId is a required field
	GameLiftAwsAccountId *string `min:"1" type:"string" required:"true"`

	// Unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same region where your fleet is deployed.
	// To get VPC information, including IDs, use the Virtual Private Cloud service
	// tools, including the VPC Dashboard in the AWS Management Console.
	//
	// PeerVpcId is a required field
	PeerVpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVpcPeeringAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcPeeringAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcPeeringAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcPeeringAuthorizationInput"}
	if s.GameLiftAwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameLiftAwsAccountId"))
	}
	if s.GameLiftAwsAccountId != nil && len(*s.GameLiftAwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameLiftAwsAccountId", 1))
	}
	if s.PeerVpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("PeerVpcId"))
	}
	if s.PeerVpcId != nil && len(*s.PeerVpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameLiftAwsAccountId sets the GameLiftAwsAccountId field's value.
func (s *CreateVpcPeeringAuthorizationInput) SetGameLiftAwsAccountId(v string) *CreateVpcPeeringAuthorizationInput {
	s.GameLiftAwsAccountId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *CreateVpcPeeringAuthorizationInput) SetPeerVpcId(v string) *CreateVpcPeeringAuthorizationInput {
	s.PeerVpcId = &v
	return s
}

// Represents the returned data in response to a request action.
type CreateVpcPeeringAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// Details on the requested VPC peering authorization, including expiration.
	VpcPeeringAuthorization *VpcPeeringAuthorization `type:"structure"`
}

// String returns the string representation
func (s CreateVpcPeeringAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcPeeringAuthorizationOutput) GoString() string {
	return s.String()
}

// SetVpcPeeringAuthorization sets the VpcPeeringAuthorization field's value.
func (s *CreateVpcPeeringAuthorizationOutput) SetVpcPeeringAuthorization(v *VpcPeeringAuthorization) *CreateVpcPeeringAuthorizationOutput {
	s.VpcPeeringAuthorization = v
	return s
}

// Represents the input for a request action.
type CreateVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet. This tells Amazon GameLift which GameLift
	// VPC to peer with.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Unique identifier for the AWS account with the VPC that you want to peer
	// your Amazon GameLift fleet with. You can find your Account ID in the AWS
	// Management Console under account settings.
	//
	// PeerVpcAwsAccountId is a required field
	PeerVpcAwsAccountId *string `min:"1" type:"string" required:"true"`

	// Unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same region where your fleet is deployed.
	// To get VPC information, including IDs, use the Virtual Private Cloud service
	// tools, including the VPC Dashboard in the AWS Management Console.
	//
	// PeerVpcId is a required field
	PeerVpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcPeeringConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcPeeringConnectionInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.PeerVpcAwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("PeerVpcAwsAccountId"))
	}
	if s.PeerVpcAwsAccountId != nil && len(*s.PeerVpcAwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcAwsAccountId", 1))
	}
	if s.PeerVpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("PeerVpcId"))
	}
	if s.PeerVpcId != nil && len(*s.PeerVpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *CreateVpcPeeringConnectionInput) SetFleetId(v string) *CreateVpcPeeringConnectionInput {
	s.FleetId = &v
	return s
}

// SetPeerVpcAwsAccountId sets the PeerVpcAwsAccountId field's value.
func (s *CreateVpcPeeringConnectionInput) SetPeerVpcAwsAccountId(v string) *CreateVpcPeeringConnectionInput {
	s.PeerVpcAwsAccountId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *CreateVpcPeeringConnectionInput) SetPeerVpcId(v string) *CreateVpcPeeringConnectionInput {
	s.PeerVpcId = &v
	return s
}

type CreateVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify the alias you want to delete.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DeleteAliasInput) SetAliasId(v string) *DeleteAliasInput {
	s.AliasId = &v
	return s
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to delete.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBuildInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *DeleteBuildInput) SetBuildId(v string) *DeleteBuildInput {
	s.BuildId = &v
	return s
}

type DeleteBuildOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBuildOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to be deleted.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteFleetInput) SetFleetId(v string) *DeleteFleetInput {
	s.FleetId = &v
	return s
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// Descriptive label that is associated with game session queue. Queue names
	// must be unique within each region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGameSessionQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGameSessionQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGameSessionQueueInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteGameSessionQueueInput) SetName(v string) *DeleteGameSessionQueueInput {
	s.Name = &v
	return s
}

type DeleteGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGameSessionQueueOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteMatchmakingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a matchmaking configuration
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMatchmakingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMatchmakingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMatchmakingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMatchmakingConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteMatchmakingConfigurationInput) SetName(v string) *DeleteMatchmakingConfigurationInput {
	s.Name = &v
	return s
}

type DeleteMatchmakingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMatchmakingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMatchmakingConfigurationOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to be deleted.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Descriptive label that is associated with a scaling policy. Policy names
	// do not need to be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScalingPolicyInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteScalingPolicyInput) SetFleetId(v string) *DeleteScalingPolicyInput {
	s.FleetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteScalingPolicyInput) SetName(v string) *DeleteScalingPolicyInput {
	s.Name = &v
	return s
}

type DeleteScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteVpcPeeringAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the AWS account that you use to manage your Amazon
	// GameLift fleet. You can find your Account ID in the AWS Management Console
	// under account settings.
	//
	// GameLiftAwsAccountId is a required field
	GameLiftAwsAccountId *string `min:"1" type:"string" required:"true"`

	// Unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same region where your fleet is deployed.
	// To get VPC information, including IDs, use the Virtual Private Cloud service
	// tools, including the VPC Dashboard in the AWS Management Console.
	//
	// PeerVpcId is a required field
	PeerVpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcPeeringAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcPeeringAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcPeeringAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcPeeringAuthorizationInput"}
	if s.GameLiftAwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameLiftAwsAccountId"))
	}
	if s.GameLiftAwsAccountId != nil && len(*s.GameLiftAwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameLiftAwsAccountId", 1))
	}
	if s.PeerVpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("PeerVpcId"))
	}
	if s.PeerVpcId != nil && len(*s.PeerVpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameLiftAwsAccountId sets the GameLiftAwsAccountId field's value.
func (s *DeleteVpcPeeringAuthorizationInput) SetGameLiftAwsAccountId(v string) *DeleteVpcPeeringAuthorizationInput {
	s.GameLiftAwsAccountId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *DeleteVpcPeeringAuthorizationInput) SetPeerVpcId(v string) *DeleteVpcPeeringAuthorizationInput {
	s.PeerVpcId = &v
	return s
}

type DeleteVpcPeeringAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpcPeeringAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcPeeringAuthorizationOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet. This value must match the fleet ID referenced
	// in the VPC peering connection record.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Unique identifier for a VPC peering connection. This value is included in
	// the VpcPeeringConnection object, which can be retrieved by calling DescribeVpcPeeringConnections.
	//
	// VpcPeeringConnectionId is a required field
	VpcPeeringConnectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcPeeringConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcPeeringConnectionInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.VpcPeeringConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcPeeringConnectionId"))
	}
	if s.VpcPeeringConnectionId != nil && len(*s.VpcPeeringConnectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcPeeringConnectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteVpcPeeringConnectionInput) SetFleetId(v string) *DeleteVpcPeeringConnectionInput {
	s.FleetId = &v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *DeleteVpcPeeringConnectionInput) SetVpcPeeringConnectionId(v string) *DeleteVpcPeeringConnectionInput {
	s.VpcPeeringConnectionId = &v
	return s
}

type DeleteVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify the alias you want to retrieve.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeAliasInput) SetAliasId(v string) *DescribeAliasInput {
	s.AliasId = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeAliasOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the requested alias.
	Alias *Alias `type:"structure"`
}

// String returns the string representation
func (s DescribeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *DescribeAliasOutput) SetAlias(v *Alias) *DescribeAliasOutput {
	s.Alias = v
	return s
}

// Represents the input for a request action.
type DescribeBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to retrieve properties for.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBuildInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *DescribeBuildInput) SetBuildId(v string) *DescribeBuildInput {
	s.BuildId = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeBuildOutput struct {
	_ struct{} `type:"structure"`

	// Set of properties describing the requested build.
	Build *Build `type:"structure"`
}

// String returns the string representation
func (s DescribeBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *DescribeBuildOutput) SetBuild(v *Build) *DescribeBuildOutput {
	s.Build = v
	return s
}

// Represents the input for a request action.
type DescribeEC2InstanceLimitsInput struct {
	_ struct{} `type:"structure"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions. Leave
	// this parameter blank to retrieve limits for all types.
	EC2InstanceType *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation
func (s DescribeEC2InstanceLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEC2InstanceLimitsInput) GoString() string {
	return s.String()
}

// SetEC2InstanceType sets the EC2InstanceType field's value.
func (s *DescribeEC2InstanceLimitsInput) SetEC2InstanceType(v string) *DescribeEC2InstanceLimitsInput {
	s.EC2InstanceType = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeEC2InstanceLimitsOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the maximum number of instances for the specified instance
	// type.
	EC2InstanceLimits []*EC2InstanceLimit `type:"list"`
}

// String returns the string representation
func (s DescribeEC2InstanceLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEC2InstanceLimitsOutput) GoString() string {
	return s.String()
}

// SetEC2InstanceLimits sets the EC2InstanceLimits field's value.
func (s *DescribeEC2InstanceLimitsOutput) SetEC2InstanceLimits(v []*EC2InstanceLimit) *DescribeEC2InstanceLimitsOutput {
	s.EC2InstanceLimits = v
	return s
}

// Represents the input for a request action.
type DescribeFleetAttributesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet(s) to retrieve attributes for. To request attributes
	// for all fleets, leave this parameter empty.
	FleetIds []*string `min:"1" type:"list"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value. This parameter
	// is ignored when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetAttributesInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetIds sets the FleetIds field's value.
func (s *DescribeFleetAttributesInput) SetFleetIds(v []*string) *DescribeFleetAttributesInput {
	s.FleetIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetAttributesInput) SetLimit(v int64) *DescribeFleetAttributesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAttributesInput) SetNextToken(v string) *DescribeFleetAttributesInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeFleetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing attribute metadata for each requested fleet
	// ID.
	FleetAttributes []*FleetAttributes `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetAttributesOutput) GoString() string {
	return s.String()
}

// SetFleetAttributes sets the FleetAttributes field's value.
func (s *DescribeFleetAttributesOutput) SetFleetAttributes(v []*FleetAttributes) *DescribeFleetAttributesOutput {
	s.FleetAttributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAttributesOutput) SetNextToken(v string) *DescribeFleetAttributesOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type DescribeFleetCapacityInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet(s) to retrieve capacity information for. To
	// request capacity information for all fleets, leave this parameter empty.
	FleetIds []*string `min:"1" type:"list"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value. This parameter
	// is ignored when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetCapacityInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetIds sets the FleetIds field's value.
func (s *DescribeFleetCapacityInput) SetFleetIds(v []*string) *DescribeFleetCapacityInput {
	s.FleetIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetCapacityInput) SetLimit(v int64) *DescribeFleetCapacityInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetCapacityInput) SetNextToken(v string) *DescribeFleetCapacityInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeFleetCapacityOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing capacity information for each requested
	// fleet ID. Leave this parameter empty to retrieve capacity information for
	// all fleets.
	FleetCapacity []*FleetCapacity `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetCapacityOutput) GoString() string {
	return s.String()
}

// SetFleetCapacity sets the FleetCapacity field's value.
func (s *DescribeFleetCapacityOutput) SetFleetCapacity(v []*FleetCapacity) *DescribeFleetCapacityOutput {
	s.FleetCapacity = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetCapacityOutput) SetNextToken(v string) *DescribeFleetCapacityOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type DescribeFleetEventsInput struct {
	_ struct{} `type:"structure"`

	// Most recent date to retrieve event logs for. If no end time is specified,
	// this call returns entries from the specified start time up to the present.
	// Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").
	EndTime *time.Time `type:"timestamp"`

	// Unique identifier for a fleet to get event logs for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Earliest date to retrieve event logs for. If no start time is specified,
	// this call returns entries starting from when the fleet was created to the
	// specified end time. Format is a number expressed in Unix time as milliseconds
	// (ex: "1469498468.057").
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeFleetEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetEventsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeFleetEventsInput) SetEndTime(v time.Time) *DescribeFleetEventsInput {
	s.EndTime = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetEventsInput) SetFleetId(v string) *DescribeFleetEventsInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetEventsInput) SetLimit(v int64) *DescribeFleetEventsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetEventsInput) SetNextToken(v string) *DescribeFleetEventsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeFleetEventsInput) SetStartTime(v time.Time) *DescribeFleetEventsInput {
	s.StartTime = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeFleetEventsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing event log entries for the specified fleet.
	Events []*Event `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeFleetEventsOutput) SetEvents(v []*Event) *DescribeFleetEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetEventsOutput) SetNextToken(v string) *DescribeFleetEventsOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type DescribeFleetPortSettingsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to retrieve port settings for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFleetPortSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetPortSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetPortSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetPortSettingsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetPortSettingsInput) SetFleetId(v string) *DescribeFleetPortSettingsInput {
	s.FleetId = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeFleetPortSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains port settings for the requested fleet ID.
	InboundPermissions []*IpPermission `type:"list"`
}

// String returns the string representation
func (s DescribeFleetPortSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetPortSettingsOutput) GoString() string {
	return s.String()
}

// SetInboundPermissions sets the InboundPermissions field's value.
func (s *DescribeFleetPortSettingsOutput) SetInboundPermissions(v []*IpPermission) *DescribeFleetPortSettingsOutput {
	s.InboundPermissions = v
	return s
}

// Represents the input for a request action.
type DescribeFleetUtilizationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet(s) to retrieve utilization data for. To request
	// utilization data for all fleets, leave this parameter empty.
	FleetIds []*string `min:"1" type:"list"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value. This parameter
	// is ignored when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetUtilizationInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetIds sets the FleetIds field's value.
func (s *DescribeFleetUtilizationInput) SetFleetIds(v []*string) *DescribeFleetUtilizationInput {
	s.FleetIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetUtilizationInput) SetLimit(v int64) *DescribeFleetUtilizationInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetUtilizationInput) SetNextToken(v string) *DescribeFleetUtilizationInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeFleetUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing utilization information for each requested
	// fleet ID.
	FleetUtilization []*FleetUtilization `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetUtilizationOutput) GoString() string {
	return s.String()
}

// SetFleetUtilization sets the FleetUtilization field's value.
func (s *DescribeFleetUtilizationOutput) SetFleetUtilization(v []*FleetUtilization) *DescribeFleetUtilizationOutput {
	s.FleetUtilization = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetUtilizationOutput) SetNextToken(v string) *DescribeFleetUtilizationOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type DescribeGameSessionDetailsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias associated with the fleet to retrieve all
	// game sessions for.
	AliasId *string `type:"string"`

	// Unique identifier for a fleet to retrieve all game sessions active on the
	// fleet.
	FleetId *string `type:"string"`

	// Unique identifier for the game session to retrieve.
	GameSessionId *string `min:"1" type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. Possible game session statuses
	// include ACTIVE, TERMINATED, ACTIVATING and TERMINATING (the last two are
	// transitory).
	StatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionDetailsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StatusFilter != nil && len(*s.StatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeGameSessionDetailsInput) SetAliasId(v string) *DescribeGameSessionDetailsInput {
	s.AliasId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeGameSessionDetailsInput) SetFleetId(v string) *DescribeGameSessionDetailsInput {
	s.FleetId = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *DescribeGameSessionDetailsInput) SetGameSessionId(v string) *DescribeGameSessionDetailsInput {
	s.GameSessionId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameSessionDetailsInput) SetLimit(v int64) *DescribeGameSessionDetailsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionDetailsInput) SetNextToken(v string) *DescribeGameSessionDetailsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *DescribeGameSessionDetailsInput) SetStatusFilter(v string) *DescribeGameSessionDetailsInput {
	s.StatusFilter = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeGameSessionDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing game session properties and the protection
	// policy currently in force for each session matching the request.
	GameSessionDetails []*GameSessionDetail `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionDetailsOutput) GoString() string {
	return s.String()
}

// SetGameSessionDetails sets the GameSessionDetails field's value.
func (s *DescribeGameSessionDetailsOutput) SetGameSessionDetails(v []*GameSessionDetail) *DescribeGameSessionDetailsOutput {
	s.GameSessionDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionDetailsOutput) SetNextToken(v string) *DescribeGameSessionDetailsOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type DescribeGameSessionPlacementInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session placement to retrieve.
	//
	// PlacementId is a required field
	PlacementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGameSessionPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionPlacementInput"}
	if s.PlacementId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementId"))
	}
	if s.PlacementId != nil && len(*s.PlacementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementId sets the PlacementId field's value.
func (s *DescribeGameSessionPlacementInput) SetPlacementId(v string) *DescribeGameSessionPlacementInput {
	s.PlacementId = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeGameSessionPlacementOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the requested game session placement.
	GameSessionPlacement *GameSessionPlacement `type:"structure"`
}

// String returns the string representation
func (s DescribeGameSessionPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionPlacementOutput) GoString() string {
	return s.String()
}

// SetGameSessionPlacement sets the GameSessionPlacement field's value.
func (s *DescribeGameSessionPlacementOutput) SetGameSessionPlacement(v *GameSessionPlacement) *DescribeGameSessionPlacementOutput {
	s.GameSessionPlacement = v
	return s
}

// Represents the input for a request action.
type DescribeGameSessionQueuesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// List of queue names to retrieve information for. To request settings for
	// all queues, leave this parameter empty.
	Names []*string `type:"list"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionQueuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionQueuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionQueuesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameSessionQueuesInput) SetLimit(v int64) *DescribeGameSessionQueuesInput {
	s.Limit = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeGameSessionQueuesInput) SetNames(v []*string) *DescribeGameSessionQueuesInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionQueuesInput) SetNextToken(v string) *DescribeGameSessionQueuesInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeGameSessionQueuesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects that describes the requested game session queues.
	GameSessionQueues []*GameSessionQueue `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionQueuesOutput) GoString() string {
	return s.String()
}

// SetGameSessionQueues sets the GameSessionQueues field's value.
func (s *DescribeGameSessionQueuesOutput) SetGameSessionQueues(v []*GameSessionQueue) *DescribeGameSessionQueuesOutput {
	s.GameSessionQueues = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionQueuesOutput) SetNextToken(v string) *DescribeGameSessionQueuesOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type DescribeGameSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias associated with the fleet to retrieve all
	// game sessions for.
	AliasId *string `type:"string"`

	// Unique identifier for a fleet to retrieve all game sessions for.
	FleetId *string `type:"string"`

	// Unique identifier for the game session to retrieve. You can use either a
	// GameSessionId or GameSessionArn value.
	GameSessionId *string `min:"1" type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. Possible game session statuses
	// include ACTIVE, TERMINATED, ACTIVATING, and TERMINATING (the last two are
	// transitory).
	StatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StatusFilter != nil && len(*s.StatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeGameSessionsInput) SetAliasId(v string) *DescribeGameSessionsInput {
	s.AliasId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeGameSessionsInput) SetFleetId(v string) *DescribeGameSessionsInput {
	s.FleetId = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *DescribeGameSessionsInput) SetGameSessionId(v string) *DescribeGameSessionsInput {
	s.GameSessionId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameSessionsInput) SetLimit(v int64) *DescribeGameSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionsInput) SetNextToken(v string) *DescribeGameSessionsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *DescribeGameSessionsInput) SetStatusFilter(v string) *DescribeGameSessionsInput {
	s.StatusFilter = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeGameSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing game session properties for each session
	// matching the request.
	GameSessions []*GameSession `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionsOutput) GoString() string {
	return s.String()
}

// SetGameSessions sets the GameSessions field's value.
func (s *DescribeGameSessionsOutput) SetGameSessions(v []*GameSession) *DescribeGameSessionsOutput {
	s.GameSessions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionsOutput) SetNextToken(v string) *DescribeGameSessionsOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type DescribeInstancesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to retrieve instance information for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Unique identifier for an instance to retrieve. Specify an instance ID or
	// leave blank to retrieve all instances in the fleet.
	InstanceId *string `type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstancesInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeInstancesInput) SetFleetId(v string) *DescribeInstancesInput {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeInstancesInput) SetInstanceId(v string) *DescribeInstancesInput {
	s.InstanceId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeInstancesInput) SetLimit(v int64) *DescribeInstancesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancesInput) SetNextToken(v string) *DescribeInstancesInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing properties for each instance returned.
	Instances []*Instance `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribeInstancesOutput) SetInstances(v []*Instance) *DescribeInstancesOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancesOutput) SetNextToken(v string) *DescribeInstancesOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type DescribeMatchmakingConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. This parameter is limited to 10.
	Limit *int64 `min:"1" type:"integer"`

	// Unique identifier for a matchmaking configuration(s) to retrieve. To request
	// all existing configurations, leave this parameter empty.
	Names []*string `type:"list"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Unique identifier for a matchmaking rule set. Use this parameter to retrieve
	// all matchmaking configurations that use this rule set.
	RuleSetName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeMatchmakingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMatchmakingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMatchmakingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMatchmakingConfigurationsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RuleSetName != nil && len(*s.RuleSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeMatchmakingConfigurationsInput) SetLimit(v int64) *DescribeMatchmakingConfigurationsInput {
	s.Limit = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeMatchmakingConfigurationsInput) SetNames(v []*string) *DescribeMatchmakingConfigurationsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMatchmakingConfigurationsInput) SetNextToken(v string) *DescribeMatchmakingConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DescribeMatchmakingConfigurationsInput) SetRuleSetName(v string) *DescribeMatchmakingConfigurationsInput {
	s.RuleSetName = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeMatchmakingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of requested matchmaking configuration objects.
	Configurations []*MatchmakingConfiguration `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeMatchmakingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMatchmakingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *DescribeMatchmakingConfigurationsOutput) SetConfigurations(v []*MatchmakingConfiguration) *DescribeMatchmakingConfigurationsOutput {
	s.Configurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMatchmakingConfigurationsOutput) SetNextToken(v string) *DescribeMatchmakingConfigurationsOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type DescribeMatchmakingInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a matchmaking ticket. You can include up to 10 ID values.
	//
	// TicketIds is a required field
	TicketIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeMatchmakingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMatchmakingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMatchmakingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMatchmakingInput"}
	if s.TicketIds == nil {
		invalidParams.Add(request.NewErrParamRequired("TicketIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTicketIds sets the TicketIds field's value.
func (s *DescribeMatchmakingInput) SetTicketIds(v []*string) *DescribeMatchmakingInput {
	s.TicketIds = v
	return s
}

// Represents the returned data in response to a request action.
type DescribeMatchmakingOutput struct {
	_ struct{} `type:"structure"`

	// Collection of existing matchmaking ticket objects matching the request.
	TicketList []*MatchmakingTicket `type:"list"`
}

// String returns the string representation
func (s DescribeMatchmakingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMatchmakingOutput) GoString() string {
	return s.String()
}

// SetTicketList sets the TicketList field's value.
func (s *DescribeMatchmakingOutput) SetTicketList(v []*MatchmakingTicket) *DescribeMatchmakingOutput {
	s.TicketList = v
	return s
}

// Represents the input for a request action.
type DescribeMatchmakingRuleSetsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Unique identifier for a matchmaking rule set. This name is used to identify
	// the rule set associated with a matchmaking configuration.
	Names []*string `min:"1" type:"list"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeMatchmakingRuleSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMatchmakingRuleSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMatchmakingRuleSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMatchmakingRuleSetsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeMatchmakingRuleSetsInput) SetLimit(v int64) *DescribeMatchmakingRuleSetsInput {
	s.Limit = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeMatchmakingRuleSetsInput) SetNames(v []*string) *DescribeMatchmakingRuleSetsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMatchmakingRuleSetsInput) SetNextToken(v string) *DescribeMatchmakingRuleSetsInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeMatchmakingRuleSetsOutput struct {
	_ struct{} `type:"structure"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// Collection of requested matchmaking rule set objects.
	//
	// RuleSets is a required field
	RuleSets []*MatchmakingRuleSet `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeMatchmakingRuleSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMatchmakingRuleSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMatchmakingRuleSetsOutput) SetNextToken(v string) *DescribeMatchmakingRuleSetsOutput {
	s.NextToken = &v
	return s
}

// SetRuleSets sets the RuleSets field's value.
func (s *DescribeMatchmakingRuleSetsOutput) SetRuleSets(v []*MatchmakingRuleSet) *DescribeMatchmakingRuleSetsOutput {
	s.RuleSets = v
	return s
}

// Represents the input for a request action.
type DescribePlayerSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to retrieve player sessions for.
	GameSessionId *string `min:"1" type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. If a player session ID is specified,
	// this parameter is ignored.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value. If a player session
	// ID is specified, this parameter is ignored.
	NextToken *string `min:"1" type:"string"`

	// Unique identifier for a player to retrieve player sessions for.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session to retrieve.
	PlayerSessionId *string `type:"string"`

	// Player session status to filter results on.
	//
	// Possible player session statuses include the following:
	//
	//    * RESERVED -- The player session request has been received, but the player
	//    has not yet connected to the server process and/or been validated.
	//
	//    * ACTIVE -- The player has been validated by the server process and is
	//    currently connected.
	//
	//    * COMPLETED -- The player connection has been dropped.
	//
	//    * TIMEDOUT -- A player session request was received, but the player did
	//    not connect and/or was not validated within the timeout limit (60 seconds).
	PlayerSessionStatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribePlayerSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlayerSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePlayerSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePlayerSessionsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}
	if s.PlayerSessionStatusFilter != nil && len(*s.PlayerSessionStatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerSessionStatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *DescribePlayerSessionsInput) SetGameSessionId(v string) *DescribePlayerSessionsInput {
	s.GameSessionId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribePlayerSessionsInput) SetLimit(v int64) *DescribePlayerSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePlayerSessionsInput) SetNextToken(v string) *DescribePlayerSessionsInput {
	s.NextToken = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *DescribePlayerSessionsInput) SetPlayerId(v string) *DescribePlayerSessionsInput {
	s.PlayerId = &v
	return s
}

// SetPlayerSessionId sets the PlayerSessionId field's value.
func (s *DescribePlayerSessionsInput) SetPlayerSessionId(v string) *DescribePlayerSessionsInput {
	s.PlayerSessionId = &v
	return s
}

// SetPlayerSessionStatusFilter sets the PlayerSessionStatusFilter field's value.
func (s *DescribePlayerSessionsInput) SetPlayerSessionStatusFilter(v string) *DescribePlayerSessionsInput {
	s.PlayerSessionStatusFilter = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribePlayerSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// Collection of objects containing properties for each player session that
	// matches the request.
	PlayerSessions []*PlayerSession `type:"list"`
}

// String returns the string representation
func (s DescribePlayerSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlayerSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePlayerSessionsOutput) SetNextToken(v string) *DescribePlayerSessionsOutput {
	s.NextToken = &v
	return s
}

// SetPlayerSessions sets the PlayerSessions field's value.
func (s *DescribePlayerSessionsOutput) SetPlayerSessions(v []*PlayerSession) *DescribePlayerSessionsOutput {
	s.PlayerSessions = v
	return s
}

// Represents the input for a request action.
type DescribeRuntimeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to get the run-time configuration for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRuntimeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuntimeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuntimeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuntimeConfigurationInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeRuntimeConfigurationInput) SetFleetId(v string) *DescribeRuntimeConfigurationInput {
	s.FleetId = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeRuntimeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Instructions describing how server processes should be launched and maintained
	// on each instance in the fleet.
	RuntimeConfiguration *RuntimeConfiguration `type:"structure"`
}

// String returns the string representation
func (s DescribeRuntimeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuntimeConfigurationOutput) GoString() string {
	return s.String()
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *DescribeRuntimeConfigurationOutput) SetRuntimeConfiguration(v *RuntimeConfiguration) *DescribeRuntimeConfigurationOutput {
	s.RuntimeConfiguration = v
	return s
}

// Represents the input for a request action.
type DescribeScalingPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to retrieve scaling policies for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Scaling policy status to filter results on. A scaling policy is only in force
	// when in an ACTIVE status.
	//
	//    * ACTIVE -- The scaling policy is currently in force.
	//
	//    * UPDATEREQUESTED -- A request to update the scaling policy has been received.
	//
	//    * UPDATING -- A change is being made to the scaling policy.
	//
	//    * DELETEREQUESTED -- A request to delete the scaling policy has been received.
	//
	//    * DELETING -- The scaling policy is being deleted.
	//
	//    * DELETED -- The scaling policy has been deleted.
	//
	//    * ERROR -- An error occurred in creating the policy. It should be removed
	//    and recreated.
	StatusFilter *string `type:"string" enum:"ScalingStatusType"`
}

// String returns the string representation
func (s DescribeScalingPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPoliciesInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeScalingPoliciesInput) SetFleetId(v string) *DescribeScalingPoliciesInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeScalingPoliciesInput) SetLimit(v int64) *DescribeScalingPoliciesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesInput) SetNextToken(v string) *DescribeScalingPoliciesInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *DescribeScalingPoliciesInput) SetStatusFilter(v string) *DescribeScalingPoliciesInput {
	s.StatusFilter = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeScalingPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// Collection of objects containing the scaling policies matching the request.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesOutput) SetNextToken(v string) *DescribeScalingPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetScalingPolicies sets the ScalingPolicies field's value.
func (s *DescribeScalingPoliciesOutput) SetScalingPolicies(v []*ScalingPolicy) *DescribeScalingPoliciesOutput {
	s.ScalingPolicies = v
	return s
}

type DescribeVpcPeeringAuthorizationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeVpcPeeringAuthorizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcPeeringAuthorizationsInput) GoString() string {
	return s.String()
}

type DescribeVpcPeeringAuthorizationsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects that describe all valid VPC peering operations for
	// the current AWS account.
	VpcPeeringAuthorizations []*VpcPeeringAuthorization `type:"list"`
}

// String returns the string representation
func (s DescribeVpcPeeringAuthorizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcPeeringAuthorizationsOutput) GoString() string {
	return s.String()
}

// SetVpcPeeringAuthorizations sets the VpcPeeringAuthorizations field's value.
func (s *DescribeVpcPeeringAuthorizationsOutput) SetVpcPeeringAuthorizations(v []*VpcPeeringAuthorization) *DescribeVpcPeeringAuthorizationsOutput {
	s.VpcPeeringAuthorizations = v
	return s
}

// Represents the input for a request action.
type DescribeVpcPeeringConnectionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s DescribeVpcPeeringConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcPeeringConnectionsInput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeVpcPeeringConnectionsInput) SetFleetId(v string) *DescribeVpcPeeringConnectionsInput {
	s.FleetId = &v
	return s
}

// Represents the returned data in response to a request action.
type DescribeVpcPeeringConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of VPC peering connection records that match the request.
	VpcPeeringConnections []*VpcPeeringConnection `type:"list"`
}

// String returns the string representation
func (s DescribeVpcPeeringConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVpcPeeringConnectionsOutput) GoString() string {
	return s.String()
}

// SetVpcPeeringConnections sets the VpcPeeringConnections field's value.
func (s *DescribeVpcPeeringConnectionsOutput) SetVpcPeeringConnections(v []*VpcPeeringConnection) *DescribeVpcPeeringConnectionsOutput {
	s.VpcPeeringConnections = v
	return s
}

// Player information for use when creating player sessions using a game session
// placement request with StartGameSessionPlacement.
type DesiredPlayerSession struct {
	_ struct{} `type:"structure"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// Unique identifier for a player to associate with the player session.
	PlayerId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DesiredPlayerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DesiredPlayerSession) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DesiredPlayerSession) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DesiredPlayerSession"}
	if s.PlayerData != nil && len(*s.PlayerData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerData", 1))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlayerData sets the PlayerData field's value.
func (s *DesiredPlayerSession) SetPlayerData(v string) *DesiredPlayerSession {
	s.PlayerData = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *DesiredPlayerSession) SetPlayerId(v string) *DesiredPlayerSession {
	s.PlayerId = &v
	return s
}

// Current status of fleet capacity. The number of active instances should match
// or be in the process of matching the number of desired instances. Pending
// and terminating counts are non-zero only if fleet capacity is adjusting to
// an UpdateFleetCapacity request, or if access to resources is temporarily
// affected.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
type EC2InstanceCounts struct {
	_ struct{} `type:"structure"`

	// Actual number of active instances in the fleet.
	ACTIVE *int64 `type:"integer"`

	// Ideal number of active instances in the fleet.
	DESIRED *int64 `type:"integer"`

	// Number of active instances in the fleet that are not currently hosting a
	// game session.
	IDLE *int64 `type:"integer"`

	// Maximum value allowed for the fleet's instance count.
	MAXIMUM *int64 `type:"integer"`

	// Minimum value allowed for the fleet's instance count.
	MINIMUM *int64 `type:"integer"`

	// Number of instances in the fleet that are starting but not yet active.
	PENDING *int64 `type:"integer"`

	// Number of instances in the fleet that are no longer active but haven't yet
	// been terminated.
	TERMINATING *int64 `type:"integer"`
}

// String returns the string representation
func (s EC2InstanceCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2InstanceCounts) GoString() string {
	return s.String()
}

// SetACTIVE sets the ACTIVE field's value.
func (s *EC2InstanceCounts) SetACTIVE(v int64) *EC2InstanceCounts {
	s.ACTIVE = &v
	return s
}

// SetDESIRED sets the DESIRED field's value.
func (s *EC2InstanceCounts) SetDESIRED(v int64) *EC2InstanceCounts {
	s.DESIRED = &v
	return s
}

// SetIDLE sets the IDLE field's value.
func (s *EC2InstanceCounts) SetIDLE(v int64) *EC2InstanceCounts {
	s.IDLE = &v
	return s
}

// SetMAXIMUM sets the MAXIMUM field's value.
func (s *EC2InstanceCounts) SetMAXIMUM(v int64) *EC2InstanceCounts {
	s.MAXIMUM = &v
	return s
}

// SetMINIMUM sets the MINIMUM field's value.
func (s *EC2InstanceCounts) SetMINIMUM(v int64) *EC2InstanceCounts {
	s.MINIMUM = &v
	return s
}

// SetPENDING sets the PENDING field's value.
func (s *EC2InstanceCounts) SetPENDING(v int64) *EC2InstanceCounts {
	s.PENDING = &v
	return s
}

// SetTERMINATING sets the TERMINATING field's value.
func (s *EC2InstanceCounts) SetTERMINATING(v int64) *EC2InstanceCounts {
	s.TERMINATING = &v
	return s
}

// Maximum number of instances allowed based on the Amazon Elastic Compute Cloud
// (Amazon EC2) instance type. Instance limits can be retrieved by calling DescribeEC2InstanceLimits.
type EC2InstanceLimit struct {
	_ struct{} `type:"structure"`

	// Number of instances of the specified type that are currently in use by this
	// AWS account.
	CurrentInstances *int64 `type:"integer"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	EC2InstanceType *string `type:"string" enum:"EC2InstanceType"`

	// Number of instances allowed.
	InstanceLimit *int64 `type:"integer"`
}

// String returns the string representation
func (s EC2InstanceLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2InstanceLimit) GoString() string {
	return s.String()
}

// SetCurrentInstances sets the CurrentInstances field's value.
func (s *EC2InstanceLimit) SetCurrentInstances(v int64) *EC2InstanceLimit {
	s.CurrentInstances = &v
	return s
}

// SetEC2InstanceType sets the EC2InstanceType field's value.
func (s *EC2InstanceLimit) SetEC2InstanceType(v string) *EC2InstanceLimit {
	s.EC2InstanceType = &v
	return s
}

// SetInstanceLimit sets the InstanceLimit field's value.
func (s *EC2InstanceLimit) SetInstanceLimit(v int64) *EC2InstanceLimit {
	s.InstanceLimit = &v
	return s
}

// Log entry describing an event that involves Amazon GameLift resources (such
// as a fleet). In addition to tracking activity, event codes and messages can
// provide additional information for troubleshooting and debugging problems.
type Event struct {
	_ struct{} `type:"structure"`

	// Type of event being logged. The following events are currently in use:
	//
	// Fleet creation events:
	//
	//    * FLEET_CREATED -- A fleet record was successfully created with a status
	//    of NEW. Event messaging includes the fleet ID.
	//
	//    * FLEET_STATE_DOWNLOADING -- Fleet status changed from NEW to DOWNLOADING.
	//    The compressed build has started downloading to a fleet instance for installation.
	//
	//    *  FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the
	//    fleet instance.
	//
	//    * FLEET_CREATION_EXTRACTING_BUILD – The game server build was successfully
	//    downloaded to an instance, and the build files are now being extracted
	//    from the uploaded build and saved to an instance. Failure at this stage
	//    prevents a fleet from moving to ACTIVE status. Logs for this stage display
	//    a list of the files that are extracted and saved on the instance. Access
	//    the logs by using the URL in PreSignedLogUrl.
	//
	//    * FLEET_CREATION_RUNNING_INSTALLER – The game server build files were
	//    successfully extracted, and the Amazon GameLift is now running the build's
	//    install script (if one is included). Failure in this stage prevents a
	//    fleet from moving to ACTIVE status. Logs for this stage list the installation
	//    steps and whether or not the install completed successfully. Access the
	//    logs by using the URL in PreSignedLogUrl.
	//
	//    * FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful,
	//    and the Amazon GameLift is now verifying that the game server launch paths,
	//    which are specified in the fleet's run-time configuration, exist. If any
	//    listed launch path exists, Amazon GameLift tries to launch a game server
	//    process and waits for the process to report ready. Failures in this stage
	//    prevent a fleet from moving to ACTIVE status. Logs for this stage list
	//    the launch paths in the run-time configuration and indicate whether each
	//    is found. Access the logs by using the URL in PreSignedLogUrl.
	//
	//    * FLEET_STATE_VALIDATING -- Fleet status changed from DOWNLOADING to VALIDATING.
	//
	//    *  FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the run-time
	//    configuration failed because the executable specified in a launch path
	//    does not exist on the instance.
	//
	//    * FLEET_STATE_BUILDING -- Fleet status changed from VALIDATING to BUILDING.
	//
	//    * FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the run-time
	//    configuration failed because the executable specified in a launch path
	//    failed to run on the fleet instance.
	//
	//    * FLEET_STATE_ACTIVATING -- Fleet status changed from BUILDING to ACTIVATING.
	//
	//
	//    *  FLEET_ACTIVATION_FAILED - The fleet failed to successfully complete
	//    one of the steps in the fleet activation process. This event code indicates
	//    that the game build was successfully downloaded to a fleet instance, built,
	//    and validated, but was not able to start a server process. A possible
	//    reason for failure is that the game server is not reporting "process ready"
	//    to the Amazon GameLift service.
	//
	//    * FLEET_STATE_ACTIVE -- The fleet's status changed from ACTIVATING to
	//    ACTIVE. The fleet is now ready to host game sessions.
	//
	// VPC peering events:
	//
	//    * FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been established
	//    between the VPC for an Amazon GameLift fleet and a VPC in your AWS account.
	//
	//    * FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed.
	//    Event details and status information (see DescribeVpcPeeringConnections)
	//    provide additional detail. A common reason for peering failure is that
	//    the two VPCs have overlapping CIDR blocks of IPv4 addresses. To resolve
	//    this, change the CIDR block for the VPC in your AWS account. For more
	//    information on VPC peering failures, see http://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html
	//    (http://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html)
	//
	//    * FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully
	//    deleted.
	//
	// Spot instance events:
	//
	//    *  INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with
	//    a two-minute notification.
	//
	// Other fleet events:
	//
	//    * FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings
	//    (desired instances, minimum/maximum scaling limits). Event messaging includes
	//    the new capacity settings.
	//
	//    * FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made
	//    to the fleet's game session protection policy setting. Event messaging
	//    includes both the old and new policy setting.
	//
	//    * FLEET_DELETED -- A request to delete a fleet was initiated.
	//
	//    *  GENERIC_EVENT -- An unspecified event has occurred.
	EventCode *string `type:"string" enum:"EventCode"`

	// Unique identifier for a fleet event.
	EventId *string `min:"1" type:"string"`

	// Time stamp indicating when this event occurred. Format is a number expressed
	// in Unix time as milliseconds (for example "1469498468.057").
	EventTime *time.Time `type:"timestamp"`

	// Additional information related to the event.
	Message *string `min:"1" type:"string"`

	// Location of stored logs with additional detail that is related to the event.
	// This is useful for debugging issues. The URL is valid for 15 minutes. You
	// can also access fleet creation logs through the Amazon GameLift console.
	PreSignedLogUrl *string `min:"1" type:"string"`

	// Unique identifier for an event resource, such as a fleet ID.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetEventCode sets the EventCode field's value.
func (s *Event) SetEventCode(v string) *Event {
	s.EventCode = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *Event) SetEventId(v string) *Event {
	s.EventId = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *Event) SetEventTime(v time.Time) *Event {
	s.EventTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetPreSignedLogUrl sets the PreSignedLogUrl field's value.
func (s *Event) SetPreSignedLogUrl(v string) *Event {
	s.PreSignedLogUrl = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Event) SetResourceId(v string) *Event {
	s.ResourceId = &v
	return s
}

// General properties describing a fleet.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
type FleetAttributes struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build.
	BuildId *string `type:"string"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// Human-readable description of the fleet.
	Description *string `min:"1" type:"string"`

	// Identifier for a fleet that is unique across all regions.
	FleetArn *string `min:"1" type:"string"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Indicates whether the fleet uses on-demand or spot instances. A spot instance
	// in use may be interrupted with a two-minute notification.
	FleetType *string `type:"string" enum:"FleetType"`

	// EC2 instance type indicating the computing resources of each instance in
	// the fleet, including CPU, memory, storage, and networking capacity. See Amazon
	// EC2 Instance Types (http://aws.amazon.com/ec2/instance-types/) for detailed
	// descriptions.
	InstanceType *string `type:"string" enum:"EC2InstanceType"`

	// Location of default log files. When a server process is shut down, Amazon
	// GameLift captures and stores any log files in this location. These logs are
	// in addition to game session logs; see more on game session logs in the Amazon
	// GameLift Developer Guide (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code).
	// If no default log path for a fleet is specified, Amazon GameLift automatically
	// uploads logs that are stored on each instance at C:\game\logs (for Windows)
	// or /local/game/logs (for Linux). Use the Amazon GameLift console to access
	// stored logs.
	LogPaths []*string `type:"list"`

	// Names of metric groups that this fleet is included in. In Amazon CloudWatch,
	// you can view metrics for an individual fleet or aggregated metrics for fleets
	// that are in a fleet metric group. A fleet can be included in only one metric
	// group at a time.
	MetricGroups []*string `type:"list"`

	// Descriptive label that is associated with a fleet. Fleet names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Type of game session protection to set for all new instances started in the
	// fleet.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// Operating system of the fleet's computing resources. A fleet's operating
	// system depends on the OS specified for the build that is deployed on this
	// fleet.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// Fleet policy to limit the number of game sessions an individual player can
	// create over a span of time.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy `type:"structure"`

	// Game server launch parameters specified for fleets created before 2016-08-04
	// (or AWS SDK v. 0.12.16). Server launch parameters for fleets created after
	// this date are specified in the fleet's RuntimeConfiguration.
	ServerLaunchParameters *string `min:"1" type:"string"`

	// Path to a game server executable in the fleet's build, specified for fleets
	// created before 2016-08-04 (or AWS SDK v. 0.12.16). Server launch paths for
	// fleets created after this date are specified in the fleet's RuntimeConfiguration.
	ServerLaunchPath *string `min:"1" type:"string"`

	// Current status of the fleet.
	//
	// Possible fleet statuses include the following:
	//
	//    * NEW -- A new fleet has been defined and desired instances is set to
	//    1.
	//
	//    * DOWNLOADING/VALIDATING/BUILDING/ACTIVATING -- Amazon GameLift is setting
	//    up the new fleet, creating new instances with the game build and starting
	//    server processes.
	//
	//    * ACTIVE -- Hosts can now accept game sessions.
	//
	//    * ERROR -- An error occurred when downloading, validating, building, or
	//    activating the fleet.
	//
	//    * DELETING -- Hosts are responding to a delete fleet request.
	//
	//    * TERMINATED -- The fleet no longer exists.
	Status *string `type:"string" enum:"FleetStatus"`

	// List of fleet actions that have been suspended using StopFleetActions. This
	// includes auto-scaling.
	StoppedActions []*string `min:"1" type:"list"`

	// Time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s FleetAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetAttributes) GoString() string {
	return s.String()
}

// SetBuildId sets the BuildId field's value.
func (s *FleetAttributes) SetBuildId(v string) *FleetAttributes {
	s.BuildId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FleetAttributes) SetCreationTime(v time.Time) *FleetAttributes {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FleetAttributes) SetDescription(v string) *FleetAttributes {
	s.Description = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *FleetAttributes) SetFleetArn(v string) *FleetAttributes {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *FleetAttributes) SetFleetId(v string) *FleetAttributes {
	s.FleetId = &v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *FleetAttributes) SetFleetType(v string) *FleetAttributes {
	s.FleetType = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *FleetAttributes) SetInstanceType(v string) *FleetAttributes {
	s.InstanceType = &v
	return s
}

// SetLogPaths sets the LogPaths field's value.
func (s *FleetAttributes) SetLogPaths(v []*string) *FleetAttributes {
	s.LogPaths = v
	return s
}

// SetMetricGroups sets the MetricGroups field's value.
func (s *FleetAttributes) SetMetricGroups(v []*string) *FleetAttributes {
	s.MetricGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *FleetAttributes) SetName(v string) *FleetAttributes {
	s.Name = &v
	return s
}

// SetNewGameSessionProtectionPolicy sets the NewGameSessionProtectionPolicy field's value.
func (s *FleetAttributes) SetNewGameSessionProtectionPolicy(v string) *FleetAttributes {
	s.NewGameSessionProtectionPolicy = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *FleetAttributes) SetOperatingSystem(v string) *FleetAttributes {
	s.OperatingSystem = &v
	return s
}

// SetResourceCreationLimitPolicy sets the ResourceCreationLimitPolicy field's value.
func (s *FleetAttributes) SetResourceCreationLimitPolicy(v *ResourceCreationLimitPolicy) *FleetAttributes {
	s.ResourceCreationLimitPolicy = v
	return s
}

// SetServerLaunchParameters sets the ServerLaunchParameters field's value.
func (s *FleetAttributes) SetServerLaunchParameters(v string) *FleetAttributes {
	s.ServerLaunchParameters = &v
	return s
}

// SetServerLaunchPath sets the ServerLaunchPath field's value.
func (s *FleetAttributes) SetServerLaunchPath(v string) *FleetAttributes {
	s.ServerLaunchPath = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FleetAttributes) SetStatus(v string) *FleetAttributes {
	s.Status = &v
	return s
}

// SetStoppedActions sets the StoppedActions field's value.
func (s *FleetAttributes) SetStoppedActions(v []*string) *FleetAttributes {
	s.StoppedActions = v
	return s
}

// SetTerminationTime sets the TerminationTime field's value.
func (s *FleetAttributes) SetTerminationTime(v time.Time) *FleetAttributes {
	s.TerminationTime = &v
	return s
}

// Information about the fleet's capacity. Fleet capacity is measured in EC2
// instances. By default, new fleets have a capacity of one instance, but can
// be updated as needed. The maximum number of instances for a fleet is determined
// by the fleet's instance type.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
type FleetCapacity struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Current status of fleet capacity.
	InstanceCounts *EC2InstanceCounts `type:"structure"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	InstanceType *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation
func (s FleetCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetCapacity) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *FleetCapacity) SetFleetId(v string) *FleetCapacity {
	s.FleetId = &v
	return s
}

// SetInstanceCounts sets the InstanceCounts field's value.
func (s *FleetCapacity) SetInstanceCounts(v *EC2InstanceCounts) *FleetCapacity {
	s.InstanceCounts = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *FleetCapacity) SetInstanceType(v string) *FleetCapacity {
	s.InstanceType = &v
	return s
}

// Current status of fleet utilization, including the number of game and player
// sessions being hosted.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
type FleetUtilization struct {
	_ struct{} `type:"structure"`

	// Number of active game sessions currently being hosted on all instances in
	// the fleet.
	ActiveGameSessionCount *int64 `type:"integer"`

	// Number of server processes in an ACTIVE status currently running across all
	// instances in the fleet
	ActiveServerProcessCount *int64 `type:"integer"`

	// Number of active player sessions currently being hosted on all instances
	// in the fleet.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Maximum players allowed across all game sessions currently being hosted on
	// all instances in the fleet.
	MaximumPlayerSessionCount *int64 `type:"integer"`
}

// String returns the string representation
func (s FleetUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetUtilization) GoString() string {
	return s.String()
}

// SetActiveGameSessionCount sets the ActiveGameSessionCount field's value.
func (s *FleetUtilization) SetActiveGameSessionCount(v int64) *FleetUtilization {
	s.ActiveGameSessionCount = &v
	return s
}

// SetActiveServerProcessCount sets the ActiveServerProcessCount field's value.
func (s *FleetUtilization) SetActiveServerProcessCount(v int64) *FleetUtilization {
	s.ActiveServerProcessCount = &v
	return s
}

// SetCurrentPlayerSessionCount sets the CurrentPlayerSessionCount field's value.
func (s *FleetUtilization) SetCurrentPlayerSessionCount(v int64) *FleetUtilization {
	s.CurrentPlayerSessionCount = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *FleetUtilization) SetFleetId(v string) *FleetUtilization {
	s.FleetId = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *FleetUtilization) SetMaximumPlayerSessionCount(v int64) *FleetUtilization {
	s.MaximumPlayerSessionCount = &v
	return s
}

// Set of key-value pairs that contain information about a game session. When
// included in a game session request, these properties communicate details
// to be used when setting up the new game session, such as to specify a game
// mode, level, or map. Game properties are passed to the game server process
// when initiating a new game session; the server process uses the properties
// as appropriate. For more information, see the  Amazon GameLift Developer
// Guide (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-create).
type GameProperty struct {
	_ struct{} `type:"structure"`

	// Game property identifier.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// Game property value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GameProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GameProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GameProperty"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *GameProperty) SetKey(v string) *GameProperty {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *GameProperty) SetValue(v string) *GameProperty {
	s.Value = &v
	return s
}

// Properties describing a game session.
//
// A game session in ACTIVE status can host players. When a game session ends,
// its status is set to TERMINATED.
//
// Once the session ends, the game session object is retained for 30 days. This
// means you can reuse idempotency token values after this time. Game session
// logs are retained for 14 days.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
type GameSession struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// Unique identifier for a player. This ID is used to enforce a resource protection
	// policy (if one exists), that limits the number of game sessions a player
	// can create.
	CreatorId *string `min:"1" type:"string"`

	// Number of players currently in the game session.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// Unique identifier for a fleet that the game session is running on.
	FleetId *string `type:"string"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// You can search for active game sessions based on this custom data with SearchGameSessions.
	GameProperties []*GameProperty `type:"list"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string `min:"1" type:"string"`

	// Unique identifier for the game session. A game session ARN has the following
	// format: arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string
	// or idempotency token>.
	GameSessionId *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	IpAddress *string `type:"string"`

	// Information about the matchmaking process that was used to create the game
	// session. It is in JSON syntax, formatted as a string. In addition the matchmaking
	// configuration used, it contains data on all players assigned to the match,
	// including player attributes and team assignments. For more details on matchmaker
	// data, see Match Data (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data).
	// Matchmaker data is useful when requesting match backfills, and is updated
	// whenever new players are added during a successful backfill (see StartMatchBackfill).
	MatchmakerData *string `min:"1" type:"string"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	Name *string `min:"1" type:"string"`

	// Indicates whether or not the game session is accepting new players.
	PlayerSessionCreationPolicy *string `type:"string" enum:"PlayerSessionCreationPolicy"`

	// Port number for the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	Port *int64 `min:"1" type:"integer"`

	// Current status of the game session. A game session must have an ACTIVE status
	// to have player sessions.
	Status *string `type:"string" enum:"GameSessionStatus"`

	// Provides additional information about game session status. INTERRUPTED indicates
	// that the game session was hosted on a spot instance that was reclaimed, causing
	// the active game session to be terminated.
	StatusReason *string `type:"string" enum:"GameSessionStatusReason"`

	// Time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s GameSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSession) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GameSession) SetCreationTime(v time.Time) *GameSession {
	s.CreationTime = &v
	return s
}

// SetCreatorId sets the CreatorId field's value.
func (s *GameSession) SetCreatorId(v string) *GameSession {
	s.CreatorId = &v
	return s
}

// SetCurrentPlayerSessionCount sets the CurrentPlayerSessionCount field's value.
func (s *GameSession) SetCurrentPlayerSessionCount(v int64) *GameSession {
	s.CurrentPlayerSessionCount = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GameSession) SetFleetId(v string) *GameSession {
	s.FleetId = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *GameSession) SetGameProperties(v []*GameProperty) *GameSession {
	s.GameProperties = v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *GameSession) SetGameSessionData(v string) *GameSession {
	s.GameSessionData = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *GameSession) SetGameSessionId(v string) *GameSession {
	s.GameSessionId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GameSession) SetIpAddress(v string) *GameSession {
	s.IpAddress = &v
	return s
}

// SetMatchmakerData sets the MatchmakerData field's value.
func (s *GameSession) SetMatchmakerData(v string) *GameSession {
	s.MatchmakerData = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *GameSession) SetMaximumPlayerSessionCount(v int64) *GameSession {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *GameSession) SetName(v string) *GameSession {
	s.Name = &v
	return s
}

// SetPlayerSessionCreationPolicy sets the PlayerSessionCreationPolicy field's value.
func (s *GameSession) SetPlayerSessionCreationPolicy(v string) *GameSession {
	s.PlayerSessionCreationPolicy = &v
	return s
}

// SetPort sets the Port field's value.
func (s *GameSession) SetPort(v int64) *GameSession {
	s.Port = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GameSession) SetStatus(v string) *GameSession {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GameSession) SetStatusReason(v string) *GameSession {
	s.StatusReason = &v
	return s
}

// SetTerminationTime sets the TerminationTime field's value.
func (s *GameSession) SetTerminationTime(v time.Time) *GameSession {
	s.TerminationTime = &v
	return s
}

// Connection information for the new game session that is created with matchmaking.
// (with StartMatchmaking). Once a match is set, the FlexMatch engine places
// the match and creates a new game session for it. This information, including
// the game session endpoint and player sessions for each player in the original
// matchmaking request, is added to the MatchmakingTicket, which can be retrieved
// by calling DescribeMatchmaking.
type GameSessionConnectionInfo struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session and uniquely identifies it.
	GameSessionArn *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	IpAddress *string `type:"string"`

	// Collection of player session IDs, one for each player ID that was included
	// in the original matchmaking request.
	MatchedPlayerSessions []*MatchedPlayerSession `type:"list"`

	// Port number for the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	Port *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GameSessionConnectionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionConnectionInfo) GoString() string {
	return s.String()
}

// SetGameSessionArn sets the GameSessionArn field's value.
func (s *GameSessionConnectionInfo) SetGameSessionArn(v string) *GameSessionConnectionInfo {
	s.GameSessionArn = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GameSessionConnectionInfo) SetIpAddress(v string) *GameSessionConnectionInfo {
	s.IpAddress = &v
	return s
}

// SetMatchedPlayerSessions sets the MatchedPlayerSessions field's value.
func (s *GameSessionConnectionInfo) SetMatchedPlayerSessions(v []*MatchedPlayerSession) *GameSessionConnectionInfo {
	s.MatchedPlayerSessions = v
	return s
}

// SetPort sets the Port field's value.
func (s *GameSessionConnectionInfo) SetPort(v int64) *GameSessionConnectionInfo {
	s.Port = &v
	return s
}

// A game session's properties plus the protection policy currently in force.
type GameSessionDetail struct {
	_ struct{} `type:"structure"`

	// Object that describes a game session.
	GameSession *GameSession `type:"structure"`

	// Current status of protection for the game session.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	ProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`
}

// String returns the string representation
func (s GameSessionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionDetail) GoString() string {
	return s.String()
}

// SetGameSession sets the GameSession field's value.
func (s *GameSessionDetail) SetGameSession(v *GameSession) *GameSessionDetail {
	s.GameSession = v
	return s
}

// SetProtectionPolicy sets the ProtectionPolicy field's value.
func (s *GameSessionDetail) SetProtectionPolicy(v string) *GameSessionDetail {
	s.ProtectionPolicy = &v
	return s
}

// Object that describes a StartGameSessionPlacement request. This object includes
// the full details of the original request plus the current status and start/end
// time stamps.
//
// Game session placement-related operations include:
//
//    * StartGameSessionPlacement
//
//    * DescribeGameSessionPlacement
//
//    * StopGameSessionPlacement
type GameSessionPlacement struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this request was completed, canceled, or timed
	// out.
	EndTime *time.Time `type:"timestamp"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameProperties []*GameProperty `type:"list"`

	// Identifier for the game session created by this placement request. This value
	// is set once the new game session is placed (placement status is FULFILLED).
	// This identifier is unique across all regions. You can use this value as a
	// GameSessionId value as needed.
	GameSessionArn *string `min:"1" type:"string"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string `min:"1" type:"string"`

	// Unique identifier for the game session. This value is set once the new game
	// session is placed (placement status is FULFILLED).
	GameSessionId *string `min:"1" type:"string"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	GameSessionName *string `min:"1" type:"string"`

	// Descriptive label that is associated with game session queue. Queue names
	// must be unique within each region.
	GameSessionQueueName *string `min:"1" type:"string"`

	// Name of the region where the game session created by this placement request
	// is running. This value is set once the new game session is placed (placement
	// status is FULFILLED).
	GameSessionRegion *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number. This value is set once
	// the new game session is placed (placement status is FULFILLED).
	IpAddress *string `type:"string"`

	// Information on the matchmaking process for this game. Data is in JSON syntax,
	// formatted as a string. It identifies the matchmaking configuration used to
	// create the match, and contains data on all players assigned to the match,
	// including player attributes and team assignments. For more details on matchmaker
	// data, see Match Data (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data).
	MatchmakerData *string `min:"1" type:"string"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Collection of information on player sessions created in response to the game
	// session placement request. These player sessions are created only once a
	// new game session is successfully placed (placement status is FULFILLED).
	// This information includes the player ID (as provided in the placement request)
	// and the corresponding player session ID. Retrieve full player sessions by
	// calling DescribePlayerSessions with the player session ID.
	PlacedPlayerSessions []*PlacedPlayerSession `type:"list"`

	// Unique identifier for a game session placement.
	PlacementId *string `min:"1" type:"string"`

	// Set of values, expressed in milliseconds, indicating the amount of latency
	// that a player experiences when connected to AWS regions.
	PlayerLatencies []*PlayerLatency `type:"list"`

	// Port number for the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number. This value is set once
	// the new game session is placed (placement status is FULFILLED).
	Port *int64 `min:"1" type:"integer"`

	// Time stamp indicating when this request was placed in the queue. Format is
	// a number expressed in Unix time as milliseconds (for example "1469498468.057").
	StartTime *time.Time `type:"timestamp"`

	// Current status of the game session placement request.
	//
	//    * PENDING -- The placement request is currently in the queue waiting to
	//    be processed.
	//
	//    * FULFILLED -- A new game session and player sessions (if requested) have
	//    been successfully created. Values for GameSessionArn and GameSessionRegion
	//    are available.
	//
	//    * CANCELLED -- The placement request was canceled with a call to StopGameSessionPlacement.
	//
	//    * TIMED_OUT -- A new game session was not successfully created before
	//    the time limit expired. You can resubmit the placement request as needed.
	Status *string `type:"string" enum:"GameSessionPlacementState"`
}

// String returns the string representation
func (s GameSessionPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionPlacement) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GameSessionPlacement) SetEndTime(v time.Time) *GameSessionPlacement {
	s.EndTime = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *GameSessionPlacement) SetGameProperties(v []*GameProperty) *GameSessionPlacement {
	s.GameProperties = v
	return s
}

// SetGameSessionArn sets the GameSessionArn field's value.
func (s *GameSessionPlacement) SetGameSessionArn(v string) *GameSessionPlacement {
	s.GameSessionArn = &v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *GameSessionPlacement) SetGameSessionData(v string) *GameSessionPlacement {
	s.GameSessionData = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *GameSessionPlacement) SetGameSessionId(v string) *GameSessionPlacement {
	s.GameSessionId = &v
	return s
}

// SetGameSessionName sets the GameSessionName field's value.
func (s *GameSessionPlacement) SetGameSessionName(v string) *GameSessionPlacement {
	s.GameSessionName = &v
	return s
}

// SetGameSessionQueueName sets the GameSessionQueueName field's value.
func (s *GameSessionPlacement) SetGameSessionQueueName(v string) *GameSessionPlacement {
	s.GameSessionQueueName = &v
	return s
}

// SetGameSessionRegion sets the GameSessionRegion field's value.
func (s *GameSessionPlacement) SetGameSessionRegion(v string) *GameSessionPlacement {
	s.GameSessionRegion = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GameSessionPlacement) SetIpAddress(v string) *GameSessionPlacement {
	s.IpAddress = &v
	return s
}

// SetMatchmakerData sets the MatchmakerData field's value.
func (s *GameSessionPlacement) SetMatchmakerData(v string) *GameSessionPlacement {
	s.MatchmakerData = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *GameSessionPlacement) SetMaximumPlayerSessionCount(v int64) *GameSessionPlacement {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetPlacedPlayerSessions sets the PlacedPlayerSessions field's value.
func (s *GameSessionPlacement) SetPlacedPlayerSessions(v []*PlacedPlayerSession) *GameSessionPlacement {
	s.PlacedPlayerSessions = v
	return s
}

// SetPlacementId sets the PlacementId field's value.
func (s *GameSessionPlacement) SetPlacementId(v string) *GameSessionPlacement {
	s.PlacementId = &v
	return s
}

// SetPlayerLatencies sets the PlayerLatencies field's value.
func (s *GameSessionPlacement) SetPlayerLatencies(v []*PlayerLatency) *GameSessionPlacement {
	s.PlayerLatencies = v
	return s
}

// SetPort sets the Port field's value.
func (s *GameSessionPlacement) SetPort(v int64) *GameSessionPlacement {
	s.Port = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GameSessionPlacement) SetStartTime(v time.Time) *GameSessionPlacement {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GameSessionPlacement) SetStatus(v string) *GameSessionPlacement {
	s.Status = &v
	return s
}

// Configuration of a queue that is used to process game session placement requests.
// The queue configuration identifies several game features:
//
//    * The destinations where a new game session can potentially be hosted.
//    Amazon GameLift tries these destinations in an order based on either the
//    queue's default order or player latency information, if provided in a
//    placement request. With latency information, Amazon GameLift can place
//    game sessions where the majority of players are reporting the lowest possible
//    latency.
//
//    * The length of time that placement requests can wait in the queue before
//    timing out.
//
//    * A set of optional latency policies that protect individual players from
//    high latencies, preventing game sessions from being placed where any individual
//    player is reporting latency higher than a policy's maximum.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
type GameSessionQueue struct {
	_ struct{} `type:"structure"`

	// List of fleets that can be used to fulfill game session placement requests
	// in the queue. Fleets are identified by either a fleet ARN or a fleet alias
	// ARN. Destinations are listed in default preference order.
	Destinations []*GameSessionQueueDestination `type:"list"`

	// Amazon Resource Name (ARN (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session queue and uniquely identifies it. Format
	// is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	GameSessionQueueArn *string `min:"1" type:"string"`

	// Descriptive label that is associated with game session queue. Queue names
	// must be unique within each region.
	Name *string `min:"1" type:"string"`

	// Collection of latency policies to apply when processing game sessions placement
	// requests with player latency information. Multiple policies are evaluated
	// in order of the maximum latency value, starting with the lowest latency values.
	// With just one policy, it is enforced at the start of the game session placement
	// for the duration period. With multiple policies, each policy is enforced
	// consecutively for its duration period. For example, a queue might enforce
	// a 60-second policy followed by a 120-second policy, and then no policy for
	// the remainder of the placement.
	PlayerLatencyPolicies []*PlayerLatencyPolicy `type:"list"`

	// Maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s GameSessionQueue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionQueue) GoString() string {
	return s.String()
}

// SetDestinations sets the Destinations field's value.
func (s *GameSessionQueue) SetDestinations(v []*GameSessionQueueDestination) *GameSessionQueue {
	s.Destinations = v
	return s
}

// SetGameSessionQueueArn sets the GameSessionQueueArn field's value.
func (s *GameSessionQueue) SetGameSessionQueueArn(v string) *GameSessionQueue {
	s.GameSessionQueueArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GameSessionQueue) SetName(v string) *GameSessionQueue {
	s.Name = &v
	return s
}

// SetPlayerLatencyPolicies sets the PlayerLatencyPolicies field's value.
func (s *GameSessionQueue) SetPlayerLatencyPolicies(v []*PlayerLatencyPolicy) *GameSessionQueue {
	s.PlayerLatencyPolicies = v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *GameSessionQueue) SetTimeoutInSeconds(v int64) *GameSessionQueue {
	s.TimeoutInSeconds = &v
	return s
}

// Fleet designated in a game session queue. Requests for new game sessions
// in the queue are fulfilled by starting a new game session on any destination
// configured for a queue.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
type GameSessionQueueDestination struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) assigned to fleet or fleet alias. ARNs, which
	// include a fleet ID or alias ID and a region name, provide a unique identifier
	// across all regions.
	DestinationArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GameSessionQueueDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionQueueDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GameSessionQueueDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GameSessionQueueDestination"}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *GameSessionQueueDestination) SetDestinationArn(v string) *GameSessionQueueDestination {
	s.DestinationArn = &v
	return s
}

// Represents the input for a request action.
type GetGameSessionLogUrlInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to get logs for.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGameSessionLogUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGameSessionLogUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGameSessionLogUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGameSessionLogUrlInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *GetGameSessionLogUrlInput) SetGameSessionId(v string) *GetGameSessionLogUrlInput {
	s.GameSessionId = &v
	return s
}

// Represents the returned data in response to a request action.
type GetGameSessionLogUrlOutput struct {
	_ struct{} `type:"structure"`

	// Location of the requested game session logs, available for download.
	PreSignedUrl *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetGameSessionLogUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGameSessionLogUrlOutput) GoString() string {
	return s.String()
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *GetGameSessionLogUrlOutput) SetPreSignedUrl(v string) *GetGameSessionLogUrlOutput {
	s.PreSignedUrl = &v
	return s
}

// Represents the input for a request action.
type GetInstanceAccessInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that contains the instance you want access
	// to. The fleet can be in any of the following statuses: ACTIVATING, ACTIVE,
	// or ERROR. Fleets with an ERROR status may be accessible for a short time
	// before they are deleted.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Unique identifier for an instance you want to get access to. You can access
	// an instance in any status.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceAccessInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *GetInstanceAccessInput) SetFleetId(v string) *GetInstanceAccessInput {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetInstanceAccessInput) SetInstanceId(v string) *GetInstanceAccessInput {
	s.InstanceId = &v
	return s
}

// Represents the returned data in response to a request action.
type GetInstanceAccessOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains connection information for a fleet instance, including
	// IP address and access credentials.
	InstanceAccess *InstanceAccess `type:"structure"`
}

// String returns the string representation
func (s GetInstanceAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceAccessOutput) GoString() string {
	return s.String()
}

// SetInstanceAccess sets the InstanceAccess field's value.
func (s *GetInstanceAccessOutput) SetInstanceAccess(v *InstanceAccess) *GetInstanceAccessOutput {
	s.InstanceAccess = v
	return s
}

// Properties that describe an instance of a virtual computing resource that
// hosts one or more game servers. A fleet may contain zero or more instances.
type Instance struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// Unique identifier for a fleet that the instance is in.
	FleetId *string `type:"string"`

	// Unique identifier for an instance.
	InstanceId *string `type:"string"`

	// IP address assigned to the instance.
	IpAddress *string `type:"string"`

	// Operating system that is running on this instance.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// Current status of the instance. Possible statuses include the following:
	//
	//    * PENDING -- The instance is in the process of being created and launching
	//    server processes as defined in the fleet's run-time configuration.
	//
	//    * ACTIVE -- The instance has been successfully created and at least one
	//    server process has successfully launched and reported back to Amazon GameLift
	//    that it is ready to host a game session. The instance is now considered
	//    ready to host game sessions.
	//
	//    * TERMINATING -- The instance is in the process of shutting down. This
	//    may happen to reduce capacity during a scaling down event or to recycle
	//    resources in the event of a problem.
	Status *string `type:"string" enum:"InstanceStatus"`

	// EC2 instance type that defines the computing resources of this instance.
	Type *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Instance) SetCreationTime(v time.Time) *Instance {
	s.CreationTime = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *Instance) SetFleetId(v string) *Instance {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Instance) SetInstanceId(v string) *Instance {
	s.InstanceId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Instance) SetIpAddress(v string) *Instance {
	s.IpAddress = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *Instance) SetOperatingSystem(v string) *Instance {
	s.OperatingSystem = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Instance) SetStatus(v string) *Instance {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Instance) SetType(v string) *Instance {
	s.Type = &v
	return s
}

// Information required to remotely connect to a fleet instance. Access is requested
// by calling GetInstanceAccess.
type InstanceAccess struct {
	_ struct{} `type:"structure"`

	// Credentials required to access the instance.
	Credentials *InstanceCredentials `type:"structure"`

	// Unique identifier for a fleet containing the instance being accessed.
	FleetId *string `type:"string"`

	// Unique identifier for an instance being accessed.
	InstanceId *string `type:"string"`

	// IP address assigned to the instance.
	IpAddress *string `type:"string"`

	// Operating system that is running on the instance.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`
}

// String returns the string representation
func (s InstanceAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAccess) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *InstanceAccess) SetCredentials(v *InstanceCredentials) *InstanceAccess {
	s.Credentials = v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *InstanceAccess) SetFleetId(v string) *InstanceAccess {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceAccess) SetInstanceId(v string) *InstanceAccess {
	s.InstanceId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *InstanceAccess) SetIpAddress(v string) *InstanceAccess {
	s.IpAddress = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *InstanceAccess) SetOperatingSystem(v string) *InstanceAccess {
	s.OperatingSystem = &v
	return s
}

// Set of credentials required to remotely access a fleet instance. Access credentials
// are requested by calling GetInstanceAccess and returned in an InstanceAccess
// object.
type InstanceCredentials struct {
	_ struct{} `type:"structure"`

	// Secret string. For Windows instances, the secret is a password for use with
	// Windows Remote Desktop. For Linux instances, it is a private key (which must
	// be saved as a .pem file) for use with SSH.
	Secret *string `min:"1" type:"string"`

	// User login string.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InstanceCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceCredentials) GoString() string {
	return s.String()
}

// SetSecret sets the Secret field's value.
func (s *InstanceCredentials) SetSecret(v string) *InstanceCredentials {
	s.Secret = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *InstanceCredentials) SetUserName(v string) *InstanceCredentials {
	s.UserName = &v
	return s
}

// A range of IP addresses and port settings that allow inbound traffic to connect
// to server processes on Amazon GameLift. Each game session hosted on a fleet
// is assigned a unique combination of IP address and port number, which must
// fall into the fleet's allowed ranges. This combination is included in the
// GameSession object.
type IpPermission struct {
	_ struct{} `type:"structure"`

	// Starting value for a range of allowed port numbers.
	//
	// FromPort is a required field
	FromPort *int64 `min:"1" type:"integer" required:"true"`

	// Range of allowed IP addresses. This value must be expressed in CIDR notation.
	// Example: "000.000.000.000/[subnet mask]" or optionally the shortened version
	// "0.0.0.0/[subnet mask]".
	//
	// IpRange is a required field
	IpRange *string `type:"string" required:"true"`

	// Network communication protocol used by the fleet.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true" enum:"IpProtocol"`

	// Ending value for a range of allowed port numbers. Port numbers are end-inclusive.
	// This value must be higher than FromPort.
	//
	// ToPort is a required field
	ToPort *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s IpPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpPermission) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpPermission) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpPermission"}
	if s.FromPort == nil {
		invalidParams.Add(request.NewErrParamRequired("FromPort"))
	}
	if s.FromPort != nil && *s.FromPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FromPort", 1))
	}
	if s.IpRange == nil {
		invalidParams.Add(request.NewErrParamRequired("IpRange"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.ToPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ToPort"))
	}
	if s.ToPort != nil && *s.ToPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ToPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromPort sets the FromPort field's value.
func (s *IpPermission) SetFromPort(v int64) *IpPermission {
	s.FromPort = &v
	return s
}

// SetIpRange sets the IpRange field's value.
func (s *IpPermission) SetIpRange(v string) *IpPermission {
	s.IpRange = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *IpPermission) SetProtocol(v string) *IpPermission {
	s.Protocol = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *IpPermission) SetToPort(v int64) *IpPermission {
	s.ToPort = &v
	return s
}

// Represents the input for a request action.
type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Descriptive label that is associated with an alias. Alias names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Type of routing to filter results on. Use this parameter to retrieve only
	// aliases of a certain type. To retrieve all aliases, leave this parameter
	// empty.
	//
	// Possible routing types include the following:
	//
	//    * SIMPLE -- The alias resolves to one specific fleet. Use this type when
	//    routing to active fleets.
	//
	//    * TERMINAL -- The alias does not resolve to a fleet but instead can be
	//    used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException
	//    with the RoutingStrategy message embedded.
	RoutingStrategyType *string `type:"string" enum:"RoutingStrategyType"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListAliasesInput) SetLimit(v int64) *ListAliasesInput {
	s.Limit = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListAliasesInput) SetName(v string) *ListAliasesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesInput) SetNextToken(v string) *ListAliasesInput {
	s.NextToken = &v
	return s
}

// SetRoutingStrategyType sets the RoutingStrategyType field's value.
func (s *ListAliasesInput) SetRoutingStrategyType(v string) *ListAliasesInput {
	s.RoutingStrategyType = &v
	return s
}

// Represents the returned data in response to a request action.
type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of alias records that match the list request.
	Aliases []*Alias `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*Alias) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesOutput) SetNextToken(v string) *ListAliasesOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type ListBuildsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Build status to filter results by. To retrieve all builds, leave this parameter
	// empty.
	//
	// Possible build statuses include the following:
	//
	//    * INITIALIZED -- A new build has been defined, but no files have been
	//    uploaded. You cannot create fleets for builds that are in this status.
	//    When a build is successfully created, the build status is set to this
	//    value.
	//
	//    * READY -- The game build has been successfully uploaded. You can now
	//    create new fleets for this build.
	//
	//    * FAILED -- The game build upload failed. You cannot create new fleets
	//    for this build.
	Status *string `type:"string" enum:"BuildStatus"`
}

// String returns the string representation
func (s ListBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBuildsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBuildsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListBuildsInput) SetLimit(v int64) *ListBuildsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsInput) SetNextToken(v string) *ListBuildsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListBuildsInput) SetStatus(v string) *ListBuildsInput {
	s.Status = &v
	return s
}

// Represents the returned data in response to a request action.
type ListBuildsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of build records that match the request.
	Builds []*Build `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsOutput) GoString() string {
	return s.String()
}

// SetBuilds sets the Builds field's value.
func (s *ListBuildsOutput) SetBuilds(v []*Build) *ListBuildsOutput {
	s.Builds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsOutput) SetNextToken(v string) *ListBuildsOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
type ListFleetsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to return fleets for. Use this parameter to
	// return only fleets using the specified build. To retrieve all fleets, leave
	// this parameter empty.
	BuildId *string `type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFleetsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *ListFleetsInput) SetBuildId(v string) *ListFleetsInput {
	s.BuildId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListFleetsInput) SetLimit(v int64) *ListFleetsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsInput) SetNextToken(v string) *ListFleetsInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
type ListFleetsOutput struct {
	_ struct{} `type:"structure"`

	// Set of fleet IDs matching the list request. You can retrieve additional information
	// about all returned fleets by passing this result set to a call to DescribeFleetAttributes,
	// DescribeFleetCapacity, or DescribeFleetUtilization.
	FleetIds []*string `min:"1" type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsOutput) GoString() string {
	return s.String()
}

// SetFleetIds sets the FleetIds field's value.
func (s *ListFleetsOutput) SetFleetIds(v []*string) *ListFleetsOutput {
	s.FleetIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsOutput) SetNextToken(v string) *ListFleetsOutput {
	s.NextToken = &v
	return s
}

// Represents a new player session that is created as a result of a successful
// FlexMatch match. A successful match automatically creates new player sessions
// for every player ID in the original matchmaking request.
//
// When players connect to the match's game session, they must include both
// player ID and player session ID in order to claim their assigned player slot.
type MatchedPlayerSession struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a player
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session
	PlayerSessionId *string `type:"string"`
}

// String returns the string representation
func (s MatchedPlayerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MatchedPlayerSession) GoString() string {
	return s.String()
}

// SetPlayerId sets the PlayerId field's value.
func (s *MatchedPlayerSession) SetPlayerId(v string) *MatchedPlayerSession {
	s.PlayerId = &v
	return s
}

// SetPlayerSessionId sets the PlayerSessionId field's value.
func (s *MatchedPlayerSession) SetPlayerSessionId(v string) *MatchedPlayerSession {
	s.PlayerSessionId = &v
	return s
}

// Guidelines for use with FlexMatch to match players into games. All matchmaking
// requests must specify a matchmaking configuration.
type MatchmakingConfiguration struct {
	_ struct{} `type:"structure"`

	// Flag that determines whether or not a match that was created with this configuration
	// must be accepted by the matched players. To require acceptance, set to TRUE.
	AcceptanceRequired *bool `type:"boolean"`

	// Length of time (in seconds) to wait for players to accept a proposed match.
	// If any player rejects the match or fails to accept before the timeout, the
	// ticket continues to look for an acceptable match.
	AcceptanceTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Number of player slots in a match to keep open for future players. For example,
	// if the configuration's rule set specifies a match for a single 12-person
	// team, and the additional player count is set to 2, only 10 players are selected
	// for the match.
	AdditionalPlayerCount *int64 `type:"integer"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// Information to attached to all events related to the matchmaking configuration.
	CustomEventData *string `type:"string"`

	// Descriptive label that is associated with matchmaking configuration.
	Description *string `min:"1" type:"string"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match.
	GameProperties []*GameProperty `type:"list"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match.
	GameSessionData *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session queue and uniquely identifies it. Format
	// is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	// These queues are used when placing game sessions for matches that are created
	// with this matchmaking configuration. Queues can be located in any region.
	GameSessionQueueArns []*string `type:"list"`

	// Unique identifier for a matchmaking configuration. This name is used to identify
	// the configuration associated with a matchmaking request or ticket.
	Name *string `min:"1" type:"string"`

	// SNS topic ARN that is set up to receive matchmaking notifications.
	NotificationTarget *string `type:"string"`

	// Maximum duration, in seconds, that a matchmaking ticket can remain in process
	// before timing out. Requests that time out can be resubmitted as needed.
	RequestTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Unique identifier for a matchmaking rule set to use with this configuration.
	// A matchmaking configuration can only use rule sets that are defined in the
	// same region.
	RuleSetName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MatchmakingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MatchmakingConfiguration) GoString() string {
	return s.String()
}

// SetAcceptanceRequired sets the AcceptanceRequired field's value.
func (s *MatchmakingConfiguration) SetAcceptanceRequired(v bool) *MatchmakingConfiguration {
	s.AcceptanceRequired = &v
	return s
}

// SetAcceptanceTimeoutSeconds sets the AcceptanceTimeoutSeconds field's value.
func (s *MatchmakingConfiguration) SetAcceptanceTimeoutSeconds(v int64) *MatchmakingConfiguration {
	s.AcceptanceTimeoutSeconds = &v
	return s
}

// SetAdditionalPlayerCount sets the AdditionalPlayerCount field's value.
func (s *MatchmakingConfiguration) SetAdditionalPlayerCount(v int64) *MatchmakingConfiguration {
	s.AdditionalPlayerCount = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *MatchmakingConfiguration) SetCreationTime(v time.Time) *MatchmakingConfiguration {
	s.CreationTime = &v
	return s
}

// SetCustomEventData sets the CustomEventData field's value.
func (s *MatchmakingConfiguration) SetCustomEventData(v string) *MatchmakingConfiguration {
	s.CustomEventData = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *MatchmakingConfiguration) SetDescription(v string) *MatchmakingConfiguration {
	s.Description = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *MatchmakingConfiguration) SetGameProperties(v []*GameProperty) *MatchmakingConfiguration {
	s.GameProperties = v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *MatchmakingConfiguration) SetGameSessionData(v string) *MatchmakingConfiguration {
	s.GameSessionData = &v
	return s
}

// SetGameSessionQueueArns sets the GameSessionQueueArns field's value.
func (s *MatchmakingConfiguration) SetGameSessionQueueArns(v []*string) *MatchmakingConfiguration {
	s.GameSessionQueueArns = v
	return s
}

// SetName sets the Name field's value.
func (s *MatchmakingConfiguration) SetName(v string) *MatchmakingConfiguration {
	s.Name = &v
	return s
}

// SetNotificationTarget sets the NotificationTarget field's value.
func (s *MatchmakingConfiguration) SetNotificationTarget(v string) *MatchmakingConfiguration {
	s.NotificationTarget = &v
	return s
}

// SetRequestTimeoutSeconds sets the RequestTimeoutSeconds field's value.
func (s *MatchmakingConfiguration) SetRequestTimeoutSeconds(v int64) *MatchmakingConfiguration {
	s.RequestTimeoutSeconds = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *MatchmakingConfiguration) SetRuleSetName(v string) *MatchmakingConfiguration {
	s.RuleSetName = &v
	return s
}

// Set of rule statements, used with FlexMatch, that determine how to build
// a certain kind of player match. Each rule set describes a type of group to
// be created and defines the parameters for acceptable player matches. Rule
// sets are used in MatchmakingConfiguration objects.
//
// A rule set may define the following elements for a match. For detailed information
// and examples showing how to construct a rule set, see Build a FlexMatch Rule
// Set (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-rulesets.html).
//
//    * Teams -- Required. A rule set must define one or multiple teams for
//    the match and set minimum and maximum team sizes. For example, a rule
//    set might describe a 4x4 match that requires all eight slots to be filled.
//
//
//    * Player attributes -- Optional. These attributes specify a set of player
//    characteristics to evaluate when looking for a match. Matchmaking requests
//    that use a rule set with player attributes must provide the corresponding
//    attribute values. For example, an attribute might specify a player's skill
//    or level.
//
//    * Rules -- Optional. Rules define how to evaluate potential players for
//    a match based on player attributes. A rule might specify minimum requirements
//    for individual players, teams, or entire matches. For example, a rule
//    might require each player to meet a certain skill level, each team to
//    have at least one player in a certain role, or the match to have a minimum
//    average skill level. or may describe an entire group--such as all teams
//    must be evenly matched or have at least one player in a certain role.
//
//
//    * Expansions -- Optional. Expansions allow you to relax the rules after
//    a period of time when no acceptable matches are found. This feature lets
//    you balance getting players into games in a reasonable amount of time
//    instead of making them wait indefinitely for the best possible match.
//    For example, you might use an expansion to increase the maximum skill
//    variance between players after 30 seconds.
type MatchmakingRuleSet struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// Collection of matchmaking rules, formatted as a JSON string. (Note that comments14
	// are not allowed in JSON, but most elements support a description field.)
	//
	// RuleSetBody is a required field
	RuleSetBody *string `min:"1" type:"string" required:"true"`

	// Unique identifier for a matchmaking rule set
	RuleSetName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MatchmakingRuleSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MatchmakingRuleSet) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *MatchmakingRuleSet) SetCreationTime(v time.Time) *MatchmakingRuleSet {
	s.CreationTime = &v
	return s
}

// SetRuleSetBody sets the RuleSetBody field's value.
func (s *MatchmakingRuleSet) SetRuleSetBody(v string) *MatchmakingRuleSet {
	s.RuleSetBody = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *MatchmakingRuleSet) SetRuleSetName(v string) *MatchmakingRuleSet {
	s.RuleSetName = &v
	return s
}

// Ticket generated to track the progress of a matchmaking request. Each ticket
// is uniquely identified by a ticket ID, supplied by the requester, when creating
// a matchmaking request with StartMatchmaking. Tickets can be retrieved by
// calling DescribeMatchmaking with the ticket ID.
type MatchmakingTicket struct {
	_ struct{} `type:"structure"`

	// Name of the MatchmakingConfiguration that is used with this ticket. Matchmaking
	// configurations determine how players are grouped into a match and how a new
	// game session is created for the match.
	ConfigurationName *string `min:"1" type:"string"`

	// Time stamp indicating when this matchmaking request stopped being processed
	// due to success, failure, or cancellation. Format is a number expressed in
	// Unix time as milliseconds (for example "1469498468.057").
	EndTime *time.Time `type:"timestamp"`

	// Average amount of time (in seconds) that players are currently waiting for
	// a match. If there is not enough recent data, this property may be empty.
	EstimatedWaitTime *int64 `type:"integer"`

	// Identifier and connection information of the game session created for the
	// match. This information is added to the ticket only after the matchmaking
	// request has been successfully completed.
	GameSessionConnectionInfo *GameSessionConnectionInfo `type:"structure"`

	// A set of Player objects, each representing a player to find matches for.
	// Players are identified by a unique player ID and may include latency data
	// for use during matchmaking. If the ticket is in status COMPLETED, the Player
	// objects include the team the players were assigned to in the resulting match.
	Players []*Player `type:"list"`

	// Time stamp indicating when this matchmaking request was received. Format
	// is a number expressed in Unix time as milliseconds (for example "1469498468.057").
	StartTime *time.Time `type:"timestamp"`

	// Current status of the matchmaking request.
	//
	//    * QUEUED -- The matchmaking request has been received and is currently
	//    waiting to be processed.
	//
	//    * SEARCHING -- The matchmaking request is currently being processed.
	//
	//    * REQUIRES_ACCEPTANCE -- A match has been proposed and the players must
	//    accept the match (see AcceptMatch). This status is used only with requests
	//    that use a matchmaking configuration with a player acceptance requirement.
	//
	//    * PLACING -- The FlexMatch engine has matched players and is in the process
	//    of placing a new game session for the match.
	//
	//    * COMPLETED -- Players have been matched and a game session is ready to
	//    host the players. A ticket in this state contains the necessary connection
	//    information for players.
	//
	//    * FAILED -- The matchmaking request was not completed. Tickets with players
	//    who fail to accept a proposed match are placed in FAILED status.
	//
	//    * CANCELLED -- The matchmaking request was canceled with a call to StopMatchmaking.
	//
	//    * TIMED_OUT -- The matchmaking request was not successful within the duration
	//    specified in the matchmaking configuration.
	//
	// Matchmaking requests that fail to successfully complete (statuses FAILED,
	// CANCELLED, TIMED_OUT) can be resubmitted as new requests with new ticket
	// IDs.
	Status *string `type:"string" enum:"MatchmakingConfigurationStatus"`

	// Additional information about the current status.
	StatusMessage *string `type:"string"`

	// Code to explain the current status. For example, a status reason may indicate
	// when a ticket has returned to SEARCHING status after a proposed match fails
	// to receive player acceptances.
	StatusReason *string `type:"string"`

	// Unique identifier for a matchmaking ticket.
	TicketId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MatchmakingTicket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MatchmakingTicket) GoString() string {
	return s.String()
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *MatchmakingTicket) SetConfigurationName(v string) *MatchmakingTicket {
	s.ConfigurationName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *MatchmakingTicket) SetEndTime(v time.Time) *MatchmakingTicket {
	s.EndTime = &v
	return s
}

// SetEstimatedWaitTime sets the EstimatedWaitTime field's value.
func (s *MatchmakingTicket) SetEstimatedWaitTime(v int64) *MatchmakingTicket {
	s.EstimatedWaitTime = &v
	return s
}

// SetGameSessionConnectionInfo sets the GameSessionConnectionInfo field's value.
func (s *MatchmakingTicket) SetGameSessionConnectionInfo(v *GameSessionConnectionInfo) *MatchmakingTicket {
	s.GameSessionConnectionInfo = v
	return s
}

// SetPlayers sets the Players field's value.
func (s *MatchmakingTicket) SetPlayers(v []*Player) *MatchmakingTicket {
	s.Players = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MatchmakingTicket) SetStartTime(v time.Time) *MatchmakingTicket {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MatchmakingTicket) SetStatus(v string) *MatchmakingTicket {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *MatchmakingTicket) SetStatusMessage(v string) *MatchmakingTicket {
	s.StatusMessage = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *MatchmakingTicket) SetStatusReason(v string) *MatchmakingTicket {
	s.StatusReason = &v
	return s
}

// SetTicketId sets the TicketId field's value.
func (s *MatchmakingTicket) SetTicketId(v string) *MatchmakingTicket {
	s.TicketId = &v
	return s
}

// Information about a player session that was created as part of a StartGameSessionPlacement
// request. This object contains only the player ID and player session ID. To
// retrieve full details on a player session, call DescribePlayerSessions with
// the player session ID.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
type PlacedPlayerSession struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a player that is associated with this player session.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session.
	PlayerSessionId *string `type:"string"`
}

// String returns the string representation
func (s PlacedPlayerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacedPlayerSession) GoString() string {
	return s.String()
}

// SetPlayerId sets the PlayerId field's value.
func (s *PlacedPlayerSession) SetPlayerId(v string) *PlacedPlayerSession {
	s.PlayerId = &v
	return s
}

// SetPlayerSessionId sets the PlayerSessionId field's value.
func (s *PlacedPlayerSession) SetPlayerSessionId(v string) *PlacedPlayerSession {
	s.PlayerSessionId = &v
	return s
}

// Represents a player in matchmaking. When starting a matchmaking request,
// a player has a player ID, attributes, and may have latency data. Team information
// is added after a match has been successfully completed.
type Player struct {
	_ struct{} `type:"structure"`

	// Set of values, expressed in milliseconds, indicating the amount of latency
	// that a player experiences when connected to AWS regions. If this property
	// is present, FlexMatch considers placing the match only in regions for which
	// latency is reported.
	//
	// If a matchmaker has a rule that evaluates player latency, players must report
	// latency in order to be matched. If no latency is reported in this scenario,
	// FlexMatch assumes that no regions are available to the player and the ticket
	// is not matchable.
	LatencyInMs map[string]*int64 `type:"map"`

	// Collection of key:value pairs containing player information for use in matchmaking.
	// Player attribute keys must match the playerAttributes used in a matchmaking
	// rule set. Example: "PlayerAttributes": {"skill": {"N": "23"}, "gameMode":
	// {"S": "deathmatch"}}.
	PlayerAttributes map[string]*AttributeValue `type:"map"`

	// Unique identifier for a player
	PlayerId *string `min:"1" type:"string"`

	// Name of the team that the player is assigned to in a match. Team names are
	// defined in a matchmaking rule set.
	Team *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Player) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Player) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Player) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Player"}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}
	if s.Team != nil && len(*s.Team) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Team", 1))
	}
	if s.PlayerAttributes != nil {
		for i, v := range s.PlayerAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PlayerAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatencyInMs sets the LatencyInMs field's value.
func (s *Player) SetLatencyInMs(v map[string]*int64) *Player {
	s.LatencyInMs = v
	return s
}

// SetPlayerAttributes sets the PlayerAttributes field's value.
func (s *Player) SetPlayerAttributes(v map[string]*AttributeValue) *Player {
	s.PlayerAttributes = v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *Player) SetPlayerId(v string) *Player {
	s.PlayerId = &v
	return s
}

// SetTeam sets the Team field's value.
func (s *Player) SetTeam(v string) *Player {
	s.Team = &v
	return s
}

// Regional latency information for a player, used when requesting a new game
// session with StartGameSessionPlacement. This value indicates the amount of
// time lag that exists when the player is connected to a fleet in the specified
// region. The relative difference between a player's latency values for multiple
// regions are used to determine which fleets are best suited to place a new
// game session for the player.
type PlayerLatency struct {
	_ struct{} `type:"structure"`

	// Amount of time that represents the time lag experienced by the player when
	// connected to the specified region.
	LatencyInMilliseconds *float64 `type:"float"`

	// Unique identifier for a player associated with the latency data.
	PlayerId *string `min:"1" type:"string"`

	// Name of the region that is associated with the latency value.
	RegionIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PlayerLatency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlayerLatency) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlayerLatency) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PlayerLatency"}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}
	if s.RegionIdentifier != nil && len(*s.RegionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatencyInMilliseconds sets the LatencyInMilliseconds field's value.
func (s *PlayerLatency) SetLatencyInMilliseconds(v float64) *PlayerLatency {
	s.LatencyInMilliseconds = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *PlayerLatency) SetPlayerId(v string) *PlayerLatency {
	s.PlayerId = &v
	return s
}

// SetRegionIdentifier sets the RegionIdentifier field's value.
func (s *PlayerLatency) SetRegionIdentifier(v string) *PlayerLatency {
	s.RegionIdentifier = &v
	return s
}

// Queue setting that determines the highest latency allowed for individual
// players when placing a game session. When a latency policy is in force, a
// game session cannot be placed at any destination in a region where a player
// is reporting latency higher than the cap. Latency policies are only enforced
// when the placement request contains player latency information.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
type PlayerLatencyPolicy struct {
	_ struct{} `type:"structure"`

	// The maximum latency value that is allowed for any player, in milliseconds.
	// All policies must have a value set for this property.
	MaximumIndividualPlayerLatencyMilliseconds *int64 `type:"integer"`

	// The length of time, in seconds, that the policy is enforced while placing
	// a new game session. A null value for this property means that the policy
	// is enforced until the queue times out.
	PolicyDurationSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s PlayerLatencyPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlayerLatencyPolicy) GoString() string {
	return s.String()
}

// SetMaximumIndividualPlayerLatencyMilliseconds sets the MaximumIndividualPlayerLatencyMilliseconds field's value.
func (s *PlayerLatencyPolicy) SetMaximumIndividualPlayerLatencyMilliseconds(v int64) *PlayerLatencyPolicy {
	s.MaximumIndividualPlayerLatencyMilliseconds = &v
	return s
}

// SetPolicyDurationSeconds sets the PolicyDurationSeconds field's value.
func (s *PlayerLatencyPolicy) SetPolicyDurationSeconds(v int64) *PlayerLatencyPolicy {
	s.PolicyDurationSeconds = &v
	return s
}

// Properties describing a player session. Player session objects are created
// either by creating a player session for a specific game session, or as part
// of a game session placement. A player session represents either a player
// reservation for a game session (status RESERVED) or actual player activity
// in a game session (status ACTIVE). A player session object (including player
// data) is automatically passed to a game session when the player connects
// to the game session and is validated.
//
// When a player disconnects, the player session status changes to COMPLETED.
// Once the session ends, the player session object is retained for 30 days
// and then removed.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
type PlayerSession struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// Unique identifier for a fleet that the player's game session is running on.
	FleetId *string `type:"string"`

	// Unique identifier for the game session that the player session is connected
	// to.
	GameSessionId *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	IpAddress *string `type:"string"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// Unique identifier for a player that is associated with this player session.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session.
	PlayerSessionId *string `type:"string"`

	// Port number for the game session. To connect to a Amazon GameLift server
	// process, an app needs both the IP address and port number.
	Port *int64 `min:"1" type:"integer"`

	// Current status of the player session.
	//
	// Possible player session statuses include the following:
	//
	//    * RESERVED -- The player session request has been received, but the player
	//    has not yet connected to the server process and/or been validated.
	//
	//    * ACTIVE -- The player has been validated by the server process and is
	//    currently connected.
	//
	//    * COMPLETED -- The player connection has been dropped.
	//
	//    * TIMEDOUT -- A player session request was received, but the player did
	//    not connect and/or was not validated within the timeout limit (60 seconds).
	Status *string `type:"string" enum:"PlayerSessionStatus"`

	// Time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s PlayerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlayerSession) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *PlayerSession) SetCreationTime(v time.Time) *PlayerSession {
	s.CreationTime = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *PlayerSession) SetFleetId(v string) *PlayerSession {
	s.FleetId = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *PlayerSession) SetGameSessionId(v string) *PlayerSession {
	s.GameSessionId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *PlayerSession) SetIpAddress(v string) *PlayerSession {
	s.IpAddress = &v
	return s
}

// SetPlayerData sets the PlayerData field's value.
func (s *PlayerSession) SetPlayerData(v string) *PlayerSession {
	s.PlayerData = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *PlayerSession) SetPlayerId(v string) *PlayerSession {
	s.PlayerId = &v
	return s
}

// SetPlayerSessionId sets the PlayerSessionId field's value.
func (s *PlayerSession) SetPlayerSessionId(v string) *PlayerSession {
	s.PlayerSessionId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *PlayerSession) SetPort(v int64) *PlayerSession {
	s.Port = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PlayerSession) SetStatus(v string) *PlayerSession {
	s.Status = &v
	return s
}

// SetTerminationTime sets the TerminationTime field's value.
func (s *PlayerSession) SetTerminationTime(v time.Time) *PlayerSession {
	s.TerminationTime = &v
	return s
}

// Represents the input for a request action.
type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Comparison operator to use when measuring the metric against the threshold
	// value.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperatorType"`

	// Length of time (in minutes) the metric must be at or beyond the threshold
	// before a scaling event is triggered.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// Unique identifier for a fleet to apply this policy to. The fleet cannot be
	// in any of the following statuses: ERROR or DELETING.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Name of the Amazon GameLift-defined metric that is used to trigger a scaling
	// adjustment. For detailed descriptions of fleet metrics, see Monitor Amazon
	// GameLift with Amazon CloudWatch (http://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html).
	//
	//    * ActivatingGameSessions -- Game sessions in the process of being created.
	//
	//    * ActiveGameSessions -- Game sessions that are currently running.
	//
	//    * ActiveInstances -- Fleet instances that are currently running at least
	//    one game session.
	//
	//    * AvailableGameSessions -- Additional game sessions that fleet could host
	//    simultaneously, given current capacity.
	//
	//    * AvailablePlayerSessions -- Empty player slots in currently active game
	//    sessions. This includes game sessions that are not currently accepting
	//    players. Reserved player slots are not included.
	//
	//    * CurrentPlayerSessions -- Player slots in active game sessions that are
	//    being used by a player or are reserved for a player.
	//
	//    * IdleInstances -- Active instances that are currently hosting zero game
	//    sessions.
	//
	//    * PercentAvailableGameSessions -- Unused percentage of the total number
	//    of game sessions that a fleet could host simultaneously, given current
	//    capacity. Use this metric for a target-based scaling policy.
	//
	//    * PercentIdleInstances -- Percentage of the total number of active instances
	//    that are hosting zero game sessions.
	//
	//    * QueueDepth -- Pending game session placement requests, in any queue,
	//    where the current fleet is the top-priority destination.
	//
	//    * WaitTime -- Current wait time for pending game session placement requests,
	//    in any queue, where the current fleet is the top-priority destination.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true" enum:"MetricName"`

	// Descriptive label that is associated with a scaling policy. Policy names
	// do not need to be unique. A fleet can have only one scaling policy with the
	// same name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Type of scaling policy to create. For a target-based policy, set the parameter
	// MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration.
	// For a rule-based policy set the following parameters: MetricName, ComparisonOperator,
	// Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
	PolicyType *string `type:"string" enum:"PolicyType"`

	// Amount of adjustment to make, based on the scaling adjustment type.
	ScalingAdjustment *int64 `type:"integer"`

	// Type of adjustment to make to a fleet's instance count (see FleetCapacity):
	//
	//    * ChangeInCapacity -- add (or subtract) the scaling adjustment value from
	//    the current instance count. Positive values scale up while negative values
	//    scale down.
	//
	//    * ExactCapacity -- set the instance count to the scaling adjustment value.
	//
	//    * PercentChangeInCapacity -- increase or reduce the current instance count
	//    by the scaling adjustment, read as a percentage. Positive values scale
	//    up while negative values scale down; for example, a value of "-10" scales
	//    the fleet down by 10%.
	ScalingAdjustmentType *string `type:"string" enum:"ScalingAdjustmentType"`

	// Object that contains settings for a target-based scaling policy.
	TargetConfiguration *TargetConfiguration `type:"structure"`

	// Metric value used to trigger a scaling event.
	Threshold *float64 `type:"double"`
}

// String returns the string representation
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScalingPolicyInput"}
	if s.EvaluationPeriods != nil && *s.EvaluationPeriods < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EvaluationPeriods", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TargetConfiguration != nil {
		if err := s.TargetConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *PutScalingPolicyInput) SetComparisonOperator(v string) *PutScalingPolicyInput {
	s.ComparisonOperator = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *PutScalingPolicyInput) SetEvaluationPeriods(v int64) *PutScalingPolicyInput {
	s.EvaluationPeriods = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *PutScalingPolicyInput) SetFleetId(v string) *PutScalingPolicyInput {
	s.FleetId = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *PutScalingPolicyInput) SetMetricName(v string) *PutScalingPolicyInput {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutScalingPolicyInput) SetName(v string) *PutScalingPolicyInput {
	s.Name = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *PutScalingPolicyInput) SetPolicyType(v string) *PutScalingPolicyInput {
	s.PolicyType = &v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *PutScalingPolicyInput) SetScalingAdjustment(v int64) *PutScalingPolicyInput {
	s.ScalingAdjustment = &v
	return s
}

// SetScalingAdjustmentType sets the ScalingAdjustmentType field's value.
func (s *PutScalingPolicyInput) SetScalingAdjustmentType(v string) *PutScalingPolicyInput {
	s.ScalingAdjustmentType = &v
	return s
}

// SetTargetConfiguration sets the TargetConfiguration field's value.
func (s *PutScalingPolicyInput) SetTargetConfiguration(v *TargetConfiguration) *PutScalingPolicyInput {
	s.TargetConfiguration = v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *PutScalingPolicyInput) SetThreshold(v float64) *PutScalingPolicyInput {
	s.Threshold = &v
	return s
}

// Represents the returned data in response to a request action.
type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Descriptive label that is associated with a scaling policy. Policy names
	// do not need to be unique.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *PutScalingPolicyOutput) SetName(v string) *PutScalingPolicyOutput {
	s.Name = &v
	return s
}

// Represents the input for a request action.
type RequestUploadCredentialsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to get credentials for.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RequestUploadCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestUploadCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestUploadCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestUploadCredentialsInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *RequestUploadCredentialsInput) SetBuildId(v string) *RequestUploadCredentialsInput {
	s.BuildId = &v
	return s
}

// Represents the returned data in response to a request action.
type RequestUploadCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// Amazon S3 path and key, identifying where the game build files are stored.
	StorageLocation *S3Location `type:"structure"`

	// AWS credentials required when uploading a game build to the storage location.
	// These credentials have a limited lifespan and are valid only for the build
	// they were issued for.
	UploadCredentials *AwsCredentials `type:"structure"`
}

// String returns the string representation
func (s RequestUploadCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestUploadCredentialsOutput) GoString() string {
	return s.String()
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *RequestUploadCredentialsOutput) SetStorageLocation(v *S3Location) *RequestUploadCredentialsOutput {
	s.StorageLocation = v
	return s
}

// SetUploadCredentials sets the UploadCredentials field's value.
func (s *RequestUploadCredentialsOutput) SetUploadCredentials(v *AwsCredentials) *RequestUploadCredentialsOutput {
	s.UploadCredentials = v
	return s
}

// Represents the input for a request action.
type ResolveAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the alias you want to resolve.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResolveAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolveAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolveAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *ResolveAliasInput) SetAliasId(v string) *ResolveAliasInput {
	s.AliasId = &v
	return s
}

// Represents the returned data in response to a request action.
type ResolveAliasOutput struct {
	_ struct{} `type:"structure"`

	// Fleet identifier that is associated with the requested alias.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s ResolveAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveAliasOutput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *ResolveAliasOutput) SetFleetId(v string) *ResolveAliasOutput {
	s.FleetId = &v
	return s
}

// Policy that limits the number of game sessions a player can create on the
// same fleet. This optional policy gives game owners control over how players
// can consume available game server resources. A resource creation policy makes
// the following statement: "An individual player can create a maximum number
// of new game sessions within a specified time period".
//
// The policy is evaluated when a player tries to create a new game session.
// For example, with a policy of 10 new game sessions and a time period of 60
// minutes, on receiving a CreateGameSession request, Amazon GameLift checks
// that the player (identified by CreatorId) has created fewer than 10 game
// sessions in the past 60 minutes.
type ResourceCreationLimitPolicy struct {
	_ struct{} `type:"structure"`

	// Maximum number of game sessions that an individual can create during the
	// policy period.
	NewGameSessionsPerCreator *int64 `type:"integer"`

	// Time span used in evaluating the resource creation limit policy.
	PolicyPeriodInMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s ResourceCreationLimitPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCreationLimitPolicy) GoString() string {
	return s.String()
}

// SetNewGameSessionsPerCreator sets the NewGameSessionsPerCreator field's value.
func (s *ResourceCreationLimitPolicy) SetNewGameSessionsPerCreator(v int64) *ResourceCreationLimitPolicy {
	s.NewGameSessionsPerCreator = &v
	return s
}

// SetPolicyPeriodInMinutes sets the PolicyPeriodInMinutes field's value.
func (s *ResourceCreationLimitPolicy) SetPolicyPeriodInMinutes(v int64) *ResourceCreationLimitPolicy {
	s.PolicyPeriodInMinutes = &v
	return s
}

// Routing configuration for a fleet alias.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
type RoutingStrategy struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that the alias points to.
	FleetId *string `type:"string"`

	// Message text to be used with a terminal routing strategy.
	Message *string `type:"string"`

	// Type of routing strategy.
	//
	// Possible routing types include the following:
	//
	//    * SIMPLE -- The alias resolves to one specific fleet. Use this type when
	//    routing to active fleets.
	//
	//    * TERMINAL -- The alias does not resolve to a fleet but instead can be
	//    used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException
	//    with the RoutingStrategy message embedded.
	Type *string `type:"string" enum:"RoutingStrategyType"`
}

// String returns the string representation
func (s RoutingStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingStrategy) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *RoutingStrategy) SetFleetId(v string) *RoutingStrategy {
	s.FleetId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *RoutingStrategy) SetMessage(v string) *RoutingStrategy {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *RoutingStrategy) SetType(v string) *RoutingStrategy {
	s.Type = &v
	return s
}

// A collection of server process configurations that describe what processes
// to run on each instance in a fleet. All fleets must have a run-time configuration.
// Each instance in the fleet launches the server processes specified in the
// run-time configuration and launches new ones as existing processes end. Each
// instance regularly checks for an updated run-time configuration and follows
// the new instructions.
//
// The run-time configuration enables the instances in a fleet to run multiple
// processes simultaneously. Potential scenarios are as follows: (1) Run multiple
// processes of a single game server executable to maximize usage of your hosting
// resources. (2) Run one or more processes of different build executables,
// such as your game server executable and a related program, or two or more
// different versions of a game server. (3) Run multiple processes of a single
// game server but with different launch parameters, for example to run one
// process on each instance in debug mode.
//
// A Amazon GameLift instance is limited to 50 processes running simultaneously.
// A run-time configuration must specify fewer than this limit. To calculate
// the total number of processes specified in a run-time configuration, add
// the values of the ConcurrentExecutions parameter for each ServerProcess object
// in the run-time configuration.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetCapacity
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeEC2InstanceLimits
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
type RuntimeConfiguration struct {
	_ struct{} `type:"structure"`

	// Maximum amount of time (in seconds) that a game session can remain in status
	// ACTIVATING. If the game session is not active before the timeout, activation
	// is terminated and the game session status is changed to TERMINATED.
	GameSessionActivationTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Maximum number of game sessions with status ACTIVATING to allow on an instance
	// simultaneously. This setting limits the amount of instance resources that
	// can be used for new game activations at any one time.
	MaxConcurrentGameSessionActivations *int64 `min:"1" type:"integer"`

	// Collection of server process configurations that describe which server processes
	// to run on each instance in a fleet.
	ServerProcesses []*ServerProcess `min:"1" type:"list"`
}

// String returns the string representation
func (s RuntimeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuntimeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuntimeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuntimeConfiguration"}
	if s.GameSessionActivationTimeoutSeconds != nil && *s.GameSessionActivationTimeoutSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("GameSessionActivationTimeoutSeconds", 1))
	}
	if s.MaxConcurrentGameSessionActivations != nil && *s.MaxConcurrentGameSessionActivations < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConcurrentGameSessionActivations", 1))
	}
	if s.ServerProcesses != nil && len(s.ServerProcesses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerProcesses", 1))
	}
	if s.ServerProcesses != nil {
		for i, v := range s.ServerProcesses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ServerProcesses", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionActivationTimeoutSeconds sets the GameSessionActivationTimeoutSeconds field's value.
func (s *RuntimeConfiguration) SetGameSessionActivationTimeoutSeconds(v int64) *RuntimeConfiguration {
	s.GameSessionActivationTimeoutSeconds = &v
	return s
}

// SetMaxConcurrentGameSessionActivations sets the MaxConcurrentGameSessionActivations field's value.
func (s *RuntimeConfiguration) SetMaxConcurrentGameSessionActivations(v int64) *RuntimeConfiguration {
	s.MaxConcurrentGameSessionActivations = &v
	return s
}

// SetServerProcesses sets the ServerProcesses field's value.
func (s *RuntimeConfiguration) SetServerProcesses(v []*ServerProcess) *RuntimeConfiguration {
	s.ServerProcesses = v
	return s
}

// Location in Amazon Simple Storage Service (Amazon S3) where build files can
// be stored for access by Amazon GameLift. This location is specified in a
// CreateBuild request. For more details, see the Create a Build with Files
// in Amazon S3 (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build).
type S3Location struct {
	_ struct{} `type:"structure"`

	// Amazon S3 bucket identifier. This is the name of your S3 bucket.
	Bucket *string `min:"1" type:"string"`

	// Name of the zip file containing your build files.
	Key *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// for the access role that allows Amazon GameLift to access your S3 bucket.
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Location) SetBucket(v string) *S3Location {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Location) SetKey(v string) *S3Location {
	s.Key = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *S3Location) SetRoleArn(v string) *S3Location {
	s.RoleArn = &v
	return s
}

// Rule that controls how a fleet is scaled. Scaling policies are uniquely identified
// by the combination of name and fleet ID.
//
// Operations related to fleet capacity scaling include:
//
//    * DescribeFleetCapacity
//
//    * UpdateFleetCapacity
//
//    * DescribeEC2InstanceLimits
//
//    * Manage scaling policies:
//
// PutScalingPolicy (auto-scaling)
//
// DescribeScalingPolicies (auto-scaling)
//
// DeleteScalingPolicy (auto-scaling)
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// Comparison operator to use when measuring a metric against the threshold
	// value.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperatorType"`

	// Length of time (in minutes) the metric must be at or beyond the threshold
	// before a scaling event is triggered.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// Unique identifier for a fleet that is associated with this scaling policy.
	FleetId *string `type:"string"`

	// Name of the Amazon GameLift-defined metric that is used to trigger a scaling
	// adjustment. For detailed descriptions of fleet metrics, see Monitor Amazon
	// GameLift with Amazon CloudWatch (http://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html).
	//
	//    * ActivatingGameSessions -- Game sessions in the process of being created.
	//
	//    * ActiveGameSessions -- Game sessions that are currently running.
	//
	//    * ActiveInstances -- Fleet instances that are currently running at least
	//    one game session.
	//
	//    * AvailableGameSessions -- Additional game sessions that fleet could host
	//    simultaneously, given current capacity.
	//
	//    * AvailablePlayerSessions -- Empty player slots in currently active game
	//    sessions. This includes game sessions that are not currently accepting
	//    players. Reserved player slots are not included.
	//
	//    * CurrentPlayerSessions -- Player slots in active game sessions that are
	//    being used by a player or are reserved for a player.
	//
	//    * IdleInstances -- Active instances that are currently hosting zero game
	//    sessions.
	//
	//    * PercentAvailableGameSessions -- Unused percentage of the total number
	//    of game sessions that a fleet could host simultaneously, given current
	//    capacity. Use this metric for a target-based scaling policy.
	//
	//    * PercentIdleInstances -- Percentage of the total number of active instances
	//    that are hosting zero game sessions.
	//
	//    * QueueDepth -- Pending game session placement requests, in any queue,
	//    where the current fleet is the top-priority destination.
	//
	//    * WaitTime -- Current wait time for pending game session placement requests,
	//    in any queue, where the current fleet is the top-priority destination.
	MetricName *string `type:"string" enum:"MetricName"`

	// Descriptive label that is associated with a scaling policy. Policy names
	// do not need to be unique.
	Name *string `min:"1" type:"string"`

	// Type of scaling policy to create. For a target-based policy, set the parameter
	// MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration.
	// For a rule-based policy set the following parameters: MetricName, ComparisonOperator,
	// Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
	PolicyType *string `type:"string" enum:"PolicyType"`

	// Amount of adjustment to make, based on the scaling adjustment type.
	ScalingAdjustment *int64 `type:"integer"`

	// Type of adjustment to make to a fleet's instance count (see FleetCapacity):
	//
	//    * ChangeInCapacity -- add (or subtract) the scaling adjustment value from
	//    the current instance count. Positive values scale up while negative values
	//    scale down.
	//
	//    * ExactCapacity -- set the instance count to the scaling adjustment value.
	//
	//    * PercentChangeInCapacity -- increase or reduce the current instance count
	//    by the scaling adjustment, read as a percentage. Positive values scale
	//    up while negative values scale down.
	ScalingAdjustmentType *string `type:"string" enum:"ScalingAdjustmentType"`

	// Current status of the scaling policy. The scaling policy can be in force
	// only when in an ACTIVE status. Scaling policies can be suspended for individual
	// fleets (see StopFleetActions; if suspended for a fleet, the policy status
	// does not change. View a fleet's stopped actions by calling DescribeFleetCapacity.
	//
	//    * ACTIVE -- The scaling policy can be used for auto-scaling a fleet.
	//
	//    * UPDATE_REQUESTED -- A request to update the scaling policy has been
	//    received.
	//
	//    * UPDATING -- A change is being made to the scaling policy.
	//
	//    * DELETE_REQUESTED -- A request to delete the scaling policy has been
	//    received.
	//
	//    * DELETING -- The scaling policy is being deleted.
	//
	//    * DELETED -- The scaling policy has been deleted.
	//
	//    * ERROR -- An error occurred in creating the policy. It should be removed
	//    and recreated.
	Status *string `type:"string" enum:"ScalingStatusType"`

	// Object that contains settings for a target-based scaling policy.
	TargetConfiguration *TargetConfiguration `type:"structure"`

	// Metric value used to trigger a scaling event.
	Threshold *float64 `type:"double"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *ScalingPolicy) SetComparisonOperator(v string) *ScalingPolicy {
	s.ComparisonOperator = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *ScalingPolicy) SetEvaluationPeriods(v int64) *ScalingPolicy {
	s.EvaluationPeriods = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *ScalingPolicy) SetFleetId(v string) *ScalingPolicy {
	s.FleetId = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ScalingPolicy) SetMetricName(v string) *ScalingPolicy {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *ScalingPolicy) SetName(v string) *ScalingPolicy {
	s.Name = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *ScalingPolicy) SetPolicyType(v string) *ScalingPolicy {
	s.PolicyType = &v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *ScalingPolicy) SetScalingAdjustment(v int64) *ScalingPolicy {
	s.ScalingAdjustment = &v
	return s
}

// SetScalingAdjustmentType sets the ScalingAdjustmentType field's value.
func (s *ScalingPolicy) SetScalingAdjustmentType(v string) *ScalingPolicy {
	s.ScalingAdjustmentType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ScalingPolicy) SetStatus(v string) *ScalingPolicy {
	s.Status = &v
	return s
}

// SetTargetConfiguration sets the TargetConfiguration field's value.
func (s *ScalingPolicy) SetTargetConfiguration(v *TargetConfiguration) *ScalingPolicy {
	s.TargetConfiguration = v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *ScalingPolicy) SetThreshold(v float64) *ScalingPolicy {
	s.Threshold = &v
	return s
}

// Represents the input for a request action.
type SearchGameSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias associated with the fleet to search for active
	// game sessions. Each request must reference either a fleet ID or alias ID,
	// but not both.
	AliasId *string `type:"string"`

	// String containing the search criteria for the session search. If no filter
	// expression is included, the request returns results for all game sessions
	// in the fleet that are in ACTIVE status.
	//
	// A filter expression can contain one or multiple conditions. Each condition
	// consists of the following:
	//
	//    * Operand -- Name of a game session attribute. Valid values are gameSessionName,
	//    gameSessionId, gameSessionProperties, maximumSessions, creationTimeMillis,
	//    playerSessionCount, hasAvailablePlayerSessions.
	//
	//    * Comparator -- Valid comparators are: =, <>, <, >, <=, >=.
	//
	//    * Value -- Value to be searched for. Values may be numbers, boolean values
	//    (true/false) or strings depending on the operand. String values are case
	//    sensitive and must be enclosed in single quotes. Special characters must
	//    be escaped. Boolean and string values can only be used with the comparators
	//    = and <>. For example, the following filter expression searches on gameSessionName:
	//    "FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game 1'".
	//
	// To chain multiple conditions in a single expression, use the logical keywords
	// AND, OR, and NOT and parentheses as needed. For example: x AND y AND NOT
	// z, NOT (x OR y).
	//
	// Session search evaluates conditions from left to right using the following
	// precedence rules:
	//
	// =, <>, <, >, <=, >=
	//
	// Parentheses
	//
	// NOT
	//
	// AND
	//
	// OR
	//
	// For example, this filter expression retrieves game sessions hosting at least
	// ten players that have an open player slot: "maximumSessions>=10 AND hasAvailablePlayerSessions=true".
	FilterExpression *string `min:"1" type:"string"`

	// Unique identifier for a fleet to search for active game sessions. Each request
	// must reference either a fleet ID or alias ID, but not both.
	FleetId *string `type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. The maximum number of results returned
	// is 20, even if this value is not set or is set higher than 20.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Instructions on how to sort the search results. If no sort expression is
	// included, the request returns results in random order. A sort expression
	// consists of the following elements:
	//
	//    * Operand -- Name of a game session attribute. Valid values are gameSessionName,
	//    gameSessionId, gameSessionProperties, maximumSessions, creationTimeMillis,
	//    playerSessionCount, hasAvailablePlayerSessions.
	//
	//    * Order -- Valid sort orders are ASC (ascending) and DESC (descending).
	//
	// For example, this sort expression returns the oldest active sessions first:
	// "SortExpression": "creationTimeMillis ASC". Results with a null value for
	// the sort operand are returned at the end of the list.
	SortExpression *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SearchGameSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchGameSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchGameSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchGameSessionsInput"}
	if s.FilterExpression != nil && len(*s.FilterExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterExpression", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SortExpression != nil && len(*s.SortExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SortExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *SearchGameSessionsInput) SetAliasId(v string) *SearchGameSessionsInput {
	s.AliasId = &v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *SearchGameSessionsInput) SetFilterExpression(v string) *SearchGameSessionsInput {
	s.FilterExpression = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *SearchGameSessionsInput) SetFleetId(v string) *SearchGameSessionsInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *SearchGameSessionsInput) SetLimit(v int64) *SearchGameSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchGameSessionsInput) SetNextToken(v string) *SearchGameSessionsInput {
	s.NextToken = &v
	return s
}

// SetSortExpression sets the SortExpression field's value.
func (s *SearchGameSessionsInput) SetSortExpression(v string) *SearchGameSessionsInput {
	s.SortExpression = &v
	return s
}

// Represents the returned data in response to a request action.
type SearchGameSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing game session properties for each session
	// matching the request.
	GameSessions []*GameSession `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SearchGameSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchGameSessionsOutput) GoString() string {
	return s.String()
}

// SetGameSessions sets the GameSessions field's value.
func (s *SearchGameSessionsOutput) SetGameSessions(v []*GameSession) *SearchGameSessionsOutput {
	s.GameSessions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchGameSessionsOutput) SetNextToken(v string) *SearchGameSessionsOutput {
	s.NextToken = &v
	return s
}

// A set of instructions for launching server processes on each instance in
// a fleet. Each instruction set identifies the location of the server executable,
// optional launch parameters, and the number of server processes with this
// configuration to maintain concurrently on the instance. Server process configurations
// make up a fleet's RuntimeConfiguration.
type ServerProcess struct {
	_ struct{} `type:"structure"`

	// Number of server processes using this configuration to run concurrently on
	// an instance.
	//
	// ConcurrentExecutions is a required field
	ConcurrentExecutions *int64 `min:"1" type:"integer" required:"true"`

	// Location of the server executable in a game build. All game builds are installed
	// on instances at the root : for Windows instances C:\game, and for Linux instances
	// /local/game. A Windows game build with an executable file located at MyGame\latest\server.exe
	// must have a launch path of "C:\game\MyGame\latest\server.exe". A Linux game
	// build with an executable file located at MyGame/latest/server.exe must have
	// a launch path of "/local/game/MyGame/latest/server.exe".
	//
	// LaunchPath is a required field
	LaunchPath *string `min:"1" type:"string" required:"true"`

	// Optional list of parameters to pass to the server executable on launch.
	Parameters *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ServerProcess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerProcess) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerProcess) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerProcess"}
	if s.ConcurrentExecutions == nil {
		invalidParams.Add(request.NewErrParamRequired("ConcurrentExecutions"))
	}
	if s.ConcurrentExecutions != nil && *s.ConcurrentExecutions < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ConcurrentExecutions", 1))
	}
	if s.LaunchPath == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchPath"))
	}
	if s.LaunchPath != nil && len(*s.LaunchPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchPath", 1))
	}
	if s.Parameters != nil && len(*s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConcurrentExecutions sets the ConcurrentExecutions field's value.
func (s *ServerProcess) SetConcurrentExecutions(v int64) *ServerProcess {
	s.ConcurrentExecutions = &v
	return s
}

// SetLaunchPath sets the LaunchPath field's value.
func (s *ServerProcess) SetLaunchPath(v string) *ServerProcess {
	s.LaunchPath = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ServerProcess) SetParameters(v string) *ServerProcess {
	s.Parameters = &v
	return s
}

type StartFleetActionsInput struct {
	_ struct{} `type:"structure"`

	// List of actions to restart on the fleet.
	//
	// Actions is a required field
	Actions []*string `min:"1" type:"list" required:"true"`

	// Unique identifier for a fleet
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartFleetActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFleetActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFleetActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFleetActionsInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *StartFleetActionsInput) SetActions(v []*string) *StartFleetActionsInput {
	s.Actions = v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *StartFleetActionsInput) SetFleetId(v string) *StartFleetActionsInput {
	s.FleetId = &v
	return s
}

type StartFleetActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartFleetActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFleetActionsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type StartGameSessionPlacementInput struct {
	_ struct{} `type:"structure"`

	// Set of information on each player to create a player session for.
	DesiredPlayerSessions []*DesiredPlayerSession `type:"list"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameProperties []*GameProperty `type:"list"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string `min:"1" type:"string"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	GameSessionName *string `min:"1" type:"string"`

	// Name of the queue to use to place the new game session.
	//
	// GameSessionQueueName is a required field
	GameSessionQueueName *string `min:"1" type:"string" required:"true"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	//
	// MaximumPlayerSessionCount is a required field
	MaximumPlayerSessionCount *int64 `type:"integer" required:"true"`

	// Unique identifier to assign to the new game session placement. This value
	// is developer-defined. The value must be unique across all regions and cannot
	// be reused unless you are resubmitting a canceled or timed-out placement request.
	//
	// PlacementId is a required field
	PlacementId *string `min:"1" type:"string" required:"true"`

	// Set of values, expressed in milliseconds, indicating the amount of latency
	// that a player experiences when connected to AWS regions. This information
	// is used to try to place the new game session where it can offer the best
	// possible gameplay experience for the players.
	PlayerLatencies []*PlayerLatency `type:"list"`
}

// String returns the string representation
func (s StartGameSessionPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGameSessionPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartGameSessionPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartGameSessionPlacementInput"}
	if s.GameSessionData != nil && len(*s.GameSessionData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionData", 1))
	}
	if s.GameSessionName != nil && len(*s.GameSessionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionName", 1))
	}
	if s.GameSessionQueueName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionQueueName"))
	}
	if s.GameSessionQueueName != nil && len(*s.GameSessionQueueName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionQueueName", 1))
	}
	if s.MaximumPlayerSessionCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumPlayerSessionCount"))
	}
	if s.PlacementId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementId"))
	}
	if s.PlacementId != nil && len(*s.PlacementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementId", 1))
	}
	if s.DesiredPlayerSessions != nil {
		for i, v := range s.DesiredPlayerSessions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DesiredPlayerSessions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GameProperties != nil {
		for i, v := range s.GameProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GameProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PlayerLatencies != nil {
		for i, v := range s.PlayerLatencies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PlayerLatencies", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredPlayerSessions sets the DesiredPlayerSessions field's value.
func (s *StartGameSessionPlacementInput) SetDesiredPlayerSessions(v []*DesiredPlayerSession) *StartGameSessionPlacementInput {
	s.DesiredPlayerSessions = v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *StartGameSessionPlacementInput) SetGameProperties(v []*GameProperty) *StartGameSessionPlacementInput {
	s.GameProperties = v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *StartGameSessionPlacementInput) SetGameSessionData(v string) *StartGameSessionPlacementInput {
	s.GameSessionData = &v
	return s
}

// SetGameSessionName sets the GameSessionName field's value.
func (s *StartGameSessionPlacementInput) SetGameSessionName(v string) *StartGameSessionPlacementInput {
	s.GameSessionName = &v
	return s
}

// SetGameSessionQueueName sets the GameSessionQueueName field's value.
func (s *StartGameSessionPlacementInput) SetGameSessionQueueName(v string) *StartGameSessionPlacementInput {
	s.GameSessionQueueName = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *StartGameSessionPlacementInput) SetMaximumPlayerSessionCount(v int64) *StartGameSessionPlacementInput {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetPlacementId sets the PlacementId field's value.
func (s *StartGameSessionPlacementInput) SetPlacementId(v string) *StartGameSessionPlacementInput {
	s.PlacementId = &v
	return s
}

// SetPlayerLatencies sets the PlayerLatencies field's value.
func (s *StartGameSessionPlacementInput) SetPlayerLatencies(v []*PlayerLatency) *StartGameSessionPlacementInput {
	s.PlayerLatencies = v
	return s
}

// Represents the returned data in response to a request action.
type StartGameSessionPlacementOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created game session placement. This object
	// includes all the information provided in the request, as well as start/end
	// time stamps and placement status.
	GameSessionPlacement *GameSessionPlacement `type:"structure"`
}

// String returns the string representation
func (s StartGameSessionPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGameSessionPlacementOutput) GoString() string {
	return s.String()
}

// SetGameSessionPlacement sets the GameSessionPlacement field's value.
func (s *StartGameSessionPlacementOutput) SetGameSessionPlacement(v *GameSessionPlacement) *StartGameSessionPlacementOutput {
	s.GameSessionPlacement = v
	return s
}

// Represents the input for a request action.
type StartMatchBackfillInput struct {
	_ struct{} `type:"structure"`

	// Name of the matchmaker to use for this request. The name of the matchmaker
	// that was used with the original game session is listed in the GameSession
	// object, MatchmakerData property. This property contains a matchmaking configuration
	// ARN value, which includes the matchmaker name. (In the ARN value "arn:aws:gamelift:us-west-2:111122223333:matchmakingconfiguration/MM-4v4",
	// the matchmaking configuration name is "MM-4v4".) Use only the name for this
	// parameter.
	//
	// ConfigurationName is a required field
	ConfigurationName *string `min:"1" type:"string" required:"true"`

	// Amazon Resource Name (ARN (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session and uniquely identifies it.
	//
	// GameSessionArn is a required field
	GameSessionArn *string `min:"1" type:"string" required:"true"`

	// Match information on all players that are currently assigned to the game
	// session. This information is used by the matchmaker to find new players and
	// add them to the existing game.
	//
	//    * PlayerID, PlayerAttributes, Team -\\- This information is maintained
	//    in the GameSession object, MatchmakerData property, for all players who
	//    are currently assigned to the game session. The matchmaker data is in
	//    JSON syntax, formatted as a string. For more details, see  Match Data
	//    (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data).
	//
	//
	//    * LatencyInMs -\\- If the matchmaker uses player latency, include a latency
	//    value, in milliseconds, for the region that the game session is currently
	//    in. Do not include latency values for any other region.
	//
	// Players is a required field
	Players []*Player `type:"list" required:"true"`

	// Unique identifier for a matchmaking ticket. If no ticket ID is specified
	// here, Amazon GameLift will generate one in the form of a UUID. Use this identifier
	// to track the match backfill ticket status and retrieve match results.
	TicketId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartMatchBackfillInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMatchBackfillInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMatchBackfillInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMatchBackfillInput"}
	if s.ConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationName"))
	}
	if s.ConfigurationName != nil && len(*s.ConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationName", 1))
	}
	if s.GameSessionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionArn"))
	}
	if s.GameSessionArn != nil && len(*s.GameSessionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionArn", 1))
	}
	if s.Players == nil {
		invalidParams.Add(request.NewErrParamRequired("Players"))
	}
	if s.TicketId != nil && len(*s.TicketId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TicketId", 1))
	}
	if s.Players != nil {
		for i, v := range s.Players {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Players", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *StartMatchBackfillInput) SetConfigurationName(v string) *StartMatchBackfillInput {
	s.ConfigurationName = &v
	return s
}

// SetGameSessionArn sets the GameSessionArn field's value.
func (s *StartMatchBackfillInput) SetGameSessionArn(v string) *StartMatchBackfillInput {
	s.GameSessionArn = &v
	return s
}

// SetPlayers sets the Players field's value.
func (s *StartMatchBackfillInput) SetPlayers(v []*Player) *StartMatchBackfillInput {
	s.Players = v
	return s
}

// SetTicketId sets the TicketId field's value.
func (s *StartMatchBackfillInput) SetTicketId(v string) *StartMatchBackfillInput {
	s.TicketId = &v
	return s
}

// Represents the returned data in response to a request action.
type StartMatchBackfillOutput struct {
	_ struct{} `type:"structure"`

	// Ticket representing the backfill matchmaking request. This object includes
	// the information in the request, ticket status, and match results as generated
	// during the matchmaking process.
	MatchmakingTicket *MatchmakingTicket `type:"structure"`
}

// String returns the string representation
func (s StartMatchBackfillOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMatchBackfillOutput) GoString() string {
	return s.String()
}

// SetMatchmakingTicket sets the MatchmakingTicket field's value.
func (s *StartMatchBackfillOutput) SetMatchmakingTicket(v *MatchmakingTicket) *StartMatchBackfillOutput {
	s.MatchmakingTicket = v
	return s
}

// Represents the input for a request action.
type StartMatchmakingInput struct {
	_ struct{} `type:"structure"`

	// Name of the matchmaking configuration to use for this request. Matchmaking
	// configurations must exist in the same region as this request.
	//
	// ConfigurationName is a required field
	ConfigurationName *string `min:"1" type:"string" required:"true"`

	// Information on each player to be matched. This information must include a
	// player ID, and may contain player attributes and latency data to be used
	// in the matchmaking process. After a successful match, Player objects contain
	// the name of the team the player is assigned to.
	//
	// Players is a required field
	Players []*Player `type:"list" required:"true"`

	// Unique identifier for a matchmaking ticket. If no ticket ID is specified
	// here, Amazon GameLift will generate one in the form of a UUID. Use this identifier
	// to track the matchmaking ticket status and retrieve match results.
	TicketId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartMatchmakingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMatchmakingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMatchmakingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMatchmakingInput"}
	if s.ConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationName"))
	}
	if s.ConfigurationName != nil && len(*s.ConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationName", 1))
	}
	if s.Players == nil {
		invalidParams.Add(request.NewErrParamRequired("Players"))
	}
	if s.TicketId != nil && len(*s.TicketId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TicketId", 1))
	}
	if s.Players != nil {
		for i, v := range s.Players {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Players", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationName sets the ConfigurationName field's value.
func (s *StartMatchmakingInput) SetConfigurationName(v string) *StartMatchmakingInput {
	s.ConfigurationName = &v
	return s
}

// SetPlayers sets the Players field's value.
func (s *StartMatchmakingInput) SetPlayers(v []*Player) *StartMatchmakingInput {
	s.Players = v
	return s
}

// SetTicketId sets the TicketId field's value.
func (s *StartMatchmakingInput) SetTicketId(v string) *StartMatchmakingInput {
	s.TicketId = &v
	return s
}

// Represents the returned data in response to a request action.
type StartMatchmakingOutput struct {
	_ struct{} `type:"structure"`

	// Ticket representing the matchmaking request. This object include the information
	// included in the request, ticket status, and match results as generated during
	// the matchmaking process.
	MatchmakingTicket *MatchmakingTicket `type:"structure"`
}

// String returns the string representation
func (s StartMatchmakingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMatchmakingOutput) GoString() string {
	return s.String()
}

// SetMatchmakingTicket sets the MatchmakingTicket field's value.
func (s *StartMatchmakingOutput) SetMatchmakingTicket(v *MatchmakingTicket) *StartMatchmakingOutput {
	s.MatchmakingTicket = v
	return s
}

type StopFleetActionsInput struct {
	_ struct{} `type:"structure"`

	// List of actions to suspend on the fleet.
	//
	// Actions is a required field
	Actions []*string `min:"1" type:"list" required:"true"`

	// Unique identifier for a fleet
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopFleetActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFleetActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFleetActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopFleetActionsInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *StopFleetActionsInput) SetActions(v []*string) *StopFleetActionsInput {
	s.Actions = v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *StopFleetActionsInput) SetFleetId(v string) *StopFleetActionsInput {
	s.FleetId = &v
	return s
}

type StopFleetActionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopFleetActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFleetActionsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type StopGameSessionPlacementInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session placement to cancel.
	//
	// PlacementId is a required field
	PlacementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopGameSessionPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopGameSessionPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopGameSessionPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopGameSessionPlacementInput"}
	if s.PlacementId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementId"))
	}
	if s.PlacementId != nil && len(*s.PlacementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementId sets the PlacementId field's value.
func (s *StopGameSessionPlacementInput) SetPlacementId(v string) *StopGameSessionPlacementInput {
	s.PlacementId = &v
	return s
}

// Represents the returned data in response to a request action.
type StopGameSessionPlacementOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the canceled game session placement, with CANCELLED
	// status and an end time stamp.
	GameSessionPlacement *GameSessionPlacement `type:"structure"`
}

// String returns the string representation
func (s StopGameSessionPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopGameSessionPlacementOutput) GoString() string {
	return s.String()
}

// SetGameSessionPlacement sets the GameSessionPlacement field's value.
func (s *StopGameSessionPlacementOutput) SetGameSessionPlacement(v *GameSessionPlacement) *StopGameSessionPlacementOutput {
	s.GameSessionPlacement = v
	return s
}

// Represents the input for a request action.
type StopMatchmakingInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a matchmaking ticket.
	//
	// TicketId is a required field
	TicketId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopMatchmakingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopMatchmakingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopMatchmakingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopMatchmakingInput"}
	if s.TicketId == nil {
		invalidParams.Add(request.NewErrParamRequired("TicketId"))
	}
	if s.TicketId != nil && len(*s.TicketId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TicketId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTicketId sets the TicketId field's value.
func (s *StopMatchmakingInput) SetTicketId(v string) *StopMatchmakingInput {
	s.TicketId = &v
	return s
}

type StopMatchmakingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopMatchmakingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopMatchmakingOutput) GoString() string {
	return s.String()
}

// Settings for a target-based scaling policy (see ScalingPolicy. A target-based
// policy tracks a particular fleet metric specifies a target value for the
// metric. As player usage changes, the policy triggers Amazon GameLift to adjust
// capacity so that the metric returns to the target value. The target configuration
// specifies settings as needed for the target based policy, including the target
// value.
//
// Operations related to fleet capacity scaling include:
//
//    * DescribeFleetCapacity
//
//    * UpdateFleetCapacity
//
//    * DescribeEC2InstanceLimits
//
//    * Manage scaling policies:
//
// PutScalingPolicy (auto-scaling)
//
// DescribeScalingPolicies (auto-scaling)
//
// DeleteScalingPolicy (auto-scaling)
//
//    * Manage fleet actions:
//
// StartFleetActions
//
// StopFleetActions
type TargetConfiguration struct {
	_ struct{} `type:"structure"`

	// Desired value to use with a target-based scaling policy. The value must be
	// relevant for whatever metric the scaling policy is using. For example, in
	// a policy using the metric PercentAvailableGameSessions, the target value
	// should be the preferred size of the fleet's buffer (the percent of capacity
	// that should be idle and ready for new game sessions).
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s TargetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetConfiguration"}
	if s.TargetValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetValue sets the TargetValue field's value.
func (s *TargetConfiguration) SetTargetValue(v float64) *TargetConfiguration {
	s.TargetValue = &v
	return s
}

// Represents the input for a request action.
type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify the alias you want to update.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`

	// Human-readable description of an alias.
	Description *string `min:"1" type:"string"`

	// Descriptive label that is associated with an alias. Alias names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Object that specifies the fleet and routing type to use for the alias.
	RoutingStrategy *RoutingStrategy `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *UpdateAliasInput) SetAliasId(v string) *UpdateAliasInput {
	s.AliasId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAliasInput) SetDescription(v string) *UpdateAliasInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAliasInput) SetName(v string) *UpdateAliasInput {
	s.Name = &v
	return s
}

// SetRoutingStrategy sets the RoutingStrategy field's value.
func (s *UpdateAliasInput) SetRoutingStrategy(v *RoutingStrategy) *UpdateAliasInput {
	s.RoutingStrategy = v
	return s
}

// Represents the returned data in response to a request action.
type UpdateAliasOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the updated alias configuration.
	Alias *Alias `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *UpdateAliasOutput) SetAlias(v *Alias) *UpdateAliasOutput {
	s.Alias = v
	return s
}

// Represents the input for a request action.
type UpdateBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to update.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`

	// Descriptive label that is associated with a build. Build names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Version that is associated with this build. Version strings do not need to
	// be unique.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBuildInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *UpdateBuildInput) SetBuildId(v string) *UpdateBuildInput {
	s.BuildId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateBuildInput) SetName(v string) *UpdateBuildInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateBuildInput) SetVersion(v string) *UpdateBuildInput {
	s.Version = &v
	return s
}

// Represents the returned data in response to a request action.
type UpdateBuildOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the updated build record.
	Build *Build `type:"structure"`
}

// String returns the string representation
func (s UpdateBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *UpdateBuildOutput) SetBuild(v *Build) *UpdateBuildOutput {
	s.Build = v
	return s
}

// Represents the input for a request action.
type UpdateFleetAttributesInput struct {
	_ struct{} `type:"structure"`

	// Human-readable description of a fleet.
	Description *string `min:"1" type:"string"`

	// Unique identifier for a fleet to update attribute metadata for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Names of metric groups to include this fleet in. Amazon CloudWatch uses a
	// fleet metric group is to aggregate metrics from multiple fleets. Use an existing
	// metric group name to add this fleet to the group. Or use a new name to create
	// a new metric group. A fleet can only be included in one metric group at a
	// time.
	MetricGroups []*string `type:"list"`

	// Descriptive label that is associated with a fleet. Fleet names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Game session protection policy to apply to all new instances created in this
	// fleet. Instances that already exist are not affected. You can set protection
	// for individual instances using UpdateGameSession.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// Policy that limits the number of game sessions an individual player can create
	// over a span of time.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetAttributesInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFleetAttributesInput) SetDescription(v string) *UpdateFleetAttributesInput {
	s.Description = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetAttributesInput) SetFleetId(v string) *UpdateFleetAttributesInput {
	s.FleetId = &v
	return s
}

// SetMetricGroups sets the MetricGroups field's value.
func (s *UpdateFleetAttributesInput) SetMetricGroups(v []*string) *UpdateFleetAttributesInput {
	s.MetricGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFleetAttributesInput) SetName(v string) *UpdateFleetAttributesInput {
	s.Name = &v
	return s
}

// SetNewGameSessionProtectionPolicy sets the NewGameSessionProtectionPolicy field's value.
func (s *UpdateFleetAttributesInput) SetNewGameSessionProtectionPolicy(v string) *UpdateFleetAttributesInput {
	s.NewGameSessionProtectionPolicy = &v
	return s
}

// SetResourceCreationLimitPolicy sets the ResourceCreationLimitPolicy field's value.
func (s *UpdateFleetAttributesInput) SetResourceCreationLimitPolicy(v *ResourceCreationLimitPolicy) *UpdateFleetAttributesInput {
	s.ResourceCreationLimitPolicy = v
	return s
}

// Represents the returned data in response to a request action.
type UpdateFleetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that was updated.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s UpdateFleetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetAttributesOutput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetAttributesOutput) SetFleetId(v string) *UpdateFleetAttributesOutput {
	s.FleetId = &v
	return s
}

// Represents the input for a request action.
type UpdateFleetCapacityInput struct {
	_ struct{} `type:"structure"`

	// Number of EC2 instances you want this fleet to host.
	DesiredInstances *int64 `type:"integer"`

	// Unique identifier for a fleet to update capacity for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Maximum value allowed for the fleet's instance count. Default if not set
	// is 1.
	MaxSize *int64 `type:"integer"`

	// Minimum value allowed for the fleet's instance count. Default if not set
	// is 0.
	MinSize *int64 `type:"integer"`
}

// String returns the string representation
func (s UpdateFleetCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetCapacityInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredInstances sets the DesiredInstances field's value.
func (s *UpdateFleetCapacityInput) SetDesiredInstances(v int64) *UpdateFleetCapacityInput {
	s.DesiredInstances = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetCapacityInput) SetFleetId(v string) *UpdateFleetCapacityInput {
	s.FleetId = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *UpdateFleetCapacityInput) SetMaxSize(v int64) *UpdateFleetCapacityInput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *UpdateFleetCapacityInput) SetMinSize(v int64) *UpdateFleetCapacityInput {
	s.MinSize = &v
	return s
}

// Represents the returned data in response to a request action.
type UpdateFleetCapacityOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that was updated.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s UpdateFleetCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetCapacityOutput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetCapacityOutput) SetFleetId(v string) *UpdateFleetCapacityOutput {
	s.FleetId = &v
	return s
}

// Represents the input for a request action.
type UpdateFleetPortSettingsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to update port settings for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Collection of port settings to be added to the fleet record.
	InboundPermissionAuthorizations []*IpPermission `type:"list"`

	// Collection of port settings to be removed from the fleet record.
	InboundPermissionRevocations []*IpPermission `type:"list"`
}

// String returns the string representation
func (s UpdateFleetPortSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetPortSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetPortSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetPortSettingsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.InboundPermissionAuthorizations != nil {
		for i, v := range s.InboundPermissionAuthorizations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InboundPermissionAuthorizations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InboundPermissionRevocations != nil {
		for i, v := range s.InboundPermissionRevocations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InboundPermissionRevocations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetPortSettingsInput) SetFleetId(v string) *UpdateFleetPortSettingsInput {
	s.FleetId = &v
	return s
}

// SetInboundPermissionAuthorizations sets the InboundPermissionAuthorizations field's value.
func (s *UpdateFleetPortSettingsInput) SetInboundPermissionAuthorizations(v []*IpPermission) *UpdateFleetPortSettingsInput {
	s.InboundPermissionAuthorizations = v
	return s
}

// SetInboundPermissionRevocations sets the InboundPermissionRevocations field's value.
func (s *UpdateFleetPortSettingsInput) SetInboundPermissionRevocations(v []*IpPermission) *UpdateFleetPortSettingsInput {
	s.InboundPermissionRevocations = v
	return s
}

// Represents the returned data in response to a request action.
type UpdateFleetPortSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that was updated.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s UpdateFleetPortSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetPortSettingsOutput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetPortSettingsOutput) SetFleetId(v string) *UpdateFleetPortSettingsOutput {
	s.FleetId = &v
	return s
}

// Represents the input for a request action.
type UpdateGameSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to update.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	Name *string `min:"1" type:"string"`

	// Policy determining whether or not the game session accepts new players.
	PlayerSessionCreationPolicy *string `type:"string" enum:"PlayerSessionCreationPolicy"`

	// Game session protection policy to apply to this game session only.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	ProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`
}

// String returns the string representation
func (s UpdateGameSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGameSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGameSessionInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *UpdateGameSessionInput) SetGameSessionId(v string) *UpdateGameSessionInput {
	s.GameSessionId = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *UpdateGameSessionInput) SetMaximumPlayerSessionCount(v int64) *UpdateGameSessionInput {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGameSessionInput) SetName(v string) *UpdateGameSessionInput {
	s.Name = &v
	return s
}

// SetPlayerSessionCreationPolicy sets the PlayerSessionCreationPolicy field's value.
func (s *UpdateGameSessionInput) SetPlayerSessionCreationPolicy(v string) *UpdateGameSessionInput {
	s.PlayerSessionCreationPolicy = &v
	return s
}

// SetProtectionPolicy sets the ProtectionPolicy field's value.
func (s *UpdateGameSessionInput) SetProtectionPolicy(v string) *UpdateGameSessionInput {
	s.ProtectionPolicy = &v
	return s
}

// Represents the returned data in response to a request action.
type UpdateGameSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the updated game session metadata.
	GameSession *GameSession `type:"structure"`
}

// String returns the string representation
func (s UpdateGameSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionOutput) GoString() string {
	return s.String()
}

// SetGameSession sets the GameSession field's value.
func (s *UpdateGameSessionOutput) SetGameSession(v *GameSession) *UpdateGameSessionOutput {
	s.GameSession = v
	return s
}

// Represents the input for a request action.
type UpdateGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// List of fleets that can be used to fulfill game session placement requests
	// in the queue. Fleets are identified by either a fleet ARN or a fleet alias
	// ARN. Destinations are listed in default preference order. When updating this
	// list, provide a complete list of destinations.
	Destinations []*GameSessionQueueDestination `type:"list"`

	// Descriptive label that is associated with game session queue. Queue names
	// must be unique within each region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Collection of latency policies to apply when processing game sessions placement
	// requests with player latency information. Multiple policies are evaluated
	// in order of the maximum latency value, starting with the lowest latency values.
	// With just one policy, it is enforced at the start of the game session placement
	// for the duration period. With multiple policies, each policy is enforced
	// consecutively for its duration period. For example, a queue might enforce
	// a 60-second policy followed by a 120-second policy, and then no policy for
	// the remainder of the placement. When updating policies, provide a complete
	// collection of policies.
	PlayerLatencyPolicies []*PlayerLatencyPolicy `type:"list"`

	// Maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s UpdateGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGameSessionQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGameSessionQueueInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *UpdateGameSessionQueueInput) SetDestinations(v []*GameSessionQueueDestination) *UpdateGameSessionQueueInput {
	s.Destinations = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGameSessionQueueInput) SetName(v string) *UpdateGameSessionQueueInput {
	s.Name = &v
	return s
}

// SetPlayerLatencyPolicies sets the PlayerLatencyPolicies field's value.
func (s *UpdateGameSessionQueueInput) SetPlayerLatencyPolicies(v []*PlayerLatencyPolicy) *UpdateGameSessionQueueInput {
	s.PlayerLatencyPolicies = v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *UpdateGameSessionQueueInput) SetTimeoutInSeconds(v int64) *UpdateGameSessionQueueInput {
	s.TimeoutInSeconds = &v
	return s
}

// Represents the returned data in response to a request action.
type UpdateGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly updated game session queue.
	GameSessionQueue *GameSessionQueue `type:"structure"`
}

// String returns the string representation
func (s UpdateGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionQueueOutput) GoString() string {
	return s.String()
}

// SetGameSessionQueue sets the GameSessionQueue field's value.
func (s *UpdateGameSessionQueueOutput) SetGameSessionQueue(v *GameSessionQueue) *UpdateGameSessionQueueOutput {
	s.GameSessionQueue = v
	return s
}

// Represents the input for a request action.
type UpdateMatchmakingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Flag that determines whether or not a match that was created with this configuration
	// must be accepted by the matched players. To require acceptance, set to TRUE.
	AcceptanceRequired *bool `type:"boolean"`

	// Length of time (in seconds) to wait for players to accept a proposed match.
	// If any player rejects the match or fails to accept before the timeout, the
	// ticket continues to look for an acceptable match.
	AcceptanceTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Number of player slots in a match to keep open for future players. For example,
	// if the configuration's rule set specifies a match for a single 12-person
	// team, and the additional player count is set to 2, only 10 players are selected
	// for the match.
	AdditionalPlayerCount *int64 `type:"integer"`

	// Information to attached to all events related to the matchmaking configuration.
	CustomEventData *string `type:"string"`

	// Descriptive label that is associated with matchmaking configuration.
	Description *string `min:"1" type:"string"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match.
	GameProperties []*GameProperty `type:"list"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match.
	GameSessionData *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session queue and uniquely identifies it. Format
	// is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	// These queues are used when placing game sessions for matches that are created
	// with this matchmaking configuration. Queues can be located in any region.
	GameSessionQueueArns []*string `type:"list"`

	// Unique identifier for a matchmaking configuration to update.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// SNS topic ARN that is set up to receive matchmaking notifications. See  Setting
	// up Notifications for Matchmaking (http://docs.aws.amazon.com/gamelift/latest/developerguide/match-notification.html)
	// for more information.
	NotificationTarget *string `type:"string"`

	// Maximum duration, in seconds, that a matchmaking ticket can remain in process
	// before timing out. Requests that time out can be resubmitted as needed.
	RequestTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Unique identifier for a matchmaking rule set to use with this configuration.
	// A matchmaking configuration can only use rule sets that are defined in the
	// same region.
	RuleSetName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateMatchmakingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMatchmakingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMatchmakingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMatchmakingConfigurationInput"}
	if s.AcceptanceTimeoutSeconds != nil && *s.AcceptanceTimeoutSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("AcceptanceTimeoutSeconds", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GameSessionData != nil && len(*s.GameSessionData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionData", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RequestTimeoutSeconds != nil && *s.RequestTimeoutSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RequestTimeoutSeconds", 1))
	}
	if s.RuleSetName != nil && len(*s.RuleSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetName", 1))
	}
	if s.GameProperties != nil {
		for i, v := range s.GameProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GameProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptanceRequired sets the AcceptanceRequired field's value.
func (s *UpdateMatchmakingConfigurationInput) SetAcceptanceRequired(v bool) *UpdateMatchmakingConfigurationInput {
	s.AcceptanceRequired = &v
	return s
}

// SetAcceptanceTimeoutSeconds sets the AcceptanceTimeoutSeconds field's value.
func (s *UpdateMatchmakingConfigurationInput) SetAcceptanceTimeoutSeconds(v int64) *UpdateMatchmakingConfigurationInput {
	s.AcceptanceTimeoutSeconds = &v
	return s
}

// SetAdditionalPlayerCount sets the AdditionalPlayerCount field's value.
func (s *UpdateMatchmakingConfigurationInput) SetAdditionalPlayerCount(v int64) *UpdateMatchmakingConfigurationInput {
	s.AdditionalPlayerCount = &v
	return s
}

// SetCustomEventData sets the CustomEventData field's value.
func (s *UpdateMatchmakingConfigurationInput) SetCustomEventData(v string) *UpdateMatchmakingConfigurationInput {
	s.CustomEventData = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateMatchmakingConfigurationInput) SetDescription(v string) *UpdateMatchmakingConfigurationInput {
	s.Description = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *UpdateMatchmakingConfigurationInput) SetGameProperties(v []*GameProperty) *UpdateMatchmakingConfigurationInput {
	s.GameProperties = v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *UpdateMatchmakingConfigurationInput) SetGameSessionData(v string) *UpdateMatchmakingConfigurationInput {
	s.GameSessionData = &v
	return s
}

// SetGameSessionQueueArns sets the GameSessionQueueArns field's value.
func (s *UpdateMatchmakingConfigurationInput) SetGameSessionQueueArns(v []*string) *UpdateMatchmakingConfigurationInput {
	s.GameSessionQueueArns = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateMatchmakingConfigurationInput) SetName(v string) *UpdateMatchmakingConfigurationInput {
	s.Name = &v
	return s
}

// SetNotificationTarget sets the NotificationTarget field's value.
func (s *UpdateMatchmakingConfigurationInput) SetNotificationTarget(v string) *UpdateMatchmakingConfigurationInput {
	s.NotificationTarget = &v
	return s
}

// SetRequestTimeoutSeconds sets the RequestTimeoutSeconds field's value.
func (s *UpdateMatchmakingConfigurationInput) SetRequestTimeoutSeconds(v int64) *UpdateMatchmakingConfigurationInput {
	s.RequestTimeoutSeconds = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *UpdateMatchmakingConfigurationInput) SetRuleSetName(v string) *UpdateMatchmakingConfigurationInput {
	s.RuleSetName = &v
	return s
}

// Represents the returned data in response to a request action.
type UpdateMatchmakingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the updated matchmaking configuration.
	Configuration *MatchmakingConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateMatchmakingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMatchmakingConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateMatchmakingConfigurationOutput) SetConfiguration(v *MatchmakingConfiguration) *UpdateMatchmakingConfigurationOutput {
	s.Configuration = v
	return s
}

// Represents the input for a request action.
type UpdateRuntimeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to update run-time configuration for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Instructions for launching server processes on each instance in the fleet.
	// The run-time configuration for a fleet has a collection of server process
	// configurations, one for each type of server process to run on an instance.
	// A server process configuration specifies the location of the server executable,
	// launch parameters, and the number of concurrent processes with that configuration
	// to maintain on each instance.
	//
	// RuntimeConfiguration is a required field
	RuntimeConfiguration *RuntimeConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRuntimeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuntimeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuntimeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuntimeConfigurationInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.RuntimeConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("RuntimeConfiguration"))
	}
	if s.RuntimeConfiguration != nil {
		if err := s.RuntimeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RuntimeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateRuntimeConfigurationInput) SetFleetId(v string) *UpdateRuntimeConfigurationInput {
	s.FleetId = &v
	return s
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *UpdateRuntimeConfigurationInput) SetRuntimeConfiguration(v *RuntimeConfiguration) *UpdateRuntimeConfigurationInput {
	s.RuntimeConfiguration = v
	return s
}

// Represents the returned data in response to a request action.
type UpdateRuntimeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The run-time configuration currently in force. If the update was successful,
	// this object matches the one in the request.
	RuntimeConfiguration *RuntimeConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateRuntimeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuntimeConfigurationOutput) GoString() string {
	return s.String()
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *UpdateRuntimeConfigurationOutput) SetRuntimeConfiguration(v *RuntimeConfiguration) *UpdateRuntimeConfigurationOutput {
	s.RuntimeConfiguration = v
	return s
}

// Represents the input for a request action.
type ValidateMatchmakingRuleSetInput struct {
	_ struct{} `type:"structure"`

	// Collection of matchmaking rules to validate, formatted as a JSON string.
	//
	// RuleSetBody is a required field
	RuleSetBody *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ValidateMatchmakingRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateMatchmakingRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateMatchmakingRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateMatchmakingRuleSetInput"}
	if s.RuleSetBody == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetBody"))
	}
	if s.RuleSetBody != nil && len(*s.RuleSetBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetBody", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetBody sets the RuleSetBody field's value.
func (s *ValidateMatchmakingRuleSetInput) SetRuleSetBody(v string) *ValidateMatchmakingRuleSetInput {
	s.RuleSetBody = &v
	return s
}

// Represents the returned data in response to a request action.
type ValidateMatchmakingRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// Response indicating whether or not the rule set is valid.
	Valid *bool `type:"boolean"`
}

// String returns the string representation
func (s ValidateMatchmakingRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateMatchmakingRuleSetOutput) GoString() string {
	return s.String()
}

// SetValid sets the Valid field's value.
func (s *ValidateMatchmakingRuleSetOutput) SetValid(v bool) *ValidateMatchmakingRuleSetOutput {
	s.Valid = &v
	return s
}

// Represents an authorization for a VPC peering connection between the VPC
// for an Amazon GameLift fleet and another VPC on an account you have access
// to. This authorization must exist and be valid for the peering connection
// to be established. Authorizations are valid for 24 hours after they are issued.
//
// VPC peering connection operations include:
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
type VpcPeeringAuthorization struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this authorization was issued. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// Time stamp indicating when this authorization expires (24 hours after issuance).
	// Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
	ExpirationTime *time.Time `type:"timestamp"`

	// Unique identifier for the AWS account that you use to manage your Amazon
	// GameLift fleet. You can find your Account ID in the AWS Management Console
	// under account settings.
	GameLiftAwsAccountId *string `min:"1" type:"string"`

	PeerVpcAwsAccountId *string `min:"1" type:"string"`

	// Unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same region where your fleet is deployed.
	// To get VPC information, including IDs, use the Virtual Private Cloud service
	// tools, including the VPC Dashboard in the AWS Management Console.
	PeerVpcId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s VpcPeeringAuthorization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcPeeringAuthorization) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *VpcPeeringAuthorization) SetCreationTime(v time.Time) *VpcPeeringAuthorization {
	s.CreationTime = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *VpcPeeringAuthorization) SetExpirationTime(v time.Time) *VpcPeeringAuthorization {
	s.ExpirationTime = &v
	return s
}

// SetGameLiftAwsAccountId sets the GameLiftAwsAccountId field's value.
func (s *VpcPeeringAuthorization) SetGameLiftAwsAccountId(v string) *VpcPeeringAuthorization {
	s.GameLiftAwsAccountId = &v
	return s
}

// SetPeerVpcAwsAccountId sets the PeerVpcAwsAccountId field's value.
func (s *VpcPeeringAuthorization) SetPeerVpcAwsAccountId(v string) *VpcPeeringAuthorization {
	s.PeerVpcAwsAccountId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *VpcPeeringAuthorization) SetPeerVpcId(v string) *VpcPeeringAuthorization {
	s.PeerVpcId = &v
	return s
}

// Represents a peering connection between a VPC on one of your AWS accounts
// and the VPC for your Amazon GameLift fleets. This record may be for an active
// peering connection or a pending connection that has not yet been established.
//
// VPC peering connection operations include:
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
type VpcPeeringConnection struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet. This ID determines the ID of the Amazon GameLift
	// VPC for your fleet.
	FleetId *string `type:"string"`

	// Unique identifier for the VPC that contains the Amazon GameLift fleet for
	// this connection. This VPC is managed by Amazon GameLift and does not appear
	// in your AWS account.
	GameLiftVpcId *string `min:"1" type:"string"`

	// CIDR block of IPv4 addresses assigned to the VPC peering connection for the
	// GameLift VPC. The peered VPC also has an IPv4 CIDR block associated with
	// it; these blocks cannot overlap or the peering connection cannot be created.
	IpV4CidrBlock *string `min:"1" type:"string"`

	// Unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same region where your fleet is deployed.
	// To get VPC information, including IDs, use the Virtual Private Cloud service
	// tools, including the VPC Dashboard in the AWS Management Console.
	PeerVpcId *string `min:"1" type:"string"`

	// Object that contains status information about the connection. Status indicates
	// if a connection is pending, successful, or failed.
	Status *VpcPeeringConnectionStatus `type:"structure"`

	// Unique identifier that is automatically assigned to the connection record.
	// This ID is referenced in VPC peering connection events, and is used when
	// deleting a connection with DeleteVpcPeeringConnection.
	VpcPeeringConnectionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcPeeringConnection) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *VpcPeeringConnection) SetFleetId(v string) *VpcPeeringConnection {
	s.FleetId = &v
	return s
}

// SetGameLiftVpcId sets the GameLiftVpcId field's value.
func (s *VpcPeeringConnection) SetGameLiftVpcId(v string) *VpcPeeringConnection {
	s.GameLiftVpcId = &v
	return s
}

// SetIpV4CidrBlock sets the IpV4CidrBlock field's value.
func (s *VpcPeeringConnection) SetIpV4CidrBlock(v string) *VpcPeeringConnection {
	s.IpV4CidrBlock = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *VpcPeeringConnection) SetPeerVpcId(v string) *VpcPeeringConnection {
	s.PeerVpcId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VpcPeeringConnection) SetStatus(v *VpcPeeringConnectionStatus) *VpcPeeringConnection {
	s.Status = v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *VpcPeeringConnection) SetVpcPeeringConnectionId(v string) *VpcPeeringConnection {
	s.VpcPeeringConnectionId = &v
	return s
}

// Represents status information for a VPC peering connection. Status is associated
// with a VpcPeeringConnection object. Status codes and messages are provided
// from EC2 (see VpcPeeringConnectionStateReason (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpcPeeringConnectionStateReason.html)).
// Connection status information is also communicated as a fleet Event.
type VpcPeeringConnectionStatus struct {
	_ struct{} `type:"structure"`

	// Code indicating the status of a VPC peering connection.
	Code *string `min:"1" type:"string"`

	// Additional messaging associated with the connection status.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcPeeringConnectionStatus) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *VpcPeeringConnectionStatus) SetCode(v string) *VpcPeeringConnectionStatus {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *VpcPeeringConnectionStatus) SetMessage(v string) *VpcPeeringConnectionStatus {
	s.Message = &v
	return s
}

const (
	// AcceptanceTypeAccept is a AcceptanceType enum value
	AcceptanceTypeAccept = "ACCEPT"

	// AcceptanceTypeReject is a AcceptanceType enum value
	AcceptanceTypeReject = "REJECT"
)

const (
	// BuildStatusInitialized is a BuildStatus enum value
	BuildStatusInitialized = "INITIALIZED"

	// BuildStatusReady is a BuildStatus enum value
	BuildStatusReady = "READY"

	// BuildStatusFailed is a BuildStatus enum value
	BuildStatusFailed = "FAILED"
)

const (
	// ComparisonOperatorTypeGreaterThanOrEqualToThreshold is a ComparisonOperatorType enum value
	ComparisonOperatorTypeGreaterThanOrEqualToThreshold = "GreaterThanOrEqualToThreshold"

	// ComparisonOperatorTypeGreaterThanThreshold is a ComparisonOperatorType enum value
	ComparisonOperatorTypeGreaterThanThreshold = "GreaterThanThreshold"

	// ComparisonOperatorTypeLessThanThreshold is a ComparisonOperatorType enum value
	ComparisonOperatorTypeLessThanThreshold = "LessThanThreshold"

	// ComparisonOperatorTypeLessThanOrEqualToThreshold is a ComparisonOperatorType enum value
	ComparisonOperatorTypeLessThanOrEqualToThreshold = "LessThanOrEqualToThreshold"
)

const (
	// EC2InstanceTypeT2Micro is a EC2InstanceType enum value
	EC2InstanceTypeT2Micro = "t2.micro"

	// EC2InstanceTypeT2Small is a EC2InstanceType enum value
	EC2InstanceTypeT2Small = "t2.small"

	// EC2InstanceTypeT2Medium is a EC2InstanceType enum value
	EC2InstanceTypeT2Medium = "t2.medium"

	// EC2InstanceTypeT2Large is a EC2InstanceType enum value
	EC2InstanceTypeT2Large = "t2.large"

	// EC2InstanceTypeC3Large is a EC2InstanceType enum value
	EC2InstanceTypeC3Large = "c3.large"

	// EC2InstanceTypeC3Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC3Xlarge = "c3.xlarge"

	// EC2InstanceTypeC32xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC32xlarge = "c3.2xlarge"

	// EC2InstanceTypeC34xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC34xlarge = "c3.4xlarge"

	// EC2InstanceTypeC38xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC38xlarge = "c3.8xlarge"

	// EC2InstanceTypeC4Large is a EC2InstanceType enum value
	EC2InstanceTypeC4Large = "c4.large"

	// EC2InstanceTypeC4Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC4Xlarge = "c4.xlarge"

	// EC2InstanceTypeC42xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC42xlarge = "c4.2xlarge"

	// EC2InstanceTypeC44xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC44xlarge = "c4.4xlarge"

	// EC2InstanceTypeC48xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC48xlarge = "c4.8xlarge"

	// EC2InstanceTypeR3Large is a EC2InstanceType enum value
	EC2InstanceTypeR3Large = "r3.large"

	// EC2InstanceTypeR3Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR3Xlarge = "r3.xlarge"

	// EC2InstanceTypeR32xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR32xlarge = "r3.2xlarge"

	// EC2InstanceTypeR34xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR34xlarge = "r3.4xlarge"

	// EC2InstanceTypeR38xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR38xlarge = "r3.8xlarge"

	// EC2InstanceTypeR4Large is a EC2InstanceType enum value
	EC2InstanceTypeR4Large = "r4.large"

	// EC2InstanceTypeR4Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR4Xlarge = "r4.xlarge"

	// EC2InstanceTypeR42xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR42xlarge = "r4.2xlarge"

	// EC2InstanceTypeR44xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR44xlarge = "r4.4xlarge"

	// EC2InstanceTypeR48xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR48xlarge = "r4.8xlarge"

	// EC2InstanceTypeR416xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR416xlarge = "r4.16xlarge"

	// EC2InstanceTypeM3Medium is a EC2InstanceType enum value
	EC2InstanceTypeM3Medium = "m3.medium"

	// EC2InstanceTypeM3Large is a EC2InstanceType enum value
	EC2InstanceTypeM3Large = "m3.large"

	// EC2InstanceTypeM3Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM3Xlarge = "m3.xlarge"

	// EC2InstanceTypeM32xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM32xlarge = "m3.2xlarge"

	// EC2InstanceTypeM4Large is a EC2InstanceType enum value
	EC2InstanceTypeM4Large = "m4.large"

	// EC2InstanceTypeM4Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM4Xlarge = "m4.xlarge"

	// EC2InstanceTypeM42xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM42xlarge = "m4.2xlarge"

	// EC2InstanceTypeM44xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM44xlarge = "m4.4xlarge"

	// EC2InstanceTypeM410xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM410xlarge = "m4.10xlarge"
)

const (
	// EventCodeGenericEvent is a EventCode enum value
	EventCodeGenericEvent = "GENERIC_EVENT"

	// EventCodeFleetCreated is a EventCode enum value
	EventCodeFleetCreated = "FLEET_CREATED"

	// EventCodeFleetDeleted is a EventCode enum value
	EventCodeFleetDeleted = "FLEET_DELETED"

	// EventCodeFleetScalingEvent is a EventCode enum value
	EventCodeFleetScalingEvent = "FLEET_SCALING_EVENT"

	// EventCodeFleetStateDownloading is a EventCode enum value
	EventCodeFleetStateDownloading = "FLEET_STATE_DOWNLOADING"

	// EventCodeFleetStateValidating is a EventCode enum value
	EventCodeFleetStateValidating = "FLEET_STATE_VALIDATING"

	// EventCodeFleetStateBuilding is a EventCode enum value
	EventCodeFleetStateBuilding = "FLEET_STATE_BUILDING"

	// EventCodeFleetStateActivating is a EventCode enum value
	EventCodeFleetStateActivating = "FLEET_STATE_ACTIVATING"

	// EventCodeFleetStateActive is a EventCode enum value
	EventCodeFleetStateActive = "FLEET_STATE_ACTIVE"

	// EventCodeFleetStateError is a EventCode enum value
	EventCodeFleetStateError = "FLEET_STATE_ERROR"

	// EventCodeFleetInitializationFailed is a EventCode enum value
	EventCodeFleetInitializationFailed = "FLEET_INITIALIZATION_FAILED"

	// EventCodeFleetBinaryDownloadFailed is a EventCode enum value
	EventCodeFleetBinaryDownloadFailed = "FLEET_BINARY_DOWNLOAD_FAILED"

	// EventCodeFleetValidationLaunchPathNotFound is a EventCode enum value
	EventCodeFleetValidationLaunchPathNotFound = "FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND"

	// EventCodeFleetValidationExecutableRuntimeFailure is a EventCode enum value
	EventCodeFleetValidationExecutableRuntimeFailure = "FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE"

	// EventCodeFleetValidationTimedOut is a EventCode enum value
	EventCodeFleetValidationTimedOut = "FLEET_VALIDATION_TIMED_OUT"

	// EventCodeFleetActivationFailed is a EventCode enum value
	EventCodeFleetActivationFailed = "FLEET_ACTIVATION_FAILED"

	// EventCodeFleetActivationFailedNoInstances is a EventCode enum value
	EventCodeFleetActivationFailedNoInstances = "FLEET_ACTIVATION_FAILED_NO_INSTANCES"

	// EventCodeFleetNewGameSessionProtectionPolicyUpdated is a EventCode enum value
	EventCodeFleetNewGameSessionProtectionPolicyUpdated = "FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED"

	// EventCodeServerProcessInvalidPath is a EventCode enum value
	EventCodeServerProcessInvalidPath = "SERVER_PROCESS_INVALID_PATH"

	// EventCodeServerProcessSdkInitializationTimeout is a EventCode enum value
	EventCodeServerProcessSdkInitializationTimeout = "SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT"

	// EventCodeServerProcessProcessReadyTimeout is a EventCode enum value
	EventCodeServerProcessProcessReadyTimeout = "SERVER_PROCESS_PROCESS_READY_TIMEOUT"

	// EventCodeServerProcessCrashed is a EventCode enum value
	EventCodeServerProcessCrashed = "SERVER_PROCESS_CRASHED"

	// EventCodeServerProcessTerminatedUnhealthy is a EventCode enum value
	EventCodeServerProcessTerminatedUnhealthy = "SERVER_PROCESS_TERMINATED_UNHEALTHY"

	// EventCodeServerProcessForceTerminated is a EventCode enum value
	EventCodeServerProcessForceTerminated = "SERVER_PROCESS_FORCE_TERMINATED"

	// EventCodeServerProcessProcessExitTimeout is a EventCode enum value
	EventCodeServerProcessProcessExitTimeout = "SERVER_PROCESS_PROCESS_EXIT_TIMEOUT"

	// EventCodeGameSessionActivationTimeout is a EventCode enum value
	EventCodeGameSessionActivationTimeout = "GAME_SESSION_ACTIVATION_TIMEOUT"

	// EventCodeFleetCreationExtractingBuild is a EventCode enum value
	EventCodeFleetCreationExtractingBuild = "FLEET_CREATION_EXTRACTING_BUILD"

	// EventCodeFleetCreationRunningInstaller is a EventCode enum value
	EventCodeFleetCreationRunningInstaller = "FLEET_CREATION_RUNNING_INSTALLER"

	// EventCodeFleetCreationValidatingRuntimeConfig is a EventCode enum value
	EventCodeFleetCreationValidatingRuntimeConfig = "FLEET_CREATION_VALIDATING_RUNTIME_CONFIG"

	// EventCodeFleetVpcPeeringSucceeded is a EventCode enum value
	EventCodeFleetVpcPeeringSucceeded = "FLEET_VPC_PEERING_SUCCEEDED"

	// EventCodeFleetVpcPeeringFailed is a EventCode enum value
	EventCodeFleetVpcPeeringFailed = "FLEET_VPC_PEERING_FAILED"

	// EventCodeFleetVpcPeeringDeleted is a EventCode enum value
	EventCodeFleetVpcPeeringDeleted = "FLEET_VPC_PEERING_DELETED"

	// EventCodeInstanceInterrupted is a EventCode enum value
	EventCodeInstanceInterrupted = "INSTANCE_INTERRUPTED"
)

const (
	// FleetActionAutoScaling is a FleetAction enum value
	FleetActionAutoScaling = "AUTO_SCALING"
)

const (
	// FleetStatusNew is a FleetStatus enum value
	FleetStatusNew = "NEW"

	// FleetStatusDownloading is a FleetStatus enum value
	FleetStatusDownloading = "DOWNLOADING"

	// FleetStatusValidating is a FleetStatus enum value
	FleetStatusValidating = "VALIDATING"

	// FleetStatusBuilding is a FleetStatus enum value
	FleetStatusBuilding = "BUILDING"

	// FleetStatusActivating is a FleetStatus enum value
	FleetStatusActivating = "ACTIVATING"

	// FleetStatusActive is a FleetStatus enum value
	FleetStatusActive = "ACTIVE"

	// FleetStatusDeleting is a FleetStatus enum value
	FleetStatusDeleting = "DELETING"

	// FleetStatusError is a FleetStatus enum value
	FleetStatusError = "ERROR"

	// FleetStatusTerminated is a FleetStatus enum value
	FleetStatusTerminated = "TERMINATED"
)

const (
	// FleetTypeOnDemand is a FleetType enum value
	FleetTypeOnDemand = "ON_DEMAND"

	// FleetTypeSpot is a FleetType enum value
	FleetTypeSpot = "SPOT"
)

const (
	// GameSessionPlacementStatePending is a GameSessionPlacementState enum value
	GameSessionPlacementStatePending = "PENDING"

	// GameSessionPlacementStateFulfilled is a GameSessionPlacementState enum value
	GameSessionPlacementStateFulfilled = "FULFILLED"

	// GameSessionPlacementStateCancelled is a GameSessionPlacementState enum value
	GameSessionPlacementStateCancelled = "CANCELLED"

	// GameSessionPlacementStateTimedOut is a GameSessionPlacementState enum value
	GameSessionPlacementStateTimedOut = "TIMED_OUT"
)

const (
	// GameSessionStatusActive is a GameSessionStatus enum value
	GameSessionStatusActive = "ACTIVE"

	// GameSessionStatusActivating is a GameSessionStatus enum value
	GameSessionStatusActivating = "ACTIVATING"

	// GameSessionStatusTerminated is a GameSessionStatus enum value
	GameSessionStatusTerminated = "TERMINATED"

	// GameSessionStatusTerminating is a GameSessionStatus enum value
	GameSessionStatusTerminating = "TERMINATING"

	// GameSessionStatusError is a GameSessionStatus enum value
	GameSessionStatusError = "ERROR"
)

const (
	// GameSessionStatusReasonInterrupted is a GameSessionStatusReason enum value
	GameSessionStatusReasonInterrupted = "INTERRUPTED"
)

const (
	// InstanceStatusPending is a InstanceStatus enum value
	InstanceStatusPending = "PENDING"

	// InstanceStatusActive is a InstanceStatus enum value
	InstanceStatusActive = "ACTIVE"

	// InstanceStatusTerminating is a InstanceStatus enum value
	InstanceStatusTerminating = "TERMINATING"
)

const (
	// IpProtocolTcp is a IpProtocol enum value
	IpProtocolTcp = "TCP"

	// IpProtocolUdp is a IpProtocol enum value
	IpProtocolUdp = "UDP"
)

const (
	// MatchmakingConfigurationStatusCancelled is a MatchmakingConfigurationStatus enum value
	MatchmakingConfigurationStatusCancelled = "CANCELLED"

	// MatchmakingConfigurationStatusCompleted is a MatchmakingConfigurationStatus enum value
	MatchmakingConfigurationStatusCompleted = "COMPLETED"

	// MatchmakingConfigurationStatusFailed is a MatchmakingConfigurationStatus enum value
	MatchmakingConfigurationStatusFailed = "FAILED"

	// MatchmakingConfigurationStatusPlacing is a MatchmakingConfigurationStatus enum value
	MatchmakingConfigurationStatusPlacing = "PLACING"

	// MatchmakingConfigurationStatusQueued is a MatchmakingConfigurationStatus enum value
	MatchmakingConfigurationStatusQueued = "QUEUED"

	// MatchmakingConfigurationStatusRequiresAcceptance is a MatchmakingConfigurationStatus enum value
	MatchmakingConfigurationStatusRequiresAcceptance = "REQUIRES_ACCEPTANCE"

	// MatchmakingConfigurationStatusSearching is a MatchmakingConfigurationStatus enum value
	MatchmakingConfigurationStatusSearching = "SEARCHING"

	// MatchmakingConfigurationStatusTimedOut is a MatchmakingConfigurationStatus enum value
	MatchmakingConfigurationStatusTimedOut = "TIMED_OUT"
)

const (
	// MetricNameActivatingGameSessions is a MetricName enum value
	MetricNameActivatingGameSessions = "ActivatingGameSessions"

	// MetricNameActiveGameSessions is a MetricName enum value
	MetricNameActiveGameSessions = "ActiveGameSessions"

	// MetricNameActiveInstances is a MetricName enum value
	MetricNameActiveInstances = "ActiveInstances"

	// MetricNameAvailableGameSessions is a MetricName enum value
	MetricNameAvailableGameSessions = "AvailableGameSessions"

	// MetricNameAvailablePlayerSessions is a MetricName enum value
	MetricNameAvailablePlayerSessions = "AvailablePlayerSessions"

	// MetricNameCurrentPlayerSessions is a MetricName enum value
	MetricNameCurrentPlayerSessions = "CurrentPlayerSessions"

	// MetricNameIdleInstances is a MetricName enum value
	MetricNameIdleInstances = "IdleInstances"

	// MetricNamePercentAvailableGameSessions is a MetricName enum value
	MetricNamePercentAvailableGameSessions = "PercentAvailableGameSessions"

	// MetricNamePercentIdleInstances is a MetricName enum value
	MetricNamePercentIdleInstances = "PercentIdleInstances"

	// MetricNameQueueDepth is a MetricName enum value
	MetricNameQueueDepth = "QueueDepth"

	// MetricNameWaitTime is a MetricName enum value
	MetricNameWaitTime = "WaitTime"
)

const (
	// OperatingSystemWindows2012 is a OperatingSystem enum value
	OperatingSystemWindows2012 = "WINDOWS_2012"

	// OperatingSystemAmazonLinux is a OperatingSystem enum value
	OperatingSystemAmazonLinux = "AMAZON_LINUX"
)

const (
	// PlayerSessionCreationPolicyAcceptAll is a PlayerSessionCreationPolicy enum value
	PlayerSessionCreationPolicyAcceptAll = "ACCEPT_ALL"

	// PlayerSessionCreationPolicyDenyAll is a PlayerSessionCreationPolicy enum value
	PlayerSessionCreationPolicyDenyAll = "DENY_ALL"
)

const (
	// PlayerSessionStatusReserved is a PlayerSessionStatus enum value
	PlayerSessionStatusReserved = "RESERVED"

	// PlayerSessionStatusActive is a PlayerSessionStatus enum value
	PlayerSessionStatusActive = "ACTIVE"

	// PlayerSessionStatusCompleted is a PlayerSessionStatus enum value
	PlayerSessionStatusCompleted = "COMPLETED"

	// PlayerSessionStatusTimedout is a PlayerSessionStatus enum value
	PlayerSessionStatusTimedout = "TIMEDOUT"
)

const (
	// PolicyTypeRuleBased is a PolicyType enum value
	PolicyTypeRuleBased = "RuleBased"

	// PolicyTypeTargetBased is a PolicyType enum value
	PolicyTypeTargetBased = "TargetBased"
)

const (
	// ProtectionPolicyNoProtection is a ProtectionPolicy enum value
	ProtectionPolicyNoProtection = "NoProtection"

	// ProtectionPolicyFullProtection is a ProtectionPolicy enum value
	ProtectionPolicyFullProtection = "FullProtection"
)

const (
	// RoutingStrategyTypeSimple is a RoutingStrategyType enum value
	RoutingStrategyTypeSimple = "SIMPLE"

	// RoutingStrategyTypeTerminal is a RoutingStrategyType enum value
	RoutingStrategyTypeTerminal = "TERMINAL"
)

const (
	// ScalingAdjustmentTypeChangeInCapacity is a ScalingAdjustmentType enum value
	ScalingAdjustmentTypeChangeInCapacity = "ChangeInCapacity"

	// ScalingAdjustmentTypeExactCapacity is a ScalingAdjustmentType enum value
	ScalingAdjustmentTypeExactCapacity = "ExactCapacity"

	// ScalingAdjustmentTypePercentChangeInCapacity is a ScalingAdjustmentType enum value
	ScalingAdjustmentTypePercentChangeInCapacity = "PercentChangeInCapacity"
)

const (
	// ScalingStatusTypeActive is a ScalingStatusType enum value
	ScalingStatusTypeActive = "ACTIVE"

	// ScalingStatusTypeUpdateRequested is a ScalingStatusType enum value
	ScalingStatusTypeUpdateRequested = "UPDATE_REQUESTED"

	// ScalingStatusTypeUpdating is a ScalingStatusType enum value
	ScalingStatusTypeUpdating = "UPDATING"

	// ScalingStatusTypeDeleteRequested is a ScalingStatusType enum value
	ScalingStatusTypeDeleteRequested = "DELETE_REQUESTED"

	// ScalingStatusTypeDeleting is a ScalingStatusType enum value
	ScalingStatusTypeDeleting = "DELETING"

	// ScalingStatusTypeDeleted is a ScalingStatusType enum value
	ScalingStatusTypeDeleted = "DELETED"

	// ScalingStatusTypeError is a ScalingStatusType enum value
	ScalingStatusTypeError = "ERROR"
)
