// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/websecurityscanner/v1beta/scan_config.proto

package websecurityscanner

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Type of user agents used for scanning.
type ScanConfig_UserAgent int32

const (
	// The user agent is unknown. Service will default to CHROME_LINUX.
	ScanConfig_USER_AGENT_UNSPECIFIED ScanConfig_UserAgent = 0
	// Chrome on Linux. This is the service default if unspecified.
	ScanConfig_CHROME_LINUX ScanConfig_UserAgent = 1
	// Chrome on Android.
	ScanConfig_CHROME_ANDROID ScanConfig_UserAgent = 2
	// Safari on IPhone.
	ScanConfig_SAFARI_IPHONE ScanConfig_UserAgent = 3
)

var ScanConfig_UserAgent_name = map[int32]string{
	0: "USER_AGENT_UNSPECIFIED",
	1: "CHROME_LINUX",
	2: "CHROME_ANDROID",
	3: "SAFARI_IPHONE",
}

var ScanConfig_UserAgent_value = map[string]int32{
	"USER_AGENT_UNSPECIFIED": 0,
	"CHROME_LINUX":           1,
	"CHROME_ANDROID":         2,
	"SAFARI_IPHONE":          3,
}

func (x ScanConfig_UserAgent) String() string {
	return proto.EnumName(ScanConfig_UserAgent_name, int32(x))
}

func (ScanConfig_UserAgent) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0b8e0c37c8759a6e, []int{0, 0}
}

// Cloud platforms supported by Cloud Web Security Scanner.
type ScanConfig_TargetPlatform int32

const (
	// The target platform is unknown. Requests with this enum value will be
	// rejected with INVALID_ARGUMENT error.
	ScanConfig_TARGET_PLATFORM_UNSPECIFIED ScanConfig_TargetPlatform = 0
	// Google App Engine service.
	ScanConfig_APP_ENGINE ScanConfig_TargetPlatform = 1
	// Google Compute Engine service.
	ScanConfig_COMPUTE ScanConfig_TargetPlatform = 2
)

var ScanConfig_TargetPlatform_name = map[int32]string{
	0: "TARGET_PLATFORM_UNSPECIFIED",
	1: "APP_ENGINE",
	2: "COMPUTE",
}

var ScanConfig_TargetPlatform_value = map[string]int32{
	"TARGET_PLATFORM_UNSPECIFIED": 0,
	"APP_ENGINE":                  1,
	"COMPUTE":                     2,
}

func (x ScanConfig_TargetPlatform) String() string {
	return proto.EnumName(ScanConfig_TargetPlatform_name, int32(x))
}

func (ScanConfig_TargetPlatform) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0b8e0c37c8759a6e, []int{0, 1}
}

// Scan risk levels supported by Cloud Web Security Scanner. LOW impact
// scanning will minimize requests with the potential to modify data. To
// achieve the maximum scan coverage, NORMAL risk level is recommended.
type ScanConfig_RiskLevel int32

const (
	// Use default, which is NORMAL.
	ScanConfig_RISK_LEVEL_UNSPECIFIED ScanConfig_RiskLevel = 0
	// Normal scanning (Recommended)
	ScanConfig_NORMAL ScanConfig_RiskLevel = 1
	// Lower impact scanning
	ScanConfig_LOW ScanConfig_RiskLevel = 2
)

var ScanConfig_RiskLevel_name = map[int32]string{
	0: "RISK_LEVEL_UNSPECIFIED",
	1: "NORMAL",
	2: "LOW",
}

var ScanConfig_RiskLevel_value = map[string]int32{
	"RISK_LEVEL_UNSPECIFIED": 0,
	"NORMAL":                 1,
	"LOW":                    2,
}

func (x ScanConfig_RiskLevel) String() string {
	return proto.EnumName(ScanConfig_RiskLevel_name, int32(x))
}

func (ScanConfig_RiskLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0b8e0c37c8759a6e, []int{0, 2}
}

// Controls export of scan configurations and results to Cloud Security
// Command Center.
type ScanConfig_ExportToSecurityCommandCenter int32

const (
	// Use default, which is ENABLED.
	ScanConfig_EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED ScanConfig_ExportToSecurityCommandCenter = 0
	// Export results of this scan to Cloud Security Command Center.
	ScanConfig_ENABLED ScanConfig_ExportToSecurityCommandCenter = 1
	// Do not export results of this scan to Cloud Security Command Center.
	ScanConfig_DISABLED ScanConfig_ExportToSecurityCommandCenter = 2
)

var ScanConfig_ExportToSecurityCommandCenter_name = map[int32]string{
	0: "EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED",
	1: "ENABLED",
	2: "DISABLED",
}

var ScanConfig_ExportToSecurityCommandCenter_value = map[string]int32{
	"EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED": 0,
	"ENABLED":  1,
	"DISABLED": 2,
}

func (x ScanConfig_ExportToSecurityCommandCenter) String() string {
	return proto.EnumName(ScanConfig_ExportToSecurityCommandCenter_name, int32(x))
}

func (ScanConfig_ExportToSecurityCommandCenter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0b8e0c37c8759a6e, []int{0, 3}
}

// A ScanConfig resource contains the configurations to launch a scan.
type ScanConfig struct {
	// The resource name of the ScanConfig. The name follows the format of
	// 'projects/{projectId}/scanConfigs/{scanConfigId}'. The ScanConfig IDs are
	// generated by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required.
	// The user provided display name of the ScanConfig.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The maximum QPS during scanning. A valid value ranges from 5 to 20
	// inclusively. If the field is unspecified or its value is set 0, server will
	// default to 15. Other values outside of [5, 20] range will be rejected with
	// INVALID_ARGUMENT error.
	MaxQps int32 `protobuf:"varint,3,opt,name=max_qps,json=maxQps,proto3" json:"max_qps,omitempty"`
	// Required.
	// The starting URLs from which the scanner finds site pages.
	StartingUrls []string `protobuf:"bytes,4,rep,name=starting_urls,json=startingUrls,proto3" json:"starting_urls,omitempty"`
	// The authentication configuration. If specified, service will use the
	// authentication configuration during scanning.
	Authentication *ScanConfig_Authentication `protobuf:"bytes,5,opt,name=authentication,proto3" json:"authentication,omitempty"`
	// The user agent used during scanning.
	UserAgent ScanConfig_UserAgent `protobuf:"varint,6,opt,name=user_agent,json=userAgent,proto3,enum=google.cloud.websecurityscanner.v1beta.ScanConfig_UserAgent" json:"user_agent,omitempty"`
	// The blacklist URL patterns as described in
	// https://cloud.google.com/security-scanner/docs/excluded-urls
	BlacklistPatterns []string `protobuf:"bytes,7,rep,name=blacklist_patterns,json=blacklistPatterns,proto3" json:"blacklist_patterns,omitempty"`
	// The schedule of the ScanConfig.
	Schedule *ScanConfig_Schedule `protobuf:"bytes,8,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be
	// used as a default.
	TargetPlatforms []ScanConfig_TargetPlatform `protobuf:"varint,9,rep,packed,name=target_platforms,json=targetPlatforms,proto3,enum=google.cloud.websecurityscanner.v1beta.ScanConfig_TargetPlatform" json:"target_platforms,omitempty"`
	// Controls export of scan configurations and results to Cloud Security
	// Command Center.
	ExportToSecurityCommandCenter ScanConfig_ExportToSecurityCommandCenter `protobuf:"varint,10,opt,name=export_to_security_command_center,json=exportToSecurityCommandCenter,proto3,enum=google.cloud.websecurityscanner.v1beta.ScanConfig_ExportToSecurityCommandCenter" json:"export_to_security_command_center,omitempty"`
	// Latest ScanRun if available.
	LatestRun *ScanRun `protobuf:"bytes,11,opt,name=latest_run,json=latestRun,proto3" json:"latest_run,omitempty"`
	// The risk level selected for the scan
	RiskLevel            ScanConfig_RiskLevel `protobuf:"varint,12,opt,name=risk_level,json=riskLevel,proto3,enum=google.cloud.websecurityscanner.v1beta.ScanConfig_RiskLevel" json:"risk_level,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ScanConfig) Reset()         { *m = ScanConfig{} }
func (m *ScanConfig) String() string { return proto.CompactTextString(m) }
func (*ScanConfig) ProtoMessage()    {}
func (*ScanConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b8e0c37c8759a6e, []int{0}
}

func (m *ScanConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig.Unmarshal(m, b)
}
func (m *ScanConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig.Marshal(b, m, deterministic)
}
func (m *ScanConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig.Merge(m, src)
}
func (m *ScanConfig) XXX_Size() int {
	return xxx_messageInfo_ScanConfig.Size(m)
}
func (m *ScanConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig proto.InternalMessageInfo

func (m *ScanConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ScanConfig) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ScanConfig) GetMaxQps() int32 {
	if m != nil {
		return m.MaxQps
	}
	return 0
}

func (m *ScanConfig) GetStartingUrls() []string {
	if m != nil {
		return m.StartingUrls
	}
	return nil
}

func (m *ScanConfig) GetAuthentication() *ScanConfig_Authentication {
	if m != nil {
		return m.Authentication
	}
	return nil
}

func (m *ScanConfig) GetUserAgent() ScanConfig_UserAgent {
	if m != nil {
		return m.UserAgent
	}
	return ScanConfig_USER_AGENT_UNSPECIFIED
}

func (m *ScanConfig) GetBlacklistPatterns() []string {
	if m != nil {
		return m.BlacklistPatterns
	}
	return nil
}

func (m *ScanConfig) GetSchedule() *ScanConfig_Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *ScanConfig) GetTargetPlatforms() []ScanConfig_TargetPlatform {
	if m != nil {
		return m.TargetPlatforms
	}
	return nil
}

func (m *ScanConfig) GetExportToSecurityCommandCenter() ScanConfig_ExportToSecurityCommandCenter {
	if m != nil {
		return m.ExportToSecurityCommandCenter
	}
	return ScanConfig_EXPORT_TO_SECURITY_COMMAND_CENTER_UNSPECIFIED
}

func (m *ScanConfig) GetLatestRun() *ScanRun {
	if m != nil {
		return m.LatestRun
	}
	return nil
}

func (m *ScanConfig) GetRiskLevel() ScanConfig_RiskLevel {
	if m != nil {
		return m.RiskLevel
	}
	return ScanConfig_RISK_LEVEL_UNSPECIFIED
}

// Scan authentication configuration.
type ScanConfig_Authentication struct {
	// Required.
	// Authentication configuration
	//
	// Types that are valid to be assigned to Authentication:
	//	*ScanConfig_Authentication_GoogleAccount_
	//	*ScanConfig_Authentication_CustomAccount_
	Authentication       isScanConfig_Authentication_Authentication `protobuf_oneof:"authentication"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *ScanConfig_Authentication) Reset()         { *m = ScanConfig_Authentication{} }
func (m *ScanConfig_Authentication) String() string { return proto.CompactTextString(m) }
func (*ScanConfig_Authentication) ProtoMessage()    {}
func (*ScanConfig_Authentication) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b8e0c37c8759a6e, []int{0, 0}
}

func (m *ScanConfig_Authentication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Authentication.Unmarshal(m, b)
}
func (m *ScanConfig_Authentication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Authentication.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Authentication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Authentication.Merge(m, src)
}
func (m *ScanConfig_Authentication) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Authentication.Size(m)
}
func (m *ScanConfig_Authentication) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Authentication.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Authentication proto.InternalMessageInfo

type isScanConfig_Authentication_Authentication interface {
	isScanConfig_Authentication_Authentication()
}

type ScanConfig_Authentication_GoogleAccount_ struct {
	GoogleAccount *ScanConfig_Authentication_GoogleAccount `protobuf:"bytes,1,opt,name=google_account,json=googleAccount,proto3,oneof"`
}

type ScanConfig_Authentication_CustomAccount_ struct {
	CustomAccount *ScanConfig_Authentication_CustomAccount `protobuf:"bytes,2,opt,name=custom_account,json=customAccount,proto3,oneof"`
}

func (*ScanConfig_Authentication_GoogleAccount_) isScanConfig_Authentication_Authentication() {}

func (*ScanConfig_Authentication_CustomAccount_) isScanConfig_Authentication_Authentication() {}

func (m *ScanConfig_Authentication) GetAuthentication() isScanConfig_Authentication_Authentication {
	if m != nil {
		return m.Authentication
	}
	return nil
}

func (m *ScanConfig_Authentication) GetGoogleAccount() *ScanConfig_Authentication_GoogleAccount {
	if x, ok := m.GetAuthentication().(*ScanConfig_Authentication_GoogleAccount_); ok {
		return x.GoogleAccount
	}
	return nil
}

func (m *ScanConfig_Authentication) GetCustomAccount() *ScanConfig_Authentication_CustomAccount {
	if x, ok := m.GetAuthentication().(*ScanConfig_Authentication_CustomAccount_); ok {
		return x.CustomAccount
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScanConfig_Authentication) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScanConfig_Authentication_GoogleAccount_)(nil),
		(*ScanConfig_Authentication_CustomAccount_)(nil),
	}
}

// Describes authentication configuration that uses a Google account.
type ScanConfig_Authentication_GoogleAccount struct {
	// Required.
	// The user name of the Google account.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Input only.
	// Required.
	// The password of the Google account. The credential is stored encrypted
	// and not returned in any response nor included in audit logs.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanConfig_Authentication_GoogleAccount) Reset() {
	*m = ScanConfig_Authentication_GoogleAccount{}
}
func (m *ScanConfig_Authentication_GoogleAccount) String() string { return proto.CompactTextString(m) }
func (*ScanConfig_Authentication_GoogleAccount) ProtoMessage()    {}
func (*ScanConfig_Authentication_GoogleAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b8e0c37c8759a6e, []int{0, 0, 0}
}

func (m *ScanConfig_Authentication_GoogleAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.Unmarshal(m, b)
}
func (m *ScanConfig_Authentication_GoogleAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Authentication_GoogleAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.Merge(m, src)
}
func (m *ScanConfig_Authentication_GoogleAccount) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.Size(m)
}
func (m *ScanConfig_Authentication_GoogleAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Authentication_GoogleAccount.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Authentication_GoogleAccount proto.InternalMessageInfo

func (m *ScanConfig_Authentication_GoogleAccount) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *ScanConfig_Authentication_GoogleAccount) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

// Describes authentication configuration that uses a custom account.
type ScanConfig_Authentication_CustomAccount struct {
	// Required.
	// The user name of the custom account.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Input only.
	// Required.
	// The password of the custom account. The credential is stored encrypted
	// and not returned in any response nor included in audit logs.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// Required.
	// The login form URL of the website.
	LoginUrl             string   `protobuf:"bytes,3,opt,name=login_url,json=loginUrl,proto3" json:"login_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanConfig_Authentication_CustomAccount) Reset() {
	*m = ScanConfig_Authentication_CustomAccount{}
}
func (m *ScanConfig_Authentication_CustomAccount) String() string { return proto.CompactTextString(m) }
func (*ScanConfig_Authentication_CustomAccount) ProtoMessage()    {}
func (*ScanConfig_Authentication_CustomAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b8e0c37c8759a6e, []int{0, 0, 1}
}

func (m *ScanConfig_Authentication_CustomAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Authentication_CustomAccount.Unmarshal(m, b)
}
func (m *ScanConfig_Authentication_CustomAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Authentication_CustomAccount.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Authentication_CustomAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Authentication_CustomAccount.Merge(m, src)
}
func (m *ScanConfig_Authentication_CustomAccount) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Authentication_CustomAccount.Size(m)
}
func (m *ScanConfig_Authentication_CustomAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Authentication_CustomAccount.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Authentication_CustomAccount proto.InternalMessageInfo

func (m *ScanConfig_Authentication_CustomAccount) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *ScanConfig_Authentication_CustomAccount) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *ScanConfig_Authentication_CustomAccount) GetLoginUrl() string {
	if m != nil {
		return m.LoginUrl
	}
	return ""
}

// Scan schedule configuration.
type ScanConfig_Schedule struct {
	// A timestamp indicates when the next run will be scheduled. The value is
	// refreshed by the server after each run. If unspecified, it will default
	// to current server time, which means the scan will be scheduled to start
	// immediately.
	ScheduleTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=schedule_time,json=scheduleTime,proto3" json:"schedule_time,omitempty"`
	// Required.
	// The duration of time between executions in days.
	IntervalDurationDays int32    `protobuf:"varint,2,opt,name=interval_duration_days,json=intervalDurationDays,proto3" json:"interval_duration_days,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanConfig_Schedule) Reset()         { *m = ScanConfig_Schedule{} }
func (m *ScanConfig_Schedule) String() string { return proto.CompactTextString(m) }
func (*ScanConfig_Schedule) ProtoMessage()    {}
func (*ScanConfig_Schedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b8e0c37c8759a6e, []int{0, 1}
}

func (m *ScanConfig_Schedule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanConfig_Schedule.Unmarshal(m, b)
}
func (m *ScanConfig_Schedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanConfig_Schedule.Marshal(b, m, deterministic)
}
func (m *ScanConfig_Schedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanConfig_Schedule.Merge(m, src)
}
func (m *ScanConfig_Schedule) XXX_Size() int {
	return xxx_messageInfo_ScanConfig_Schedule.Size(m)
}
func (m *ScanConfig_Schedule) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanConfig_Schedule.DiscardUnknown(m)
}

var xxx_messageInfo_ScanConfig_Schedule proto.InternalMessageInfo

func (m *ScanConfig_Schedule) GetScheduleTime() *timestamp.Timestamp {
	if m != nil {
		return m.ScheduleTime
	}
	return nil
}

func (m *ScanConfig_Schedule) GetIntervalDurationDays() int32 {
	if m != nil {
		return m.IntervalDurationDays
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.cloud.websecurityscanner.v1beta.ScanConfig_UserAgent", ScanConfig_UserAgent_name, ScanConfig_UserAgent_value)
	proto.RegisterEnum("google.cloud.websecurityscanner.v1beta.ScanConfig_TargetPlatform", ScanConfig_TargetPlatform_name, ScanConfig_TargetPlatform_value)
	proto.RegisterEnum("google.cloud.websecurityscanner.v1beta.ScanConfig_RiskLevel", ScanConfig_RiskLevel_name, ScanConfig_RiskLevel_value)
	proto.RegisterEnum("google.cloud.websecurityscanner.v1beta.ScanConfig_ExportToSecurityCommandCenter", ScanConfig_ExportToSecurityCommandCenter_name, ScanConfig_ExportToSecurityCommandCenter_value)
	proto.RegisterType((*ScanConfig)(nil), "google.cloud.websecurityscanner.v1beta.ScanConfig")
	proto.RegisterType((*ScanConfig_Authentication)(nil), "google.cloud.websecurityscanner.v1beta.ScanConfig.Authentication")
	proto.RegisterType((*ScanConfig_Authentication_GoogleAccount)(nil), "google.cloud.websecurityscanner.v1beta.ScanConfig.Authentication.GoogleAccount")
	proto.RegisterType((*ScanConfig_Authentication_CustomAccount)(nil), "google.cloud.websecurityscanner.v1beta.ScanConfig.Authentication.CustomAccount")
	proto.RegisterType((*ScanConfig_Schedule)(nil), "google.cloud.websecurityscanner.v1beta.ScanConfig.Schedule")
}

func init() {
	proto.RegisterFile("google/cloud/websecurityscanner/v1beta/scan_config.proto", fileDescriptor_0b8e0c37c8759a6e)
}

var fileDescriptor_0b8e0c37c8759a6e = []byte{
	// 968 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xdd, 0x6e, 0xdb, 0x46,
	0x13, 0x0d, 0xa5, 0xc4, 0x96, 0x46, 0x3f, 0x61, 0x16, 0x1f, 0xf2, 0x09, 0x4a, 0x83, 0x28, 0x2e,
	0x10, 0x08, 0x05, 0x22, 0x21, 0x6e, 0x0b, 0x14, 0x48, 0x80, 0x82, 0x96, 0x68, 0x5b, 0xa8, 0x44,
	0xb2, 0x2b, 0x2a, 0x76, 0x5b, 0x03, 0xdb, 0x15, 0xb5, 0x66, 0x08, 0xf3, 0xaf, 0xdc, 0xa5, 0x63,
	0x5f, 0xf6, 0x35, 0xfa, 0x1c, 0x7d, 0x82, 0x02, 0xbd, 0xe9, 0x53, 0x15, 0x5c, 0x92, 0x8a, 0xe5,
	0x00, 0x69, 0xa2, 0xf6, 0x6e, 0x67, 0x66, 0xe7, 0x9c, 0xd9, 0xe1, 0xcc, 0x21, 0x7c, 0xe3, 0x46,
	0x91, 0xeb, 0xb3, 0xa1, 0xe3, 0x47, 0xe9, 0x6a, 0xf8, 0x96, 0x2d, 0x39, 0x73, 0xd2, 0xc4, 0x13,
	0xd7, 0xdc, 0xa1, 0x61, 0xc8, 0x92, 0xe1, 0xe5, 0x8b, 0x25, 0x13, 0x74, 0x98, 0x99, 0xc4, 0x89,
	0xc2, 0x73, 0xcf, 0x1d, 0xc4, 0x49, 0x24, 0x22, 0xf4, 0x2c, 0xcf, 0x1c, 0xc8, 0xcc, 0xc1, 0xfb,
	0x99, 0x83, 0x3c, 0xb3, 0xfb, 0x59, 0xc1, 0x40, 0x63, 0x6f, 0x48, 0xc3, 0x30, 0x12, 0x54, 0x78,
	0x51, 0xc8, 0x73, 0x94, 0xee, 0xd7, 0x9f, 0xc2, 0x9f, 0xa4, 0x61, 0x91, 0xf6, 0xa4, 0x48, 0x93,
	0xd6, 0x32, 0x3d, 0x1f, 0x0a, 0x2f, 0x60, 0x5c, 0xd0, 0x20, 0xce, 0x2f, 0xec, 0xfd, 0xde, 0x06,
	0x98, 0x3b, 0x34, 0x1c, 0xc9, 0x92, 0x11, 0x82, 0xbb, 0x21, 0x0d, 0x58, 0x47, 0xe9, 0x29, 0xfd,
	0x3a, 0x96, 0x67, 0xf4, 0x14, 0x9a, 0x2b, 0x8f, 0xc7, 0x3e, 0xbd, 0x26, 0x32, 0x56, 0x91, 0xb1,
	0x46, 0xe1, 0x33, 0xb2, 0x2b, 0xff, 0x87, 0xdd, 0x80, 0x5e, 0x91, 0x5f, 0x62, 0xde, 0xa9, 0xf6,
	0x94, 0xfe, 0x3d, 0xbc, 0x13, 0xd0, 0xab, 0xef, 0x63, 0x8e, 0x3e, 0x87, 0x16, 0x17, 0x34, 0x11,
	0x5e, 0xe8, 0x92, 0x34, 0xf1, 0x79, 0xe7, 0x6e, 0xaf, 0xda, 0xaf, 0xe3, 0x66, 0xe9, 0x5c, 0x24,
	0x3e, 0x47, 0x1e, 0xb4, 0x69, 0x2a, 0xde, 0xb0, 0x50, 0x78, 0x8e, 0x7c, 0x74, 0xe7, 0x5e, 0x4f,
	0xe9, 0x37, 0xf6, 0xb5, 0xc1, 0xc7, 0xb5, 0x6e, 0xf0, 0xee, 0x01, 0x03, 0x6d, 0x03, 0x08, 0xdf,
	0x02, 0x46, 0x3f, 0x01, 0xa4, 0x9c, 0x25, 0x84, 0xba, 0x2c, 0x14, 0x9d, 0x9d, 0x9e, 0xd2, 0x6f,
	0xef, 0xbf, 0xda, 0x82, 0x66, 0xc1, 0x59, 0xa2, 0x65, 0x18, 0xb8, 0x9e, 0x96, 0x47, 0xf4, 0x1c,
	0xd0, 0xd2, 0xa7, 0xce, 0x85, 0xef, 0x71, 0x41, 0x62, 0x2a, 0x04, 0x4b, 0x42, 0xde, 0xd9, 0x95,
	0x2f, 0x7e, 0xb0, 0x8e, 0x58, 0x45, 0x00, 0x9d, 0x40, 0x8d, 0x3b, 0x6f, 0xd8, 0x2a, 0xf5, 0x59,
	0xa7, 0x26, 0x1f, 0xfc, 0x72, 0x8b, 0x4a, 0xe6, 0x05, 0x04, 0x5e, 0x83, 0x21, 0x1f, 0x54, 0x41,
	0x13, 0x97, 0x09, 0x12, 0xfb, 0x54, 0x9c, 0x47, 0x49, 0xc0, 0x3b, 0xf5, 0x5e, 0xb5, 0xdf, 0xde,
	0xaa, 0xa3, 0xb6, 0x84, 0xb2, 0x0a, 0x24, 0x7c, 0x5f, 0x6c, 0xd8, 0x1c, 0xfd, 0xa6, 0xc0, 0x53,
	0x76, 0x15, 0x47, 0x89, 0x20, 0x22, 0x22, 0x25, 0x1e, 0x71, 0xa2, 0x20, 0xa0, 0xe1, 0x8a, 0x38,
	0x2c, 0x14, 0x2c, 0xe9, 0x80, 0x6c, 0xb5, 0xb5, 0x05, 0xbf, 0x2e, 0xb1, 0xed, 0x68, 0x5e, 0xdc,
	0x1c, 0xe5, 0xc0, 0x23, 0x89, 0x8b, 0x1f, 0xb3, 0x0f, 0x85, 0x91, 0x01, 0xe0, 0x53, 0xc1, 0xb8,
	0xc8, 0x76, 0xa2, 0xd3, 0x90, 0x5d, 0x1e, 0x7e, 0x4a, 0x11, 0x38, 0x0d, 0x71, 0x3d, 0x87, 0xc0,
	0xa9, 0x9c, 0x9f, 0xc4, 0xe3, 0x17, 0xc4, 0x67, 0x97, 0xcc, 0xef, 0x34, 0xb7, 0x9e, 0x1f, 0xec,
	0xf1, 0x8b, 0x69, 0x86, 0x81, 0xeb, 0x49, 0x79, 0xec, 0xfe, 0x59, 0x85, 0xf6, 0xe6, 0xfc, 0xa2,
	0x2b, 0x68, 0xe7, 0xe0, 0x84, 0x3a, 0x4e, 0x94, 0x86, 0x42, 0x6e, 0x66, 0x63, 0xdf, 0xfc, 0xd7,
	0xab, 0x31, 0x38, 0x92, 0x00, 0x5a, 0x0e, 0x7b, 0x7c, 0x07, 0xb7, 0xdc, 0x9b, 0x8e, 0x8c, 0xd9,
	0x49, 0xb9, 0x88, 0x82, 0x35, 0x73, 0xe5, 0xbf, 0x62, 0x1e, 0x49, 0xdc, 0x1b, 0xcc, 0xce, 0x4d,
	0x47, 0xf7, 0x08, 0x5a, 0x1b, 0xb5, 0xa1, 0x2e, 0xd4, 0xb2, 0x25, 0xbb, 0x21, 0x4c, 0x6b, 0x3b,
	0x8b, 0xc5, 0x94, 0xf3, 0xb7, 0x51, 0xb2, 0x2a, 0x84, 0x69, 0x6d, 0x77, 0x57, 0xd0, 0xda, 0xa0,
	0xda, 0x16, 0x08, 0x3d, 0x82, 0xba, 0x1f, 0xb9, 0x5e, 0x98, 0x49, 0x98, 0x14, 0xb8, 0x3a, 0xae,
	0x49, 0xc7, 0x22, 0xf1, 0x0f, 0xd4, 0xdb, 0xea, 0xd5, 0xfd, 0x55, 0x81, 0x5a, 0xb9, 0x96, 0xe8,
	0x5b, 0x68, 0x95, 0x8b, 0x49, 0x32, 0xf1, 0x2d, 0x3e, 0x60, 0xb7, 0x6c, 0x63, 0xa9, 0xcc, 0x03,
	0xbb, 0x54, 0x66, 0xdc, 0x2c, 0x13, 0x32, 0x17, 0xfa, 0x0a, 0x1e, 0x7a, 0xd9, 0x2c, 0x5f, 0x52,
	0x9f, 0xac, 0xd2, 0x44, 0x52, 0x90, 0x15, 0xbd, 0xe6, 0xb2, 0xcc, 0x7b, 0xf8, 0x7f, 0x65, 0x74,
	0x5c, 0x04, 0xc7, 0xf4, 0x9a, 0xef, 0xfd, 0x0c, 0xf5, 0xb5, 0x46, 0xa1, 0x2e, 0x3c, 0x5c, 0xcc,
	0x75, 0x4c, 0xb4, 0x23, 0xdd, 0xb0, 0xc9, 0xc2, 0x98, 0x5b, 0xfa, 0x68, 0x72, 0x38, 0xd1, 0xc7,
	0xea, 0x1d, 0xa4, 0x42, 0x73, 0x74, 0x8c, 0xcd, 0x99, 0x4e, 0xa6, 0x13, 0x63, 0x71, 0xaa, 0x2a,
	0x08, 0x41, 0xbb, 0xf0, 0x68, 0xc6, 0x18, 0x9b, 0x93, 0xb1, 0x5a, 0x41, 0x0f, 0xa0, 0x35, 0xd7,
	0x0e, 0x35, 0x3c, 0x21, 0x13, 0xeb, 0xd8, 0x34, 0x74, 0xb5, 0xba, 0x67, 0x40, 0x7b, 0x53, 0x1a,
	0xd0, 0x13, 0x78, 0x64, 0x6b, 0xf8, 0x48, 0xb7, 0x89, 0x35, 0xd5, 0xec, 0x43, 0x13, 0xcf, 0x6e,
	0x71, 0xb5, 0x01, 0x34, 0xcb, 0x22, 0xba, 0x71, 0x34, 0x31, 0x74, 0x55, 0x41, 0x0d, 0xd8, 0x1d,
	0x99, 0x33, 0x6b, 0x61, 0xeb, 0x6a, 0x65, 0xef, 0x15, 0xd4, 0xd7, 0x5b, 0x91, 0x55, 0x8c, 0x27,
	0xf3, 0xef, 0xc8, 0x54, 0x7f, 0xad, 0x4f, 0x6f, 0xa1, 0x00, 0xec, 0x18, 0x26, 0x9e, 0x69, 0x53,
	0x55, 0x41, 0xbb, 0x50, 0x9d, 0x9a, 0x27, 0x6a, 0x65, 0x2f, 0x80, 0xc7, 0x1f, 0x14, 0x0a, 0xf4,
	0x02, 0x9e, 0xeb, 0xa7, 0x96, 0x89, 0x6d, 0x62, 0x9b, 0x64, 0xae, 0x8f, 0x16, 0x78, 0x62, 0xff,
	0x40, 0x46, 0xe6, 0x6c, 0xa6, 0x19, 0x63, 0x32, 0xd2, 0x0d, 0x5b, 0xc7, 0xb7, 0x88, 0x1a, 0xb0,
	0xab, 0x1b, 0xda, 0xc1, 0x54, 0x1f, 0xab, 0x0a, 0x6a, 0x42, 0x6d, 0x3c, 0x99, 0xe7, 0x56, 0xe5,
	0xe0, 0x0f, 0x05, 0xbe, 0x70, 0xa2, 0xe0, 0x23, 0x77, 0xe1, 0xe0, 0xfe, 0xbb, 0x65, 0xb0, 0xb2,
	0xef, 0x6d, 0x29, 0x3f, 0x9e, 0x16, 0xa9, 0x6e, 0xe4, 0xd3, 0xd0, 0x1d, 0x44, 0x89, 0x3b, 0x74,
	0x59, 0x28, 0xa7, 0x61, 0x98, 0x87, 0x68, 0xec, 0xf1, 0x7f, 0xfa, 0xdf, 0xbf, 0x7c, 0x3f, 0xf2,
	0x57, 0xe5, 0x59, 0xbe, 0x3e, 0x67, 0xa3, 0x2c, 0xf7, 0xec, 0x84, 0x2d, 0xcb, 0x8e, 0xcc, 0xf3,
	0x1b, 0x67, 0xaf, 0x65, 0xee, 0x72, 0x47, 0xb2, 0x7d, 0xf9, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x36, 0xf5, 0x50, 0x43, 0xdc, 0x08, 0x00, 0x00,
}
