package openshift

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	bindingDiscoveryFileName = "binding-discovery.yaml"
)

var _ asset.WritableAsset = (*BindingDiscovery)(nil)

// BindingDiscovery  is the variable/constant representing the contents of the respective file
type BindingDiscovery struct {
	fileName string
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *BindingDiscovery) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *BindingDiscovery) Name() string {
	return "BindingDiscovery"
}

// Generate generates the actual files by this asset
func (t *BindingDiscovery) Generate(parents asset.Parents) error {
	t.fileName = bindingDiscoveryFileName
	data, err := content.GetOpenshiftTemplate(t.fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, t.fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *BindingDiscovery) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *BindingDiscovery) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, bindingDiscoveryFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
