// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconnect

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddFlowOutputs = "AddFlowOutputs"

// AddFlowOutputsRequest generates a "aws/request.Request" representing the
// client's request for the AddFlowOutputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddFlowOutputs for more information on using the AddFlowOutputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddFlowOutputsRequest method.
//    req, resp := client.AddFlowOutputsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs
func (c *MediaConnect) AddFlowOutputsRequest(input *AddFlowOutputsInput) (req *request.Request, output *AddFlowOutputsOutput) {
	op := &request.Operation{
		Name:       opAddFlowOutputs,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/outputs",
	}

	if input == nil {
		input = &AddFlowOutputsInput{}
	}

	output = &AddFlowOutputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddFlowOutputs API operation for AWS MediaConnect.
//
// Adds outputs to an existing flow. You can create up to 20 outputs per flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddFlowOutputs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAddFlowOutputs420Exception "AddFlowOutputs420Exception"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs
func (c *MediaConnect) AddFlowOutputs(input *AddFlowOutputsInput) (*AddFlowOutputsOutput, error) {
	req, out := c.AddFlowOutputsRequest(input)
	return out, req.Send()
}

// AddFlowOutputsWithContext is the same as AddFlowOutputs with the addition of
// the ability to pass a context and additional request options.
//
// See AddFlowOutputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddFlowOutputsWithContext(ctx aws.Context, input *AddFlowOutputsInput, opts ...request.Option) (*AddFlowOutputsOutput, error) {
	req, out := c.AddFlowOutputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlow = "CreateFlow"

// CreateFlowRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlow for more information on using the CreateFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFlowRequest method.
//    req, resp := client.CreateFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow
func (c *MediaConnect) CreateFlowRequest(input *CreateFlowInput) (req *request.Request, output *CreateFlowOutput) {
	op := &request.Operation{
		Name:       opCreateFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows",
	}

	if input == nil {
		input = &CreateFlowInput{}
	}

	output = &CreateFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlow API operation for AWS MediaConnect.
//
// Creates a new flow. The request must include one source. The request optionally
// can include outputs (up to 20) and entitlements (up to 50).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation CreateFlow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCreateFlow420Exception "CreateFlow420Exception"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow
func (c *MediaConnect) CreateFlow(input *CreateFlowInput) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	return out, req.Send()
}

// CreateFlowWithContext is the same as CreateFlow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) CreateFlowWithContext(ctx aws.Context, input *CreateFlowInput, opts ...request.Option) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlow = "DeleteFlow"

// DeleteFlowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlow for more information on using the DeleteFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFlowRequest method.
//    req, resp := client.DeleteFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow
func (c *MediaConnect) DeleteFlowRequest(input *DeleteFlowInput) (req *request.Request, output *DeleteFlowOutput) {
	op := &request.Operation{
		Name:       opDeleteFlow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}",
	}

	if input == nil {
		input = &DeleteFlowInput{}
	}

	output = &DeleteFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFlow API operation for AWS MediaConnect.
//
// Deletes a flow. Before you can delete a flow, you must stop the flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DeleteFlow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow
func (c *MediaConnect) DeleteFlow(input *DeleteFlowInput) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	return out, req.Send()
}

// DeleteFlowWithContext is the same as DeleteFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DeleteFlowWithContext(ctx aws.Context, input *DeleteFlowInput, opts ...request.Option) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlow = "DescribeFlow"

// DescribeFlowRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlow for more information on using the DescribeFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFlowRequest method.
//    req, resp := client.DescribeFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow
func (c *MediaConnect) DescribeFlowRequest(input *DescribeFlowInput) (req *request.Request, output *DescribeFlowOutput) {
	op := &request.Operation{
		Name:       opDescribeFlow,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/flows/{flowArn}",
	}

	if input == nil {
		input = &DescribeFlowInput{}
	}

	output = &DescribeFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlow API operation for AWS MediaConnect.
//
// Displays the details of a flow. The response includes the flow ARN, name,
// and Availability Zone, as well as details about the source, outputs, and
// entitlements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DescribeFlow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow
func (c *MediaConnect) DescribeFlow(input *DescribeFlowInput) (*DescribeFlowOutput, error) {
	req, out := c.DescribeFlowRequest(input)
	return out, req.Send()
}

// DescribeFlowWithContext is the same as DescribeFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DescribeFlowWithContext(ctx aws.Context, input *DescribeFlowInput, opts ...request.Option) (*DescribeFlowOutput, error) {
	req, out := c.DescribeFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGrantFlowEntitlements = "GrantFlowEntitlements"

// GrantFlowEntitlementsRequest generates a "aws/request.Request" representing the
// client's request for the GrantFlowEntitlements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GrantFlowEntitlements for more information on using the GrantFlowEntitlements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GrantFlowEntitlementsRequest method.
//    req, resp := client.GrantFlowEntitlementsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements
func (c *MediaConnect) GrantFlowEntitlementsRequest(input *GrantFlowEntitlementsInput) (req *request.Request, output *GrantFlowEntitlementsOutput) {
	op := &request.Operation{
		Name:       opGrantFlowEntitlements,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements",
	}

	if input == nil {
		input = &GrantFlowEntitlementsInput{}
	}

	output = &GrantFlowEntitlementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GrantFlowEntitlements API operation for AWS MediaConnect.
//
// Grants entitlements to an existing flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation GrantFlowEntitlements for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGrantFlowEntitlements420Exception "GrantFlowEntitlements420Exception"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements
func (c *MediaConnect) GrantFlowEntitlements(input *GrantFlowEntitlementsInput) (*GrantFlowEntitlementsOutput, error) {
	req, out := c.GrantFlowEntitlementsRequest(input)
	return out, req.Send()
}

// GrantFlowEntitlementsWithContext is the same as GrantFlowEntitlements with the addition of
// the ability to pass a context and additional request options.
//
// See GrantFlowEntitlements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) GrantFlowEntitlementsWithContext(ctx aws.Context, input *GrantFlowEntitlementsInput, opts ...request.Option) (*GrantFlowEntitlementsOutput, error) {
	req, out := c.GrantFlowEntitlementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEntitlements = "ListEntitlements"

// ListEntitlementsRequest generates a "aws/request.Request" representing the
// client's request for the ListEntitlements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntitlements for more information on using the ListEntitlements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEntitlementsRequest method.
//    req, resp := client.ListEntitlementsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements
func (c *MediaConnect) ListEntitlementsRequest(input *ListEntitlementsInput) (req *request.Request, output *ListEntitlementsOutput) {
	op := &request.Operation{
		Name:       opListEntitlements,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/entitlements",
	}

	if input == nil {
		input = &ListEntitlementsInput{}
	}

	output = &ListEntitlementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntitlements API operation for AWS MediaConnect.
//
// Displays a list of all entitlements that have been granted to this account.
// This request returns 20 results per page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListEntitlements for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements
func (c *MediaConnect) ListEntitlements(input *ListEntitlementsInput) (*ListEntitlementsOutput, error) {
	req, out := c.ListEntitlementsRequest(input)
	return out, req.Send()
}

// ListEntitlementsWithContext is the same as ListEntitlements with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntitlements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListEntitlementsWithContext(ctx aws.Context, input *ListEntitlementsInput, opts ...request.Option) (*ListEntitlementsOutput, error) {
	req, out := c.ListEntitlementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFlows = "ListFlows"

// ListFlowsRequest generates a "aws/request.Request" representing the
// client's request for the ListFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlows for more information on using the ListFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFlowsRequest method.
//    req, resp := client.ListFlowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows
func (c *MediaConnect) ListFlowsRequest(input *ListFlowsInput) (req *request.Request, output *ListFlowsOutput) {
	op := &request.Operation{
		Name:       opListFlows,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/flows",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowsInput{}
	}

	output = &ListFlowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlows API operation for AWS MediaConnect.
//
// Displays a list of flows that are associated with this account. This request
// returns a paginated result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListFlows for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows
func (c *MediaConnect) ListFlows(input *ListFlowsInput) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	return out, req.Send()
}

// ListFlowsWithContext is the same as ListFlows with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListFlowsWithContext(ctx aws.Context, input *ListFlowsInput, opts ...request.Option) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowsPages iterates over the pages of a ListFlows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFlows operation.
//    pageNum := 0
//    err := client.ListFlowsPages(params,
//        func(page *ListFlowsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaConnect) ListFlowsPages(input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool) error {
	return c.ListFlowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowsPagesWithContext same as ListFlowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListFlowsPagesWithContext(ctx aws.Context, input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListFlowsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opRemoveFlowOutput = "RemoveFlowOutput"

// RemoveFlowOutputRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFlowOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFlowOutput for more information on using the RemoveFlowOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveFlowOutputRequest method.
//    req, resp := client.RemoveFlowOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput
func (c *MediaConnect) RemoveFlowOutputRequest(input *RemoveFlowOutputInput) (req *request.Request, output *RemoveFlowOutputOutput) {
	op := &request.Operation{
		Name:       opRemoveFlowOutput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/outputs/{outputArn}",
	}

	if input == nil {
		input = &RemoveFlowOutputInput{}
	}

	output = &RemoveFlowOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFlowOutput API operation for AWS MediaConnect.
//
// Removes an output from an existing flow. This request can be made only on
// an output that does not have an entitlement associated with it. If the output
// has an entitlement, you must revoke the entitlement instead. When an entitlement
// is revoked from a flow, the service automatically removes the associated
// output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveFlowOutput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput
func (c *MediaConnect) RemoveFlowOutput(input *RemoveFlowOutputInput) (*RemoveFlowOutputOutput, error) {
	req, out := c.RemoveFlowOutputRequest(input)
	return out, req.Send()
}

// RemoveFlowOutputWithContext is the same as RemoveFlowOutput with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFlowOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveFlowOutputWithContext(ctx aws.Context, input *RemoveFlowOutputInput, opts ...request.Option) (*RemoveFlowOutputOutput, error) {
	req, out := c.RemoveFlowOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeFlowEntitlement = "RevokeFlowEntitlement"

// RevokeFlowEntitlementRequest generates a "aws/request.Request" representing the
// client's request for the RevokeFlowEntitlement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeFlowEntitlement for more information on using the RevokeFlowEntitlement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeFlowEntitlementRequest method.
//    req, resp := client.RevokeFlowEntitlementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement
func (c *MediaConnect) RevokeFlowEntitlementRequest(input *RevokeFlowEntitlementInput) (req *request.Request, output *RevokeFlowEntitlementOutput) {
	op := &request.Operation{
		Name:       opRevokeFlowEntitlement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements/{entitlementArn}",
	}

	if input == nil {
		input = &RevokeFlowEntitlementInput{}
	}

	output = &RevokeFlowEntitlementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeFlowEntitlement API operation for AWS MediaConnect.
//
// Revokes an entitlement from a flow. Once an entitlement is revoked, the content
// becomes unavailable to the subscriber and the associated output is removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RevokeFlowEntitlement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement
func (c *MediaConnect) RevokeFlowEntitlement(input *RevokeFlowEntitlementInput) (*RevokeFlowEntitlementOutput, error) {
	req, out := c.RevokeFlowEntitlementRequest(input)
	return out, req.Send()
}

// RevokeFlowEntitlementWithContext is the same as RevokeFlowEntitlement with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeFlowEntitlement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RevokeFlowEntitlementWithContext(ctx aws.Context, input *RevokeFlowEntitlementInput, opts ...request.Option) (*RevokeFlowEntitlementOutput, error) {
	req, out := c.RevokeFlowEntitlementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFlow = "StartFlow"

// StartFlowRequest generates a "aws/request.Request" representing the
// client's request for the StartFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFlow for more information on using the StartFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartFlowRequest method.
//    req, resp := client.StartFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow
func (c *MediaConnect) StartFlowRequest(input *StartFlowInput) (req *request.Request, output *StartFlowOutput) {
	op := &request.Operation{
		Name:       opStartFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/start/{flowArn}",
	}

	if input == nil {
		input = &StartFlowInput{}
	}

	output = &StartFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFlow API operation for AWS MediaConnect.
//
// Starts a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation StartFlow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow
func (c *MediaConnect) StartFlow(input *StartFlowInput) (*StartFlowOutput, error) {
	req, out := c.StartFlowRequest(input)
	return out, req.Send()
}

// StartFlowWithContext is the same as StartFlow with the addition of
// the ability to pass a context and additional request options.
//
// See StartFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) StartFlowWithContext(ctx aws.Context, input *StartFlowInput, opts ...request.Option) (*StartFlowOutput, error) {
	req, out := c.StartFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopFlow = "StopFlow"

// StopFlowRequest generates a "aws/request.Request" representing the
// client's request for the StopFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopFlow for more information on using the StopFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopFlowRequest method.
//    req, resp := client.StopFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow
func (c *MediaConnect) StopFlowRequest(input *StopFlowInput) (req *request.Request, output *StopFlowOutput) {
	op := &request.Operation{
		Name:       opStopFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/stop/{flowArn}",
	}

	if input == nil {
		input = &StopFlowInput{}
	}

	output = &StopFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopFlow API operation for AWS MediaConnect.
//
// Stops a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation StopFlow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow
func (c *MediaConnect) StopFlow(input *StopFlowInput) (*StopFlowOutput, error) {
	req, out := c.StopFlowRequest(input)
	return out, req.Send()
}

// StopFlowWithContext is the same as StopFlow with the addition of
// the ability to pass a context and additional request options.
//
// See StopFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) StopFlowWithContext(ctx aws.Context, input *StopFlowInput, opts ...request.Option) (*StopFlowOutput, error) {
	req, out := c.StopFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowEntitlement = "UpdateFlowEntitlement"

// UpdateFlowEntitlementRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowEntitlement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowEntitlement for more information on using the UpdateFlowEntitlement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFlowEntitlementRequest method.
//    req, resp := client.UpdateFlowEntitlementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement
func (c *MediaConnect) UpdateFlowEntitlementRequest(input *UpdateFlowEntitlementInput) (req *request.Request, output *UpdateFlowEntitlementOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowEntitlement,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements/{entitlementArn}",
	}

	if input == nil {
		input = &UpdateFlowEntitlementInput{}
	}

	output = &UpdateFlowEntitlementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowEntitlement API operation for AWS MediaConnect.
//
// You can change an entitlement's description, subscribers, and encryption.
// If you change the subscribers, the service will remove the outputs that are
// are used by the subscribers that are removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowEntitlement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement
func (c *MediaConnect) UpdateFlowEntitlement(input *UpdateFlowEntitlementInput) (*UpdateFlowEntitlementOutput, error) {
	req, out := c.UpdateFlowEntitlementRequest(input)
	return out, req.Send()
}

// UpdateFlowEntitlementWithContext is the same as UpdateFlowEntitlement with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowEntitlement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowEntitlementWithContext(ctx aws.Context, input *UpdateFlowEntitlementInput, opts ...request.Option) (*UpdateFlowEntitlementOutput, error) {
	req, out := c.UpdateFlowEntitlementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowOutput = "UpdateFlowOutput"

// UpdateFlowOutputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowOutput for more information on using the UpdateFlowOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFlowOutputRequest method.
//    req, resp := client.UpdateFlowOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput
func (c *MediaConnect) UpdateFlowOutputRequest(input *UpdateFlowOutputInput) (req *request.Request, output *UpdateFlowOutputOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowOutput,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/outputs/{outputArn}",
	}

	if input == nil {
		input = &UpdateFlowOutputInput{}
	}

	output = &UpdateFlowOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowOutput API operation for AWS MediaConnect.
//
// Updates an existing flow output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowOutput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput
func (c *MediaConnect) UpdateFlowOutput(input *UpdateFlowOutputInput) (*UpdateFlowOutputOutput, error) {
	req, out := c.UpdateFlowOutputRequest(input)
	return out, req.Send()
}

// UpdateFlowOutputWithContext is the same as UpdateFlowOutput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowOutputWithContext(ctx aws.Context, input *UpdateFlowOutputInput, opts ...request.Option) (*UpdateFlowOutputOutput, error) {
	req, out := c.UpdateFlowOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowSource = "UpdateFlowSource"

// UpdateFlowSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowSource for more information on using the UpdateFlowSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFlowSourceRequest method.
//    req, resp := client.UpdateFlowSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource
func (c *MediaConnect) UpdateFlowSourceRequest(input *UpdateFlowSourceInput) (req *request.Request, output *UpdateFlowSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/source/{sourceArn}",
	}

	if input == nil {
		input = &UpdateFlowSourceInput{}
	}

	output = &UpdateFlowSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowSource API operation for AWS MediaConnect.
//
// Updates the source of a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowSource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource
func (c *MediaConnect) UpdateFlowSource(input *UpdateFlowSourceInput) (*UpdateFlowSourceOutput, error) {
	req, out := c.UpdateFlowSourceRequest(input)
	return out, req.Send()
}

// UpdateFlowSourceWithContext is the same as UpdateFlowSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowSourceWithContext(ctx aws.Context, input *UpdateFlowSourceInput, opts ...request.Option) (*UpdateFlowSourceOutput, error) {
	req, out := c.UpdateFlowSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Adds outputs to an existing flow. You can create up to 20 outputs per flow.
type AddFlowOutputsInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// A list of outputs that you want to add.
	//
	// Outputs is a required field
	Outputs []*AddOutputRequest `locationName:"outputs" type:"list" required:"true"`
}

// String returns the string representation
func (s AddFlowOutputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFlowOutputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFlowOutputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddFlowOutputsInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.Outputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Outputs"))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowOutputsInput) SetFlowArn(v string) *AddFlowOutputsInput {
	s.FlowArn = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AddFlowOutputsInput) SetOutputs(v []*AddOutputRequest) *AddFlowOutputsInput {
	s.Outputs = v
	return s
}

// The result of a successful AddOutput request. The response includes the details
// of the newly added outputs.
type AddFlowOutputsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that these outputs were added to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The details of the newly added outputs.
	Outputs []*Output `locationName:"outputs" type:"list"`
}

// String returns the string representation
func (s AddFlowOutputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFlowOutputsOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowOutputsOutput) SetFlowArn(v string) *AddFlowOutputsOutput {
	s.FlowArn = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AddFlowOutputsOutput) SetOutputs(v []*Output) *AddFlowOutputsOutput {
	s.Outputs = v
	return s
}

// The output that you want to add to this flow.
type AddOutputRequest struct {
	_ struct{} `type:"structure"`

	// A description of the output. This description appears only on the AWS Elemental
	// MediaConnect console and will not be seen by the end user.
	Description *string `locationName:"description" type:"string"`

	// The IP address from which video will be sent to output destinations.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" type:"string" required:"true"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key).
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The maximum latency in milliseconds for Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The name of the output. This value must be unique within the current flow.
	Name *string `locationName:"name" type:"string"`

	// The port to use when content is distributed to this output.
	//
	// Port is a required field
	Port *int64 `locationName:"port" type:"integer" required:"true"`

	// The protocol to use for the output.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The smoothing latency in milliseconds for RTP and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`
}

// String returns the string representation
func (s AddOutputRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddOutputRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddOutputRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddOutputRequest"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *AddOutputRequest) SetDescription(v string) *AddOutputRequest {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *AddOutputRequest) SetDestination(v string) *AddOutputRequest {
	s.Destination = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *AddOutputRequest) SetEncryption(v *Encryption) *AddOutputRequest {
	s.Encryption = v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *AddOutputRequest) SetMaxLatency(v int64) *AddOutputRequest {
	s.MaxLatency = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddOutputRequest) SetName(v string) *AddOutputRequest {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AddOutputRequest) SetPort(v int64) *AddOutputRequest {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AddOutputRequest) SetProtocol(v string) *AddOutputRequest {
	s.Protocol = &v
	return s
}

// SetSmoothingLatency sets the SmoothingLatency field's value.
func (s *AddOutputRequest) SetSmoothingLatency(v int64) *AddOutputRequest {
	s.SmoothingLatency = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *AddOutputRequest) SetStreamId(v string) *AddOutputRequest {
	s.StreamId = &v
	return s
}

// Creates a new flow. The request must include one source. The request optionally
// can include outputs (up to 20) and one entitlement.
type CreateFlowInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that you want to create the flow in. These options
	// are limited to the Availability Zones within the current AWS Region.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The entitlements that you want to grant on a flow.
	Entitlements []*GrantEntitlementRequest `locationName:"entitlements" type:"list"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The outputs that you want to add to this flow.
	Outputs []*AddOutputRequest `locationName:"outputs" type:"list"`

	// The settings for the source of the flow.
	//
	// Source is a required field
	Source *SetSourceRequest `locationName:"source" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Entitlements != nil {
		for i, v := range s.Entitlements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entitlements", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateFlowInput) SetAvailabilityZone(v string) *CreateFlowInput {
	s.AvailabilityZone = &v
	return s
}

// SetEntitlements sets the Entitlements field's value.
func (s *CreateFlowInput) SetEntitlements(v []*GrantEntitlementRequest) *CreateFlowInput {
	s.Entitlements = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFlowInput) SetName(v string) *CreateFlowInput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateFlowInput) SetOutputs(v []*AddOutputRequest) *CreateFlowInput {
	s.Outputs = v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateFlowInput) SetSource(v *SetSourceRequest) *CreateFlowInput {
	s.Source = v
	return s
}

// The result of a successful CreateFlow request.
type CreateFlowOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow, including its source, outputs, and entitlements.
	Flow *Flow `locationName:"flow" type:"structure"`
}

// String returns the string representation
func (s CreateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowOutput) GoString() string {
	return s.String()
}

// SetFlow sets the Flow field's value.
func (s *CreateFlowOutput) SetFlow(v *Flow) *CreateFlowOutput {
	s.Flow = v
	return s
}

type DeleteFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *DeleteFlowInput) SetFlowArn(v string) *DeleteFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful DeleteFlow request.
type DeleteFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that was deleted.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The status of the flow when the DeleteFlow process begins.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s DeleteFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *DeleteFlowOutput) SetFlowArn(v string) *DeleteFlowOutput {
	s.FlowArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteFlowOutput) SetStatus(v string) *DeleteFlowOutput {
	s.Status = &v
	return s
}

type DescribeFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *DescribeFlowInput) SetFlowArn(v string) *DescribeFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful DescribeFlow request.
type DescribeFlowOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow, including its source, outputs, and entitlements.
	Flow *Flow `locationName:"flow" type:"structure"`

	// Messages that provide the state of the flow.
	Messages *Messages `locationName:"messages" type:"structure"`
}

// String returns the string representation
func (s DescribeFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowOutput) GoString() string {
	return s.String()
}

// SetFlow sets the Flow field's value.
func (s *DescribeFlowOutput) SetFlow(v *Flow) *DescribeFlowOutput {
	s.Flow = v
	return s
}

// SetMessages sets the Messages field's value.
func (s *DescribeFlowOutput) SetMessages(v *Messages) *DescribeFlowOutput {
	s.Messages = v
	return s
}

// Information about the encryption of the flow.
type Encryption struct {
	_ struct{} `type:"structure"`

	// The type of algorithm that is used for the encryption (such as aes128, aes192,
	// or aes256).
	//
	// Algorithm is a required field
	Algorithm *string `locationName:"algorithm" type:"string" required:"true" enum:"Algorithm"`

	// The type of key that is used for the encryption. If no keyType is provided,
	// the service will use the default setting (static-key).
	KeyType *string `locationName:"keyType" type:"string" enum:"KeyType"`

	// The ARN of the role that you created during setup (when you set up AWS Elemental
	// MediaConnect as a trusted entity).
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN that was assigned to the secret that you created in AWS Secrets Manager
	// to store the encryption key.
	//
	// SecretArn is a required field
	SecretArn *string `locationName:"secretArn" type:"string" required:"true"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Encryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Encryption"}
	if s.Algorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("Algorithm"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithm sets the Algorithm field's value.
func (s *Encryption) SetAlgorithm(v string) *Encryption {
	s.Algorithm = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *Encryption) SetKeyType(v string) *Encryption {
	s.KeyType = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Encryption) SetRoleArn(v string) *Encryption {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *Encryption) SetSecretArn(v string) *Encryption {
	s.SecretArn = &v
	return s
}

// The settings for a flow entitlement.
type Entitlement struct {
	_ struct{} `type:"structure"`

	// A description of the entitlement.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output that is associated
	// with this entitlement.
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The ARN of the entitlement.
	//
	// EntitlementArn is a required field
	EntitlementArn *string `locationName:"entitlementArn" type:"string" required:"true"`

	// The name of the entitlement.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flow using your
	// content as the source.
	//
	// Subscribers is a required field
	Subscribers []*string `locationName:"subscribers" type:"list" required:"true"`
}

// String returns the string representation
func (s Entitlement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Entitlement) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Entitlement) SetDescription(v string) *Entitlement {
	s.Description = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *Entitlement) SetEncryption(v *Encryption) *Entitlement {
	s.Encryption = v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *Entitlement) SetEntitlementArn(v string) *Entitlement {
	s.EntitlementArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Entitlement) SetName(v string) *Entitlement {
	s.Name = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *Entitlement) SetSubscribers(v []*string) *Entitlement {
	s.Subscribers = v
	return s
}

// The settings for a flow, including its source, outputs, and entitlements.
type Flow struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that you want to create the flow in. These options
	// are limited to the Availability Zones within the current AWS.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// A description of the flow. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The IP address from which video will be sent to output destinations.
	EgressIp *string `locationName:"egressIp" type:"string"`

	// The entitlements in this flow.
	//
	// Entitlements is a required field
	Entitlements []*Entitlement `locationName:"entitlements" type:"list" required:"true"`

	// The Amazon Resource Name (ARN), a unique identifier for any AWS resource,
	// of the flow.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The outputs in this flow.
	//
	// Outputs is a required field
	Outputs []*Output `locationName:"outputs" type:"list" required:"true"`

	// The settings for the source of the flow.
	//
	// Source is a required field
	Source *Source `locationName:"source" type:"structure" required:"true"`

	// The current status of the flow.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`
}

// String returns the string representation
func (s Flow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Flow) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Flow) SetAvailabilityZone(v string) *Flow {
	s.AvailabilityZone = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Flow) SetDescription(v string) *Flow {
	s.Description = &v
	return s
}

// SetEgressIp sets the EgressIp field's value.
func (s *Flow) SetEgressIp(v string) *Flow {
	s.EgressIp = &v
	return s
}

// SetEntitlements sets the Entitlements field's value.
func (s *Flow) SetEntitlements(v []*Entitlement) *Flow {
	s.Entitlements = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *Flow) SetFlowArn(v string) *Flow {
	s.FlowArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Flow) SetName(v string) *Flow {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Flow) SetOutputs(v []*Output) *Flow {
	s.Outputs = v
	return s
}

// SetSource sets the Source field's value.
func (s *Flow) SetSource(v *Source) *Flow {
	s.Source = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Flow) SetStatus(v string) *Flow {
	s.Status = &v
	return s
}

// The entitlements that you want to grant on a flow.
type GrantEntitlementRequest struct {
	_ struct{} `type:"structure"`

	// A description of the entitlement. This description appears only on the AWS
	// Elemental MediaConnect console and will not be seen by the subscriber or
	// end user.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output that is associated
	// with this entitlement.
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The name of the entitlement. This value must be unique within the current
	// flow.
	Name *string `locationName:"name" type:"string"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flows using your
	// content as the source.
	//
	// Subscribers is a required field
	Subscribers []*string `locationName:"subscribers" type:"list" required:"true"`
}

// String returns the string representation
func (s GrantEntitlementRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantEntitlementRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantEntitlementRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrantEntitlementRequest"}
	if s.Subscribers == nil {
		invalidParams.Add(request.NewErrParamRequired("Subscribers"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *GrantEntitlementRequest) SetDescription(v string) *GrantEntitlementRequest {
	s.Description = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *GrantEntitlementRequest) SetEncryption(v *Encryption) *GrantEntitlementRequest {
	s.Encryption = v
	return s
}

// SetName sets the Name field's value.
func (s *GrantEntitlementRequest) SetName(v string) *GrantEntitlementRequest {
	s.Name = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *GrantEntitlementRequest) SetSubscribers(v []*string) *GrantEntitlementRequest {
	s.Subscribers = v
	return s
}

// Grants an entitlement on a flow.
type GrantFlowEntitlementsInput struct {
	_ struct{} `type:"structure"`

	// The list of entitlements that you want to grant.
	//
	// Entitlements is a required field
	Entitlements []*GrantEntitlementRequest `locationName:"entitlements" type:"list" required:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GrantFlowEntitlementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantFlowEntitlementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantFlowEntitlementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrantFlowEntitlementsInput"}
	if s.Entitlements == nil {
		invalidParams.Add(request.NewErrParamRequired("Entitlements"))
	}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.Entitlements != nil {
		for i, v := range s.Entitlements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entitlements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntitlements sets the Entitlements field's value.
func (s *GrantFlowEntitlementsInput) SetEntitlements(v []*GrantEntitlementRequest) *GrantFlowEntitlementsInput {
	s.Entitlements = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *GrantFlowEntitlementsInput) SetFlowArn(v string) *GrantFlowEntitlementsInput {
	s.FlowArn = &v
	return s
}

// The entitlements that were just granted.
type GrantFlowEntitlementsOutput struct {
	_ struct{} `type:"structure"`

	// The entitlements that were just granted.
	Entitlements []*Entitlement `locationName:"entitlements" type:"list"`

	// The ARN of the flow that these entitlements were granted to.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s GrantFlowEntitlementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantFlowEntitlementsOutput) GoString() string {
	return s.String()
}

// SetEntitlements sets the Entitlements field's value.
func (s *GrantFlowEntitlementsOutput) SetEntitlements(v []*Entitlement) *GrantFlowEntitlementsOutput {
	s.Entitlements = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *GrantFlowEntitlementsOutput) SetFlowArn(v string) *GrantFlowEntitlementsOutput {
	s.FlowArn = &v
	return s
}

type ListEntitlementsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEntitlementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitlementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitlementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitlementsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitlementsInput) SetMaxResults(v int64) *ListEntitlementsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitlementsInput) SetNextToken(v string) *ListEntitlementsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListEntitlements request. The response includes
// the ARN of each entitlement, the name of the associated flow, and the NextToken
// to use in a subsequent ListEntitlements request.
type ListEntitlementsOutput struct {
	_ struct{} `type:"structure"`

	// A list of entitlements that have been granted to you from other AWS accounts.
	Entitlements []*ListedEntitlement `locationName:"entitlements" type:"list"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListEntitlements request with MaxResults set at 5.
	// The service returns the first batch of results (up to 5) and a NextToken
	// value. To see the next batch of results, you can submit the ListEntitlements
	// request a second time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEntitlementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitlementsOutput) GoString() string {
	return s.String()
}

// SetEntitlements sets the Entitlements field's value.
func (s *ListEntitlementsOutput) SetEntitlements(v []*ListedEntitlement) *ListEntitlementsOutput {
	s.Entitlements = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitlementsOutput) SetNextToken(v string) *ListEntitlementsOutput {
	s.NextToken = &v
	return s
}

type ListFlowsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFlowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlowsInput) SetMaxResults(v int64) *ListFlowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsInput) SetNextToken(v string) *ListFlowsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListFlows request. The response includes flow
// summaries and the NextToken to use in a subsequent ListFlows request.
type ListFlowsOutput struct {
	_ struct{} `type:"structure"`

	// A list of flow summaries.
	Flows []*ListedFlow `locationName:"flows" type:"list"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListFlows request with MaxResults set at 5. The service
	// returns the first batch of results (up to 5) and a NextToken value. To see
	// the next batch of results, you can submit the ListFlows request a second
	// time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFlowsOutput) GoString() string {
	return s.String()
}

// SetFlows sets the Flows field's value.
func (s *ListFlowsOutput) SetFlows(v []*ListedFlow) *ListFlowsOutput {
	s.Flows = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsOutput) SetNextToken(v string) *ListFlowsOutput {
	s.NextToken = &v
	return s
}

// An entitlement that has been granted to you from other AWS accounts.
type ListedEntitlement struct {
	_ struct{} `type:"structure"`

	// The ARN of the entitlement.
	//
	// EntitlementArn is a required field
	EntitlementArn *string `locationName:"entitlementArn" type:"string" required:"true"`

	// The name of the entitlement.
	//
	// EntitlementName is a required field
	EntitlementName *string `locationName:"entitlementName" type:"string" required:"true"`
}

// String returns the string representation
func (s ListedEntitlement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListedEntitlement) GoString() string {
	return s.String()
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *ListedEntitlement) SetEntitlementArn(v string) *ListedEntitlement {
	s.EntitlementArn = &v
	return s
}

// SetEntitlementName sets the EntitlementName field's value.
func (s *ListedEntitlement) SetEntitlementName(v string) *ListedEntitlement {
	s.EntitlementName = &v
	return s
}

// Provides a summary of a flow, including its ARN, Availability Zone, and source
// type.
type ListedFlow struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that the flow was created in.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// A description of the flow.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The ARN of the flow.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of source. This value is either owned (originated somewhere other
	// than an AWS Elemental MediaConnect flow owned by another AWS account) or
	// entitled (originated at an AWS Elemental MediaConnect flow owned by another
	// AWS account).
	//
	// SourceType is a required field
	SourceType *string `locationName:"sourceType" type:"string" required:"true" enum:"SourceType"`

	// The current status of the flow.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`
}

// String returns the string representation
func (s ListedFlow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListedFlow) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ListedFlow) SetAvailabilityZone(v string) *ListedFlow {
	s.AvailabilityZone = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListedFlow) SetDescription(v string) *ListedFlow {
	s.Description = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *ListedFlow) SetFlowArn(v string) *ListedFlow {
	s.FlowArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListedFlow) SetName(v string) *ListedFlow {
	s.Name = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ListedFlow) SetSourceType(v string) *ListedFlow {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListedFlow) SetStatus(v string) *ListedFlow {
	s.Status = &v
	return s
}

// Messages that provide the state of the flow.
type Messages struct {
	_ struct{} `type:"structure"`

	// A list of errors that might have been generated from processes on this flow.
	//
	// Errors is a required field
	Errors []*string `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation
func (s Messages) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Messages) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *Messages) SetErrors(v []*string) *Messages {
	s.Errors = v
	return s
}

// The settings for an output.
type Output struct {
	_ struct{} `type:"structure"`

	// A description of the output.
	Description *string `locationName:"description" type:"string"`

	// The address where you want to send the output.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key).
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The ARN of the entitlement on the originator''s flow. This value is relevant
	// only on entitled flows.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant
	// only for outputs that were added by creating a MediaLive input.
	MediaLiveInputArn *string `locationName:"mediaLiveInputArn" type:"string"`

	// The name of the output. This value must be unique within the current flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the output.
	//
	// OutputArn is a required field
	OutputArn *string `locationName:"outputArn" type:"string" required:"true"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// Attributes related to the transport stream that are used in the output.
	Transport *Transport `locationName:"transport" type:"structure"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Output) SetDescription(v string) *Output {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *Output) SetDestination(v string) *Output {
	s.Destination = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *Output) SetEncryption(v *Encryption) *Output {
	s.Encryption = v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *Output) SetEntitlementArn(v string) *Output {
	s.EntitlementArn = &v
	return s
}

// SetMediaLiveInputArn sets the MediaLiveInputArn field's value.
func (s *Output) SetMediaLiveInputArn(v string) *Output {
	s.MediaLiveInputArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Output) SetName(v string) *Output {
	s.Name = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *Output) SetOutputArn(v string) *Output {
	s.OutputArn = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Output) SetPort(v int64) *Output {
	s.Port = &v
	return s
}

// SetTransport sets the Transport field's value.
func (s *Output) SetTransport(v *Transport) *Output {
	s.Transport = v
	return s
}

type RemoveFlowOutputInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// OutputArn is a required field
	OutputArn *string `location:"uri" locationName:"outputArn" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveFlowOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFlowOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFlowOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveFlowOutputInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.OutputArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowOutputInput) SetFlowArn(v string) *RemoveFlowOutputInput {
	s.FlowArn = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *RemoveFlowOutputInput) SetOutputArn(v string) *RemoveFlowOutputInput {
	s.OutputArn = &v
	return s
}

// The result of a successful RemoveFlowOutput request including the flow ARN
// and the output ARN that was removed.
type RemoveFlowOutputOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the output you removed.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The ARN of the output that was removed.
	OutputArn *string `locationName:"outputArn" type:"string"`
}

// String returns the string representation
func (s RemoveFlowOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFlowOutputOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowOutputOutput) SetFlowArn(v string) *RemoveFlowOutputOutput {
	s.FlowArn = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *RemoveFlowOutputOutput) SetOutputArn(v string) *RemoveFlowOutputOutput {
	s.OutputArn = &v
	return s
}

type RevokeFlowEntitlementInput struct {
	_ struct{} `type:"structure"`

	// EntitlementArn is a required field
	EntitlementArn *string `location:"uri" locationName:"entitlementArn" type:"string" required:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeFlowEntitlementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeFlowEntitlementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeFlowEntitlementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeFlowEntitlementInput"}
	if s.EntitlementArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntitlementArn"))
	}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *RevokeFlowEntitlementInput) SetEntitlementArn(v string) *RevokeFlowEntitlementInput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *RevokeFlowEntitlementInput) SetFlowArn(v string) *RevokeFlowEntitlementInput {
	s.FlowArn = &v
	return s
}

// The result of a successful RevokeFlowEntitlement request. The response includes
// the ARN of the flow that was updated and the ARN of the entitlement that
// was revoked.
type RevokeFlowEntitlementOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the entitlement that was revoked.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The ARN of the flow that the entitlement was revoked from.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s RevokeFlowEntitlementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeFlowEntitlementOutput) GoString() string {
	return s.String()
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *RevokeFlowEntitlementOutput) SetEntitlementArn(v string) *RevokeFlowEntitlementOutput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *RevokeFlowEntitlementOutput) SetFlowArn(v string) *RevokeFlowEntitlementOutput {
	s.FlowArn = &v
	return s
}

// The settings for the source of the flow.
type SetSourceRequest struct {
	_ struct{} `type:"structure"`

	// The type of encryption that is used on the content ingested from this source.
	Decryption *Encryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to this flow. The
	// entitlement is set by the flow originator, and the ARN is generated as part
	// of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The smoothing max bitrate for RTP and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds for Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The name of the source.
	Name *string `locationName:"name" type:"string"`

	// The protocol that is used by the source.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation
func (s SetSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSourceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSourceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetSourceRequest"}
	if s.Decryption != nil {
		if err := s.Decryption.Validate(); err != nil {
			invalidParams.AddNested("Decryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecryption sets the Decryption field's value.
func (s *SetSourceRequest) SetDecryption(v *Encryption) *SetSourceRequest {
	s.Decryption = v
	return s
}

// SetDescription sets the Description field's value.
func (s *SetSourceRequest) SetDescription(v string) *SetSourceRequest {
	s.Description = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *SetSourceRequest) SetEntitlementArn(v string) *SetSourceRequest {
	s.EntitlementArn = &v
	return s
}

// SetIngestPort sets the IngestPort field's value.
func (s *SetSourceRequest) SetIngestPort(v int64) *SetSourceRequest {
	s.IngestPort = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *SetSourceRequest) SetMaxBitrate(v int64) *SetSourceRequest {
	s.MaxBitrate = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *SetSourceRequest) SetMaxLatency(v int64) *SetSourceRequest {
	s.MaxLatency = &v
	return s
}

// SetName sets the Name field's value.
func (s *SetSourceRequest) SetName(v string) *SetSourceRequest {
	s.Name = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *SetSourceRequest) SetProtocol(v string) *SetSourceRequest {
	s.Protocol = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *SetSourceRequest) SetStreamId(v string) *SetSourceRequest {
	s.StreamId = &v
	return s
}

// SetWhitelistCidr sets the WhitelistCidr field's value.
func (s *SetSourceRequest) SetWhitelistCidr(v string) *SetSourceRequest {
	s.WhitelistCidr = &v
	return s
}

// The settings for the source of the flow.
type Source struct {
	_ struct{} `type:"structure"`

	// The type of encryption that is used on the content ingested from this source.
	Decryption *Encryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to content that comes
	// from another AWS account. The entitlement is set by the content originator
	// and the ARN is generated as part of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The IP address that the flow will be listening on for incoming content.
	IngestIp *string `locationName:"ingestIp" type:"string"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The name of the source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the source.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" type:"string" required:"true"`

	// Attributes related to the transport stream that are used in the source.
	Transport *Transport `locationName:"transport" type:"structure"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Source) GoString() string {
	return s.String()
}

// SetDecryption sets the Decryption field's value.
func (s *Source) SetDecryption(v *Encryption) *Source {
	s.Decryption = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Source) SetDescription(v string) *Source {
	s.Description = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *Source) SetEntitlementArn(v string) *Source {
	s.EntitlementArn = &v
	return s
}

// SetIngestIp sets the IngestIp field's value.
func (s *Source) SetIngestIp(v string) *Source {
	s.IngestIp = &v
	return s
}

// SetIngestPort sets the IngestPort field's value.
func (s *Source) SetIngestPort(v int64) *Source {
	s.IngestPort = &v
	return s
}

// SetName sets the Name field's value.
func (s *Source) SetName(v string) *Source {
	s.Name = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *Source) SetSourceArn(v string) *Source {
	s.SourceArn = &v
	return s
}

// SetTransport sets the Transport field's value.
func (s *Source) SetTransport(v *Transport) *Source {
	s.Transport = v
	return s
}

// SetWhitelistCidr sets the WhitelistCidr field's value.
func (s *Source) SetWhitelistCidr(v string) *Source {
	s.WhitelistCidr = &v
	return s
}

type StartFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s StartFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *StartFlowInput) SetFlowArn(v string) *StartFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful StartFlow request.
type StartFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you started.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The status of the flow when the StartFlow process begins.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s StartFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *StartFlowOutput) SetFlowArn(v string) *StartFlowOutput {
	s.FlowArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartFlowOutput) SetStatus(v string) *StartFlowOutput {
	s.Status = &v
	return s
}

type StopFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s StopFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *StopFlowInput) SetFlowArn(v string) *StopFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful StopFlow request.
type StopFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you stopped.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The status of the flow when the StopFlow process begins.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s StopFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *StopFlowOutput) SetFlowArn(v string) *StopFlowOutput {
	s.FlowArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StopFlowOutput) SetStatus(v string) *StopFlowOutput {
	s.Status = &v
	return s
}

// Attributes related to the transport stream that are used in a source or output.
type Transport struct {
	_ struct{} `type:"structure"`

	// The smoothing max bitrate for RTP and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds for Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The protocol that is used by the source or output.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The smoothing latency in milliseconds for RTP and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`
}

// String returns the string representation
func (s Transport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transport) GoString() string {
	return s.String()
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *Transport) SetMaxBitrate(v int64) *Transport {
	s.MaxBitrate = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *Transport) SetMaxLatency(v int64) *Transport {
	s.MaxLatency = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Transport) SetProtocol(v string) *Transport {
	s.Protocol = &v
	return s
}

// SetSmoothingLatency sets the SmoothingLatency field's value.
func (s *Transport) SetSmoothingLatency(v int64) *Transport {
	s.SmoothingLatency = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *Transport) SetStreamId(v string) *Transport {
	s.StreamId = &v
	return s
}

// Information about the encryption of the flow.
type UpdateEncryption struct {
	_ struct{} `type:"structure"`

	// The type of algorithm that is used for the encryption (such as aes128, aes192,
	// or aes256).
	Algorithm *string `locationName:"algorithm" type:"string" enum:"Algorithm"`

	// The type of key that is used for the encryption. If no keyType is provided,
	// the service will use the default setting (static-key).
	KeyType *string `locationName:"keyType" type:"string" enum:"KeyType"`

	// The ARN of the role that you created during setup (when you set up AWS Elemental
	// MediaConnect as a trusted entity).
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The ARN that was assigned to the secret that you created in AWS Secrets Manager
	// to store the encryption key.
	SecretArn *string `locationName:"secretArn" type:"string"`
}

// String returns the string representation
func (s UpdateEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEncryption) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *UpdateEncryption) SetAlgorithm(v string) *UpdateEncryption {
	s.Algorithm = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *UpdateEncryption) SetKeyType(v string) *UpdateEncryption {
	s.KeyType = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateEncryption) SetRoleArn(v string) *UpdateEncryption {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *UpdateEncryption) SetSecretArn(v string) *UpdateEncryption {
	s.SecretArn = &v
	return s
}

// The updates that you want to make to a specific entitlement.
type UpdateFlowEntitlementInput struct {
	_ struct{} `type:"structure"`

	// A description of the entitlement. This description appears only on the AWS
	// Elemental MediaConnect console and will not be seen by the subscriber or
	// end user.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output associated with this
	// entitlement.
	Encryption *UpdateEncryption `locationName:"encryption" type:"structure"`

	// EntitlementArn is a required field
	EntitlementArn *string `location:"uri" locationName:"entitlementArn" type:"string" required:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flow using your
	// content as the source.
	Subscribers []*string `locationName:"subscribers" type:"list"`
}

// String returns the string representation
func (s UpdateFlowEntitlementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowEntitlementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowEntitlementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowEntitlementInput"}
	if s.EntitlementArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntitlementArn"))
	}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowEntitlementInput) SetDescription(v string) *UpdateFlowEntitlementInput {
	s.Description = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *UpdateFlowEntitlementInput) SetEncryption(v *UpdateEncryption) *UpdateFlowEntitlementInput {
	s.Encryption = v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *UpdateFlowEntitlementInput) SetEntitlementArn(v string) *UpdateFlowEntitlementInput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowEntitlementInput) SetFlowArn(v string) *UpdateFlowEntitlementInput {
	s.FlowArn = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *UpdateFlowEntitlementInput) SetSubscribers(v []*string) *UpdateFlowEntitlementInput {
	s.Subscribers = v
	return s
}

// The result of a successful UpdateFlowEntitlement request. The response includes
// the ARN of the flow that was updated and the updated entitlement configuration.
type UpdateFlowEntitlementOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow entitlement.
	Entitlement *Entitlement `locationName:"entitlement" type:"structure"`

	// The ARN of the flow that this entitlement was granted on.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s UpdateFlowEntitlementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowEntitlementOutput) GoString() string {
	return s.String()
}

// SetEntitlement sets the Entitlement field's value.
func (s *UpdateFlowEntitlementOutput) SetEntitlement(v *Entitlement) *UpdateFlowEntitlementOutput {
	s.Entitlement = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowEntitlementOutput) SetFlowArn(v string) *UpdateFlowEntitlementOutput {
	s.FlowArn = &v
	return s
}

// The updates that you want to make to an existing output of an existing flow.
type UpdateFlowOutputInput struct {
	_ struct{} `type:"structure"`

	// A description of the output. This description appears only on the AWS Elemental
	// MediaConnect console and will not be seen by the end user.
	Description *string `locationName:"description" type:"string"`

	// The IP address where you want to send the output.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key).
	Encryption *UpdateEncryption `locationName:"encryption" type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The maximum latency in milliseconds for Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// OutputArn is a required field
	OutputArn *string `location:"uri" locationName:"outputArn" type:"string" required:"true"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// The protocol to use for the output.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// The smoothing latency in milliseconds for RTP and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`
}

// String returns the string representation
func (s UpdateFlowOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowOutputInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.OutputArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowOutputInput) SetDescription(v string) *UpdateFlowOutputInput {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *UpdateFlowOutputInput) SetDestination(v string) *UpdateFlowOutputInput {
	s.Destination = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *UpdateFlowOutputInput) SetEncryption(v *UpdateEncryption) *UpdateFlowOutputInput {
	s.Encryption = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowOutputInput) SetFlowArn(v string) *UpdateFlowOutputInput {
	s.FlowArn = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *UpdateFlowOutputInput) SetMaxLatency(v int64) *UpdateFlowOutputInput {
	s.MaxLatency = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *UpdateFlowOutputInput) SetOutputArn(v string) *UpdateFlowOutputInput {
	s.OutputArn = &v
	return s
}

// SetPort sets the Port field's value.
func (s *UpdateFlowOutputInput) SetPort(v int64) *UpdateFlowOutputInput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateFlowOutputInput) SetProtocol(v string) *UpdateFlowOutputInput {
	s.Protocol = &v
	return s
}

// SetSmoothingLatency sets the SmoothingLatency field's value.
func (s *UpdateFlowOutputInput) SetSmoothingLatency(v int64) *UpdateFlowOutputInput {
	s.SmoothingLatency = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *UpdateFlowOutputInput) SetStreamId(v string) *UpdateFlowOutputInput {
	s.StreamId = &v
	return s
}

// The result of a successful UpdateFlowOutput request including the flow ARN
// and the updated output.
type UpdateFlowOutputOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the updated output.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The settings for an output.
	Output *Output `locationName:"output" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowOutputOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowOutputOutput) SetFlowArn(v string) *UpdateFlowOutputOutput {
	s.FlowArn = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *UpdateFlowOutputOutput) SetOutput(v *Output) *UpdateFlowOutputOutput {
	s.Output = v
	return s
}

// The settings for the updated source of the flow.
type UpdateFlowSourceInput struct {
	_ struct{} `type:"structure"`

	// The type of encryption used on the content ingested from this source.
	Decryption *UpdateEncryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to this flow. The
	// entitlement is set by the flow originator, and the ARN is generated as part
	// of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The smoothing max bitrate for RTP and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds for Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The protocol that is used by the source.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// SourceArn is a required field
	SourceArn *string `location:"uri" locationName:"sourceArn" type:"string" required:"true"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation
func (s UpdateFlowSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowSourceInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecryption sets the Decryption field's value.
func (s *UpdateFlowSourceInput) SetDecryption(v *UpdateEncryption) *UpdateFlowSourceInput {
	s.Decryption = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowSourceInput) SetDescription(v string) *UpdateFlowSourceInput {
	s.Description = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *UpdateFlowSourceInput) SetEntitlementArn(v string) *UpdateFlowSourceInput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowSourceInput) SetFlowArn(v string) *UpdateFlowSourceInput {
	s.FlowArn = &v
	return s
}

// SetIngestPort sets the IngestPort field's value.
func (s *UpdateFlowSourceInput) SetIngestPort(v int64) *UpdateFlowSourceInput {
	s.IngestPort = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *UpdateFlowSourceInput) SetMaxBitrate(v int64) *UpdateFlowSourceInput {
	s.MaxBitrate = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *UpdateFlowSourceInput) SetMaxLatency(v int64) *UpdateFlowSourceInput {
	s.MaxLatency = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateFlowSourceInput) SetProtocol(v string) *UpdateFlowSourceInput {
	s.Protocol = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *UpdateFlowSourceInput) SetSourceArn(v string) *UpdateFlowSourceInput {
	s.SourceArn = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *UpdateFlowSourceInput) SetStreamId(v string) *UpdateFlowSourceInput {
	s.StreamId = &v
	return s
}

// SetWhitelistCidr sets the WhitelistCidr field's value.
func (s *UpdateFlowSourceInput) SetWhitelistCidr(v string) *UpdateFlowSourceInput {
	s.WhitelistCidr = &v
	return s
}

// The result of a successful UpdateFlowSource request. The response includes
// the ARN of the flow that was updated and the updated source configuration.
type UpdateFlowSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you want to update.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The settings for the source of the flow.
	Source *Source `locationName:"source" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowSourceOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowSourceOutput) SetFlowArn(v string) *UpdateFlowSourceOutput {
	s.FlowArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UpdateFlowSourceOutput) SetSource(v *Source) *UpdateFlowSourceOutput {
	s.Source = v
	return s
}

const (
	// AlgorithmAes128 is a Algorithm enum value
	AlgorithmAes128 = "aes128"

	// AlgorithmAes192 is a Algorithm enum value
	AlgorithmAes192 = "aes192"

	// AlgorithmAes256 is a Algorithm enum value
	AlgorithmAes256 = "aes256"
)

const (
	// KeyTypeStaticKey is a KeyType enum value
	KeyTypeStaticKey = "static-key"
)

const (
	// ProtocolZixiPush is a Protocol enum value
	ProtocolZixiPush = "zixi-push"

	// ProtocolRtpFec is a Protocol enum value
	ProtocolRtpFec = "rtp-fec"

	// ProtocolRtp is a Protocol enum value
	ProtocolRtp = "rtp"
)

const (
	// SourceTypeOwned is a SourceType enum value
	SourceTypeOwned = "OWNED"

	// SourceTypeEntitled is a SourceType enum value
	SourceTypeEntitled = "ENTITLED"
)

const (
	// StatusStandby is a Status enum value
	StatusStandby = "STANDBY"

	// StatusActive is a Status enum value
	StatusActive = "ACTIVE"

	// StatusUpdating is a Status enum value
	StatusUpdating = "UPDATING"

	// StatusDeleting is a Status enum value
	StatusDeleting = "DELETING"

	// StatusStarting is a Status enum value
	StatusStarting = "STARTING"

	// StatusStopping is a Status enum value
	StatusStopping = "STOPPING"

	// StatusError is a Status enum value
	StatusError = "ERROR"
)
