package bootkube

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	openshiftServiceCertSignerNamespaceFileName = "09-openshift-service-cert-signer-namespace.yaml"
)

var _ asset.WritableAsset = (*OpenshiftServiceCertSignerNamespace)(nil)

// OpenshiftServiceCertSignerNamespace is the constant to represent the contents of 09-openshift-service-signer-namespace.yaml
type OpenshiftServiceCertSignerNamespace struct {
	fileName string
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *OpenshiftServiceCertSignerNamespace) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *OpenshiftServiceCertSignerNamespace) Name() string {
	return "OpenshiftServiceCertSignerNamespace"
}

// Generate generates the actual files by this asset
func (t *OpenshiftServiceCertSignerNamespace) Generate(parents asset.Parents) error {
	t.fileName = openshiftServiceCertSignerNamespaceFileName
	data, err := content.GetBootkubeTemplate(t.fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, t.fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *OpenshiftServiceCertSignerNamespace) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *OpenshiftServiceCertSignerNamespace) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, openshiftServiceCertSignerNamespaceFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
