// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	userv1 "github.com/openshift/api/user/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeIdentities implements IdentityInterface
type FakeIdentities struct {
	Fake *FakeUserV1
}

var identitiesResource = schema.GroupVersionResource{Group: "user.openshift.io", Version: "v1", Resource: "identities"}

var identitiesKind = schema.GroupVersionKind{Group: "user.openshift.io", Version: "v1", Kind: "Identity"}

// Get takes name of the identity, and returns the corresponding identity object, and an error if there is any.
func (c *FakeIdentities) Get(ctx context.Context, name string, options v1.GetOptions) (result *userv1.Identity, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(identitiesResource, name), &userv1.Identity{})
	if obj == nil {
		return nil, err
	}
	return obj.(*userv1.Identity), err
}

// List takes label and field selectors, and returns the list of Identities that match those selectors.
func (c *FakeIdentities) List(ctx context.Context, opts v1.ListOptions) (result *userv1.IdentityList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(identitiesResource, identitiesKind, opts), &userv1.IdentityList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &userv1.IdentityList{ListMeta: obj.(*userv1.IdentityList).ListMeta}
	for _, item := range obj.(*userv1.IdentityList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested identities.
func (c *FakeIdentities) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(identitiesResource, opts))
}

// Create takes the representation of a identity and creates it.  Returns the server's representation of the identity, and an error, if there is any.
func (c *FakeIdentities) Create(ctx context.Context, identity *userv1.Identity, opts v1.CreateOptions) (result *userv1.Identity, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(identitiesResource, identity), &userv1.Identity{})
	if obj == nil {
		return nil, err
	}
	return obj.(*userv1.Identity), err
}

// Update takes the representation of a identity and updates it. Returns the server's representation of the identity, and an error, if there is any.
func (c *FakeIdentities) Update(ctx context.Context, identity *userv1.Identity, opts v1.UpdateOptions) (result *userv1.Identity, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(identitiesResource, identity), &userv1.Identity{})
	if obj == nil {
		return nil, err
	}
	return obj.(*userv1.Identity), err
}

// Delete takes name of the identity and deletes it. Returns an error if one occurs.
func (c *FakeIdentities) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(identitiesResource, name), &userv1.Identity{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeIdentities) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(identitiesResource, listOpts)

	_, err := c.Fake.Invokes(action, &userv1.IdentityList{})
	return err
}

// Patch applies the patch and returns the patched identity.
func (c *FakeIdentities) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *userv1.Identity, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(identitiesResource, name, pt, data, subresources...), &userv1.Identity{})
	if obj == nil {
		return nil, err
	}
	return obj.(*userv1.Identity), err
}
