// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/openshift/aws-ebs-csi-driver-operator/pkg/apis/operator/v1alpha1"
	scheme "github.com/openshift/aws-ebs-csi-driver-operator/pkg/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AWSEBSDriversGetter has a method to return a AWSEBSDriverInterface.
// A group's client should implement this interface.
type AWSEBSDriversGetter interface {
	AWSEBSDrivers() AWSEBSDriverInterface
}

// AWSEBSDriverInterface has methods to work with AWSEBSDriver resources.
type AWSEBSDriverInterface interface {
	Create(ctx context.Context, aWSEBSDriver *v1alpha1.AWSEBSDriver, opts v1.CreateOptions) (*v1alpha1.AWSEBSDriver, error)
	Update(ctx context.Context, aWSEBSDriver *v1alpha1.AWSEBSDriver, opts v1.UpdateOptions) (*v1alpha1.AWSEBSDriver, error)
	UpdateStatus(ctx context.Context, aWSEBSDriver *v1alpha1.AWSEBSDriver, opts v1.UpdateOptions) (*v1alpha1.AWSEBSDriver, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.AWSEBSDriver, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.AWSEBSDriverList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AWSEBSDriver, err error)
	AWSEBSDriverExpansion
}

// aWSEBSDrivers implements AWSEBSDriverInterface
type aWSEBSDrivers struct {
	client rest.Interface
}

// newAWSEBSDrivers returns a AWSEBSDrivers
func newAWSEBSDrivers(c *CsiV1alpha1Client) *aWSEBSDrivers {
	return &aWSEBSDrivers{
		client: c.RESTClient(),
	}
}

// Get takes name of the aWSEBSDriver, and returns the corresponding aWSEBSDriver object, and an error if there is any.
func (c *aWSEBSDrivers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.AWSEBSDriver, err error) {
	result = &v1alpha1.AWSEBSDriver{}
	err = c.client.Get().
		Resource("awsebsdrivers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AWSEBSDrivers that match those selectors.
func (c *aWSEBSDrivers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.AWSEBSDriverList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.AWSEBSDriverList{}
	err = c.client.Get().
		Resource("awsebsdrivers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested aWSEBSDrivers.
func (c *aWSEBSDrivers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("awsebsdrivers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a aWSEBSDriver and creates it.  Returns the server's representation of the aWSEBSDriver, and an error, if there is any.
func (c *aWSEBSDrivers) Create(ctx context.Context, aWSEBSDriver *v1alpha1.AWSEBSDriver, opts v1.CreateOptions) (result *v1alpha1.AWSEBSDriver, err error) {
	result = &v1alpha1.AWSEBSDriver{}
	err = c.client.Post().
		Resource("awsebsdrivers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(aWSEBSDriver).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a aWSEBSDriver and updates it. Returns the server's representation of the aWSEBSDriver, and an error, if there is any.
func (c *aWSEBSDrivers) Update(ctx context.Context, aWSEBSDriver *v1alpha1.AWSEBSDriver, opts v1.UpdateOptions) (result *v1alpha1.AWSEBSDriver, err error) {
	result = &v1alpha1.AWSEBSDriver{}
	err = c.client.Put().
		Resource("awsebsdrivers").
		Name(aWSEBSDriver.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(aWSEBSDriver).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *aWSEBSDrivers) UpdateStatus(ctx context.Context, aWSEBSDriver *v1alpha1.AWSEBSDriver, opts v1.UpdateOptions) (result *v1alpha1.AWSEBSDriver, err error) {
	result = &v1alpha1.AWSEBSDriver{}
	err = c.client.Put().
		Resource("awsebsdrivers").
		Name(aWSEBSDriver.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(aWSEBSDriver).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the aWSEBSDriver and deletes it. Returns an error if one occurs.
func (c *aWSEBSDrivers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("awsebsdrivers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *aWSEBSDrivers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("awsebsdrivers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched aWSEBSDriver.
func (c *aWSEBSDrivers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AWSEBSDriver, err error) {
	result = &v1alpha1.AWSEBSDriver{}
	err = c.client.Patch(pt).
		Resource("awsebsdrivers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
