/*
Copyright Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/operator-framework/operator-lifecycle-manager/pkg/package-server/apis/operators/v1"
	scheme "github.com/operator-framework/operator-lifecycle-manager/pkg/package-server/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PackageManifestsGetter has a method to return a PackageManifestInterface.
// A group's client should implement this interface.
type PackageManifestsGetter interface {
	PackageManifests(namespace string) PackageManifestInterface
}

// PackageManifestInterface has methods to work with PackageManifest resources.
type PackageManifestInterface interface {
	Create(ctx context.Context, packageManifest *v1.PackageManifest, opts metav1.CreateOptions) (*v1.PackageManifest, error)
	Update(ctx context.Context, packageManifest *v1.PackageManifest, opts metav1.UpdateOptions) (*v1.PackageManifest, error)
	UpdateStatus(ctx context.Context, packageManifest *v1.PackageManifest, opts metav1.UpdateOptions) (*v1.PackageManifest, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.PackageManifest, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.PackageManifestList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.PackageManifest, err error)
	PackageManifestExpansion
}

// packageManifests implements PackageManifestInterface
type packageManifests struct {
	client rest.Interface
	ns     string
}

// newPackageManifests returns a PackageManifests
func newPackageManifests(c *OperatorsV1Client, namespace string) *packageManifests {
	return &packageManifests{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the packageManifest, and returns the corresponding packageManifest object, and an error if there is any.
func (c *packageManifests) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.PackageManifest, err error) {
	result = &v1.PackageManifest{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("packagemanifests").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PackageManifests that match those selectors.
func (c *packageManifests) List(ctx context.Context, opts metav1.ListOptions) (result *v1.PackageManifestList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.PackageManifestList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("packagemanifests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested packageManifests.
func (c *packageManifests) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("packagemanifests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a packageManifest and creates it.  Returns the server's representation of the packageManifest, and an error, if there is any.
func (c *packageManifests) Create(ctx context.Context, packageManifest *v1.PackageManifest, opts metav1.CreateOptions) (result *v1.PackageManifest, err error) {
	result = &v1.PackageManifest{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("packagemanifests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(packageManifest).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a packageManifest and updates it. Returns the server's representation of the packageManifest, and an error, if there is any.
func (c *packageManifests) Update(ctx context.Context, packageManifest *v1.PackageManifest, opts metav1.UpdateOptions) (result *v1.PackageManifest, err error) {
	result = &v1.PackageManifest{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("packagemanifests").
		Name(packageManifest.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(packageManifest).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *packageManifests) UpdateStatus(ctx context.Context, packageManifest *v1.PackageManifest, opts metav1.UpdateOptions) (result *v1.PackageManifest, err error) {
	result = &v1.PackageManifest{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("packagemanifests").
		Name(packageManifest.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(packageManifest).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the packageManifest and deletes it. Returns an error if one occurs.
func (c *packageManifests) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("packagemanifests").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *packageManifests) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("packagemanifests").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched packageManifest.
func (c *packageManifests) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.PackageManifest, err error) {
	result = &v1.PackageManifest{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("packagemanifests").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
