/*
Copyright 2019 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package internalversion

import (
	operators "github.com/operator-framework/operator-lifecycle-manager/pkg/package-server/apis/operators"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PackageManifestLister helps list PackageManifests.
type PackageManifestLister interface {
	// List lists all PackageManifests in the indexer.
	List(selector labels.Selector) (ret []*operators.PackageManifest, err error)
	// PackageManifests returns an object that can list and get PackageManifests.
	PackageManifests(namespace string) PackageManifestNamespaceLister
	PackageManifestListerExpansion
}

// packageManifestLister implements the PackageManifestLister interface.
type packageManifestLister struct {
	indexer cache.Indexer
}

// NewPackageManifestLister returns a new PackageManifestLister.
func NewPackageManifestLister(indexer cache.Indexer) PackageManifestLister {
	return &packageManifestLister{indexer: indexer}
}

// List lists all PackageManifests in the indexer.
func (s *packageManifestLister) List(selector labels.Selector) (ret []*operators.PackageManifest, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*operators.PackageManifest))
	})
	return ret, err
}

// PackageManifests returns an object that can list and get PackageManifests.
func (s *packageManifestLister) PackageManifests(namespace string) PackageManifestNamespaceLister {
	return packageManifestNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PackageManifestNamespaceLister helps list and get PackageManifests.
type PackageManifestNamespaceLister interface {
	// List lists all PackageManifests in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*operators.PackageManifest, err error)
	// Get retrieves the PackageManifest from the indexer for a given namespace and name.
	Get(name string) (*operators.PackageManifest, error)
	PackageManifestNamespaceListerExpansion
}

// packageManifestNamespaceLister implements the PackageManifestNamespaceLister
// interface.
type packageManifestNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PackageManifests in the indexer for a given namespace.
func (s packageManifestNamespaceLister) List(selector labels.Selector) (ret []*operators.PackageManifest, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*operators.PackageManifest))
	})
	return ret, err
}

// Get retrieves the PackageManifest from the indexer for a given namespace and name.
func (s packageManifestNamespaceLister) Get(name string) (*operators.PackageManifest, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(operators.Resource("packagemanifest"), name)
	}
	return obj.(*operators.PackageManifest), nil
}
